﻿Namespace AI
    Public Class AIBoard
        Inherits Board

        ''' <summary>
        ''' 開放度を保持
        ''' </summary>
        ''' <remarks></remarks>
        Private _liberty((SIZE_X + 2) * (SIZE_Y + 2) - 1) As Integer
        Private Property Liberty(ByVal x As Integer, ByVal y As Integer) As Integer
            Get
                Debug.Assert(0 <= x AndAlso x <= SIZE_X + 1)
                Debug.Assert(0 <= y AndAlso y <= SIZE_Y + 1)
                Return _liberty(y * (SIZE_X + 2) + x)
            End Get
            Set(ByVal value As Integer)
                Debug.Assert(0 <= x AndAlso x <= SIZE_X + 1)
                Debug.Assert(0 <= y AndAlso y <= SIZE_Y + 1)
                _liberty(y * (SIZE_X + 2) + x) = value
            End Set
        End Property


        Public Sub New()
            MyBase.New()
            InitLiberty()
        End Sub

        Public Sub New(ByVal source As Board)
            MyBase.New(source)
            InitLiberty()
        End Sub


        Private Sub InitLiberty()

            'すべてのマスで全方向打てると仮定
            For x As Integer = 2 To SIZE_X - 1
                For y As Integer = 2 To SIZE_Y - 1
                    Liberty(x, y) = 8
                Next
            Next

            '辺の開放度を設定
            For x As Integer = 2 To SIZE_X - 1
                Liberty(x, 1) = 5
                Liberty(x, SIZE_Y) = 5
            Next
            For y As Integer = 2 To SIZE_Y - 1
                Liberty(1, y) = 5
                Liberty(SIZE_Y, y) = 5
            Next

            '角の開放度を設定
            Liberty(1, 1) = 3
            Liberty(1, SIZE_Y) = 3
            Liberty(SIZE_X, 1) = 3
            Liberty(SIZE_X, SIZE_Y) = 3

            '初期配置してある周りの開放度を再計算
            For x As Integer = 1 To SIZE_X
                For y As Integer = 1 To SIZE_Y
                    If Cells(x, y) <> DiscColor.EMPTY Then
                        IncreaseLiberty(New Point(x, y), -1)
                    End If
                Next
            Next

        End Sub

        Public Overrides Sub Move(ByVal point As Point)
            MyBase.Move(point)
            IncreaseLiberty(point, -1)
        End Sub

        Public Overrides Sub Undo()
            Dim log As ReverseLog = _updateLogs.Last
            If Not log.IsPass Then
                IncreaseLiberty(log.PutDisc, 1)
            End If
            MyBase.Undo()
        End Sub

        ''' <summary>
        ''' 置かれた位置の周りの開放度を指定した値ほど増加させる。
        ''' </summary>
        ''' <param name="point"></param>
        ''' <remarks></remarks>
        Private Sub IncreaseLiberty(ByVal point As Point, ByVal val As Integer)
            Debug.Assert(1 <= point.X AndAlso point.X <= SIZE_X)
            Debug.Assert(1 <= point.Y AndAlso point.Y <= SIZE_Y)
            Liberty(point.X - 1, point.Y - 1) += val
            Liberty(point.X - 1, point.Y) += val
            Liberty(point.X - 1, point.Y + 1) += val
            Liberty(point.X, point.Y - 1) += val
            Liberty(point.X, point.Y + 1) += val
            Liberty(point.X + 1, point.Y - 1) += val
            Liberty(point.X + 1, point.Y) += val
            Liberty(point.X + 1, point.Y + 1) += val
        End Sub


        Public Function GetLiberty(ByVal point As Point) As Integer
            Debug.Assert(1 <= point.X AndAlso point.X <= SIZE_X)
            Debug.Assert(1 <= point.Y AndAlso point.Y <= SIZE_Y)
            Return Liberty(point.X, point.Y)
        End Function

    End Class
End Namespace

