// luasample1.cpp : R\[ AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"

#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "time.h"
#include <lua.hpp>
#include "LuaHelper.h"


LuaHelper g_luah;

void WaitInputOnError(const char* errormsg,const char* confirmmsg){
	printf(errormsg);
	printf("\n");
	printf(confirmmsg);
	getchar();
}

// [h֐
// G[ȂȂ܂Ń[hJԂ
// ̓[h̃[h
void ReloadLuaFiles(const char* arg =""){
	LuaFuncParam param;
	param.String(arg);
	LuaFuncParam result;
	while(true) {
		if (g_luah.DoFile("scripts/reload.lua", &result, 2, &param)) {
			if(result.GetBool(0)) {
				//XNvg[h
				break;
			}
			//XNvg[[hsireload.luaŃG[⑫ꍇj
			WaitInputOnError(result.GetString(1),"Reload OK?");
		}else {
			WaitInputOnError(g_luah.GetErr(),"Reload OK?");
		}
	}
}
	 
// Luat@Cs
bool DoLuaFile(const char* path) {
	std::string err;
	if (!g_luah.DoFile(path, NULL, 0, NULL)) {
		// G[Ԃ
		err = g_luah.GetErr();
		DebugPrintfLn("DoLuaFile: %s", err.c_str());
		return false;
	}
	return true;
}

// LuãG[擾
const char * GetLuaError() {
	return g_luah.GetErr();
}

int main(int argc, char* argv[])
{
 
	lua_State *L = lua_open();
	luaL_openlibs(L);

	g_luah.SetLua(L);

	ReloadLuaFiles("load");
	
	lua_close(L);

	return 0;
}

