#include "stdafx.h"
#include "Board.h"

#define countof(x) sizeof(x) / sizeof(x[0])

void Board::GenerateMoves()
{
	int cnt = 0;
	MoveSet& turnMoveSet = GetTurnMoveSet();
	for (int y = COL_MEM_SIZE; y < CELLS_COUNT - COL_MEM_SIZE; y += COL_MEM_SIZE) {
		for (int x = 1; x <= COL_SIZE; x++) {
			int pos = x + y;
			Move& move = turnMoveSet.data[cnt];
			move.drop_pos = pos;
			CompletionRevInfo(move);
			if (!move.isInvalid()) {
				cnt++;
			}
		}
	}
	turnMoveSet.count = cnt;
}

void Board::Do(Move *move)
{
	moves_log.push_back(*move);
	cells[move->drop_pos] = color_of_turn;
	for (int i = 0; i < move->rev_pos_count; i++) {
		cells[move->rev_pos[i]] = color_of_turn;
	}
	color_of_turn = -color_of_turn;
	//̎𐶐B
	turn_count++;
	GenerateMoves();
	//łƂ낪Ȃ΃pXB
	if (GetTurnMoveSet().isEmpty()) {
		color_of_turn = -color_of_turn;
		//łƂłȂ΃Q[I
		GenerateMoves();
		if (GetTurnMoveSet().isEmpty()) {
			//Q[I
		}
	}
}

void Board::Undo()
{
	//Ō̒ɒڂB
	Move &undoinfo = moves_log.back();
	//ЂԂ΂̐Fɖ߂B
	for (int i = 0; i < undoinfo.rev_pos_count; i++) {
		cells[undoinfo.rev_pos[i]] = -undoinfo.color;
	}
	//uꏊ΂菜
	cells[undoinfo.drop_pos] = EMPTY;
	//Ԃɖ߂B
	color_of_turn = undoinfo.color;
	//Ō̒B
	moves_log.pop_back();
	//萔炷B
	turn_count--;
}



void Board::CompletionRevInfo(Move & move)
{
	const int UP = -COL_MEM_SIZE;
	const int DOWN = COL_MEM_SIZE;
	const int LEFT = -1;
	const int RIGHT = 1;

	int directions[8] = {
		UP,
		DOWN,
		LEFT,
		RIGHT,
		UP + RIGHT,
		UP + LEFT,
		DOWN + RIGHT ,
		DOWN + LEFT };

	//}XłȂΑłĂȂB
	if (cells[move.drop_pos] != EMPTY) {
		return;
	}

	//݂̐Fݒ
	move.color = color_of_turn;

	//8΂܂Ă邩mF
	for (int i = 0; i < countof(directions); i++) {
		
		//݂̕ЂԂȂꍇ͌ɖ߂߂ɂЂԂ̂m肵
		//΂̐oĂB
		int pre_rev_pos_count = move.rev_pos_count;

		//܂΂ׂ̗̃}XɒڂB
		int pos = move.drop_pos;
		pos += directions[i];
		
		while (cells[pos] == -color_of_turn) {
			//΂̐F̐΂ĂΉɂЂԂʒuɒǉB
			move.AddRevpos(pos);
			//ׂ̐΂Ɉړ
			pos += directions[i];
			//ŌオF̐΂łȂ΋܂ĂȂB
			if (cells[pos] == WALL || cells[pos] == EMPTY) {
				//ɂЂԂ΂ɒǉ̂LZB
				move.rev_pos_count = pre_rev_pos_count;
			}
		}
	}
}

Board::Board()
{
	const int x_of_left = 0;
	const int x_of_right = COL_MEM_SIZE - 1;
	const int y_of_top = 0;
	const int y_of_bottom = (ROW_MEM_SIZE - 1) * COL_MEM_SIZE;

	//EƍǂɂB
	for (int y = 0; y < CELLS_COUNT; y += COL_MEM_SIZE) {
		cells[x_of_left + y] = WALL;
		cells[x_of_right + y] = WALL;
	}

	//ƉǂɂB
	for (int x = 1; x <= COL_SIZE; x++) {
		cells[x + y_of_top] = WALL;
		cells[x + y_of_bottom] = WALL;
	}


	//ȂɂĂȂԂɂB
	for (int y = COL_MEM_SIZE; y < CELLS_COUNT - COL_MEM_SIZE; y+= COL_MEM_SIZE) {
		for (int x = 1; x <= COL_SIZE; x++) {
			cells[x + y] = EMPTY;	
		}
	}

	//S̐΂zuB
	cells[position(4, 4)] = WHITE;
	cells[position(5, 5)] = WHITE;
	cells[position(4, 5)] = BLACK;
	cells[position(5, 4)] = BLACK;

	//ɂB
	turn_count = 0;
	color_of_turn = BLACK;
	
	//𐶐
	GenerateMoves();
}


Board::~Board()
{
}
