// ConsoleApplication1.cpp : R\[ AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"
#include "../Reversi2/Board.h"
#include "../Reversi2/Move.h"

#include <iostream>
using namespace std;

void output(Board &board) {
	cout << " PQRSTUVWX\n";
	for (int y = 1; y <= ROW_SIZE; y++) {
		cout << y;
		for (int x = 1; x <= COL_SIZE; x++) {
			int c = board.Cells(x, y);
			if (c == BLACK) {
				cout << "Z";
			}
			else if (c == WHITE) {
				cout << "";
			}
			else if (c == EMPTY) {	
				cout << "E";
			}
			else if (c == WALL) {
				cout << "";
			}
			else {
				cout << "~";
			}
		}
		cout << endl;
	}
}
Move& ComputeAI(Board &b) {
	return b.GetTurnMoveSet().data[0];
}
void input(Move &move) {
	int x, y;
	cin >> x >> y;
	move.drop_pos = x + y * COL_MEM_SIZE;
}
int main()
{
	Board b;
	output(b);
	while (1) {
		Move move;
		if (b.GetColor() == WHITE) {
			move = ComputeAI(b);
		}
		else {
			input(move);
			b.CompletionRevInfo(move);
			if (move.isInvalid()) {
				continue;
			}
		}
		b.Do(&move);
		output(b);
	}
    return 0;
}

