
// ReversiView.cpp : CReversiView NX̎
//

#include "stdafx.h"
// SHARED_HANDLERS ́Avr[AkŁAьtB^[ nh[Ă ATL vWFNgŒ`łA
// ̃vWFNgƂ̃hLg R[h̋L\ɂ܂B
#ifndef SHARED_HANDLERS
#include "Reversi.h"
#endif

#include "ReversiDoc.h"
#include "ReversiView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CReversiView

IMPLEMENT_DYNCREATE(CReversiView, CView)

BEGIN_MESSAGE_MAP(CReversiView, CView)
	// WR}h
	ON_COMMAND(ID_FILE_PRINT, &CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, &CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, &CReversiView::OnFilePrintPreview)
	ON_WM_CONTEXTMENU()
	ON_WM_RBUTTONUP()
END_MESSAGE_MAP()

// CReversiView RXgNV/fXgNV

CReversiView::CReversiView()
{

	InitBoard();
}

CReversiView::~CReversiView()
{
}

BOOL CReversiView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ̈ʒu CREATESTRUCT cs C Window NX܂̓X^C
	//  CĂB

	return CView::PreCreateWindow(cs);
}

// CReversiView `

void CReversiView::OnDraw(CDC* pDC)
{
	CReversiDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (!pDoc)
		return;

	// TODO: ̏ꏊɃlCeBu f[^p̕`R[hǉ܂B
	DrawBoad(pDC);

}


// CReversiView 


void CReversiView::OnFilePrintPreview()
{
#ifndef SHARED_HANDLERS
	AFXPrintPreview(this);
#endif
}

BOOL CReversiView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// ̈
	return DoPreparePrinting(pInfo);
}

void CReversiView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: O̓ʂȏǉĂB
}

void CReversiView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: ̌㏈ǉĂB
}

void CReversiView::InitBoard(void)
{
	int x, y;
	for (x = 0; x < MASU_NUM; x++) {
		for (y = 0; y < MASU_NUM; y++) {
			m_Board[x][y] = BLANK;
		}
	}
	m_Board[3][3] = m_Board[4][4] = BLACK_STONE;
	m_Board[3][4] = m_Board[4][3] = WHITE_STONE;

}

void CReversiView::DrawBoad(CDC * pDC)
{
	int x, y;
	CBrush gray_brush, black_brush, white_brush;

	white_brush.CreateStockObject(WHITE_BRUSH);
	gray_brush.CreateSolidBrush(RGB(200, 200, 200));
	black_brush.CreateSolidBrush(RGB(0, 0, 0));
	pDC->SelectObject(&gray_brush);

	for (x = 0; x < MASU_NUM; x++)
	{
		for (y = 0; y < MASU_NUM; y++)
		{
			/* IZ̎lp`悷 */
			pDC->Rectangle(x * MASU_SIZE, y * MASU_SIZE,
				(x + 1) * MASU_SIZE - 1, (y + 1) * MASU_SIZE - 1);

			/* IZ̏ɂ΂`悷 */
			if (m_Board[x][y] == BLANK)continue;
			else if (m_Board[x][y] == BLACK_STONE)pDC->SelectObject(&black_brush);
			else pDC->SelectObject(&white_brush);

			pDC->Ellipse(x * MASU_SIZE + 3, y * MASU_SIZE + 3,
				(x + 1) * MASU_SIZE - 4, (y + 1) * MASU_SIZE - 4);

			pDC->SelectObject(&gray_brush);
		}
	}

	pDC->SelectObject(&white_brush);       //ftHg̃uVɖ߂
}


void CReversiView::OnRButtonUp(UINT /* nFlags */, CPoint point)
{
	ClientToScreen(&point);
	OnContextMenu(this, point);
}

void CReversiView::OnContextMenu(CWnd* /* pWnd */, CPoint point)
{
#ifndef SHARED_HANDLERS
	theApp.GetContextMenuManager()->ShowPopupMenu(IDR_POPUP_EDIT, point.x, point.y, this, TRUE);
#endif
}


// CReversiView ff

#ifdef _DEBUG
void CReversiView::AssertValid() const
{
	CView::AssertValid();
}

void CReversiView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CReversiDoc* CReversiView::GetDocument() const // fobOȊÕo[W̓CCłB
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CReversiDoc)));
	return (CReversiDoc*)m_pDocument;
}
#endif //_DEBUG


// CReversiView bZ[W nh[
