#pragma once
#include "Move.h"
#include <vector>

/// <summary>
/// Ղ̉̑傫
/// </summary>
const int COL_SIZE = 8;

/// <summary>
/// Ղ̏c̑傫
/// </summary>
const int ROW_SIZE = 8;

/// <summary>
/// The col memory size
/// </summary>
const int COL_MEM_SIZE = 1 + COL_SIZE + 1;

/// <summary>
/// The row memory size
/// </summary>
const int ROW_MEM_SIZE = 1 + ROW_SIZE + 1;


const int BLACK = 1;
const int WHITE = -1;
const int EMPTY = 0;
const int WALL = 2;

class Board
{
	/// <summary>
	/// The cells count
	/// </summary>
	const int CELLS_COUNT = COL_MEM_SIZE * ROW_MEM_SIZE;



	int cells[(ROW_SIZE + 2) * (COL_SIZE + 2)];
	int turn_count;
	int color_of_turn;
	std::vector<Move> moves;

public:
	/// <summary>
	/// Positions the specified x and y.
	/// </summary>
	/// <param name="x">The x.</param>
	/// <param name="y">The y.</param>
	/// <returns></returns>
	int position(int x, int y) {
		return x + y * COL_MEM_SIZE;
	}

	/// <summary>
	/// ʒuϐ̉ 
	/// </summary>
	/// <param name="position">The position.</param>
	/// <returns></returns>
	int x_of(int position) {
		return position % COL_MEM_SIZE;
	}

	/// <summary>
	/// ʒuϐ̏c
	/// </summary>
	/// <param name="position">The position.</param>
	/// <returns></returns>
	int y_of(int position) {
		return position / COL_MEM_SIZE;
	}

	int Cells(int x, int y) {
		int pos = position(x, y);
		return cells[pos];
	}

	void Do(Move *move);

	void Undo();

	Board();
	~Board();
};

