#include <iostream>

using namespace std;

class airship{
  int crewMax;
  int loadingCapacity;
public:
  airship(int crewMax, int loadingCapacity){
    this->crewMax = crewMax;
    this->loadingCapacity = loadingCapacity;
  }
  int getCrewMax(){
    return crewMax;
  }
  int getLoadingCapacity(){
    return loadingCapacity;
  }
};

enum EngineType { propeller, jet };

class airplane : public airship {
  EngineType engineType;
  int cruisingDistance;
public:
  airplane(int crewMax, int loadingCapacity,
    EngineType engineType, int cruisingDistance)
      : airship(crewMax, loadingCapacity){
    this->engineType = engineType;
    this->cruisingDistance = cruisingDistance;
  }
  EngineType getEngineType(){
    return engineType;
  }
  int getCruisingDistance(){
    return cruisingDistance;
  }
};

enum GasType { helium, hydrogen };

class ballon : public airship {
  GasType gasType;
  int maxHeight;
public:
  ballon(int crewMax, int loadingCapacity,
    GasType gasType, int maxHeight)
      : airship(crewMax, loadingCapacity){
    this->gasType = gasType;
    this->maxHeight = maxHeight;
  }
  GasType getGasType(){
    return gasType;
  }
  int GetMaxHeight(){
    return maxHeight;
  }
};

void printAirship(airship &ar){
  std::cout << "最大搭乗員数" << ar.getCrewMax() << "人" << '\n';
  std::cout << "最大積載量" << ar.getLoadingCapacity() << "kg" << '\n';
}

void printBallon(ballon &bl){
  printAirship(bl);
  std::cout << "最大高度" << bl.GetMaxHeight() << "m"<< '\n';
  if (bl.getGasType() == helium) {
    std::cout << "気体はヘリウム" << '\n';
  }else if(bl.getGasType() == hydrogen){
    std::cout << "気体は水素" << '\n';
  }
}

void printAirplane(airplane &ap){
  printAirship(ap);
  std::cout << "航続距離" << ap.getCruisingDistance() << "Km"<< '\n';
  if (ap.getEngineType() == propeller){
    std::cout << "エンジンはプロペラ" << '\n';
  }else if(ap.getEngineType() == jet){
    std::cout << "エンジンはジェット" << '\n';
  }
}

int main(int argc, char const *argv[]) {
  ballon b1(2, 10, helium, 1000);
  ballon b2(3, 12, hydrogen, 1200);
  airplane a1(25, 1000, jet, 15000);
  airplane a2(2, 200, propeller, 5000);
  std::cout << "b1" << '\n';
  printBallon(b1);
  std::cout << "b2" << '\n';
  printBallon(b2);
  std::cout << "a1" << '\n';
  printAirplane(a1);
  std::cout << "a2" << '\n';
  printAirplane(a2);
  return 0;
}
