#include <iostream>
#include <cassert>
using namespace std;

template <typename INTTYPE> 
class matrix {
	int row;
	int col;
	INTTYPE **cells;
public:
	matrix(int row,int col);
	matrix* multiple(matrix *b);
	~matrix();
	INTTYPE getCells(int r, int c);
	void setCells(int r, int c, INTTYPE x);
	void input();
	void output();
private:
	INTTYPE multiple_sum(matrix *a,matrix *b, int i, int j);
};

template <typename INTTYPE> 
INTTYPE matrix<INTTYPE>::getCells(int r, int c){
        return cells[r][c];
}

template <typename INTTYPE> 
void matrix<INTTYPE>::setCells(int r, int c, INTTYPE x){
        cells[r][c] = x;
}

template <typename INTTYPE> 
matrix<INTTYPE>::matrix(int row, int col){
        this->row = row;
        this->col = col;
        cells = new INTTYPE*[row];
        for(int i = 0; i < row; i++){
                cells[i] = new INTTYPE[col];
        }
}

template <typename INTTYPE> 
matrix<INTTYPE>* matrix<INTTYPE>::multiple(matrix *b){
	matrix<INTTYPE>* c = new matrix<INTTYPE>(this->row,b->col);
	for(int i = 0; i < c->row; i++){
		for(int j = 0; j < c->col; j++){
			c->setCells(i,j, multiple_sum(this,b,i,j));
		}
	}
	return c;
}

template <typename INTTYPE> 
INTTYPE matrix<INTTYPE>::multiple_sum(matrix *a,matrix *b, int i, int j){
	INTTYPE sum = 0;
	assert(b->row == a->col);
	int m = a->col;
	for(int k = 0; k < m; k++){
		sum += a->getCells(i,k) * b->getCells(k, j);
	}
	return sum;
}

template <typename INTTYPE> 
matrix<INTTYPE>::~matrix(){
        for(int i = 0; i < row; i++){
                delete[] cells[i];      
        }
        delete[] cells;
}

template <typename INTTYPE> 
void matrix<INTTYPE>::input(){
	for(int i = 0; i < this->row; i++){
		for(int j = 0; j < this->col; j++){
			int data;
			cin >> data;
			this->setCells(i,j,data);
		}
	}
}

template <typename INTTYPE> 
void matrix<INTTYPE>::output(){
	for(int i = 0; i < this->row; i++){
		for(int j = 0; j < this->col; j++){
			cout << this->getCells(i,j);
			if (j == this->col - 1){
				cout << endl;
			}else{
				cout << " ";
			}
		}
	}
}

template <typename INTTYPE>
void run(void){
	int n,m,l;
	cin >> n >> m >> l;
	matrix<INTTYPE> *a = new matrix<INTTYPE>(n, m);
	a->input();
	matrix<INTTYPE> *b = new matrix<INTTYPE>(m, l);
	b->input();
	matrix<INTTYPE> *c = a->multiple(b);
	c->output();
	delete c;
	delete b;	
	delete a;
}

int main(int argc, char *argv[]){
	run<long long int>();
}
