#include <iostream>
#include <string>
#include <cassert>

using namespace std;

const int DICE_SIZE = 6;
int const CmdCount = 6;
int const RotateLen = 4;

//ダイス
//東西南北に転がすことができる。
class dice {
  //一番上,南面,東面,西面,北面,底面の数字
  int values[DICE_SIZE];
public:
  dice ();
  virtual ~dice ();
  int &operator[](int i){
    assert(0 <= i && i < DICE_SIZE);
    return values[i];
  };
  void docmd(string str);
  void docmd(char c);
  void setTopAndFront(int top,int front);
  void input(void);
  int right(void){return values[2];};
  int top(void){return values[0];};
  int front(void){return values[1];};
private:

  int indexs[CmdCount][RotateLen];
  char *cmdChar;
  string *toTopCmd;
  string *toFrontCmd;
  void move_forward(int *indexs);
  int find_value(int num);
};
void dice::setTopAndFront(int top, int front){
  int idxTop = find_value(top);
  docmd(toTopCmd[idxTop]);
  int idxFront = find_value(front);
  docmd(toFrontCmd[idxFront]);
}
int dice::find_value(int num){
  for(int i = 0; i < DICE_SIZE; i++){
    if(values[i] == num){
      return i;
    }
  }
  assert(false);
}
dice::dice(){
  int westindex[RotateLen] = {1, 3, 6, 4};
  int northindex[RotateLen] = {1, 2, 6, 5};
  int leftindex[RotateLen] = {4, 2, 3, 5};
  cmdChar = new char[CmdCount]{'W', 'E', 'N', 'S','L','R'};
  for(int i = 0; i < RotateLen; i++){
    indexs[0][i] = westindex[i] - 1;//W
    indexs[1][i] = westindex[RotateLen - i - 1] - 1;//E
    indexs[2][i] = northindex[i] - 1;//N
    indexs[3][i] = northindex[RotateLen - i - 1] - 1;//S
    indexs[4][i] = leftindex[i] - 1;//L
    indexs[5][i] = leftindex[RotateLen - i - 1] - 1;//R
  }
  toTopCmd = new string[DICE_SIZE]{"","N","W","E","S","NN"};
  toFrontCmd = new string[DICE_SIZE]{"S","","L","R","LL","N"};
}
dice::~dice(){
  delete [] cmdChar;
  delete [] toTopCmd;
  delete [] toFrontCmd;
}

void dice::docmd(string str){
  for(int i = 0; i < str.length(); i++){
  //  cout << "docmd(str[i])" << str[i] << endl;
    docmd(str[i]);
  }
}

void dice::docmd(char c){
  for(int i = 0; i < CmdCount; i++){
    if (c == cmdChar[i]){
    //  cout << cmdChar[i] << endl;
      move_forward(indexs[i]);
      return;
    }
  }
  assert(false);//命令表にない命令
}
void dice::move_forward(int *indexs){
  int temp = values[indexs[0]];
  values[indexs[0]] = values[indexs[1]];
  values[indexs[1]] = values[indexs[2]];
  values[indexs[2]] = values[indexs[3]];
  values[indexs[3]] = temp;
}
void dice::input(void){
  for(int i=0; i < DICE_SIZE; i++){
    int n;
    cin >> n;
    values[i] = n;
  }
}
int main(int argc, char const *argv[]) {
  dice d;
  d.input();
  int count;
  cin >> count;
  for(int i = 0; i < count ;i++){
    int top,front;
    cin >> top >> front;
    d.setTopAndFront(top,front);
    cout << "right:" << d.right() << "top:" << d.top() << "front:" << d.front() << endl;
  }
  return 0;
}
