#include <iostream>
#include <string>
#include <cassert>

using namespace std;

const int DICE_SIZE = 6;

//ダイス
//東西南北に転がすことができる。
class dice {
  //一番上,南面,東面,西面,北面,底面の数字
  int values[DICE_SIZE];
public:
  dice ();
  virtual ~dice ();
  int &operator[](int i){
    assert(0 <= i && i < DICE_SIZE);
    return values[i];
  };
  void docmd(string str);
  void docmd(char c);
private:
  int indexs[4][4];
  char *cmdChar;
  void move_forward(int *indexs);
};
dice::dice(){
  int westindex[4] = {1, 3, 6, 4};
  int northindex[4] = {1, 2, 6, 5};
  cmdChar = new char[4]{'W', 'E', 'N', 'S'};
  for(int i = 0; i < 4; i++){
    indexs[0][i] = westindex[i] - 1;//W
    indexs[1][i] = westindex[4 - i - 1] - 1;//E
    indexs[2][i] = northindex[i] - 1;//N
    indexs[3][i] = northindex[4 - i - 1] - 1;//S
  }
}
dice::~dice(){
  delete [] cmdChar;
}

void dice::docmd(string str){
  for(int i = 0; i < str.length(); i++){
  //  cout << "docmd(str[i])" << str[i] << endl;
    docmd(str[i]);
  }
}

void dice::docmd(char c){
  for(int i = 0; i < 4; i++){
    if (c == cmdChar[i]){
    //  cout << cmdChar[i] << endl;
      move_forward(indexs[i]);
      return;
    }
  }
  assert(false);//命令表にない命令
}
void dice::move_forward(int *indexs){
  int temp = values[indexs[0]];
  values[indexs[0]] = values[indexs[1]];
  values[indexs[1]] = values[indexs[2]];
  values[indexs[2]] = values[indexs[3]];
  values[indexs[3]] = temp;
}

int main(int argc, char const *argv[]) {
  dice d;
  for(int i=0; i < DICE_SIZE; i++){
    int n;
    cin >> n;
    d[i] = n;
  }
  string commandstr;
  cin >> commandstr;
  d.docmd(commandstr);
  int topnum = d[0];
  cout << topnum << endl;
  return 0;
}
