#include <iostream>
#include <cmath>
#include <vector>
#include <cassert>
#include <iomanip>

using namespace std;

long double dis_p(int p, vector<int> &x, vector<int> &y){
	assert(x.size() == y.size());	
	double sum = 0.0;
	for(int i = 0; i < x.size(); i++){
		int ab = abs(x[i] - y[i]);
		int ab_p = pow(ab, p);
		sum += ab_p;
	}
	return powl(sum, 1.0L / p);
}
double chebishev(vector<int> &x, vector<int> &y){
	assert(x.size() == y.size());	
	double max = 0.0;
	for(int i = 0; i < x.size(); i++){
		int ab = abs(x[i] - y[i]);
		if(max < ab){
			max = ab;
		}
	}
	return max;
}
void input(int num,vector<int> &v){
	for(int i = 0; i < num; i++){	
		int x;
		cin >> x;
		v.push_back(x);
	}
}
void output(long double num){
	cout << fixed << fixed << std::setprecision(8) << num << endl;
}
int main(int argc, char *argv[])
{
	int num;
	cin >> num;
	vector<int> x,y;
	input(num, x);
	input(num, y);
	for(int p = 1; p <= 3; p++){
		output (dis_p(p, x,y));
	}
	output (chebishev(x,y));
	return 0;
}
