#include <iostream>
#include <cmath>
#include <cassert>

using namespace std;

typedef unsigned int MEMTYPE;

class mybitset {
  MEMTYPE *mem;
  int size;
  bool ismemfree;
public:
  int bitlen(){
    return sizeof(MEMTYPE) * 8;
  }
  mybitset(){
    ismemfree = true;
  }
  void setsize(int size){
    this->size = size;
    mem = new MEMTYPE[size / bitlen() + 1];
    ismemfree = false;
  }
  ~mybitset(){
    if (!ismemfree){
      delete [] mem;
    }
  }
  bool get(int pos){
    MEMTYPE bit = 1 << (pos % bitlen());
    return (mem[pos / bitlen()] & bit) != 0;
  };
  void set(int pos){
    MEMTYPE bit = 1 << (pos % bitlen());
    mem[pos / bitlen()] |= bit;
  };
  void reset(int pos){
    MEMTYPE bit = ~(1 << (pos % bitlen()));
    mem[pos / bitlen()] &= bit;
  }
};

class primer {
  mybitset isprime;
  int max;
public:
  bool getPrime(int number);
  primer(int max);
};

bool primer::getPrime(int number){
  assert(max > number);
  if (max > number){
    return isprime.get(number);
  }
  //assert(max * max > number);
  //for(int i = 0; i < max ; i++){
  //  if (isprime.get(i)){
  //    if (number % i == 0){
  //      return false;
  //    }
  //  }
  //}
  return true;
}
primer::primer(int max){
  this->max = max;
  isprime.setsize(max + 1);
  //エラトステネスの篩で素数かどうかの判定
  isprime.reset(0);
  isprime.reset(1);
  for(int i = 2; i < max; i++){
    isprime.set(i);
  }
  for(int i = 2; i < sqrt(max); i++){
    if(isprime.get(i)){
      for(int j = 2; i * j < max; j++){
        isprime.reset(i * j);
      }
    }
  }
}


int main(int argc, char const *argv[]) {
  int count;
  cin >> count;
  int prime_count = 0;
  primer p = primer(100000000);
  for (int i = 0; i < count; i++) {
    int number;
    cin >> number;
    if (p.getPrime(number)){
      prime_count++;
    }
  }
  cout << prime_count << endl;
  return 0;
}

/* test code
int main(int argc, char const *argv[]) {
  int count;
  cin >> count;
  int prime_count = 0;
  primer p = primer(20);
  mybitset b;
  b.setsize(100);
  cout << "b.bitlen() = " << b.bitlen() << endl;
  for(int i = 0; i < 20; i++){
    b.set(i);
    if(!b.get(i)){
      cout << "set error "<< i << endl;
    }
  }
  for(int i = 0; i < 20; i++){
    b.reset(i);
    if(b.get(i)){
      cout << "reset error"<< i << endl;
    }
  }
  for(int i = 20; i >= 0; i--){
    b.set(i);
    if(!b.get(i)){
      cout << "set error" << i << endl;
    }
  }
  for (int i = 0; i < count; i++) {
    int number;
    cin >> number;
    if (p.getPrime(number)){
      prime_count++;
    }
  }
  cout << prime_count << endl;
  return 0;
}
*/
