﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;

namespace Azyobuzi.XamlIn.Builder
{
    /// <summary>
    /// XAMLからインストーラを作成します。
    /// </summary>
    public class Builder
    {
        static void Main(string[] args)
        {
            Console.WriteLine("XamlInビルダー Ver." +
                   Assembly.GetExecutingAssembly().GetName().Version.ToString());

            if (args.Length == 0)
                return;

            var builder = new Builder();
            builder.Build(args);
        }

        /// <summary>
        /// ビルドを行います。
        /// </summary>
        /// <param name="xamlFiles">ビルドするソース</param>
        /// <returns>エラー情報</returns>
        public List<string> Build(string[] xamlFiles)
        {
            throw new NotImplementedException();
        }
    }
}
