﻿using System;

namespace Azyobuzi.UserStreamEx
{
    public interface INotStartedUserStream
    {
        IStartedUserStream Start(string track, bool allReplies);

        #region Events
        event EventHandler Started;
        event EventHandler<StoppedEventArgs> Stopped;
        event EventHandler<ReceiveFriendsEventArgs> ReceiveFriends;
        event EventHandler<NewTweetEventArgs> NewTweet;
        event EventHandler<NewDirectMessageEventArgs> NewDirectMessage;
        event EventHandler<DeleteStatusEventArgs> DeleteStatus;
        event EventHandler<ReceiveEventEventArgs> ReceiveEvent;
        event EventHandler<TrackLimitEventArgs> TrackLimit;
        event EventHandler<ReceiveJsonEventArgs> ReceiveUnsupportedData;
        #endregion

        #region AddHandlerMethod
        INotStartedUserStream SetStartedEvent(EventHandler handler);
        INotStartedUserStream SetStoppedEvent(EventHandler<StoppedEventArgs> handler);
        INotStartedUserStream SetReceiveFriendsEvent(EventHandler<ReceiveFriendsEventArgs> handler);
        INotStartedUserStream SetNewTweetEvent(EventHandler<NewTweetEventArgs> handler);
        INotStartedUserStream SetNewDirectMessageEvent(EventHandler<NewDirectMessageEventArgs> handler);
        INotStartedUserStream SetDeleteStatusEvent(EventHandler<DeleteStatusEventArgs> handler);
        INotStartedUserStream SetReceiveEventEvent(EventHandler<ReceiveEventEventArgs> handler);
        INotStartedUserStream SetTrackLimitEvent(EventHandler<TrackLimitEventArgs> handler);
        INotStartedUserStream SetReceiveUnsupportedDataEvent(EventHandler<ReceiveJsonEventArgs> handler);
        #endregion
    }

    public interface IStartedUserStream
    {
        INotStartedUserStream Stop();
        IStartedUserStream SetTimeout(int waitTime);
    }
}
