package jp.sourceforge.pdt_tools.xdebug.support.handlers;

import java.util.Iterator;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStringValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;
import org.w3c.dom.Node;

@SuppressWarnings("restriction")
public class CompleteStringValue extends AbstractHandler {

	public CompleteStringValue() {
	}

	public Object execute(ExecutionEvent event) throws ExecutionException {
		IStructuredSelection selection = getCurrentSelection(event);
		if (selection != null) {
			IDebugElement context = getContext();
			Iterator<?> it = selection.iterator();
			while (it.hasNext()) {
				Object object = it.next();
				if (object instanceof IWatchExpression) {
					IWatchExpression expression = (IWatchExpression) object;
					IValue value = expression.getValue();
					if (value instanceof DBGpStringValue) {
						DBGpStringValue stringValue = (DBGpStringValue) value;
						if (!stringValue.isComplete()) {
							complete(expression, stringValue);
						}
					}
					expression.setExpressionContext(context);
					if (!expression.isEnabled()) {
						expression.evaluate();
					}
				}
			}
		}
		return null;
	}

	private IStructuredSelection getCurrentSelection(ExecutionEvent event)
			throws ExecutionException {
		IWorkbenchPage page = HandlerUtil
				.getActiveWorkbenchWindowChecked(event).getActivePage();
		if (page != null) {
			ISelection selection = page.getSelection();
			if (selection instanceof IStructuredSelection) {
				return (IStructuredSelection) selection;
			}
		}
		return null;
	}

	private IDebugElement getContext() {
		IAdaptable object = DebugUITools.getDebugContext();
		IDebugElement context = null;
		if (object instanceof IDebugElement) {
			context = (IDebugElement) object;
		} else if (object instanceof ILaunch) {
			context = ((ILaunch) object).getDebugTarget();
		}
		return context;
	}

	private void complete(IWatchExpression expression, DBGpStringValue value) {
		DBGpTarget target = (DBGpTarget) value.getDebugTarget();
		String stackLevel = "0";
		Node result = target.getCompleteString(expression.getExpressionText(),
				stackLevel, value.getRequiredBytes());
		if (result != null) {
			IVariable tempVar = new DBGpVariable(target, result, stackLevel);
			try {
				IValue valRes = tempVar.getValue();
				if (valRes instanceof DBGpStringValue) {
					value = (DBGpStringValue) valRes;
				}
			} catch (DebugException e) {
			}
		}
	}

}
