package jp.sourceforge.pdt_tools.js_beautify;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "jp.sourceforge.pdt_tools.js_beautify"; //$NON-NLS-1$

	// The shared instance
	private static Activator plugin;

	private String js_beautify;

	public Activator() {
	}

	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	public static Activator getDefault() {
		return plugin;
	}

	public static void log(Throwable e) {
		getDefault().getLog().log(
				new Status(IStatus.ERROR, PLUGIN_ID, e.getLocalizedMessage()));
	}

	public String getScript() {
		if (js_beautify == null) {
			try {
				URL url = new URL(
						"platform:/plugin/jp.sourceforge.pdt_tools.js_beautify/scripts/beautify.js");
				InputStream inputStream = url.openConnection().getInputStream();
				BufferedReader reader = new BufferedReader(
						new InputStreamReader(inputStream, "UTF-8"));
				String line;
				StringBuffer script = new StringBuffer();
				while ((line = reader.readLine()) != null) {
					script.append(line + "\n");
				}
				reader.close();
				js_beautify = script.toString();
			} catch (IOException e) {
				Activator.log(e);
			}
		}
		return js_beautify;
	}
}
