package jp.sourceforge.pdt_tools.jsformat.handlers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import jp.sourceforge.pdt_tools.jsformat.Activator;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.formatter.DefaultCodeFormatter;
import org.eclipse.wst.jsdt.internal.formatter.DefaultCodeFormatterOptions;

@SuppressWarnings("restriction")
public class CommandHandler extends AbstractHandler {

	public CommandHandler() {
	}

	public Object execute(ExecutionEvent event) throws ExecutionException {
		IEditorPart editor = HandlerUtil.getActiveEditor(event);
		if (editor == null) {
			return null;
		}
		Object obj = editor.getAdapter(IDocument.class);
		if (obj == null) {
			if (editor instanceof AbstractTextEditor) {
				obj = ((AbstractTextEditor) editor).getDocumentProvider()
						.getDocument(editor.getEditorInput());
			}
		}
		if (!(obj instanceof IDocument)) {
			Activator.log(new RuntimeException("Could not get IDocument"));
			return null;
		}
		IDocument document = (IDocument) obj;
		ISelectionProvider provider = editor.getEditorSite()
				.getSelectionProvider();
		if (provider == null) {
			Activator.log(new RuntimeException(
					"Could not get ISelectionProvider"));
			return null;
		}
		ISelection selection = provider.getSelection();
		if (selection instanceof ITextSelection) {
			int offset = ((ITextSelection) selection).getOffset();
			int length = ((ITextSelection) selection).getLength();
			if (length > 0) {
				IProject project = null;
				Object resource = editor.getEditorInput().getAdapter(
						IResource.class);
				if (resource instanceof IResource) {
					project = ((IResource) resource).getProject();
				}
				DefaultCodeFormatter formatter = new DefaultCodeFormatter(
						new DefaultCodeFormatterOptions(getOptions(project)));
				try {
					String string = document.get(offset, length);
					TextEdit text = formatter.format(0, string, 0, length, 0,
							document.getLegalLineDelimiters()[0]);
					if (text != null) {
						IDocument doc = new Document(string);
						text.apply(doc);
						if (!string.equals(doc.get())) {
							document.replace(offset, length, doc.get());
						}
					}
				} catch (BadLocationException e) {
					Activator.log(e);
				}
			}
		}
		return null;
	}

	@SuppressWarnings("unchecked")
	private Map<String, String> getOptions(IProject project) {
		DefaultCodeFormatterOptions options = DefaultCodeFormatterOptions
				.getDefaultSettings();
		PreferencesService service = PreferencesService.getDefault();
		IScopeContext[] contexts = (project != null) ? new IScopeContext[] {
				new ProjectScope(project), InstanceScope.INSTANCE }
				: new IScopeContext[] { InstanceScope.INSTANCE };
		Map<String, String> settings = new HashMap<String, String>();
		Iterator<String> it = options.getMap().keySet().iterator();
		while (it.hasNext()) {
			String key = it.next();
			String value = service.getString(JavaScriptCore.PLUGIN_ID, key,
					null, contexts);
			if (value != null) {
				settings.put(key, value);
			} else {
				settings.put(key, (String) options.getMap().get(key));
			}
		}
		if (!settings.isEmpty()) {
			options.set(settings);
		}
		return options.getMap();
	}
}
