package jp.sourceforge.pdt_tools.jsbeautifier.handlers;

import java.util.LinkedList;
import java.util.List;

import jp.sourceforge.pdt_tools.jsbeautifier.Activator;
import jp.sourceforge.pdt_tools.jsbeautifier.JSBeautifier;
import jp.sourceforge.pdt_tools.jsbeautifier.JSBeautifierOptions;
import jp.sourceforge.pdt_tools.jsbeautifier.preferences.PreferenceConstants;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class CommandHandler extends AbstractHandler {

	public CommandHandler() {
	}

	public Object execute(ExecutionEvent event) throws ExecutionException {
		ITextEditor editor = null;
		IEditorPart editorPart = HandlerUtil.getActiveEditor(event);
		if (editorPart instanceof ITextEditor) {
			editor = (ITextEditor) editorPart;
		}
		if (editor == null) {
			return null;
		}
		Object obj = editor.getAdapter(IDocument.class);
		if (obj == null) {
			obj = editor.getDocumentProvider().getDocument(
					editor.getEditorInput());
		}
		if (!(obj instanceof IDocument)) {
			Activator.log(new RuntimeException("Could not get IDocument"));
			return null;
		}
		IDocument document = (IDocument) obj;
		ISelectionProvider provider = editor.getEditorSite()
				.getSelectionProvider();
		if (provider == null) {
			Activator.log(new RuntimeException(
					"Could not get ISelectionProvider"));
			return null;
		}
		ISelection selection = provider.getSelection();
		if (selection instanceof ITextSelection) {
			int offset = ((ITextSelection) selection).getOffset();
			int length = ((ITextSelection) selection).getLength();
			if (length > 0) {
				IProject project = null;
				Object resource = editor.getEditorInput().getAdapter(
						IResource.class);
				if (resource instanceof IResource) {
					project = ((IResource) resource).getProject();
				}
				JSBeautifierOptions options = getOptions(project);
				try {
					String string = document.get(offset, length);
					String delimiter = document.getLineDelimiter(document
							.getLineOfOffset(offset + length - 1));
					JSBeautifier jsBeautifier = new JSBeautifier();
					String formatted = jsBeautifier
							.js_beautify(string, options);
					if (!"".equals(formatted)) {
						if (string.endsWith(delimiter)) {
							formatted += delimiter;
						}
						if (!formatted.equals(string)) {
							document.replace(offset, length, formatted);
							editor.selectAndReveal(offset, formatted.length());
						}
					}
				} catch (BadLocationException e) {
					Activator.log(e);
				} catch (RuntimeException e) {
					Activator.log(e);
				}
			}
		}
		return null;
	}

	private JSBeautifierOptions getOptions(IProject project) {
		JSBeautifierOptions options = new JSBeautifierOptions();
		IPreferencesService preference = Platform.getPreferencesService();
		List<IScopeContext> contextList = new LinkedList<IScopeContext>();
		if (project != null) {
			contextList.add(new ProjectScope(project));
		}
		contextList.add(InstanceScope.INSTANCE);
		IScopeContext[] contexts = contextList
				.toArray(new IScopeContext[contextList.size()]);
		options.indent_size = preference.getInt(Activator.PLUGIN_ID,
				PreferenceConstants.INDENT_SIZE, options.indent_size, contexts);
		options.indent_char = preference.getString(Activator.PLUGIN_ID,
				PreferenceConstants.INDENT_CHAR, options.indent_char, contexts);
		options.preserve_newlines = preference.getBoolean(Activator.PLUGIN_ID,
				PreferenceConstants.PRESERVE_NEWLINES,
				options.preserve_newlines, contexts);
		options.max_preserve_newlines = preference.getInt(Activator.PLUGIN_ID,
				PreferenceConstants.MAX_PRESERVE_NEWLINES,
				options.max_preserve_newlines, contexts);
		options.jslint_happy = preference.getBoolean(Activator.PLUGIN_ID,
				PreferenceConstants.JSLINT_HAPPY, options.jslint_happy,
				contexts);
		options.brace_style = preference.getInt(Activator.PLUGIN_ID,
				PreferenceConstants.BRACE_STYLE, options.brace_style, contexts);
		options.keep_array_indentation = preference.getBoolean(
				Activator.PLUGIN_ID,
				PreferenceConstants.KEEP_ARRAY_INDENTATION,
				options.keep_array_indentation, contexts);
		options.unescape_strings = preference.getBoolean(Activator.PLUGIN_ID,
				PreferenceConstants.UNESCAPE_STRINGS, options.unescape_strings,
				contexts);
		return options;
	}
}
