package jp.sourceforge.pdt_tools.debug.starter;

import java.util.Set;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.debug.core.model.IPHPDebugTarget;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.RegistryToggleState;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

@SuppressWarnings("restriction")
public class Activator extends AbstractUIPlugin implements IStartup {

	// The plug-in ID
	public static final String PLUGIN_ID = "jp.sourceforge.pdt_tools.debug.starter"; //$NON-NLS-1$

	// The shared instance
	private static Activator plugin;

	private static final String COMMAND_ID = "jp.sourceforge.pdt_tools.debug.starter.commands.toggleDebugDaemon";

	private static boolean started = false;
	private static boolean enabled = false;

	public Activator() {
	}

	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 * 
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given plug-in
	 * relative path
	 * 
	 * @param path
	 *            the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}

	public static boolean isStarted() {
		return started;
	}

	public static void setStarted(boolean value) {
		started = value;
	}

	public static boolean isEnabled() {
		return enabled;
	}

	@Override
	public void earlyStartup() {
		enabled = true;
		startDaemon(true);
		DebugPlugin.getDefault().addDebugEventListener(
				new IDebugEventSetListener() {
					@Override
					public void handleDebugEvents(DebugEvent[] events) {
						for (DebugEvent event : events) {
							if (event.getKind() == DebugEvent.CREATE) {
								if (event.getSource() instanceof IPHPDebugTarget) {
									if (!started) {
										startDaemon(false);
									}
								}
							}
						}
					}
				});
	}

	private void startDaemon(boolean initial) {
		DaemonPlugin daemonPlugin = DaemonPlugin.getDefault();
		if (initial) {
			// referencing DaemonPlugin causes activating the plugin and
			// starting daemons if it is not yet loaded
		} else {
			daemonPlugin.startDaemons(null);
		}
		Set<String> debuggerIds = PHPDebuggersRegistry.getDebuggersIds();
		for (String debuggerId : debuggerIds) {
			daemonPlugin.makeSureDebuggerInitialized(debuggerId);
		}
		started = true;
		Object service = PlatformUI.getWorkbench().getService(
				ICommandService.class);
		if (service instanceof ICommandService) {
			final Command command = ((ICommandService) service)
					.getCommand(COMMAND_ID);
			if (command != null) {
				State state = command.getState(RegistryToggleState.STATE_ID);
				if (state == null) {
					state = new State();
					state.setValue(Boolean.TRUE);
					command.addState(RegistryToggleState.STATE_ID, state);
				}
				if (!Boolean.TRUE.equals(state.getValue())) {
					if (initial) {
						daemonPlugin.stopDaemons(null);
						started = false;
					} else {
						UIJob uiJob = new UIJob("") {
							@Override
							public IStatus runInUIThread(
									IProgressMonitor monitor) {
								try {
									HandlerUtil.toggleCommandState(command);
								} catch (ExecutionException e) {
									DaemonPlugin.log(e);
								}
								return Status.OK_STATUS;
							}
						};
						uiJob.schedule();
					}
				}
			}
		}
	}

}
