<?php

// Start of pgsql v.

/**
 * PostgreSQL 接続をオープンする
 * @link http://www.php.net/manual/ja/function.pg-connect.php
 * @param connection_string string <p>
 * すべてデフォルトのパラメータを使用する場合には
 * connection_string を空にすることが可能です。
 * または 1 つ以上のパラメータを空白で区切って指定することも可能です。
 * 個々のパラメータは keyword = value の形式で
 * 設定します。等号の前後の空白はあってもなくてもかまいません。
 * 空の値や空白を含む値を指定する場合は、その値をシングルクォートで
 * 囲みます（例: keyword = 'a value'）。値の中に
 * シングルクォートやバックスラッシュが含まれる場合は、それらを
 * バックスラッシュでエスケープする必要があります（例: \' および \\）。
 * </p>
 * <p>
 * 現在利用できるパラメータは以下のとおりです。
 * host, hostaddr, port,
 * dbname (デフォルトは user の値), user,
 * password, connect_timeout,
 * options, tty（無視されます）, sslmode,
 * requiressl（非推奨。代わりに sslmode を推奨します）
 * および service 。これらのうち実際にどの
 * パラメータが使えるかは、PostgreSQL のバージョンに依存します。
 * </p>
 * <p>
 * options パラメータを使うと、
 * サーバー側で実行されるコマンドラインパラメータを指定することができます。
 * </p>
 * @param connect_type int[optional] <p>
 * PGSQL_CONNECT_FORCE_NEW が渡された場合は、
 * たとえ connection_string が既存の接続と
 * まったく同一であっても新しい接続をオープンします。
 * </p>
 * @return resource 成功した場合に PostgreSQL の接続リソース、失敗した場合に FALSE を返します。
 */
function pg_connect ($connection_string, $connect_type = null) {}

/**
 * 持続的な PostgreSQL 接続をオープンする
 * @link http://www.php.net/manual/ja/function.pg-pconnect.php
 * @param connection_string string <p>
 * すべてデフォルトのパラメータを使用する場合には
 * connection_string を空にすることが可能です。
 * または 1 つ以上のパラメータを空白で区切って指定することも可能です。
 * 個々のパラメータは keyword = value の形式で
 * 設定します。等号の前後の空白はあってもなくてもかまいません。
 * 空の値や空白を含む値を指定する場合は、その値をシングルクォートで
 * 囲みます（例: keyword = 'a value'）。値の中に
 * シングルクォートやバックスラッシュが含まれる場合は、それらを
 * バックスラッシュでエスケープする必要があります（例: \' および \\）。
 * </p>
 * <p>
 * 現在利用できるパラメータは以下のとおりです。
 * host, hostaddr, port,
 * dbname, user,
 * password, connect_timeout,
 * options, tty（無視されます）, sslmode,
 * requiressl（非推奨。代わりに sslmode を推奨します）
 * および service 。これらのうち実際にどの
 * パラメータが使えるかは、PostgreSQL のバージョンに依存します。
 * </p>
 * @param connect_type int[optional] <p>
 * PGSQL_CONNECT_FORCE_NEW が渡された場合は、
 * たとえ connection_string が既存の接続と
 * まったく同一であっても新しい接続をオープンします。
 * </p>
 * @return resource 成功した場合に PostgreSQL の接続リソース、失敗した場合に FALSE を返します。
 */
function pg_pconnect ($connection_string, $connect_type = null) {}

/**
 * PostgreSQL 接続をクローズする
 * @link http://www.php.net/manual/ja/function.pg-close.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function pg_close ($connection = null) {}

/**
 * 接続ステータスを取得する
 * @link http://www.php.net/manual/ja/function.pg-connection-status.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @return int PGSQL_CONNECTION_OK あるいは
 * PGSQL_CONNECTION_BAD 。
 */
function pg_connection_status ($connection) {}

/**
 * 接続がビジーかどうか調べる
 * @link http://www.php.net/manual/ja/function.pg-connection-busy.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @return bool 接続がビジーの場合に TRUE 、そうでない場合に FALSE を返します。
 */
function pg_connection_busy ($connection) {}

/**
 * 接続をリセット(再接続)する
 * @link http://www.php.net/manual/ja/function.pg-connection-reset.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function pg_connection_reset ($connection) {}

/**
 * 接続に関連するホスト名を返す
 * @link http://www.php.net/manual/ja/function.pg-host.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @return string connection が接続しているホストの名前を
 * 文字列で返します。エラー時には FALSE を返します。
 */
function pg_host ($connection = null) {}

/**
 * データベース名を取得する
 * @link http://www.php.net/manual/ja/function.pg-dbname.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @return string connection が指すデータベースの名前を表す
 * 文字列を返します。エラー時には FALSE を返します。
 */
function pg_dbname ($connection = null) {}

/**
 * 接続に関連するポート番号を返す
 * @link http://www.php.net/manual/ja/function.pg-port.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @return int connection が指しているデータベースのポート番号を
 * 含む int を返します。エラー時には FALSE を返します。
 */
function pg_port ($connection = null) {}

/**
 * 接続に関する TTY 名を返す
 * @link http://www.php.net/manual/ja/function.pg-tty.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @return string connection のデバッグ TTY を文字列で返します。
 * エラー時には FALSE を返します。
 */
function pg_tty ($connection = null) {}

/**
 * 接続に関連するオプションを取得する
 * @link http://www.php.net/manual/ja/function.pg-options.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @return string connection のオプションを文字列で返します。
 * エラー時には FALSE を返します。
 */
function pg_options ($connection = null) {}

/**
 * クライアント・プロトコル・サーバーのバージョンを配列で返す
 * @link http://www.php.net/manual/ja/function.pg-version.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @return array client, protocol 
 * および server のキーとその値を持つ配列を
 * 返します（有効な場合）。エラー時や接続が正常でない場合に FALSE
 * を返します。
 */
function pg_version ($connection = null) {}

/**
 * データベース接続を調べる
 * @link http://www.php.net/manual/ja/function.pg-ping.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function pg_ping ($connection = null) {}

/**
 * サーバーのパラメータ設定を検索する
 * @link http://www.php.net/manual/ja/function.pg-parameter-status.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @param param_name string <p>
 * 指定可能な param_name には以下が含まれます。
 * server_version、
 * server_encoding、client_encoding、
 * is_superuser、session_authorization、
 * DateStyle、TimeZone および
 * integer_datetimes。
 * </p>
 * @return string パラメータの値を文字列で返します。失敗した場合や
 * param_name が間違っている場合には
 * FALSE を返します。
 */
function pg_parameter_status ($connection = null, $param_name) {}

/**
 * サーバー上で実行中のトランザクションの状態を返す
 * @link http://www.php.net/manual/ja/function.pg-transaction-status.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @return int PGSQL_TRANSACTION_IDLE（アイドル状態）、
 * PGSQL_TRANSACTION_ACTIVE（コマンドの実行中）、
 * PGSQL_TRANSACTION_INTRANS（正常なトランザクション内でアイドル状態）、
 * あるいは PGSQL_TRANSACTION_INERROR（失敗したトランザクション内でアイドル状態）
 * のいずれかを返します。
 * 接続が異常な場合は PGSQL_TRANSACTION_UNKNOWN を返します。
 * PGSQL_TRANSACTION_ACTIVE が返されるのは、クエリを
 * サーバーに送信した後まだそれが完了していない場合のみです。
 */
function pg_transaction_status ($connection) {}

/**
 * クエリを実行する
 * @link http://www.php.net/manual/ja/function.pg-query.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @param query string <p>
 * 実行する 1 つまたは複数の SQL 文。複数の文が関数に渡された場合は、
 * 明示的に BEGIN/COMMIT コマンドを指定していない限りはそれらの文は
 * ひとつのトランザクションとして実行されます。しかし、1 回のコールで
 * 複数のトランザクションを実行することは推奨されません。
 * </p>
 * <p>
 * クエリ内のデータは 適切にエスケープ
 * する必要があります。
 * </p>
 * @return resource 成功した場合にクエリ結果リソース、失敗した場合に FALSE を返します。
 */
function pg_query ($connection = null, $query) {}

/**
 * SQL コマンドとパラメータを分割してサーバーにを送信し、その結果を待つ
 * @link http://www.php.net/manual/ja/function.pg-query-params.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @param query string <p>
 * パラメータ化した SQL 文。ひとつの文のみである必要があります
 * （複数の文をセミコロンで区切る形式は使用できません）。パラメータを
 * 使用する際は $1、$2 などの形式で参照されます。
 * </p>
 * @param params array <p>
 * プリペアドステートメント中の $1、$2 などのプレースホルダを
 * 置き換えるパラメータの配列。配列の要素数はプレースホルダの
 * 数と一致する必要があります。
 * </p>
 * @return resource 成功した場合にクエリ結果リソース、失敗した場合に FALSE を返します。
 */
function pg_query_params ($connection = null, $query, array $params) {}

/**
 * 指定したパラメータでプリペアドステートメントを作成するリクエストを
   送信し、その完了を待つ
 * @link http://www.php.net/manual/ja/function.pg-prepare.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @param stmtname string <p>
 * プリペアドステートメントにつける名前。接続内で一意である必要があります。
 * "" が指定された場合は無名ステートメントが作成され、以前に定義された
 * 無名ステートメントを上書きします。
 * </p>
 * @param query string <p>
 * パラメータ化した SQL 文。ひとつの文のみである必要があります
 * （複数の文をセミコロンで区切る形式は使用できません）。パラメータを
 * 使用する際は $1、$2 などの形式で参照されます。
 * </p>
 * @return resource 成功した場合にクエリ結果リソース、失敗した場合に FALSE を返します。
 */
function pg_prepare ($connection = null, $stmtname, $query) {}

/**
 * 指定したパラメータを用いてプリペアドステートメントを実行するリクエストを
   送信し、その結果を待つ
 * @link http://www.php.net/manual/ja/function.pg-execute.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @param stmtname string <p>
 * 実行するプリペアドステートメントの名前。"" が指定された場合は
 * 無名ステートメントが実行されます。名前は、事前に
 * pg_prepare・pg_send_prepare
 * あるいは PREPARE SQL コマンドで準備されたものである
 * 必要があります。
 * </p>
 * @param params array <p>
 * プリペアドステートメント中の $1、$2 などのプレースホルダを
 * 置き換えるパラメータの配列。配列の要素数はプレースホルダの
 * 数と一致する必要があります。
 * </p>
 * <p>
 * この関数をコールする際に、要素の内容は文字列に変換されます。
 * </p>
 * @return resource 成功した場合にクエリ結果リソース、失敗した場合に FALSE を返します。
 */
function pg_execute ($connection = null, $stmtname, array $params) {}

/**
 * 非同期クエリを送信する
 * @link http://www.php.net/manual/ja/function.pg-send-query.php
 * @param connection resource <p>
 * PostgreSQL データベース接続リソース。
 * </p>
 * @param query string <p>
 * 実行するひとつまたは複数の SQL 文。
 * </p>
 * <p>
 * クエリ内のデータは 適切にエスケープ
 * する必要があります。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。</p>
 * <p>
 * クエリの結果を利用するには pg_get_result を使用します。
 */
function pg_send_query ($connection, $query) {}

/**
 * コマンドとパラメータを分割してサーバーに送信し、その結果を待たない
 * @link http://www.php.net/manual/ja/function.pg-send-query-params.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @param query string <p>
 * パラメータ化した SQL 文。ひとつの文のみである必要があります
 * （複数の文をセミコロンで区切る形式は使用できません）。パラメータを
 * 使用する際は $1、$2 などの形式で参照されます。
 * </p>
 * @param params array <p>
 * プリペアドステートメント中の $1、$2 などのプレースホルダを
 * 置き換えるパラメータの配列。配列の要素数はプレースホルダの
 * 数と一致する必要があります。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。</p>
 * <p>
 * クエリの結果を判断するには pg_get_result
 * を使用します。
 */
function pg_send_query_params ($connection, $query, array $params) {}

/**
 * 指定したパラメータでプリペアドステートメントを作成するリクエストを
   送信し、その結果を待たない
 * @link http://www.php.net/manual/ja/function.pg-send-prepare.php
 * @param connection resource <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @param stmtname string <p>
 * プリペアドステートメントにつける名前。接続内で一意である必要があります。
 * "" が指定された場合は無名ステートメントが作成され、以前に定義された
 * 無名ステートメントを上書きします。
 * </p>
 * @param query string <p>
 * パラメータ化した SQL 文。ひとつの文のみである必要があります
 * （複数の文をセミコロンで区切る形式は使用できません）。パラメータを
 * 使用する際は $1、$2 などの形式で参照されます。
 * </p>
 * @return bool 成功した場合に TRUE 、失敗した場合に FALSE を返します。
 * クエリの結果を確かめるには pg_get_result
 * を使用します。
 */
function pg_send_prepare ($connection, $stmtname, $query) {}

/**
 * 指定したパラメータでプリペアドステートメントを実行するリクエストを
   送信し、その結果を待たない
 * @link http://www.php.net/manual/ja/function.pg-send-execute.php
 * @param connection resource <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @param stmtname string <p>
 * 実行するプリペアドステートメントの名前。"" が指定された場合は
 * 無名ステートメントが実行されます。名前は、事前に
 * pg_prepare・pg_send_prepare
 * あるいは PREPARE SQL コマンドで準備されたものである
 * 必要があります。
 * </p>
 * @param params array <p>
 * プリペアドステートメント中の $1、$2 などのプレースホルダを
 * 置き換えるパラメータの配列。配列の要素数はプレースホルダの
 * 数と一致する必要があります。
 * </p>
 * @return bool 成功した場合に TRUE 、失敗した場合に FALSE を返します。
 * クエリの結果を確認するには pg_get_result
 * を使用します。
 */
function pg_send_execute ($connection, $stmtname, array $params) {}

/**
 * 非同期クエリを取り消す
 * @link http://www.php.net/manual/ja/function.pg-cancel-query.php
 * @param connection resource <p>
 * PostgreSQL データベース接続リソース。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function pg_cancel_query ($connection) {}

/**
 * 結果リソースから値を返す
 * @link http://www.php.net/manual/ja/function.pg-fetch-result.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @param row int <p>
 * 結果から取得する行の番号。行番号は 0 から始まります。指定しなかった
 * 場合は、次の行が読み込まれます。
 * </p>
 * @param field mixed <p> 
 * 取得するフィールド（カラム）の名前を表す文字列、あるいは取得する
 * フィールドの番号。フィールド番号は 0 から始まります。
 * </p>
 * @return string 論理型の値は &quot;t&quot; あるいは &quot;f&quot; の形式で返します。
 * 配列を含むそれ以外の型は、PostgreSQL のやりかたにしたがって文字列として
 * フォーマットされた形式で返します。これは psql
 * プログラムの出力と同じ形式です。データベースの NULL
 * 値は、NULL として返します。
 * </p>
 * <p>
 * row が結果の行数より大きい場合、
 * あるいはそれ以外のエラーが発生した場合は FALSE を返します。
 */
function pg_fetch_result ($result, $row, $field) {}

/**
 * 数値添字の配列として行を得る
 * @link http://www.php.net/manual/ja/function.pg-fetch-row.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @param row int[optional] <p>
 * 取得する行番号。最初の行は 0 です。省略したり NULL を指定したりした場合は、
 * 次の行を取得します。
 * </p>
 * @param result_type int[optional] 
 * @return array 個々の値を文字列として格納した配列を返します。配列の添字は 0 から
 * 始まります。データベースの NULL 値は NULL
 * として返します。
 * </p>
 * <p>
 * row が結果の行数より大きい場合・行が存在しない場合
 * 、そしてそれ以外のエラーが発生した場合は FALSE を返します。
 */
function pg_fetch_row ($result, $row = null, $result_type = null) {}

/**
 * 行を連想配列として取得する
 * @link http://www.php.net/manual/ja/function.pg-fetch-assoc.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @param row int[optional] <p>
 * 取得する行番号。最初の行は 0 です。省略したり NULL を指定したりした場合は、
 * 次の行を取得します。
 * </p>
 * @return array 連想配列（フィールド名をキーとする）を返します。
 * 配列の各要素の値は文字列です。
 * データベースの NULL 値は、NULL として返します。
 * </p>
 * <p>
 * row が結果の行数より大きい場合、行が存在しない場合、
 * そしてそれ以外のエラーが発生した場合は FALSE を返します。
 */
function pg_fetch_assoc ($result, $row = null) {}

/**
 * 行を配列として取得する
 * @link http://www.php.net/manual/ja/function.pg-fetch-array.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @param row int[optional] <p>
 * 取得する行番号。最初の行は 0 です。省略したり NULL を指定したりした場合は、
 * 次の行を取得します。
 * </p>
 * @param result_type int[optional] <p>
 * result_type は、返り値の形式を制御する
 * オプションのパラメータです。result_type
 * は定数であり、次の値のどれかとすることが可能です。
 * PGSQL_ASSOC、PGSQL_NUM
 * および PGSQL_BOTH。
 * PGSQL_NUM を使用すると、pg_fetch_array
 * は数値添字の配列を返します。また、PGSQL_ASSOC
 * を使用すると連想配列形式で返します。PGSQL_BOTH
 * がデフォルト設定で、これは数値添字の配列と連想配列の両方を返します。
 * </p>
 * @return array 0 から始まる数値添字の配列か連想配列（フィールド名をキーとする）、
 * あるいはその両方を返します。配列の各要素の値は文字列です。
 * データベースの NULL 値は、NULL として返します。
 * </p>
 * <p>
 * row が結果の行数より大きい場合や行が存在しない場合、
 * そしてそれ以外のエラーが発生した場合は FALSE を返します。
 */
function pg_fetch_array ($result, $row = null, $result_type = null) {}

/**
 * 行をオブジェクトとして得る
 * @link http://www.php.net/manual/ja/function.pg-fetch-object.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @param row int[optional] <p>
 * 取得する行番号。最初の行は 0 です。省略したり NULL を指定したりした場合は、
 * 次の行を取得します。
 * </p>
 * @param result_type int[optional] <p>
 * 非推奨で、無視されます。
 * </p>
 * @return object 結果の各フィールドに対応する属性を持つ object を返します。
 * データベースの NULL 値は NULL として返します。
 * </p>
 * <p>
 * row が結果の行数より大きい場合・行が存在しない場合
 * 、そしてそれ以外のエラーが発生した場合は FALSE を返します。
 */
function pg_fetch_object ($result, $row = null, $result_type = null) {}

/**
 * 取得されたすべての行を配列として取得する
 * @link http://www.php.net/manual/ja/function.pg-fetch-all.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @return array 結果のすべての行を含む配列を返します。それぞれの行は、フィールド名を
 * 添字とするフィールド値の配列です。
 * </p>
 * <p>
 * 結果の行数が 0 だった場合、あるいはその他のエラーが発生した場合に
 * FALSE を返します。
 */
function pg_fetch_all ($result) {}

/**
 * 指定したカラムの全ての行を配列として取得する
 * @link http://www.php.net/manual/ja/function.pg-fetch-all-columns.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @param column int[optional] <p>
 * 結果リソースから取得するカラムの番号。0 から始まります。
 * 指定しない場合のデフォルトは最初のカラムです。
 * </p>
 * @return array 結果カラムの全ての値を配列で返します。
 * </p>
 * <p>
 * column が結果のカラム数より大きい場合や
 * その他のエラーが発生した場合に FALSE を返します。
 */
function pg_fetch_all_columns ($result, $column = null) {}

/**
 * 変更されたレコード(タプル)の数を返す
 * @link http://www.php.net/manual/ja/function.pg-affected-rows.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @return int クエリによって変更された行の数を返します。もし変更されたタプルがない場合は
 * 0 を返します。
 */
function pg_affected_rows ($result) {}

/**
 * 非同期クエリの結果を取得する
 * @link http://www.php.net/manual/ja/function.pg-get-result.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @return resource 結果 resource を返します。結果がもうない場合に FALSE
 * を返します。
 */
function pg_get_result ($connection = null) {}

/**
 * 結果リソースの内部行オフセットを設定する
 * @link http://www.php.net/manual/ja/function.pg-result-seek.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @param offset int <p>
 * 結果リソース内で、内部オフセットを移動させる行。
 * 行番号はゼロから始まります。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function pg_result_seek ($result, $offset) {}

/**
 * クエリ結果のステータスを取得する
 * @link http://www.php.net/manual/ja/function.pg-result-status.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @param type int[optional] <p>
 * result の数値ステータスを返す
 * PGSQL_STATUS_LONG、あるいは
 * result のコマンドタグを返す
 * PGSQL_STATUS_STRING のいずれかです。
 * 指定しない場合は PGSQL_STATUS_LONG がデフォルトです。
 * </p>
 * @return mixed PGSQL_STATUS_LONG が指定された場合の返り値は
 * 以下のいずれかです。
 * PGSQL_EMPTY_QUERY、
 * PGSQL_COMMAND_OK、PGSQL_TUPLES_OK、PGSQL_COPY_OUT、
 * PGSQL_COPY_IN、PGSQL_BAD_RESPONSE、PGSQL_NONFATAL_ERROR
 * および PGSQL_FATAL_ERROR 。
 * それ以外の場合は、PostgreSQL コマンドタグを含む文字列を返します。
 */
function pg_result_status ($result, $type = null) {}

/**
 * メモリを開放する
 * @link http://www.php.net/manual/ja/function.pg-free-result.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function pg_free_result ($result) {}

/**
 * 直近の行のオブジェクト ID を返す
 * @link http://www.php.net/manual/ja/function.pg-last-oid.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @return string 指定された connection で、直近に挿入された行に
 * 割り当てられた OID を文字列で返します。エラー時や有効な OID のない場合に
 * FALSE を返します。
 */
function pg_last_oid ($result) {}

/**
 * 行数を返す
 * @link http://www.php.net/manual/ja/function.pg-num-rows.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @return int 結果の行数を返します。エラー時には -1 を返します。
 */
function pg_num_rows ($result) {}

/**
 * フィールド数を返す
 * @link http://www.php.net/manual/ja/function.pg-num-fields.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @return int 結果のフィールド（カラム）数を返します。エラー時には -1 を返します。
 */
function pg_num_fields ($result) {}

/**
 * フィールドの名前を返す
 * @link http://www.php.net/manual/ja/function.pg-field-name.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @param field_number int <p>
 * フィールド番号。0 から始まります。
 * </p>
 * @return string フィールド名を返します。エラー時には FALSE を返します。
 */
function pg_field_name ($result, $field_number) {}

/**
 * 指定されたフィールドのフィールド番号を返す
 * @link http://www.php.net/manual/ja/function.pg-field-num.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @param field_name string <p>
 * フィールドの名前。
 * </p>
 * @return int フィールド番号（0 から始まります）を返します。エラー時には -1 を返します。
 */
function pg_field_num ($result, $field_name) {}

/**
 * 指定したフィールドの内部記憶領域におけるサイズを返す
 * @link http://www.php.net/manual/ja/function.pg-field-size.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @param field_number int <p>
 * フィールド番号。0 から始まります。
 * </p>
 * @return int 内部記憶領域のサイズ（バイト数）を返します。-1 は可変長フィールドを
 * 示します。エラー時には FALSE を返します。
 */
function pg_field_size ($result, $field_number) {}

/**
 * フィールド番号に対応する型名を返す
 * @link http://www.php.net/manual/ja/function.pg-field-type.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @param field_number int <p>
 * フィールド番号。0 から始まります。
 * </p>
 * @return string フィールド型の名前を文字列で返します。エラー時には FALSE を返します。
 */
function pg_field_type ($result, $field_number) {}

/**
 * フィールド番号に対応する型 ID（OID）を返す
 * @link http://www.php.net/manual/ja/function.pg-field-type-oid.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @param field_number int <p>
 * フィールド番号。0 から始まります。
 * </p>
 * @return int フィールドの型に対応する OID を返します。エラー時には FALSE を返します。
 */
function pg_field_type_oid ($result, $field_number) {}

/**
 * 表示される長さを返す
 * @link http://www.php.net/manual/ja/function.pg-field-prtlen.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @param row_number int 
 * @param field_name_or_number mixed 
 * @return int フィールドの表示される長さを返します。エラー時には FALSE を返します。
 */
function pg_field_prtlen ($result, $row_number, $field_name_or_number) {}

/**
 * フィールドが SQL の <literal>NULL</literal> かどうか調べる
 * @link http://www.php.net/manual/ja/function.pg-field-is-null.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @param row int <p>
 * 取得する結果の行番号。行番号は 0 から始まります。指定しなかった場合は
 * カレントの行を取得します。
 * </p>
 * @param field mixed <p>
 * （0 から始まる）フィールド番号を表す数値、
 * あるいはフィールド名を表す文字列。
 * </p>
 * @return int 指定した行のフィールドが SQL の NULL だった場合に
 * 1、そうでない場合に 0 を返します。
 * もし範囲外の行を指定したりその他のエラーが発生したりした場合には
 * FALSE を返します。
 */
function pg_field_is_null ($result, $row, $field) {}

/**
 * tables フィールドの名前あるいは oid を返す
 * @link http://www.php.net/manual/ja/function.pg-field-table.php
 * @param result resource <p>
 * pg_query、pg_query_params
 * あるいは pg_execute
 * (その他も含む) から返された、PostgreSQL クエリ結果リソース。
 * </p>
 * @param field_number int <p>
 * 0 から始まるフィールド番号。
 * </p>
 * @param oid_only bool[optional] <p>
 * デフォルトでは、フィールドが属するテーブルの名前が返されます。
 * しかし oid_only をTRUE に設定すると、
 * その代わりに oid が返されます。
 * </p>
 * @return mixed 成功した場合にフィールドのテーブル名あるいは oid、
 * あるいは失敗した場合に FALSE を返します。
 */
function pg_field_table ($result, $field_number, $oid_only = null) {}

/**
 * SQL NOTIFY メッセージを取得する
 * @link http://www.php.net/manual/ja/function.pg-get-notify.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @param result_type int[optional] <p>
 * result_type は、返り値の形式を制御する
 * オプションのパラメータです。result_type
 * は定数であり、次の値のどれかとすることが可能です。
 * PGSQL_ASSOC、PGSQL_NUM
 * および PGSQL_BOTH。
 * PGSQL_NUM を使用すると、pg_get_notify
 * は数値添字の配列を返します。また、PGSQL_ASSOC
 * を使用すると連想配列形式で返します。PGSQL_BOTH
 * がデフォルト設定で、これは数値添字の配列と連想配列の両方を返します。
 * </p>
 * @return array NOTIFY メッセージ名とバックエンドの PID を含む
 * 配列を返します。もし待ち受ける NOTIFY が存在しない
 * 場合は then FALSE を返します。
 */
function pg_get_notify ($connection, $result_type = null) {}

/**
 * バックエンドのプロセス ID を得る
 * @link http://www.php.net/manual/ja/function.pg-get-pid.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @return int バックエンドのデータベースのプロセス ID 。
 */
function pg_get_pid ($connection) {}

/**
 * 結果に関連するエラーメッセージを取得する
 * @link http://www.php.net/manual/ja/function.pg-result-error.php
 * @param result resource <p>
 * pg_query, pg_query_params
 * あるいは pg_execute から返される PostgreSQL の
 * クエリ結果リソース。
 * </p>
 * @return string result パラメータに関連付けられたエラーがある場合は
 * それを文字列で返し、それ以外の場合は FALSE を返します。
 */
function pg_result_error ($result) {}

/**
 * エラー報告の各フィールドを返す
 * @link http://www.php.net/manual/ja/function.pg-result-error-field.php
 * @param result resource <p>
 * 実行したステートメントのクエリ結果リソース。
 * </p>
 * @param fieldcode int <p>
 * 以下の fieldcode が使用可能です。 PGSQL_DIAG_SEVERITY、
 * PGSQL_DIAG_SQLSTATE、PGSQL_DIAG_MESSAGE_PRIMARY、
 * PGSQL_DIAG_MESSAGE_DETAIL、
 * PGSQL_DIAG_MESSAGE_HINT、PGSQL_DIAG_STATEMENT_POSITION、
 * PGSQL_DIAG_INTERNAL_POSITION（PostgreSQL 8.0+ のみ）、
 * PGSQL_DIAG_INTERNAL_QUERY（PostgreSQL 8.0+ のみ）、
 * PGSQL_DIAG_CONTEXT、PGSQL_DIAG_SOURCE_FILE、
 * PGSQL_DIAG_SOURCE_LINE あるいは
 * PGSQL_DIAG_SOURCE_FUNCTION 。
 * </p>
 * @return string エラーフィールドの内容を文字列で返します。
 * フィールドが存在しない場合に NULL 、失敗した場合に FALSE
 * を返します。
 */
function pg_result_error_field ($result, $fieldcode) {}

/**
 * 特定の接続から直近のエラーメッセージ文字列を取得する
 * @link http://www.php.net/manual/ja/function.pg-last-error.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @return string 指定した connection の直近のエラーメッセージを
 * 含む文字列を返します。エラー時には FALSE を返します。
 */
function pg_last_error ($connection = null) {}

/**
 * PostgreSQL サーバーからの直近の通知メッセージを返す
 * @link http://www.php.net/manual/ja/function.pg-last-notice.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @return string 指定された connection の直近の通知を文字列で
 * 返します。エラー時には FALSE を返します。
 */
function pg_last_notice ($connection) {}

/**
 * NULL で終わる文字列を PostgreSQL バックエンドに送信する
 * @link http://www.php.net/manual/ja/function.pg-put-line.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @param data string <p>
 * PostgreSQL バックエンドに直接送信されるテキストデータ。
 * 最後に NULL が自動的に付加されます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function pg_put_line ($connection = null, $data) {}

/**
 * PostgreSQL バックエンドと同期する
 * @link http://www.php.net/manual/ja/function.pg-end-copy.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function pg_end_copy ($connection = null) {}

/**
 * 配列にテーブルをコピーする
 * @link http://www.php.net/manual/ja/function.pg-copy-to.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @param table_name string <p>
 * データを rows にコピーするテーブルの名前。
 * </p>
 * @param delimiter string[optional] <p>
 * rows の要素内で、各フィールドに対応する値を
 * 区切る文字。デフォルトは TAB です。
 * </p>
 * @param null_as string[optional] <p>
 * rows の中で、SQL の NULL 
 * をどのように表現するか。デフォルトは \N ("\\N") です。
 * </p>
 * @return array COPY されたデータが 1 行ごとにひとつの要素と
 * なっている配列を返します。失敗した場合には FALSE を返します。
 */
function pg_copy_to ($connection, $table_name, $delimiter = null, $null_as = null) {}

/**
 * 配列からテーブルに挿入する
 * @link http://www.php.net/manual/ja/function.pg-copy-from.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @param table_name string <p>
 * rows をコピーするテーブルの名前。
 * </p>
 * @param rows array <p>
 * table_name にコピーするデータの配列。
 * rows の個々の値が table_name
 * のひとつの行となります。rows の個々の値は、
 * それぞれのフィールドに対応する値が区切り文字で区切られており、最後は
 * 改行で終了していなければなりません。
 * </p>
 * @param delimiter string[optional] <p>
 * rows の要素内で、各フィールドに対応する値を
 * 区切る文字。デフォルトは TAB です。
 * </p>
 * @param null_as string[optional] <p>
 * rows の中で、SQL の NULL 
 * をどのように表現するか。デフォルトは \N ("\\N") です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function pg_copy_from ($connection, $table_name, array $rows, $delimiter = null, $null_as = null) {}

/**
 * PostgreSQL 接続のトレースを有効にする
 * @link http://www.php.net/manual/ja/function.pg-trace.php
 * @param pathname string <p>
 * トレースログを書き込むファイルの名前（フルパスを含む）。
 * fopen と同じ。
 * </p>
 * @param mode string[optional] <p>
 * オプションのファイルアクセスモード。fopen
 * と同じです。
 * </p>
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function pg_trace ($pathname, $mode = null, $connection = null) {}

/**
 * PostgreSQL 接続のトレースを無効にする
 * @link http://www.php.net/manual/ja/function.pg-untrace.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @return bool Always returns TRUE.
 */
function pg_untrace ($connection = null) {}

/**
 * ラージオブジェクトを生成する
 * @link http://www.php.net/manual/ja/function.pg-lo-create.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @param object_id mixed[optional] <p>
 * object_id が指定されると、
 * この関数は指定された ID のラージオブジェクトを作成しようとします。
 * それ以外の場合は、サーバーから割り当てられたオブジェクト ID を使用します。
 * このパラメータは PHP 5.3 で追加されたもので、
 * PostgreSQL 8.1 以降の新機能に依存しています。
 * </p>
 * @return int ラージオブジェクトの OID を返します。
 * エラー時には FALSE を返します。
 */
function pg_lo_create ($connection = null, $object_id = null) {}

/**
 * ラージオブジェクトを削除する
 * @link http://www.php.net/manual/ja/function.pg-lo-unlink.php
 * @param connection resource <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @param oid int <p>
 * データベース内のラージオブジェクトの OID 。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function pg_lo_unlink ($connection, $oid) {}

/**
 * ラージオブジェクトをオープンする
 * @link http://www.php.net/manual/ja/function.pg-lo-open.php
 * @param connection resource <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @param oid int <p>
 * データベース内のラージオブジェクトの OID 。
 * </p>
 * @param mode string <p>
 * 読み込み専用の "r"、書き込み専用の "w"、読み書き可能な "rw"
 * のいずれか。
 * </p>
 * @return resource ラージオブジェクトのリソースを返します。エラー時には FALSE を返します。
 */
function pg_lo_open ($connection, $oid, $mode) {}

/**
 * ラージオブジェクトをクローズする
 * @link http://www.php.net/manual/ja/function.pg-lo-close.php
 * @param large_object resource 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function pg_lo_close ($large_object) {}

/**
 * ラージオブジェクトを読み込む
 * @link http://www.php.net/manual/ja/function.pg-lo-read.php
 * @param large_object resource <p>
 * pg_lo_open によって返された
 * PostgreSQL ラージオブジェクト (LOB) リソース。
 * </p>
 * @param len int[optional] <p>
 * 返すデータの最大バイト数（オプション）。
 * </p>
 * @return string ラージオブジェクトから len バイトのデータを
 * 文字列で返します。エラー時には FALSE を返します。
 */
function pg_lo_read ($large_object, $len = null) {}

/**
 * ラージオブジェクトを書く
 * @link http://www.php.net/manual/ja/function.pg-lo-write.php
 * @param large_object resource <p>
 * pg_lo_open によって返された
 * PostgreSQL ラージオブジェクト (LOB) リソース。
 * </p>
 * @param data string <p>
 * ラージオブジェクトに書き込むデータ。len が
 * data の長さより小さく指定されている場合、
 * len バイトのみが書き込まれます。
 * </p>
 * @param len int[optional] <p>
 * 書き込むデータの最大バイト数（オプション）。0 より大きく、かつ
 * data のサイズ以下でなければなりません。
 * デフォルトは data の長さです。
 * </p>
 * @return int ラージオブジェクトに書き込んだバイト数を返します。
 * エラー時には FALSE を返します。
 */
function pg_lo_write ($large_object, $data, $len = null) {}

/**
 * ラージオブジェクト全体を読み込みブラウザに直接送信する
 * @link http://www.php.net/manual/ja/function.pg-lo-read-all.php
 * @param large_object resource <p>
 * pg_lo_open によって返された
 * PostgreSQL ラージオブジェクト (LOB) リソース。
 * </p>
 * @return int 読み込んだバイト数を返します。エラー時には FALSE を返します。
 */
function pg_lo_read_all ($large_object) {}

/**
 * ファイルからラージオブジェクトをインポートする
 * @link http://www.php.net/manual/ja/function.pg-lo-import.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @param pathname string <p>
 * クライアントのファイルシステムからラージオブジェクト用データを
 * 読み込む際のフルパスとファイル名。
 * </p>
 * @param object_id mixed[optional] <p>
 * object_id が指定されると、
 * この関数は指定された ID のラージオブジェクトを作成しようとします。
 * それ以外の場合は、サーバーから割り当てられたオブジェクト ID を使用します。
 * このパラメータは PHP 5.3 で追加されたもので、
 * PostgreSQL 8.1 以降の新機能に依存しています。
 * </p>
 * @return int 作成されたラージオブジェクトの OID を返します。
 * 失敗した場合には FALSE を返します。
 */
function pg_lo_import ($connection = null, $pathname, $object_id = null) {}

/**
 * ラージオブジェクトをファイルにエクスポートする
 * @link http://www.php.net/manual/ja/function.pg-lo-export.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @param oid int <p>
 * データベース内のラージオブジェクトの OID 。
 * </p>
 * @param pathname string <p>
 * ラージオブジェクトをクライアントのファイルシステムに書き込む際の
 * フルパスとファイル名。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function pg_lo_export ($connection = null, $oid, $pathname) {}

/**
 * ラージオブジェクトの位置をシークする
 * @link http://www.php.net/manual/ja/function.pg-lo-seek.php
 * @param large_object resource <p>
 * pg_lo_open が返す PostgreSQL の
 * ラージオブジェクト(LOB)リソース。
 * </p>
 * @param offset int <p>
 * シークするバイト数。
 * </p>
 * @param whence int[optional] <p>
 * 定数 PGSQL_SEEK_SET（オブジェクトの先頭からシークする）、
 * PGSQL_SEEK_CUR（カレントの位置からシークする）、
 * あるいは PGSQL_SEEK_END（オブジェクトの最後からシークする）
 * の中のひとつ。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function pg_lo_seek ($large_object, $offset, $whence = null) {}

/**
 * ラージオブジェクトのカレントのシーク位置を返す
 * @link http://www.php.net/manual/ja/function.pg-lo-tell.php
 * @param large_object resource <p>
 * pg_lo_open が返す PostgreSQL の
 * ラージオブジェクト(LOB)リソース。
 * </p>
 * @return int ラージオブジェクトの先頭からのカレントのシーク位置（バイト数）を返します。
 * エラーが発生した場合は、負の数を返します。
 */
function pg_lo_tell ($large_object) {}

/**
 * クエリに使う文字列をエスケープする
 * @link http://www.php.net/manual/ja/function.pg-escape-string.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。
 * connection が存在しない場合は、
 * デフォルトの接続を使用します。デフォルトの接続は、
 * pg_connect あるいは pg_pconnect
 * で直近に作成されたものとなります。
 * </p>
 * @param data string <p>
 * エスケープするテキスト文字列。
 * </p>
 * @return string エスケープされたデータを文字列で返します。
 */
function pg_escape_string ($connection = null, $data) {}

/**
 * bytea フィールドに挿入するために文字列をエスケープする
 * @link http://www.php.net/manual/ja/function.pg-escape-bytea.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。
 * connection が存在しない場合は、
 * デフォルトの接続を使用します。デフォルトの接続は、
 * pg_connect あるいは pg_pconnect
 * で直近に作成されたものとなります。
 * </p>
 * @param data string <p>
 * bytea 型のカラムに挿入するテキストまたはバイナリデータを含む
 * 文字列。
 * </p>
 * @return string エスケープされたデータを文字列で返します。
 */
function pg_escape_bytea ($connection = null, $data) {}

/**
 * bytea 型のバイナリをアンエスケープする
 * @link http://www.php.net/manual/ja/function.pg-unescape-bytea.php
 * @param data string <p>
 * PHP のバイナリ文字列に変換する PostgreSQL の bytea データを含む
 * 文字列。
 * </p>
 * @return string アンエスケープされたデータを文字列で返します。
 */
function pg_unescape_bytea ($data) {}

/**
 * テキスト型フィールドに挿入するために、リテラルをエスケープする
 * @link http://www.php.net/manual/ja/function.pg-escape-literal.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。
 * connection が存在しない場合は、
 * デフォルトの接続を使用します。デフォルトの接続は、
 * pg_connect あるいは pg_pconnect
 * で直近に作成されたものとなります。
 * </p>
 * @param data string <p>
 * エスケープするテキスト文字列。
 * </p>
 * @return string エスケープされたデータを文字列で返します。
 */
function pg_escape_literal ($connection = null, $data) {}

/**
 * テキスト型フィールドに挿入するために、識別子をエスケープする
 * @link http://www.php.net/manual/ja/function.pg-escape-identifier.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。
 * connection が存在しない場合は、
 * デフォルトの接続を使用します。デフォルトの接続は、
 * pg_connect あるいは pg_pconnect
 * で直近に作成されたものとなります。
 * </p>
 * @param data string <p>
 * エスケープするテキスト文字列。
 * </p>
 * @return string エスケープされたデータを文字列で返します。
 */
function pg_escape_identifier ($connection = null, $data) {}

/**
 * <function>pg_last_error</function> および <function>pg_result_error</function>
   が返すメッセージの詳細度を指定する
 * @link http://www.php.net/manual/ja/function.pg-set-error-verbosity.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @param verbosity int <p>
 * 指定する詳細度。PGSQL_ERRORS_TERSE、
 * PGSQL_ERRORS_DEFAULT
 * あるいは PGSQL_ERRORS_VERBOSE 。
 * </p>
 * @return int 変更前の詳細度レベル。PGSQL_ERRORS_TERSE、
 * PGSQL_ERRORS_DEFAULT
 * あるいは PGSQL_ERRORS_VERBOSE のいずれかを
 * 返します。
 */
function pg_set_error_verbosity ($connection = null, $verbosity) {}

/**
 * クライアントのエンコーディングを取得する
 * @link http://www.php.net/manual/ja/function.pg-client-encoding.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @return string クライアントのエンコーディングを返します。エラー時には FALSE を返します。
 */
function pg_client_encoding ($connection = null) {}

/**
 * クライアントのエンコーディングを設定する
 * @link http://www.php.net/manual/ja/function.pg-set-client-encoding.php
 * @param connection resource[optional] <p>
 * PostgreSQL データベース接続リソース。connection
 * が指定されていない場合はデフォルトの接続が使用されます。
 * デフォルトの接続は、直近の pg_connect
 * あるいは pg_pconnect によって作成されたものです。
 * </p>
 * @param encoding string <p>
 * クライアントエンコーディング。以下のうちのひとつです。SQL_ASCII、EUC_JP、
 * EUC_CN、EUC_KR、EUC_TW、
 * UNICODE、MULE_INTERNAL、LATINX (X=1...9)、
 * KOI8、WIN、ALT、SJIS、
 * BIG5 あるいは WIN1250 。
 * </p>
 * <p>
 * 利用可能なエンコーディングの完全なリストは、使用している PostgreSQL
 * のバージョンに依存します。詳細な情報については PostgreSQL のマニュアルを
 * 参照ください。
 * </p>
 * @return int 成功した場合に 0 、エラー時に -1 を返します。
 */
function pg_set_client_encoding ($connection = null, $encoding) {}

/**
 * テーブルからメタデータを取得する
 * @link http://www.php.net/manual/ja/function.pg-meta-data.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @param table_name string <p>
 * テーブルの名前。
 * </p>
 * @return array テーブル定義の配列を返します。エラー時には FALSE を返します。
 */
function pg_meta_data ($connection, $table_name) {}

/**
 * 連想配列の値を、SQL 文として実行可能な形式に変換する
 * @link http://www.php.net/manual/ja/function.pg-convert.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @param table_name string <p>
 * 変換対象となるテーブルの名前。
 * </p>
 * @param assoc_array array <p>
 * 変換されるデータ。
 * </p>
 * @param options int[optional] <p>
 * PGSQL_CONV_IGNORE_DEFAULT, 
 * PGSQL_CONV_FORCE_NULL あるいは
 * PGSQL_CONV_IGNORE_NOT_NULL の組み合わせ。
 * </p>
 * @return array 変換された値の配列を返します。エラー時には FALSE を返します。
 */
function pg_convert ($connection, $table_name, array $assoc_array, $options = null) {}

/**
 * テーブルに配列を挿入する
 * @link http://www.php.net/manual/ja/function.pg-insert.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @param table_name string <p>
 * 行を挿入するテーブルの名前。テーブル table_name
 * は、少なくとも assoc_array の要素数ぶんのカラムを
 * 保持している必要があります。
 * </p>
 * @param assoc_array array <p>
 * テーブル table_name のフィールド名をキーに、
 * 挿入する内容を値にもつ配列。
 * </p>
 * @param options int[optional] <p>
 * PGSQL_CONV_OPTS、
 * PGSQL_DML_NO_CONV、
 * PGSQL_DML_EXEC、
 * PGSQL_DML_ASYNC あるいは
 * PGSQL_DML_STRING を組み合わせた数。
 * PGSQL_DML_STRING が
 * options に含まれていた場合、
 * クエリ文字列が返されます。
 * </p>
 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。 options で
 * PGSQL_DML_STRING が渡された場合は文字列を返します。
 */
function pg_insert ($connection, $table_name, array $assoc_array, $options = null) {}

/**
 * テーブルを更新する
 * @link http://www.php.net/manual/ja/function.pg-update.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @param table_name string <p>
 * 行を更新するテーブルの名前。
 * </p>
 * @param data array <p>
 * テーブル table_name のフィールド名をキーに、
 * そしてマッチした対象を更新するデータを値にもつ配列。
 * </p>
 * @param condition array <p>
 * テーブル table_name のフィールド名をキーに、
 * そして取得対象となる行にマッチするデータを値にもつ配列。
 * </p>
 * @param options int[optional] <p>
 * PGSQL_CONV_OPTS、
 * PGSQL_DML_NO_CONV、
 * PGSQL_DML_EXEC あるいは
 * PGSQL_DML_STRING の組み合わせ。
 * options の一部に
 * PGSQL_DML_STRING が含まれていた場合、
 * クエリ文字列が返されます。
 * </p>
 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。 options に
 * PGSQL_DML_STRING が渡された場合は文字列を返します。
 */
function pg_update ($connection, $table_name, array $data, array $condition, $options = null) {}

/**
 * レコードを削除する
 * @link http://www.php.net/manual/ja/function.pg-delete.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @param table_name string <p>
 * 行を削除するテーブルの名前。
 * </p>
 * @param assoc_array array <p>
 * そのキーが table_name テーブルのフィールド名、
 * 値が削除したいフィールドの値となっている配列。
 * </p>
 * @param options int[optional] <p>
 * PGSQL_CONV_FORCE_NULL、
 * PGSQL_DML_NO_CONV、
 * PGSQL_DML_EXEC あるいは
 * PGSQL_DML_STRING を組み合わせた数。
 * options に PGSQL_DML_STRING
 * が含まれている場合、クエリ文字列が返されます。
 * </p>
 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。 
 * options で PGSQL_DML_STRING
 * が渡された場合は文字列を返します。
 */
function pg_delete ($connection, $table_name, array $assoc_array, $options = null) {}

/**
 * レコードを選択する
 * @link http://www.php.net/manual/ja/function.pg-select.php
 * @param connection resource <p>
 * PostgreSQL データベースの接続リソース。
 * </p>
 * @param table_name string <p>
 * 行を選択するテーブルの名前。
 * </p>
 * @param assoc_array array <p>
 * テーブル table_name のフィールド名をキーに、
 * そして取得対象となる行にマッチするデータを値にもつ配列。
 * </p>
 * @param options int[optional] <p>
 * PGSQL_CONV_FORCE_NULL、
 * PGSQL_DML_NO_CONV、
 * PGSQL_DML_EXEC、
 * PGSQL_DML_ASYNC あるいは
 * PGSQL_DML_STRING の組み合わせ。
 * options の一部に 
 * PGSQL_DML_STRING が含まれていた場合、
 * クエリ文字列が返されます。
 * </p>
 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。 options に
 * PGSQL_DML_STRING が渡された場合は文字列を返します。
 */
function pg_select ($connection, $table_name, array $assoc_array, $options = null) {}

/**
 * @param connection[optional]
 * @param query[optional]
 */
function pg_exec ($connection, $query) {}

/**
 * @param result
 */
function pg_getlastoid ($result) {}

/**
 * @param result
 */
function pg_cmdtuples ($result) {}

/**
 * @param connection[optional]
 */
function pg_errormessage ($connection) {}

/**
 * @param result
 */
function pg_numrows ($result) {}

/**
 * @param result
 */
function pg_numfields ($result) {}

/**
 * @param result
 * @param field_number
 */
function pg_fieldname ($result, $field_number) {}

/**
 * @param result
 * @param field_number
 */
function pg_fieldsize ($result, $field_number) {}

/**
 * @param result
 * @param field_number
 */
function pg_fieldtype ($result, $field_number) {}

/**
 * @param result
 * @param field_name
 */
function pg_fieldnum ($result, $field_name) {}

/**
 * @param result
 * @param row[optional]
 * @param field_name_or_number[optional]
 */
function pg_fieldprtlen ($result, $row, $field_name_or_number) {}

/**
 * @param result
 * @param row[optional]
 * @param field_name_or_number[optional]
 */
function pg_fieldisnull ($result, $row, $field_name_or_number) {}

/**
 * @param result
 */
function pg_freeresult ($result) {}

/**
 * @param connection
 */
function pg_result ($connection) {}

/**
 * @param large_object
 */
function pg_loreadall ($large_object) {}

/**
 * @param connection[optional]
 * @param large_object_id[optional]
 */
function pg_locreate ($connection, $large_object_id) {}

/**
 * @param connection[optional]
 * @param large_object_oid[optional]
 */
function pg_lounlink ($connection, $large_object_oid) {}

/**
 * @param connection[optional]
 * @param large_object_oid[optional]
 * @param mode[optional]
 */
function pg_loopen ($connection, $large_object_oid, $mode) {}

/**
 * @param large_object
 */
function pg_loclose ($large_object) {}

/**
 * @param large_object
 * @param len[optional]
 */
function pg_loread ($large_object, $len) {}

/**
 * @param large_object
 * @param buf
 * @param len[optional]
 */
function pg_lowrite ($large_object, $buf, $len) {}

/**
 * @param connection[optional]
 * @param filename[optional]
 * @param large_object_oid[optional]
 */
function pg_loimport ($connection, $filename, $large_object_oid) {}

/**
 * @param connection[optional]
 * @param objoid[optional]
 * @param filename[optional]
 */
function pg_loexport ($connection, $objoid, $filename) {}

/**
 * @param connection[optional]
 */
function pg_clientencoding ($connection) {}

/**
 * @param connection[optional]
 * @param encoding[optional]
 */
function pg_setclientencoding ($connection, $encoding) {}

define ('PGSQL_LIBPQ_VERSION', "8.3.3");
define ('PGSQL_LIBPQ_VERSION_STR', "PostgreSQL 8.3.3, compiled by Visual C++ build 1500");

/**
 * pg_connect に渡し、既存の同一接続を無視して
 * 新しい接続を確立させるようにします。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_CONNECT_FORCE_NEW', 2);

/**
 * pg_fetch_array に渡します。
 * フィールド名と値の連想配列を返します。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_ASSOC', 1);

/**
 * pg_fetch_array に渡します。
 * フィールド番号と値の数値添字配列を返します。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_NUM', 2);

/**
 * pg_fetch_array に渡します。
 * フィールド値の配列を、数値添字（フィールド番号で）と
 * 連想配列（フィールド名で）の両方で返します。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_BOTH', 3);

/**
 * pg_connection_status から返され、データベースとの
 * 接続が不正な状態になっていることを示します。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_CONNECTION_BAD', 1);

/**
 * pg_connection_status から返され、データベースとの
 * 接続が正常であることを示します。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_CONNECTION_OK', 0);

/**
 * pg_transaction_status から返されます。
 * 接続は現在アイドル状態で、トランザクション内ではありません。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_TRANSACTION_IDLE', 0);

/**
 * pg_transaction_status から返されます。
 * 接続内でコマンドを実行中です。クエリが接続を通じて送信され、
 * まだ完了していません。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_TRANSACTION_ACTIVE', 1);

/**
 * pg_transaction_status から返されます。
 * 接続は現在アイドル状態で、トランザクションブロック内にあります。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_TRANSACTION_INTRANS', 2);

/**
 * pg_transaction_status から返されます。
 * 接続は現在アイドル状態で、トランザクション処理に失敗しています。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_TRANSACTION_INERROR', 3);

/**
 * pg_transaction_status から返されます。
 * 接続が正常ではありません。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_TRANSACTION_UNKNOWN', 4);

/**
 * pg_set_error_verbosity に渡します。
 * 返されるメッセージを指定します。ここには深刻度・短い説明および
 * 発生位置のみを含めます。通常は 1 行に収まるでしょう。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_ERRORS_TERSE', 0);

/**
 * pg_set_error_verbosity に渡します。
 * デフォルトで返されるメッセージで、上の内容に加えて詳細・
 * ヒントあるいは詳細情報を含めます（複数行にまたがるかもしれません）。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_ERRORS_DEFAULT', 1);

/**
 * pg_set_error_verbosity に渡します。
 * 詳細モードでのメッセージで、有効なフィールドをすべて含めます。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_ERRORS_VERBOSE', 2);

/**
 * pg_lo_seek に渡します。シーク操作は
 * オブジェクトの先頭から始められます。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_SEEK_SET', 0);

/**
 * pg_lo_seek に渡します。シーク操作は
 * カレントの位置から始められます。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_SEEK_CUR', 1);

/**
 * pg_lo_seek に渡します。シーク操作は
 * オブジェクトの最後から始められます。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_SEEK_END', 2);

/**
 * pg_result_status に渡します。
 * 結果として数値が要求されていることを示します。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_STATUS_LONG', 1);

/**
 * pg_result_status に渡します。
 * 結果としてテキストのコマンドタグが要求されていることを示します。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_STATUS_STRING', 2);

/**
 * pg_result_status から返されます。
 * サーバーに送信された文字列が空でした。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_EMPTY_QUERY', 0);

/**
 * pg_result_status から返されます。
 * コマンドは正常に終了し、何もデータを返しませんでした。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_COMMAND_OK', 1);

/**
 * pg_result_status から返されます。
 * コマンドは正常に終了し、データを返しました
 * （SELECT や SHOW など）。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_TUPLES_OK', 2);

/**
 * pg_result_status から返されます。
 * （サーバーからの）データのコピーが始まりました。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_COPY_OUT', 3);

/**
 * pg_result_status から返されます。
 * （サーバーへの）データのコピーが始まりました。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_COPY_IN', 4);

/**
 * pg_result_status から返されます。
 * サーバーからの応答を判別できませんでした。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_BAD_RESPONSE', 5);

/**
 * pg_result_status から返されます。
 * 致命的ではないエラー（通知や警告など）が発生しました。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_NONFATAL_ERROR', 6);

/**
 * pg_result_status から返されます。
 * 致命的なエラーが発生しました。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_FATAL_ERROR', 7);

/**
 * pg_result_error_field に渡します。
 * 深刻度です。その内容は ERROR、
 * FATAL、あるいは PANIC
 * （エラーメッセージ内）、あるいは WARNING、
 * NOTICE、DEBUG、
 * INFO、あるいは LOG
 * （通知メッセージ内）、あるいはこれらの各国語版のうちのどれかです。
 * 常に存在します。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_DIAG_SEVERITY', 83);

/**
 * pg_result_error_field に渡します。
 * エラーの SQLSTATE コードです。SQLSTATE コードは発生したエラーの種別を
 * 特定します。これは、データベースエラーに対してフロントエンドの
 * アプリケーションが適切な操作（エラー処理など）をできるようにするために
 * 使用されます。このフィールドはローカライズされていません。また、
 * 常に存在します。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_DIAG_SQLSTATE', 67);

/**
 * pg_result_error_field に渡します。
 * 人間が判読できる最初のエラーメッセージ（たいてい 1 行）です。常に存在します。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_DIAG_MESSAGE_PRIMARY', 77);

/**
 * pg_result_error_field に渡します。
 * オプションの 2 番目のエラーメッセージで、問題に対する詳細な情報を
 * 含みます。複数行にまたがることもあります。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_DIAG_MESSAGE_DETAIL', 68);

/**
 * pg_result_error_field に渡します。
 * オプションのメッセージで、問題に対してどのように対応すべきかを指摘
 * します。エラーの詳細情報と違う点は、発生した事実ではなくアドバイス
 * （時に不適切な場合もある）をするところです。複数行にまたがることも
 * あります。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_DIAG_MESSAGE_HINT', 72);

/**
 * pg_result_error_field に渡します。
 * エラーカーソルの位置を、もとのステートメント中の位置として表す
 * 整数値を保持する文字列です。
 * 最初の文字の位置は 1 で、それ以降（バイト数ではなく）文字数で
 * 位置を数えます。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_DIAG_STATEMENT_POSITION', 80);

/**
 * pg_result_error_field に渡します。
 * PG_DIAG_STATEMENT_POSITION と同じ定義ですが、
 * こちらはカーソル位置が内部で生成されたコマンドを参照している場合に
 * 使用されます。このフィールドが存在する場合は、常に
 * PG_DIAG_INTERNAL_QUERY フィールドも存在します。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_DIAG_INTERNAL_POSITION', 112);

/**
 * pg_result_error_field に渡します。
 * 失敗した内部生成コマンドのテキストです。例としては、PL/pgSQL 関数で
 * 発行された SQL クエリなどがあてはまります。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_DIAG_INTERNAL_QUERY', 113);

/**
 * pg_result_error_field に渡します。
 * エラーが発生した状況を指定します。現在ここに含まれているのは、
 * アクティブなプロシージャの関数や内部生成クエリのコール履歴です。
 * これはエントリごとに 1 行のデータとなっており、直近のデータが
 * 先頭にきます。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_DIAG_CONTEXT', 87);

/**
 * pg_result_error_field に渡します。
 * エラーが報告された箇所の、PostgreSQL ソースコードでのファイル名です。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_DIAG_SOURCE_FILE', 70);

/**
 * pg_result_error_field に渡します。
 * エラーが報告された箇所の、PostgreSQL ソースコードでの行番号です。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_DIAG_SOURCE_LINE', 76);

/**
 * pg_result_error_field に渡します。
 * エラーが報告された箇所の、PostgreSQL ソースコードでの関数名です。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_DIAG_SOURCE_FUNCTION', 82);

/**
 * pg_convert に渡します。
 * 変換時に、テーブルのデフォルト値を無視します。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_CONV_IGNORE_DEFAULT', 2);

/**
 * pg_convert に渡します。
 * 空文字列に対して、SQL の NULL を使用します。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_CONV_FORCE_NULL', 4);

/**
 * pg_convert に渡します。
 * NULL を SQL の NOT NULL に変換しないように
 * します。
 * @link http://www.php.net/manual/ja/pgsql.constants.php
 */
define ('PGSQL_CONV_IGNORE_NOT_NULL', 8);
define ('PGSQL_DML_NO_CONV', 256);
define ('PGSQL_DML_EXEC', 512);
define ('PGSQL_DML_ASYNC', 1024);
define ('PGSQL_DML_STRING', 2048);

// End of pgsql v.
?>
