<?php

// Start of gettext v.

/**
 * デフォルトドメインを設定する
 * @link http://www.php.net/manual/ja/function.textdomain.php
 * @param text_domain string <p>
 * 新しいメッセージドメイン。NULL を指定すると、現在の設定をそのまま
 * 取得し、変更しません。
 * </p>
 * @return string 成功すると、この関数はドメインを変更した後に現在のメッセージドメインを
 * 返します。
 */
function textdomain ($text_domain) {}

/**
 * 現在のドメインのメッセージを参照する
 * @link http://www.php.net/manual/ja/function.gettext.php
 * @param message string <p>
 * 翻訳するメッセージ。
 * </p>
 * @return string 翻訳テーブルに翻訳文字列が見つかった場合にその文字列、
 * あるいは見つからなかった場合に元の文字列を返します。
 */
function gettext ($message) {}

/**
 * @param msgid
 */
function _ ($msgid) {}

/**
 * 現在のドメインを上書きする
 * @link http://www.php.net/manual/ja/function.dgettext.php
 * @param domain string <p>
 * ドメイン。
 * </p>
 * @param message string <p>
 * メッセージ。
 * </p>
 * @return string 成功した場合に文字列を返します。
 */
function dgettext ($domain, $message) {}

/**
 * 単一の参照に関するドメインを上書きする
 * @link http://www.php.net/manual/ja/function.dcgettext.php
 * @param domain string <p>
 * ドメイン。
 * </p>
 * @param message string <p>
 * メッセージ。
 * </p>
 * @param category int <p>
 * カテゴリ。
 * </p>
 * @return string 成功した場合に文字列を返します。
 */
function dcgettext ($domain, $message, $category) {}

/**
 * ドメインのパスを設定する
 * @link http://www.php.net/manual/ja/function.bindtextdomain.php
 * @param domain string <p>
 * ドメイン。
 * </p>
 * @param directory string <p>
 * ディレクトリのパス。
 * </p>
 * @return string 現在設定されているドメインへのフルパスを返します。
 */
function bindtextdomain ($domain, $directory) {}

/**
 * gettext の複数形版
 * @link http://www.php.net/manual/ja/function.ngettext.php
 * @param msgid1 string <p>
 * </p>
 * @param msgid2 string <p>
 * </p>
 * @param n int <p>
 * </p>
 * @return string msgid1 および msgid2
 * で表されるメッセージの、数 n
 * に対応する複数形を返します。
 */
function ngettext ($msgid1, $msgid2, $n) {}

/**
 * dgettext の複数形版
 * @link http://www.php.net/manual/ja/function.dngettext.php
 * @param domain string <p>
 * ドメイン。
 * </p>
 * @param msgid1 string <p>
 * </p>
 * @param msgid2 string <p>
 * </p>
 * @param n int <p>
 * </p>
 * @return string 成功した場合に文字列を返します。
 */
function dngettext ($domain, $msgid1, $msgid2, $n) {}

/**
 * dcgettext の複数形版
 * @link http://www.php.net/manual/ja/function.dcngettext.php
 * @param domain string <p>
 * ドメイン。
 * </p>
 * @param msgid1 string <p>
 * </p>
 * @param msgid2 string <p>
 * </p>
 * @param n int <p>
 * </p>
 * @param category int <p>
 * </p>
 * @return string 成功した場合に文字列を返します。
 */
function dcngettext ($domain, $msgid1, $msgid2, $n, $category) {}

/**
 * DOMAIN メッセージカタログから返されるメッセージの文字エンコーディングを指定する
 * @link http://www.php.net/manual/ja/function.bind-textdomain-codeset.php
 * @param domain string <p>
 * ドメイン。
 * </p>
 * @param codeset string <p>
 * コードセット。
 * </p>
 * @return string 成功した場合に文字列を返します。
 */
function bind_textdomain_codeset ($domain, $codeset) {}

// End of gettext v.
?>
