<?php

// Start of gmp v.

/**
 * GMP 数を作成する
 * @link http://www.php.net/manual/ja/function.gmp-init.php
 * @param number mixed <p>
 * 整数値あるいは文字列。文字列表現には、
 * 十進数か十六進数、あるいは八進数を使用可能です。
 * </p>
 * @param base int[optional] <p>
 * 基数。
 * </p>
 * <p>
 * 基数には 2 から 36 までの値を指定することができます。
 * 基数を 0 (デフォルト値) にすると、最初の文字に応じて実際の基数を決定します。
 * 最初の二文字が 0x あるいは 0X
 * の場合は十六進数、それ以外で最初の文字が "0" の場合は八進数、
 * それ以外の場合は十進数となります。
 * </p>
 * @return resource GMP 数リソースを返します。
 */
function gmp_init ($number, $base = null) {}

/**
 * GMP 数を整数に変換する
 * @link http://www.php.net/manual/ja/function.gmp-intval.php
 * @param gmpnumber resource <p>
 * GMP 数。
 * </p>
 * @return int gmpnumber を整数に変換した結果を返します。
 */
function gmp_intval ($gmpnumber) {}

/**
 * GMP 数を文字列に変換する
 * @link http://www.php.net/manual/ja/function.gmp-strval.php
 * @param gmpnumber resource <p>
 * 文字列の変換したい GMP 数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param base int[optional] <p>
 * 返り値の基数。デフォルトは 10 です。
 * 基数として使用可能な値は 2 から 62 までおよび -2 から -36 までです。
 * </p>
 * @return string 数を文字列で表したものを返します。
 */
function gmp_strval ($gmpnumber, $base = null) {}

/**
 * 数値を加算する
 * @link http://www.php.net/manual/ja/function.gmp-add.php
 * @param a resource <p>
 * 足される数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param b resource <p>
 * 足す数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource 加算の結果を GMP 数で返します。
 */
function gmp_add ($a, $b) {}

/**
 * 数値の減算
 * @link http://www.php.net/manual/ja/function.gmp-sub.php
 * @param a resource <p>
 * 引かれる数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param b resource <p>
 * a から引く数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource GMP 数リソースを返します。
 */
function gmp_sub ($a, $b) {}

/**
 * 数値を乗算する
 * @link http://www.php.net/manual/ja/function.gmp-mul.php
 * @param a resource <p>
 * b を掛けられる数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param b resource <p>
 * a に掛ける数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource GMP 数リソースを返します。
 */
function gmp_mul ($a, $b) {}

/**
 * 除算を行い、商と余りを得る
 * @link http://www.php.net/manual/ja/function.gmp-div-qr.php
 * @param n resource <p>
 * 割られる数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param d resource <p>
 * n を割る数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param round int[optional] <p>
 * 引数 round の説明については、
 * gmp_div_q 関数を参照ください。
 * </p>
 * @return array 配列を返します。配列の最初の要素は
 * [n/d] (割算の結果の整数値)、2 番目の要素は
 * (n - [n/d] * d) (割算の余り) です。
 */
function gmp_div_qr ($n, $d, $round = null) {}

/**
 * 数値を除算する
 * @link http://www.php.net/manual/ja/function.gmp-div-q.php
 * @param a resource <p>
 * 割られる数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param b resource <p>
 * a を割る数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param round int[optional] <p>
 * 結果の丸め方は round
 * で指定し、次の値を指定可能です。
 * GMP_ROUND_ZERO: 結果は 0 の方に丸められます。
 * @return resource GMP 数リソースを返します。
 */
function gmp_div_q ($a, $b, $round = null) {}

/**
 * 除算の余りを計算する
 * @link http://www.php.net/manual/ja/function.gmp-div-r.php
 * @param n resource <p>
 * 割られる数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param d resource <p>
 * n を割る数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param round int[optional] <p>
 * 引数 round の説明については、関数
 * gmp_div_q を参照ください。
 * </p>
 * @return resource 余りを GMP 数で返します。
 */
function gmp_div_r ($n, $d, $round = null) {}

/**
 * <function>gmp_div_q</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.gmp-div.php
 * @param a
 * @param b
 * @param round[optional]
 */
function gmp_div ($a, $b, $round) {}

/**
 * モジュロ演算
 * @link http://www.php.net/manual/ja/function.gmp-mod.php
 * @param n resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param d resource <p>
 * 法として使用する値。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource GMP 数リソースを返します。
 */
function gmp_mod ($n, $d) {}

/**
 * 正確な除算
 * @link http://www.php.net/manual/ja/function.gmp-divexact.php
 * @param n resource <p>
 * 割られる数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param d resource <p>
 * a を割る数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource GMP 数リソースを返します。
 */
function gmp_divexact ($n, $d) {}

/**
 * 符号を反転する
 * @link http://www.php.net/manual/ja/function.gmp-neg.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource -a を GMP 数で返します。
 */
function gmp_neg ($a) {}

/**
 * 絶対値
 * @link http://www.php.net/manual/ja/function.gmp-abs.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource a の絶対値を GMP 数で返します。
 */
function gmp_abs ($a) {}

/**
 * 階乗
 * @link http://www.php.net/manual/ja/function.gmp-fact.php
 * @param a mixed <p>
 * 階乗を求める数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource GMP 数リソースを返します。
 */
function gmp_fact ($a) {}

/**
 * 平方根を計算する
 * @link http://www.php.net/manual/ja/function.gmp-sqrt.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource 平方根の整数部分を GMP 数で返します。
 */
function gmp_sqrt ($a) {}

/**
 * 余りつきの平方根
 * @link http://www.php.net/manual/ja/function.gmp-sqrtrem.php
 * @param a resource <p>
 * 平方根を計算したい数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return array 最初の要素が a の整数平方根
 * (gmp_sqrtも参照ください)、2 番目の要素が余り
 * (すなわち、a と最初の要素の 2 乗の差)
 * であるような配列を返します。
 */
function gmp_sqrtrem ($a) {}

/**
 * べき乗を計算する
 * @link http://www.php.net/manual/ja/function.gmp-pow.php
 * @param base resource <p>
 * もととなる数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param exp int <p>
 * 正の数で、base
 * を何乗するかを指定します。
 * </p>
 * @return resource べき乗の結果を GMP 数で返します。
 * 0^0 は 1 となります。
 */
function gmp_pow ($base, $exp) {}

/**
 * べき乗とモジュロを計算する
 * @link http://www.php.net/manual/ja/function.gmp-powm.php
 * @param base resource <p>
 * もととなる数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param exp resource <p>
 * 正の数で、base
 * を何乗するかを指定します。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param mod resource <p>
 * モジュロ。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource 結果を GMP 数で返します。
 */
function gmp_powm ($base, $exp, $mod) {}

/**
 * 平方数かどうかを調べる
 * @link http://www.php.net/manual/ja/function.gmp-perfect-square.php
 * @param a resource <p>
 * 平方数かどうかを調べたい数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return bool a が平方数の場合に TRUE、その他の場合に
 * FALSE を返します。
 */
function gmp_perfect_square ($a) {}

/**
 * 数が"おそらく素数"であるかどうかを調べる
 * @link http://www.php.net/manual/ja/function.gmp-prob-prime.php
 * @param a resource <p>
 * 素数かどうかを調べたい数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param reps int[optional] <p>
 * reps の値 (デフォルトは 10) は、5
 * から 10 までです。より大きい値を指定すると、素数でない数を
 * 「おそらく素数である」と誤認識する可能性が小さくなります。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return int この関数が 0 を返す場合、a は確実に素数ではありません。
 * 1 を返す場合、a は「おそらく」
 * 素数です。2 を返す場合、a は確実に素数です。
 */
function gmp_prob_prime ($a, $reps = null) {}

/**
 * 最大公約数を計算する
 * @link http://www.php.net/manual/ja/function.gmp-gcd.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param b resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource a と b
 * の両方を割り切ることができる正の数を GMP 数で返します。
 */
function gmp_gcd ($a, $b) {}

/**
 * 最大公約数と乗数を計算する
 * @link http://www.php.net/manual/ja/function.gmp-gcdext.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param b resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return array GMP 数の配列を返します。
 */
function gmp_gcdext ($a, $b) {}

/**
 * 法による逆
 * @link http://www.php.net/manual/ja/function.gmp-invert.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param b resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource 成功した場合に GMP 数、逆が存在しない場合に FALSE を返します。
 */
function gmp_invert ($a, $b) {}

/**
 * ヤコビ記号
 * @link http://www.php.net/manual/ja/function.gmp-jacobi.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param p resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p> 
 * <p>
 * 正の奇数でなければなりません。
 * </p>
 * @return int GMP 数リソースを返します。
 */
function gmp_jacobi ($a, $p) {}

/**
 * ルジェンドル記号
 * @link http://www.php.net/manual/ja/function.gmp-legendre.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param p resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p> 
 * <p>
 * 正の奇数でなければなりません。
 * </p>
 * @return int GMP 数リソースを返します。
 */
function gmp_legendre ($a, $p) {}

/**
 * 数を比較する
 * @link http://www.php.net/manual/ja/function.gmp-cmp.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param b resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return int a &gt; b の場合に正の値、a = b
 * の場合にゼロ、a &lt; b の場合に負の値を返します。
 */
function gmp_cmp ($a, $b) {}

/**
 * 数の符号
 * @link http://www.php.net/manual/ja/function.gmp-sign.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return int a が正の場合に 1、
 * a が負の場合に -1、そして
 * a がゼロの場合に 0 を返します。
 */
function gmp_sign ($a) {}

/**
 * 乱数を生成する
 * @link http://www.php.net/manual/ja/function.gmp-random.php
 * @param limiter int[optional] <p>
 * リミッタ。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource ランダムな GMP 数を返します。
 */
function gmp_random ($limiter = null) {}

/**
 * ビット AND を計算する
 * @link http://www.php.net/manual/ja/function.gmp-and.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param b resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource ビット AND 演算の結果を GMP 数で返します。
 */
function gmp_and ($a, $b) {}

/**
 * ビット OR を計算する
 * @link http://www.php.net/manual/ja/function.gmp-or.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param b resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource GMP 数リソースを返します。
 */
function gmp_or ($a, $b) {}

/**
 * 1 の補数を計算する
 * @link http://www.php.net/manual/ja/function.gmp-com.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource a についての 1 の補数を GMP 数で返します。
 */
function gmp_com ($a) {}

/**
 * ビット XOR を計算する
 * @link http://www.php.net/manual/ja/function.gmp-xor.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param b resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource GMP 数リソースを返します。
 */
function gmp_xor ($a, $b) {}

/**
 * ビットを設定する
 * @link http://www.php.net/manual/ja/function.gmp-setbit.php
 * @param a resource <p>
 * ビットをセットしたい数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param index int <p>
 * 設定するビット。
 * </p>
 * @param set_clear bool[optional] <p>
 * そのビットを 0
 * または 1 のどちらにするかを定義します。デフォルトで、ビットは 1
 * に設定されます。
 * </p>
 * @return void GMP 数リソースを返します。
 */
function gmp_setbit ($a, $index, $set_clear = null) {}

/**
 * ビットをクリアする
 * @link http://www.php.net/manual/ja/function.gmp-clrbit.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param index int GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return void GMP 数リソースを返します。
 */
function gmp_clrbit ($a, $index) {}

/**
 * 0 を探す
 * @link http://www.php.net/manual/ja/function.gmp-scan0.php
 * @param a resource <p>
 * スキャンする数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param start int <p>
 * 開始するビット。
 * </p>
 * @return int ビットが見つかった場所のインデックスを整数値で返します。
 * インデックスは 0 から始まります。
 */
function gmp_scan0 ($a, $start) {}

/**
 * 1 を探す
 * @link http://www.php.net/manual/ja/function.gmp-scan1.php
 * @param a resource <p>
 * スキャンする数。
 * </p>
 * GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param start int <p>
 * 開始するビット。
 * </p>
 * @return int ビットが見つかった場所のインデックスを整数値で返します。
 * セットされているビットが存在しない場合には -1 を返します。
 */
function gmp_scan1 ($a, $start) {}

/**
 * ビットが設定されているかどうかを調べる
 * @link http://www.php.net/manual/ja/function.gmp-testbit.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @param index int <p>
 * 調べたいビット。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function gmp_testbit ($a, $index) {}

/**
 * セットされているビットの数
 * @link http://www.php.net/manual/ja/function.gmp-popcount.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return int a にセットされているビットの数を返します。
 */
function gmp_popcount ($a) {}

/**
 * ハミング距離
 * @link http://www.php.net/manual/ja/function.gmp-hamdist.php
 * @param a resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p> 
 * <p>
 * 正の数である必要があります。
 * </p>
 * @param b resource GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p> 
 * <p>
 * 正の数である必要があります。
 * </p>
 * @return int GMP 数リソースを返します。
 */
function gmp_hamdist ($a, $b) {}

/**
 * 次の素数を見つける
 * @link http://www.php.net/manual/ja/function.gmp-nextprime.php
 * @param a int GMP 数リソース、
 * あるいは数値に変換可能な数値形式の文字列。</p>
 * @return resource a より大きい次の素数を
 * GMP 数として返します。
 */
function gmp_nextprime ($a) {}

define ('GMP_ROUND_ZERO', 0);
define ('GMP_ROUND_PLUSINF', 1);
define ('GMP_ROUND_MINUSINF', 2);
define ('GMP_MPIR_VERSION', "1.3.1");

/**
 * GMP ライブラリのバージョン。
 * @link http://www.php.net/manual/ja/gmp.constants.php
 */
define ('GMP_VERSION', "4.2.1");

// End of gmp v.
?>
