<?php

// Start of ftp v.

/**
 * FTP 接続をオープンする
 * @link http://www.php.net/manual/ja/function.ftp-connect.php
 * @param host string <p>
 * FTP サーバーのアドレス。このパラメータには、最後のスラッシュや最初の
 * ftp:// をつけてはいけません。
 * </p>
 * @param port int[optional] <p>
 * このパラメータは接続先のポートを指定します。もし指定しなかったり
 * ゼロを指定したりした場合は、デフォルトの FTP ポートである 21
 * が用いられます。
 * </p>
 * @param timeout int[optional] <p>
 * このパラメータは、以降のネットワーク操作時のタイムアウトを指定します。
 * 指定されなかった場合のデフォルト値は 90 秒です。タイムアウトの変更や
 * 参照は、ftp_set_option や
 * ftp_get_option を用いていつでも可能です。
 * </p>
 * @return resource 成功した場合に FTP ストリームを、エラー時に FALSE を返します。
 */
function ftp_connect ($host, $port = null, $timeout = null) {}

/**
 * FTP 接続にログインする
 * @link http://www.php.net/manual/ja/function.ftp-login.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param username string <p>
 * ユーザー名（USER）。
 * </p>
 * @param password string <p>
 * パスワード（PASS）。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 * 失敗した場合は、PHP が警告を発生します。
 */
function ftp_login ($ftp_stream, $username, $password) {}

/**
 * カレントのディレクトリ名を返す
 * @link http://www.php.net/manual/ja/function.ftp-pwd.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @return string カレントのディレクトリ名、またはエラー時には FALSE を返します。
 */
function ftp_pwd ($ftp_stream) {}

/**
 * 親ディレクトリに移動する
 * @link http://www.php.net/manual/ja/function.ftp-cdup.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ftp_cdup ($ftp_stream) {}

/**
 * FTP サーバー上でディレクトリを移動する
 * @link http://www.php.net/manual/ja/function.ftp-chdir.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param directory string <p>
 * 対象となるディレクトリ。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 * ディレクトリの変更に失敗した場合は、PHP は警告を出します。
 */
function ftp_chdir ($ftp_stream, $directory) {}

/**
 * FTP サーバー上でのコマンドの実行をリクエストする
 * @link http://www.php.net/manual/ja/function.ftp-exec.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param command string <p>
 * 実行したいコマンド。
 * </p>
 * @return bool コマンドが成功した（サーバーの応答コードが 200）
 * 場合に TRUE を、それ以外の場合に FALSE を返します。
 */
function ftp_exec ($ftp_stream, $command) {}

/**
 * FTP サーバーに任意のコマンドを送信する
 * @link http://www.php.net/manual/ja/function.ftp-raw.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param command string <p>
 * 実行したいコマンド。
 * </p>
 * @return array サーバーからの応答を文字列の配列で返します。
 * 結果の文字列に対して、何の処理も行いません。また、
 * ftp_raw はそのコマンドが成功したのかどうかを
 * 判断できません。
 */
function ftp_raw ($ftp_stream, $command) {}

/**
 * ディレクトリを作成する
 * @link http://www.php.net/manual/ja/function.ftp-mkdir.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param directory string <p>
 * 作成されるディレクトリの名前。
 * </p>
 * @return string 成功した時には新規に作成したディレクトリ名、エラー時に FALSE
 * を返します。
 */
function ftp_mkdir ($ftp_stream, $directory) {}

/**
 * ディレクトリを削除する
 * @link http://www.php.net/manual/ja/function.ftp-rmdir.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param directory string <p>
 * 削除するディレクトリ。空のディレクトリへの絶対パス
 * または相対パスでなければなりません。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ftp_rmdir ($ftp_stream, $directory) {}

/**
 * FTP 経由でファイルのパーミッションを設定する
 * @link http://www.php.net/manual/ja/function.ftp-chmod.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param mode int <p>
 * 新しいパーミッション。8 進数 で指定します。
 * </p>
 * @param filename string <p>
 * リモートファイル。
 * </p>
 * @return int 成功した場合に新しいパーミッションを、エラー時に FALSE を返します。
 */
function ftp_chmod ($ftp_stream, $mode, $filename) {}

/**
 * アップロードされるファイルのためのスペースを確保する
 * @link http://www.php.net/manual/ja/function.ftp-alloc.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param filesize int <p>
 * 確保したいバイト数。
 * </p>
 * @param result string[optional] <p>
 * もし変数が指定されていた場合、サーバーからの応答テキストの内容の
 * 参照が格納されます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ftp_alloc ($ftp_stream, $filesize, &$result = null) {}

/**
 * 指定したディレクトリのファイルの一覧を返す
 * @link http://www.php.net/manual/ja/function.ftp-nlist.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param directory string <p>
 * 一覧を表示するディレクトリ。このパラメータには引数を含めることができます。
 * 例: ftp_nlist($conn_id, "-la /your/dir");
 * このパラメータはエスケープ処理されません。スペースやその他の文字を含む
 * ファイル名では問題が発生する可能性があることに注意してください。
 * </p>
 * @return array 成功した場合は指定したディレクトリ内のファイル名の配列を、
 * エラー時には FALSE を返します。
 */
function ftp_nlist ($ftp_stream, $directory) {}

/**
 * 指定したディレクトリの詳細なファイル一覧を返す
 * @link http://www.php.net/manual/ja/function.ftp-rawlist.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param directory string <p>
 * ディレクトリのパス。
 * LIST コマンドの引数を含むこともあります。
 * </p>
 * @param recursive bool[optional] <p>
 * TRUE を設定した場合、発行されるコマンドは LIST -R
 * となります。
 * </p>
 * @return array 各要素が 1 行分のテキストに対応する配列を返します。
 * </p>
 * <p>
 * 出力に関する処理は全く行われません。結果の解釈の仕方を定義するために
 * ftp_systype から返されるシステム型 ID 
 * を使用することができます。
 */
function ftp_rawlist ($ftp_stream, $directory, $recursive = null) {}

/**
 * リモート FTP サーバーのシステム型 ID を返す
 * @link http://www.php.net/manual/ja/function.ftp-systype.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @return string リモートシステム型を返します。エラー時には FALSE を返します。
 */
function ftp_systype ($ftp_stream) {}

/**
 * パッシブモードをオンまたはオフにする
 * @link http://www.php.net/manual/ja/function.ftp-pasv.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param pasv bool <p>
 * TRUE, の場合はパッシブモードをオンに、そうでない場合はオフにします。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ftp_pasv ($ftp_stream, $pasv) {}

/**
 * FTP サーバーからファイルをダウンロードする
 * @link http://www.php.net/manual/ja/function.ftp-get.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param local_file string <p>
 * ローカルファイルのパス（ファイルがすでに存在する場合は上書きされます）。
 * </p>
 * @param remote_file string <p>
 * リモートファイルのパス。
 * </p>
 * @param mode int <p>
 * 転送モード。FTP_ASCII または
 * FTP_BINARY のどちらかを指定する必要があります。
 * </p>
 * @param resumepos int[optional] <p>
 * リモートファイルの、ダウンロードを開始する位置。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ftp_get ($ftp_stream, $local_file, $remote_file, $mode, $resumepos = null) {}

/**
 * FTP サーバーからファイルをダウンロードし、オープン中のファイルに保存する
 * @link http://www.php.net/manual/ja/function.ftp-fget.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param handle resource <p>
 * オープンされているファイルのポインタ。ここにデータが保存されます。
 * </p>
 * @param remote_file string <p>
 * リモートファイルのパス。
 * </p>
 * @param mode int <p>
 * 転送モード。FTP_ASCII または
 * FTP_BINARY のどちらかを指定する必要があります。
 * </p>
 * @param resumepos int[optional] <p>
 * リモートファイル中で、ダウンロードを開始する位置。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ftp_fget ($ftp_stream, $handle, $remote_file, $mode, $resumepos = null) {}

/**
 * FTP サーバーにファイルをアップロードする
 * @link http://www.php.net/manual/ja/function.ftp-put.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param remote_file string <p>
 * リモートファイルのパス。
 * </p>
 * @param local_file string <p>
 * ローカルファイルのパス。
 * </p>
 * @param mode int <p>
 * 転送モード。FTP_ASCII または
 * FTP_BINARY のどちらかを指定する必要があります。
 * </p>
 * @param startpos int[optional] <p>リモートファイル内での、アップロード開始位置。</p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ftp_put ($ftp_stream, $remote_file, $local_file, $mode, $startpos = null) {}

/**
 * オープン中のファイルを FTP サーバーにアップロードする
 * @link http://www.php.net/manual/ja/function.ftp-fput.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param remote_file string <p>
 * リモートファイルのパス。
 * </p>
 * @param handle resource <p>
 * ローカルでオープンされているファイルのポインタ。
 * ファイルの終端まで進むと読み込みが終了します。
 * </p>
 * @param mode int <p>
 * 転送モード。FTP_ASCII または
 * FTP_BINARY のどちらかを指定する必要があります。
 * </p>
 * @param startpos int[optional] <p>リモートファイル内での、アップロード開始位置。</p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ftp_fput ($ftp_stream, $remote_file, $handle, $mode, $startpos = null) {}

/**
 * 指定したファイルのサイズを返す
 * @link http://www.php.net/manual/ja/function.ftp-size.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param remote_file string <p>
 * リモートファイル。
 * </p>
 * @return int 成功した場合はファイルのサイズを、エラー時には -1 を返します。
 */
function ftp_size ($ftp_stream, $remote_file) {}

/**
 * 指定したファイルが最後に更新された時刻を返す
 * @link http://www.php.net/manual/ja/function.ftp-mdtm.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param remote_file string <p>
 * 最終更新時刻を取得するファイル。
 * </p>
 * @return int 成功した場合にUNIXのタイムスタンプ、エラー時に -1 を返します。
 */
function ftp_mdtm ($ftp_stream, $remote_file) {}

/**
 * FTP サーバー上のファイルまたはディレクトリの名前を変更する
 * @link http://www.php.net/manual/ja/function.ftp-rename.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param oldname string <p>
 * 現在のファイル/ディレクトリの名前。
 * </p>
 * @param newname string <p>
 * 新しい名前。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ftp_rename ($ftp_stream, $oldname, $newname) {}

/**
 * FTP サーバー上のファイルを削除する
 * @link http://www.php.net/manual/ja/function.ftp-delete.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param path string <p>
 * 削除するファイル。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ftp_delete ($ftp_stream, $path) {}

/**
 * SITEコマンドをサーバーに送信する
 * @link http://www.php.net/manual/ja/function.ftp-site.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param command string <p>
 * SITE コマンド。このパラメータはエスケープされないので、スペースや
 * その他の文字を含むファイル名は問題を引き起こす可能性があることに
 * 注意してください。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ftp_site ($ftp_stream, $command) {}

/**
 * FTP 接続を閉じる
 * @link http://www.php.net/manual/ja/function.ftp-close.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ftp_close ($ftp_stream) {}

/**
 * さまざまな FTP 実行時オプションを設定する
 * @link http://www.php.net/manual/ja/function.ftp-set-option.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param option int <p>
 * 現在、以下のオプションがサポートされています:
 * <table>
 * サポートされる実行時 FTP オプション
 * <tr valign="top">
 * <td>FTP_TIMEOUT_SEC</td>
 * <td>
 * 全てのネットワーク関連関数に関して秒単位でタイムアウトを変更
 * します。valueは、
 * 0 より大きい整数値である必要があります。
 * デフォルトのタイムアウトは90秒です。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>FTP_AUTOSEEK</td>
 * <td>
 * 有効になっている場合は、GET や PUT のリクエストが
 * resumepos や startpos
 * のパラメータ付きで実行されるとファイル中の該当位置をシークします。
 * デフォルトで有効になっています。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @param value mixed <p>
 * このパラメータの内容は、どの option 
 * を変更しようとしているかによって変わります。
 * </p>
 * @return bool オプションが設定できた場合に TRUE 、そうでない場合に FALSE を返します。
 * option がサポートされていなかった場合や
 * option が想定していない値を value
 * に渡した場合は警告メッセージが発生します。
 */
function ftp_set_option ($ftp_stream, $option, $value) {}

/**
 * カレント FTP ストリームでの種々の実行時動作を取得する
 * @link http://www.php.net/manual/ja/function.ftp-get-option.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID
 * </p>
 * @param option int <p>
 * 現在、以下のオプションがサポートされています:
 * <table>
 * サポートされる実行時 FTP オプション
 * <tr valign="top">
 * <td>FTP_TIMEOUT_SEC</td>
 * <td>
 * ネットワーク関連処理で使用されるカレントのタイムアウトを返します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>FTP_AUTOSEEK</td>
 * <td>
 * オプションが設定されている場合に TRUE を、それ以外の場合に
 * FALSE を返します。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @return mixed 成功した場合はその値を、指定した option
 * がサポートされていない場合は FALSE を返します。後者の場合は、
 * 同時に警告メッセージも発生します。
 */
function ftp_get_option ($ftp_stream, $option) {}

/**
 * FTP サーバーからファイルをダウンロードし、オープン中のファイルに保存する（非ブロッキング）
 * @link http://www.php.net/manual/ja/function.ftp-nb-fget.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param handle resource <p>
 * オープンされているファイルのポインタ。ここにデータが保存されます。
 * </p>
 * @param remote_file string <p>
 * リモートファイルのパス。
 * </p>
 * @param mode int <p>
 * 転送モード。FTP_ASCII または
 * FTP_BINARY のどちらかを指定する必要があります。
 * </p>
 * @param resumepos int[optional] <p>ダウンロードを開始する、リモートファイル内の位置。</p>
 * @return int FTP_FAILED、FTP_FINISHED
 * あるいは FTP_MOREDATA を返します。
 */
function ftp_nb_fget ($ftp_stream, $handle, $remote_file, $mode, $resumepos = null) {}

/**
 * FTP サーバーからファイルを取得し、ローカルファイルに書き込む（非ブロッキング）
 * @link http://www.php.net/manual/ja/function.ftp-nb-get.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param local_file string <p>
 * ローカルファイルのパス（ファイルがすでに存在する場合、上書きされます）。
 * </p>
 * @param remote_file string <p>
 * リモートファイルのパス。
 * </p>
 * @param mode int <p>
 * 転送モード。FTP_ASCII または
 * FTP_BINARY のどちらかを指定する必要があります。
 * </p>
 * @param resumepos int[optional] <p>ダウンロードを開始する、リモートファイル内の位置。</p>
 * @return int FTP_FAILED、FTP_FINISHED
 * あるいは FTP_MOREDATA を返します。
 */
function ftp_nb_get ($ftp_stream, $local_file, $remote_file, $mode, $resumepos = null) {}

/**
 * ファイルの取得/送信を継続する（非ブロッキング）
 * @link http://www.php.net/manual/ja/function.ftp-nb-continue.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @return int FTP_FAILED、FTP_FINISHED
 * あるいは FTP_MOREDATA を返します。
 */
function ftp_nb_continue ($ftp_stream) {}

/**
 * FTP サーバーにファイルを保存する（非ブロッキング）
 * @link http://www.php.net/manual/ja/function.ftp-nb-put.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param remote_file string <p>
 * リモートファイルのパス。
 * </p>
 * @param local_file string <p>
 * ローカルファイルのパス。
 * </p>
 * @param mode int <p>
 * 転送モード。FTP_ASCII または
 * FTP_BINARY のどちらかを指定する必要があります。
 * </p>
 * @param startpos int[optional] <p>リモートファイル内での、アップロード開始位置。</p>
 * @return int FTP_FAILED、FTP_FINISHED
 * あるいは FTP_MOREDATA を返します。
 */
function ftp_nb_put ($ftp_stream, $remote_file, $local_file, $mode, $startpos = null) {}

/**
 * オープン中のファイルを FTP サーバーに保存する（非ブロッキング）
 * @link http://www.php.net/manual/ja/function.ftp-nb-fput.php
 * @param ftp_stream resource <p>
 * FTP 接続のリンク ID 。
 * </p>
 * @param remote_file string <p>
 * リモートファイルのパス。
 * </p>
 * @param handle resource <p>
 * ローカルでオープンされているファイルのポインタ。
 * ファイルの終端まで進むと読み込みが終了します。
 * </p>
 * @param mode int <p>
 * 転送モード。FTP_ASCII または
 * FTP_BINARY のどちらかを指定する必要があります。
 * </p>
 * @param startpos int[optional] <p>リモートファイル内での、アップロード開始位置。</p>
 * @return int FTP_FAILED、FTP_FINISHED
 * あるいは FTP_MOREDATA を返します。
 */
function ftp_nb_fput ($ftp_stream, $remote_file, $handle, $mode, $startpos = null) {}

/**
 * <function>ftp_close</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ftp-quit.php
 * @param ftp
 */
function ftp_quit ($ftp) {}


/**
 * <p></p>
 * @link http://www.php.net/manual/ja/ftp.constants.php
 */
define ('FTP_ASCII', 1);

/**
 * <p></p>
 * @link http://www.php.net/manual/ja/ftp.constants.php
 */
define ('FTP_TEXT', 1);

/**
 * <p></p>
 * @link http://www.php.net/manual/ja/ftp.constants.php
 */
define ('FTP_BINARY', 2);

/**
 * <p></p>
 * @link http://www.php.net/manual/ja/ftp.constants.php
 */
define ('FTP_IMAGE', 2);

/**
 * <p>
 * GET および PUT リクエスト用のレジューム位置と開始位置を自動的に
 * 定義します（FTP_AUTOSEEK が有効な場合のみ動作します）。
 * </p>
 * @link http://www.php.net/manual/ja/ftp.constants.php
 */
define ('FTP_AUTORESUME', -1);

/**
 * <p>
 * 詳細は、ftp_set_option を参照ください。
 * </p>
 * @link http://www.php.net/manual/ja/ftp.constants.php
 */
define ('FTP_TIMEOUT_SEC', 0);

/**
 * <p>
 * 詳細は、ftp_set_option を参照してください。
 * </p>
 * @link http://www.php.net/manual/ja/ftp.constants.php
 */
define ('FTP_AUTOSEEK', 1);

/**
 * <p>
 * 非同期伝送が失敗しました。
 * </p>
 * @link http://www.php.net/manual/ja/ftp.constants.php
 */
define ('FTP_FAILED', 0);

/**
 * <p>
 * 非同期伝送が終了しました。
 * </p>
 * @link http://www.php.net/manual/ja/ftp.constants.php
 */
define ('FTP_FINISHED', 1);

/**
 * <p>
 * 非同期伝送がまだアクティブです。
 * </p>
 * @link http://www.php.net/manual/ja/ftp.constants.php
 */
define ('FTP_MOREDATA', 2);

// End of ftp v.
?>
