<?php

// Start of xsl v.0.1

class XSLTProcessor  {

	/**
	 * スタイルシートを取り込む
	 * @link http://www.php.net/manual/ja/xsltprocessor.importstylesheet.php
	 * @param stylesheet object <p>
	 * 取り込まれるスタイルシートを DOMDocument
	 * オブジェクトあるいは SimpleXMLElement
	 * オブジェクトとして指定します。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function importStylesheet ($stylesheet) {}

	/**
	 * DOMDocument に変換する
	 * @link http://www.php.net/manual/ja/xsltprocessor.transformtodoc.php
	 * @param doc DOMNode <p>
	 * 変換されるノードを指定します。
	 * </p>
	 * @return DOMDocument 結果の DOMDocument 。
	 * エラーが発生した場合は FALSE 。
	 */
	public function transformToDoc (DOMNode $doc) {}

	/**
	 * URI に変換する
	 * @link http://www.php.net/manual/ja/xsltprocessor.transformtouri.php
	 * @param doc DOMDocument <p>
	 * 変換する文章を指定します。
	 * </p>
	 * @param uri string <p>
	 * 変換先の URI。
	 * </p>
	 * @return int 書き込まれたバイト数。エラーが発生した場合は FALSE 。
	 */
	public function transformToUri (DOMDocument $doc, $uri) {}

	/**
	 * XML に変換する
	 * @link http://www.php.net/manual/ja/xsltprocessor.transformtoxml.php
	 * @param doc DOMDocument <p>
	 * 変換されるノードを指定します。
	 * </p>
	 * @return string 変換結果の文字列。エラーが発生した場合は FALSE 。
	 */
	public function transformToXml (DOMDocument $doc) {}

	/**
	 * パラメータの値を設定する
	 * @link http://www.php.net/manual/ja/xsltprocessor.setparameter.php
	 * @param namespace string <p>
	 * XSLT パラメータの名前空間 URI を指定します。
	 * </p>
	 * @param name string <p>
	 * XSLT パラメータのローカル名を指定します。
	 * </p>
	 * @param value string <p>
	 * XSLT パラメータの新しい値を指定します。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setParameter ($namespace, $name, $value) {}

	/**
	 * パラメータの値を取得する
	 * @link http://www.php.net/manual/ja/xsltprocessor.getparameter.php
	 * @param namespaceURI string <p>
	 * XSLT パラメータの名前空間 URI を指定します。
	 * </p>
	 * @param localName string <p>
	 * XSLT パラメータのローカル名を指定します。
	 * </p>
	 * @return string パラメータの値 (文字列)、あるいは設定されていない場合は FALSE を返します。
	 */
	public function getParameter ($namespaceURI, $localName) {}

	/**
	 * パラメータを削除する
	 * @link http://www.php.net/manual/ja/xsltprocessor.removeparameter.php
	 * @param namespaceURI string <p>
	 * XSLT パラメータの名前空間 URI を指定します。
	 * </p>
	 * @param localName string <p>
	 * XSLT パラメータのローカル名を指定します。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function removeParameter ($namespaceURI, $localName) {}

	/**
	 * PHP が EXSLT をサポートしているかどうかを判定する
	 * @link http://www.php.net/manual/ja/xsltprocessor.hasexsltsupport.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function hasExsltSupport () {}

	/**
	 * PHP 関数を XSLT 関数として利用できるようにする
	 * @link http://www.php.net/manual/ja/xsltprocessor.registerphpfunctions.php
	 * @param restrict mixed[optional] <p>
	 * このパラメータは、XSLT からコールされる信頼できる関数のみを許可します。
	 * </p>
	 * <p>
	 * このパラメータには文字列 (関数名)
	 * あるいは関数の配列のいずれかを指定します。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function registerPHPFunctions ($restrict = null) {}

	/**
	 * プロファイル情報の出力ファイルを設定する
	 * @link http://www.php.net/manual/ja/xsltprocessor.setprofiling.php
	 * @param filename string <p>
	 * プロファイル情報を出力するファイルへのパス。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setProfiling ($filename) {}

	/**
	 * セキュリティ設定の指定する
	 * @link http://www.php.net/manual/ja/xsltprocessor.setsecurityprefs.php
	 * @param securityPrefs int 
	 * @return int 
	 */
	public function setSecurityPrefs ($securityPrefs) {}

	/**
	 * セキュリティ設定を取得する
	 * @link http://www.php.net/manual/ja/xsltprocessor.getsecurityprefs.php
	 * @return int 
	 */
	public function getSecurityPrefs () {}

}
define ('XSL_CLONE_AUTO', 0);
define ('XSL_CLONE_NEVER', -1);
define ('XSL_CLONE_ALWAYS', 1);
define ('XSL_SECPREF_NONE', 0);
define ('XSL_SECPREF_READ_FILE', 2);
define ('XSL_SECPREF_WRITE_FILE', 4);
define ('XSL_SECPREF_CREATE_DIRECTORY', 8);
define ('XSL_SECPREF_READ_NETWORK', 16);
define ('XSL_SECPREF_WRITE_NETWORK', 32);
define ('XSL_SECPREF_DEFAULT', 44);

/**
 * libxslt のバージョンを 10117 のように表します。PHP 5.1.2 以降で使用可能です。
 * @link http://www.php.net/manual/ja/xsl.constants.php
 */
define ('LIBXSLT_VERSION', 10127);

/**
 * libxslt のバージョンを 1.1.17 のように表します。PHP 5.1.2 以降で使用可能です。
 * @link http://www.php.net/manual/ja/xsl.constants.php
 */
define ('LIBXSLT_DOTTED_VERSION', "1.1.27");

/**
 * libexslt のバージョンを 813 のように表します。PHP 5.1.2 以降で使用可能です。
 * @link http://www.php.net/manual/ja/xsl.constants.php
 */
define ('LIBEXSLT_VERSION', 816);

/**
 * libexslt のバージョンを 1.1.17 のように表します。PHP 5.1.2 以降で使用可能です。
 * @link http://www.php.net/manual/ja/xsl.constants.php
 */
define ('LIBEXSLT_DOTTED_VERSION', "0.8.16");

// End of xsl v.0.1
?>
