<?php

// Start of soap v.

class SoapClient  {

	/**
	 * SoapClient コンストラクタ
	 * @link http://www.php.net/manual/ja/soapclient.soapclient.php
	 * @param wsdl
	 * @param options[optional]
	 */
	public function SoapClient ($wsdl, $options) {}

	/**
	 * SOAP 関数をコールする (非推奨)
	 * @link http://www.php.net/manual/ja/soapclient.call.php
	 * @param function_name string 
	 * @param arguments string 
	 * @return mixed 
	 */
	public function __call ($function_name, $arguments) {}

	/**
	 * SOAP 関数をコールする
	 * @link http://www.php.net/manual/ja/soapclient.soapcall.php
	 * @param function_name string <p>
	 * コールしたい SOAP 関数の名前。
	 * </p>
	 * @param arguments array <p>
	 * 関数に渡す引数の配列。これは、数値添字配列あるいは連想配列のどちらの形式でもかまいません。
	 * たいていの SOAP サーバーは、パラメータ名を指定しないといけないことに注意しましょう。
	 * そんな場合は、連想配列でないといけません。
	 * </p>
	 * @param options array[optional] <p>
	 * クライアントに渡すオプションの連想配列。
	 * </p>
	 * <p>
	 * location はリモートウェブサービスの URL です。
	 * </p>
	 * <p>
	 * uri は SOAP サービスのターゲット名前空間です。
	 * </p>
	 * <p>
	 * soapaction はコールしたいアクションです。
	 * </p>
	 * @param input_headers mixed[optional] <p>
	 * SOAP リクエストで送信するヘッダの配列。
	 * </p>
	 * @param output_headers array[optional] <p>
	 * 指定すると、この配列に SOAP レスポンスのヘッダが書き込まれます。
	 * </p>
	 * @return mixed SOAP 関数は、一つまたは複数の値を返す可能性があります。
	 * SOAP 関数によって返される値が 1 つだけの場合、__soapCall
	 * の返す値は単純な値 (例えば、整数型、文字列など) になります。
	 * 複数の値が返される場合、__soapCall
	 * は出力パラメータの名前を連想配列として返します。
	 * </p>
	 * <p>
	 * エラーの場合は、SoapClient オブジェクトの作成時に exceptions
	 * オプションが FALSE となっていれば SoapFault オブジェクトを返します。
	 */
	public function __soapCall ($function_name, array $arguments, array $options = null, $input_headers = null, array &$output_headers = null) {}

	/**
	 * 直近の SOAP リクエストを返す
	 * @link http://www.php.net/manual/ja/soapclient.getlastrequest.php
	 * @return string 直近の SOAP リクエストを XML 文字列で返します。
	 */
	public function __getLastRequest () {}

	/**
	 * 直近の SOAP レスポンスを返す
	 * @link http://www.php.net/manual/ja/soapclient.getlastresponse.php
	 * @return string 直近の SOAP レスポンスを XML 文字列で返します。
	 */
	public function __getLastResponse () {}

	/**
	 * 直近の SOAP リクエストヘッダを返す
	 * @link http://www.php.net/manual/ja/soapclient.getlastrequestheaders.php
	 * @return string 直近の SOAP リクエストヘッダ
	 */
	public function __getLastRequestHeaders () {}

	/**
	 * 直近の SOAP レスポンスヘッダを返す
	 * @link http://www.php.net/manual/ja/soapclient.getlastresponseheaders.php
	 * @return string 直近の SOAP レスポンスヘッダ
	 */
	public function __getLastResponseHeaders () {}

	/**
	 * SOAP 関数の一覧を返す
	 * @link http://www.php.net/manual/ja/soapclient.getfunctions.php
	 * @return array SOAP 関数のプロトタイプ、返り値の型、関数名、型ヒントつきパラメータの配列を返します。
	 */
	public function __getFunctions () {}

	/**
	 * SOAP 型の一覧を返す
	 * @link http://www.php.net/manual/ja/soapclient.gettypes.php
	 * @return array SOAP 型の配列を返します。すべての構造や型が含まれています。
	 */
	public function __getTypes () {}

	/**
	 * SOAP リクエストを実行する
	 * @link http://www.php.net/manual/ja/soapclient.dorequest.php
	 * @param request string <p>
	 * XML SOAP リクエスト
	 * </p>
	 * @param location string <p>
	 * リクエスト先の URL
	 * </p>
	 * @param action string <p>
	 * SOAP アクション
	 * </p>
	 * @param version int <p>
	 * SOAP バージョン
	 * </p>
	 * @param one_way int[optional] <p>
	 * one_way に 1 を設定すると、このメソッドは何も返しません。
	 * レスポンスが不要なときにこれを使用します。
	 * </p>
	 * @return string XML SOAP レスポンス
	 */
	public function __doRequest ($request, $location, $action, $version, $one_way = null) {}

	/**
	 * SOAP リクエストと共に送信されるクッキーを設定する
	 * @link http://www.php.net/manual/ja/soapclient.setcookie.php
	 * @param name string <p>
	 * クッキーの名前
	 * </p>
	 * @param value string[optional] <p>
	 * クッキーの値。指定されない場合、クッキーは削除されます。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function __setCookie ($name, $value = null) {}

	/**
	 * 使用するウェブサービスの場所を設定する
	 * @link http://www.php.net/manual/ja/soapclient.setlocation.php
	 * @param new_location string[optional] <p>
	 * 新しいエンドポイント URL。
	 * </p>
	 * @return string それまでのエンドポイント URL を返します。
	 */
	public function __setLocation ($new_location = null) {}

	/**
	 * 以降のコール用の SOAP ヘッダを設定する
	 * @link http://www.php.net/manual/ja/soapclient.setsoapheaders.php
	 * @param soapheaders mixed[optional] <p>
	 * 設定したいヘッダ。SoapHeader
	 * オブジェクト、あるいは SoapHeader オブジェクトの配列です。
	 * 省略したり NULL を設定したりした場合はヘッダが削除されます。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function __setSoapHeaders ($soapheaders = null) {}

}

class SoapVar  {

	/**
	 * SoapVar コンストラクタ
	 * @link http://www.php.net/manual/ja/soapvar.soapvar.php
	 * @param data
	 * @param encoding
	 * @param type_name[optional]
	 * @param type_namespace[optional]
	 * @param node_name[optional]
	 * @param node_namespace[optional]
	 */
	public function SoapVar ($data, $encoding, $type_name, $type_namespace, $node_name, $node_namespace) {}

}

class SoapServer  {

	/**
	 * SoapServer コンストラクタ
	 * @link http://www.php.net/manual/ja/soapserver.soapserver.php
	 * @param wsdl
	 * @param options[optional]
	 */
	public function SoapServer ($wsdl, $options) {}

	/**
	 * SoapServer の持続モードを設定する
	 * @link http://www.php.net/manual/ja/soapserver.setpersistence.php
	 * @param mode int <p>
	 * SOAP_PERSISTENCE_XXX 定数のうちの一つ
	 * </p>
	 * <p>
	 * SOAP_PERSISTENCE_REQUEST - SoapServer のデータはリクエスト間で持続しません。
	 * これは、SoapServer オブジェクトで setClass をコールした直後のデフォルトの挙動です。
	 * </p>
	 * <p>
	 * SOAP_PERSISTENCE_SESSION - SoapServer のデータをリクエスト間で持続させます。
	 * これを実現するために、SoapServer クラスのデータをシリアライズして
	 * $_SESSION['_bogus_session_name'] に格納します。
	 * そのため、このモードを設定する前に
	 * session_start をコールしておく必要があります。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setPersistence ($mode) {}

	/**
	 * SOAP リクエストを処理するクラスを設定する
	 * @link http://www.php.net/manual/ja/soapserver.setclass.php
	 * @param class_name string <p>
	 * エクスポートするクラス名
	 * </p>
	 * @param args mixed[optional] <p>
	 * これらのオプションパラメータは、
	 * オブジェクト作成時にデフォルトのクラスコンストラクタに渡されます。
	 * </p>
	 * @param _ mixed[optional] 
	 * @return void 値を返しません。
	 */
	public function setClass ($class_name, $args = null, $_ = null) {}

	/**
	 * SOAP リクエストの処理に使用するオブジェクトを設定する
	 * @link http://www.php.net/manual/ja/soapserver.setobject.php
	 * @param object object <p>
	 * リクエストを処理するオブジェクト。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setObject ($object) {}

	/**
	 * SOAP リクエストによって処理される単一もしくはいくつかの関数を追加する
	 * @link http://www.php.net/manual/ja/soapserver.addfunction.php
	 * @param functions mixed <p>
	 * 単一の関数をエクスポートするには、
	 * このパラメータに文字列として関数名を渡してください。
	 * </p>
	 * <p>
	 * いくつかの関数をエクスポートするには、関数名の配列を渡してください。
	 * </p>
	 * <p>
	 * 全ての関数をエクスポートする場合、特別な定数
	 * SOAP_FUNCTIONS_ALL
	 * を渡してください。
	 * </p>
	 * <p>
	 * functions は、全ての入力引数を
	 * WSDL ファイルで定義されている順序と同じ順序で受け取る必要があり
	 * (これらの関数は出力パラメータを引数として受け取ることはありません)
	 * 、一つまたは複数の値を返す必要があります。
	 * 複数の値を返すには、名前付き出力パラメータの配列を返す必要があります。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function addFunction ($functions) {}

	/**
	 * 定義されている関数の一覧を返す
	 * @link http://www.php.net/manual/ja/soapserver.getfunctions.php
	 * @return array 定義されている関数の配列を返します。
	 */
	public function getFunctions () {}

	/**
	 * SOAP リクエストを処理する
	 * @link http://www.php.net/manual/ja/soapserver.handle.php
	 * @param soap_request string[optional] <p>
	 * SOAP リクエスト。もし引数が省略された場合、
	 * HTTP リクエストで POST されたデータの中にリクエストがあるとみなします。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function handle ($soap_request = null) {}

	/**
	 * エラーを示す SoapServer フォールト を発行する
	 * @link http://www.php.net/manual/ja/soapserver.fault.php
	 * @param code string <p>
	 * 返したいエラーコード。
	 * </p>
	 * @param string string <p>
	 * エラーについての簡単な説明。
	 * </p>
	 * @param actor string[optional] <p>
	 * フォールトを引き起こしたアクターをあらわす文字列。
	 * </p>
	 * @param details string[optional] <p>
	 * フォールトについての詳細。
	 * </p>
	 * @param name string[optional] <p>
	 * フォールトの名前。これは WSDL ファイルにある名前を使うことができます。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function fault ($code, $string, $actor = null, $details = null, $name = null) {}

	/**
	 * SOAP ヘッダをレスポンスに追加する
	 * @link http://www.php.net/manual/ja/soapserver.addsoapheader.php
	 * @param object SoapHeader <p>
	 * 返すヘッダ。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function addSoapHeader (SoapHeader $object) {}

}

class SoapFault extends Exception  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;


	/**
	 * SoapFault コンストラクタ
	 * @link http://www.php.net/manual/ja/soapfault.soapfault.php
	 * @param faultcode
	 * @param faultstring
	 * @param faultactor[optional]
	 * @param detail[optional]
	 * @param faultname[optional]
	 * @param headerfault[optional]
	 */
	public function SoapFault ($faultcode, $faultstring, $faultactor, $detail, $faultname, $headerfault) {}

	/**
	 * SoapFault の文字列表現を取得する
	 * @link http://www.php.net/manual/ja/soapfault.tostring.php
	 * @return string SoapFault を文字列であらわした内容を返します。
	 */
	public function __toString () {}

	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

}

class SoapParam  {

	/**
	 * SoapParam コンストラクタ
	 * @link http://www.php.net/manual/ja/soapparam.soapparam.php
	 * @param data
	 * @param name
	 */
	public function SoapParam ($data, $name) {}

}

class SoapHeader  {

	/**
	 * SoapHeader コンストラクタ
	 * @link http://www.php.net/manual/ja/soapheader.soapheader.php
	 * @param namespace
	 * @param name
	 * @param data[optional]
	 * @param mustunderstand[optional]
	 * @param actor[optional]
	 */
	public function SoapHeader ($namespace, $name, $data, $mustunderstand, $actor) {}

}

/**
 * SOAP エラーハンドラを使用するかどうかを設定する
 * @link http://www.php.net/manual/ja/function.use-soap-error-handler.php
 * @param handler bool[optional] <p>
 * TRUE に設定すると、エラーの詳細をクライアントに送信します。
 * </p>
 * @return bool 元の値を返します。
 */
function use_soap_error_handler ($handler = null) {}

/**
 * SOAP コールが失敗したかどうかを調べる
 * @link http://www.php.net/manual/ja/function.is-soap-fault.php
 * @param object mixed <p>
 * 検査するオブジェクト
 * </p>
 * @return bool エラー時に TRUE、それ以外の場合に FALSE を返します。
 */
function is_soap_fault ($object) {}

define ('SOAP_1_1', 1);
define ('SOAP_1_2', 2);
define ('SOAP_PERSISTENCE_SESSION', 1);
define ('SOAP_PERSISTENCE_REQUEST', 2);
define ('SOAP_FUNCTIONS_ALL', 999);
define ('SOAP_ENCODED', 1);
define ('SOAP_LITERAL', 2);
define ('SOAP_RPC', 1);
define ('SOAP_DOCUMENT', 2);
define ('SOAP_ACTOR_NEXT', 1);
define ('SOAP_ACTOR_NONE', 2);
define ('SOAP_ACTOR_UNLIMATERECEIVER', 3);
define ('SOAP_COMPRESSION_ACCEPT', 32);
define ('SOAP_COMPRESSION_GZIP', 0);
define ('SOAP_COMPRESSION_DEFLATE', 16);
define ('SOAP_AUTHENTICATION_BASIC', 0);
define ('SOAP_AUTHENTICATION_DIGEST', 1);
define ('UNKNOWN_TYPE', 999998);
define ('XSD_STRING', 101);
define ('XSD_BOOLEAN', 102);
define ('XSD_DECIMAL', 103);
define ('XSD_FLOAT', 104);
define ('XSD_DOUBLE', 105);
define ('XSD_DURATION', 106);
define ('XSD_DATETIME', 107);
define ('XSD_TIME', 108);
define ('XSD_DATE', 109);
define ('XSD_GYEARMONTH', 110);
define ('XSD_GYEAR', 111);
define ('XSD_GMONTHDAY', 112);
define ('XSD_GDAY', 113);
define ('XSD_GMONTH', 114);
define ('XSD_HEXBINARY', 115);
define ('XSD_BASE64BINARY', 116);
define ('XSD_ANYURI', 117);
define ('XSD_QNAME', 118);
define ('XSD_NOTATION', 119);
define ('XSD_NORMALIZEDSTRING', 120);
define ('XSD_TOKEN', 121);
define ('XSD_LANGUAGE', 122);
define ('XSD_NMTOKEN', 123);
define ('XSD_NAME', 124);
define ('XSD_NCNAME', 125);
define ('XSD_ID', 126);
define ('XSD_IDREF', 127);
define ('XSD_IDREFS', 128);
define ('XSD_ENTITY', 129);
define ('XSD_ENTITIES', 130);
define ('XSD_INTEGER', 131);
define ('XSD_NONPOSITIVEINTEGER', 132);
define ('XSD_NEGATIVEINTEGER', 133);
define ('XSD_LONG', 134);
define ('XSD_INT', 135);
define ('XSD_SHORT', 136);
define ('XSD_BYTE', 137);
define ('XSD_NONNEGATIVEINTEGER', 138);
define ('XSD_UNSIGNEDLONG', 139);
define ('XSD_UNSIGNEDINT', 140);
define ('XSD_UNSIGNEDSHORT', 141);
define ('XSD_UNSIGNEDBYTE', 142);
define ('XSD_POSITIVEINTEGER', 143);
define ('XSD_NMTOKENS', 144);
define ('XSD_ANYTYPE', 145);
define ('XSD_ANYXML', 147);
define ('APACHE_MAP', 200);
define ('SOAP_ENC_OBJECT', 301);
define ('SOAP_ENC_ARRAY', 300);
define ('XSD_1999_TIMEINSTANT', 401);
define ('XSD_NAMESPACE', "http://www.w3.org/2001/XMLSchema");
define ('XSD_1999_NAMESPACE', "http://www.w3.org/1999/XMLSchema");
define ('SOAP_SINGLE_ELEMENT_ARRAYS', 1);
define ('SOAP_WAIT_ONE_WAY_CALLS', 2);
define ('SOAP_USE_XSI_ARRAY_TYPE', 4);
define ('WSDL_CACHE_NONE', 0);
define ('WSDL_CACHE_DISK', 1);
define ('WSDL_CACHE_MEMORY', 2);
define ('WSDL_CACHE_BOTH', 3);

// End of soap v.
?>
