<?php

// Start of zip v.1.11.0

class ZipArchive  {
	const CREATE = 1;
	const EXCL = 2;
	const CHECKCONS = 4;
	const OVERWRITE = 8;
	const FL_NOCASE = 1;
	const FL_NODIR = 2;
	const FL_COMPRESSED = 4;
	const FL_UNCHANGED = 8;
	const CM_DEFAULT = -1;
	const CM_STORE = 0;
	const CM_SHRINK = 1;
	const CM_REDUCE_1 = 2;
	const CM_REDUCE_2 = 3;
	const CM_REDUCE_3 = 4;
	const CM_REDUCE_4 = 5;
	const CM_IMPLODE = 6;
	const CM_DEFLATE = 8;
	const CM_DEFLATE64 = 9;
	const CM_PKWARE_IMPLODE = 10;
	const CM_BZIP2 = 12;
	const CM_LZMA = 14;
	const CM_TERSE = 18;
	const CM_LZ77 = 19;
	const CM_WAVPACK = 97;
	const CM_PPMD = 98;
	const ER_OK = 0;
	const ER_MULTIDISK = 1;
	const ER_RENAME = 2;
	const ER_CLOSE = 3;
	const ER_SEEK = 4;
	const ER_READ = 5;
	const ER_WRITE = 6;
	const ER_CRC = 7;
	const ER_ZIPCLOSED = 8;
	const ER_NOENT = 9;
	const ER_EXISTS = 10;
	const ER_OPEN = 11;
	const ER_TMPOPEN = 12;
	const ER_ZLIB = 13;
	const ER_MEMORY = 14;
	const ER_CHANGED = 15;
	const ER_COMPNOTSUPP = 16;
	const ER_EOF = 17;
	const ER_INVAL = 18;
	const ER_NOZIP = 19;
	const ER_INTERNAL = 20;
	const ER_INCONS = 21;
	const ER_REMOVE = 22;
	const ER_DELETED = 23;


	/**
	 * ZIP ファイルアーカイブをオープンする
	 * @link http://www.php.net/manual/ja/ziparchive.open.php
	 * @param filename string <p>
	 * オープンする ZIP アーカイブのファイル名。
	 * </p>
	 * @param flags int[optional] <p>
	 * アーカイブのオープンに使用するモード。
	 * <p>
	 * ZIPARCHIVE::OVERWRITE
	 * </p>
	 * @return mixed エラーコード
	 * <p>
	 * 成功した場合に TRUE、それ以外の場合にエラーコードを返します。
	 * <p>
	 * ZIPARCHIVE::ER_EXISTS
	 * </p>
	 * <p>
	 * ファイルが既に存在します。
	 * </p>
	 * <p>
	 * ZIPARCHIVE::ER_INCONS
	 * </p>
	 * <p>
	 * Zip アーカイブに矛盾があります。
	 * </p>
	 * <p>
	 * ZIPARCHIVE::ER_INVAL
	 * </p>
	 * <p>
	 * 無効な引数です。
	 * </p>
	 * <p>
	 * ZIPARCHIVE::ER_MEMORY
	 * </p>
	 * <p>
	 * メモリの確保に失敗しました。
	 * </p>
	 * <p>
	 * ZIPARCHIVE::ER_NOENT
	 * </p>
	 * <p>
	 * ファイルが存在しません。
	 * </p>
	 * <p>
	 * ZIPARCHIVE::ER_NOZIP
	 * </p>
	 * <p>
	 * zip アーカイブではありません。
	 * </p>
	 * <p>
	 * ZIPARCHIVE::ER_OPEN
	 * </p>
	 * <p>
	 * ファイルを開けません。
	 * </p>
	 * <p>
	 * ZIPARCHIVE::ER_READ
	 * </p>
	 * <p>
	 * 読み込みエラー。
	 * </p>
	 * <p>
	 * ZIPARCHIVE::ER_SEEK
	 * </p>
	 * <p>
	 * シークエラー。
	 * </p>
	 * </p>
	 */
	public function open ($filename, $flags = null) {}

	/**
	 * アクティブな (オープンされた、あるいは新しく作成された) アーカイブを閉じる
	 * @link http://www.php.net/manual/ja/ziparchive.close.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function close () {}

	/**
	 * システムエラー、または ZIP メッセージに関するエラー情報を返す
	 * @link http://www.php.net/manual/ja/ziparchive.getstatusstring.php
	 * @return string 成功時にはステータスメッセージを文字列で返します。失敗した場合に FALSE を返します。
	 */
	public function getStatusString () {}

	/**
	 * 新しいディレクトリを追加する
	 * @link http://www.php.net/manual/ja/ziparchive.addemptydir.php
	 * @param dirname string <p>
	 * 追加するディレクトリ。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function addEmptyDir ($dirname) {}

	/**
	 * 内容を指定して、ファイルを ZIP アーカイブに追加する
	 * @link http://www.php.net/manual/ja/ziparchive.addfromstring.php
	 * @param localname string <p>
	 * 作成するエントリの名前。
	 * </p>
	 * @param contents string <p>
	 * エントリを作成するために使用するデータの内容。
	 * バイナリセーフな形式で使用します。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function addFromString ($localname, $contents) {}

	/**
	 * 指定したパスからファイルを ZIP アーカイブに追加する
	 * @link http://www.php.net/manual/ja/ziparchive.addfile.php
	 * @param filename string <p>
	 * 追加するファイルへのパス。
	 * </p>
	 * @param localname string[optional] <p>
	 * 指定した場合は ZIP アーカイブ内部での名前となり、filename を上書きします。
	 * </p>
	 * @param start int[optional] <p>
	 * このパラメータは使いませんが、ZipArchive を継承するためには必要です。
	 * </p>
	 * @param length int[optional] <p>
	 * このパラメータは使いませんが、ZipArchive を継承するためには必要です。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function addFile ($filename, $localname = null, $start = null, $length = null) {}

	/**
	 * @param pattern
	 * @param flags[optional]
	 * @param options[optional]
	 */
	public function addGlob ($pattern, $flags, $options) {}

	/**
	 * @param pattern
	 * @param path[optional]
	 * @param options[optional]
	 */
	public function addPattern ($pattern, $path, $options) {}

	/**
	 * インデックスを使用してエントリ名を変更する
	 * @link http://www.php.net/manual/ja/ziparchive.renameindex.php
	 * @param index int <p>
	 * 名前を変更するエントリのインデックス。
	 * </p>
	 * @param newname string <p>
	 * 新しい名前。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function renameIndex ($index, $newname) {}

	/**
	 * 名前を使用してエントリ名を変更する
	 * @link http://www.php.net/manual/ja/ziparchive.renamename.php
	 * @param name string <p>
	 * 名前を変更するエントリの名前。
	 * </p>
	 * @param newname string <p>
	 * 新しい名前。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function renameName ($name, $newname) {}

	/**
	 * ZIP アーカイブのコメントを設定する
	 * @link http://www.php.net/manual/ja/ziparchive.setarchivecomment.php
	 * @param comment string <p>
	 * コメントの内容。
	 * </p>
	 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setArchiveComment ($comment) {}

	/**
	 * ZIP アーカイブのコメントを返す
	 * @link http://www.php.net/manual/ja/ziparchive.getarchivecomment.php
	 * @param flags int[optional] <p>
	 * ZIPARCHIVE::FL_UNCHANGED を設定すると、
	 * 元の変更されていないコメントを返します。
	 * </p>
	 * @return string Zip アーカイブのコメントを返します。失敗した場合に FALSE を返します。
	 */
	public function getArchiveComment ($flags = null) {}

	/**
	 * インデックスを使用してエントリのコメントを設定する
	 * @link http://www.php.net/manual/ja/ziparchive.setcommentindex.php
	 * @param index int <p>
	 * エントリのインデックス。
	 * </p>
	 * @param comment string <p>
	 * コメントの内容。
	 * </p>
	 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setCommentIndex ($index, $comment) {}

	/**
	 * 名前を使用してエントリのコメントを設定する
	 * @link http://www.php.net/manual/ja/ziparchive.setcommentname.php
	 * @param name string <p>
	 * エントリの名前。
	 * </p>
	 * @param comment string <p>
	 * コメントの内容。
	 * </p>
	 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setCommentName ($name, $comment) {}

	/**
	 * エントリのインデックスを使用して、エントリのコメントを返す
	 * @link http://www.php.net/manual/ja/ziparchive.getcommentindex.php
	 * @param index int <p>
	 * エントリのインデックス。
	 * </p>
	 * @param flags int[optional] <p>
	 * ZIPARCHIVE::FL_UNCHANGED を指定すると、
	 * 元の変化していないコメントを返します。
	 * </p>
	 * @return string 成功した場合にコメント、失敗した場合に FALSE を返します。
	 */
	public function getCommentIndex ($index, $flags = null) {}

	/**
	 * エントリ名を使用して、エントリのコメントを返す
	 * @link http://www.php.net/manual/ja/ziparchive.getcommentname.php
	 * @param name string <p>
	 * エントリの名前。
	 * </p>
	 * @param flags int[optional] <p>
	 * ZIPARCHIVE::FL_UNCHANGED を指定すると、
	 * 元の変化していないコメントが返されます。
	 * </p>
	 * @return string 成功した場合にコメント、失敗した場合に FALSE を返します。
	 */
	public function getCommentName ($name, $flags = null) {}

	/**
	 * インデックスを使用して、アーカイブ内のエントリを削除する
	 * @link http://www.php.net/manual/ja/ziparchive.deleteindex.php
	 * @param index int <p>
	 * 削除するエントリのインデックス。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function deleteIndex ($index) {}

	/**
	 * 名前を使用して、アーカイブからエントリを削除する
	 * @link http://www.php.net/manual/ja/ziparchive.deletename.php
	 * @param name string <p>
	 * 削除するエントリの名前。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function deleteName ($name) {}

	/**
	 * 名前を使用してエントリの詳細を取得する
	 * @link http://www.php.net/manual/ja/ziparchive.statname.php
	 * @param name string <p>
	 * エントリの名前。
	 * </p>
	 * @param flags int[optional] <p>
	 * 名前をどのように探すのかを設定します。
	 * また ZIPARCHIVE::FL_UNCHANGED を OR で連結すると、
	 * アーカイブ内に最初に記録された際の情報を取得します。
	 * 変更内容は無視されます。
	 * <p>
	 * ZIPARCHIVE::FL_NOCASE
	 * </p>
	 * @return mixed エントリの詳細を含む配列を返します。失敗した場合に FALSE を返します。
	 */
	public function statName ($name, $flags = null) {}

	/**
	 * インデックスを使用してエントリの詳細を取得する
	 * @link http://www.php.net/manual/ja/ziparchive.statindex.php
	 * @param index int <p>
	 * エントリのインデックス。
	 * </p>
	 * @param flags int[optional] <p>
	 * ZIPARCHIVE::FL_UNCHANGED を OR で連結すると、
	 * アーカイブ内に最初に記録された際の情報を取得します。
	 * 変更内容は無視されます。
	 * </p>
	 * @return mixed エントリの詳細を含む配列を返します。失敗した場合に FALSE を返します。
	 */
	public function statIndex ($index, $flags = null) {}

	/**
	 * アーカイブ内のエントリのインデックスを返す
	 * @link http://www.php.net/manual/ja/ziparchive.locatename.php
	 * @param name string <p>
	 * 探したいエントリの名前。
	 * </p>
	 * @param flags int[optional] <p>
	 * この関数は、アーカイブ内の指定した名前のファイルのインデックスを返します。
	 * フラグには、次の値を OR で連結して指定します。
	 * あるいは何もしていしない場合は 0 とします。
	 * <p>
	 * ZIPARCHIVE::FL_NOCASE
	 * </p>
	 * @return mixed 成功した場合にエントリのインデックス、失敗した場合に FALSE を返します。
	 */
	public function locateName ($name, $flags = null) {}

	/**
	 * インデックスを使用して、エントリの名前を返す
	 * @link http://www.php.net/manual/ja/ziparchive.getnameindex.php
	 * @param index int <p>
	 * エントリのインデックス。
	 * </p>
	 * @param flags int[optional] <p>
	 * ZIPARCHIVE::FL_UNCHANGED を指定すると、
	 * 元の変化していないコメントを返します。
	 * </p>
	 * @return string 成功した場合に名前、失敗した場合に FALSE を返します。
	 */
	public function getNameIndex ($index, $flags = null) {}

	/**
	 * アーカイブ全体に対して行われたすべての変更を取り消す
	 * @link http://www.php.net/manual/ja/ziparchive.unchangearchive.php
	 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function unchangeArchive () {}

	/**
	 * アーカイブに対するすべての変更を取り消す
	 * @link http://www.php.net/manual/ja/ziparchive.unchangeall.php
	 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function unchangeAll () {}

	/**
	 * 指定したインデックスのエントリに対するすべての変更を取り消す
	 * @link http://www.php.net/manual/ja/ziparchive.unchangeindex.php
	 * @param index int <p>
	 * エントリのインデックス。
	 * </p>
	 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function unchangeIndex ($index) {}

	/**
	 * 指定した名前のエントリに対するすべての変更を取り消す
	 * @link http://www.php.net/manual/ja/ziparchive.unchangename.php
	 * @param name string <p>
	 * エントリの名前。
	 * </p>
	 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function unchangeName ($name) {}

	/**
	 * アーカイブの内容を展開する
	 * @link http://www.php.net/manual/ja/ziparchive.extractto.php
	 * @param destination string <p>
	 * ファイルを展開する場所。
	 * </p>
	 * @param entries mixed[optional] <p>
	 * 展開するエントリ。単一のエントリ名、
	 * あるいはエントリ名の配列を指定します。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function extractTo ($destination, $entries = null) {}

	/**
	 * 名前を使用して、エントリの内容を返す
	 * @link http://www.php.net/manual/ja/ziparchive.getfromname.php
	 * @param name string <p>
	 * エントリの名前。
	 * </p>
	 * @param length int[optional] <p>
	 * エントリから読み込む長さ。0 の場合はエントリ全体を読み込みます。
	 * </p>
	 * @param flags int[optional] <p>
	 * アーカイブのオープン時に使用するフラグ。以下の値を
	 * OR で連結して使用します。
	 * <p>
	 * ZIPARCHIVE::FL_UNCHANGED
	 * </p>
	 * @return mixed 成功した場合にエントリの内容、失敗した場合に FALSE を返します。
	 */
	public function getFromName ($name, $length = null, $flags = null) {}

	/**
	 * インデックスを使用して、エントリの内容を返す
	 * @link http://www.php.net/manual/ja/ziparchive.getfromindex.php
	 * @param index int <p>
	 * エントリのインデックス。
	 * </p>
	 * @param length int[optional] <p>
	 * エントリから読み込む長さ。0 の場合はエントリ全体を読み込みます。
	 * </p>
	 * @param flags int[optional] <p>
	 * アーカイブのオープン時に使用するフラグ。以下の値を
	 * OR で連結して使用します。
	 * <p>
	 * ZIPARCHIVE::FL_UNCHANGED
	 * </p>
	 * @return mixed 成功した場合にエントリの内容、失敗した場合に FALSE を返します。
	 */
	public function getFromIndex ($index, $length = null, $flags = null) {}

	/**
	 * 名前を使用して、エントリのファイルハンドラ (読み込み専用) を取得する
	 * @link http://www.php.net/manual/ja/ziparchive.getstream.php
	 * @param name string <p>
	 * 使用するエントリの名前。
	 * </p>
	 * @return resource 成功した場合にファイルポインタ (リソース)、
	 * 失敗した場合に FALSE を返します。
	 */
	public function getStream ($name) {}

}

/**
 * Zip ファイルアーカイブをオープンする
 * @link http://www.php.net/manual/ja/function.zip-open.php
 * @param filename string <p>
 * オープンする ZIP アーカイブのファイル名。
 * </p>
 * @return resource 後で
 * zip_read および zip_close
 * で使用されるリソースハンドル、または、
 * filename が存在しない場合やその他のエラーが発生した場合は
 * エラーの番号を返します。
 */
function zip_open ($filename) {}

/**
 * ZIP ファイルアーカイブを閉じる
 * @link http://www.php.net/manual/ja/function.zip-close.php
 * @param zip resource <p>
 * 事前に zip_open でオープンされた ZIP ファイル。
 * </p>
 * @return void 値を返しません。
 */
function zip_close ($zip) {}

/**
 * Zip ファイルアーカイブの中の次のエントリを読み込む
 * @link http://www.php.net/manual/ja/function.zip-read.php
 * @param zip resource <p>
 * zip_open でオープン済みの ZIP ファイル。
 * </p>
 * @return resource 後で zip_entry_...
 * 関数で使用されるディレクトリエントリリソース、または、
 * 読み込むエントリがもうない場合に FALSE、
 * その他のエラーが発生した場合はエラー番号を返します。
 */
function zip_read ($zip) {}

/**
 * 読込み用にディレクトリエントリをオープンする
 * @link http://www.php.net/manual/ja/function.zip-entry-open.php
 * @param zip resource <p>
 * zip_openにより返された有効なリソースハンドル
 * </p>
 * @param zip_entry resource <p>
 * zip_readにより返されたディレクトリエントリ
 * </p>
 * @param mode string[optional] <p>
 * fopenのマニュアルで指定されたモードのどれか
 * </p>
 * <p>
 * 現在、modeは無視され、
 * 常に"rb"となります。
 * これは、PHPのzipサポートが読み込みのみのアクセスであるためです。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * fopenや他の同種の関数と異なり、
 * zip_entry_openの戻り値は、
 * 処理の結果のみを示し、ディレクトリエントリの読み込みやクローズの際には
 * 必要とされません。
 */
function zip_entry_open ($zip, $zip_entry, $mode = null) {}

/**
 * ディレクトリエントリを閉じる
 * @link http://www.php.net/manual/ja/function.zip-entry-close.php
 * @param zip_entry resource <p>
 * zip_entry_openによりオープンされたディレクトリの
 * エントリ
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function zip_entry_close ($zip_entry) {}

/**
 * オープンされたディレクトリエントリから読み込む
 * @link http://www.php.net/manual/ja/function.zip-entry-read.php
 * @param zip_entry resource <p>
 * zip_readにより返されたディレクトリエントリ
 * </p>
 * @param length int[optional] <p>
 * 返すバイト数。指定されない場合、この関数は1024バイトを読み込みます。
 * </p>
 * <p>
 * これは、読み込むデータの非圧縮時の長さとなります。
 * </p>
 * @return string 読み込んだデータ、または、ファイルの終端に達した時に 
 * FALSE を返します。
 * reached.
 */
function zip_entry_read ($zip_entry, $length = null) {}

/**
 * ディレクトリエントリの実際のファイルサイズを取得する
 * @link http://www.php.net/manual/ja/function.zip-entry-filesize.php
 * @param zip_entry resource <p>
 * zip_readにより返されたディレクトリのエントリ
 * </p>
 * @return int ディレクトリエントリのサイズ
 */
function zip_entry_filesize ($zip_entry) {}

/**
 * ディレクトリエントリの名前を取得する
 * @link http://www.php.net/manual/ja/function.zip-entry-name.php
 * @param zip_entry resource <p>
 * zip_readにより返されたディレクトリエントリ
 * </p>
 * @return string ディレクトリエントリの名前
 */
function zip_entry_name ($zip_entry) {}

/**
 * ディレクトリエントリの圧縮時のサイズを取得する
 * @link http://www.php.net/manual/ja/function.zip-entry-compressedsize.php
 * @param zip_entry resource <p>
 * zip_readにより返されたディレクトリのエントリ
 * </p>
 * @return int 圧縮後のサイズ
 */
function zip_entry_compressedsize ($zip_entry) {}

/**
 * ディレクトリエントリの圧縮方法を取得する
 * @link http://www.php.net/manual/ja/function.zip-entry-compressionmethod.php
 * @param zip_entry resource <p>
 * zip_readにより返されたディレクトリのエントリ
 * </p>
 * @return string 圧縮方法
 */
function zip_entry_compressionmethod ($zip_entry) {}

// End of zip v.1.11.0
?>
