<?php

// Start of tidy v.2.0

class tidy  {

	/**
	 * Tidy ドキュメントについて指定した設定オプションの値を返す
	 * @link http://www.php.net/manual/ja/tidy.getopt.php
	 * @param option string <p>
	 * それぞれの設定オプションと型の一覧は、http://tidy.sourceforge.net/docs/quickref.html
	 * にあります。
	 * </p>
	 * @return mixed 指定した設定オプション option
	 * の値を返します。
	 * 返される型は、設定オプションの型に依存します。
	 */
	public function getOpt ($option) {}

	/**
	 * パースされたマークアップに設定に基く誤りの修正を行う
	 * @link http://www.php.net/manual/ja/tidy.cleanrepair.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function cleanRepair () {}

	/**
	 * ファイルまたは URI にあるマークアップをパースする
	 * @link http://www.php.net/manual/ja/tidy.parsefile.php
	 * @param filename string <p>
	 * もし filename パラメータが与えられた場合、
	 * この関数はファイルを読み込み、tidy_parse_file
	 * のように実行してファイルに基づいたオブジェクトを初期化します。
	 * </p>
	 * @param config mixed[optional] <p>
	 * config には配列あるいは文字列を渡します。
	 * 文字列を渡した場合は設定ファイルの名前、
	 * それ以外の場合は設定そのものとして解釈されます。
	 * </p>
	 * <p>
	 * オプションについての説明は http://tidy.sourceforge.net/docs/quickref.html
	 * を参照ください。
	 * </p>
	 * @param encoding string[optional] <p>
	 * encoding は入出力ドキュメントのエンコーディングを設定します。
	 * 指定できるエンコーディング名は
	 * ascii、latin0、latin1、
	 * raw、utf8、iso2022、
	 * mac、win1252、ibm858、
	 * utf16、utf16le、utf16be、
	 * big5 および shiftjis です。
	 * </p>
	 * @param use_include_path bool[optional] <p>
	 * include_path からファイルを探します。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function parseFile ($filename, $config = null, $encoding = null, $use_include_path = null) {}

	/**
	 * 文字列にストアされたドキュメントをパースする
	 * @link http://www.php.net/manual/ja/tidy.parsestring.php
	 * @param input string <p>
	 * パースするデータ。
	 * </p>
	 * @param config mixed[optional] <p>
	 * config には配列あるいは文字列を渡します。
	 * 文字列を渡した場合は設定ファイルの名前、
	 * それ以外の場合は設定そのものとして解釈されます。
	 * </p>
	 * <p>
	 * オプションについての説明は http://tidy.sourceforge.net/docs/quickref.html
	 * を参照ください。
	 * </p>
	 * @param encoding string[optional] <p>
	 * encoding は入出力ドキュメントのエンコーディングを設定します。
	 * 指定できるエンコーディング名は
	 * ascii、latin0、latin1、
	 * raw、utf8、iso2022、
	 * mac、win1252、ibm858、
	 * utf16、utf16le、utf16be、
	 * big5 および shiftjis です。
	 * </p>
	 * @return bool 新しい tidy インスタンスを返します。
	 */
	public function parseString ($input, $config = null, $encoding = null) {}

	/**
	 * 別途提供される設定ファイルを使用して文字列を修正する
	 * @link http://www.php.net/manual/ja/tidy.repairstring.php
	 * @param data string <p>
	 * 修正するデータ。
	 * </p>
	 * @param config mixed[optional] <p>
	 * config には配列あるいは文字列を渡します。
	 * 文字列を渡した場合は設定ファイルの名前、
	 * それ以外の場合は設定そのものとして解釈されます。
	 * </p>
	 * <p>
	 * オプションについての説明は
	 * http://tidy.sourceforge.net/docs/quickref.html
	 * を参照ください。
	 * </p>
	 * @param encoding string[optional] <p>
	 * encoding は入出力ドキュメントのエンコーディングを設定します。
	 * 指定できるエンコーディング名は
	 * ascii、latin0、latin1、
	 * raw、utf8、iso2022、
	 * mac、win1252、ibm858、
	 * utf16、utf16le、utf16be、
	 * big5 および shiftjis です。
	 * </p>
	 * @return string 修正した文字列を返します。
	 */
	public function repairString ($data, $config = null, $encoding = null) {}

	/**
	 * ファイルを修正し、それを文字列として返す
	 * @link http://www.php.net/manual/ja/tidy.repairfile.php
	 * @param filename string <p>
	 * 修正するファイル。
	 * </p>
	 * @param config mixed[optional] <p>
	 * config には配列あるいは文字列を渡します。
	 * 文字列を渡した場合は設定ファイルの名前、
	 * それ以外の場合は設定そのものとして解釈されます。
	 * </p>
	 * <p>
	 * オプションについての説明は
	 * http://tidy.sourceforge.net/docs/quickref.html
	 * を参照ください。
	 * </p>
	 * @param encoding string[optional] <p>
	 * encoding は入出力ドキュメントのエンコーディングを設定します。
	 * 指定できるエンコーディング名は
	 * ascii、latin0、latin1、
	 * raw、utf8、iso2022、
	 * mac、win1252、ibm858、
	 * utf16、utf16le、utf16be、
	 * big5 および shiftjis です。
	 * </p>
	 * @param use_include_path bool[optional] <p>
	 * include_path からファイルを探します。
	 * </p>
	 * @return string 修正した内容を文字列で返します。
	 */
	public function repairFile ($filename, $config = null, $encoding = null, $use_include_path = null) {}

	/**
	 * パース、修正されたマークアップの診断を行う
	 * @link http://www.php.net/manual/ja/tidy.diagnose.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function diagnose () {}

	/**
	 * Tidy ライブラリのリリース日 (バージョン) を取得する
	 * @link http://www.php.net/manual/ja/tidy.getrelease.php
	 * @return string Tidy ライブラリのリリース日を文字列で返します。
	 */
	public function getRelease () {}

	/**
	 * 現在の Tidy の設定を取得する
	 * @link http://www.php.net/manual/ja/tidy.getconfig.php
	 * @return array 設定オプションの配列を返します。
	 * </p>
	 * <p>
	 * それぞれのオプションの説明については、http://tidy.sourceforge.net/docs/quickref.html を参照ください。
	 */
	public function getConfig () {}

	/**
	 * 指定したドキュメントのステータスを取得する
	 * @link http://www.php.net/manual/ja/tidy.getstatus.php
	 * @return int エラー/警告が発生しなかった場合は 0、
	 * 警告やアクセイシビリティエラーの場合は 1、
	 * エラーの場合は 2 を返します。
	 */
	public function getStatus () {}

	/**
	 * 指定したドキュメントで検出された HTML バージョンを取得する
	 * @link http://www.php.net/manual/ja/tidy.gethtmlver.php
	 * @return int 出された HTML バージョンを返します。
	 * </p>
	 * <p>
	 * この関数は Tidylib 自体でまだ実装されていません。そのため常に
	 * 0 を返します。
	 */
	public function getHtmlVer () {}

	/**
	 * ドキュメントが XHTML ドキュメントかどうかを示す
	 * @link http://www.php.net/manual/ja/tidy.isxhtml.php
	 * @return bool 指定した Tidy オブジェクト object
	 * が XHTML ドキュメントの場合、この関数は TRUE を返します。
	 * その他の場合は FALSE を返します。
	 * </p>
	 * <p>
	 * この関数はまだ Tidylib 自身に実装されていません。
	 * なので、常に FALSE を返します。
	 */
	public function isXhtml () {}

	/**
	 * ドキュメントが一般的な XML ドキュメント (非 HTML/XHTML) かどうかを示す
	 * @link http://www.php.net/manual/ja/tidy.isxml.php
	 * @return bool 指定した Tidy オブジェクト object
	 * が一般的な XML ドキュメント (非 HTML/XHTML) の場合、
	 * この関数は TRUE を返します。
	 * その他の場合は FALSE を返します。
	 * </p>
	 * <p>
	 * この関数はまだ Tidylib 自身に実装されていません。
	 * なので、常に FALSE を返します。
	 */
	public function isXml () {}

	/**
	 * Tidy パースツリーのルートを表す <classname>tidyNode</classname> を返す
	 * @link http://www.php.net/manual/ja/tidy.root.php
	 * @return tidyNode tidyNode オブジェクトを返します。
	 */
	public function root () {}

	/**
	 * Tidy パースツリーの &lt;head&gt; タグから始まる <classname>tidyNode</classname> オブジェクトを返す
	 * @link http://www.php.net/manual/ja/tidy.head.php
	 * @return tidyNode tidyNode オブジェクトを返します。
	 */
	public function head () {}

	/**
	 * Tidy パースツリーの &lt;html&gt; タグから始まる <classname>tidyNode</classname> オブジェクトを返す
	 * @link http://www.php.net/manual/ja/tidy.html.php
	 * @return tidyNode tidyNode オブジェクトを返します。
	 */
	public function html () {}

	/**
	 * Tidy パースツリーの &lt;body&gt; タグから始まる <classname>tidyNode</classname> オブジェクトを返す
	 * @link http://www.php.net/manual/ja/tidy.body.php
	 * @return tidyNode 見つかった HTML バージョンを返します。
	 * </p>
	 * <p>
	 * この関数は Tidylib 自体でまだ実装されていません。そのため常に
	 * 0 を返します。
	 */
	public function body () {}

	/**
	 * 新しい <classname>tidy</classname> オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/tidy.construct.php
	 */
	public function __construct () {}

}

final class tidyNode  {

	/**
	 * ノードが子を持つかどうかを調べる
	 * @link http://www.php.net/manual/ja/tidynode.haschildren.php
	 * @return bool ノードが子を持つ場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function hasChildren () {}

	/**
	 * このノードが兄弟ノードを持つかどうかを調べる
	 * @link http://www.php.net/manual/ja/tidynode.hassiblings.php
	 * @return bool 兄弟ノードを持つ場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function hasSiblings () {}

	/**
	 * このノードがコメントを表すものかどうかを調べる
	 * @link http://www.php.net/manual/ja/tidynode.iscomment.php
	 * @return bool このノードがコメントである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isComment () {}

	/**
	 * このノードが HTML ドキュメントであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/tidynode.ishtml.php
	 * @return bool ノードが HTML ドキュメントの一部である場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isHtml () {}

	/**
	 * このノードが (マークアップでない) テキストであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/tidynode.istext.php
	 * @return bool ノードがテキストを著す場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isText () {}

	/**
	 * このノードが JSTE であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/tidynode.isjste.php
	 * @return bool ノードが JSTE である場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isJste () {}

	/**
	 * このノードが ASP かどうかを調べる
	 * @link http://www.php.net/manual/ja/tidynode.isasp.php
	 * @return bool ノードが ASP の場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isAsp () {}

	/**
	 * このノードが PHP であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/tidynode.isphp.php
	 * @return bool ノードが PHP コードである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isPhp () {}

	/**
	 * カレントノードの親ノードを返す
	 * @link http://www.php.net/manual/ja/tidynode.getparent.php
	 * @return tidyNode そのノードが親を持っている場合に tidyNode、
	 * それ以外の場合に NULL を返します。
	 */
	public function getParent () {}

	private function __construct () {}

}

/**
 * @param option
 */
function tidy_getopt ($option) {}

/**
 * @param input
 * @param config_options[optional]
 * @param encoding[optional]
 */
function tidy_parse_string ($input, $config_options, $encoding) {}

/**
 * @param file
 * @param config_options[optional]
 * @param encoding[optional]
 * @param use_include_path[optional]
 */
function tidy_parse_file ($file, $config_options, $encoding, $use_include_path) {}

/**
 * パースされた Tidy マークアップを表す文字列を返す
 * @link http://www.php.net/manual/ja/function.tidy-get-output.php
 * @param object tidy <p>
 * Tidy オブジェクト。
 * </p>
 * @return string 修正された HTML を文字列で返します。
 */
function tidy_get_output (tidy $object) {}

function tidy_get_error_buffer () {}

function tidy_clean_repair () {}

/**
 * @param data
 * @param config_file[optional]
 * @param encoding[optional]
 */
function tidy_repair_string ($data, $config_file, $encoding) {}

/**
 * @param filename
 * @param config_file[optional]
 * @param encoding[optional]
 * @param use_include_path[optional]
 */
function tidy_repair_file ($filename, $config_file, $encoding, $use_include_path) {}

function tidy_diagnose () {}

function tidy_get_release () {}

function tidy_get_config () {}

function tidy_get_status () {}

function tidy_get_html_ver () {}

function tidy_is_xhtml () {}

function tidy_is_xml () {}

/**
 * 指定したドキュメントについて発生した Tidy エラーの数を返す
 * @link http://www.php.net/manual/ja/function.tidy-error-count.php
 * @param object tidy <p>
 * Tidy オブジェクト。
 * </p>
 * @return int エラーの数を返します。
 */
function tidy_error_count (tidy $object) {}

/**
 * 指定したドキュメントについて発生した Tidy 警告の数を返す
 * @link http://www.php.net/manual/ja/function.tidy-warning-count.php
 * @param object tidy <p>
 * Tidy オブジェクト。
 * </p>
 * @return int 警告の数を返します。
 */
function tidy_warning_count (tidy $object) {}

/**
 * 指定したドキュメントについて発生したTidyアクセシビリティ警告の数を返す
 * @link http://www.php.net/manual/ja/function.tidy-access-count.php
 * @param object tidy <p>
 * Tidy オブジェクト。
 * </p>
 * @return int 警告の数を返します。
 */
function tidy_access_count (tidy $object) {}

/**
 * 指定したドキュメントについて発生した Tidy 設定エラーの数を返す
 * @link http://www.php.net/manual/ja/function.tidy-config-count.php
 * @param object tidy <p>
 * Tidy オブジェクト。
 * </p>
 * @return int エラーの数を返します。
 */
function tidy_config_count (tidy $object) {}

function tidy_get_root () {}

function tidy_get_head () {}

function tidy_get_html () {}

/**
 * @param tidy
 */
function tidy_get_body ($tidy) {}


/**
 * 説明
 * @link http://www.php.net/manual/ja/tidy.constants.php
 */
define ('TIDY_TAG_UNKNOWN', 0);
define ('TIDY_TAG_A', 1);
define ('TIDY_TAG_ABBR', 2);
define ('TIDY_TAG_ACRONYM', 3);
define ('TIDY_TAG_ADDRESS', 4);
define ('TIDY_TAG_ALIGN', 5);
define ('TIDY_TAG_APPLET', 6);
define ('TIDY_TAG_AREA', 7);
define ('TIDY_TAG_B', 8);
define ('TIDY_TAG_BASE', 9);
define ('TIDY_TAG_BASEFONT', 10);
define ('TIDY_TAG_BDO', 11);
define ('TIDY_TAG_BGSOUND', 12);
define ('TIDY_TAG_BIG', 13);
define ('TIDY_TAG_BLINK', 14);
define ('TIDY_TAG_BLOCKQUOTE', 15);
define ('TIDY_TAG_BODY', 16);
define ('TIDY_TAG_BR', 17);
define ('TIDY_TAG_BUTTON', 18);
define ('TIDY_TAG_CAPTION', 19);
define ('TIDY_TAG_CENTER', 20);
define ('TIDY_TAG_CITE', 21);
define ('TIDY_TAG_CODE', 22);
define ('TIDY_TAG_COL', 23);
define ('TIDY_TAG_COLGROUP', 24);
define ('TIDY_TAG_COMMENT', 25);
define ('TIDY_TAG_DD', 26);
define ('TIDY_TAG_DEL', 27);
define ('TIDY_TAG_DFN', 28);
define ('TIDY_TAG_DIR', 29);
define ('TIDY_TAG_DIV', 30);
define ('TIDY_TAG_DL', 31);
define ('TIDY_TAG_DT', 32);
define ('TIDY_TAG_EM', 33);
define ('TIDY_TAG_EMBED', 34);
define ('TIDY_TAG_FIELDSET', 35);
define ('TIDY_TAG_FONT', 36);
define ('TIDY_TAG_FORM', 37);
define ('TIDY_TAG_FRAME', 38);
define ('TIDY_TAG_FRAMESET', 39);
define ('TIDY_TAG_H1', 40);
define ('TIDY_TAG_H2', 41);
define ('TIDY_TAG_H3', 42);
define ('TIDY_TAG_H4', 43);
define ('TIDY_TAG_H5', 44);
define ('TIDY_TAG_H6', 45);
define ('TIDY_TAG_HEAD', 46);
define ('TIDY_TAG_HR', 47);
define ('TIDY_TAG_HTML', 48);
define ('TIDY_TAG_I', 49);
define ('TIDY_TAG_IFRAME', 50);
define ('TIDY_TAG_ILAYER', 51);
define ('TIDY_TAG_IMG', 52);
define ('TIDY_TAG_INPUT', 53);
define ('TIDY_TAG_INS', 54);
define ('TIDY_TAG_ISINDEX', 55);
define ('TIDY_TAG_KBD', 56);
define ('TIDY_TAG_KEYGEN', 57);
define ('TIDY_TAG_LABEL', 58);
define ('TIDY_TAG_LAYER', 59);
define ('TIDY_TAG_LEGEND', 60);
define ('TIDY_TAG_LI', 61);
define ('TIDY_TAG_LINK', 62);
define ('TIDY_TAG_LISTING', 63);
define ('TIDY_TAG_MAP', 64);
define ('TIDY_TAG_MARQUEE', 65);
define ('TIDY_TAG_MENU', 66);
define ('TIDY_TAG_META', 67);
define ('TIDY_TAG_MULTICOL', 68);
define ('TIDY_TAG_NOBR', 69);
define ('TIDY_TAG_NOEMBED', 70);
define ('TIDY_TAG_NOFRAMES', 71);
define ('TIDY_TAG_NOLAYER', 72);
define ('TIDY_TAG_NOSAVE', 73);
define ('TIDY_TAG_NOSCRIPT', 74);
define ('TIDY_TAG_OBJECT', 75);
define ('TIDY_TAG_OL', 76);
define ('TIDY_TAG_OPTGROUP', 77);
define ('TIDY_TAG_OPTION', 78);
define ('TIDY_TAG_P', 79);
define ('TIDY_TAG_PARAM', 80);
define ('TIDY_TAG_PLAINTEXT', 81);
define ('TIDY_TAG_PRE', 82);
define ('TIDY_TAG_Q', 83);
define ('TIDY_TAG_RB', 84);
define ('TIDY_TAG_RBC', 85);
define ('TIDY_TAG_RP', 86);
define ('TIDY_TAG_RT', 87);
define ('TIDY_TAG_RTC', 88);
define ('TIDY_TAG_RUBY', 89);
define ('TIDY_TAG_S', 90);
define ('TIDY_TAG_SAMP', 91);
define ('TIDY_TAG_SCRIPT', 92);
define ('TIDY_TAG_SELECT', 93);
define ('TIDY_TAG_SERVER', 94);
define ('TIDY_TAG_SERVLET', 95);
define ('TIDY_TAG_SMALL', 96);
define ('TIDY_TAG_SPACER', 97);
define ('TIDY_TAG_SPAN', 98);
define ('TIDY_TAG_STRIKE', 99);
define ('TIDY_TAG_STRONG', 100);
define ('TIDY_TAG_STYLE', 101);
define ('TIDY_TAG_SUB', 102);
define ('TIDY_TAG_SUP', 103);
define ('TIDY_TAG_TABLE', 104);
define ('TIDY_TAG_TBODY', 105);
define ('TIDY_TAG_TD', 106);
define ('TIDY_TAG_TEXTAREA', 107);
define ('TIDY_TAG_TFOOT', 108);
define ('TIDY_TAG_TH', 109);
define ('TIDY_TAG_THEAD', 110);
define ('TIDY_TAG_TITLE', 111);
define ('TIDY_TAG_TR', 112);
define ('TIDY_TAG_TT', 113);
define ('TIDY_TAG_U', 114);
define ('TIDY_TAG_UL', 115);
define ('TIDY_TAG_VAR', 116);
define ('TIDY_TAG_WBR', 117);
define ('TIDY_TAG_XMP', 118);

/**
 * ルートノード
 * @link http://www.php.net/manual/ja/tidy.constants.php
 */
define ('TIDY_NODETYPE_ROOT', 0);

/**
 * 文章型
 * @link http://www.php.net/manual/ja/tidy.constants.php
 */
define ('TIDY_NODETYPE_DOCTYPE', 1);

/**
 * HTML コメント
 * @link http://www.php.net/manual/ja/tidy.constants.php
 */
define ('TIDY_NODETYPE_COMMENT', 2);

/**
 * 処理命令
 * @link http://www.php.net/manual/ja/tidy.constants.php
 */
define ('TIDY_NODETYPE_PROCINS', 3);

/**
 * テキスト
 * @link http://www.php.net/manual/ja/tidy.constants.php
 */
define ('TIDY_NODETYPE_TEXT', 4);

/**
 * 開始タグ
 * @link http://www.php.net/manual/ja/tidy.constants.php
 */
define ('TIDY_NODETYPE_START', 5);

/**
 * 終了タグ
 * @link http://www.php.net/manual/ja/tidy.constants.php
 */
define ('TIDY_NODETYPE_END', 6);

/**
 * 空タグ
 * @link http://www.php.net/manual/ja/tidy.constants.php
 */
define ('TIDY_NODETYPE_STARTEND', 7);

/**
 * CDATA
 * @link http://www.php.net/manual/ja/tidy.constants.php
 */
define ('TIDY_NODETYPE_CDATA', 8);

/**
 * XML セクション
 * @link http://www.php.net/manual/ja/tidy.constants.php
 */
define ('TIDY_NODETYPE_SECTION', 9);

/**
 * ASP コード
 * @link http://www.php.net/manual/ja/tidy.constants.php
 */
define ('TIDY_NODETYPE_ASP', 10);

/**
 * JSTE コード
 * @link http://www.php.net/manual/ja/tidy.constants.php
 */
define ('TIDY_NODETYPE_JSTE', 11);

/**
 * PHP コード
 * @link http://www.php.net/manual/ja/tidy.constants.php
 */
define ('TIDY_NODETYPE_PHP', 12);

/**
 * XML 宣言
 * @link http://www.php.net/manual/ja/tidy.constants.php
 */
define ('TIDY_NODETYPE_XMLDECL', 13);

// End of tidy v.2.0
?>
