<?php

// Start of mysqli v.0.1

class mysqli_sql_exception extends RuntimeException  {
	protected $message;
	protected $file;
	protected $line;
	protected $code;
	protected $sqlstate;


	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

final class mysqli_driver  {
	public $client_info;
	public $client_version;
	public $driver_version;
	public $embedded;
	public $reconnect;
	public $report_mode;

}

class mysqli  {
	public $affected_rows;
	public $client_info;
	public $client_version;
	public $connect_errno;
	public $connect_error;
	public $errno;
	public $error;
	public $error_list;
	public $field_count;
	public $host_info;
	public $info;
	public $insert_id;
	public $server_info;
	public $server_version;
	public $stat;
	public $sqlstate;
	public $protocol_version;
	public $thread_id;
	public $warning_count;


	/**
	 * データベース更新の自動コミットをオンまたはオフにする
	 * @link http://www.php.net/manual/ja/mysqli.autocommit.php
	 * @param link mysqli 
	 * @param mode bool <p>
	 * 自動コミットを有効にするかどうか。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function autocommit (mysqli $link, $mode) {}

	/**
	 * 指定されたデータベース接続のユーザー名を変更する
	 * @link http://www.php.net/manual/ja/mysqli.change-user.php
	 * @param link mysqli 
	 * @param user string <p>
	 * MySQL のユーザー名。
	 * </p>
	 * @param password string <p>
	 * MySQL のパスワード。
	 * </p>
	 * @param database string <p>
	 * 変更するデータベース。
	 * </p>
	 * <p>
	 * 引数には NULL 値を渡すこともできます。
	 * その場合ユーザーの変更だけでデータベースの選択はされません。
	 * そのようなケースでデータベースを選択したい場合には
	 * mysqli_select_db 関数を使用してください。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function change_user (mysqli $link, $user, $password, $database) {}

	/**
	 * データベース接続のデフォルトの文字コードセットを返す
	 * @link http://www.php.net/manual/ja/mysqli.character-set-name.php
	 * @param link mysqli 
	 * @return string 現在の接続のデフォルト文字セットを返します。
	 */
	public function character_set_name (mysqli $link) {}

	/**
	 * 事前にオープンしているデータベース接続を閉じる
	 * @link http://www.php.net/manual/ja/mysqli.close.php
	 * @param link mysqli 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function close (mysqli $link) {}

	/**
	 * 現在のトランザクションをコミットする
	 * @link http://www.php.net/manual/ja/mysqli.commit.php
	 * @param link mysqli 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function commit (mysqli $link) {}

	/**
	 * @param host[optional]
	 * @param user[optional]
	 * @param password[optional]
	 * @param database[optional]
	 * @param port[optional]
	 * @param socket[optional]
	 */
	public function connect ($host, $user, $password, $database, $port, $socket) {}

	/**
	 * デバッグ情報をログに出力する
	 * @link http://www.php.net/manual/ja/mysqli.dump-debug-info.php
	 * @param link mysqli 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function dump_debug_info (mysqli $link) {}

	/**
	 * デバッグ操作を行う
	 * @link http://www.php.net/manual/ja/mysqli.debug.php
	 * @param message string <p>
	 * 実行するデバッグ操作を表す文字列。
	 * </p>
	 * @return bool TRUE.
	 */
	public function debug ($message) {}

	/**
	 * 文字セットオブジェクトを返す
	 * @link http://www.php.net/manual/ja/mysqli.get-charset.php
	 * @param link mysqli 
	 * @return object この関数は、以下のプロパティを持つ文字セットオブジェクトを返します。
	 * charset
	 * <p>文字セット名</p>
	 * collation
	 * <p>照合規則名</p>
	 * dir
	 * <p>文字セットの設定を読み込むディレクトリ。組み込みの文字セットについては ""</p>
	 * min_length
	 * <p>最小の文字の長さ (バイト数)</p>
	 * max_length
	 * <p>最大の文字の長さ (バイト数)</p>
	 * number
	 * <p>内部文字セット番号</p>
	 * state
	 * <p>文字セットの状態</p>
	 */
	public function get_charset (mysqli $link) {}

	/**
	 * MySQL クライアント情報を取得する
	 * @link http://www.php.net/manual/ja/mysqli.get-client-info.php
	 * @param link mysqli 
	 * @return string MySQL クライアントライブラリのバージョンを文字列で返します。
	 */
	public function get_client_info (mysqli $link) {}

	/**
	 * クライアント接続に関する統計情報を返す
	 * @link http://www.php.net/manual/ja/mysqli.get-connection-stats.php
	 * @param link mysqli 
	 * @return array 成功した場合に接続の統計情報を含む配列、それ以外の場合に FALSE を返します。
	 */
	public function get_connection_stats (mysqli $link) {}

	public function get_server_info () {}

	/**
	 * SHOW WARNINGS の結果を取得する
	 * @link http://www.php.net/manual/ja/mysqli.get-warnings.php
	 * @param link mysqli 
	 * @return mysqli_warning 
	 */
	public function get_warnings (mysqli $link) {}

	/**
	 * MySQLi を初期化し、mysqli_real_connect() で使用するリソースを返す
	 * @link http://www.php.net/manual/ja/mysqli.init.php
	 * @return mysqli オブジェクトを返します。
	 */
	public function init () {}

	/**
	 * サーバーに MySQL スレッドの停止を問い合わせる
	 * @link http://www.php.net/manual/ja/mysqli.kill.php
	 * @param link mysqli 
	 * @param processid int 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function kill (mysqli $link, $processid) {}

	/**
	 * データベース上でクエリを実行する
	 * @link http://www.php.net/manual/ja/mysqli.multi-query.php
	 * @param link mysqli 
	 * @param query string <p>
	 * クエリを表す文字列。
	 * </p>
	 * <p>
	 * クエリ内のデータは 適切にエスケープ
	 * する必要があります。
	 * </p>
	 * @return bool 最初のステートメントが失敗した場合にのみ FALSE を返します。
	 * その他のステートメントのエラーを取得するには、まず
	 * mysqli_next_result をコールする必要があります。
	 */
	public function multi_query (mysqli $link, $query) {}

	/**
	 * @param host[optional]
	 * @param user[optional]
	 * @param password[optional]
	 * @param database[optional]
	 * @param port[optional]
	 * @param socket[optional]
	 */
	public function mysqli ($host, $user, $password, $database, $port, $socket) {}

	/**
	 * マルチクエリからの結果がまだ残っているかどうかを調べる
	 * @link http://www.php.net/manual/ja/mysqli.more-results.php
	 * @param link mysqli 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function more_results (mysqli $link) {}

	/**
	 * multi_query の、次の結果を準備する
	 * @link http://www.php.net/manual/ja/mysqli.next-result.php
	 * @param link mysqli 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function next_result (mysqli $link) {}

	/**
	 * オプションを設定する
	 * @link http://www.php.net/manual/ja/mysqli.options.php
	 * @param link mysqli 
	 * @param option int <p>
	 * 指定するオプション。以下の値のいずれかです。
	 * <table>
	 * 使用可能なオプション
	 * <tr valign="top">
	 * <td>名前</td>
	 * <td>説明</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>MYSQLI_OPT_CONNECT_TIMEOUT</td>
	 * <td>接続のタイムアウト秒数 (PHP 5.3.1 以降、Windows 上での TCP/IP 接続をサポートします)。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>MYSQLI_OPT_LOCAL_INFILE</td>
	 * <td>LOAD LOCAL INFILE の使用可/不可。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>MYSQLI_INIT_COMMAND</td>
	 * <td>MySQL サーバーへの接続後に実行するコマンド。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>MYSQLI_READ_DEFAULT_FILE</td>
	 * <td>
	 * my.cnf の代わりに、指定した名前のファイルから
	 * 設定を読み込みます。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>MYSQLI_READ_DEFAULT_GROUP</td>
	 * <td>
	 * my.cnf の指定した名前のグループ、あるいは
	 * MYSQL_READ_DEFAULT_FILE で指定したファイルから
	 * 設定を読み込みます。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>MYSQLI_SERVER_PUBLIC_KEY</td>
	 * <td>
	 * RSA 公開鍵ファイル。SHA-256 ベースの認証で使います。
	 * </td>
	 * </tr>
	 * </table>
	 * </p>
	 * @param value mixed <p>
	 * オプションに設定する値。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function options (mysqli $link, $option, $value) {}

	/**
	 * サーバーとの接続をチェックし、もし切断されている場合は再接続を試みる
	 * @link http://www.php.net/manual/ja/mysqli.ping.php
	 * @param link mysqli 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function ping (mysqli $link) {}

	/**
	 * 接続を問い合わせる
	 * @link http://www.php.net/manual/ja/mysqli.poll.php
	 * @param read array <p>
	 * </p>
	 * @param error array <p>
	 * </p>
	 * @param reject array <p>
	 * </p>
	 * @param sec int <p>
	 * 待ち続ける秒数。非負の数でなければなりません。
	 * </p>
	 * @param usec int[optional] <p>
	 * 待ち続けるマイクロ秒数。非負の数でなければなりません。
	 * </p>
	 * @return int 成功した場合に使用できる接続の数、それ以外の場合に FALSE を返します。
	 */
	public static function poll (array &$read, array &$error, array &$reject, $sec, $usec = null) {}

	/**
	 * 実行するための SQL ステートメントを準備する
	 * @link http://www.php.net/manual/ja/mysqli.prepare.php
	 * @param link mysqli 
	 * @param query string <p>
	 * クエリを表す文字列。
	 * </p>
	 * <p>
	 * ステートメントの最後にセミコロンや \g
	 * を追加してはいけません。
	 * </p>
	 * <p>
	 * query にはひとつまたは複数のパラメータを
	 * 含めることが可能です。そのためには、適切な位置にクエスチョンマーク
	 * (?) を埋め込みます。
	 * </p>
	 * <p>
	 * パラメータのマーカは、それが SQL 文の適切な位置にある場合のみ有効です。
	 * 例えば INSERT 文の
	 * VALUES() リストの中 (行に登録するカラム値を指定する)
	 * や WHERE 句で列のデータと比較する値などが
	 * 適切な位置の例です。
	 * </p>
	 * <p>
	 * しかし、識別子 (テーブルやカラムの名前) や SELECT
	 * 文で選択する項目の名前に指定したり、
	 * (等号 = のような)
	 * 二項演算子の両側にパラメータを指定したりすることはできません。
	 * 後者の制限は、パラメータの型が判断できなくなることによるものです。
	 * また、パラメータのマーカを NULL と比較して
	 * ? IS NULL のようにすることもできません。
	 * 一般に、パラメータが使用可能なのはデータ操作言語 (DML)
	 * ステートメントであり、データ定義言語 (DDL)
	 * ステートメントでは使用できません。
	 * </p>
	 * @return mysqli_stmt mysqli_prepare はステートメントオブジェクトを返します。
	 * エラー時には FALSE を返します。
	 */
	public function prepare (mysqli $link, $query) {}

	/**
	 * データベース上でクエリを実行する
	 * @link http://www.php.net/manual/ja/mysqli.query.php
	 * @param link mysqli 
	 * @param query string <p>
	 * クエリ文字列。
	 * </p>
	 * <p>
	 * クエリ内のデータは 適切にエスケープ.
	 * する必要があります。
	 * </p>
	 * @param resultmode int[optional] <p>
	 * 定数 MYSQLI_USE_RESULT あるいは
	 * MYSQLI_STORE_RESULT で、望みの挙動を指定します。
	 * デフォルトでは MYSQLI_STORE_RESULT
	 * を使用します。
	 * </p>
	 * <p>
	 * MYSQLI_USE_RESULT を使用すると、
	 * mysqli_free_result をコールするまでは
	 * それ以降のコールはすべて Commands out of sync
	 * エラーを返します。
	 * </p>
	 * <p>
	 * MYSQLI_ASYNC (mysqlnd で使用可能)
	 * を使用すると、クエリを非同期実行できるようになります。
	 * このクエリの結果を取得するには
	 * mysqli_poll を使用します。
	 * </p>
	 * @return mixed 失敗した場合に FALSE を返します。
	 * SELECT, SHOW, DESCRIBE あるいは
	 * EXPLAIN が成功した場合は、mysqli_query
	 * は mysqli_result オブジェクトを返します。それ以外のクエリが成功した場合は、
	 * mysqli_query は TRUE を返します。
	 */
	public function query (mysqli $link, $query, $resultmode = null) {}

	/**
	 * mysql サーバーとの接続をオープンする
	 * @link http://www.php.net/manual/ja/mysqli.real-connect.php
	 * @param link mysqli 
	 * @param host string[optional] <p>
	 * ホスト名あるいは IP アドレス。NULL 値あるいは文字列
	 * "localhost" をこのパラメータに指定すると、ローカルホストを使用します。
	 * 使用可能な場合は、TCP/IP プロトコルよりもパイプを優先して使用します。
	 * </p>
	 * @param username string[optional] <p>
	 * MySQL ユーザー名。
	 * </p>
	 * @param passwd string[optional] <p>
	 * NULL を指定した場合は、MySQL サーバーは
	 * パスワードを持たないユーザーレコードについてのみ認証を試みます。
	 * これにより、同一のユーザー名に対して (パスワードが指定されたか
	 * 否かによって) 違う権限を与えることができます。
	 * </p>
	 * @param dbname string[optional] <p>
	 * 指定した場合は、
	 * クエリが行われるデフォルトのデータベースとなります。
	 * </p>
	 * @param port int[optional] <p>
	 * MySQL サーバーに接続する際のポート番号を指定します。
	 * </p>
	 * @param socket string[optional] <p>
	 * 使用するソケットあるいは名前つきパイプを指定します。
	 * </p>
	 * <p>
	 * socket 引数を指定しても、MySQL サーバーへの
	 * 接続時の型を明示的に定義することにはなりません。MySQL サーバーへの
	 * 接続方法については host 引数で定義されます。
	 * </p>
	 * @param flags int[optional] <p>
	 * パラメータ flags
	 * で、接続時のさまざまなオプションを設定します。
	 * </p>
	 * <table>
	 * サポートするフラグ
	 * <tr valign="top">
	 * <td>名前</td>
	 * <td>説明</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>MYSQLI_CLIENT_COMPRESS</td>
	 * <td>圧縮プロトコルを使用します。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>MYSQLI_CLIENT_FOUND_ROWS</td>
	 * <td>変更された行数ではなく、マッチした行数を返します。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>MYSQLI_CLIENT_IGNORE_SPACE</td>
	 * <td>関数名に続く空白文字を許可します。すべての関数名を予約語とします。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>MYSQLI_CLIENT_INTERACTIVE</td>
	 * <td>
	 * 接続を閉じるまでのタイムアウト時間として、
	 * (wait_timeout のかわりに)
	 * interactive_timeout の使用を許可します。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>MYSQLI_CLIENT_SSL</td>
	 * <td>SSL (暗号化) を使用します。</td>
	 * </tr>
	 * </table>
	 * <p>
	 * セキュリティの観点から、PHP では MULTI_STATEMENT
	 * フラグはサポートされていません。複数のクエリを実行したい場合は、
	 * mysqli_multi_query 関数を使用してください。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function real_connect (mysqli $link, $host = null, $username = null, $passwd = null, $dbname = null, $port = null, $socket = null, $flags = null) {}

	/**
	 * 接続の現在の文字セットを考慮して、SQL 文で使用する文字列の特殊文字をエスケープする
	 * @link http://www.php.net/manual/ja/mysqli.real-escape-string.php
	 * @param escapestr string <p>
	 * エスケープする文字列。
	 * </p>
	 * <p>
	 * エンコードされる文字は NUL (ASCII 0), \n, \r, \, ', ", および
	 * Control-Z です。
	 * </p>
	 * @return string エスケープ済みの文字列を返します。
	 */
	public function real_escape_string ($escapestr) {}

	/**
	 * 非同期クエリから結果を取得する
	 * @link http://www.php.net/manual/ja/mysqli.reap-async-query.php
	 * @param link mysql 
	 * @return mysqli_result 成功した場合に mysqli_result、それ以外の場合に FALSE を返します。
	 */
	public function reap_async_query ($link) {}

	/**
	 * @param string_to_escape
	 */
	public function escape_string ($string_to_escape) {}

	/**
	 * SQL クエリを実行する
	 * @link http://www.php.net/manual/ja/mysqli.real-query.php
	 * @param link mysqli 
	 * @param query string <p>
	 * クエリを表す文字列。
	 * </p>
	 * <p>
	 * クエリ内のデータは 適切にエスケープ.
	 * する必要があります。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function real_query (mysqli $link, $query) {}

	/**
	 * 現在のトランザクションをロールバックする
	 * @link http://www.php.net/manual/ja/mysqli.rollback.php
	 * @param link mysqli 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function rollback (mysqli $link) {}

	/**
	 * クエリを実行するためのデフォルトのデータベースを選択する
	 * @link http://www.php.net/manual/ja/mysqli.select-db.php
	 * @param link mysqli 
	 * @param dbname string <p>
	 * データベース名。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function select_db (mysqli $link, $dbname) {}

	/**
	 * クライアントのデフォルト文字セットを設定する
	 * @link http://www.php.net/manual/ja/mysqli.set-charset.php
	 * @param link mysqli 
	 * @param charset string <p>
	 * デフォルトとして設定する文字セット。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function set_charset (mysqli $link, $charset) {}

	/**
	 * @param option
	 * @param value
	 */
	public function set_opt ($option, $value) {}

	/**
	 * SSL を使用したセキュアな接続を確立する
	 * @link http://www.php.net/manual/ja/mysqli.ssl-set.php
	 * @param link mysqli 
	 * @param key string <p>
	 * 鍵ファイルへのパス。
	 * </p>
	 * @param cert string <p>
	 * 証明書ファイルへのパス。
	 * </p>
	 * @param ca string <p>
	 * CA ファイルへのパス。
	 * </p>
	 * @param capath string <p>
	 * 信頼された SSL CA 証明書が PEM フォーマットで格納されているディレクトリへのパス。
	 * </p>
	 * @param cipher string <p>
	 * SSL の暗号化に使用可能な暗号形式の一覧。
	 * </p>
	 * @return bool この関数は、常に TRUE を返します。もし SSL が正しく設定できていない場合、
	 * mysqli_real_connect は接続時にエラーを返します。
	 */
	public function ssl_set (mysqli $link, $key, $cert, $ca, $capath, $cipher) {}

	/**
	 * 現在のシステム状態を取得する
	 * @link http://www.php.net/manual/ja/mysqli.stat.php
	 * @param link mysqli 
	 * @return string サーバーの状態を示す文字列を返します。エラー時には FALSE を返します。
	 */
	public function stat (mysqli $link) {}

	/**
	 * ステートメントを初期化し、mysqli_stmt_prepare で使用するオブジェクトを返す
	 * @link http://www.php.net/manual/ja/mysqli.stmt-init.php
	 * @param link mysqli 
	 * @return mysqli_stmt オブジェクトを返します。
	 */
	public function stmt_init (mysqli $link) {}

	/**
	 * 直近のクエリから結果セットを転送する
	 * @link http://www.php.net/manual/ja/mysqli.store-result.php
	 * @param link mysqli 
	 * @return mysqli_result バッファに格納した結果オブジェクトを返します。エラー時には FALSE を返します。
	 * </p>
	 * <p>
	 * mysqli_store_result は、クエリが結果セットを
	 * 返さなかった場合（例えば、クエリが INSERT 文であった場合）に
	 * FALSE を返します。また、結果セットの読み込みに失敗した場合にも
	 * FALSE を返します。エラーが発生したかどうかを調べるには、
	 * mysqli_error が空文字列以外を返す・
	 * mysqli_errno がゼロ以外の値を返す・あるいは
	 * mysqli_field_count がゼロ以外の値を返す
	 * のいずれかを確認します。それ以外にこの関数が FALSE を返す理由としては
	 * mysqli_query のコールに成功して返された
	 * 結果セットが大きすぎる（メモリに割り当てられない）場合がありえます。
	 * もし mysqli_field_count がゼロ以外の値を
	 * 返した場合、文は空でない結果セットを生成しています。
	 */
	public function store_result (mysqli $link) {}

	/**
	 * スレッドセーフであるかどうかを返す
	 * @link http://www.php.net/manual/ja/mysqli.thread-safe.php
	 * @return bool クライアントライブラリがスレッドセーフの場合に TRUE、
	 * そうでない場合に FALSE を返します。
	 */
	public function thread_safe () {}

	/**
	 * 結果セットの取得を開始する
	 * @link http://www.php.net/manual/ja/mysqli.use-result.php
	 * @param link mysqli 
	 * @return mysqli_result バッファに取得しないで結果オブジェクトを返します。
	 * エラー時には FALSE を返します。
	 */
	public function use_result (mysqli $link) {}

	/**
	 * リフレッシュする
	 * @link http://www.php.net/manual/ja/mysqli.refresh.php
	 * @param link resource 
	 * @param options int <p>
	 * リフレッシュのオプションを定数 MYSQLI_REFRESH_* で指定します。定数の意味は
	 * MySQLi 定数 のドキュメントを参照ください。
	 * </p>
	 * <p>
	 * 公式ドキュメントの MySQL Refresh
	 * も参照ください。
	 * </p>
	 * @return int リフレッシュに成功した場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function refresh ($link, $options) {}

}

final class mysqli_warning  {
	public $message;
	public $sqlstate;
	public $errno;


	/**
	 * コンストラクタ
	 * @link http://www.php.net/manual/ja/mysqli-warning.construct.php
	 */
	protected function __construct () {}

	/**
	 * next
	 * @link http://www.php.net/manual/ja/mysqli-warning.next.php
	 */
	public function next () {}

}

class mysqli_result implements Traversable {
	public $current_field;
	public $field_count;
	public $lengths;
	public $num_rows;
	public $type;


	public function __construct () {}

	public function close () {}

	/**
	 * 結果に関連付けられたメモリを開放する
	 * @link http://www.php.net/manual/ja/mysqli-result.free.php
	 * @return void 値を返しません。
	 */
	public function free () {}

	/**
	 * 結果の任意の行にポインタを移動する
	 * @link http://www.php.net/manual/ja/mysqli-result.data-seek.php
	 * @param result mysqli_result 
	 * @param offset int <p>
	 * フィールドオフセット。ゼロから全行数 - 1 までの間
	 * （0..mysqli_num_rows - 1）である必要があります。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function data_seek (mysqli_result $result, $offset) {}

	/**
	 * 結果セットの次のフィールドを返す
	 * @link http://www.php.net/manual/ja/mysqli-result.fetch-field.php
	 * @param result mysqli_result 
	 * @return object フィールド定義情報を含むオブジェクトを返します。もし
	 * フィールドの情報が取得できない場合は、FALSE を返します。
	 * </p>
	 * <p>
	 * <table>
	 * オブジェクトのプロパティ
	 * <tr valign="top">
	 * <td>プロパティ</td>
	 * <td>説明</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>name</td>
	 * <td>カラムの名前。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>orgname</td>
	 * <td>もしエイリアスが指定されている場合の、本来の名前。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>table</td>
	 * <td>フィールドが属するテーブルの名前。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>orgtable</td>
	 * <td>もしエイリアスが指定されている場合の、本来のテーブル名。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>def</td>
	 * <td>デフォルト値のために予約済。現在は常に ""。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>db</td>
	 * <td>データベース (PHP 5.3.6 以降)。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>catalog</td>
	 * <td>カタログ名。常に "def" (PHP 5.3.6 以降)。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>max_length</td>
	 * <td>結果セットにおけるフィールドの最大幅。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>length</td>
	 * <td>テーブルの定義で指定されているフィールド幅。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>charsetnr</td>
	 * <td>フィールドの文字セット番号。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>flags</td>
	 * <td>フィールドのビットフラグを整数型で表す。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>type</td>
	 * <td>フィールドのデータ型。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>decimals</td>
	 * <td>フィールドの桁数（integer 型のフィールド）。</td>
	 * </tr>
	 * </table>
	 */
	public function fetch_field (mysqli_result $result) {}

	/**
	 * 結果セットのフィールド情報をオブジェクトの配列で返す
	 * @link http://www.php.net/manual/ja/mysqli-result.fetch-fields.php
	 * @param result mysqli_result 
	 * @return array フィールド定義情報を含むオブジェクトの配列を返します。もし
	 * フィールドの情報が取得できない場合は、FALSE を返します。
	 * </p>
	 * <p>
	 * <table>
	 * オブジェクトのプロパティ
	 * <tr valign="top">
	 * <td>プロパティ</td>
	 * <td>説明</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>name</td>
	 * <td>カラムの名前。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>orgname</td>
	 * <td>もしエイリアスが指定されている場合の、本来の名前。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>table</td>
	 * <td>フィールドが属するテーブルの名前。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>orgtable</td>
	 * <td>もしエイリアスが指定されている場合の、本来のテーブル名。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>max_length</td>
	 * <td>結果セットにおけるフィールドの最大幅。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>length</td>
	 * <td>テーブルの定義で指定されているフィールド幅。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>charsetnr</td>
	 * <td>フィールドの文字セット番号。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>flags</td>
	 * <td>フィールドのビットフラグを整数型で表す。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>type</td>
	 * <td>フィールドのデータ型。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>decimals</td>
	 * <td>フィールドの桁数（integer 型のフィールド）。</td>
	 * </tr>
	 * </table>
	 */
	public function fetch_fields (mysqli_result $result) {}

	/**
	 * 単一のフィールドのメタデータを取得する
	 * @link http://www.php.net/manual/ja/mysqli-result.fetch-field-direct.php
	 * @param result mysqli_result 
	 * @param fieldnr int <p>
	 * フィールド番号。この値は
	 * 0 から フィールド数 - 1
	 * までの範囲でなければなりません。
	 * </p>
	 * @return object フィールド定義情報を含むオブジェクトを返します。もし、指定した
	 * fieldnr のフィールドの情報が取得できない場合は
	 * FALSE を返します。
	 * </p>
	 * <p>
	 * <table>
	 * オブジェクトの属性
	 * <tr valign="top">
	 * <td>属性</td>
	 * <td>説明</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>name</td>
	 * <td>カラムの名前。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>orgname</td>
	 * <td>もしエイリアスが指定されている場合の、本来の名前。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>table</td>
	 * <td>フィールドが属するテーブルの名前。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>orgtable</td>
	 * <td>もしエイリアスが指定されている場合の、本来のテーブル名。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>def</td>
	 * <td>フィールドのデフォルト値。文字列形式。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>max_length</td>
	 * <td>結果セットにおけるフィールドの最大幅。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>length</td>
	 * <td>テーブルの定義で指定されているフィールド幅。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>charsetnr</td>
	 * <td>フィールドの文字セット番号。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>flags</td>
	 * <td>フィールドのビットフラグを整数型で表す。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>type</td>
	 * <td>フィールドのデータ型。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>decimals</td>
	 * <td>フィールドの桁数（integer 型のフィールド）。</td>
	 * </tr>
	 * </table>
	 */
	public function fetch_field_direct (mysqli_result $result, $fieldnr) {}

	/**
	 * 結果のすべての行を連想配列・数値添字配列あるいはその両方の形式で取得する
	 * @link http://www.php.net/manual/ja/mysqli-result.fetch-all.php
	 * @param result mysqli_result 
	 * @param resulttype int[optional] <p>
	 * このオプションは、
	 * 結果の行データから返す配列の型を指定します。ここで指定可能な値は
	 * 定数 MYSQLI_ASSOC、
	 * MYSQLI_NUM あるいは MYSQLI_BOTH.
	 * のいずれかです。
	 * </p>
	 * @return mixed 結果の行を含む連想配列あるいは数値添字配列の配列を返します。
	 */
	public function fetch_all (mysqli_result $result, $resulttype = null) {}

	/**
	 * 結果の行を連想配列・数値添字配列あるいはその両方の形式で取得する
	 * @link http://www.php.net/manual/ja/mysqli-result.fetch-array.php
	 * @param result mysqli_result 
	 * @param resulttype int[optional] <p>
	 * このオプションは、
	 * 結果の行データから返す配列の型を指定します。ここで指定可能な値は
	 * 定数 MYSQLI_ASSOC、
	 * MYSQLI_NUM あるいは MYSQLI_BOTH.
	 * のいずれかです。
	 * </p>
	 * <p>
	 * MYSQLI_ASSOC 定数を指定すると、この関数は
	 * mysqli_fetch_assoc と同じ結果を返します。一方
	 * MYSQLI_NUM を指定すると、mysqli_fetch_row
	 * 関数と同じ結果となります。最後の MYSQLI_BOTH を指定すると、
	 * ひとつの配列にこれら両方の属性を含めます。
	 * </p>
	 * @return mixed 取得した行に対応する文字列の配列を返します。結果セットにもう行がない場合には
	 * NULL を返します。
	 */
	public function fetch_array (mysqli_result $result, $resulttype = null) {}

	/**
	 * 結果の行を連想配列で取得する
	 * @link http://www.php.net/manual/ja/mysqli-result.fetch-assoc.php
	 * @param result mysqli_result 
	 * @return array 取得した行に対応する文字列の連想配列を返します。
	 * 連想配列の各キーが、結果セットのカラムを表します。
	 * 結果セットにもう行がない場合には NULL を返します。
	 * </p>
	 * <p>
	 * もし 2 つ以上のカラムが同じフィールド名であった場合は、最後に現れた
	 * カラムが優先され、以前のデータを上書きします。同名の複数のカラムに
	 * アクセスする場合、mysqli_fetch_row を用いて
	 * 数値添字配列を使用するか、あるいはカラム名にエイリアスを指定する
	 * 必要があります。
	 */
	public function fetch_assoc (mysqli_result $result) {}

	/**
	 * 結果セットの現在の行をオブジェクトとして返す
	 * @link http://www.php.net/manual/ja/mysqli-result.fetch-object.php
	 * @param result mysqli_result 
	 * @param class_name string[optional] <p>
	 * インスタンス化してプロパティを設定後に返すクラスの名前。
	 * 省略した場合は stdClass オブジェクトを返します。
	 * </p>
	 * @param params array[optional] <p>
	 * オプションのパラメータの配列で、
	 * class_name オブジェクトのコンストラクタに渡します。
	 * </p>
	 * @return object 取得した行に対応する文字列プロパティを有するオブジェクトを返します。
	 * もし結果セットにもう行がない場合には NULL を返します。
	 */
	public function fetch_object (mysqli_result $result, $class_name = null, array $params = null) {}

	/**
	 * 結果の行を数値添字配列で取得する
	 * @link http://www.php.net/manual/ja/mysqli-result.fetch-row.php
	 * @param result mysqli_result 
	 * @return mixed mysqli_fetch_row は取得した行に対応する文字列の配列を
	 * 返します。もしもう行がない場合には NULL を返します。
	 */
	public function fetch_row (mysqli_result $result) {}

	/**
	 * 結果ポインタを、指定したフィールドオフセットに設定する
	 * @link http://www.php.net/manual/ja/mysqli-result.field-seek.php
	 * @param result mysqli_result 
	 * @param fieldnr int <p>
	 * フィールド番号。これは
	 * 0 から フィールド数 - 1
	 * までの範囲でなければなりません。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function field_seek (mysqli_result $result, $fieldnr) {}

	public function free_result () {}

}

class mysqli_stmt  {
	public $affected_rows;
	public $insert_id;
	public $num_rows;
	public $param_count;
	public $field_count;
	public $errno;
	public $error;
	public $error_list;
	public $sqlstate;
	public $id;


	public function __construct () {}

	/**
	 * ステートメントの属性の現在の値を取得する
	 * @link http://www.php.net/manual/ja/mysqli-stmt.attr-get.php
	 * @param stmt mysqli_stmt 
	 * @param attr int <p>
	 * 取得したい属性。
	 * </p>
	 * @return int 属性がみつからない場合は FALSE を、
	 * それ以外の場合はその属性の値を返します。
	 */
	public function attr_get (mysqli_stmt $stmt, $attr) {}

	/**
	 * プリペアドステートメントの振る舞いを変更する
	 * @link http://www.php.net/manual/ja/mysqli-stmt.attr-set.php
	 * @param stmt mysqli_stmt 
	 * @param attr int <p>
	 * 設定したい属性。次のいずれかの値となります。
	 * <table>
	 * 属性の値
	 * <tr valign="top">
	 * <td>文字</td>
	 * <td>説明</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>MYSQLI_STMT_ATTR_UPDATE_MAX_LENGTH</td>
	 * <td>
	 * 1 に設定すると、mysqli_stmt_store_result は
	 * メタデータ MYSQL_FIELD->max_length の値を上書きします。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>MYSQLI_STMT_ATTR_CURSOR_TYPE</td>
	 * <td>
	 * mysqli_stmt_execute
	 * が起動された際にステートメントをオープンするためのカーソル型。
	 * mode は、MYSQLI_CURSOR_TYPE_NO_CURSOR
	 * (デフォルト) あるいは MYSQLI_CURSOR_TYPE_READ_ONLY となります。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>MYSQLI_STMT_ATTR_PREFETCH_ROWS</td>
	 * <td>
	 * カーソルの使用時にサーバーからいちどに取得する行数。
	 * mode に指定できる値の範囲は
	 * 1 から unsigned long の最大値までで、デフォルトは 1 です。
	 * </td>
	 * </tr>
	 * </table>
	 * </p>
	 * <p>
	 * MYSQLI_STMT_ATTR_CURSOR_TYPE オプションで
	 * MYSQLI_CURSOR_TYPE_READ_ONLY を使用すると、
	 * mysqli_stmt_execute
	 * を起動した際にそのステートメント用のカーソルをオープンします。
	 * 以前に mysqli_stmt_execute
	 * をコールした際にオープンしたカーソルが残っている場合は、
	 * それを閉じてから新しいカーソルをオープンします。また
	 * mysqli_stmt_reset
	 * も、オープンしているカーソルをすべて閉じてからステートメント再実行の準備をします。
	 * mysqli_stmt_free_result
	 * は、オープンしているカーソルをすべて閉じます。
	 * </p>
	 * <p>
	 * プリペアドステートメント用のカーソルをオープンするのなら
	 * mysqli_stmt_store_result は不要です。
	 * </p>
	 * @param mode int <p>属性に割り当てるモード。</p>
	 * @return bool 
	 */
	public function attr_set (mysqli_stmt $stmt, $attr, $mode) {}

	/**
	 * プリペアドステートメントのパラメータに変数をバインドする
	 * @link http://www.php.net/manual/ja/mysqli-stmt.bind-param.php
	 * @param stmt mysqli_stmt 
	 * @param types string <p>
	 * ひとつあるいは複数の文字で、対応するバインド変数の型を表します。
	 * <table>
	 * 型指定文字
	 * <tr valign="top">
	 * <td>文字</td>
	 * <td>説明</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>i</td>
	 * <td>対応する変数の型は integer です。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>d</td>
	 * <td>対応する変数の型は double です。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>s</td>
	 * <td>対応する変数の型は string です。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>b</td>
	 * <td>対応する変数の型は blob で、複数のパケットに分割して送信されます。</td>
	 * </tr>
	 * </table>
	 * </p>
	 * @param var1 mixed <p>
	 * 変数の数。文字列
	 * types
	 * の長さは、ステートメント中のパラメータの数と一致する必要があります。
	 * </p>
	 * @param _ mixed[optional] 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function bind_param (mysqli_stmt $stmt, $types, &$var1, &$_ = null) {}

	/**
	 * 結果を保存するため、プリペアドステートメントに変数をバインドする
	 * @link http://www.php.net/manual/ja/mysqli-stmt.bind-result.php
	 * @param stmt mysqli_stmt 
	 * @param var1 mixed <p>
	 * バインドする変数。
	 * </p>
	 * @param _ mixed[optional] 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function bind_result (mysqli_stmt $stmt, &$var1, &$_ = null) {}

	/**
	 * プリペアドステートメントを閉じる
	 * @link http://www.php.net/manual/ja/mysqli-stmt.close.php
	 * @param stmt mysqli_stmt 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function close (mysqli_stmt $stmt) {}

	/**
	 * ステートメントの結果セットの任意の行に移動する
	 * @link http://www.php.net/manual/ja/mysqli-stmt.data-seek.php
	 * @param stmt mysqli_stmt 
	 * @param offset int <p>
	 * ゼロから行の総数 - 1（0..mysqli_stmt_num_rows - 1）
	 * までの間である必要があります。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function data_seek (mysqli_stmt $stmt, $offset) {}

	/**
	 * プリペアドクエリを実行する
	 * @link http://www.php.net/manual/ja/mysqli-stmt.execute.php
	 * @param stmt mysqli_stmt 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function execute (mysqli_stmt $stmt) {}

	/**
	 * プリペアドステートメントから結果を取得し、バインド変数に格納する
	 * @link http://www.php.net/manual/ja/mysqli-stmt.fetch.php
	 * @param stmt mysqli_stmt 
	 * @return bool 
	 */
	public function fetch (mysqli_stmt $stmt) {}

	/**
	 * SHOW WARNINGS の結果を取得する
	 * @link http://www.php.net/manual/ja/mysqli-stmt.get-warnings.php
	 * @param stmt mysqli_stmt 
	 * @return object 
	 */
	public function get_warnings (mysqli_stmt $stmt) {}

	/**
	 * プリペアドステートメントから結果セットのメタデータを返す
	 * @link http://www.php.net/manual/ja/mysqli-stmt.result-metadata.php
	 * @param stmt mysqli_stmt 
	 * @return mysqli_result 結果のオブジェクトを返します。エラー時には FALSE を返します。
	 */
	public function result_metadata (mysqli_stmt $stmt) {}

	/**
	 * 複数クエリで、次の結果が存在するかどうかを調べる
	 * @link http://www.php.net/manual/ja/mysqli-stmt.more-results.php
	 * @return bool 結果がさらに存在する場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function more_results () {}

	/**
	 * 複数クエリから、次の結果を読み込む
	 * @link http://www.php.net/manual/ja/mysqli-stmt.next-result.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function next_result () {}

	public function num_rows () {}

	/**
	 * データをブロックで送信する
	 * @link http://www.php.net/manual/ja/mysqli-stmt.send-long-data.php
	 * @param stmt mysqli_stmt 
	 * @param param_nr int <p>
	 * データに関連付けるパラメータを示します。
	 * パラメータの番号は 0 から始まります。
	 * </p>
	 * @param data string <p>
	 * 送信するデータを含む文字列。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function send_long_data (mysqli_stmt $stmt, $param_nr, $data) {}

	/**
	 * 指定したステートメントハンドルの結果を格納したメモリを開放する
	 * @link http://www.php.net/manual/ja/mysqli-stmt.free-result.php
	 * @param stmt mysqli_stmt 
	 * @return void 値を返しません。
	 */
	public function free_result (mysqli_stmt $stmt) {}

	/**
	 * プリペアドステートメントをリセットする
	 * @link http://www.php.net/manual/ja/mysqli-stmt.reset.php
	 * @param stmt mysqli_stmt 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function reset (mysqli_stmt $stmt) {}

	/**
	 * SQL ステートメントを実行するために準備する
	 * @link http://www.php.net/manual/ja/mysqli-stmt.prepare.php
	 * @param stmt mysqli_stmt 
	 * @param query string <p>
	 * クエリを表す文字列。単一の SQL 文で構成されている必要があります。
	 * </p>
	 * <p>
	 * ひとつまたは複数のパラメータを SQL 文に含めることができます。
	 * そのためには、適切な位置にクエスチョンマーク
	 * (?) を埋め込みます。
	 * </p>
	 * <p>
	 * ステートメントの最後にセミコロンや \g
	 * を追加してはいけません。
	 * </p>
	 * <p>
	 * パラメータのマーカは、それが SQL 文の適切な位置にある場合のみ
	 * 有効です。例えば INSERT 文の VALUES() リストの中
	 * (行に登録するカラム値を指定する) や 
	 * WHERE 句で列のデータと比較する値などが適切な位置の例です。
	 * </p>
	 * <p>
	 * しかし、識別子 (テーブルやカラムの名前) や SELECT 文で選択する
	 * 項目の名前に指定したり、(等号 = のような)
	 * 二項演算子の両側にパラメータを指定したりすることはできません。
	 * 後者の制限は、パラメータの型が判断できなくなることによるものです。
	 * また、パラメータのマーカを NULL と比較して
	 * ? IS NULL のようにすることもできません。
	 * 一般に、パラメータが使用可能なのはデータ操作言語 (DML)
	 * ステートメントであり、データ定義言語 (DDL) ステートメントでは
	 * 使用できません。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function prepare (mysqli_stmt $stmt, $query) {}

	/**
	 * プリペアドステートメントから結果を転送する
	 * @link http://www.php.net/manual/ja/mysqli-stmt.store-result.php
	 * @param stmt mysqli_stmt 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function store_result (mysqli_stmt $stmt) {}

	/**
	 * プリペアード・ステートメントから結果セットを取得
	 * @link http://www.php.net/manual/ja/mysqli-stmt.get-result.php
	 * @param stmt mysqli_stmt 
	 * @return mysqli_result 結果セット、失敗した場合に FALSE を返します 。
	 */
	public function get_result (mysqli_stmt $stmt) {}

}

/**
 * @param link
 */
function mysqli_affected_rows ($link) {}

/**
 * @param link
 * @param mode
 */
function mysqli_autocommit ($link, $mode) {}

/**
 * @param link
 * @param user
 * @param password
 * @param database
 */
function mysqli_change_user ($link, $user, $password, $database) {}

/**
 * @param link
 */
function mysqli_character_set_name ($link) {}

/**
 * @param link
 */
function mysqli_close ($link) {}

/**
 * @param link
 */
function mysqli_commit ($link) {}

/**
 * <methodname>mysqli::__construct</methodname> のエイリアス
 * @link http://www.php.net/manual/ja/function.mysqli-connect.php
 * @param host[optional]
 * @param user[optional]
 * @param password[optional]
 * @param database[optional]
 * @param port[optional]
 * @param socket[optional]
 */
function mysqli_connect ($host, $user, $password, $database, $port, $socket) {}

function mysqli_connect_errno () {}

function mysqli_connect_error () {}

/**
 * @param result
 * @param offset
 */
function mysqli_data_seek ($result, $offset) {}

/**
 * @param link
 */
function mysqli_dump_debug_info ($link) {}

/**
 * @param debug_options
 */
function mysqli_debug ($debug_options) {}

/**
 * @param link
 */
function mysqli_errno ($link) {}

/**
 * @param link
 */
function mysqli_error ($link) {}

/**
 * @param link
 */
function mysqli_error_list ($link) {}

/**
 * @param stmt
 */
function mysqli_stmt_execute ($stmt) {}

/**
 * <function>mysqli_stmt_execute</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.mysqli-execute.php
 * @param stmt
 */
function mysqli_execute ($stmt) {}

/**
 * @param result
 */
function mysqli_fetch_field ($result) {}

/**
 * @param result
 */
function mysqli_fetch_fields ($result) {}

/**
 * @param result
 * @param field_nr
 */
function mysqli_fetch_field_direct ($result, $field_nr) {}

/**
 * @param result
 */
function mysqli_fetch_lengths ($result) {}

/**
 * @param result
 */
function mysqli_fetch_all ($result) {}

/**
 * @param result
 * @param result_type[optional]
 */
function mysqli_fetch_array ($result, $result_type) {}

/**
 * @param result
 */
function mysqli_fetch_assoc ($result) {}

/**
 * @param result
 * @param class_name[optional]
 * @param params[optional]
 */
function mysqli_fetch_object ($result, $class_namearray , $params) {}

/**
 * @param result
 */
function mysqli_fetch_row ($result) {}

/**
 * @param link
 */
function mysqli_field_count ($link) {}

/**
 * @param result
 * @param field_nr
 */
function mysqli_field_seek ($result, $field_nr) {}

/**
 * @param result
 */
function mysqli_field_tell ($result) {}

/**
 * @param result
 */
function mysqli_free_result ($result) {}

/**
 * @param link
 */
function mysqli_get_connection_stats ($link) {}

/**
 * クライアントのプロセス単位の統計情報を返す
 * @link http://www.php.net/manual/ja/mysqli.get-client-stats.php
 * @return array 成功した場合にクライアントの統計情報を含む配列、それ以外の場合に FALSE を返します。
 */
function mysqli_get_client_stats () {}

/**
 * @param link
 */
function mysqli_get_charset ($link) {}

/**
 * @param link
 */
function mysqli_get_client_info ($link) {}

/**
 * MySQL クライアントのバージョンを文字列で返す
 * @link http://www.php.net/manual/ja/mysqli.get-client-version.php
 * @param link mysqli 
 * @return int MySQL クライアントライブラリのバージョンを、以下の書式で返します。
 * main_version*10000 + minor_version *100 + sub_version
 * 例えば、4.1.0 は 40100 となります。
 * </p>
 * <p>
 * これは、ある機能が使用可能かどうかを知るため、クライアントライブラリの
 * バージョンを手っ取り早く調べたい場合に有用です。
 */
function mysqli_get_client_version (mysqli $link) {}

/**
 * @param link
 */
function mysqli_get_host_info ($link) {}

/**
 * @param link
 */
function mysqli_get_proto_info ($link) {}

/**
 * @param link
 */
function mysqli_get_server_info ($link) {}

/**
 * @param link
 */
function mysqli_get_server_version ($link) {}

/**
 * @param link
 */
function mysqli_get_warnings ($link) {}

function mysqli_init () {}

/**
 * @param link
 */
function mysqli_info ($link) {}

/**
 * @param link
 */
function mysqli_insert_id ($link) {}

/**
 * @param link
 * @param connection_id
 */
function mysqli_kill ($link, $connection_id) {}

/**
 * @param link
 */
function mysqli_more_results ($link) {}

/**
 * @param link
 * @param query
 */
function mysqli_multi_query ($link, $query) {}

/**
 * @param link
 */
function mysqli_next_result ($link) {}

/**
 * @param result
 */
function mysqli_num_fields ($result) {}

/**
 * @param result
 */
function mysqli_num_rows ($result) {}

/**
 * @param link
 * @param option
 * @param value
 */
function mysqli_options ($link, $option, $value) {}

/**
 * @param link
 */
function mysqli_ping ($link) {}

/**
 * @param read
 * @param write
 * @param error
 * @param sec
 * @param usec[optional]
 */
function mysqli_poll (array &$read = nullarray , &$write = nullarray , &$error = null, $sec, $usec) {}

/**
 * @param link
 * @param query
 */
function mysqli_prepare ($link, $query) {}

/**
 * <link linkend="mysqli-driver.report-mode">mysqli_driver->report_mode</link> のエイリアス
 * @link http://www.php.net/manual/ja/function.mysqli-report.php
 * @param flags
 */
function mysqli_report ($flags) {}

/**
 * @param link
 * @param query
 */
function mysqli_query ($link, $query) {}

/**
 * @param link
 * @param host[optional]
 * @param user[optional]
 * @param password[optional]
 * @param database[optional]
 * @param port[optional]
 * @param socket[optional]
 * @param flags[optional]
 */
function mysqli_real_connect ($link, $host, $user, $password, $database, $port, $socket, $flags) {}

/**
 * @param link
 * @param string_to_escape
 */
function mysqli_real_escape_string ($link, $string_to_escape) {}

/**
 * @param link
 * @param query
 */
function mysqli_real_query ($link, $query) {}

/**
 * @param link
 */
function mysqli_reap_async_query ($link) {}

/**
 * @param link
 */
function mysqli_rollback ($link) {}

/**
 * @param link
 * @param database
 */
function mysqli_select_db ($link, $database) {}

/**
 * @param link
 * @param charset
 */
function mysqli_set_charset ($link, $charset) {}

/**
 * @param stmt
 */
function mysqli_stmt_affected_rows ($stmt) {}

/**
 * @param stmt
 * @param attribute
 */
function mysqli_stmt_attr_get ($stmt, $attribute) {}

/**
 * @param stmt
 * @param attribute
 * @param value
 */
function mysqli_stmt_attr_set ($stmt, $attribute, $value) {}

/**
 * @param stmt
 * @param types
 */
function mysqli_stmt_bind_param ($stmt, $types) {}

/**
 * @param stmt
 */
function mysqli_stmt_bind_result ($stmt) {}

/**
 * @param stmt
 */
function mysqli_stmt_close ($stmt) {}

/**
 * @param stmt
 * @param offset
 */
function mysqli_stmt_data_seek ($stmt, $offset) {}

/**
 * @param stmt
 */
function mysqli_stmt_errno ($stmt) {}

/**
 * @param stmt
 */
function mysqli_stmt_error ($stmt) {}

/**
 * @param stmt
 */
function mysqli_stmt_error_list ($stmt) {}

/**
 * @param stmt
 */
function mysqli_stmt_fetch ($stmt) {}

/**
 * @param stmt
 */
function mysqli_stmt_field_count ($stmt) {}

/**
 * @param stmt
 */
function mysqli_stmt_free_result ($stmt) {}

/**
 * @param stmt
 */
function mysqli_stmt_get_result ($stmt) {}

/**
 * @param stmt
 */
function mysqli_stmt_get_warnings ($stmt) {}

/**
 * @param link
 */
function mysqli_stmt_init ($link) {}

/**
 * @param stmt
 */
function mysqli_stmt_insert_id ($stmt) {}

/**
 * @param stmt
 */
function mysqli_stmt_more_results ($stmt) {}

/**
 * @param stmt
 */
function mysqli_stmt_next_result ($stmt) {}

/**
 * @param stmt
 */
function mysqli_stmt_num_rows ($stmt) {}

/**
 * @param stmt
 */
function mysqli_stmt_param_count ($stmt) {}

/**
 * @param stmt
 * @param query
 */
function mysqli_stmt_prepare ($stmt, $query) {}

/**
 * @param stmt
 */
function mysqli_stmt_reset ($stmt) {}

/**
 * @param stmt
 */
function mysqli_stmt_result_metadata ($stmt) {}

/**
 * @param stmt
 * @param param_nr
 * @param data
 */
function mysqli_stmt_send_long_data ($stmt, $param_nr, $data) {}

/**
 * @param stmt
 */
function mysqli_stmt_store_result ($stmt) {}

/**
 * @param stmt
 */
function mysqli_stmt_sqlstate ($stmt) {}

/**
 * @param link
 */
function mysqli_sqlstate ($link) {}

/**
 * @param link
 * @param key
 * @param cert
 * @param certificate_authority
 * @param certificate_authority_path
 * @param cipher
 */
function mysqli_ssl_set ($link, $key, $cert, $certificate_authority, $certificate_authority_path, $cipher) {}

/**
 * @param link
 */
function mysqli_stat ($link) {}

/**
 * @param link
 */
function mysqli_store_result ($link) {}

/**
 * @param link
 */
function mysqli_thread_id ($link) {}

function mysqli_thread_safe () {}

/**
 * @param link
 */
function mysqli_use_result ($link) {}

/**
 * @param link
 */
function mysqli_warning_count ($link) {}

/**
 * @param link
 * @param options
 */
function mysqli_refresh ($link, $options) {}

/**
 * <function>mysqli_real_escape_string</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.mysqli-escape-string.php
 * @param link
 * @param query
 */
function mysqli_escape_string ($link, $query) {}

/**
 * <function>mysqli_options</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.mysqli-set-opt.php
 */
function mysqli_set_opt () {}


/**
 * <p>
 * my.cnf の指定した名前のグループか、
 * あるいは MYSQLI_READ_DEFAULT_FILE
 * で指定したファイルからオプションを読み込みます。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_READ_DEFAULT_GROUP', 5);

/**
 * <p>
 * my.cnf のかわりに、指定したファイルからオプションを
 * 読み込みます。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_READ_DEFAULT_FILE', 4);

/**
 * <p>
 * 接続のタイムアウトまでの秒数。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_OPT_CONNECT_TIMEOUT', 0);

/**
 * <p>
 * LOAD LOCAL INFILE コマンドを有効にします。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_OPT_LOCAL_INFILE', 8);

/**
 * <p>
 * MySQL サーバーへの接続時に実行するコマンド。
 * 再接続時にも自動的に再実行されます。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_INIT_COMMAND', 3);
define ('MYSQLI_OPT_NET_CMD_BUFFER_SIZE', 202);
define ('MYSQLI_OPT_NET_READ_BUFFER_SIZE', 203);
define ('MYSQLI_OPT_INT_AND_FLOAT_NATIVE', 201);
define ('MYSQLI_OPT_SSL_VERIFY_SERVER_CERT', 21);

/**
 * <p>
 * SSL（暗号化プロトコル）を使用します。このオプションは、アプリケーション
 * プログラムで指定することはできず、MySQL クライアントライブラリの内部で設定します。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_CLIENT_SSL', 2048);

/**
 * <p>
 * 圧縮プロトコルを使用します。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_CLIENT_COMPRESS', 32);

/**
 * <p>
 * （wait_timeout のかわりに）interactive_timeout の秒数を使用できるように
 * します。クライアントセッションの wait_timeout 変数の値は、interactive_timeout
 * 変数の値に設定されます。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_CLIENT_INTERACTIVE', 1024);

/**
 * <p>
 * 関数名に続く空白文字を許可します。すべての関数名を予約語とします。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_CLIENT_IGNORE_SPACE', 256);

/**
 * <p>
 * db_name.tbl_name.col_name 形式の使用を禁止します。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_CLIENT_NO_SCHEMA', 16);
define ('MYSQLI_CLIENT_FOUND_ROWS', 2);

/**
 * <p>
 * 結果セットをバッファに格納します。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_STORE_RESULT', 0);

/**
 * <p>
 * 結果セットをバッファに格納しません。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_USE_RESULT', 1);
define ('MYSQLI_ASYNC', 8);

/**
 * <p>
 * 行データを、カラム名をインデックスとする配列に格納して返します。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_ASSOC', 1);

/**
 * <p>
 * 行データを、数値インデックスの配列に格納して返します。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_NUM', 2);

/**
 * <p>
 * 行データを、数値インデックス・カラム名インデックスの両方を
 * 保持する配列に格納して返します。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_BOTH', 3);

/**
 * <p>
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_STMT_ATTR_UPDATE_MAX_LENGTH', 0);

/**
 * <p>
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_STMT_ATTR_CURSOR_TYPE', 1);

/**
 * <p>
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_CURSOR_TYPE_NO_CURSOR', 0);

/**
 * <p>
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_CURSOR_TYPE_READ_ONLY', 1);

/**
 * <p>
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_CURSOR_TYPE_FOR_UPDATE', 2);

/**
 * <p>
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_CURSOR_TYPE_SCROLLABLE', 4);

/**
 * <p>
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_STMT_ATTR_PREFETCH_ROWS', 2);

/**
 * <p>
 * フィールドは、NOT NULL と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_NOT_NULL_FLAG', 1);

/**
 * <p>
 * フィールドは、プライマリキーの一部です。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_PRI_KEY_FLAG', 2);

/**
 * <p>
 * フィールドは、ユニークキーの一部です。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_UNIQUE_KEY_FLAG', 4);

/**
 * <p>
 * フィールドは、インデックスの一部です。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_MULTIPLE_KEY_FLAG', 8);

/**
 * <p>
 * フィールドは BLOB と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_BLOB_FLAG', 16);

/**
 * <p>
 * フィールドは UNSIGNED と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_UNSIGNED_FLAG', 32);

/**
 * <p>
 * フィールドは ZEROFILL と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_ZEROFILL_FLAG', 64);

/**
 * <p>
 * フィールドは AUTO_INCREMENT と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_AUTO_INCREMENT_FLAG', 512);

/**
 * <p>
 * フィールドは TIMESTAMP と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TIMESTAMP_FLAG', 1024);

/**
 * <p>
 * フィールドは SET と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_SET_FLAG', 2048);

/**
 * <p>
 * フィールドは NUMERIC と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_NUM_FLAG', 32768);

/**
 * <p>
 * フィールドは、マルチインデックスの一部です。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_PART_KEY_FLAG', 16384);

/**
 * <p>
 * フィールドは GROUP BY の一部です。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_GROUP_FLAG', 32768);

/**
 * <p>
 * フィールドが ENUM として定義されています。PHP 5.3.0 以降で使用可能です。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_ENUM_FLAG', 256);
define ('MYSQLI_BINARY_FLAG', 128);
define ('MYSQLI_NO_DEFAULT_VALUE_FLAG', 4096);
define ('MYSQLI_ON_UPDATE_NOW_FLAG', 8192);

/**
 * <p>
 * フィールドは DECIMAL と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_DECIMAL', 0);

/**
 * <p>
 * フィールドは TINYINT と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_TINY', 1);

/**
 * <p>
 * フィールドは SMALLINT と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_SHORT', 2);

/**
 * <p>
 * フィールドは INT と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_LONG', 3);

/**
 * <p>
 * フィールドは FLOAT と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_FLOAT', 4);

/**
 * <p>
 * フィールドは DOUBLE と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_DOUBLE', 5);

/**
 * <p>
 * フィールドは DEFAULT NULL と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_NULL', 6);

/**
 * <p>
 * フィールドは TIMESTAMP と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_TIMESTAMP', 7);

/**
 * <p>
 * フィールドは BIGINT と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_LONGLONG', 8);

/**
 * <p>
 * フィールドは MEDIUMINT と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_INT24', 9);

/**
 * <p>
 * フィールドは DATE と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_DATE', 10);

/**
 * <p>
 * フィールドは TIME と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_TIME', 11);

/**
 * <p>
 * フィールドは DATETIME と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_DATETIME', 12);

/**
 * <p>
 * フィールドは YEAR と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_YEAR', 13);

/**
 * <p>
 * フィールドは DATE と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_NEWDATE', 14);

/**
 * <p>
 * フィールドは ENUM と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_ENUM', 247);

/**
 * <p>
 * フィールドは SET と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_SET', 248);

/**
 * <p>
 * フィールドは TINYBLOB と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_TINY_BLOB', 249);

/**
 * <p>
 * フィールドは MEDIUMBLOB と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_MEDIUM_BLOB', 250);

/**
 * <p>
 * フィールドは LONGBLOB と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_LONG_BLOB', 251);

/**
 * <p>
 * フィールドは BLOB と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_BLOB', 252);

/**
 * <p>
 * フィールドは VARCHAR あるいは BINARY と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_VAR_STRING', 253);

/**
 * <p>
 * フィールドは STRING と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_STRING', 254);

/**
 * <p>
 * フィールドは TINYINT と定義されています。
 * CHAR については MYSQLI_TYPE_STRING を参照ください。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_CHAR', 1);

/**
 * <p>
 * フィールドは INTERVAL と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_INTERVAL', 247);

/**
 * <p>
 * フィールドは GEOMETRY と定義されています。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_GEOMETRY', 255);

/**
 * <p>
 * 精密な DECIMAL あるいは NUMERIC のフィールドです (MySQL 5.0.3 以降)。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_NEWDECIMAL', 246);

/**
 * <p>
 * フィールドは BIT と定義されています (MySQL 5.0.3 以降)。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_TYPE_BIT', 16);

/**
 * <p>
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_SET_CHARSET_NAME', 7);
define ('MYSQLI_SET_CHARSET_DIR', 6);

/**
 * <p>
 * バインド変数に使用可能なデータがありません。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_NO_DATA', 100);

/**
 * <p>
 * データのトランケーションが発生しました。PHP 5.1.0 および MySQL 5.0.5 以降で使用可能です。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_DATA_TRUNCATED', 101);

/**
 * <p>
 * クエリ内でインデックスが使われていなかったり間違ったインデックスを使っていたりする場合に報告します。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_REPORT_INDEX', 4);

/**
 * <p>
 * mysqli 関数コールのエラーを報告します。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_REPORT_ERROR', 1);

/**
 * <p>
 * エラー時に、警告の代わりに mysqli_sql_exception をスローします。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_REPORT_STRICT', 2);

/**
 * <p>
 * すべてのオプションを有効にします (すべてを報告します)。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_REPORT_ALL', 255);

/**
 * <p>
 * 報告を無効にします。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_REPORT_OFF', 0);

/**
 * <p>
 * mysqli_debug 機能が有効の場合に 1 が設定されます。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_DEBUG_TRACE_ENABLED', 0);

/**
 * <p>
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_SERVER_QUERY_NO_GOOD_INDEX_USED', 16);

/**
 * <p>
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_SERVER_QUERY_NO_INDEX_USED', 32);
define ('MYSQLI_SERVER_QUERY_WAS_SLOW', 2048);
define ('MYSQLI_SERVER_PS_OUT_PARAMS', 4096);

/**
 * <p>
 * 権限テーブルをリフレッシュします。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_REFRESH_GRANT', 1);

/**
 * <p>
 * ログをフラッシュします。SQL 文
 * FLUSH LOGS を実行するのと同じです。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_REFRESH_LOG', 2);

/**
 * <p>
 * テーブルキャッシュをフラッシュします。SQL 文
 * FLUSH TABLES を実行するのと同じです。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_REFRESH_TABLES', 4);

/**
 * <p>
 * ホストキャッシュをフラッシュします。SQL 文
 * FLUSH HOSTS を実行するのと同じです。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_REFRESH_HOSTS', 8);

/**
 * <p>
 * 状態変数をリセットします。SQL 文
 * FLUSH STATUS を実行するのと同じです。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_REFRESH_STATUS', 16);

/**
 * <p>
 * スレッドキャッシュをフラッシュします。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_REFRESH_THREADS', 32);

/**
 * <p>
 * レプリケーションのスレーブ側のサーバーで、
 * マスタサーバーの情報をリセットしてスレーブを再起動します。
 * SQL 文
 * RESET SLAVE を実行するのと同じです。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_REFRESH_SLAVE', 64);

/**
 * <p>
 * レプリケーションのマスタ側のサーバーで、
 * バイナリログインデックスにあるバイナリログファイルを削除してインデックスファイルを切り詰めます。
 * SQL 文
 * RESET MASTER を実行するのと同じです。
 * </p>
 * @link http://www.php.net/manual/ja/mysqli.constants.php
 */
define ('MYSQLI_REFRESH_MASTER', 128);
define ('MYSQLI_REFRESH_BACKUP_LOG', 2097152);

// End of mysqli v.0.1
?>
