<?php

// Start of mysql v.1.0

/**
 * MySQL サーバーへの接続をオープンする
 * @link http://www.php.net/manual/ja/function.mysql-connect.php
 * @param server string[optional] <p>
 * MySQL サーバー。"hostname:port" のようにポート番号を
 * 指定することが可能で、localhost では ":/path/to/socket"
 * のようにソケットへのパスを指定することも可能です。
 * </p>
 * <p>
 * PHP ディレクティブ 
 * mysql.default_host が指定されない場合（デフォルト）、
 * 'localhost:3306' が使用されます。
 * SQL セーフモード の場合はこのパラメータは無視され、常に
 * 'localhost:3306' が用いられます。
 * </p>
 * @param username string[optional] <p>
 * ユーザー名。デフォルト値は mysql.default_user
 * で定義されている値です。SQL セーフモード の場合はこのパラメータは無視され、
 * サーバープロセスの所有ユーザー名が用いられます。
 * </p>
 * @param password string[optional] <p>
 * パスワード。デフォルト値は mysql.default_password
 * で定義されている値です。SQL セーフモード の場合はこのパラメータは無視され、
 * 空のパスワードが用いられます。
 * </p>
 * @param new_link bool[optional] <p>
 * 同じ引数で 2 回 mysql_connect をコールした場合、
 * 2 回目は新規のリンクが確立されるのではなく、代わりにすでにオープンされた
 * リンクのリンク ID が返されます。
 * パラメータ new_link はこの動作を変更し、既に
 * mysql_connect が同じパラメータでコールされて
 * いる場合でも常に新規のリンクがオープンされるようにします。
 * SQL セーフモード の場合はこのパラメータは無視されます。
 * </p>
 * @param client_flags int[optional] <p>
 * パラメータ client_flags は、
 * 以下の定数の組み合わせです：
 * 128 (LOAD DATA LOCAL の処理を有効にする)、
 * MYSQL_CLIENT_SSL、
 * MYSQL_CLIENT_COMPRESS、
 * MYSQL_CLIENT_IGNORE_SPACE または
 * MYSQL_CLIENT_INTERACTIVE。
 * 詳細な情報については 
 * を参照ください。
 * SQL セーフモード の場合はこのパラメータは無視されます。
 * </p>
 * @return resource 成功した場合に MySQL リンク ID を、失敗した場合に FALSE を返します。
 */
function mysql_connect ($server = null, $username = null, $password = null, $new_link = null, $client_flags = null) {}

/**
 * MySQL サーバーへの持続的な接続をオープンする
 * @link http://www.php.net/manual/ja/function.mysql-pconnect.php
 * @param server string[optional] <p>
 * MySQL サーバー。"hostname:port" のようにポート番号を
 * 指定することが可能で、localhost では ":/path/to/socket"
 * のようにソケットへのパスを指定することも可能です。
 * </p>
 * <p>
 * PHP ディレクティブ 
 * mysql.default_host が指定されない場合（デフォルト）、
 * 'localhost:3306' が使用されます。
 * </p>
 * @param username string[optional] <p>
 * ユーザー名。デフォルト値はサーバープロセスの所有ユーザー名です。
 * </p>
 * @param password string[optional] <p>
 * パスワード。デフォルト値は空のパスワードです。
 * </p>
 * @param client_flags int[optional] <p>
 * パラメータ client_flags は、
 * 以下の定数の組み合わせです：
 * 128 (LOAD DATA LOCAL の処理を有効にする)、
 * MYSQL_CLIENT_SSL、
 * MYSQL_CLIENT_COMPRESS、
 * MYSQL_CLIENT_IGNORE_SPACE または
 * MYSQL_CLIENT_INTERACTIVE
 * </p>
 * @return resource 成功した場合に MySQL 持続的リンク ID を、失敗した場合に FALSE を返します。
 */
function mysql_pconnect ($server = null, $username = null, $password = null, $client_flags = null) {}

/**
 * MySQL 接続を閉じる
 * @link http://www.php.net/manual/ja/function.mysql-close.php
 * @param link_identifier resource[optional] 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function mysql_close ($link_identifier = null) {}

/**
 * MySQL データベースを選択する
 * @link http://www.php.net/manual/ja/function.mysql-select-db.php
 * @param database_name string <p>
 * 選択するデータベース名。
 * </p>
 * @param link_identifier resource[optional] 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function mysql_select_db ($database_name, $link_identifier = null) {}

/**
 * MySQL クエリを送信する
 * @link http://www.php.net/manual/ja/function.mysql-query.php
 * @param query string <p>
 * SQL クエリ。
 * </p>
 * <p>
 * クエリ文字列は、セミコロンで終えてはいけません。
 * クエリ内のデータは 適切にエスケープ
 * する必要があります。
 * </p>
 * @param link_identifier resource[optional] 
 * @return resource SELECT, SHOW, DESCRIBE や EXPLAIN 文、その他結果セットを返す文では、
 * mysql_query は成功した場合に
 * resource を返します。エラー時には FALSE を返します。
 * </p>
 * <p>
 * それ以外の SQL 文 INSERT, UPDATE, DELETE, DROP などでは、
 * mysql_query は成功した場合に
 * TRUE 、エラー時に FALSE を返します。
 * </p>
 * <p>
 * 返された結果にアクセスするためには、結果リソースを
 * mysql_fetch_array やその他の関数に渡します。
 * </p>
 * <p>
 * SELECT 文によって返された行の数を知るには
 * mysql_num_rows を用います。また
 * DELETE, INSERT, REPLACE, または UPDATE 文で変更された行の数を
 * 知るには mysql_affected_rows を用います。
 * </p>
 * <p>
 * クエリが参照するテーブルにアクセスする権限がない場合も
 * mysql_queryは失敗し、FALSE が返されます。
 */
function mysql_query ($query, $link_identifier = null) {}

/**
 * MySQL に SQL クエリを送信するが、結果に対してのフェッチやバッファリングは行わない
 * @link http://www.php.net/manual/ja/function.mysql-unbuffered-query.php
 * @param query string <p>
 * 実行する SQL クエリ。
 * </p>
 * <p>
 * クエリ内のデータは 適切にエスケープ
 * する必要があります。
 * </p>
 * @param link_identifier resource[optional] 
 * @return resource SELECT, SHOW, DESCRIBE あるいは EXPLAIN では、
 * mysql_unbuffered_query は
 * 成功した場合に resource 、エラー時に FALSE を返します。
 * </p>
 * <p>
 * UPDATE, DELETE, DROP, などその他の SQL 文では、
 * mysql_unbuffered_query は
 * 成功した場合に TRUE 、エラー時に FALSE を返します。
 */
function mysql_unbuffered_query ($query, $link_identifier = null) {}

/**
 * データベースを選択し、そこでクエリーを実行する
 * @link http://www.php.net/manual/ja/function.mysql-db-query.php
 * @param database string <p>
 * 選択するデータベース名。
 * </p>
 * @param query string <p>
 * MySQL クエリー。
 * </p>
 * <p>
 * クエリ内のデータは 適切にエスケープ
 * する必要があります。
 * </p>
 * @param link_identifier resource[optional] 
 * @return resource クエリーの結果を指す MySQL 結果リソースを正の値で返します。
 * エラー時には FALSE を返します。また、
 * INSERT/UPDATE/DELETE
 * クエリーの場合には TRUE または FALSE を返し、これらはそれぞれ
 * クエリーが 成功した / 失敗した ことを示します。
 */
function mysql_db_query ($database, $query, $link_identifier = null) {}

/**
 * MySQL サーバー上で利用可能なデータベースのリストを得る
 * @link http://www.php.net/manual/ja/function.mysql-list-dbs.php
 * @param link_identifier resource[optional] 
 * @return resource 成功した場合に結果ポインタ resource を、失敗した場合に
 * FALSE を返します。結果ポインタの中身を調べるために
 * mysql_tablename 関数を利用し、取得したテーブルを
 * 利用するには mysql_fetch_array などの関数を
 * 利用してください。
 */
function mysql_list_dbs ($link_identifier = null) {}

/**
 * MySQL データベース上のテーブルのリストを得る
 * @link http://www.php.net/manual/ja/function.mysql-list-tables.php
 * @param database string <p>
 * データベース名。
 * </p>
 * @param link_identifier resource[optional] 
 * @return resource 成功した場合に結果ポインタ resource 、
 * 失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * 結果ポインタの中身を調べるためには
 * mysql_tablename 関数を利用し、
 * 取得したテーブルを利用するには mysql_fetch_array
 * などの関数を利用してください。
 */
function mysql_list_tables ($database, $link_identifier = null) {}

/**
 * MySQL テーブルのフィールドのリストを得る
 * @link http://www.php.net/manual/ja/function.mysql-list-fields.php
 * @param database_name string <p>
 * クエリの対象となるデータベース名。
 * </p>
 * @param table_name string <p>
 * クエリの対象となるテーブル名。
 * </p>
 * @param link_identifier resource[optional] 
 * @return resource 成功した場合に結果ポインタ resource 、失敗した場合に FALSE
 * を返します。
 * </p>
 * <p>
 * 返された結果は mysql_field_flags,
 * mysql_field_len,
 * mysql_field_name そして
 * mysql_field_type で利用可能です。
 */
function mysql_list_fields ($database_name, $table_name, $link_identifier = null) {}

/**
 * MySQL プロセスのリストを得る
 * @link http://www.php.net/manual/ja/function.mysql-list-processes.php
 * @param link_identifier resource[optional] 
 * @return resource 成功した場合に結果ポインタ resource 、
 * 失敗した場合に FALSE を返します。
 */
function mysql_list_processes ($link_identifier = null) {}

/**
 * 直近に実行された MySQL 操作のエラーメッセージを返す
 * @link http://www.php.net/manual/ja/function.mysql-error.php
 * @param link_identifier resource[optional] 
 * @return string 直近の MySQL 関数からのエラー文字列を返します。エラーが発生していない
 * 場合には、'' (空文字列) を返します。
 */
function mysql_error ($link_identifier = null) {}

/**
 * 直近の MySQL 処理からエラーメッセージのエラー番号を返す
 * @link http://www.php.net/manual/ja/function.mysql-errno.php
 * @param link_identifier resource[optional] 
 * @return int 直近の MySQL 関数からのエラー番号を返します。エラーが発生していない
 * 場合は、0 (ゼロ)を返します。
 */
function mysql_errno ($link_identifier = null) {}

/**
 * 一番最近の操作で変更された行の数を得る
 * @link http://www.php.net/manual/ja/function.mysql-affected-rows.php
 * @param link_identifier resource[optional] 
 * @return int 成功した場合に変更された行の数を、直近のクエリが失敗した場合に
 * -1 を返します。
 * </p>
 * <p>
 * 直近のクエリが WHERE 句を含まない DELETE だった場合、テーブルから
 * すべてのレコードが削除されますが、MySQL 4.1.2 以前のバージョンでは
 * この関数はゼロを返します。
 * </p>
 * <p>
 * UPDATE を使用する場合、MySQL では新旧の値が同じときには更新処理を行いません。
 * このことから、必ずしも mysql_affected_rows の返す値が
 * マッチする行の数と一致するとは限りません。返す値は実際に更新処理が行われた
 * 行の数です。
 * </p>
 * <p>
 * REPLACE ステートメントは、まず最初に同じ主キーのレコードを削除した後に
 * 新しいレコードを挿入します。この関数は、削除された行の数と
 * 挿入された行の数を足したものを返します。
 * </p> 
 * <p>
 * "INSERT ... ON DUPLICATE KEY UPDATE" クエリの場合の返り値は、
 * 新しい行を追加した場合が 1
 * で既存の行を更新した場合が 2 となります。
 */
function mysql_affected_rows ($link_identifier = null) {}

/**
 * 直近のクエリで生成された ID を得る
 * @link http://www.php.net/manual/ja/function.mysql-insert-id.php
 * @param link_identifier resource[optional] 
 * @return int 直近のクエリにより AUTO_INCREMENT カラム用に生成された
 * ID を返します。直近のクエリが AUTO_INCREMENT な値を生成しなかった
 * 場合に 0、MySQL 接続が確立されていなかった
 * 場合に FALSE を返します。
 */
function mysql_insert_id ($link_identifier = null) {}

/**
 * 結果データを得る
 * @link http://www.php.net/manual/ja/function.mysql-result.php
 * @param result resource 
 * @param row int <p>
 * 結果から取得する行の番号。行番号は 0
 * からはじまります。
 * </p>
 * @param field mixed[optional] <p>
 * 取得したいフィールド名またはフィールドのオフセット。
 * </p>
 * <p>
 * フィールドのオフセット、フィールド名またはテーブル名.フィールド名を
 * 指定可能です。カラム名のエイリアスが定義されている
 * （'select foo as bar from...'）場合、そのカラム名の代わりに
 * エイリアスを使用してください。指定しなかった場合は最初のフィールドを
 * 取得します。
 * </p>
 * @return string 成功した場合に MySQL 結果セットのひとつのセルの内容、
 * 失敗した場合に FALSE を返します。
 */
function mysql_result ($result, $row, $field = null) {}

/**
 * 結果における行の数を得る
 * @link http://www.php.net/manual/ja/function.mysql-num-rows.php
 * @param result resource 
 * @return int 成功した場合に結果セットの行の数、失敗した場合に FALSE を返します。
 */
function mysql_num_rows ($result) {}

/**
 * 結果におけるフィールドの数を得る
 * @link http://www.php.net/manual/ja/function.mysql-num-fields.php
 * @param result resource 
 * @return int 成功した場合に結果セット resource のフィールド数、
 * 失敗した場合に FALSE を返します。
 */
function mysql_num_fields ($result) {}

/**
 * 結果を添字配列として取得する
 * @link http://www.php.net/manual/ja/function.mysql-fetch-row.php
 * @param result resource 
 * @return array 取得された行に対応する文字列の配列を返します。もう行がない場合は、
 * FALSE を返します。
 * </p>
 * <p>
 * mysql_fetch_rowは、指定した結果 ID
 * が指す結果から 1 行分のデータを取得します。
 * 各結果カラムは、オフセット 0 から始まる配列に格納されます。
 */
function mysql_fetch_row ($result) {}

/**
 * 連想配列、添字配列、またはその両方として結果の行を取得する
 * @link http://www.php.net/manual/ja/function.mysql-fetch-array.php
 * @param result resource 
 * @param result_type int[optional] <p>
 * 取得する配列の形式です。以下の定数値をとります。:
 * MYSQL_ASSOC,
 * MYSQL_NUM, そして
 * MYSQL_BOTH
 * </p>
 * @return array 取得した行をあらわす文字列の配列を返します。もし行が存在しない場合は FALSE
 * を返します。返される配列の形式は、result_type
 * がどのように指定されているかによります。MYSQL_BOTH（デフォルト）
 * を利用すると、連想添字と数値添字を共に持つ配列を取得します。
 * MYSQL_ASSOC を利用すると（
 * mysql_fetch_assoc の動作と同様に）連想添字のみが取得され、
 * MYSQL_NUM を利用すると
 * （mysql_fetch_row の動作と同様に）数値添字のみが
 * 取得されます。
 * </p>
 * <p>
 * 結果の中で同じフィールド名のカラムが 2 つ以上ある場合、
 * 最後のカラムが優先されます。
 * 同名の他のカラムにアクセスするには、そのカラムの数値インデックスを
 * 使うかまたはカラムの別名を定義する必要があります。
 * カラムの別名を定義した場合は、本来の列名でそのカラムにアクセスすることは
 * できません。
 */
function mysql_fetch_array ($result, $result_type = null) {}

/**
 * 連想配列として結果の行を取得する
 * @link http://www.php.net/manual/ja/function.mysql-fetch-assoc.php
 * @param result resource 
 * @return array 取得した行に対応する文字列の連想配列を返します。行がもうない場合には
 * FALSE を返します。
 * </p>
 * <p>
 * 結果の複数のカラムが同じフィールド名を有している場合、最後のカラ
 * ムが優先されます。同じ名前を有する他のカラムにアクセスするには、
 * mysql_fetch_rowを使用して数値添字を返すか、
 * エイリアス名を追加する必要があります。エイリアスの説明については、
 * mysql_fetch_arrayの例を参照ください。
 */
function mysql_fetch_assoc ($result) {}

/**
 * 結果の行をオブジェクトとして取得する
 * @link http://www.php.net/manual/ja/function.mysql-fetch-object.php
 * @param result resource 
 * @param class_name string[optional] <p>
 * インスタンス化し、プロパティを設定して返すクラスの名前。
 * 指定しなかった場合は stdClass
 * オブジェクトが返されます。
 * </p>
 * @param params array[optional] <p>
 * class_name オブジェクトのコンストラクタに渡す
 * オプションのパラメータの配列。
 * </p>
 * @return object 取得された行を表す文字列プロパティを有するオブジェクト(object)を返します。
 * もう行が残っていない場合は、FALSE を返します。
 */
function mysql_fetch_object ($result, $class_name = null, array $params = null) {}

/**
 * 内部的な結果ポインタを移動する
 * @link http://www.php.net/manual/ja/function.mysql-data-seek.php
 * @param result resource 
 * @param row_number int <p>
 * 新しく結果ポインタを設定したい行番号です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function mysql_data_seek ($result, $row_number) {}

/**
 * 結果における各出力の長さを得る
 * @link http://www.php.net/manual/ja/function.mysql-fetch-lengths.php
 * @param result resource 
 * @return array 成功した場合に長さの配列（array）を、
 * 失敗した場合に FALSE を返します。
 */
function mysql_fetch_lengths ($result) {}

/**
 * 結果からカラム情報を取得し、オブジェクトとして返す
 * @link http://www.php.net/manual/ja/function.mysql-fetch-field.php
 * @param result resource 
 * @param field_offset int[optional] <p>
 * 数字で表したフィールドの位置です。もし指定されなければ、
 * まだこの関数で情報を取得していないフィールドのうち最初のものが
 * 選択されます。field_offset は、
 * 0 からはじまります。
 * </p>
 * @return object フィールド情報を含むobjectを返します。オブジェクトの
 * プロパティは次のとおりです。
 * </p>
 * <p>
 * name - カラム名
 * table - カラムが属しているテーブルの名前。エイリアスを定義している場合はエイリアスの名前
 * max_length - カラムの最大長
 * not_null - カラムが NULL 値をとることができない場合 1
 * primary_key - カラムが主キーであれば 1
 * unique_key - カラムがユニークキーであれば 1
 * multiple_key - カラムが非ユニークキーであれば 1
 * numeric - カラムが数値(numeric)であれば 1
 * blob - カラムがBLOBであれば 1
 * type - カラムの型
 * unsigned - カラムが符号無し(unsigned)であれば 1
 * zerofill - カラムがゼロで埋められている(zero-filled)場合に 1
 */
function mysql_fetch_field ($result, $field_offset = null) {}

/**
 * 結果ポインタを指定したフィールドオフセットにセットする
 * @link http://www.php.net/manual/ja/function.mysql-field-seek.php
 * @param result resource 
 * @param field_offset int 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function mysql_field_seek ($result, $field_offset) {}

/**
 * 結果保持用メモリを開放する
 * @link http://www.php.net/manual/ja/function.mysql-free-result.php
 * @param result resource 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * result がリソースではなかった場合、
 * E_WARNING レベルのエラーが発生します。
 * mysql_query が resource
 * を返すのは SELECT, SHOW, EXPLAIN, そして DESCRIBE
 * の場合だけであることに注意しましょう。
 */
function mysql_free_result ($result) {}

/**
 * 結果において指定したフィールド名を取得する
 * @link http://www.php.net/manual/ja/function.mysql-field-name.php
 * @param result resource 
 * @param field_offset int 
 * @return string 成功した場合に指定したフィールドの名前を、失敗した場合に FALSE を返します。
 */
function mysql_field_name ($result, $field_offset) {}

/**
 * 指定したフィールドが含まれるテーブルの名前を取得する
 * @link http://www.php.net/manual/ja/function.mysql-field-table.php
 * @param result resource 
 * @param field_offset int 
 * @return string 成功した場合にテーブルの名前を返します。
 */
function mysql_field_table ($result, $field_offset) {}

/**
 * 指定したフィールドの長さを返す
 * @link http://www.php.net/manual/ja/function.mysql-field-len.php
 * @param result resource 
 * @param field_offset int 
 * @return int 成功した場合には指定したフィールドの長さ、失敗した場合に FALSE を返します。
 */
function mysql_field_len ($result, $field_offset) {}

/**
 * 結果において指定したフィールドの型を取得する
 * @link http://www.php.net/manual/ja/function.mysql-field-type.php
 * @param result resource 
 * @param field_offset int 
 * @return string 返されるフィールド型は
 * "int", "real", 
 * "string", "blob", そして
 * その他 MySQL ドキュメント
 * で詳細が規定されている型のうちのひとつになります。
 */
function mysql_field_type ($result, $field_offset) {}

/**
 * 結果において指定したフィールドのフラグを取得する
 * @link http://www.php.net/manual/ja/function.mysql-field-flags.php
 * @param result resource 
 * @param field_offset int 
 * @return string 結果についてのフラグを文字列で返します。失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * 運用システム上のMySQLがサポートしている場合、次のフラグがレポート
 * されます。 "not_null", 
 * "primary_key", "unique_key", 
 * "multiple_key", "blob", 
 * "unsigned", "zerofill",
 * "binary", "enum", 
 * "auto_increment" そして "timestamp"
 */
function mysql_field_flags ($result, $field_offset) {}

/**
 * mysql_query で使用するために文字列をエスケープする
 * @link http://www.php.net/manual/ja/function.mysql-escape-string.php
 * @param unescaped_string string <p>
 * エスケープされる文字列。
 * </p>
 * @return string エスケープされた文字列を返します。
 */
function mysql_escape_string ($unescaped_string) {}

/**
 * SQL 文中で用いる文字列の特殊文字をエスケープする
 * @link http://www.php.net/manual/ja/function.mysql-real-escape-string.php
 * @param unescaped_string string <p>
 * エスケープされる文字列。
 * </p>
 * @param link_identifier resource[optional] 
 * @return string 成功した場合にエスケープ後の文字列、失敗した場合に FALSE を返します。
 */
function mysql_real_escape_string ($unescaped_string, $link_identifier = null) {}

/**
 * 現在のシステムの状態を取得する
 * @link http://www.php.net/manual/ja/function.mysql-stat.php
 * @param link_identifier resource[optional] 
 * @return string 稼働時間、スレッド、クエリ、オープンされているテーブル、フラッシュされた
 * テーブル、そして 1 秒あたりのクエリ数を文字列で返します。その他のデータも
 * 含めた完全な状態を得るには、SHOW STATUS SQL コマンドを
 * 実行する必要があります。link_identifier が不正な
 * 場合には NULL が返されます。
 */
function mysql_stat ($link_identifier = null) {}

/**
 * カレントのスレッド ID を返す
 * @link http://www.php.net/manual/ja/function.mysql-thread-id.php
 * @param link_identifier resource[optional] 
 * @return int 成功した場合にスレッド ID 、失敗した場合に FALSE を返します。
 */
function mysql_thread_id ($link_identifier = null) {}

/**
 * 文字セット名を返す
 * @link http://www.php.net/manual/ja/function.mysql-client-encoding.php
 * @param link_identifier resource[optional] 
 * @return string カレントの接続から、デフォルトの文字セット名を返します。
 */
function mysql_client_encoding ($link_identifier = null) {}

/**
 * サーバーとの接続状況を調べ、接続されていない場合は再接続する
 * @link http://www.php.net/manual/ja/function.mysql-ping.php
 * @param link_identifier resource[optional] 
 * @return bool MySQL サーバーとの接続が有効な場合に TRUE そうでない場合に
 * FALSE を返します。
 */
function mysql_ping ($link_identifier = null) {}

/**
 * MySQL クライアント情報を取得する
 * @link http://www.php.net/manual/ja/function.mysql-get-client-info.php
 * @return string MySQL クライアントのバージョンを返します。
 */
function mysql_get_client_info () {}

/**
 * MySQL ホスト情報を取得する
 * @link http://www.php.net/manual/ja/function.mysql-get-host-info.php
 * @param link_identifier resource[optional] 
 * @return string 使用されている MySQL 接続の型を表す文字列を返します。
 * 失敗した場合に FALSE を返します。
 */
function mysql_get_host_info ($link_identifier = null) {}

/**
 * MySQL プロトコル情報を取得する
 * @link http://www.php.net/manual/ja/function.mysql-get-proto-info.php
 * @param link_identifier resource[optional] 
 * @return int 成功した場合に MySQL プロトコル、失敗した場合に FALSE を返します。
 */
function mysql_get_proto_info ($link_identifier = null) {}

/**
 * MySQL サーバー情報を取得する
 * @link http://www.php.net/manual/ja/function.mysql-get-server-info.php
 * @param link_identifier resource[optional] 
 * @return string 成功した場合に MySQL サーバーのバージョン、失敗した場合に FALSE を返します。
 */
function mysql_get_server_info ($link_identifier = null) {}

/**
 * 直近のクエリについての情報を得る
 * @link http://www.php.net/manual/ja/function.mysql-info.php
 * @param link_identifier resource[optional] 
 * @return string 成功した場合に文についての情報、失敗した場合に FALSE を返します。
 * どんな文が情報を返し、またそれがどのように見えるのかについては、以下の
 * 例を参照ください。ここに挙げられていない文では FALSE が返されます。
 */
function mysql_info ($link_identifier = null) {}

/**
 * クライアントの文字セットを設定する
 * @link http://www.php.net/manual/ja/function.mysql-set-charset.php
 * @param charset string <p>
 * 有効な文字セット名。
 * </p>
 * @param link_identifier resource[optional] 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function mysql_set_charset ($charset, $link_identifier = null) {}

/**
 * @param database_name
 * @param query
 * @param link_identifier[optional]
 */
function mysql ($database_name, $query, $link_identifier) {}

/**
 * @param result
 * @param field_index
 */
function mysql_fieldname ($result, $field_index) {}

/**
 * @param result
 * @param field_offset
 */
function mysql_fieldtable ($result, $field_offset) {}

/**
 * @param result
 * @param field_offset
 */
function mysql_fieldlen ($result, $field_offset) {}

/**
 * @param result
 * @param field_offset
 */
function mysql_fieldtype ($result, $field_offset) {}

/**
 * @param result
 * @param field_offset
 */
function mysql_fieldflags ($result, $field_offset) {}

/**
 * @param database_name
 * @param link_identifier[optional]
 */
function mysql_selectdb ($database_name, $link_identifier) {}

/**
 * @param result
 */
function mysql_freeresult ($result) {}

/**
 * @param result
 */
function mysql_numfields ($result) {}

/**
 * @param result
 */
function mysql_numrows ($result) {}

/**
 * @param link_identifier[optional]
 */
function mysql_listdbs ($link_identifier) {}

/**
 * @param database_name
 * @param link_identifier[optional]
 */
function mysql_listtables ($database_name, $link_identifier) {}

/**
 * @param database_name
 * @param table_name
 * @param link_identifier[optional]
 */
function mysql_listfields ($database_name, $table_name, $link_identifier) {}

/**
 * <function>mysql_list_dbs</function> のコール結果からデータベース名を取得する
 * @link http://www.php.net/manual/ja/function.mysql-db-name.php
 * @param result resource <p>
 * mysql_list_dbs をコールして
 * 得られた結果ポインタ。
 * </p>
 * @param row int <p>
 * 結果セット内のインデックス。
 * </p>
 * @param field mixed[optional] <p>
 * フィールド名。
 * </p>
 * @return string 成功した場合にデータベース名を、失敗した場合に FALSE を返します。
 * FALSE が返された場合、エラーの発生源を特定するには
 * mysql_error を使用してください。
 */
function mysql_db_name ($result, $row, $field = null) {}

/**
 * @param result
 * @param row
 * @param field[optional]
 */
function mysql_dbname ($result, $row, $field) {}

/**
 * フィールドのテーブル名を得る
 * @link http://www.php.net/manual/ja/function.mysql-tablename.php
 * @param result resource <p>
 * mysql_list_tables から返される
 * 結果ポインタ resource 。
 * </p>
 * @param i int <p>
 * 整数のインデックス（行/テーブル 番号）。
 * </p>
 * @return string 成功した場合にテーブル名、失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * 結果ポインタの中身を調べるために
 * mysql_tablename 関数を利用し、取得したテーブルを
 * 利用するには mysql_fetch_array などの関数を
 * 利用してください。
 */
function mysql_tablename ($result, $i) {}

/**
 * @param result
 * @param row
 * @param field[optional]
 */
function mysql_table_name ($result, $row, $field) {}


/**
 * カラムは、フィールド名を添字とする配列形式で返されます。
 * @link http://www.php.net/manual/ja/mysql.constants.php
 */
define ('MYSQL_ASSOC', 1);

/**
 * カラムは、数値の添字を持つ配列形式で返されます。添字は 0 からはじまり、
 * 結果の最初のフィールドです。
 * @link http://www.php.net/manual/ja/mysql.constants.php
 */
define ('MYSQL_NUM', 2);

/**
 * カラムは、数値の添字とフィールド名の添字のどちらでもアクセスできる
 * 配列形式で返されます。
 * @link http://www.php.net/manual/ja/mysql.constants.php
 */
define ('MYSQL_BOTH', 3);

/**
 * 圧縮プロトコルを利用します。
 * @link http://www.php.net/manual/ja/mysql.constants.php
 */
define ('MYSQL_CLIENT_COMPRESS', 32);

/**
 * SSL による暗号化を使用します。このフラグは、バージョン 4.x
 * 以降の MySQL クライアントライブラリを利用している場合にのみ有効です。
 * PHP 4 や、Windows 版の PHP 5 にバンドルされているのは、バージョン
 * 3.23.x のライブラリです。
 * @link http://www.php.net/manual/ja/mysql.constants.php
 */
define ('MYSQL_CLIENT_SSL', 2048);

/**
 * interactive_timeout で指定された秒数（wait_timeout のかわり）
 * の無通信が続くまで接続を閉じません。
 * @link http://www.php.net/manual/ja/mysql.constants.php
 */
define ('MYSQL_CLIENT_INTERACTIVE', 1024);

/**
 * 関数名の後のスペースを許可します。
 * @link http://www.php.net/manual/ja/mysql.constants.php
 */
define ('MYSQL_CLIENT_IGNORE_SPACE', 256);

// End of mysql v.1.0
?>
