<?php

// Start of zlib v.1.1

/**
 * gz ファイルを出力する
 * @link http://www.php.net/manual/ja/function.readgzfile.php
 * @param filename string <p>
 * ファイル名を指定します。このファイルはファイルシステムからオープンされ、
 * 内容は標準出力に書き込まれます。
 * </p>
 * @param use_include_path int[optional] <p>
 * include_path
 * にあるファイルも検索したい場合、このオプションパラメータを
 * 1 に設定してください。
 * </p>
 * @return int ファイルから読み込んだ (解凍された) データのバイト数を返します。
 * エラーが発生した場合、FALSE が返され、@readgzfile
 * としてコールされている場合を除き、エラーメッセージが出力されます。
 */
function readgzfile ($filename, $use_include_path = null) {}

/**
 * gz ファイルポインタの示す位置を元に戻す
 * @link http://www.php.net/manual/ja/function.gzrewind.php
 * @param zp resource <p>
 * gz ファイルポインタを指定します。これは有効なファイルポインタであり、
 * かつ、gzopen
 * によりオープンできたファイルを指している必要があります。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function gzrewind ($zp) {}

/**
 * 開かれたgzファイルへのポインタを閉じる
 * @link http://www.php.net/manual/ja/function.gzclose.php
 * @param zp resource <p>
 * gzファイルポインタ。有効なファイルポインタであり、かつ、
 * gzopen
 * によりオープンできたファイルを指している必要があります。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function gzclose ($zp) {}

/**
 * gz ファイルポインタが <acronym>EOF</acronym> かどうか調べる
 * @link http://www.php.net/manual/ja/function.gzeof.php
 * @param zp resource <p>
 * gzファイルポインタは、有効なファイルポインタであり、かつ、
 * gzopenによりオープンできたファイルを指している
 * 必要があります。
 * </p>
 * @return int gz ファイルポインタが EOF を指す、もしくはエラーが発生した場合 TRUE、
 * そうでなければ FALSE を返します。
 */
function gzeof ($zp) {}

/**
 * gz ファイルへのポインタから文字を得る
 * @link http://www.php.net/manual/ja/function.gzgetc.php
 * @param zp resource <p>
 * gz ファイルポインタを指定します。
 * これは有効なファイルポインタであり、かつ、
 * gzopen
 * によりオープンできたファイルを指している必要があります。
 * </p>
 * @return string 非圧縮の文字列、もしくは EOF (gzeof とは異なる)
 * の場合に FALSE を返します。
 */
function gzgetc ($zp) {}

/**
 * ファイルポインタから 1 行を得る
 * @link http://www.php.net/manual/ja/function.gzgets.php
 * @param zp resource <p>
 * gz ファイルポインタを指定します。
 * これは有効なファイルポインタであり、かつ、
 * gzopen
 * によりオープンできたファイルを指している必要があります。
 * </p>
 * @param length int <p>
 * 取得するデータ長を指定します。
 * </p>
 * @return string 非圧縮の文字列、もしくはエラー時に FALSE
 */
function gzgets ($zp, $length) {}

/**
 * gzファイルへのポインタから1行を得て、HTMLタグを取り除く
 * @link http://www.php.net/manual/ja/function.gzgetss.php
 * @param zp resource <p>
 * gz ファイルポインタを指定します。
 * これは有効なファイルポインタであり、かつ、
 * gzopen
 * によりオープンできたファイルを指している必要があります。
 * </p>
 * @param length int <p>
 * 取得するデータ長を指定します。
 * </p>
 * @param allowable_tags string[optional] <p>
 * このオプションパラメータにより、
 * 取り除かないタグを指定することができます。
 * </p>
 * @return string 非圧縮かつタグが取り除かれた文字列、もしくはエラー時に FALSE
 */
function gzgetss ($zp, $length, $allowable_tags = null) {}

/**
 * バイナリ対応のgzファイル読み込み
 * @link http://www.php.net/manual/ja/function.gzread.php
 * @param zp resource <p>
 * gz ファイルポインタを指定します。これは有効なファイルポインタであり、
 * かつ、gzopen
 * によりオープンできたファイルを指している必要があります。
 * </p>
 * @param length int <p>
 * 読み込むバイト数を指定します。
 * </p>
 * @return string 読み込まれたデータ
 */
function gzread ($zp, $length) {}

/**
 * gz ファイルを開く
 * @link http://www.php.net/manual/ja/function.gzopen.php
 * @param filename string <p>
 * ファイル名を指定します
 * </p>
 * @param mode string <p>
 * fopen と同じ (rb または
 * wb) ですが、
 * 圧縮レベル (wb9) または圧縮の方策、
 * つまり、wb6f のようにフィルターを通したデータを
 * f で指定したり、h
 * でハフマン圧縮のみを行うことを指定したりすることができます
 * (方策に関するパラメータの詳細については、zlib.h
 * の中の deflateInit2 の説明を参照ください)。
 * </p>
 * @param use_include_path int[optional] <p>
 * このオプションパラメータを 1 にすることにより、
 * include_pathにあるファイルも
 * 検索することができます。
 * </p>
 * @return resource オープンしたファイルへのファイルポインタを返します。その後、
 * このファイルディスクプリタから読み込んだ全ては透過的に解凍され、
 * 書き込んだものは圧縮されます。
 * </p>
 * <p>
 * オープンに失敗した場合、この関数は FALSE を返します。
 */
function gzopen ($filename, $mode, $use_include_path = null) {}

/**
 * gzファイルへのポインタから残りのデータ全部を出力する
 * @link http://www.php.net/manual/ja/function.gzpassthru.php
 * @param zp resource <p>
 * gz ファイルポインタを指定します。これは有効なファイルポインタであり、
 * かつ、gzopen
 * によりオープンできたファイルを指している必要があります。
 * </p>
 * @return int gz から読み込んで解凍され、入力に渡された文字数。
 * もしくはエラー時に FALSE 。
 */
function gzpassthru ($zp) {}

/**
 * gz ファイルポインタの位置を移動する
 * @link http://www.php.net/manual/ja/function.gzseek.php
 * @param zp resource <p>
 * gz ファイルポインタを指定します。これは有効なファイルポインタであり、
 * かつ、gzopen
 * によりオープンできたファイルを指している必要があります。
 * </p>
 * @param offset int <p>
 * 移動するオフセットを指定します。
 * </p>
 * @param whence int[optional] <p>
 * whence の値は次のいずれかです。
 * SEEK_SET - offset バイト目に設定します。
 * SEEK_CUR - 現在位置から offset ぶん進んだ位置に設定します。
 * </p>
 * <p>
 * whence を省略した場合は
 * SEEK_SET とみなします。
 * </p>
 * @return int 成功した場合、0を返します。それ以外の場合は、-1を返します。
 * 移動がEOFを超える場合にもエラーは発生しないことに注意してください。
 */
function gzseek ($zp, $offset, $whence = null) {}

/**
 * gz ファイルポインタの読み込み/書き込み位置を返します
 * @link http://www.php.net/manual/ja/function.gztell.php
 * @param zp resource <p>
 * gz ファイルポインタを指定します。これは有効なファイルポインタであり、
 * かつ、gzopen
 * によりオープンできたファイルを指している必要があります。
 * </p>
 * @return int ファイルポインタの位置、もしくはエラーが発生した場合 FALSE
 */
function gztell ($zp) {}

/**
 * バイナリセーフな gz ファイル書き込み
 * @link http://www.php.net/manual/ja/function.gzwrite.php
 * @param zp resource <p>
 * gz ファイルポインタを指定します。これは有効なファイルポインタであり、
 * かつ、gzopen
 * によりオープンできたファイルを指している必要があります。
 * </p>
 * @param string string <p>
 * 書き込む文字列を指定します。
 * </p>
 * @param length int[optional] <p>
 * 書き込む解凍されたバイト数を指定します。
 * もし指定された場合、
 * length バイトのデータが書き込まれたか、
 * string の終わりに達した時に
 * 書き込みは終了します。
 * </p>
 * <p>
 * 引数 length が指定された場合、
 * magic_quotes_runtime
 * 設定オプションは無視されて string から
 * スラッシュが取り除かれなくなることに注意してください。
 * </p>
 * @return int 与えられた gz ファイルストリームに書き込まれた (解凍された)
 * バイト数を返します。
 */
function gzwrite ($zp, $string, $length = null) {}

/**
 * <function>gzwrite</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.gzputs.php
 * @param fp
 * @param str
 * @param length[optional]
 */
function gzputs ($fp, $str, $length) {}

/**
 * gzファイル全体を配列に読み込む
 * @link http://www.php.net/manual/ja/function.gzfile.php
 * @param filename string <p>
 * ファイル名を指定します。
 * </p>
 * @param use_include_path int[optional] <p>
 * もし include_path
 * にあるファイルも検索したい場合、
 * このオプションパラメータに 1
 * を設定することができます。
 * </p>
 * @return array ファイルを含む配列で、要素毎に 1 行ずつ含んでいます。
 */
function gzfile ($filename, $use_include_path = null) {}

/**
 * 文字列を圧縮する
 * @link http://www.php.net/manual/ja/function.gzcompress.php
 * @param data string <p>
 * 圧縮するデータ
 * </p>
 * @param level int[optional] <p>
 * 圧縮レベル。0 で圧縮無し、9 で最大限の圧縮を指定できます。
 * </p>
 * <p>
 * -1 を指定すると、zlib ライブラリのデフォルトを使います。デフォルトは 6 です。
 * </p>
 * @return string 圧縮された文字列、もしくはエラーの場合 FALSE 。
 */
function gzcompress ($data, $level = null) {}

/**
 * 圧縮された文字列を解凍する
 * @link http://www.php.net/manual/ja/function.gzuncompress.php
 * @param data string <p>
 * gzcompress によって圧縮されたデータを指定します。
 * </p>
 * @param length int[optional] <p>
 * デコードするデータの最大長を指定します。
 * </p>
 * @return string オリジナルの無圧縮なデータ、もしくはエラー時に FALSE
 * </p>
 * <p>
 * この関数は、もし無圧縮なデータが圧縮された入力 data
 * の 32768 倍、もしくはオプションのパラメータ length
 * 以上の場合、エラーを返します。
 */
function gzuncompress ($data, $length = null) {}

/**
 * 文字列を deflate 圧縮する
 * @link http://www.php.net/manual/ja/function.gzdeflate.php
 * @param data string <p>
 * 収縮させるデータ
 * </p>
 * @param level int[optional] <p>
 * 圧縮レベル。圧縮しない場合に0、最大限の圧縮をする場合に9を指定可能です。
 * 指定しない場合、デフォルトの圧縮レベルは zlib
 * ライブラリのデフォルト圧縮レベルになります。
 * </p>
 * @return string 収縮された文字列、もしくはエラーの場合 FALSE 。
 */
function gzdeflate ($data, $level = null) {}

/**
 * deflate圧縮された文字列を解凍する
 * @link http://www.php.net/manual/ja/function.gzinflate.php
 * @param data string <p>
 * gzdeflate により圧縮されたデータを指定します
 * </p>
 * @param length int[optional] <p>
 * デコードする最大データ長を指定します
 * </p>
 * @return string オリジナルの無圧縮なデータ、もしくはエラー時に FALSE
 * </p>
 * <p>
 * この関数は、もし無圧縮なデータが圧縮された入力 data
 * の 32768 倍、もしくはオプションのパラメータ length
 * 以上の場合、エラーを返します。
 */
function gzinflate ($data, $length = null) {}

/**
 * gzip 圧縮された文字列を作成する
 * @link http://www.php.net/manual/ja/function.gzencode.php
 * @param data string <p>
 * エンコードするデータを指定します
 * </p>
 * @param level int[optional] <p>
 * 圧縮レベルを指定します。
 * 圧縮をしない場合に 0、最大限の圧縮を行う場合に9を指定可能です。
 * 指定されない場合のデフォルト圧縮レベルは、
 * zlib ライブラリのデフォルト圧縮レベルになります。
 * </p>
 * @param encoding_mode int[optional] <p>
 * エンコーディングモードを指定します。
 * FORCE_GZIP (デフォルト) もしくは
 * FORCE_DEFLATE を指定可能です。
 * </p>
 * <p>
 * PHP 5.4.0 より前のバージョンでは、FORCE_DEFLATE
 * を使うと、gzip ファイルヘッダに続けて標準的な zlib 圧縮文字列
 * (zlib ヘッダ込み) を出力していました。しかし、その後の crc32
 * チェックサムはありませんでした。
 * </p>
 * <p>
 * PHP 5.4.0 以降は、FORCE_DEFLATE が
 * RFC 1950 準拠の出力を生成するようになりました。zlib ヘッダ、圧縮したデータ、
 * そして Adler チェックサムとなります。
 * </p>
 * @return string エンコードされた文字列、もしくはエラー発生時に FALSE
 */
function gzencode ($data, $level = null, $encoding_mode = null) {}

/**
 * 出力バッファを gzip 圧縮するための ob_start コールバック関数
 * @link http://www.php.net/manual/ja/function.ob-gzhandler.php
 * @param buffer string <p>
 * </p>
 * @param mode int <p>
 * </p>
 * @return string 
 */
function ob_gzhandler ($buffer, $mode) {}

/**
 * 出力圧縮に使用されたコーディングの種類を返す
 * @link http://www.php.net/manual/ja/function.zlib-get-coding-type.php
 * @return string 返される値は gzip, deflate,
 * もしくは FALSE です。
 */
function zlib_get_coding_type () {}

define ('FORCE_GZIP', 1);
define ('FORCE_DEFLATE', 2);

// End of zlib v.1.1
?>
