<?php

// Start of standard v.5.3.21

class __PHP_Incomplete_Class  {
}

class php_user_filter  {
	public $filtername;
	public $params;


	/**
	 * フィルタを適用するときにコールされる
	 * @link http://www.php.net/manual/ja/php-user-filter.filter.php
	 * @param in resource <p>
	 * in は バケット群 を指すリソースで、
	 * この中には一つあるいは複数の バケット オブジェクトが含まれています。
	 * このオブジェクトに、フィルタ対象のデータが含まれます。
	 * </p>
	 * @param out resource <p>
	 * out はもう一つの バケット群 を指すリソースで、
	 * 変更した内容をここに保存します。
	 * </p>
	 * @param consumed int <p>
	 * consumed は常に参照渡しとする必要があります。
	 * フィルタで読み込んだり変更したりしたデータの長さをここで加算します。
	 * 大半の場合、各 $bucket 上で
	 * $bucket->datalen をコールするたびに
	 * consumed を増やすことになります。
	 * </p>
	 * @param closing bool <p>
	 * ストリームが終了処理の最中である場合
	 * (つまり、フィルタチェインの最後の処理を行っている場合)
	 * に、closing パラメータが TRUE となります。
	 * </p>
	 * @return int filter メソッドは、処理を終えたときに次のいずれかの値を返す必要があります。
	 * <tr valign="top">
	 * <td>返り値</td>
	 * <td>意味</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>PSFS_PASS_ON</td>
	 * <td>
	 * フィルタの処理が成功し、データが
	 * out バケット群
	 * に保存されました。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>PSFS_FEED_ME</td>
	 * <td>
	 * フィルタの処理は成功しましたが、返すデータはありません。
	 * ストリームあるいは一つ前のフィルタから、さらにデータが必要です。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>PSFS_ERR_FATAL (デフォルト)</td>
	 * <td>
	 * フィルタで対処不能なエラーが発生し、処理を続行できません。
	 * </td>
	 * </tr>
	 */
	public function filter ($in, $out, &$consumed, $closing) {}

	/**
	 * フィルタを作成するときにコールされる
	 * @link http://www.php.net/manual/ja/php-user-filter.oncreate.php
	 * @return bool このメソッドを実装は、成功した場合に TRUE
	 * そして失敗した場合に FALSE を返す必要があります。
	 */
	public function onCreate () {}

	/**
	 * フィルタを閉じるときにコールされる
	 * @link http://www.php.net/manual/ja/php-user-filter.onclose.php
	 * @return void 返り値は無視されます。
	 */
	public function onClose () {}

}

class Directory  {

	/**
	 * ディレクトリハンドルをクローズする
	 * @link http://www.php.net/manual/ja/directory.close.php
	 * @param dir_handle resource[optional] 
	 * @return void 
	 */
	public function close ($dir_handle = null) {}

	/**
	 * ディレクトリハンドルを元に戻す
	 * @link http://www.php.net/manual/ja/directory.rewind.php
	 * @param dir_handle resource[optional] 
	 * @return void 
	 */
	public function rewind ($dir_handle = null) {}

	/**
	 * ディレクトリハンドルからエントリを読み込む
	 * @link http://www.php.net/manual/ja/directory.read.php
	 * @param dir_handle resource[optional] 
	 * @return string 
	 */
	public function read ($dir_handle = null) {}

}

/**
 * 定数の値を返す
 * @link http://www.php.net/manual/ja/function.constant.php
 * @param name string <p>
 * 定数名。
 * </p>
 * @return mixed 定数の値、あるいはその定数が定義されていない場合に NULL を返します。
 */
function constant ($name) {}

/**
 * 2進表現のデータを16進表現に変換する
 * @link http://www.php.net/manual/ja/function.bin2hex.php
 * @param str string <p>
 * 文字列。
 * </p>
 * @return string 指定した文字列を16進表現に変換したものを返します。
 */
function bin2hex ($str) {}

/**
 * 実行を遅延させる
 * @link http://www.php.net/manual/ja/function.sleep.php
 * @param seconds int <p>
 * 秒単位の停止時間。
 * </p>
 * @return int 成功した場合にゼロ、エラーが発生した場合に FALSE を返します。
 * </p>
 * <p>
 * シグナルで中断した場合、sleep はゼロ以外の値を返します。
 * Windows では、この値は常に
 * 192 (Windows API の定数
 * WAIT_IO_COMPLETION の値) です。
 * その他のプラットフォームでは、残りの遅延秒数を返します。
 */
function sleep ($seconds) {}

/**
 * マイクロ秒単位で実行を遅延する
 * @link http://www.php.net/manual/ja/function.usleep.php
 * @param micro_seconds int <p>
 * 実行を停止するマイクロ秒数。マイクロ秒とは、一秒の百万分の一です。
 * </p>
 * @return void 値を返しません。
 */
function usleep ($micro_seconds) {}

/**
 * 秒およびナノ秒単位で実行を遅延する
 * @link http://www.php.net/manual/ja/function.time-nanosleep.php
 * @param seconds int <p>
 * 非負の整数である必要があります。
 * </p>
 * @param nanoseconds int <p>
 * 十億よりも小さい非負の整数である必要があります。
 * </p>
 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * シグナルによって遅延処理が中断された場合、以下の要素からなる連想配列を返します。
 * seconds - 残りの秒数
 * nanoseconds - 残りのナノ秒数
 */
function time_nanosleep ($seconds, $nanoseconds) {}

/**
 * 指定した時刻まで実行を遅延する
 * @link http://www.php.net/manual/ja/function.time-sleep-until.php
 * @param timestamp float <p>
 * スクリプトが再開する時刻。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function time_sleep_until ($timestamp) {}

/**
 * 出力バッファをフラッシュする
 * @link http://www.php.net/manual/ja/function.flush.php
 * @return void 値を返しません。
 */
function flush () {}

/**
 * 指定した文字数で文字列を分割する
 * @link http://www.php.net/manual/ja/function.wordwrap.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @param width int[optional] <p>
 * 文字列を分割するときの文字数。
 * </p>
 * @param break string[optional] <p>
 * オプションのパラメータ
 * break を用いて行を分割します。
 * </p>
 * @param cut bool[optional] <p>
 * cut を TRUE に設定すると、
 * 文字列は常に指定した幅でラップされます。このため、
 * 指定した幅よりも長い単語がある場合には、分割されます (2 番目の例を参照ください)。
 * </p>
 * @return string 受け取った文字列を指定した長さで分割したものを返します。
 */
function wordwrap ($str, $width = null, $break = null, $cut = null) {}

/**
 * 特殊文字を HTML エンティティに変換する
 * @link http://www.php.net/manual/ja/function.htmlspecialchars.php
 * @param string string <p>
 * 変換される文字列。
 * </p>
 * @param flags int[optional] <p>
 * 以下のフラグを組み合わせたビットマスクです。
 * クォートや無効な符号単位シーケンス、そして文書型の扱いを指定します。
 * デフォルトは ENT_COMPAT | ENT_HTML401 です。
 * <table>
 * 利用可能な flags 定数
 * <tr valign="top">
 * <td>定数名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_COMPAT</td>
 * <td>ダブルクオートは変換しますがシングルクオートは変換しません。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_QUOTES</td>
 * <td>シングルクオートとダブルクオートを共に変換します。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_NOQUOTES</td>
 * <td>シングルクオートとダブルクオートは共に変換されません。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_IGNORE</td>
 * <td>
 * 無効な符号単位シーケンスを含む文字列を渡したときに、
 * 空の文字列を返すのではなく無効な部分を切り捨てるようになります。
 * このフラグは使わないようにしましょう。
 * セキュリティの問題が発生する可能性があります。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_SUBSTITUTE</td>
 * <td>
 * 無効な符号単位シーケンスを含む文字列を渡したときに、
 * 空の文字列を返すのではなく Unicode の置換文字に置き換えます。
 * UTF-8 の場合は U+FFFD、それ以外の場合は &amp;#FFFD; となります。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_DISALLOWED</td>
 * <td>
 * 指定した文書型において無効な符号位置を、Unicode の代替文字である
 * U+FFFD (UTF-8) あるいは &amp;#FFFD; で置き換えます。
 * これを設定しなければ、無効な符号位置をそのまま残します。
 * これは、外部コンテンツを埋め込んだ XML 文書を整形式に保つために有用です。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_HTML401</td>
 * <td>
 * コードを HTML 4.01 として処理します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_XML1</td>
 * <td>
 * コードを XML 1 として処理します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_XHTML</td>
 * <td>
 * コードを XHTML として処理します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_HTML5</td>
 * <td>
 * コードを HTML 5 として処理します。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @param encoding string[optional] <p>
 * 変換に使用されるエンコーディングを指定します。
 * 省略した場合のデフォルト値は、PHP 5.4.0 より前のバージョンでは
 * ISO-8859-1、そして PHP 5.4.0 以降では UTF-8 となります。
 * </p>
 * <p>
 * この関数を使ううえでは
 * ISO-8859-1 と ISO-8859-15、
 * UTF-8、cp866、
 * cp1251、cp1252 そして
 * KOI8-R は事実上同等です。
 * string 自体がそのエンコーディングにおける有効な文字列である限り、
 * これらのエンコーディングでは
 * htmlspecialchars の影響が及ぶ文字がみな同じ位置にあるからです。
 * </p>
 * &reference.strings.charsets;
 * @param double_encode bool[optional] <p>
 * double_encode をオフにすると、PHP
 * は既存の html エンティティをエンコードしません。
 * デフォルトでは、既存のエンティティも含めてすべてを変換します。
 * </p>
 * @return string 変換後の文字列を返します。
 * </p>
 * <p>
 * 入力の string の中に
 * エンコーディング encoding における無効なコードユニットシーケンスが含まれており、
 * かつ ENT_IGNORE フラグが設定されていなければ、
 * htmlspecialchars は空文字列を返します。
 */
function htmlspecialchars ($string, $flags = null, $encoding = null, $double_encode = null) {}

/**
 * 適用可能な文字を全て HTML エンティティに変換する
 * @link http://www.php.net/manual/ja/function.htmlentities.php
 * @param string string <p>
 * 入力文字列。
 * </p>
 * @param flags int[optional] <p>
 * 以下のフラグを組み合わせたビットマスクです。
 * クォートや無効な符号単位シーケンス、そして文書型の扱いを指定します。
 * デフォルトは ENT_COMPAT | ENT_HTML401 です。
 * <table>
 * 利用可能な flags 定数
 * <tr valign="top">
 * <td>定数名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_COMPAT</td>
 * <td>ダブルクオートは変換しますがシングルクオートは変換しません。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_QUOTES</td>
 * <td>シングルクオートとダブルクオートを共に変換します。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_NOQUOTES</td>
 * <td>シングルクオートとダブルクオートは共に変換されません。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_IGNORE</td>
 * <td>
 * 無効な符号単位シーケンスを含む文字列を渡したときに、
 * 空の文字列を返すのではなく無効な部分を切り捨てるようになります。
 * このフラグは使わないようにしましょう。
 * セキュリティの問題が発生する可能性があります。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_SUBSTITUTE</td>
 * <td>
 * 無効な符号単位シーケンスを含む文字列を渡したときに、
 * 空の文字列を返すのではなく Unicode の置換文字に置き換えます。
 * UTF-8 の場合は U+FFFD、それ以外の場合は &amp;#FFFD; となります。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_DISALLOWED</td>
 * <td>
 * 指定した文書型において無効な符号位置を、Unicode の代替文字である
 * U+FFFD (UTF-8) あるいは &amp;#FFFD; で置き換えます。
 * これを設定しなければ、無効な符号位置をそのまま残します。
 * これは、外部コンテンツを埋め込んだ XML 文書を整形式に保つために有用です。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_HTML401</td>
 * <td>
 * コードを HTML 4.01 として処理します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_XML1</td>
 * <td>
 * コードを XML 1 として処理します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_XHTML</td>
 * <td>
 * コードを XHTML として処理します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_HTML5</td>
 * <td>
 * コードを HTML 5 として処理します。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @param encoding string[optional] <p>
 * htmlspecialcharsと同様に、htmlentities はオプションの3番目の引数
 * charset をとり、変換に使用されるエンコーディングを指定可能です。
 * 省略した場合のデフォルト値は、PHP 5.4.0 より前のバージョンでは
 * ISO-8859-1、そして PHP 5.4.0 以降では UTF-8 となります。
 * この引数は表向きには任意指定となっていますが、コードにあわせて正しい値を指定しておくことを強く推奨します。
 * </p>
 * &reference.strings.charsets;
 * @param double_encode bool[optional] <p>
 * double_encode をオフにすると、PHP
 * は既存の html エンティティをエンコードしません。
 * デフォルトでは、既存のエンティティも含めてすべてを変換します。
 * </p>
 * @return string エンコードした文字列を返します。
 * </p>
 * <p>
 * 入力文字列の中に、指定した encoding で無効な符号単位シーケンスが含まれる場合は、
 * ENT_IGNORE あるいは
 * ENT_SUBSTITUTE フラグが設定されていない限りは空文字列を返します。
 */
function htmlentities ($string, $flags = null, $encoding = null, $double_encode = null) {}

/**
 * HTML エンティティを適切な文字に変換する
 * @link http://www.php.net/manual/ja/function.html-entity-decode.php
 * @param string string <p>
 * 入力文字列。
 * </p>
 * @param flags int[optional] <p>
 * 以下のフラグのビットマスクによる組み合わせで、クォートの扱いやドキュメントの形式を指定します。
 * デフォルトは ENT_COMPAT | ENT_HTML401 です。
 * <table>
 * 使用可能な flags 定数
 * <tr valign="top">
 * <td>定数名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_COMPAT</td>
 * <td>ダブルクォートを変換し、シングルクォートはそのままにします。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_QUOTES</td>
 * <td>ダブルクォート、シングルクォートの両方を変換します。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_NOQUOTES</td>
 * <td>ダブルクォート、シングルクォートの両方とも変換しません。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_HTML401</td>
 * <td>
 * コードを HTML 4.01 として処理します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_XML1</td>
 * <td>
 * コードを XML 1 として処理します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_XHTML</td>
 * <td>
 * コードを XHTML として処理します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_HTML5</td>
 * <td>
 * コードを HTML 5 として処理します。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @param encoding string[optional] <p>
 * 使用するエンコーディング。省略した場合のデフォルト値は、
 * PHP 5.4.0 より前のバージョンでは ISO-8859-1、そして
 * PHP 5.4.0 以降では UTF-8 となります。
 * </p>
 * &reference.strings.charsets;
 * @return string デコードされた文字列を返します。
 */
function html_entity_decode ($string, $flags = null, $encoding = null) {}

/**
 * 特殊な HTML エンティティを文字に戻す
 * @link http://www.php.net/manual/ja/function.htmlspecialchars-decode.php
 * @param string string <p>
 * デコードする文字列。
 * </p>
 * @param flags int[optional] <p>
 * 以下のフラグのビットマスクによる組み合わせで、クォートの扱いやドキュメントの形式を指定します。
 * デフォルトは ENT_COMPAT | ENT_HTML401 です。
 * <table>
 * 使用可能な flags 定数
 * <tr valign="top">
 * <td>定数名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_COMPAT</td>
 * <td>ダブルクォートを変換し、シングルクォートはそのままにします。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_QUOTES</td>
 * <td>ダブルクォート、シングルクォートの両方を変換します。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_NOQUOTES</td>
 * <td>ダブルクォート、シングルクォートの両方をそのままにします。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_HTML401</td>
 * <td>
 * コードを HTML 4.01 として処理します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_XML1</td>
 * <td>
 * コードを XML 1 として処理します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_XHTML</td>
 * <td>
 * コードを XHTML として処理します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_HTML5</td>
 * <td>
 * コードを HTML 5 として処理します。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @return string デコードされた文字列を返します。
 */
function htmlspecialchars_decode ($string, $flags = null) {}

/**
 * <function>htmlspecialchars</function> および <function>htmlentities</function> で使用される変換テーブルを返す
 * @link http://www.php.net/manual/ja/function.get-html-translation-table.php
 * @param table int[optional] <p>
 * どちらのテーブルを返すか。HTML_ENTITIES あるいは
 * HTML_SPECIALCHARS。
 * </p>
 * @param flags int[optional] <p>
 * 以下のフラグのビットマスクによる組み合わせで、
 * どのクォートをテーブルに含めるのか、そしてどのドキュメント形式用のテーブルにするのかを指定します。
 * デフォルトは ENT_COMPAT | ENT_HTML401 です。
 * <table>
 * 使用可能な flags 定数
 * <tr valign="top">
 * <td>定数名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_COMPAT</td>
 * <td>テーブルにダブルクォート用のエンティティを含めますが、シングルクォート用は含めません。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_QUOTES</td>
 * <td>テーブルにダブルクォート用、シングルクォート用の両方のエンティティを含めます。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_NOQUOTES</td>
 * <td>テーブルにダブルクォート用、シングルクォート用のどちらのエンティティも含めません。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_HTML401</td>
 * <td>HTML 4.01 用のテーブル。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_XML1</td>
 * <td>XML 1 用のテーブル。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_XHTML</td>
 * <td>XHTML 用のテーブル。</td>
 * </tr>
 * <tr valign="top">
 * <td>ENT_HTML5</td>
 * <td>HTML 5 用のテーブル。</td>
 * </tr>
 * </table>
 * </p>
 * @param encoding string[optional] <p>
 * 使用するエンコーディング。省略した場合のデフォルト値は、
 * PHP 5.4.0 より前のバージョンでは ISO-8859-1、そして
 * PHP 5.4.0 以降では UTF-8 となります。
 * </p>
 * &reference.strings.charsets;
 * @return array 変換テーブルを配列で返します。元の文字がキー、そしてエンティティが値となります。
 */
function get_html_translation_table ($table = null, $flags = null, $encoding = null) {}

/**
 * 文字列の sha1 ハッシュを計算する
 * @link http://www.php.net/manual/ja/function.sha1.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @param raw_output bool[optional] <p>
 * オプションの raw_output に TRUE
 * が指定された場合、sha1 ダイジェストは 20 バイト長のバイナリ形式で返されます。
 * それ以外の場合は、返り値は 40 文字の 16 進数となります。
 * </p>
 * @return string sha1 ハッシュを文字列で返します。
 */
function sha1 ($str, $raw_output = null) {}

/**
 * ファイルの sha1 ハッシュを計算する
 * @link http://www.php.net/manual/ja/function.sha1-file.php
 * @param filename string <p>
 * ハッシュしたいファイルのファイル名。
 * </p>
 * @param raw_output bool[optional] <p>
 * TRUE を指定すると、長さ 20 のバイナリフォーマットで
 * ダイジェストを返します。
 * </p>
 * @return string 成功した場合に文字列、それ以外の場合に FALSE を返します。
 */
function sha1_file ($filename, $raw_output = null) {}

/**
 * 文字列のmd5ハッシュ値を計算する
 * @link http://www.php.net/manual/ja/function.md5.php
 * @param str string <p>
 * 文字列。
 * </p>
 * @param raw_output bool[optional] <p>
 * オプションのraw_output に TRUE が指定された場合、
 * md5 ダイジェストが 16 バイト長のバイナリ形式で返されます。
 * </p>
 * @return string 32 文字の 16 進数からなるハッシュを返します。
 */
function md5 ($str, $raw_output = null) {}

/**
 * 指定したファイルのMD5ハッシュ値を計算する
 * @link http://www.php.net/manual/ja/function.md5-file.php
 * @param filename string <p>
 * ファイル名
 * </p>
 * @param raw_output bool[optional] <p>
 * TRUE の場合、長さ 16 の生のバイナリフォーマットで
 * ダイジェストを返します。
 * </p>
 * @return string 成功時は文字列、そうでなければ FALSE
 */
function md5_file ($filename, $raw_output = null) {}

/**
 * 文字列の crc32 多項式計算を行う
 * @link http://www.php.net/manual/ja/function.crc32.php
 * @param str string <p>
 * データ。
 * </p>
 * @return int str の crc32 チェックサムを整数値で返します。
 */
function crc32 ($str) {}

/**
 * バイナリの IPTC ブロックのタグをパースする
 * @link http://www.php.net/manual/ja/function.iptcparse.php
 * @param iptcblock string <p>
 * バイナリ IPTC ブロック。
 * </p>
 * @return array タグマーカーをインデックスとし、その値を保持する配列を返します。
 * エラー時や IPTC データが見つからなかったときは FALSE を返します。
 */
function iptcparse ($iptcblock) {}

/**
 * バイナリ IPTC データを JPEG イメージに埋めこむ
 * @link http://www.php.net/manual/ja/function.iptcembed.php
 * @param iptcdata string <p>
 * 書き込むデータ。
 * </p>
 * @param jpeg_file_name string <p>
 * JPEG 画像へのパス。
 * </p>
 * @param spool int[optional] <p>
 * Spool フラグ。これが 2 を超える場合は、JPEG
 * が文字列として返されます。
 * </p>
 * @return mixed 成功し、かつ spool フラグが 2 より小さい場合は、JPEG は文字列では返されません。
 * エラー時には FALSE を返します。
 */
function iptcembed ($iptcdata, $jpeg_file_name, $spool = null) {}

/**
 * 画像の大きさを取得する
 * @link http://www.php.net/manual/ja/function.getimagesize.php
 * @param filename string <p>
 * このパラメータは、情報を取得したいファイルの名前を指定します。
 * ローカルファイルへの参照、あるいは (設定で許可されているなら)
 * ストリームを用いたリモートファイルへの参照を指定できます。
 * </p>
 * @param imageinfo array[optional] <p>
 * オプションのパラメータで、
 * 画像ファイルから何らかの拡張情報を引き出すことが可能です。
 * 現在、この変数にはJPGファイルについて
 * 異なった複数のAPPマーカーが連想配列として返されます。いくつかのプログラムは、
 * これらのAPPマーカーを画像の中の埋込テキストの情報として使用します。
 * 最も一般的な例は、マーカーAPPl3に埋込IPTC
 * http://www.iptc.org/情報が返されることです。
 * バイナリ形式のマーカーAPP13を読むことができるよう処理するために
 * iptcparse 関数を使用することができます。
 * </p>
 * @return array 7 つの要素からなる配列を返します。
 * </p>
 * <p>
 * 0 番目および 1 番目の要素は、それぞれ画像の幅と高さを表します。
 * </p>
 * <p>
 * 形式によっては、画像を含まないものや複数の画像を含むものがあります。
 * これらの場合、getimagesize
 * は画像のサイズを適切に決定することができません。このような場合、
 * getimagesize が返す幅と高さはいずれもゼロとなります。
 * </p>
 * <p>
 * 2 番目の要素は IMAGETYPE_XXX 定数のひとつで、
 * 画像の形式を表します。
 * </p>
 * <p>
 * 3 番目の要素は IMG タグで直接利用できる文字列
 * height="yyy" width="xxx"
 * です。
 * </p>
 * <p>
 * mimeは画像のMIMEタイプに一致します。この情報は
 * 画像とともに正しい HTTP Content-type
 * ヘッダを転送するために使用できます。
 * getimagesize および MIME 型
 * ]]>
 * </p>
 * <p>
 * channels は RGB 画像の場合に 3、CMYK 画像の場合に 4 です。
 * </p>
 * <p>
 * bits は個々の色のビット数です。
 * </p>
 * <p>
 * 画像の形式によっては、channels や
 * bits の値の存在は混乱の元です。
 * たとえば、GIF は常に 1 ピクセルあたり
 * 3 チャンネルを使用しますが、グローバルカラーテーブルを使ったアニメーション GIF
 * のピクセルあたりのビット数を計算することはできません。
 * </p>
 * <p>
 * 失敗した場合には FALSE を返します。
 */
function getimagesize ($filename, array &$imageinfo = null) {}

/**
 * getimagesize, exif_read_data, exif_thumbnail, exif_imagetypeから返される
   画像形式のMIMEタイプを取得する
 * @link http://www.php.net/manual/ja/function.image-type-to-mime-type.php
 * @param imagetype int <p>
 * IMAGETYPE_XXX 定数のいずれか。
 * </p>
 * @return string 戻り値は次のとおりです。
 * <table>
 * 戻り値の定数
 * <tr valign="top">
 * <td>imagetype</td>
 * <td>戻り値</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_GIF</td>
 * <td>image/gif</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_JPEG</td>
 * <td>image/jpeg</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_PNG</td>
 * <td>image/png</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_SWF</td>
 * <td>application/x-shockwave-flash</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_PSD</td>
 * <td>image/psd</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_BMP</td>
 * <td>image/bmp</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_TIFF_II (intel byte order)</td>
 * <td>image/tiff</td>
 * </tr>
 * <tr valign="top">
 * <td>
 * IMAGETYPE_TIFF_MM (motorola byte order)
 * </td>
 * <td>image/tiff</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_JPC</td>
 * <td>application/octet-stream</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_JP2</td>
 * <td>image/jp2</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_JPX</td>
 * <td>application/octet-stream</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_JB2</td>
 * <td>application/octet-stream</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_SWC</td>
 * <td>application/x-shockwave-flash</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_IFF</td>
 * <td>image/iff</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_WBMP</td>
 * <td>image/vnd.wap.wbmp</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_XBM</td>
 * <td>image/xbm</td>
 * </tr>
 * <tr valign="top">
 * <td>IMAGETYPE_ICO</td>
 * <td>image/vnd.microsoft.icon</td>
 * </tr>
 * </table>
 */
function image_type_to_mime_type ($imagetype) {}

/**
 * 画像形式からファイルの拡張子を取得する
 * @link http://www.php.net/manual/ja/function.image-type-to-extension.php
 * @param imagetype int <p>
 * IMAGETYPE_XXX 定数のいずれかひとつ。
 * </p>
 * @param include_dot bool[optional] <p>
 * 拡張子の前にドットをつけるかどうか。デフォルトは TRUE。
 * </p>
 * @return string 指定した型に対応する拡張子を文字列で返します。
 */
function image_type_to_extension ($imagetype, $include_dot = null) {}

/**
 * PHP の設定情報を出力する
 * @link http://www.php.net/manual/ja/function.phpinfo.php
 * @param what int[optional] <p>
 * 以下にあるconstantsビット値をひとつまたは
 * 複数個を加算して、オプションのwhat引数に
 * 渡すことによって出力をカスタマイズできます。
 * それぞれの定数やビット値をor演算子
 * で結んで渡すこともできます。
 * </p>
 * <p>
 * <table>
 * phpinfo のオプション
 * <tr valign="top">
 * <td>名前(定数)</td>
 * <td>値</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>INFO_GENERAL</td>
 * <td>1</td>
 * <td>
 * configure オプション、php.ini の場所、ビルド日時、
 * Web サーバー、オペレーティングシステム等。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>INFO_CREDITS</td>
 * <td>2</td>
 * <td>
 * PHP クレジット。phpcredits も参照ください。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>INFO_CONFIGURATION</td>
 * <td>4</td>
 * <td>
 * ローカルおよびマスタの、現在の PHP ディレクティブの値。
 * ini_get も参照ください。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>INFO_MODULES</td>
 * <td>8</td>
 * <td>
 * ロードされているモジュールと、それぞれの設定。
 * get_loaded_extensions も参照ください。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>INFO_ENVIRONMENT</td>
 * <td>16</td>
 * <td>
 * $_ENV で取得できる環境変数の情報。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>INFO_VARIABLES</td>
 * <td>32</td>
 * <td>
 * EGPCS（環境変数・GET・POST・クッキー・サーバー変数）から
 * すべての 
 * 定義済みの変数を表示します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>INFO_LICENSE</td>
 * <td>64</td>
 * <td>
 * PHP ライセンス情報。ライセンス FAQ も参照ください。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>INFO_ALL</td>
 * <td>-1</td>
 * <td>
 * 上記のすべてを表示します。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function phpinfo ($what = null) {}

/**
 * 現在の PHP バージョンを取得する
 * @link http://www.php.net/manual/ja/function.phpversion.php
 * @param extension string[optional] <p>
 * オプションで指定する拡張モジュール名。
 * </p>
 * @return string オプションの extension
 * パラメータが指定されている場合、phpversion
 * はその拡張モジュールのバージョンを返します。
 * 関連するバージョン情報が存在しない場合、
 * あるいは拡張モジュールが有効でない場合は FALSE を返します。
 */
function phpversion ($extension = null) {}

/**
 * PHP に関するクレジットを出力する
 * @link http://www.php.net/manual/ja/function.phpcredits.php
 * @param flag int[optional] <p>
 * 独自のクレジットページを出力したい場合に flag
 * を利用するとよいでしょう。
 * </p>
 * <p>
 * <table>
 * 定義済みの phpcredits フラグ
 * <tr valign="top">
 * <td>名前</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>CREDITS_ALL</td>
 * <td>
 * すべてのクレジットを含めます。
 * CREDITS_DOCS + CREDITS_GENERAL +
 * CREDITS_GROUP + CREDITS_MODULES + CREDITS_FULLPAGE
 * と同等です。これは、適切なタグを含んだ
 * それ単体で成立する HTML ページを生成します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>CREDITS_DOCS</td>
 * <td>ドキュメントチームのクレジット</td>
 * </tr>
 * <tr valign="top">
 * <td>CREDITS_FULLPAGE</td>
 * <td>
 * 通常、他のフラグと組み合わせて使用します。
 * 他のフラグで指定した情報を含む、それ単体で完全に独立した
 * HTML ページを出力することを指定します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>CREDITS_GENERAL</td>
 * <td>
 * 一般的なクレジット: 言語の設計およびコンセプト、PHP
 * 作者、SAPIモジュール
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>CREDITS_GROUP</td>
 * <td>コア開発者のリスト</td>
 * </tr>
 * <tr valign="top">
 * <td>CREDITS_MODULES</td>
 * <td>PHPの拡張モジュール、およびその作者のリスト</td>
 * </tr>
 * <tr valign="top">
 * <td>CREDITS_SAPI</td>
 * <td>PHP のサーバー API モジュールとその作者のリスト</td>
 * </tr>
 * </table>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function phpcredits ($flag = null) {}

/**
 * ロゴの guid を取得する
 * @link http://www.php.net/manual/ja/function.php-logo-guid.php
 * @return string PHPE9568F34-D428-11d2-A769-00AA001ACF42
 * を返します。
 */
function php_logo_guid () {}

function php_real_logo_guid () {}

function php_egg_logo_guid () {}

/**
 * Zend guid を取得する
 * @link http://www.php.net/manual/ja/function.zend-logo-guid.php
 * @return string PHPE9568F35-D428-11d2-A769-00AA001ACF42
 * を返します。
 */
function zend_logo_guid () {}

/**
 * ウェブサーバーと PHP の間のインターフェイスの型を返す
 * @link http://www.php.net/manual/ja/function.php-sapi-name.php
 * @return string インターフェイスの型を小文字の文字列で返します。
 * </p>
 * <p>
 * これがすべてではありませんが、以下のような値が返されます。
 * aolserver, apache, 
 * apache2filter, apache2handler, 
 * caudium, cgi (PHP 5.3 まで), 
 * cgi-fcgi, cli, 
 * continuity, embed,
 * isapi, litespeed, 
 * milter, nsapi, 
 * phttpd, pi3web, roxen,
 * thttpd, tux そして webjames
 */
function php_sapi_name () {}

/**
 * PHP が稼動しているオペレーティングシステムに関する情報を返す
 * @link http://www.php.net/manual/ja/function.php-uname.php
 * @param mode string[optional] <p>
 * mode は、どのような情報を返すのかを一文字で指定します:
 * 'a': デフォルトです。すべてのモードを
 * "s n r v m" の順で返します。
 * @return string 説明を文字列で返します。
 */
function php_uname ($mode = null) {}

/**
 * 追加の ini ディレクトリにある .ini ファイルのリストを取得する
 * @link http://www.php.net/manual/ja/function.php-ini-scanned-files.php
 * @return string 成功すると、.iniファイルをカンマ区切りにした文字列が返されます。
 * --with-config-file-scan-dir
 * がセットされていなければ、
 * FALSEを返します。指定されたディレクトリが空であれば、
 * 空文字列が返されます。ファイルが認識できないものであれば、
 * そのファイルは文字列には含まれますが同時にPHPがエラーを起こします。
 * このエラーはコンパイルの時と、php_ini_scanned_files
 * 関数を使用したときの両方で発生します。
 */
function php_ini_scanned_files () {}

/**
 * 読み込まれた php.ini ファイルのパスを取得する
 * @link http://www.php.net/manual/ja/function.php-ini-loaded-file.php
 * @return string 読み込まれている php.ini のパス、
 * あるいは読み込まれていない場合に FALSE を返します。
 */
function php_ini_loaded_file () {}

/**
 * "自然順"アルゴリズムにより文字列比較を行う
 * @link http://www.php.net/manual/ja/function.strnatcmp.php
 * @param str1 string <p>
 * 最初の文字列。
 * </p>
 * @param str2 string <p>
 * 次の文字列。
 * </p>
 * @return int 他の文字列比較関数と同様に、この関数は、
 * str1 が str2
 * より小さいに場合に &lt; 0、str1 が
 * str2 より大きい場合に &gt; 0 、等しい場合に
 * 0 を返します。
 */
function strnatcmp ($str1, $str2) {}

/**
 * "自然順"アルゴリズムにより大文字小文字を区別しない文字列比較を行う
 * @link http://www.php.net/manual/ja/function.strnatcasecmp.php
 * @param str1 string <p>
 * 最初の文字列。
 * </p>
 * @param str2 string <p>
 * 次の文字列。
 * </p>
 * @return int 他の文字列比較関数と同様に、この関数は、
 * str1がstr2
 * より小さい場合に &lt; 0、str1が
 * str2より大きい場合に &gt; 0 、等しい場合に
 * 0 を返します。
 */
function strnatcasecmp ($str1, $str2) {}

/**
 * 副文字列の出現回数を数える
 * @link http://www.php.net/manual/ja/function.substr-count.php
 * @param haystack string <p>
 * 検索対象の文字列
 * </p>
 * @param needle string <p>
 * 検索する副文字列
 * </p>
 * @param offset int[optional] <p>
 * 開始位置のオフセット
 * </p>
 * @param length int[optional] <p>
 * 指定したオフセット以降に副文字列で検索する最大長。
 * オフセットと長さの総和が haystack
 * の長さよりも長い場合、警告が発生します。
 * </p>
 * @return int この関数は 整数 を返します。
 */
function substr_count ($haystack, $needle, $offset = null, $length = null) {}

/**
 * 指定したマスク内に含まれる文字からなる文字列の最初のセグメントの長さを探す
 * @link http://www.php.net/manual/ja/function.strspn.php
 * @param subject string <p>
 * 調べたい文字列。
 * </p>
 * @param mask string <p>
 * 許可する文字の一覧。
 * </p>
 * @param start int[optional] <p>
 * subject の中で調べ始める位置。
 * </p>
 * <p>
 * start に非負の値を指定すると、
 * strspn は
 * subject の
 * start 番目の位置から調査を始めます。
 * たとえば、文字列 'abcdef' において
 * 0 番目の位置にある文字は 'a'
 * で 2 番目の位置にある文字は
 * 'c' のようになります。
 * </p>
 * <p>
 * start に負の値を指定すると、
 * strspn は
 * subject の最後から
 * start 番目の位置から調査を始めます。
 * </p>
 * @param length int[optional] <p>
 * subject 内で調べる部分の長さ。
 * </p>
 * <p>
 * length に非負の値を指定すると、
 * subject の開始位置から
 * length 文字ぶんの範囲を調査します。
 * </p>
 * <p>
 * length に負の値を指定すると、
 * subject の調査範囲は
 * 開始位置から始まって subject
 * の最後から length だけさかのぼったところまでとなります。
 * </p>
 * @return int subject の中で、全て
 * mask の中の文字からなる最初のセグメントの長さを返します。
 */
function strspn ($subject, $mask, $start = null, $length = null) {}

/**
 * マスクにマッチしない最初のセグメントの長さを返す
 * @link http://www.php.net/manual/ja/function.strcspn.php
 * @param str1 string <p>
 * 最初の文字列。
 * </p>
 * @param str2 string <p>
 * 2 番目の文字列。
 * </p>
 * @param start int[optional] <p>
 * 調べ始める位置。
 * </p>
 * @param length int[optional] <p>
 * 調べる文字列の長さ。
 * </p>
 * @return int セグメントの長さを返します。
 */
function strcspn ($str1, $str2, $start = null, $length = null) {}

/**
 * 文字列をトークンに分割する
 * @link http://www.php.net/manual/ja/function.strtok.php
 * @param str string <p>
 * より小さい文字列 (トークン) に分割する文字列。
 * </p>
 * @param token string <p>
 * str を分割する際に使用する区切り文字。
 * </p>
 * @return string 文字列トークンを返します。
 */
function strtok ($str, $token) {}

/**
 * 文字列を大文字にする
 * @link http://www.php.net/manual/ja/function.strtoupper.php
 * @param string string <p>
 * 入力文字列。
 * </p>
 * @return string 大文字にした文字列を返します。
 */
function strtoupper ($string) {}

/**
 * 文字列を小文字にする
 * @link http://www.php.net/manual/ja/function.strtolower.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @return string 小文字に変換した文字列を返します。
 */
function strtolower ($str) {}

/**
 * 文字列内の部分文字列が最初に現れる場所を見つける
 * @link http://www.php.net/manual/ja/function.strpos.php
 * @param haystack string <p>
 * 検索を行う文字列。
 * </p>
 * @param needle mixed <p>
 * needle が文字列でない場合は、
 * それを整数に変換し、その番号に対応する文字として扱います。
 * </p>
 * @param offset int[optional] <p>
 * 指定すると、文字列内での検索開始位置がその位置になります。
 * strrpos や
 * strripos と異なり、負の数は指定できません。
 * </p>
 * @return int needle が見つかった位置を、
 * haystack 文字列の先頭 (offset の値とは無関係) からの相対位置で返します。
 * 文字列の開始位置は 0 であり、1 ではないことに注意しましょう。
 * </p>
 * <p>
 * needle が見つからない場合は FALSE を返します。
 */
function strpos ($haystack, $needle, $offset = null) {}

/**
 * 大文字小文字を区別せずに文字列が最初に現れる位置を探す
 * @link http://www.php.net/manual/ja/function.stripos.php
 * @param haystack string <p>
 * 検索を行う文字列。
 * </p>
 * @param needle string <p>
 * needle は、
 * ひとつまたは複数の文字であることに注意しましょう。
 * </p>
 * <p>
 * needle が文字列でない場合は、
 * それを整数に変換し、その番号に対応する文字として扱います。
 * </p>
 * @param offset int[optional] <p>
 * 指定すると、文字列内での検索開始位置がその位置になります。
 * strrpos や
 * strripos と異なり、負の数は指定できません。
 * </p>
 * @return int needle が見つかった位置を、
 * haystack 文字列の先頭 (offset の値とは無関係) からの相対位置で返します。
 * 文字列の開始位置は 0 であり、1 ではないことに注意しましょう。
 * </p>
 * <p>
 * needle が見つからない場合は FALSE を返します。
 */
function stripos ($haystack, $needle, $offset = null) {}

/**
 * 文字列中に、ある部分文字列が最後に現れる場所を探す
 * @link http://www.php.net/manual/ja/function.strrpos.php
 * @param haystack string <p>
 * 検索を行う文字列。
 * </p>
 * @param needle string <p>
 * needle が文字列でない場合は、
 * それを整数に変換し、その番号に対応する文字として扱います。
 * </p>
 * @param offset int[optional] <p>
 * 指定すると、文字列の開始位置からこの文字数だけ進んだところで検索を中止します。
 * 負の値を指定すると、文字列の最後からこの文字数だけ戻ったところから逆向きに検索を開始します。
 * </p>
 * @return int needle が見つかった位置を、
 * haystack 文字列の先頭 (offset の値とは無関係) からの相対位置で返します。
 * 文字列の開始位置は 0 であり、1 ではないことに注意しましょう。
 * </p>
 * <p>
 * needle が見つからない場合は FALSE を返します。
 */
function strrpos ($haystack, $needle, $offset = null) {}

/**
 * 文字列中で、特定の(大文字小文字を区別しない)文字列が最後に現れた位置を探す
 * @link http://www.php.net/manual/ja/function.strripos.php
 * @param haystack string <p>
 * 検索を行う文字列。
 * </p>
 * @param needle string <p>
 * needle が文字列でない場合は、
 * それを整数に変換し、その番号に対応する文字として扱います。
 * </p>
 * @param offset int[optional] <p>
 * 指定すると、文字列の開始位置からこの文字数だけ進んだところで検索を中止します。
 * 負の値を指定すると、文字列の最後からこの文字数だけ戻ったところから逆向きに検索を開始します。
 * </p>
 * @return int needle が見つかった位置を、
 * haystack 文字列の先頭 (offset の値とは無関係) からの相対位置で返します。
 * 文字列の開始位置は 0 であり、1 ではないことに注意しましょう。
 * </p>
 * <p>
 * needle が見つからない場合は FALSE を返します。
 */
function strripos ($haystack, $needle, $offset = null) {}

/**
 * 文字列を逆順にする
 * @link http://www.php.net/manual/ja/function.strrev.php
 * @param string string <p>
 * 逆順にしたい文字列。
 * </p>
 * @return string 逆順にした文字列を返します。
 */
function strrev ($string) {}

/**
 * 論理表記のヘブライ語を物理表記に変換する
 * @link http://www.php.net/manual/ja/function.hebrev.php
 * @param hebrew_text string <p>
 * ヘブライ語の入力文字列。
 * </p>
 * @param max_chars_per_line int[optional] <p>
 * このオプションのパラメータは、
 * 出力される行毎の最大文字数を返します。
 * </p>
 * @return string 物理表記の文字列を返します。
 */
function hebrev ($hebrew_text, $max_chars_per_line = null) {}

/**
 * 論理表記のヘブライ語を、改行の変換も含めて物理表記に変換する
 * @link http://www.php.net/manual/ja/function.hebrevc.php
 * @param hebrew_text string <p>
 * ヘブライ語の入力文字列。
 * </p>
 * @param max_chars_per_line int[optional] <p>
 * このオプションのパラメータは、
 * 出力される行毎の最大文字数を返します。
 * </p>
 * @return string 物理表記の文字列を返します。
 */
function hebrevc ($hebrew_text, $max_chars_per_line = null) {}

/**
 * 改行文字の前に HTML の改行タグを挿入する
 * @link http://www.php.net/manual/ja/function.nl2br.php
 * @param string string <p>
 * 入力文字列。
 * </p>
 * @param is_xhtml bool[optional] <p>
 * XHTML 準拠の改行を使うか否か。
 * </p>
 * @return string 変更後の文字列を返します。
 */
function nl2br ($string, $is_xhtml = null) {}

/**
 * パスの最後にある名前の部分を返す
 * @link http://www.php.net/manual/ja/function.basename.php
 * @param path string <p>
 * パス。
 * </p>
 * <p>
 * Windows では、スラッシュ(/) とバックスラッシュ
 * (\) の両方がディレクトリ区切り文字として使われます。
 * その他の環境ではスラッシュ(/)になります。
 * </p>
 * @param suffix string[optional] <p>
 * 名前の部分が
 * suffix で終了する場合、
 * この部分もカットされます。
 * </p>
 * @return string 指定した path のベース名を返します。
 */
function basename ($path, $suffix = null) {}

/**
 * 親ディレクトリのパスを返す
 * @link http://www.php.net/manual/ja/function.dirname.php
 * @param path string <p>
 * パス。
 * </p>
 * <p>
 * Windows では、スラッシュ(/)とバックスラッシュ
 * (\)の両方がディレクトリ区切り文字として使われます。
 * その他の環境ではスラッシュ(/)になります。
 * </p>
 * @return string 親ディレクトリのパスを返します。
 * path にスラッシュが無い場合は、
 * カレントディレクトリを示すドット ('.')
 * を返します。それ以外の場合は、スラッシュ以降の
 * /component 部分を取り除いた
 * path を返します。
 */
function dirname ($path) {}

/**
 * ファイルパスに関する情報を返す
 * @link http://www.php.net/manual/ja/function.pathinfo.php
 * @param path string <p>
 * 調べたいパス。
 * </p>
 * @param options int[optional] <p>
 * 指定する場合は、どの要素を返すのかを
 * PATHINFO_DIRNAME、
 * PATHINFO_BASENAME、
 * PATHINFO_EXTENSION あるいは
 * PATHINFO_FILENAME
 * のいずれかで指定します。
 * </p>
 * <p>
 * options を省略した場合はすべての要素を返します。
 * </p>
 * @return mixed options パラメータを渡さなかった場合は、次の要素を含む連想配列を返します。
 * dirname、basename、
 * extension (存在すれば)、そして filename。
 * </p>
 * <p>
 * path に複数の拡張子が含まれる場合は、
 * PATHINFO_EXTENSION は最後の拡張子だけを返します。また、
 * PATHINFO_FILENAME は最後の拡張子だけを取り除きます
 * (最初のサンプルを参照ください)。
 * </p>
 * <p>
 * path に拡張子がない場合は、
 * extension 要素は返されません
 * (以下の二番目の例を参照ください)。
 * </p>
 * <p>
 * options を指定すると、
 * 要求した要素を文字列で返します。
 */
function pathinfo ($path, $options = null) {}

/**
 * クォートされた文字列のクォート部分を取り除く
 * @link http://www.php.net/manual/ja/function.stripslashes.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @return string バックスラッシュが取り除かれた文字列を返します(\'
 * が ' になるなど)。
 * 2 つ並んだバックスラッシュ (\\)
 * は 1 つのバックスラッシュ (\) になります。
 */
function stripslashes ($str) {}

/**
 * <function>addcslashes</function> でクォートされた文字列をアンクォートする
 * @link http://www.php.net/manual/ja/function.stripcslashes.php
 * @param str string <p>
 * 元に戻したい文字列。
 * </p>
 * @return string 元に戻した文字列を返します。
 */
function stripcslashes ($str) {}

/**
 * 文字列が最初に現れる位置を見つける
 * @link http://www.php.net/manual/ja/function.strstr.php
 * @param haystack string <p>
 * 入力文字列。
 * </p>
 * @param needle mixed <p>
 * needle が文字列でない場合は、
 * それを整数に変換し、その番号に対応する文字として扱います。
 * </p>
 * @param before_needle bool[optional] <p>
 * TRUE にすると、strstr
 * の返り値は、haystack の中で最初に
 * needle があらわれる箇所より前の部分となります (needle は含めません)。
 * </p>
 * @return string 部分文字列を返します。
 * needle が見つからない場合は FALSE を返します。
 */
function strstr ($haystack, $needle, $before_needle = null) {}

/**
 * 大文字小文字を区別しない <function>strstr</function>
 * @link http://www.php.net/manual/ja/function.stristr.php
 * @param haystack string <p>
 * 検索を行う文字列。
 * </p>
 * @param needle mixed <p>
 * needle が文字列でない場合は、
 * それを整数に変換し、その番号に対応する文字として扱います。
 * </p>
 * @param before_needle bool[optional] <p>
 * TRUE にすると、stristr
 * の返り値は、haystack の中で最初に
 * needle があらわれる箇所より前の部分となります (needle は含めません)。
 * </p>
 * @return string マッチした部分文字列を返します。needle
 * が見つからない場合は FALSE を返します。
 */
function stristr ($haystack, $needle, $before_needle = null) {}

/**
 * 文字列中に文字が最後に現れる場所を取得する
 * @link http://www.php.net/manual/ja/function.strrchr.php
 * @param haystack string <p>
 * 検索を行う文字列。
 * </p>
 * @param needle mixed <p>
 * needle がひとつ以上の文字を含んでいる場合は、
 * 最初のもののみが使われます。この動作は、
 * strstr
 * とは異なります。
 * </p>
 * <p>
 * needle が文字列でない場合は、
 * それを整数に変換し、その番号に対応する文字として扱います。
 * </p>
 * @return string この関数は、部分文字列を返します。
 * needle が見つからない場合は FALSE を返します。
 */
function strrchr ($haystack, $needle) {}

/**
 * 文字列をランダムにシャッフルする
 * @link http://www.php.net/manual/ja/function.str-shuffle.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @return string シャッフルされた文字列を返します。
 */
function str_shuffle ($str) {}

/**
 * 文字列に使用されている単語についての情報を返す
 * @link http://www.php.net/manual/ja/function.str-word-count.php
 * @param string string <p>
 * 文字列。
 * </p>
 * @param format int[optional] <p>
 * この関数の戻り値を設定します。現在サポートされている値は
 * 以下のとおりです。
 * 0 - 見つかった単語の数を返します。
 * @param charlist string[optional] <p>
 * '単語' とみなされる文字に追加する文字のリスト。
 * </p>
 * @return mixed 選択した format に応じて、配列あるいは整数を返します。
 */
function str_word_count ($string, $format = null, $charlist = null) {}

/**
 * 文字列を配列に変換する
 * @link http://www.php.net/manual/ja/function.str-split.php
 * @param string string <p>
 * 入力文字列。
 * </p>
 * @param split_length int[optional] <p>
 * 分割した部分の最大長。
 * </p>
 * @return array オプションのパラメータ
 * split_length が指定されている場合、
 * 返される配列の各要素は、split_length
 * の長さとなります。それ以外の場合、1 文字ずつ分割された配列となります。
 * </p>
 * <p>
 * split_length が 1 より小さい場合に
 * FALSE を返します。split_length が
 * string の長さより大きい場合、文字列全体が
 * 最初の(そして唯一の)要素となる配列を返します。
 */
function str_split ($string, $split_length = null) {}

/**
 * 文字列の中から任意の文字を探す
 * @link http://www.php.net/manual/ja/function.strpbrk.php
 * @param haystack string <p>
 * char_list を探す文字列。
 * </p>
 * @param char_list string <p>
 * このパラメータは大文字小文字を区別します。
 * </p>
 * @return string 見つかった文字から始まる文字列、あるいは見つからなかった場合に
 * FALSE を返します。
 */
function strpbrk ($haystack, $char_list) {}

/**
 * 指定した位置から指定した長さの 2 つの文字列について、バイナリ対応で比較する
 * @link http://www.php.net/manual/ja/function.substr-compare.php
 * @param main_str string <p>
 * 比較したい最初の文字列。
 * </p>
 * @param str string <p>
 * 比較したい二番目の文字列。
 * </p>
 * @param offset int <p>
 * 比較を開始する位置。
 * 負の値を指定した場合は、文字列の最後から数えます。
 * </p>
 * @param length int[optional] <p>
 * 比較する長さ。デフォルト値は、
 * main_str の長さから offset を引いたものと
 * str の長さのうち、長いほうです。
 * </p>
 * @param case_insensitivity bool[optional] <p>
 * case_insensitivity が TRUE の場合、
 * 大文字小文字を区別せずに比較します。
 * </p>
 * @return int main_str の offset
 * 以降が str より小さい場合に負の数、
 * str より大きい場合に正の数、
 * 等しい場合に 0 を返します。offset が
 * main_str の長さ以上であるか、あるいは length
 * が設定されていて 1 未満である場合、substr_compare
 * は警告を表示して FALSE を返します。
 */
function substr_compare ($main_str, $str, $offset, $length = null, $case_insensitivity = null) {}

/**
 * ロケールに基づく文字列比較
 * @link http://www.php.net/manual/ja/function.strcoll.php
 * @param str1 string <p>
 * 最初の文字列。
 * </p>
 * @param str2 string <p>
 * 次の文字列。
 * </p>
 * @return int str1 が str2
 * より小さい場合に 0 未満の値、str1 が
 * str2 より大きい場合に 0 より大きな値、
 * 両者が等しい場合に 0 を返します。
 */
function strcoll ($str1, $str2) {}

/**
 * 文字列の一部分を返す
 * @link http://www.php.net/manual/ja/function.substr.php
 * @param string string <p>
 * 入力文字列。最低 1 文字以上を指定しなければなりません。
 * </p>
 * @param start int <p>
 * start が正の場合、返される文字列は、
 * string の 0 から数えて
 * start番目から始まる文字列となります。
 * 例えば、文字列'abcdef'において位置
 * 0にある文字は、'a'であり、
 * 位置2には'c'があります。
 * </p>
 * <p>
 * start が負の場合、返される文字列は、
 * stringの後ろから数えて
 * start番目から始まる文字列となります。
 * </p>
 * <p>
 * string の長さが
 * start 文字以下の場合は FALSE が返されます。
 * </p>
 * <p>
 * 負の start の使用
 * ]]>
 * </p>
 * @param length int[optional] <p>
 * length が指定され、かつ正である場合、
 * 返される文字列は start
 * (string の長さに依存します)
 * から数えてlength文字数分となります。
 * </p>
 * <p>
 * length が指定され、かつ負である場合、
 * string の終端から多くの文字が省略されます
 * (start が負の場合は、
 * 開始位置を算出したあとで)。
 * もし start が切り出し位置を超える場合、
 * false が返されます。
 * </p>
 * <p>
 * length が指定され、かつ 0 である場合は、
 * 空文字列なら NULL、そうでなければ FALSE を返します。
 * </p>
 * <p>
 * length を省略した場合は、
 * start の位置から文字列の最後までの部分文字列を返します。
 * </p>
 * 負の length の使用
 * ]]>
 * @return string 文字列の一部を返します。失敗した場合に FALSE を返します。あるいは空文字列を返します。
 */
function substr ($string, $start, $length = null) {}

/**
 * 文字列の一部を置換する
 * @link http://www.php.net/manual/ja/function.substr-replace.php
 * @param string mixed <p>
 * 入力文字列。
 * </p>
 * <p>
 * 文字列の配列を指定することもでき、各文字列について順に置換を行います。
 * この場合、他のパラメータ replacement、start
 * および length がスカラ値なら
 * それを各入力文字列に順次適用し、配列なら各入力文字列に対応する要素の値を適用します。
 * </p>
 * @param replacement mixed <p>
 * 置換する文字列。
 * </p>
 * @param start mixed <p>
 * start が正の場合、置換は
 * string で start
 * 番目の文字から始まります。
 * </p>
 * <p>
 * start が負の場合、置換は
 * string の終端から
 * start 番目の文字から始まります。
 * </p>
 * @param length mixed[optional] <p>
 * 正の値を指定した場合、
 * string の置換される部分の長さを表します。
 * 負の場合、置換を停止する位置が string
 * の終端から何文字目であるかを表します。このパラメータが省略された場合、
 * デフォルト値は strlen(string)、すなわち、
 * string の終端まで置換することになります。
 * 当然、もし length がゼロだったら、
 * この関数は string の最初から
 * start の位置に
 * replacement を挿入するということになります。
 * </p>
 * @return mixed 結果の文字列を返します。もし、string
 * が配列の場合、配列が返されます。
 */
function substr_replace ($string, $replacement, $start, $length = null) {}

/**
 * メタ文字をクォートする
 * @link http://www.php.net/manual/ja/function.quotemeta.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @return string メタ文字をクォートした文字列を返します。
 * 空文字を str に渡した場合は FALSE を返します。
 */
function quotemeta ($str) {}

/**
 * 文字列の最初の文字を大文字にする
 * @link http://www.php.net/manual/ja/function.ucfirst.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @return string 変換後の文字列を返します。
 */
function ucfirst ($str) {}

/**
 * 文字列の最初の文字を小文字にする
 * @link http://www.php.net/manual/ja/function.lcfirst.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @return string 変換後の文字列を返します。
 */
function lcfirst ($str) {}

/**
 * 文字列の各単語の最初の文字を大文字にする
 * @link http://www.php.net/manual/ja/function.ucwords.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @return string 変更後の文字列を返します。
 */
function ucwords ($str) {}

/**
 * 文字の変換あるいは部分文字列の置換を行う
 * @link http://www.php.net/manual/ja/function.strtr.php
 * @param str string <p>
 * 変換する文字列。
 * </p>
 * @param from string <p>
 * to に変換される文字列。
 * </p>
 * @param to string <p>
 * from を置換する文字列。
 * </p>
 * @return string 変換後の文字列を返します。
 * </p>
 * <p>
 * replace_pairs の中に空文字列
 * ("") のキーがある場合は
 * FALSE を返します。
 * str がスカラー値でない場合は文字列への変換をせず、
 * 警告を発して NULL を返します。
 */
function strtr ($str, $from, $to) {}

/**
 * 文字列をスラッシュでクォートする
 * @link http://www.php.net/manual/ja/function.addslashes.php
 * @param str string <p>
 * エスケープしたい文字列。
 * </p>
 * @return string エスケープされた文字列を返します。
 */
function addslashes ($str) {}

/**
 * C 言語と同様にスラッシュで文字列をクォートする
 * @link http://www.php.net/manual/ja/function.addcslashes.php
 * @param str string <p>
 * エスケープしたい文字列。
 * </p>
 * @param charlist string <p>
 * エスケープの対象となる文字を並べたもの。
 * charlist
 * が \n, \r 等の文字を含んでいる場合、
 * C言語と同様の手法によりエスケープされます。
 * アスキーコードが32未満または126より大きい文字は、8進表現に変換されます。
 * </p>
 * <p>
 * charlist 引数の文字の列びを定義する際には、
 * 範囲の最初と最後で指定する文字集合に含まれる文字の種類を把握するようにしてください。
 * ]]>
 * また、ある範囲を指定する最初の文字がその範囲の2番目の文字よりも大きな
 * ASCII 値を有している場合、範囲は定義されません。
 * 最初と最後の文字とピリオド文字のみがエスケープされます。
 * ある文字の ASCII 値を見つけるには、
 * ord 関数を使用してください。
 * ]]>
 * </p>
 * <p>
 * エスケープ文字を0, a, b, f, n, r, t , vとする場合には注意してください。
 * これらは、\0, \a, \b, \f, \n, \r, \t , \v に変換されます。PHPでは、
 * \0 (NULL), \r (復改文字), \n (改行文字), \f (フォームフィード),
 * \v (垂直タブ), \t (タブ)
 * が定義済みのエスケープシーケンスですが、C言語では、
 * これら全てが定義済みのエスケープシーケンスです。
 * </p>
 * @return string エスケープされた文字列を返します。
 */
function addcslashes ($str, $charlist) {}

/**
 * 文字列の最後から空白 (もしくはその他の文字) を取り除く
 * @link http://www.php.net/manual/ja/function.rtrim.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @param charlist string[optional] <p>
 * charlist パラメータにより、
 * 削除する文字を指定することも可能です。
 * 削除したい全ての文字をリストにしてください。..
 * を文字の範囲を指定する際に使用可能です。
 * </p>
 * @return string 変更後の文字列を返します。
 */
function rtrim ($str, $charlist = null) {}

/**
 * 検索文字列に一致したすべての文字列を置換する
 * @link http://www.php.net/manual/ja/function.str-replace.php
 * @param search mixed <p>
 * 探したい値。needle (針) と呼ばれることもあります。
 * 配列を使えば、複数の値を指定することもできます。
 * </p>
 * @param replace mixed <p>
 * 見つかった search を置き換える値。
 * 配列を使えば、複数の値を指定することもできます。
 * </p>
 * @param subject mixed <p>
 * 検索・置換の対象となる文字列あるいは配列。
 * haystack (干し草の山) と呼ばれることもあります。
 * </p>
 * <p>
 * subject が配列の場合、
 * subject の各エントリについて検索と置換が行われ、
 * 返り値は同様に配列となります。
 * </p>
 * @param count int[optional] <p>
 * 指定した場合は、マッチして置換が行われた箇所の個数がここに格納されます。
 * </p>
 * @return mixed この関数は、置換後の文字列あるいは配列を返します。
 */
function str_replace ($search, $replace, $subject, &$count = null) {}

/**
 * 大文字小文字を区別しない <function>str_replace</function>
 * @link http://www.php.net/manual/ja/function.str-ireplace.php
 * @param search mixed <p>
 * 探したい値。needle (針) と呼ばれることもあります。
 * 配列を使えば、複数の値を指定することもできます。
 * </p>
 * @param replace mixed <p>
 * 見つかった search を置き換える値。
 * 配列を使えば、複数の値を指定することもできます。
 * </p>
 * @param subject mixed <p>
 * 検索・置換の対象となる文字列あるいは配列。
 * haystack (干し草の山) と呼ばれることもあります。
 * </p>
 * <p>
 * subject が配列の場合は、そのすべての要素に
 * 対して検索と置換が行われ、返される結果も配列となります。
 * </p>
 * @param count int[optional] <p>
 * 指定した場合は、マッチして置換が行われた箇所の個数がここに格納されます。
 * </p>
 * @return mixed 置換した文字列あるいは配列を返します。
 */
function str_ireplace ($search, $replace, $subject, &$count = null) {}

/**
 * 文字列を反復する
 * @link http://www.php.net/manual/ja/function.str-repeat.php
 * @param input string <p>
 * 繰り返す文字列。
 * </p>
 * @param multiplier int <p>
 * input を繰り返す回数。
 * </p>
 * <p>
 * multiplier は 0 以上でなければなりません。
 * multiplier が
 * 0 に設定された場合、この関数は空文字を返します。
 * </p>
 * @return string 繰り返した文字列を返します。
 */
function str_repeat ($input, $multiplier) {}

/**
 * 文字列で使用されている文字に関する情報を返す
 * @link http://www.php.net/manual/ja/function.count-chars.php
 * @param string string <p>
 * 調べたい文字列。
 * </p>
 * @param mode int[optional] <p>
 * 返り値を参照ください。
 * </p>
 * @return mixed mode の値により、
 * count_chars は以下の値のどれかを返します。
 * 0 - 各バイト値をキー、各バイトの出現回数を値とする配列。
 * 1 - 0と同じですが、各バイト値の出現回数がゼロより大きいものの一覧となります。
 * 2 - 0と同じですが、各バイト値の出現回数がゼロであるものの一覧となります。
 * 3 - すべての一意な文字を含む文字列を返します。
 * 4 - 使用されていない全ての文字を含む文字列を返します。
 */
function count_chars ($string, $mode = null) {}

/**
 * 文字列をより小さな部分に分割する
 * @link http://www.php.net/manual/ja/function.chunk-split.php
 * @param body string <p>
 * 分割したい文字列。
 * </p>
 * @param chunklen int[optional] <p>
 * 各部分の長さ。
 * </p>
 * @param end string[optional] <p>
 * 行末の区切り。
 * </p>
 * @return string 分割した文字列を返します。
 */
function chunk_split ($body, $chunklen = null, $end = null) {}

/**
 * 文字列の先頭および末尾にあるホワイトスペースを取り除く
 * @link http://www.php.net/manual/ja/function.trim.php
 * @param str string <p>
 * ホワイトスペースを取り除く string
 * </p>
 * @param charlist string[optional] <p>
 * charlistパラメータにより、削除する
 * 文字を指定することも可能です。削除したい全ての文字をリストに
 * してください。..を文字の範囲を指定する際に
 * 使用可能です。
 * </p>
 * @return string ホワイトスペースを取り除いた文字列
 */
function trim ($str, $charlist = null) {}

/**
 * 文字列の最初から空白 (もしくはその他の文字) を取り除く
 * @link http://www.php.net/manual/ja/function.ltrim.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @param charlist string[optional] <p>
 * charlistパラメータにより、削除する
 * 文字を指定することも可能です。削除したい全ての文字をリストに
 * してください。..を文字の範囲を指定する際に
 * 使用可能です。
 * </p>
 * @return string この関数は文字列の最初から空白文字を取り除き、
 * 取り除かれた文字列を返します。2番目のパラメータを指定しない場合、
 * ltrimは以下の文字を削除します。
 * " " (ASCII 32
 * (0x20)), 通常の空白。
 * "\t" (ASCII 9
 * (0x09)), タブ。
 * "\n" (ASCII 10
 * (0x0A)), 改行。
 * "\r" (ASCII 13
 * (0x0D)), 復帰。
 * "\0" (ASCII 0
 * (0x00)), NUL バイト。
 * "\x0B" (ASCII 11
 * (0x0B)), 垂直タブ。
 */
function ltrim ($str, $charlist = null) {}

/**
 * 文字列から HTML および PHP タグを取り除く
 * @link http://www.php.net/manual/ja/function.strip-tags.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @param allowable_tags string[optional] <p>
 * オプションの2番目の引数により、取り除かないタグを指定できます。
 * </p>
 * <p>
 * HTML コメントや PHP タグも削除されるようになりました。この機能はハードコードされており、
 * allowable_tags で変更することはできません。
 * </p>
 * <p>
 * このパラメータには空白文字を含めてはいけません。
 * strip_tags はタグの大文字小文字を区別せず、
 * &lt; から始まって最初に空白文字か
 * &gt; があらわれるまでをタグとみなします。
 * つまり、strip_tags("&lt;br/&gt;", "&lt;br&gt;")
 * は空文字列を返すということです。
 * </p>
 * @return string タグを除去した文字列を返します。
 */
function strip_tags ($str, $allowable_tags = null) {}

/**
 * 二つの文字列の間の類似性を計算する
 * @link http://www.php.net/manual/ja/function.similar-text.php
 * @param first string <p>
 * 最初の文字列。
 * </p>
 * @param second string <p>
 * 次の文字列。
 * </p>
 * @param percent float[optional] <p>
 * 3 番目の引数としてリファレンスを渡すことにより、
 * similar_text は類似性をパーセントで計算します。
 * </p>
 * @return int 両方の文字列でマッチした文字の数を返します。
 */
function similar_text ($first, $second, &$percent = null) {}

/**
 * 文字列を文字列により分割する
 * @link http://www.php.net/manual/ja/function.explode.php
 * @param delimiter string <p>
 * 区切り文字列。
 * </p>
 * @param string string <p>
 * 入力文字列。
 * </p>
 * @param limit int[optional] <p>
 * limit に正の値が指定された場合、返される配列には
 * 最大 limit の要素が含まれ、その最後の要素には
 * string の残りの部分が全て含まれます。
 * </p>
 * <p>
 * もし limit パラメータが負の場合、
 * 最後の -limit 個の要素を除く全ての構成要素が返されます。
 * </p>
 * <p>
 * limit パラメータがゼロの場合は、1 を指定したものとみなされます。
 * </p>
 * @return array string の内容を
 * delimiter で分割した文字列の配列を返します。
 * </p>
 * <p>
 * 空の文字列 ("") が delimiter として使用された場合、
 * explode は FALSE
 * を返します。delimiter に引数
 * string に含まれていない値が含まれている場合は、
 * limit が負の値なら空の配列、そうでなければ
 * 引数 string を含む配列を返します。
 */
function explode ($delimiter, $string, $limit = null) {}

/**
 * 配列要素を文字列により連結する
 * @link http://www.php.net/manual/ja/function.implode.php
 * @param glue string <p>
 * デフォルトは空文字列です。
 * </p>
 * @param pieces array <p>
 * 連結したい文字列の配列。
 * </p>
 * @return string すべての配列要素の順序を変えずに、各要素間に
 * glue 文字列をはさんで 1 つの文字列にして返します。
 */
function implode ($glue, array $pieces) {}

/**
 * <function>implode</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.join.php
 * @param glue
 * @param pieces
 */
function join ($glue, $pieces) {}

/**
 * ロケール情報を設定する
 * @link http://www.php.net/manual/ja/function.setlocale.php
 * @param category int <p>
 * categoryは、名前付きの定数(または文字列)であり、
 * ロケール設定により影響を受ける関数のカテゴリを指定します。
 * LC_ALL 以下のものすべて
 * @param locale string <p>
 * localeが NULL もしくは空の文字列
 * ""
 * の場合、ロケール名は上記のカテゴリと同じ名前の環境変数の値、
 * または環境変数 "LANG" からセットされます。
 * </p>
 * <p>
 * locale が "0" の場合、
 * ロケール設定は適用されず、単に現在の設定が返されます。
 * </p>
 * <p>
 * locale が配列もしくは追加のパラメータが続く場合、
 * それぞれの配列要素もしくはパラメータは成功するまで新規ロケールとしてセットされます。
 * これは、ロケールが異なるシステムで異なる名前を持っている、
 * もしくはロケールが利用できない場合のフォールバックを提供するといった場合に有用です。
 * </p>
 * @param _ string[optional] 
 * @return string 現在の新しいロケールを返します。ロケール機能が未実装、
 * 指定されたロケールが存在しない、カテゴリ名が無効などの場合は
 * FALSE を返します。
 * </p>
 * <p>
 * また、カテゴリ名が無効の場合は警告メッセージが発生します。
 * カテゴリやロケール名は、
 * RFC 1766
 * や ISO 639 にあります。
 * ロケールの命名方式は、システムによって異なります。
 * </p>
 * <p>
 * setlocale の戻り値は、
 * PHP が実行されているシステムに依存します。
 * システムの setlocale 関数が返す値を返すためです。
 */
function setlocale ($category, $locale, $_ = null) {}

/**
 * 数値に関するフォーマット情報を得る
 * @link http://www.php.net/manual/ja/function.localeconv.php
 * @return array localeconv は、
 * setlocale で設定された現在のロケールに基づきデータを返します。
 * 返される連想配列は、次のフィールドを有します。
 * <tr valign="top">
 * <td>配列要素</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>decimal_point</td>
 * <td>小数点文字</td>
 * </tr>
 * <tr valign="top">
 * <td>thousands_sep</td>
 * <td>千毎の区切り文字</td>
 * </tr>
 * <tr valign="top">
 * <td>grouping</td>
 * <td>数値集合を有する配列</td>
 * </tr>
 * <tr valign="top">
 * <td>int_curr_symbol</td>
 * <td>国際通貨記号 (すなわち、USD)</td>
 * </tr>
 * <tr valign="top">
 * <td>currency_symbol</td>
 * <td>ローカルな通貨記号 (すなわち、$)</td>
 * </tr>
 * <tr valign="top">
 * <td>mon_decimal_point</td>
 * <td>通貨用の小数点文字</td>
 * </tr>
 * <tr valign="top">
 * <td>mon_thousands_sep</td>
 * <td>通貨用の千毎の区切り文字</td>
 * </tr>
 * <tr valign="top">
 * <td>mon_grouping</td>
 * <td>通貨集合を有する配列</td>
 * </tr>
 * <tr valign="top">
 * <td>positive_sign</td>
 * <td>正の値を表す記号</td>
 * </tr>
 * <tr valign="top">
 * <td>negative_sign</td>
 * <td>負の値を表す記号</td>
 * </tr>
 * <tr valign="top">
 * <td>int_frac_digits</td>
 * <td>国際分割桁</td>
 * </tr>
 * <tr valign="top">
 * <td>frac_digits</td>
 * <td>ローカルな分割桁</td>
 * </tr>
 * <tr valign="top">
 * <td>p_cs_precedes</td>
 * <td>
 * currency_symbol が正の値を前に置く場合にTRUE、後に置く場合に
 * FALSE
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>p_sep_by_space</td>
 * <td>
 * 正の値から currency_symbol を1文字の空白で区切る場合にTRUE、
 * そうでない場合にFALSE
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>n_cs_precedes</td>
 * <td>
 * currency_symbol が負の値を前に置く場合にTRUE、後に置く場合に
 * FALSE
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>n_sep_by_space</td>
 * <td>
 * 負の値から currency_symbol を1文字の空白で区切る場合にTRUE、
 * そうでない場合にFALSE
 * </td>
 * </tr>
 * <td>p_sign_posn</td>
 * <td>
 * 0 - 量および通貨記号を括る括弧
 * 1 - 量および通貨記号の前に置く符号文字列
 * 2 - 量および通貨記号の後に置く符号文字列
 * 3 - 通貨記号の直前に置く符号文字列
 * 4 - 通貨記号の直後に置く符号文字列
 * </td>
 * </tr>
 * <td>n_sign_posn</td>
 * <td>
 * 0 - 量および通貨記号を括る括弧
 * 1 - 量および通貨記号の前に置く符号文字列
 * 2 - 量および通貨記号の後に置く符号文字列
 * 3 - 通貨記号の直前に置く符号文字列
 * 4 - 通貨記号の直後に置く符号文字列
 * </td>
 * </tr>
 * </p>
 * <p>
 * n_sign_posn や n_sign_posn
 * は、フォーマッタオプションの文字列を含みます。それぞれの数字は
 * 上に一覧されている条件の 1 つを表します。
 * </p>
 * <p>
 * groupingフィールドには、グループ化する方法を表す数字を定義する配
 * 列が含まれます。例えば、nl_NL ロケール用の通貨 groupingフィールド
 * (UTF-8 モードでのユーロ記号) には、
 * 3、3を値とする要素数2の配列が含まれます。この配列のより高い添字に
 * は、より左側のグループに関するものが含まれます。
 * ある配列要素が、CHAR_MAX に等しい場合、
 * さらにグループは行われません。配列要素が0に等しい場合、
 * 前の要素が使用されています。
 */
function localeconv () {}

/**
 * 文字列の soundex キーを計算する
 * @link http://www.php.net/manual/ja/function.soundex.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @return string soundex キーを文字列で返します。
 */
function soundex ($str) {}

/**
 * 二つの文字列のレーベンシュタイン距離を計算する
 * @link http://www.php.net/manual/ja/function.levenshtein.php
 * @param str1 string <p>
 * レーベンシュタイン距離を計算する文字列のひとつ。
 * </p>
 * @param str2 string <p>
 * レーベンシュタイン距離を計算する文字列のひとつ。
 * </p>
 * @return int この関数は、引数で指定した二つの文字列のレーベンシュタイン距離を返します。
 * 引数文字列の一つが 255 文字の制限より長い場合に -1 を返します。
 */
function levenshtein ($str1, $str2) {}

/**
 * 特定の文字を返す
 * @link http://www.php.net/manual/ja/function.chr.php
 * @param ascii int <p>
 * ascii コード。
 * </p>
 * @return string 指定した文字を返します。
 */
function chr ($ascii) {}

/**
 * 文字の ASCII 値を返す
 * @link http://www.php.net/manual/ja/function.ord.php
 * @param string string <p>
 * 文字。
 * </p>
 * @return int ASCII 値を返します。
 */
function ord ($string) {}

/**
 * 文字列を処理し、変数に代入する
 * @link http://www.php.net/manual/ja/function.parse-str.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @param arr array[optional] <p>
 * 2 番目の引数
 * arr が指定された場合、
 * 変数は、代わりに配列の要素としてこの変数に保存されます。
 * </p>
 * @return void 値を返しません。
 */
function parse_str ($str, array &$arr = null) {}

/**
 * CSV 文字列をパースして配列に格納する
 * @link http://www.php.net/manual/ja/function.str-getcsv.php
 * @param input string <p>
 * パースする文字列。
 * </p>
 * @param delimiter string[optional] <p>
 * フィールド区切り文字 (1 文字のみ)。
 * </p>
 * @param enclosure string[optional] <p>
 * フィールド囲み文字 (1 文字のみ)。
 * </p>
 * @param escape string[optional] <p>
 * エスケープ文字 (1 文字のみ)。デフォルトはバックスラッシュ
 * (\)。
 * </p>
 * @return array 読み込んだフィールドの内容を配列で返します。
 */
function str_getcsv ($input, $delimiter = null, $enclosure = null, $escape = null) {}

/**
 * 文字列を固定長の他の文字列で埋める
 * @link http://www.php.net/manual/ja/function.str-pad.php
 * @param input string <p>
 * 入力文字列。
 * </p>
 * @param pad_length int <p>
 * pad_length の値が負、
 * または入力文字列の長さ以下である場合、埋める操作は行われません。
 * </p>
 * @param pad_string string[optional] <p>
 * 必要とされる埋める文字数が pad_string
 * の長さで均等に分割できない場合、pad_string
 * は切り捨てられます。
 * </p>
 * @param pad_type int[optional] <p>
 * オプションの引数 pad_type には、
 * STR_PAD_RIGHT, STR_PAD_LEFT,
 * STR_PAD_BOTH
 * を指定可能です。
 * pad_typeが指定されない場合、
 * STR_PAD_RIGHT
 * を仮定します。
 * </p>
 * @return string 埋めた後の文字列を返します。
 */
function str_pad ($input, $pad_length, $pad_string = null, $pad_type = null) {}

/**
 * <function>rtrim</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.chop.php
 * @param str
 * @param character_mask[optional]
 */
function chop ($str, $character_mask) {}

/**
 * <function>strstr</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.strchr.php
 * @param haystack
 * @param needle
 * @param part[optional]
 */
function strchr ($haystack, $needle, $part) {}

/**
 * フォーマットされた文字列を返す
 * @link http://www.php.net/manual/ja/function.sprintf.php
 * @param format string <p>
 * フォーマット文字列は 0 個以上のディレクティブ（指示子）
 * により構成されます。ディレクティブには、そのまま結果にコピーされる
 * (% を除く) 通常の文字と変換指定子
 * (conversion specifications) があり、
 * 取り出される際はどちらもそれ自身がパラメータとなります。このことは
 * sprintf の場合だけでなく printf
 * の場合も同様です。
 * </p>
 * <p>
 * 各変換指定子は、パーセント記号 (%) の後に
 * これらの要素が一つ以上続いたものになります。
 * オプションの符号指定子。これは、
 * 数値で符号 (- あるいは +) を使用するよう指定します。
 * デフォルトでは、数値が負の場合の - 符号のみが使用されます。
 * この指定子により、正の数にも強制的に + 符号をつけることができます。
 * これは PHP 4.3.0 で追加されました。
 * @param args mixed[optional] <p>
 * </p>
 * @param _ mixed[optional] 
 * @return string フォーマット文字列 format
 * に基づき生成された文字列を返します。
 */
function sprintf ($format, $args = null, $_ = null) {}

/**
 * フォーマット済みの文字列を出力する
 * @link http://www.php.net/manual/ja/function.printf.php
 * @param format string <p>
 * format についての説明は
 * sprintf を参照ください。
 * </p>
 * @param args mixed[optional] <p>
 * </p>
 * @param _ mixed[optional] 
 * @return int 出力した文字列の長さを返します。
 */
function printf ($format, $args = null, $_ = null) {}

/**
 * フォーマットされた文字列を出力する
 * @link http://www.php.net/manual/ja/function.vprintf.php
 * @param format string <p>
 * format についての説明は
 * sprintf を参照ください。
 * </p>
 * @param args array <p>
 * </p>
 * @return int 出力された文字列の長さを返します。
 */
function vprintf ($format, array $args) {}

/**
 * フォーマットされた文字列を返す
 * @link http://www.php.net/manual/ja/function.vsprintf.php
 * @param format string <p>
 * format についての説明は
 * sprintf を参照ください。
 * </p>
 * @param args array <p>
 * </p>
 * @return string (sprintfのドキュメントに記述された)
 * format に基づきフォーマットされた文字列として配列値を返します。
 */
function vsprintf ($format, array $args) {}

/**
 * フォーマットされた文字列をストリームに書き込む
 * @link http://www.php.net/manual/ja/function.fprintf.php
 * @param handle resource fopen
 * を使用して作成したファイルシステムポインタリソース。</p>
 * @param format string <p>
 * format については、
 * sprintf のドキュメントで説明されています。
 * </p>
 * @param args mixed[optional] <p>
 * </p>
 * @param _ mixed[optional] 
 * @return int 書き込まれた文字列の長さを返します。
 */
function fprintf ($handle, $format, $args = null, $_ = null) {}

/**
 * フォーマットされた文字列をストリームに書き込む
 * @link http://www.php.net/manual/ja/function.vfprintf.php
 * @param handle resource <p>
 * </p>
 * @param format string <p>
 * format については、
 * sprintf のドキュメントで説明されています。
 * </p>
 * @param args array <p>
 * </p>
 * @return int 出力された文字列の長さを返します。
 */
function vfprintf ($handle, $format, array $args) {}

/**
 * フォーマット文字列に基づき入力を処理する
 * @link http://www.php.net/manual/ja/function.sscanf.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @param format string <p>
 * str を解釈するフォーマット。
 * sprintf のドキュメントにある説明と比べて、以下の違いがあります。
 * ロケールに対応していません。
 * F、g、G および
 * b はサポートしていません。
 * D は十進数値を表します。
 * i は基数検出つきの整数値を表します。
 * n は処理する文字数を表します。
 * </p>
 * @param _ mixed[optional] 
 * @return mixed この関数のパラメータが二つだけの場合、処理された値は配列として返されます。
 * それ以外の場合は、もしオプションのパラメータが渡されればこの関数は
 * 割り当てられた値の数を返します。オプションのパラメータは
 * 参照渡しにする必要があります。
 * </p>
 * <p>
 * format で期待する部分文字列のほうが
 * 実際に str に存在するものより多い場合は
 * -1 を返します。
 */
function sscanf ($str, $format, &$_ = null) {}

/**
 * フォーマットに基づきファイルからの入力を処理する
 * @link http://www.php.net/manual/ja/function.fscanf.php
 * @param handle resource fopen
 * を使用して作成したファイルシステムポインタリソース。</p>
 * @param format string <p>
 * sprintf のドキュメントに説明されているフォーマット。
 * </p>
 * @param _ mixed[optional] 
 * @return mixed この関数のパラメータが二つだけの場合、処理された値は配列として返されます。
 * 他方、オプションのパラメータが指定された場合、
 * この関数は、代入された値の数を返します。
 * オプション引数は参照渡しとする必要があります。
 */
function fscanf ($handle, $format, &$_ = null) {}

/**
 * URL を解釈し、その構成要素を返す
 * @link http://www.php.net/manual/ja/function.parse-url.php
 * @param url string <p>
 * パースする URL。無効な文字は
 * _ に置換されます。
 * </p>
 * @param component int[optional] <p>
 * PHP_URL_SCHEME、
 * PHP_URL_HOST、PHP_URL_PORT、
 * PHP_URL_USER、PHP_URL_PASS、
 * PHP_URL_PATH、PHP_URL_QUERY
 * あるいは PHP_URL_FRAGMENT のうちのいずれかを指定し、
 * 特定の URL コンポーネントのみを文字列
 * (PHP_URL_PORT を指定した場合だけは整数値)
 * で取得するようにします。
 * </p>
 * @return mixed 完全におかしな形式の URL については、parse_url は
 * FALSE を返します。
 * </p>
 * <p>
 * component を省略した場合は、連想配列を返します。
 * 連想配列の中には少なくともひとつの要素が含まれます。
 * この配列に含まれる可能性のある要素は次のとおりです。
 * scheme - 例: http
 * host 
 * port
 * user
 * pass
 * path
 * query - クエスチョンマーク ? 以降
 * fragment - ハッシュマーク # 以降
 * </p>
 * <p>
 * component が指定されている場合、
 * parse_url は配列ではなく文字列
 * (PHP_URL_PORT の場合は整数値) を返します。
 * 要求したコンポーネントが指定した URL の中にない場合は
 * NULL を返します。
 */
function parse_url ($url, $component = null) {}

/**
 * 文字列を URL エンコードする
 * @link http://www.php.net/manual/ja/function.urlencode.php
 * @param str string <p>
 * エンコードする文字列。
 * </p>
 * @return string -_. を除くすべての非英数文字が % 記号
 * (%)に続く二桁の数字で置き換えられ、
 * 空白は + 記号(+)にエンコードされます。
 * 同様の方法で、WWW のフォームからポストされたデータはエンコードされ、
 * application/x-www-form-urlencoded
 * メディア型も同様です。歴史的な理由により、この関数は RFC 3986 エンコード(
 * rawurlencode を参照してください) とは異なり、
 * 空白を + 記号にエンコードします。
 */
function urlencode ($str) {}

/**
 * URL エンコードされた文字列をデコードする
 * @link http://www.php.net/manual/ja/function.urldecode.php
 * @param str string <p>
 * デコードする文字列。
 * </p>
 * @return string デコードした文字列を返します。
 */
function urldecode ($str) {}

/**
 * RFC 3986 に基づき URL エンコードを行う
 * @link http://www.php.net/manual/ja/function.rawurlencode.php
 * @param str string <p>
 * エンコードする URL。
 * </p>
 * @return string -_.~ を除くすべての非アルファベット文字をパーセント
 * 記号 (%)に続いて 2 つの 16 進数がある表現形式に
 * 置き換えた文字列を返します。これは、文字定数が特殊な URL デリミタと
 * して解釈されたり、URL デリミタが(いくつかの電子メールシステムのような)
 * 転送メディアにより文字変換されて失われてしまったりすることが
 * ないように、RFC 3986
 * で定められたエンコーディング方法です。
 * <p>
 * PHP 5.3.0 より前のバージョンでは、rawurlencode はチルダ (~)
 * もエンコードしていました。これは
 * RFC 1738 で定められた方法です。
 * </p>
 */
function rawurlencode ($str) {}

/**
 * URL エンコードされた文字列をデコードする
 * @link http://www.php.net/manual/ja/function.rawurldecode.php
 * @param str string <p>
 * デコードする URL。
 * </p>
 * @return string デコードされた URL を文字列で返します。
 */
function rawurldecode ($str) {}

/**
 * URL エンコードされたクエリ文字列を生成する
 * @link http://www.php.net/manual/ja/function.http-build-query.php
 * @param query_data mixed <p>
 * プロパティを含む配列もしくはオブジェクト。
 * </p>
 * <p>
 * query_data が配列の場合の形式は、
 * 単純な一次元構造か
 * あるいは配列の配列 (言い換えると、他の配列を含む配列) となります。
 * </p>
 * <p>
 * query_data がオブジェクトの場合、
 * public プロパティだけが結果に含められます。
 * </p>
 * @param numeric_prefix string[optional] <p>
 * もし数値インデックスが基底となる配列に使用されたり
 * numeric_prefix が指定された場合、
 * 基底となる配列の要素に対する数値インデックスの前にこれが追加されます。
 * </p>
 * <p>
 * これは、後で PHP や他の CGI
 * アプリケーションによってデータがデコードされる際、
 * 正当な変数名になるよう考慮したものです。
 * </p>
 * @param arg_separator string[optional] <p>
 * arg_separator.output
 * が区分のためのセパレータとして使用されます。ただし、
 * このパラメータが指定されていた場合は
 * それが使用されます。
 * </p>
 * @param enc_type int[optional] <p>
 * デフォルトは PHP_QUERY_RFC1738 です。
 * </p>
 * <p>
 * enc_type が
 * PHP_QUERY_RFC1738 の場合は
 * RFC 1738 に従ってエンコードされ、メディアタイプは
 * application/x-www-form-urlencoded となります。
 * つまり、スペースはプラス記号 (+) にエンコードされるということです。
 * </p>
 * <p>
 * enc_type が
 * PHP_QUERY_RFC3986 の場合は
 * RFC 3986 に従ってエンコードされ、
 * スペースはパーセント形式 (%20) となります。
 * </p>
 * @return string URL エンコードされた文字列を返します。
 */
function http_build_query ($query_data, $numeric_prefix = null, $arg_separator = null, $enc_type = null) {}

/**
 * リンクに関する情報を取得する
 * @link http://www.php.net/manual/ja/function.linkinfo.php
 * @param path string <p>
 * リンクへのパス。
 * </p>
 * @return int linkinfoは、lstat
 * システムコールで返された
 * Unix C 言語の stat 構造体の st_dev
 * フィールドを返します。
 * 0 を返し、エラーの場合に
 * FALSE を返します。
 */
function linkinfo ($path) {}

/**
 * ハードリンクを作成する
 * @link http://www.php.net/manual/ja/function.link.php
 * @param target string <p>
 * リンクの対象。
 * </p>
 * @param link string <p>
 * リンクの名前。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function link ($target, $link) {}

/**
 * ファイルを削除する
 * @link http://www.php.net/manual/ja/function.unlink.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @param context resource[optional] コンテキストのサポートは、
 * PHP 5.0.0 で追加されました。contexts の説明に関しては、
 * を参照してください。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function unlink ($filename, $context = null) {}

/**
 * 外部プログラムを実行する
 * @link http://www.php.net/manual/ja/function.exec.php
 * @param command string <p>
 * 実行するコマンド
 * </p>
 * @param output array[optional] <p>
 * 引数 output が存在する場合、指定した配列は、
 * コマンドからの出力の各行で埋められます。
 * \n のような後に続く空白は、この配列には含まれません。
 * 配列に既に何らかの要素が
 * 含まれる場合は、exec は配列の最後に追加される
 * ことに注意してください。関数が要素を追加することを望まないのなら、
 * それが exec に渡される前に、配列の
 * unset を呼び出してください。
 * </p>
 * @param return_var int[optional] <p>
 * 引数return_varが、引数
 * output と共に存在する場合、実行したコマンドの
 * ステータスがこの変数に書かれます。
 * </p>
 * @return string コマンド結果の最後の行を返します。コマンドを実行し、
 * 一切干渉を受けずに直接コマンドから全てのデータを受けとる必要が
 * あるならば、PassThru 関数を使ってください。
 * </p>
 * <p>
 * 実行されたコマンドの出力を取得するには、必ず output
 * パラメータを設定・使用してください。
 */
function exec ($command, array &$output = null, &$return_var = null) {}

/**
 * 外部プログラムを実行し、出力を表示する
 * @link http://www.php.net/manual/ja/function.system.php
 * @param command string <p>
 * 実行するコマンド。
 * </p>
 * @param return_var int[optional] <p>
 * 引数 return_var が存在する場合、
 * 実行したコマンドの返すステータスがこの変数に書かれます。
 * </p>
 * @return string 成功時はコマンド出力の最後の行を返し、失敗時は FALSE を返します。
 */
function system ($command, &$return_var = null) {}

/**
 * シェルのメタ文字をエスケープする
 * @link http://www.php.net/manual/ja/function.escapeshellcmd.php
 * @param command string <p>
 * エスケープされるコマンド
 * </p>
 * @return string エスケープされた文字列
 */
function escapeshellcmd ($command) {}

/**
 * シェル引数として使用される文字列をエスケープする
 * @link http://www.php.net/manual/ja/function.escapeshellarg.php
 * @param arg string <p>
 * エスケープされる引数
 * </p>
 * @return string エスケープされた文字列
 */
function escapeshellarg ($arg) {}

/**
 * 外部プログラムを実行し、未整形の出力を表示する
 * @link http://www.php.net/manual/ja/function.passthru.php
 * @param command string <p>
 * 実行するコマンド
 * </p>
 * @param return_var int[optional] <p>
 * 引数return_varが存在する場合、
 * Unix コマンドのステータスがこの変数に書かれます。
 * </p>
 * @return void 値を返しません。
 */
function passthru ($command, &$return_var = null) {}

/**
 * シェルによりコマンドを実行し、文字列として出力全体を返す
 * @link http://www.php.net/manual/ja/function.shell-exec.php
 * @param cmd string <p>
 * 実行するコマンド
 * </p>
 * @return string 実行されたコマンドからの出力、あるいはエラーが発生した場合は NULL を返します。
 */
function shell_exec ($cmd) {}

/**
 * コマンドを実行し、入出力用にファイルポインタを開く
 * @link http://www.php.net/manual/ja/function.proc-open.php
 * @param cmd string <p>
 * 実行されるコマンド。
 * </p>
 * @param descriptorspec array <p>
 * 数値添字の配列で、ディスクリプタ番号をキーとし、PHP がその
 * ディスクリプタをどのように子プロセスに渡すかを表すのが
 * 対応する値となります。
 * 0 が標準入力 (stdin)、1 が標準出力 (stdout) で、
 * 2 が標準エラー出力 (stderr) となります。
 * </p>
 * <p>
 * 各要素は、次のようになります。
 * プロセスに渡すパイプをあらわす配列。
 * 最初の要素はディスクリプタの型で、2 番目の要素がその型に対応するオプションとなります。
 * 使用できる型は pipe (2 番目の要素は、
 * プロセスにパイプの読み込み側を渡すのなら r、
 * 書き込み側を渡すのなら w)
 * および file (2 番目の要素はファイル名)
 * です。
 * 実際のファイルディスクリプタ (オープンしたファイルやソケット、
 * STDIN など) をあらわすストリームリソース。
 * </p>
 * <p>
 * ファイルディスクリプタの番号は、特に 0, 1, 2 に限られているわけでは
 * ありません。有効であるどのようなファイルディスクリプタの番号も指定でき、
 * それは子プロセスに渡されます。これにより、あるスクリプトと、
 * 子プロセスとして起動している別のスクリプトとの間で通信ができます。
 * 特に、これは PGP や GPG、openssl といったプログラムにパスフレーズを
 * より安全な方法で渡したいとき威力を発揮します。
 * 補助的なファイルディスクリプタを介して、そのようなプログラムの
 * 状態を取得するのにも便利です。
 * </p>
 * @param pipes array <p>
 * PHP 側で生成されたパイプの終端にあたる
 * ファイルポインタの配列。
 * </p>
 * @param cwd string[optional] <p>
 * コマンドの初期作業ディレクトリ。
 * 完全パスである必要があります。
 * デフォルト値 (現在の PHP プロセスの作業ディレクトリ) を使用したい場合は
 * NULL を指定します。
 * </p>
 * @param env array[optional] <p>
 * 実行するコマンドのための環境変数の配列。
 * 現在の PHP プロセスと同じ環境変数を使用する場合は
 * NULL を指定します。
 * </p>
 * @param other_options array[optional] <p>
 * その他の追加オプションを指定することが可能です。
 * 現在サポートされているオプションは次の通りです。
 * suppress_errors (windows のみ):
 * TRUE にすると、この関数が出力するエラーを抑制します。
 * bypass_shell (windows のみ):
 * TRUE にすると、cmd.exe シェルをバイパスします。
 * </p>
 * @return resource プロセスを表すリソースを返します。このリソースは、使用し終えた際に
 * proc_close を使用して開放する必要があります。
 * 失敗した場合は FALSE を返します。
 */
function proc_open ($cmd, array $descriptorspec, array &$pipes, $cwd = null, array $env = null, array $other_options = null) {}

/**
 * <function>proc_open</function> で開かれたプロセスを閉じ、
  そのプロセスの終了コードを返す
 * @link http://www.php.net/manual/ja/function.proc-close.php
 * @param process resource <p>
 * 閉じられる proc_open リソース
 * </p>
 * @return int 実行していたプロセスの終了状態を返します。
 * エラーが発生した場合は -1 を返します。
 */
function proc_close ($process) {}

/**
 * proc_open でオープンされたプロセスを強制終了する
 * @link http://www.php.net/manual/ja/function.proc-terminate.php
 * @param process resource <p>
 * 終了させる proc_open リソース。
 * </p>
 * @param signal int[optional] <p>
 * このオプションパラメータは POSIX
 * オペレーティングシステムでのみ有用です。
 * kill(2) システムコールを使用して、
 * プロセスに送信するシグナルを指定することができます。
 * デフォルトは SIGTERM です。
 * </p>
 * @return bool 実行していたプロセスの終了状態を返します。
 */
function proc_terminate ($process, $signal = null) {}

/**
 * <function>proc_open</function>
  で開かれたプロセスに関する情報を取得する
 * @link http://www.php.net/manual/ja/function.proc-get-status.php
 * @param process resource <p>
 * 評価される proc_open リソース
 * </p>
 * @return array 成功時は集められた情報の配列、失敗時は FALSE 。
 * 返される配列は次のような要素を持ちます:
 * </p>
 * <p>
 * <tr valign="top"><td>要素</td><td>型</td><td>説明</td></tr>
 * <tr valign="top">
 * <td>command</td>
 * <td>string</td>
 * <td>
 * proc_open に指定されたコマンド文字列。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>pid</td>
 * <td>int</td>
 * <td>プロセス ID</td>
 * </tr>
 * <tr valign="top">
 * <td>running</td>
 * <td>bool</td>
 * <td>
 * もしプロセスがまだ動いている場合は、TRUE 、すでに終了している場合は
 * FALSE。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>signaled</td>
 * <td>bool</td>
 * <td>
 * 子プロセスが、キャッチされていないシグナルにより終了した場合に
 * TRUE となります。Windows では常に FALSE にセットされます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>stopped</td>
 * <td>bool</td>
 * <td>
 * 子プロセスが、シグナルにより停止した時に TRUE となります。
 * Windows では常に FALSE にセットされます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>exitcode</td>
 * <td>int</td>
 * <td>
 * プロセスが返した終了コード
 * (running が FALSE の時のみ意味を持ちます)。
 * 正しい値を返すのは関数を最初にコールした時のみで、次に
 * コールした際には -1 を返します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>termsig</td>
 * <td>int</td>
 * <td>
 * プロセスを終了させたシグナルの番号です (signaled が
 * TRUE の時のみ意味を持ちます)。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>stopsig</td>
 * <td>int</td>
 * <td>
 * プロセスを停止させたシグナルの番号です (stopped が
 * TRUE の時のみ意味を持ちます)。
 * </td>
 * </tr>
 */
function proc_get_status ($process) {}

/**
 * 乱数を生成する
 * @link http://www.php.net/manual/ja/function.rand.php
 * @param min[optional]
 * @param max[optional]
 * @return int min (あるいは 0)
 * から max (あるいは getrandmax、それぞれ端点を含む)
 * までの間の疑似乱数値を返します。
 */
function rand ($min, $max) {}

/**
 * 乱数ジェネレータを初期化する
 * @link http://www.php.net/manual/ja/function.srand.php
 * @param seed int[optional] <p>
 * オプションで指定するシード値。
 * </p>
 * @return void 値を返しません。
 */
function srand ($seed = null) {}

/**
 * 乱数の最大値を取得する
 * @link http://www.php.net/manual/ja/function.getrandmax.php
 * @return int rand が返す乱数の最大値を返します。
 */
function getrandmax () {}

/**
 * よりよい乱数値を生成する
 * @link http://www.php.net/manual/ja/function.mt-rand.php
 * @param min[optional]
 * @param max[optional]
 * @return int min (あるいは 0)
 * から max (あるいは mt_getrandmax、それぞれ端点を含む)
 * までの間のランダムな整数値を返します。
 * max が min より小さい場合は
 * FALSE を返します。
 */
function mt_rand ($min, $max) {}

/**
 * 改良型乱数生成器にシードを指定する
 * @link http://www.php.net/manual/ja/function.mt-srand.php
 * @param seed int[optional] <p>
 * オプションで指定するシード値。
 * </p>
 * @return void 値を返しません。
 */
function mt_srand ($seed = null) {}

/**
 * 乱数値の最大値を表示する
 * @link http://www.php.net/manual/ja/function.mt-getrandmax.php
 * @return int mt_rand が返す乱数の最大値を返します。
 */
function mt_getrandmax () {}

/**
 * インターネットサービスおよびプロトコルが関連するポート番号を取得する
 * @link http://www.php.net/manual/ja/function.getservbyname.php
 * @param service string <p>
 * インターネットサービス名を表す文字列。
 * </p>
 * @param protocol string <p>
 * protocol は "tcp"
 * あるいは "udp" (小文字) のいずれかです。
 * </p>
 * @return int ポート番号を返します。 service あるいは
 * protocol が見つからない場合は
 * FALSE を返します。
 */
function getservbyname ($service, $protocol) {}

/**
 * ポートおよびプロトコルに対応するインターネットサービスを得る
 * @link http://www.php.net/manual/ja/function.getservbyport.php
 * @param port int <p>
 * ポート番号。
 * </p>
 * @param protocol string <p>
 * protocol は "tcp"
 * あるいは "udp" (小文字) のいずれかです。
 * </p>
 * @return string インターネットサービス名を文字列で返します。
 */
function getservbyport ($port, $protocol) {}

/**
 * プロトコル名のプロトコル番号を得る
 * @link http://www.php.net/manual/ja/function.getprotobyname.php
 * @param name string <p>
 * プロトコル名。
 * </p>
 * @return int プロトコル番号を返します。
 * 失敗した場合に FALSE を返します。
 */
function getprotobyname ($name) {}

/**
 * プロトコル番号が指すプロトコル名を取得する
 * @link http://www.php.net/manual/ja/function.getprotobynumber.php
 * @param number int <p>
 * プロトコル番号。
 * </p>
 * @return string プロトコル名を文字列で返します。失敗した場合に FALSE を返します。
 */
function getprotobynumber ($number) {}

/**
 * PHP スクリプト所有者のユーザー ID を取得する
 * @link http://www.php.net/manual/ja/function.getmyuid.php
 * @return int 現在のスクリプトのユーザー ID を返し、エラーの場合は FALSE を返します。
 */
function getmyuid () {}

/**
 * PHP スクリプトの所有者の GID を得る
 * @link http://www.php.net/manual/ja/function.getmygid.php
 * @return int 現在のスクリプトのグループ ID を返します。またはエラー時に
 * FALSE を返します。
 */
function getmygid () {}

/**
 * PHP のプロセス ID を取得する
 * @link http://www.php.net/manual/ja/function.getmypid.php
 * @return int 現在の PHP のプロセス ID を返し、エラーの場合は FALSE を返します。
 */
function getmypid () {}

/**
 * 現在のスクリプトの inode を取得する
 * @link http://www.php.net/manual/ja/function.getmyinode.php
 * @return int 現在のスクリプトの inode を表す整数値、あるいはエラーの場合は
 * FALSE を返します。
 */
function getmyinode () {}

/**
 * 最終更新時刻を取得する
 * @link http://www.php.net/manual/ja/function.getlastmod.php
 * @return int 現在のページの最終更新時刻を返します。
 * この値は Unix のタイムスタンプで、そのまま date
 * に渡す事ができます。エラーの場合は FALSE を返します。
 */
function getlastmod () {}

/**
 * MIME base64 方式によりエンコードされたデータをデコードする
 * @link http://www.php.net/manual/ja/function.base64-decode.php
 * @param data string <p>
 * デコードされるデータ。
 * </p>
 * @param strict bool[optional] <p>
 * 入力に base64 アルファベットの範囲外の文字が含まれる場合に FALSE を返す。
 * </p>
 * @return string もとのデータを返します。失敗した場合に FALSE を返します。
 * 返り値はバイナリになることもあります。
 */
function base64_decode ($data, $strict = null) {}

/**
 * MIME base64 方式でデータをエンコードする
 * @link http://www.php.net/manual/ja/function.base64-encode.php
 * @param data string <p>
 * エンコードするデータ。
 * </p>
 * @return string エンコードされたデータを文字列で返します。失敗した場合に FALSE を返します。
 */
function base64_encode ($data) {}

/**
 * 文字列を uuencode する
 * @link http://www.php.net/manual/ja/function.convert-uuencode.php
 * @param data string <p>
 * エンコードしたいデータ。
 * </p>
 * @return string uuencode されたデータを返します。
 */
function convert_uuencode ($data) {}

/**
 * uuencode された文字列をデコードする
 * @link http://www.php.net/manual/ja/function.convert-uudecode.php
 * @param data string <p>
 * uuencode されたデータ。
 * </p>
 * @return string デコードしたデータを文字列で返します。
 */
function convert_uudecode ($data) {}

/**
 * 絶対値
 * @link http://www.php.net/manual/ja/function.abs.php
 * @param number mixed <p>
 * 処理する数値。
 * </p>
 * @return number number の絶対値を返します。もし
 * number の型が float であった場合、
 * 返り値の型も float となります。それ以外の場合は
 * 返り値の型は integer となります（float は、
 * integer の最大値より大きい値をとることがありえるからです）。
 */
function abs ($number) {}

/**
 * 端数の切り上げ
 * @link http://www.php.net/manual/ja/function.ceil.php
 * @param value float <p>
 * 丸める値。
 * </p>
 * @return float value の次に大きい整数値を返します。
 * ceil の返り値は float 型と
 * なります。これは、float 値の範囲は通常 int
 * よりも広いためです。
 */
function ceil ($value) {}

/**
 * 端数の切り捨て
 * @link http://www.php.net/manual/ja/function.floor.php
 * @param value float <p>
 * 丸める数値。
 * </p>
 * @return float value をこえない最大の整数の値を返します。
 * floor の返り値は float
 * 型のままとなります。これは、
 * float の範囲が int よりも広いためです。
 */
function floor ($value) {}

/**
 * 浮動小数点数を丸める
 * @link http://www.php.net/manual/ja/function.round.php
 * @param val float <p>
 * 丸める値。
 * </p>
 * @param precision int[optional] <p>
 * オプションで指定する、丸める桁数。
 * </p>
 * @param mode int[optional] <p>
 * 次の定数のいずれかを使って、丸めのモードを指定します。
 * <tr valign="top">
 * <td>定数</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>PHP_ROUND_HALF_UP</td>
 * <td>
 * val が小数点第 precision 位の値になるように、
 * ゼロから離れる方向に丸めます。1.5 は 2 に、そして -1.5 は -2 になります。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>PHP_ROUND_HALF_DOWN</td>
 * <td>
 * val が小数点第 precision 位の値になるように、
 * ゼロに近づく方向に丸めます。1.5 は 1 に、そして -1.5 は -1 になります。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>PHP_ROUND_HALF_EVEN</td>
 * <td>
 * val が小数点第 precision 位の値になるように、
 * 次の偶数に丸めます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>PHP_ROUND_HALF_ODD</td>
 * <td>
 * val が小数点第 precision 位の値になるように、
 * 次の奇数に丸めます。
 * </td>
 * </tr>
 * </p>
 * @return float 丸めた値を返します。
 */
function round ($val, $precision = null, $mode = null) {}

/**
 * 正弦（サイン）
 * @link http://www.php.net/manual/ja/function.sin.php
 * @param arg float <p>
 * ラジアンで表した値。
 * </p>
 * @return float arg のサインを返します。
 */
function sin ($arg) {}

/**
 * 余弦（コサイン）
 * @link http://www.php.net/manual/ja/function.cos.php
 * @param arg float <p>
 * ラジアンで表した角度。
 * </p>
 * @return float arg のコサインを返します。
 */
function cos ($arg) {}

/**
 * 正接（タンジェント）
 * @link http://www.php.net/manual/ja/function.tan.php
 * @param arg float <p>
 * 処理する引数をラジアンで表したもの。
 * </p>
 * @return float arg のタンジェントを返します。
 */
function tan ($arg) {}

/**
 * 逆正弦（アークサイン）
 * @link http://www.php.net/manual/ja/function.asin.php
 * @param arg float <p>
 * 処理する角度。
 * </p>
 * @return float arg のアークサインをラジアンで返します。
 */
function asin ($arg) {}

/**
 * 逆余弦（アークコサイン）
 * @link http://www.php.net/manual/ja/function.acos.php
 * @param arg float <p>
 * 処理する角度。
 * </p>
 * @return float arg のアークコサインをラジアンで返します。
 */
function acos ($arg) {}

/**
 * 逆正接（アークタンジェント）
 * @link http://www.php.net/manual/ja/function.atan.php
 * @param arg float <p>
 * 処理する引数。
 * </p>
 * @return float arg のアークタンジェントをラジアンで返します。
 */
function atan ($arg) {}

/**
 * 逆双曲線正接（アークハイパボリックタンジェント）
 * @link http://www.php.net/manual/ja/function.atanh.php
 * @param arg float <p>
 * 処理する引数。
 * </p>
 * @return float arg のアークハイパボリックタンジェントを返します。
 */
function atanh ($arg) {}

/**
 * 2 変数のアークタンジェント
 * @link http://www.php.net/manual/ja/function.atan2.php
 * @param y float <p>
 * 被除数。
 * </p>
 * @param x float <p>
 * 除数。
 * </p>
 * @return float y/x 
 * のアークタンジェントをラジアンで返します。
 */
function atan2 ($y, $x) {}

/**
 * 双曲線正弦（ハイパボリックサイン）
 * @link http://www.php.net/manual/ja/function.sinh.php
 * @param arg float <p>
 * 処理する引数。
 * </p>
 * @return float arg のハイパボリックサインを返します。
 */
function sinh ($arg) {}

/**
 * 双曲線余弦（ハイパボリックコサイン）
 * @link http://www.php.net/manual/ja/function.cosh.php
 * @param arg float <p>
 * 処理する引数。
 * </p>
 * @return float arg のハイパボリックコサインを返します。
 */
function cosh ($arg) {}

/**
 * 双曲線正接（ハイパボリックタンジェント）
 * @link http://www.php.net/manual/ja/function.tanh.php
 * @param arg float <p>
 * 処理する引数。
 * </p>
 * @return float arg のハイパボリックタンジェントを返します。
 */
function tanh ($arg) {}

/**
 * 逆双曲線正弦（アークハイパボリックサイン）
 * @link http://www.php.net/manual/ja/function.asinh.php
 * @param arg float <p>
 * 処理する角度。
 * </p>
 * @return float arg のアークハイパボリックサインを返します。
 */
function asinh ($arg) {}

/**
 * 逆双曲線余弦（アークハイパボリックコサイン）
 * @link http://www.php.net/manual/ja/function.acosh.php
 * @param arg float <p>
 * 処理する値。
 * </p>
 * @return float arg のアークハイパボリックコサインを返します。
 */
function acosh ($arg) {}

/**
 * 値がゼロに近い時にでも精度を保つために exp(number) - 1 を返す
 * @link http://www.php.net/manual/ja/function.expm1.php
 * @param arg float <p>
 * 処理する引数。
 * </p>
 * @return float 'e' の arg 乗から 1 を引いた値を返します。
 */
function expm1 ($arg) {}

/**
 * 値がゼロに近い時にでも精度を保つ方法で計算した log(1 + number) を返す
 * @link http://www.php.net/manual/ja/function.log1p.php
 * @param number float <p>
 * 処理する引数。
 * </p>
 * @return float log(1 + number) を返します。
 */
function log1p ($number) {}

/**
 * 円周率の値を得る
 * @link http://www.php.net/manual/ja/function.pi.php
 * @return float 円周率の値を不動小数点数で返します。
 */
function pi () {}

/**
 * 値が有限の数値であるかどうかを判定する
 * @link http://www.php.net/manual/ja/function.is-finite.php
 * @param val float <p>
 * 調べる値。
 * </p>
 * @return bool val が このプラットフォーム上の PHP の
 * float 型で有効な範囲内の数である場合に TRUE、
 * それ以外の場合に FALSE を返します。
 */
function is_finite ($val) {}

/**
 * 値が数値でないかどうかを判定する
 * @link http://www.php.net/manual/ja/function.is-nan.php
 * @param val float <p>
 * 調べる値。
 * </p>
 * @return bool val が '非数値 (not a number)'
 * の場合に TRUE、そうでない場合に FALSE を返します。
 */
function is_nan ($val) {}

/**
 * 値が無限大であるかどうかを判定する
 * @link http://www.php.net/manual/ja/function.is-infinite.php
 * @param val float <p>
 * 調べる値。
 * </p>
 * @return bool val が無限大である場合に TRUE、
 * そうでない場合に FALSE を返します。
 */
function is_infinite ($val) {}

/**
 * 指数表現
 * @link http://www.php.net/manual/ja/function.pow.php
 * @param base number <p>
 * 使用する基数。
 * </p>
 * @param exp number <p>
 * 指数。
 * </p>
 * @return number base の exp 乗を返します。
 * 両方の引数が非負の整数で、かつ結果が integer 型の範囲に収まる場合は、結果を integer 型で返します。
 * それ以外の場合は結果を float 型で返します。
 */
function pow ($base, $exp) {}

/**
 * <constant>e</constant> の累乗を計算する
 * @link http://www.php.net/manual/ja/function.exp.php
 * @param arg float <p>
 * 処理する引数。
 * </p>
 * @return float 'e' の arg 乗を返します。
 */
function exp ($arg) {}

/**
 * 自然対数
 * @link http://www.php.net/manual/ja/function.log.php
 * @param arg float <p>
 * 対数を計算する値。
 * </p>
 * @param base float[optional] <p>
 * オプションで指定する、底
 * (デフォルトは 'e' で、これは自然対数となります)。
 * </p>
 * @return float base を指定した場合はそれを底とする
 * arg の対数、指定しない場合は自然対数を返します。
 */
function log ($arg, $base = null) {}

/**
 * 底が 10 の対数
 * @link http://www.php.net/manual/ja/function.log10.php
 * @param arg float <p>
 * 処理する引数。
 * </p>
 * @return float 底を 10 とする arg の対数を返します。
 */
function log10 ($arg) {}

/**
 * 平方根
 * @link http://www.php.net/manual/ja/function.sqrt.php
 * @param arg float <p>
 * 処理する引数。
 * </p>
 * @return float arg の平方根を返します。
 * 負の数を指定した場合は、特別な値 NAN を返します。
 */
function sqrt ($arg) {}

/**
 * 直角三角形の斜辺の長さを計算する
 * @link http://www.php.net/manual/ja/function.hypot.php
 * @param x float <p>
 * 最初の辺の長さ。
 * </p>
 * @param y float <p>
 * 二番目の辺の長さ。
 * </p>
 * @return float 斜辺の長さを返します。
 */
function hypot ($x, $y) {}

/**
 * 度単位の数値をラジアン単位に変換する
 * @link http://www.php.net/manual/ja/function.deg2rad.php
 * @param number float <p>
 * 度で表した角度。
 * </p>
 * @return float number と同等な値をラジアンで表したものを返します。
 */
function deg2rad ($number) {}

/**
 * ラジアン単位の数値を度単位に変換する
 * @link http://www.php.net/manual/ja/function.rad2deg.php
 * @param number float <p>
 * ラジアン値。
 * </p>
 * @return float number と同等な値を度で表したものを返します。
 */
function rad2deg ($number) {}

/**
 * 2 進数 を 10 進数に変換する
 * @link http://www.php.net/manual/ja/function.bindec.php
 * @param binary_string string <p>
 * 変換したい 2 進数文字列。
 * </p>
 * @return number binary_string を 10 進に変換した値を返します。
 */
function bindec ($binary_string) {}

/**
 * 16 進数を 10 進数に変換する
 * @link http://www.php.net/manual/ja/function.hexdec.php
 * @param hex_string string <p>
 * 変換したい 16 進文字列。
 * </p>
 * @return number hex_string を 10 進で表した値を返します。
 */
function hexdec ($hex_string) {}

/**
 * 8 進数を 10 進数に変換する
 * @link http://www.php.net/manual/ja/function.octdec.php
 * @param octal_string string <p>
 * 変換したい 8 進文字列。
 * </p>
 * @return number octal_string を 8 進で表した値を返します。
 */
function octdec ($octal_string) {}

/**
 * 10 進数を 2 進数に変換する
 * @link http://www.php.net/manual/ja/function.decbin.php
 * @param number int <p>
 * 変換したい 10 進数値。
 * </p>
 * <table>
 * 32 ビットマシンでの入力の範囲
 * <tr valign="top">
 * <td>正の number</td>
 * <td>負の number</td>
 * <td>返り値</td>
 * </tr>
 * <tr valign="top">
 * <td>0</td>
 * <td></td>
 * <td>0</td>
 * </tr>
 * <tr valign="top">
 * <td>1</td>
 * <td></td>
 * <td>1</td>
 * </tr>
 * <tr valign="top">
 * <td>2</td>
 * <td></td>
 * <td>10</td>
 * </tr>
 * <tr valign="top">
 * ... normal progression ...</td>
 * </tr>
 * <tr valign="top">
 * <td>2147483646</td>
 * <td></td>
 * <td>1111111111111111111111111111110</td>
 * </tr>
 * <tr valign="top">
 * <td>2147483647 (符号付き integer の最大値)</td>
 * <td></td>
 * <td>1111111111111111111111111111111 (1 が 31 個)</td>
 * </tr>
 * <tr valign="top">
 * <td>2147483648</td>
 * <td>-2147483648</td>
 * <td>10000000000000000000000000000000</td>
 * </tr>
 * <tr valign="top">
 * ... normal progression ...</td>
 * </tr>
 * <tr valign="top">
 * <td>4294967294</td>
 * <td>-2</td>
 * <td>11111111111111111111111111111110</td>
 * </tr>
 * <tr valign="top">
 * <td>4294967295 (符号なし integer の最大値)</td>
 * <td>-1</td>
 * <td>11111111111111111111111111111111 (1 が 32 個)</td>
 * </tr>
 * </table>
 * <table>
 * 64 ビットマシンでの入力の範囲
 * <tr valign="top">
 * <td>正の number</td>
 * <td>負の number</td>
 * <td>返り値</td>
 * </tr>
 * <tr valign="top">
 * <td>0</td>
 * <td></td>
 * <td>0</td>
 * </tr>
 * <tr valign="top">
 * <td>1</td>
 * <td></td>
 * <td>1</td>
 * </tr>
 * <tr valign="top">
 * <td>2</td>
 * <td></td>
 * <td>10</td>
 * </tr>
 * <tr valign="top">
 * ... normal progression ...</td>
 * </tr>
 * <tr valign="top">
 * <td>9223372036854775806</td>
 * <td></td>
 * <td>111111111111111111111111111111111111111111111111111111111111110</td>
 * </tr>
 * <tr valign="top">
 * <td>9223372036854775807 (符号付き integer の最大値)</td>
 * <td></td>
 * <td>111111111111111111111111111111111111111111111111111111111111111 (1 が 63 個)</td>
 * </tr>
 * <tr valign="top">
 * <td></td>
 * <td>-9223372036854775808</td>
 * <td>1000000000000000000000000000000000000000000000000000000000000000</td>
 * </tr>
 * <tr valign="top">
 * ... normal progression ...</td>
 * </tr>
 * <tr valign="top">
 * <td></td>
 * <td>-2</td>
 * <td>1111111111111111111111111111111111111111111111111111111111111110</td>
 * </tr>
 * <tr valign="top">
 * <td></td>
 * <td>-1</td>
 * <td>1111111111111111111111111111111111111111111111111111111111111111 (1 が 64 個)</td>
 * </tr>
 * </table>
 * @return string binary_string を 2 進文字列で表した値を返します。
 */
function decbin ($number) {}

/**
 * 10 進数を 8 進数に変換する
 * @link http://www.php.net/manual/ja/function.decoct.php
 * @param number int <p>
 * 変換したい 10 進数値。
 * </p>
 * @return string number を 8 進文字列で表した値を返します。
 */
function decoct ($number) {}

/**
 * 10 進数を 16 進数に変換する
 * @link http://www.php.net/manual/ja/function.dechex.php
 * @param number int <p>
 * 変換したい 10 進数値。
 * </p>
 * <p>
 * PHP の integer は符号付き整数ですが、
 * dechex ではこれを符号なし整数として扱います。
 * つまり、負の整数を渡しても、それを符号なし整数として処理します。
 * </p>
 * @return string number を 16 進文字列で表した値を返します。
 */
function dechex ($number) {}

/**
 * 数値の基数を任意に変換する
 * @link http://www.php.net/manual/ja/function.base-convert.php
 * @param number string <p>
 * 変換する数値。
 * </p>
 * @param frombase int <p>
 * 返還前の number の基数。
 * </p>
 * @param tobase int <p>
 * 変換後の number の基数。
 * </p>
 * @return string number を基数 tobase 
 * で表した値を返します。
 */
function base_convert ($number, $frombase, $tobase) {}

/**
 * 数字を千位毎にグループ化してフォーマットする
 * @link http://www.php.net/manual/ja/function.number-format.php
 * @param number float <p>
 * フォーマットする数値。
 * </p>
 * @param decimals int[optional] <p>
 * 小数点以下の桁数。
 * </p>
 * @return string number をフォーマットした結果を返します。
 */
function number_format ($number, $decimals = null) {}

/**
 * 引数で除算をした際の剰余を返す
 * @link http://www.php.net/manual/ja/function.fmod.php
 * @param x float <p>
 * 被除数。
 * </p>
 * @param y float <p>
 * 除数。
 * </p>
 * @return float x/y の剰余を返します。
 */
function fmod ($x, $y) {}

/**
 * パックされたインターネットアドレスを、人間が読める形式に変換する
 * @link http://www.php.net/manual/ja/function.inet-ntop.php
 * @param in_addr string <p>
 * 32 ビット IPv4、あるいは 128b ビット IPv6 形式のアドレス。
 * </p>
 * @return string アドレスを文字列で表したものを返します。失敗した場合に FALSE を返します。
 */
function inet_ntop ($in_addr) {}

/**
 * 人間が読める形式の IP アドレスを、パックされた in_addr 形式に変換する
 * @link http://www.php.net/manual/ja/function.inet-pton.php
 * @param address string <p>
 * 可読形式の IPv4 アドレスあるいは IPv6 アドレス。
 * </p>
 * @return string 指定した address を
 * in_addr 形式で表したものを返します。
 * 構文的に無効な address
 * (ドットのない IPv4 アドレスやコロンのない IPv6 アドレスなど)
 * を指定した場合は FALSE を返します。
 */
function inet_pton ($address) {}

/**
 * ドット表記の (IPv4) IP アドレスを、適切なアドレスに変換する
 * @link http://www.php.net/manual/ja/function.ip2long.php
 * @param ip_address string <p>
 * 標準形式のアドレス。
 * </p>
 * @return int IPv4 アドレス、あるいは ip_address
 * が不正な形式の場合に FALSE を返します。
 */
function ip2long ($ip_address) {}

/**
 * (IPv4) インターネットアドレスをインターネット標準ドット表記に変換する
 * @link http://www.php.net/manual/ja/function.long2ip.php
 * @param proper_address string <p>
 * 正しい形式のアドレス。
 * </p>
 * @return string インターネットの IP アドレスを表す文字列を返します。
 */
function long2ip ($proper_address) {}

/**
 * 環境変数の値を取得する
 * @link http://www.php.net/manual/ja/function.getenv.php
 * @param varname string <p>
 * 変数の名前。
 * </p>
 * @return string varname が示す環境変数の値を返し、
 * 環境変数 varname が存在しない場合はFALSEを返します。
 */
function getenv ($varname) {}

/**
 * 環境変数の値を設定する
 * @link http://www.php.net/manual/ja/function.putenv.php
 * @param setting string <p>
 * "FOO=BAR" 形式の設定。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function putenv ($setting) {}

/**
 * コマンドライン引数のリストからオプションを取得する
 * @link http://www.php.net/manual/ja/function.getopt.php
 * @param options string この文字列の各文字をオプション文字として使用し、
 * スクリプトにハイフンひとつ (-)
 * で始まるオプションとして渡された内容とマッチさせます。
 * たとえば、オプション文字列 "x" は
 * -x というオプションを認識します。
 * a-z、A-Z および 0-9 のみを認識します。
 * @param longopts array[optional] オプションの配列。
 * この配列の各要素をオプション文字列として使用し、
 * スクリプトにハイフンふたつ (--)
 * で始まるオプションとして渡された内容とマッチさせます。
 * たとえば、longopts の要素 "opt" は
 * --opt というオプションを認識します。
 * @return array この関数はオプション/引数のペアを連想配列で返します。
 * 失敗した場合は FALSE を返します。
 * </p>
 * <p>
 * オプション以外のものが見つかった時点でオプションのパースは終了し、
 * それ以降の内容は破棄されます。
 */
function getopt ($options, array $longopts = null) {}

/**
 * 現在の Unix タイムスタンプをマイクロ秒まで返す
 * @link http://www.php.net/manual/ja/function.microtime.php
 * @param get_as_float bool[optional] <p>
 * TRUE を指定すると、microtime は文字列ではなく
 * float を返すようになります。詳細は、返り値の説明を参照ください。
 * </p>
 * @return mixed デフォルトでは、microtime は "msec sec"
 * 形式の文字列を返します。ただし、sec は Unix エポック (1970 年 1 月 1 日 0:00:00 GMT)
 * から計算した秒数、msec は sec
 * から経過したマイクロ秒数です。
 * </p>
 * <p>
 * get_as_float を
 * TRUE に設定すると、microtime は結果を
 * float で返します。
 * これは、Unix エポックからの経過秒数をマイクロ秒単位で表したものです。
 */
function microtime ($get_as_float = null) {}

/**
 * 現在の時間を得る
 * @link http://www.php.net/manual/ja/function.gettimeofday.php
 * @param return_float bool[optional] <p>
 * TRUE を指定すると、配列ではなく float で返します。
 * </p>
 * @return mixed デフォルトでは配列を返します。return_float
 * が設定されている場合は float を返します。
 * </p>
 * <p>
 * 配列のキー:
 * "sec" - UNIX エポックからの秒
 * "usec" - マイクロ秒
 * "minuteswest" - グリニッジ基準の分
 * "dsttime" - 夏時間補正の型
 */
function gettimeofday ($return_float = null) {}

/**
 * 一意な ID を生成する
 * @link http://www.php.net/manual/ja/function.uniqid.php
 * @param prefix string[optional] <p>
 * これが有用なのは、たとえば複数ホストで同時に ID
 * を生成するような場合です。このような場合、同じマイクロ秒で同じ ID
 * が生成されてしまう可能性があります。
 * </p>
 * <p>
 * 空の prefix を指定すると、
 * 返される文字列は 13 文字となります。
 * more_entropy が TRUE の場合は
 * 23 文字となります。
 * </p>
 * @param more_entropy bool[optional] <p>
 * TRUE にすると、uniqid は
 * 返り値の最後にさらに別のエントロピーを
 * (線形合同法を使用して) 追加します。これにより、結果が一意になる可能性を高めます。
 * </p>
 * @return string 一意な識別子を文字列で返します。
 */
function uniqid ($prefix = null, $more_entropy = null) {}

/**
 * quoted-printable 文字列を 8 ビット文字列に変換する
 * @link http://www.php.net/manual/ja/function.quoted-printable-decode.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @return string 8 ビットバイナリ文字列を返します。
 */
function quoted_printable_decode ($str) {}

/**
 * 8 ビット文字列を quoted-printable 文字列に変換する
 * @link http://www.php.net/manual/ja/function.quoted-printable-encode.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @return string エンコードされた文字列を返します。
 */
function quoted_printable_encode ($str) {}

/**
 * キリル文字セットを他のものに変換する
 * @link http://www.php.net/manual/ja/function.convert-cyr-string.php
 * @param str string <p>
 * 変換したい文字列。
 * </p>
 * @param from string <p>
 * 変換元のキリル文字セットを一文字で表したもの。
 * </p>
 * @param to string <p>
 * 変換先のキリル文字セットを一文字で表したもの。
 * </p>
 * @return string 変換した文字列を返します。
 */
function convert_cyr_string ($str, $from, $to) {}

/**
 * 現在の PHP スクリプトの所有者の名前を取得する
 * @link http://www.php.net/manual/ja/function.get-current-user.php
 * @return string ユーザー名を表す文字列。
 */
function get_current_user () {}

/**
 * 実行時間の最大値を制限する
 * @link http://www.php.net/manual/ja/function.set-time-limit.php
 * @param seconds int <p>
 * 最大実行時間を表す秒数。ゼロを設定すると、時間制限を行いません。
 * </p>
 * @return void 値を返しません。
 */
function set_time_limit ($seconds) {}

/**
 * PHP 設定オプションの値を取得する
 * @link http://www.php.net/manual/ja/function.get-cfg-var.php
 * @param option string <p>
 * 設定オプションの名前。
 * </p>
 * @return string option で指定された PHP 設定オプションの現在の値を返し、
 * エラーの場合は FALSE を返します。
 */
function get_cfg_var ($option) {}

/**
 * <function>set_magic_quotes_runtime</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.magic-quotes-runtime.php
 * @param new_setting
 */
function magic_quotes_runtime ($new_setting) {}

/**
 * magic_quotes_runtime の現在アクティブな設定をセットする
 * @link http://www.php.net/manual/ja/function.set-magic-quotes-runtime.php
 * @param new_setting bool <p>
 * FALSE はオフ、TRUE はオンを表します。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function set_magic_quotes_runtime ($new_setting) {}

/**
 * magic_quotes_gpc の現在の設定を得る
 * @link http://www.php.net/manual/ja/function.get-magic-quotes-gpc.php
 * @return bool magic_quotes_gpc がオフの場合に 0、そうでない場合に 1 を返します。
 * PHP 5.4.0 以降は、常に FALSE を返します。
 */
function get_magic_quotes_gpc () {}

/**
 * magic_quotes_runtime の現在アクティブな設定値を取得する
 * @link http://www.php.net/manual/ja/function.get-magic-quotes-runtime.php
 * @return bool magic_quotes_runtime がオフの場合に 0、そうでない場合に 1 を返します。
 * PHP 5.4.0 以降は、常に FALSE を返します。
 */
function get_magic_quotes_runtime () {}

/**
 * GET/POST/Cookie 変数をグローバルスコープにインポートする
 * @link http://www.php.net/manual/ja/function.import-request-variables.php
 * @param types string <p>
 * types パラメータを使用すると、インポートする
 * リクエスト変数の種類を指定可能です。文字 'G'、'P'、'C' がそれぞれ
 * GET、POST、Cookie を表します。これらは大文字小文字を区別しないため、
 * 'g'、'p'、'c' の組み合せも使用することが可能です。
 * POST には、アップロードされたファイルに関する情報も含まれます。
 * </p>
 * <p>
 * 文字の順番には注意してください。
 * "GP" とすると、POST 変数は同名の GET
 * 変数を上書きします。GPC 以外の文字は無視されます。
 * </p>
 * @param prefix string[optional] <p>
 * 変数名の接頭辞として使用され、
 * グローバルスコープにインポートされる全ての変数名の前に付加されます。
 * このため、"userid" という名前の GET 値があり、
 * 接頭辞 "pref_" を指定した場合、
 * $pref_userid という名前のグローバル変数が作成されます。
 * </p>
 * <p>
 * prefix パラメータはオプションですが、
 * 接頭辞を指定しないか接頭辞として空の文字列を指定した場合、
 * E_NOTICE
 * レベルのエラーが発生します。
 * これは、セキュリティ上の問題を発生する可能性があります。
 * NOTICE レベルのエラーは、デフォルトの
 * error reporting
 * レベルでは表示されません。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function import_request_variables ($types, $prefix = null) {}

/**
 * エラーメッセージを送信する
 * @link http://www.php.net/manual/ja/function.error-log.php
 * @param message string <p>
 * ログに記録されるエラーメッセージ。
 * </p>
 * @param message_type int[optional] <p>
 * メッセージをどこに送るのかを指定します。以下の中から指定できます。
 * </p>
 * <p>
 * <table>
 * error_log ログタイプ
 * <tr valign="top">
 * <td>0</td>
 * <td>
 * message は、オペレーティング・システム
 * のシステムログのメカニズムまたはファイルのいずれかを使って
 * PHP のシステム・ロガーに送られます。どちらが使われるかは、
 * 設定ディレクティブ error_log 
 * の内容により決定されます。これはデフォルトのオプションです。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>1</td>
 * <td>
 * message は、destination
 * パラメータで指定されたアドレスに、電子メール
 * により送られます。このメッセージタイプの場合にのみ、
 * 4 番目のパラメータである extra_headers
 * が使われます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>2</td>
 * <td>
 * このオプションは存在しません。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>3</td>
 * <td>
 * message は destination
 * で指定されたファイルに追加されます。
 * 明示的に指定しない限り、message の
 * 最後には改行文字は追加されません。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>4</td>
 * <td>
 * message は、直接 SAPI
 * のログ出力ハンドラに送信されます。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @param destination string[optional] <p>
 * メッセージの送信先。その設定は、上で説明している
 * message_type パラメータの値によります。
 * </p>
 * @param extra_headers string[optional] <p>
 * 追加のヘッダ。message_type パラメータが
 * 1 に設定される場合に利用されます。
 * このメッセージタイプは、mail と同様に
 * 内部関数を利用します。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function error_log ($message, $message_type = null, $destination = null, $extra_headers = null) {}

/**
 * 最後に発生したエラーを取得する
 * @link http://www.php.net/manual/ja/function.error-get-last.php
 * @return array 最後に発生したエラーについての情報を連想配列で返します。連想配列のキーは
 * "type"、"message"、"file" および "line" となります。
 * PHP の内部関数で発生したエラーの場合は、
 * "message" の先頭に関数名が含まれています。
 * エラーが発生していない場合は NULL を返します。
 */
function error_get_last () {}

/**
 * 最初の引数で指定したコールバック関数をコールする
 * @link http://www.php.net/manual/ja/function.call-user-func.php
 * @param callback callable <p>
 * コールする callable。
 * </p>
 * @param parameter mixed[optional] <p>
 * コールバック関数に渡す、ゼロ個以上のパラメータ。
 * </p>
 * <p>
 * call_user_func のパラメータは
 * 参照渡しではないことに注意しましょう。
 * call_user_func の例と参照
 * ]]>
 * 上の例の出力は以下となります。</p>
 * </p>
 * @param _ mixed[optional] 
 * @return mixed コールバック関数の結果、あるいはエラー時に FALSE を返します。
 */
function call_user_func ($callback, $parameter = null, $_ = null) {}

/**
 * パラメータの配列を指定してコールバック関数をコールする
 * @link http://www.php.net/manual/ja/function.call-user-func-array.php
 * @param callback callable <p>
 * コールするcallable。
 * </p>
 * @param param_arr array <p>
 * コールバック関数に渡すパラメータを指定する配列。
 * </p>
 * @return mixed コールバック関数の結果、あるいはエラー時に FALSE を返します。
 */
function call_user_func_array ($callback, array $param_arr) {}

/**
 * 指定したオブジェクトのユーザーメソッドをコールする [古い関数]
 * @link http://www.php.net/manual/ja/function.call-user-method.php
 * @param method_name string <p>
 * コールするメソッド名。
 * </p>
 * @param obj object <p>
 * コールする method_name
 * があるオブジェクト。
 * </p>
 * @param parameter mixed[optional] 
 * @param _ mixed[optional] 
 * @return mixed 
 */
function call_user_method ($method_name, &$obj, $parameter = null, $_ = null) {}

/**
 * パラメータの配列を指定してユーザーメソッドをコールする [古い関数]
 * @link http://www.php.net/manual/ja/function.call-user-method-array.php
 * @param method_name string <p>
 * コールするメソッド名。
 * </p>
 * @param obj object <p>
 * コールする method_name
 * があるオブジェクト。
 * </p>
 * @param params array <p>
 * パラメータの配列。
 * </p>
 * @return mixed 
 */
function call_user_method_array ($method_name, &$obj, array $params) {}

/**
 * 静的メソッドをコールする
 * @link http://www.php.net/manual/ja/function.forward-static-call.php
 * @param function callable <p>
 * コールしたい関数あるいはメソッド。このパラメータは、
 * クラス名とメソッド名を指定した配列あるいは関数名を指定した文字列となります。
 * </p>
 * @param parameter mixed[optional] <p>
 * 関数に渡したいパラメータ。
 * </p>
 * @param _ mixed[optional] 
 * @return mixed 関数の結果、あるいはエラー時に FALSE を返します。
 */
function forward_static_call ($function, $parameter = null, $_ = null) {}

/**
 * 静的メソッドをコールし、引数を配列で渡す
 * @link http://www.php.net/manual/ja/function.forward-static-call-array.php
 * @param function callable <p>
 * コールしたい関数あるいはメソッド。このパラメータは、
 * クラス名とメソッド名を指定した配列あるいは関数名を指定した文字列となります。
 * </p>
 * @param parameters array 
 * @return mixed 関数の結果、あるいはエラー時に FALSE を返します。
 */
function forward_static_call_array ($function, array $parameters) {}

/**
 * 値の保存可能な表現を生成する
 * @link http://www.php.net/manual/ja/function.serialize.php
 * @param value mixed <p>
 * シリアル化する値。
 * serialize は、resource
 * 以外の全ての型を処理します。自分自身への参照を含む配列を
 * serialize することも可能です。
 * シリアル化した配列/オブジェクト内の
 * 循環参照も保存されます。その他の参照は失われます。
 * </p>
 * <p>
 * PHP は、シリアル化の前にまずメンバ関数 __sleep()
 * のコールを試みます。ここで、シリアル化の前のオブジェクトの後始末処理
 * などを行います。同様に、unserialize で
 * オブジェクトを復元した際にはメンバ関数
 * __wakeup() がコールされます。
 * </p>
 * <p>
 * オブジェクトの private メンバは、メンバ名の前にクラス名がつきます。
 * また protected メンバはメンバ名の前に '*' がつきます。
 * 前に付加されるこれらの値の前後には null バイトがついています。
 * </p>
 * @return string value
 * の保存可能なバイトストリーム表現を含む文字列を返します。
 * </p>
 * <p>
 * これはバイナリ文字列であり、null バイトを含む可能性もあることに注意しましょう。
 * 保存したり利用したりするときも、null バイトが含まれることを想定しておかないといけません。
 * たとえば、serialize の出力をデータベースに格納するときには、
 * 通常は CHAR 型や TEXT 型ではなく BLOB 型を使わないといけません。
 */
function serialize ($value) {}

/**
 * 保存用表現から PHP の値を生成する
 * @link http://www.php.net/manual/ja/function.unserialize.php
 * @param str string <p>
 * シリアル化された文字列。
 * </p>
 * <p>
 * もしアンシリアライズする変数がオブジェクトの場合、
 * オブジェクトが無事再作成された後、PHP は自動的にメンバ関数
 * __wakeup()
 * (存在していれば) をコールしようとします。
 * </p>
 * <p>
 * unserialize_callback_func ディレクティブ
 * <p>
 * コールバック関数を設定することが可能です。(不完全な
 * object "__PHP_Incomplete_Class"を得ることを防ぐため)
 * コールバック関数は、非シリアル化する際に未定義のクラスをインスタ
 * ンス化する必要がある場合にコールされます。
 * 'unserialize_callback_func'を定義するためには、
 * php.ini, ini_set, .htaccess を使用し
 * てください。未定義のクラスをインスタンス化する度に、コールバック関
 * 数がコールされます。この機能を無効とするには、
 * 単純にこの設定を空にしてください。
 * </p>
 * </p>
 * @return mixed 変換された値が返されます。その値は、
 * boolean, integer, float,
 * string, array, object
 * のいずれかとなります。
 * </p>
 * <p>
 * 渡された文字列が復元できなかった場合、FALSE を返して
 * E_NOTICE を発生します。
 */
function unserialize ($str) {}

/**
 * 変数に関する情報をダンプする
 * @link http://www.php.net/manual/ja/function.var-dump.php
 * @param expression mixed <p>
 * ダンプしたい変数。
 * </p>
 * @param _ mixed[optional] 
 * @return void 値を返しません。
 */
function var_dump ($expression, $_ = null) {}

/**
 * 変数の文字列表現を出力または返す
 * @link http://www.php.net/manual/ja/function.var-export.php
 * @param expression mixed <p>
 * エクスポートしたい変数
 * </p>
 * @param return bool[optional] <p>
 * 使用されかつ TRUE に設定された場合、var_export
 * は変数表現を出力する代わりに返します。
 * </p>
 * @return mixed return パラメータが使用され TRUE と評価される場合、
 * 変数表現を返します。そうでない場合、この関数は NULL を返します。
 */
function var_export ($expression, $return = null) {}

/**
 * 内部的な Zend の値を表す文字列をダンプする
 * @link http://www.php.net/manual/ja/function.debug-zval-dump.php
 * @param variable mixed <p>
 * 評価される変数
 * </p>
 * @return void 値を返しません。
 */
function debug_zval_dump ($variable) {}

/**
 * 指定した変数に関する情報を解りやすく出力する
 * @link http://www.php.net/manual/ja/function.print-r.php
 * @param expression mixed <p>
 * 表示したい式。
 * </p>
 * @param return bool[optional] <p>
 * print_r の結果を取得したい場合には
 * return 引数を使います。
 * この引数が TRUE の場合には、
 * print_r は情報を表示するかわりに情報を返します。
 * </p>
 * @return mixed string、integer,
 * float を指定した場合はその値が出力されます。
 * array を指定した場合、キーと要素を表す形式で値が
 * 表示されます。object に関しても同様の表示形式となります。
 * </p>
 * <p>
 * return パラメータが TRUE の場合は、
 * この関数は string を返します。それ以外の場合の返り値は TRUE です。
 */
function print_r ($expression, $return = null) {}

/**
 * PHP に割り当てられたメモリの量を返す
 * @link http://www.php.net/manual/ja/function.memory-get-usage.php
 * @param real_usage bool[optional] <p>
 * これを TRUE に設定すると、システムが割り当てた実際のメモリの大きさを取得します。
 * 省略したり FALSE を設定したりすると、
 * emalloc() が使用するメモリのみを報告します。
 * </p>
 * @return int メモリの量をバイト単位で返します。
 */
function memory_get_usage ($real_usage = null) {}

/**
 * PHP によって割り当てられたメモリの最大値を返す
 * @link http://www.php.net/manual/ja/function.memory-get-peak-usage.php
 * @param real_usage bool[optional] <p>
 * これを TRUE に設定すると、システムが割り当てた実際のメモリの大きさを取得します。
 * 省略したり FALSE を設定したりすると、
 * emalloc() が使用するメモリのみを報告します。
 * </p>
 * @return int メモリの最大値をバイト数で返します。
 */
function memory_get_peak_usage ($real_usage = null) {}

/**
 * シャットダウン時に実行する関数を登録する
 * @link http://www.php.net/manual/ja/function.register-shutdown-function.php
 * @param callback callable <p>
 * 登録するコールバック。
 * </p>
 * <p>
 * シャットダウン時のコールバックは、リクエストの一部として実行されます。
 * したがって、コールバック関数からも出力を送信できるし、出力バッファにもアクセスできます。
 * </p>
 * @param parameter mixed[optional] <p>
 * シャットダウン関数にパラメータを渡すには、ここで追加のパラメータを渡します。
 * </p>
 * @param _ mixed[optional] 
 * @return void 値を返しません。
 */
function register_shutdown_function ($callback, $parameter = null, $_ = null) {}

/**
 * 各 tick で実行する関数を登録する
 * @link http://www.php.net/manual/ja/function.register-tick-function.php
 * @param function callable <p>
 * 関数名を表す文字列、あるいはオブジェクトとメソッドを指定した配列。
 * </p>
 * @param arg mixed[optional] <p>
 * </p>
 * @param _ mixed[optional] 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function register_tick_function ($function, $arg = null, $_ = null) {}

/**
 * 各 tick の実行用の関数の登録を解除する
 * @link http://www.php.net/manual/ja/function.unregister-tick-function.php
 * @param function_name string <p>
 * 関数名を表す文字列。
 * </p>
 * @return void 値を返しません。
 */
function unregister_tick_function ($function_name) {}

/**
 * ファイルの構文ハイライト表示
 * @link http://www.php.net/manual/ja/function.highlight-file.php
 * @param filename string <p>
 * ハイライト表示する PHP ファイルへのパス。
 * </p>
 * @param return bool[optional] <p>
 * このパラメータを TRUE にすると、この関数はハイライトされたコードを返します。
 * </p>
 * @return mixed return が TRUE の場合は、
 * ハイライトされたコードを文字列として返し、表示しません。
 * それ以外の場合は、成功した場合に TRUE、
 * 失敗した場合に FALSE を返します。
 */
function highlight_file ($filename, $return = null) {}

/**
 * <function>highlight_file</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.show-source.php
 * @param file_name
 * @param return[optional]
 */
function show_source ($file_name, $return) {}

/**
 * 文字列の構文ハイライト表示
 * @link http://www.php.net/manual/ja/function.highlight-string.php
 * @param str string <p>
 * ハイライト表示する PHP コード。開始タグを含む必要があります。
 * </p>
 * @param return bool[optional] <p>
 * このパラメータを TRUE にすると、この関数はハイライトされたコードを返します。
 * </p>
 * @return mixed return が TRUE の場合は、
 * ハイライトされたコードを文字列として返し、表示しません。
 * それ以外の場合は、成功した場合に TRUE、
 * 失敗した場合に FALSE を返します。
 */
function highlight_string ($str, $return = null) {}

/**
 * コメントと空白文字を取り除いたソースを返す
 * @link http://www.php.net/manual/ja/function.php-strip-whitespace.php
 * @param filename string <p>
 * PHP ファイルへのパス。
 * </p>
 * @return string 成功した場合に処理済みのソースコード、失敗した場合に空の文字列を返します。
 * </p>
 * <p>
 * PHP 5.0.1 以降、この関数は記述どおりに動作するようになりました。
 * それまでは単に空の文字列を返すだけでした。このバグについての詳細な情報は、
 * バグ番号 29606 を参照ください。
 */
function php_strip_whitespace ($filename) {}

/**
 * 設定オプションの値を得る
 * @link http://www.php.net/manual/ja/function.ini-get.php
 * @param varname string <p>
 * 設定オプションの名前。
 * </p>
 * @return string 成功した場合に設定オプションの値、
 * null 値の場合は空の文字列を返します。
 * その設定オプションが存在しない場合は FALSE を返します。
 */
function ini_get ($varname) {}

/**
 * すべての設定オプションを得る
 * @link http://www.php.net/manual/ja/function.ini-get-all.php
 * @param extension string[optional] <p>
 * オプションで指定する拡張モジュール名。指定した場合は、
 * その拡張モジュールに関するオプションのみを返します。
 * </p>
 * @param details bool[optional] <p>
 * 詳細な設定を取得するか、あるいは各設定の現在の値のみを取得するか。
 * デフォルトは TRUE (詳細情報を取得する) です。
 * </p>
 * @return array ディレクティブ名をキーとする連想配列を返します。
 * </p>
 * <p>
 * details が TRUE (デフォルト) の場合、
 * 配列の値は、
 * global_value (php.iniで設定されている)、
 * local_value (おそらくini_setまたは
 * .htaccessでセットされている)、access (アクセスレベル)
 * を含む配列となります。
 * </p>
 * <p>
 * details が FALSE の場合、
 * 配列の値はそのオプションの現在の値となります。
 * </p>
 * <p>
 * アクセスレベルの意味についてはマニュアルを参照ください。
 * </p>
 * <p>
 * ひとつのディレクティブに複数のアクセスレベルを設定することができます。
 * access がビットマスク値となっているのはそのためです。
 */
function ini_get_all ($extension = null, $details = null) {}

/**
 * 設定オプションの値を設定する
 * @link http://www.php.net/manual/ja/function.ini-set.php
 * @param varname string <p>
 * </p>
 * <p>
 * 全てのオプションが ini_set を使用して変更することが
 * 可能なわけではありません。有効なオプションの完全な一覧は
 * 付録 を参照ください。
 * </p>
 * @param newvalue string <p>
 * オプションの新しい値。
 * </p>
 * @return string 成功した場合に元の値、失敗した場合に FALSE を返します。
 */
function ini_set ($varname, $newvalue) {}

/**
 * <function>ini_set</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ini-alter.php
 * @param varname
 * @param newvalue
 */
function ini_alter ($varname, $newvalue) {}

/**
 * 設定オプションの値を元に戻す
 * @link http://www.php.net/manual/ja/function.ini-restore.php
 * @param varname string <p>
 * 設定オプションの名前。
 * </p>
 * @return void 値を返しません。
 */
function ini_restore ($varname) {}

/**
 * 現在の include_path 設定オプションを取得する
 * @link http://www.php.net/manual/ja/function.get-include-path.php
 * @return string パスを表す文字列を返します。
 */
function get_include_path () {}

/**
 * include_path 設定オプションをセットする
 * @link http://www.php.net/manual/ja/function.set-include-path.php
 * @param new_include_path string <p>
 * include_path
 * の新しい値。
 * </p>
 * @return string 成功した場合に元の include_path
 * の値、失敗した場合に FALSE を返します。
 */
function set_include_path ($new_include_path) {}

/**
 * include_path 設定オプションの値を元に戻す
 * @link http://www.php.net/manual/ja/function.restore-include-path.php
 * @return void 値を返しません。
 */
function restore_include_path () {}

/**
 * クッキーを送信する
 * @link http://www.php.net/manual/ja/function.setcookie.php
 * @param name string <p>
 * クッキーの名前。
 * </p>
 * @param value string[optional] <p>
 * クッキーの値。この値はクライアントのコンピュータに保存されますので、
 * 重要な情報は格納しないでください。
 * name が 'cookiename' だとすると、
 * その値は $_COOKIE['cookiename'] で取得することができます。
 * </p>
 * @param expire int[optional] <p>
 * クッキーの有効期限。これは Unix タイムスタンプなので
 * Epoch（1970 年 1 月 1 日）からの経過秒数となります。
 * time または
 * mktime 関数により
 * 返された現在のUNIX標準時に、期限としたい必要な秒数を加算したものを
 * 利用することができるでしょう。
 * time()+60*60*24*30
 * はクッキーの有効期限を 30 日後にセットします。
 * 0 を設定したり省略したりした場合は、クッキーはセッションの最後
 * (つまりブラウザを閉じるとき) が有効期限となります。
 * </p>
 * <p>
 * <p>
 * expire パラメータには、Wdy, DD-Mon-YYYY
 * HH:MM:SS GMT といった形式ではなく Unix
 * タイムスタンプを渡していることにお気づきでしょうか。
 * これは、PHP の内部で自動的に変換を行っているからです。
 * </p>
 * </p>
 * @param path string[optional] <p>
 * サーバー上での、クッキーを有効としたいパス
 * '/' をセットすると、クッキーは
 * domain 配下の全てで有効となります。
 * '/foo/' をセットすると、クッキーは
 * /foo/ ディレクトリとそのサブディレクトリ配下
 * (例えば /foo/bar/) で有効となります。
 * デフォルト値は、クッキーがセットされたときのカレントディレクトリです。
 * </p>
 * @param domain string[optional] <p>
 * クッキーが有効なドメイン。ドメインを
 * 'www.example.com' に設定すると、
 * www サブドメインおよびその上位のサブドメインでクッキーが使えるようになります。
 * より低レベルのドメイン、たとえば
 * 'example.com' でクッキーを有効にすると、その上位にある
 * 'www.example.com' などのサブドメインでもクッキーが有効になります。
 * 古いブラウザの中には、非推奨になった
 * RFC 2109 を実装しているものが未だに残っているかもしれません。
 * そのようなブラウザでは、すべてのサブドメインにマッチさせるためには先頭に
 * . が必要となります。
 * </p>
 * @param secure bool[optional] <p>
 * クライアントからのセキュアな HTTPS 接続の場合にのみクッキーが送信されるようにします。
 * TRUE を設定すると、セキュアな接続が存在する場合にのみクッキーを設定します。
 * サーバー側では、このようにセキュアな接続の場合にのみクッキーを送信するという処理は
 * プログラマの責任で行うことになります
 * (たとえば $_SERVER["HTTPS"] の内容を使用します)。
 * </p>
 * @param httponly bool[optional] <p>
 * TRUE を設定すると、HTTP を通してのみクッキーにアクセスできるようになります。
 * つまり、JavaScript のようなスクリプト言語からはアクセスできなくなるということです。
 * この設定を使用すると、XSS 攻撃によって ID を盗まれる危険性を減らせる
 * (が、すべてのブラウザがこの設定をサポートしているというわけではありません)
 * と言われていますが、これはしばしば議論の対象となります。
 * PHP 5.2.0 で追加されました。
 * TRUE あるいは FALSE で指定します。
 * </p>
 * @return bool もしもこの関数をコールする前に何らかの出力がある場合には、
 * setcookie は失敗し FALSE を返します。
 * setcookie が正常に実行されると、TRUE を返します。
 * この関数では、ユーザーがクッキーを受け入れたかどうかを判断することはできません。
 */
function setcookie ($name, $value = null, $expire = null, $path = null, $domain = null, $secure = null, $httponly = null) {}

/**
 * 値を URL エンコードせずにクッキーを送信する
 * @link http://www.php.net/manual/ja/function.setrawcookie.php
 * @param name string 
 * @param value string[optional] 
 * @param expire int[optional] 
 * @param path string[optional] 
 * @param domain string[optional] 
 * @param secure bool[optional] 
 * @param httponly bool[optional] 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function setrawcookie ($name, $value = null, $expire = null, $path = null, $domain = null, $secure = null, $httponly = null) {}

/**
 * 生の HTTP ヘッダを送信する
 * @link http://www.php.net/manual/ja/function.header.php
 * @param string string <p>
 * ヘッダ文字列。
 * </p>
 * <p>
 * 特殊な header コールが 2 種類あります。最初のものは、
 * 文字列 "HTTP/"
 * から始まる全てのヘッダ (大文字・小文字は区別されません) です。
 * このヘッダは、送信する HTTP ステータスコードを示すために使用されます。
 * 例えば、存在しないファイルへのリクエストを処理するためにある PHP
 * スクリプトを使用するよう (ErrorDocument
 * ディレクティブにより) Apache を設定する場合、
 * そのスクリプトが正しいステータスコードを返すようにする必要があります。
 * </p>
 * <p>
 * ]]>
 * </p>
 * <p>
 * FastCGI の場合は、404 のレスポンスは次の形式でなければなりません。
 * ]]>
 * </p>
 * <p>
 * 2 番目の特別なヘッダは、"Location:"
 * ヘッダです。このヘッダがブラウザに返されるだけではなく、
 * ブラウザに REDIRECT (302) ステータスコードを返します
 * (201 や 3xx
 * ステータスコードが既に送信されていない場合にのみ)。
 * </p>
 * <p>
 * ]]>
 * </p>
 * @param replace bool[optional] <p>
 * オプションのパラメータ replace は、ヘッダが
 * 前に送信された類似のヘッダを置換するか、または、同じ形式の二番目の
 * ヘッダを追加するかどうかを指定します。デフォルトでは、この関数は
 * 置換を行ないますが、二番目の引数に FALSE を指定すると、同じ型の
 * 複数のヘッダを強制的に生成します。例えば、
 * </p>
 * <p>
 * ]]>
 * </p>
 * @param http_response_code int[optional] <p>
 * HTTP レスポンスコードを強制的に指定の値にします。このパラメータが意味をなすのは
 * string が空文字列でないときだけであることに注意しましょう。
 * </p>
 * @return void 値を返しません。
 */
function header ($string, $replace = null, $http_response_code = null) {}

/**
 * 以前に設定したHTTPヘッダを削除する
 * @link http://www.php.net/manual/ja/function.header-remove.php
 * @param name string[optional] <p>
 * 削除するヘッダの名前
 * </p>
 * このパラメータは大文字小文字を区別しません
 * @return void 値を返しません。
 */
function header_remove ($name = null) {}

/**
 * ヘッダが既に送信されているかどうかを調べる
 * @link http://www.php.net/manual/ja/function.headers-sent.php
 * @param file string[optional] <p>
 * オプション引数の file と
 * line がセットされている場合、
 * PHP のソースファイル名と出力が開始された行番号が、それぞれ
 * file と line
 * に格納されます。
 * </p>
 * @param line int[optional] <p>
 * 出力を開始した行番号。
 * </p>
 * @return bool headers_sent
 * は、HTTP ヘッダがまだ送信されていない場合に FALSE、
 * そうでないでない場合に TRUE を返します。
 */
function headers_sent (&$file = null, &$line = null) {}

/**
 * 送信した (もしくは送信される予定の) レスポンスヘッダの一覧を返す
 * @link http://www.php.net/manual/ja/function.headers-list.php
 * @return array ヘッダを、数値添字の配列で返します。
 */
function headers_list () {}

/**
 * クライアントとの接続が切断されているかどうかを調べる
 * @link http://www.php.net/manual/ja/function.connection-aborted.php
 * @return int クライアントとの接続が切断されている場合に 1、それ以外の場合に 0 を返します。
 */
function connection_aborted () {}

/**
 * 接続ステータスのビットフィールドを返す
 * @link http://www.php.net/manual/ja/function.connection-status.php
 * @return int 接続ステータスのビットフィールドを返します。これを定数
 * CONNECTION_XXX と比較することで、接続の状態を判断できます。
 */
function connection_status () {}

/**
 * クライアントの接続が切断された際にスクリプトの実行を終了するかどうかを設定する
 * @link http://www.php.net/manual/ja/function.ignore-user-abort.php
 * @param value string[optional] <p>
 * 指定すると、この関数は ini 項目 ignore_user_abort
 * に value の値を設定します。
 * 省略した場合、この関数は前の設定をそのまま返し、何も変更しません。
 * </p>
 * @return int 以前の設定を表す integer 値を返します。
 */
function ignore_user_abort ($value = null) {}

/**
 * 設定ファイルをパースする
 * @link http://www.php.net/manual/ja/function.parse-ini-file.php
 * @param filename string <p>
 * パースしたい ini ファイルのファイル名。
 * </p>
 * @param process_sections bool[optional] <p>
 * process_sections パラメータに TRUE
 * を設定すると、セクション名と設定が含まれた多次元の配列を得ることができます。
 * デフォルトでは、process_sections は FALSE です。
 * </p>
 * @param scanner_mode int[optional] <p>
 * INI_SCANNER_NORMAL (デフォルト) あるいは
 * INI_SCANNER_RAW。INI_SCANNER_RAW
 * を指定すると、オプションの値はパースされません。
 * </p>
 * @return array 成功した場合に設定を連想配列形式で返します。
 * 失敗した場合に FALSE を返します。
 */
function parse_ini_file ($filename, $process_sections = null, $scanner_mode = null) {}

/**
 * 設定文字列をパースする
 * @link http://www.php.net/manual/ja/function.parse-ini-string.php
 * @param ini string <p>
 * パースしたい ini ファイルの内容。
 * </p>
 * @param process_sections bool[optional] <p>
 * process_sections
 * を TRUE に設定すると、セクション名と設定を含む多次元配列を返します。
 * process_sections のデフォルトは FALSE です。
 * </p>
 * @param scanner_mode int[optional] <p>
 * INI_SCANNER_NORMAL (デフォルト) あるいは
 * INI_SCANNER_RAW。INI_SCANNER_RAW
 * を指定すると、オプションの値はパースされません。
 * </p>
 * @return array 成功した場合に設定を連想配列形式で返します。
 * 失敗した場合に FALSE を返します。
 */
function parse_ini_string ($ini, $process_sections = null, $scanner_mode = null) {}

/**
 * HTTP POST でアップロードされたファイルかどうかを調べる
 * @link http://www.php.net/manual/ja/function.is-uploaded-file.php
 * @param filename string <p>
 * 調べたいファイル名。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function is_uploaded_file ($filename) {}

/**
 * アップロードされたファイルを新しい位置に移動する
 * @link http://www.php.net/manual/ja/function.move-uploaded-file.php
 * @param filename string <p>
 * アップロードしたファイルのファイル名。
 * </p>
 * @param destination string <p>
 * ファイルの移動先。
 * </p>
 * @return bool 成功した場合に TRUE を返します。
 * </p>
 * <p>
 * filename が有効なアップロードファイルでない場合、
 * 処理は行われず、move_uploaded_file は
 * FALSE を返します。
 * </p>
 * <p>
 * filename が有効なアップロードファイルであるが、
 * 何らかの理由により、移動できない場合、処理は行われず、
 * move_uploaded_file は
 * FALSE を返します。加えて、警告が出力されます。
 */
function move_uploaded_file ($filename, $destination) {}

/**
 * 指定した IP アドレスに対応するインターネットホスト名を取得する
 * @link http://www.php.net/manual/ja/function.gethostbyaddr.php
 * @param ip_address string <p>
 * ホストの IP アドレス。
 * </p>
 * @return string 成功した場合はホスト名を返します。
 * 失敗した場合は、そのままの形の
 * ip_address を文字列で返します。
 * 入力が壊れている場合は FALSE を返します。
 */
function gethostbyaddr ($ip_address) {}

/**
 * インターネットホスト名に対応するIPv4アドレスを取得する
 * @link http://www.php.net/manual/ja/function.gethostbyname.php
 * @param hostname string <p>
 * ホスト名。
 * </p>
 * @return string IPv4 アドレスを返します。失敗した場合は、そのままの形の
 * hostname を文字列で返します。
 */
function gethostbyname ($hostname) {}

/**
 * 指定したインターネットホスト名に対応するIPv4アドレスのリストを取得する
 * @link http://www.php.net/manual/ja/function.gethostbynamel.php
 * @param hostname string <p>
 * ホスト名。
 * </p>
 * @return array IPv4 アドレスの配列を返します。
 * もし hostname が解決できなかった場合は
 * FALSE を返します。
 */
function gethostbynamel ($hostname) {}

/**
 * ホスト名を取得する
 * @link http://www.php.net/manual/ja/function.gethostname.php
 * @return string 成功時にはホスト名を示す文字列。失敗時には FALSE を返します
 */
function gethostname () {}

/**
 * <function>checkdnsrr</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.dns-check-record.php
 * @param host
 * @param type[optional]
 */
function dns_check_record ($host, $type) {}

/**
 * 指定したインターネットホスト名もしくは IP アドレスに対応する DNS レコードを検索する
 * @link http://www.php.net/manual/ja/function.checkdnsrr.php
 * @param host string <p>
 * hostは、ドットで 4 つに分けられた形式の
 * IP アドレスか、あるいはホスト名です。
 * </p>
 * @param type string[optional] <p>
 * typeは、A, MX, NS, SOA, PTR, CNAME, AAAA, A6,
 * SRV, NAPTR, ANY のどれか一つです。
 * </p>
 * @return bool レコードが見つかった場合に TRUE、
 * 何も見つからないかエラーが発生した場合に FALSE を返します。
 */
function checkdnsrr ($host, $type = null) {}

/**
 * <function>getmxrr</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.dns-get-mx.php
 * @param hostname
 * @param mxhosts
 * @param weight[optional]
 */
function dns_get_mx ($hostname, &$mxhosts, &$weight) {}

/**
 * 指定したインターネットホスト名に対応する MX レコードを取得する
 * @link http://www.php.net/manual/ja/function.getmxrr.php
 * @param hostname string <p>
 * インターネットホスト名。
 * </p>
 * @param mxhosts array <p>
 * 見つかった MX レコードのリストが、配列
 * mxhosts に格納されます。
 * </p>
 * @param weight array[optional] <p>
 * 配列 weight を指定すると、
 * そこに重み情報が格納されます。
 * </p>
 * @return bool 何かレコードが見つかった場合に TRUE、
 * 何も見つからないかエラーが発生した場合に FALSE を返します。
 */
function getmxrr ($hostname, array &$mxhosts, array &$weight = null) {}

/**
 * ホスト名に関連する DNS リソースレコードを取得する
 * @link http://www.php.net/manual/ja/function.dns-get-record.php
 * @param hostname string <p>
 * hostname は、正しい DNS ホスト名、すなわち
 * "www.example.com" のようなものでなければなりません。
 * in-addr.arpa 形式の表記を用いた逆引き検索は可能ですが、
 * たいていは gethostbyaddr を用いるほうが適当です。
 * </p>
 * <p>
 * DNS の標準規格により、メールアドレスは user.host 形式で渡されます
 * （たとえば、hostmaster.example.com が hostmaster@example.com
 * の代わりとなります）。
 * この値をしっかり確認し、mail のような関数で
 * 利用する前には必要なら変更を加えることを忘れないようにしてください。 
 * </p>
 * @param type int[optional] <p>
 * デフォルトでは、dns_get_record は
 * hostname に関連するすべてのリソースレコードを検索します。
 * これを制限するには、オプションの
 * type パラメータを指定してください。
 * type は以下のうちのいずれかです。
 * DNS_A, DNS_CNAME,
 * DNS_HINFO, DNS_MX,
 * DNS_NS, DNS_PTR,
 * DNS_SOA, DNS_TXT,
 * DNS_AAAA, DNS_SRV,
 * DNS_NAPTR, DNS_A6,
 * DNS_ALL or DNS_ANY。
 * </p>
 * <p>
 * プラットフォーム依存の libresolv のおかしな挙動のせいで、
 * DNS_ANY が常にすべてのレコードを返すとは
 * 限りません。速度は遅くなりますが、DNS_ALL
 * のほうがより確実にすべてのレコードを取得できます。
 * </p>
 * @param authns array[optional] <p>
 * 参照で渡し、
 * Authoritative Name Servers
 * のリソースレコードが格納されます。
 * </p>
 * @param addtl array[optional] <p>
 * 参照で渡し、
 * Additional Records
 * が格納されます。
 * </p>
 * @return array この関数は、連想配列を要素にもつ配列を返します。
 * 失敗した場合に FALSE を返します。
 * それぞれの連想配列には
 * 少なくとも 以下のキーが含まれています:
 * <table>
 * 基本 DNS 属性
 * <tr valign="top">
 * <td>属性</td>
 * <td>意味</td>
 * </tr>
 * <tr valign="top">
 * <td>host</td>
 * <td>
 * これ以降の関連するデータが参照する DNS 名。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>class</td>
 * <td>
 * dns_get_record は
 * Internet クラスのレコードのみを返すので、このパラメータは常に
 * IN を返します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>type</td>
 * <td>
 * レコード型を表す文字列。type の値に応じて、
 * 結果の配列には追加の属性が含まれます。以下の表を参照ください。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ttl</td>
 * <td>
 * このレコードの"有効期限 (Time To Live)"。レコードの本来の ttl と一致するとは
 * 限りません。むしろ、
 * ネームサーバーへのクエリにかかった時間をそこから引いたものに一致します。
 * </td>
 * </tr>
 * </table>
 * </p>
 * <p>
 * <table>
 * 'type' に応じて連想配列に追加される項目
 * <tr valign="top">
 * <td>レコード型</td>
 * <td>追加項目</td>
 * </tr>
 * <tr valign="top">
 * <td>A</td>
 * <td>
 * ip: ドット区切り 10 進数形式の IPv4 アドレス。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MX</td>
 * <td>
 * pri: メールエクスチェンジャの優先度。
 * 数字が小さいほど優先度が高い。
 * target: メールエクスチェンジャの FQDN 。
 * dns_get_mx も参照ください。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>CNAME</td>
 * <td>
 * target: レコードのエイリアスの対象となっている場所の FQDN 。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>NS</td>
 * <td>
 * target: このホスト名に対する権威をもっているネームサーバーの FQDN 。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>PTR</td>
 * <td>
 * target: レコードが指している、DNS 名前空間内の場所
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>TXT</td>
 * <td>
 * txt: このレコードに関連付けられている任意の文字列。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>HINFO</td>
 * <td>
 * cpu: このレコードが参照しているマシンの CPU を識別する IANA 番号。
 * os: このレコードが参照しているマシン上の OS を識別する IANA 番号。
 * これらの値の意味については、IANA の 
 * Operating System Names
 * を参照ください。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SOA</td>
 * <td>
 * mname: リソースレコードの元となるマシンの FQDN 。
 * rname: このドメインの管理責任者の Email アドレス。
 * serial: ドメインのシリアル番号。
 * refresh:
 * セカンダリネームサーバーがこのドメインのコピーを更新する際に参照するリフレッシュ間隔（秒単位）。
 * retry: リフレッシュが失敗した際に
 * 2 度目のリフレッシュを試みるまでの間隔（秒単位）
 * expire: セカンダリネームサーバーが、ゾーンデータの
 * リフレッシュに失敗した場合にコピーのデータを破棄せず持ち続ける期間
 * （秒単位）。
 * minimum-ttl: クライアントが、
 * 一度取得したデータを再リクエストすることなしに利用できる最小期間（秒単位）。
 * 個々のリソースレコードによって上書きが可能。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>AAAA</td>
 * <td>
 * ipv6: IPv6 アドレス。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>A6(PHP &gt;= 5.1.0)</td>
 * <td>
 * masklen: chain
 * で指定された対象から引き継ぐビット長。
 * ipv6: chain
 * とマージするためのこのレコードのアドレス。
 * chain: ipv6
 * データとマージするための親レコード。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SRV</td>
 * <td>
 * pri: (Priority) 値が小さいものが優先されます。
 * weight: 同じ優先順位の
 * targets からランダムに選択する際の重み。
 * target および port:
 * リクエストされたサービスが存在するホスト名とポート。
 * 詳細は RFC 2782 を参照ください。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>NAPTR</td>
 * <td>
 * order および pref: 上の
 * pri および weight と同じ。
 * flags, services, regex,
 * および replacement:
 * RFC 2915 で定義されるパラメータ。
 * </td>
 * </tr>
 * </table>
 */
function dns_get_record ($hostname, $type = null, array &$authns = null, array &$addtl = null) {}

/**
 * 変数の整数としての値を取得する
 * @link http://www.php.net/manual/ja/function.intval.php
 * @param var mixed <p>
 * 整数に変換するスカラー値
 * </p>
 * @param base int[optional] <p>
 * 変換のための基数
 * </p>
 * @return int 成功時は var の整数値、失敗時は 0。
 * 空の配列の場合は 0、空でない配列の場合は
 * 1 を返します。
 * </p>
 * <p>
 * 最大値はシステムに依存します。32 ビットシステムでは、
 * 最大の符号付き整数の範囲 -2147483648 ～ 2147483647 となります。
 * このため、そのようなシステムでは intval('1000000000000')
 * は 2147483647 を返します。
 * 64 ビットシステムにおける最大の符号付き整数は 9223372036854775807
 * となります。
 * </p>
 * <p>
 * 文字列の場合、文字列の最左の文字に依存しますが、ほとんどの場合で 0
 * を返します。
 * 整数への変換
 * の一般的なルールが適用されます。
 */
function intval ($var, $base = null) {}

/**
 * 変数の float 値を取得する
 * @link http://www.php.net/manual/ja/function.floatval.php
 * @param var mixed <p>
 * あらゆるスカラ型を指定できます。オブジェクトに
 * floatval を使用することはできません。
 * その場合は E_NOTICE レベルのエラーを発して 1 を返します。
 * </p>
 * @return float 指定した変数の float 値を返します。
 * 空の配列の場合は 0、空でない配列の場合は 1 を返します。
 * </p>
 * <p>
 * 文字列の場合、ほとんどは 0 を返しますが、先頭の文字が何であるかによってこれは変わります。
 * float 型へのキャスト
 * と同じルールに従います。
 */
function floatval ($var) {}

/**
 * <function>floatval</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.doubleval.php
 * @param var
 */
function doubleval ($var) {}

/**
 * 変数の文字列としての値を取得する
 * @link http://www.php.net/manual/ja/function.strval.php
 * @param var mixed <p>
 * 文字列に変換したい変数。
 * </p>
 * <p>
 * var には、任意のスカラー型を指定できます。
 * また、__toString()
 * メソッドを実装したオブジェクトを使うこともできます。
 * strval は配列に対して使うことはできず、
 * __toString()
 * メソッドを実装していないオブジェクトに対しても使うことはできません。
 * </p>
 * @return string var の文字列値を返します。
 */
function strval ($var) {}

/**
 * 変数の型を取得する
 * @link http://www.php.net/manual/ja/function.gettype.php
 * @param var mixed <p>
 * 型を調べたい変数。
 * </p>
 * @return string 返された文字列は、以下のいずれかの値を持ちます。
 * "boolean"
 * "integer"
 * "double" (歴史的な理由により、float
 * の場合には "double"が返されます。"float" とはなりません)
 * "string"
 * "array"
 * "object"
 * "resource"
 * "NULL"
 * "unknown type"
 */
function gettype ($var) {}

/**
 * 変数の型をセットする
 * @link http://www.php.net/manual/ja/function.settype.php
 * @param var mixed <p>
 * 変換する変数。
 * </p>
 * @param type string <p>
 * type の値は以下の命令のいずれかです。
 * "boolean" (または、PHP 4.2.0以降は"bool")
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function settype (&$var, $type) {}

/**
 * 変数が NULL かどうか調べる
 * @link http://www.php.net/manual/ja/function.is-null.php
 * @param var mixed <p>
 * 評価する変数。
 * </p>
 * @return bool var が null の場合に TRUE、
 * それ以外の場合に FALSE を返します。
 */
function is_null ($var) {}

/**
 * 変数がリソースかどうかを調べる
 * @link http://www.php.net/manual/ja/function.is-resource.php
 * @param var mixed <p>
 * 評価する変数。
 * </p>
 * @return bool var が resource の場合に TRUE、
 * それ以外の場合に FALSE を返します。
 */
function is_resource ($var) {}

/**
 * 変数が boolean であるかを調べる
 * @link http://www.php.net/manual/ja/function.is-bool.php
 * @param var mixed <p>
 * 評価する変数。
 * </p>
 * @return bool var が boolean である場合に
 * TRUE 、それ以外の場合に FALSE を返します。
 */
function is_bool ($var) {}

/**
 * <function>is_int</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.is-long.php
 * @param var
 */
function is_long ($var) {}

/**
 * 変数の型が float かどうか調べる
 * @link http://www.php.net/manual/ja/function.is-float.php
 * @param var mixed <p>
 * 評価する変数
 * </p>
 * @return bool もし var が float 型 の場合 TRUE、
 * そうでない場合は FALSE を返します。
 */
function is_float ($var) {}

/**
 * 変数が整数型かどうかを検査する
 * @link http://www.php.net/manual/ja/function.is-int.php
 * @param var mixed <p>
 * 評価する変数
 * </p>
 * @return bool もし var が 整数型 の場合 TRUE、
 * そうでない場合は FALSE を返します。
 */
function is_int ($var) {}

/**
 * <function>is_int</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.is-integer.php
 * @param var
 */
function is_integer ($var) {}

/**
 * <function>is_float</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.is-double.php
 * @param var
 */
function is_double ($var) {}

/**
 * <function>is_float</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.is-real.php
 * @param var
 */
function is_real ($var) {}

/**
 * 変数が数字または数値形式の文字列であるかを調べる
 * @link http://www.php.net/manual/ja/function.is-numeric.php
 * @param var mixed <p>
 * 評価する変数。
 * </p>
 * @return bool var が数値または数値形式の文字列である場合に
 * TRUE、それ以外の場合に FALSE を返します。
 */
function is_numeric ($var) {}

/**
 * 変数の型が文字列かどうかを調べる
 * @link http://www.php.net/manual/ja/function.is-string.php
 * @param var mixed <p>
 * 評価する変数。
 * </p>
 * @return bool var の型が string である場合に
 * TRUE、それ以外の場合に FALSE を返します。
 */
function is_string ($var) {}

/**
 * 変数が配列かどうかを検査する
 * @link http://www.php.net/manual/ja/function.is-array.php
 * @param var mixed <p>
 * 評価する変数
 * </p>
 * @return bool var が 配列型 の場合 TRUE、
 * そうでない場合 FALSE を返します。
 */
function is_array ($var) {}

/**
 * 変数がオブジェクトかどうかを検査する
 * @link http://www.php.net/manual/ja/function.is-object.php
 * @param var mixed <p>
 * 評価する変数。
 * </p>
 * @return bool もし var が object 型 の場合 TRUE、
 * そうでない場合は FALSE を返します。
 */
function is_object ($var) {}

/**
 * 変数がスカラかどうかを調べる
 * @link http://www.php.net/manual/ja/function.is-scalar.php
 * @param var mixed <p>
 * 評価する変数。
 * </p>
 * @return bool var がスカラの場合に TRUE、
 * それ以外の場合に FALSE を返します。
 */
function is_scalar ($var) {}

/**
 * 引数が、関数としてコール可能な構造であるかどうかを調べる
 * @link http://www.php.net/manual/ja/function.is-callable.php
 * @param name callable <p>
 * チェックするコールバック関数。
 * </p>
 * @param syntax_only bool[optional] <p>
 * TRUE の場合、この関数は単に name
 * が関数またはメソッドであるかどうかだけを調べます。
 * 文字列以外の型の変数や不正な形式の配列は、
 * 引数として受け付けられません。有効な配列の形式は、
 * 最初のエントリがオブジェクトあるいは文字列で、2 番目のエントリが文字列である
 * 2 つのエントリからなるものです。
 * </p>
 * @param callable_name string[optional] <p>
 * "呼び出し名" を受け取ります。下の例では "someClass::someMethod"
 * です。これは someClass::SomeMethod() が static メソッドであるかのようにみえますが、
 * そうではないことに注意しましょう。
 * </p>
 * @return bool name がコール可能な場合に TRUE、
 * それ以外の場合に FALSE を返します。
 */
function is_callable ($name, $syntax_only = null, &$callable_name = null) {}

/**
 * プロセスのファイルポインタをクローズする
 * @link http://www.php.net/manual/ja/function.pclose.php
 * @param handle resource <p>
 * ファイルポインタは有効なものでなければならず、また
 * popen で正常にオープンされたものである必要があります。
 * </p>
 * @return int 実行していたプロセスの終了ステータスを返します。
 * エラーが発生した場合は -1 を返します。
 */
function pclose ($handle) {}

/**
 * プロセスへのファイルポインタをオープンする
 * @link http://www.php.net/manual/ja/function.popen.php
 * @param command string <p>
 * コマンド。
 * </p>
 * @param mode string <p>
 * モード。
 * </p>
 * @return resource fopen
 * により返されたファイルポインタと同様のものを返しますが、
 * それは(読み書きのいずれか一方でのみ使われる)片方向ストリームであり、
 * pclose
 * によりクローズされなければならないところが異なります。
 * このポインタは、fgets、fgetss
 * および fwrite のいずれかで使うことができます。
 * モードが 'r' のときは、返されるファイルポインタは
 * そのコマンドの STDOUT と等しくなります。また、モードが
 * 'w' のときは、返されるファイルポインタは
 * そのコマンドの STDIN と等しくなります。
 * </p>
 * <p>
 * エラーが発生した場合は FALSE を返します。
 */
function popen ($command, $mode) {}

/**
 * ファイルを出力する
 * @link http://www.php.net/manual/ja/function.readfile.php
 * @param filename string <p>
 * 読み込もうとするファイルの名前。
 * </p>
 * @param use_include_path bool[optional] <p>
 * オプションの2番目の引数を使用して、これにTRUEを設定することにより、
 * include_path
 * のファイルの検索も行うことができます。
 * </p>
 * @param context resource[optional] <p>
 * コンテキストストリームリソース。
 * </p>
 * @return int ファイルから読み込んだバイト数を返します。エラーが起こると
 * FALSEを返し、また@readfileという名前でコールされない限り、
 * エラーメッセージが表示されます。
 */
function readfile ($filename, $use_include_path = null, $context = null) {}

/**
 * ファイルポインタの位置を先頭に戻す
 * @link http://www.php.net/manual/ja/function.rewind.php
 * @param handle resource <p>
 * ファイルポインタは有効なものでなければならず、
 * また fopen
 * で正常にオープンされたファイルを指している必要があります。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function rewind ($handle) {}

/**
 * ディレクトリを削除する
 * @link http://www.php.net/manual/ja/function.rmdir.php
 * @param dirname string <p>
 * ディレクトリへのパス。
 * </p>
 * @param context resource[optional] コンテキストのサポートは、
 * PHP 5.0.0 で追加されました。contexts の説明に関しては、
 * を参照してください。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function rmdir ($dirname, $context = null) {}

/**
 * 現在の umask を変更する
 * @link http://www.php.net/manual/ja/function.umask.php
 * @param mask int[optional] <p>
 * 新しい umask。
 * </p>
 * @return int umaskを引数無しで実行すると、単に現在の
 * umask値を返します。
 */
function umask ($mask = null) {}

/**
 * オープンされたファイルポインタをクローズする
 * @link http://www.php.net/manual/ja/function.fclose.php
 * @param handle resource <p>
 * ファイルポインタは有効なものでなければならず、また
 * fopenまたはfsockopen
 * で正常にオープンされたファイルを指している必要があります。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function fclose ($handle) {}

/**
 * ファイルポインタがファイル終端に達しているかどうか調べる
 * @link http://www.php.net/manual/ja/function.feof.php
 * @param handle resource ファイルポインタは、有効なファイルポインタである必要があり、
 * fopen または fsockopen で正常にオープンされた
 * （そしてまだ fclose でクローズされていない）
 * ファイルを指している必要があります。</p>
 * @return bool ファイルポインタが EOF に達しているかまたはエラー
 * (ソケットタイムアウトを含みます) の場合に TRUE 、
 * その他の場合に FALSE を返します。
 */
function feof ($handle) {}

/**
 * ファイルポインタから1文字取り出す
 * @link http://www.php.net/manual/ja/function.fgetc.php
 * @param handle resource ファイルポインタは、有効なファイルポインタである必要があり、
 * fopen または fsockopen で正常にオープンされた
 * （そしてまだ fclose でクローズされていない）
 * ファイルを指している必要があります。</p>
 * @return string handleが指すファイルポインタから 1 文字読み出し、
 * その文字からなる文字列を返します。EOF の場合に FALSE を返します。
 */
function fgetc ($handle) {}

/**
 * ファイルポインタから 1 行取得する
 * @link http://www.php.net/manual/ja/function.fgets.php
 * @param handle resource ファイルポインタは、有効なファイルポインタである必要があり、
 * fopen または fsockopen で正常にオープンされた
 * （そしてまだ fclose でクローズされていない）
 * ファイルを指している必要があります。</p>
 * @param length int[optional] <p>
 * 読み出しは、length - 1
 * バイト読み出したか、(返り値に含まれる)
 * 改行文字を検出したか、EOF に達したかのいずれかが起こった時点で終了します。
 * length が指定されない場合は、行末に達するまで読み続けます。
 * </p>
 * <p>
 * PHP 4.3.0 より前のバージョンでは、もしこのパラメータが省略された場合、
 * 行の長さを 1024 と仮定していました。
 * もしもファイル内の行の多くが 8KB を超えている場合は、
 * 行の最大長を指定するとスクリプトのリソース効率がよくなります。
 * </p>
 * @return string handle で指定したファイルポインタから最大
 * length - 1 バイト読み出し、
 * その文字列を返します。ファイルポインタから読み込むデータがもうない場合は
 * FALSE を返します。
 * </p>
 * <p>
 * エラーが起こった場合、FALSE を返します。
 */
function fgets ($handle, $length = null) {}

/**
 * ファイルポインタから 1 行取り出し、HTML タグを取り除く
 * @link http://www.php.net/manual/ja/function.fgetss.php
 * @param handle resource ファイルポインタは、有効なファイルポインタである必要があり、
 * fopen または fsockopen で正常にオープンされた
 * （そしてまだ fclose でクローズされていない）
 * ファイルを指している必要があります。</p>
 * @param length int[optional] <p>
 * 取得したいデータの長さ。
 * </p>
 * @param allowable_tags string[optional] <p>
 * オプションの 3 番目の引数を使用して、
 * 取り除く必要がないタグを指定することができます。
 * </p>
 * @return string handle で指定したファイルポインタから最大
 * length - 1 バイト読み出し、
 * HTML や PHP コードを取り除いた文字列を返します。
 * </p>
 * <p>
 * エラーが発生した場合は FALSE を返します。
 */
function fgetss ($handle, $length = null, $allowable_tags = null) {}

/**
 * バイナリセーフなファイルの読み込み
 * @link http://www.php.net/manual/ja/function.fread.php
 * @param handle resource fopen
 * を使用して作成したファイルシステムポインタリソース。</p>
 * @param length int <p>
 * 最大 length バイトまで読み込む。
 * </p>
 * @return string 読み込んだ文字列を返します。失敗した場合に FALSE を返します。
 */
function fread ($handle, $length) {}

/**
 * ファイルまたは URL をオープンする
 * @link http://www.php.net/manual/ja/function.fopen.php
 * @param filename string <p>
 * filename が "スキーム://..." の形式である場合、
 * それは URL とみなされ、PHP はそのプロトコルのハンドラ
 * (ラッパーともいいます) を探します。
 * もしもそのプロトコルに対するラッパーが登録されていない場合、
 * PHP はスクリプトに潜在的な問題があることを示す NOTICE を発行したうえで、
 * filename を通常のファイルとみなしてオープンすることを試みます。
 * </p>
 * <p>
 * PHP は、filename がローカルのファイルを示しているとみなすと、
 * そのファイルへのストリームをオープンします。
 * そのファイルはPHPからアクセスできるものでなければなりません。
 * ファイルのパーミッションが (パラメータで指定された)
 * アクセスを許可されているかどうか確認する必要があります。
 * セーフモード または open_basedir
 * を有効にしている場合は更なるアクセス制限が加えられることがあります。
 * </p>
 * <p>
 * filename が登録されているプロトコルを示していると
 * PHP が判断し、かつそのプロトコルがネットワーク URL として登録されていれば、
 * PHP は allow_url_fopen
 * が有効となっているかどうかチェックします。
 * もしこれがオフになっていると、PHP は warning を発行し fopen は失敗します。
 * </p>
 * <p>
 * サポートされているプロトコルのリストは にあります。
 * いくつかのプロトコル (wrappersにも関連する) は
 * context かつ/または php.ini のオプションをサポートします。
 * 使用するプロトコルについてセットされるオプションのリストについては、
 * それぞれのページを見てください (例えば、 php.ini 上の
 * user_agent の値は
 * http ラッパーが使用します)。
 * </p>
 * <p>
 * Windows 環境では、ファイルパスで用いる全てのバックスラッシュを
 * エスケープするかフォワードスラッシュを使用することに注意してください。
 * ]]>
 * </p>
 * @param mode string <p>
 * パラメータ mode は、
 * そのストリームに要するアクセス形式を指定します。
 * この指定は、下表のうちのどれかとなります。
 * <table>
 * fopen で使用可能な
 * mode のリスト
 * <tr valign="top">
 * <td>mode</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>'r'</td>
 * <td>
 * 読み込みのみでオープンします。ファイルポインタをファイルの先頭に置きます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>'r+'</td>
 * <td>
 * 読み込み／書き出し用にオープンします。
 * ファイルポインタをファイルの先頭に置きます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>'w'</td>
 * <td>
 * 書き出しのみでオープンします。ファイルポインタをファイルの先頭に置き、
 * ファイルサイズをゼロにします。ファイルが存在しない場合には、
 * 作成を試みます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>'w+'</td>
 * <td>
 * 読み込み／書き出し用でオープンします。
 * ファイルポインタをファイルの先頭に置き、
 * ファイルサイズをゼロにします。
 * ファイルが存在しない場合には、作成を試みます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>'a'</td>
 * <td>
 * 書き出し用のみでオープンします。ファイルポインタをファイルの終端に置きます。
 * ファイルが存在しない場合には、作成を試みます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>'a+'</td>
 * <td>
 * 読み込み／書き出し用でオープンします。
 * ファイルポインタをファイルの終端に置きます。
 * ファイルが存在しない場合には、作成を試みます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>'x'</td>
 * <td>
 * 書き込みのみでオープンします。ファイルポインタをファイルの先頭に置きます。
 * ファイルが既に存在する場合には fopen は失敗し、
 * E_WARNING レベルのエラーを発行します。
 * ファイルが存在しない場合には新規作成を試みます。
 * これは open(2) システムコールにおける
 * O_EXCL|O_CREAT フラグの指定と等価です。
 * このオプションはPHP4.3.2以降でサポートされ、また、
 * ローカルファイルに対してのみ有効です。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>'x+'</td>
 * <td>
 * 読み込み／書き出し用でオープンします。
 * それ以外のふるまいは 'x' と同じです。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>'c'</td>
 * <td>
 * 書き込みのみでオープンします。ファイルが存在しない場合には新規作成を試みます。
 * ファイルが既に存在する場合でもそれを ('w' のように) 切り詰めたりせず、
 * また ('x' のように) 関数のコールが失敗することもありません。
 * ファイルポインタをファイルの先頭に置きます。これは、アドバイザリ・ロック
 * (flock を参照ください) を確保してからファイルを変更したい場合に便利です。
 * 'w' を使うと、ロックを取得する前にファイルを切り詰めてしまいます
 * (もしファイルを切り詰めたいのなら、ロックを要求した後で
 * ftruncate を使うこともできます)。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>'c+'</td>
 * <td>
 * 読み込み／書き出し用でオープンします。
 * それ以外のふるまいは 'c' と同じです。
 * </td>
 * </tr>
 * </table>
 * </p>
 * <p>
 * オペレーティングシステムファミリが異なると行末も異なります。
 * テキストファイルに書き出し、そこに改行を加えたいとき、
 * オペレーティングシステムにあわせた正しい改行コードを使用する必要があります。
 * Unix ベースのシステムでは改行に \n キャラクタを使用します。
 * Windows ベースのシステムでは \r\n を使用します。
 * マッキントッシュベースのシステムでは \r を使用します。
 * </p>
 * <p>
 * 間違った改行コードでファイルに書き込むと、
 * 他のアプリケーション上でそのファイルを開いた際に変な風に見えてしまいます。
 * </p>
 * <p>
 * Windows上では、\nを\r\nに透過的に変換する
 * text-mode変換フラグ('t')が提供されます。
 * それに対し、'b'を使って強制的にバイナリモードにすることもできます。
 * その場合データの変換はされません。
 * このフラグを使用するには、'b' または 't'を
 * mode引数の最後に追加してください。
 * </p>
 * <p>
 * デフォルトの変換モードは SAPI と使用している PHP のバージョンによって異なります。
 * したがって、互換性の意味から、常に適切なフラグを指定することが推奨されます。
 * plain-text ファイルを使用する場合には 't' モードを指定すべきであり、
 * 改行に \n を使用すると、
 * メモ帳のようなアプリケーションで読めることを期待できます。
 * それ以外のケースでは 'b' を使うべきです。
 * </p>
 * <p>
 * バイナリファイルを扱っている際に
 * 'b' フラグを指定しなかった場合、
 * 画像ファイルが壊れたり、\r\n
 * キャラクタがおかしくなる等の問題を抱えてしまうでしょう。
 * </p>
 * <p>
 * 互換性維持のために、fopen でファイルをオープンする際は
 * 常に 'b' フラグを指定することが強く推奨されます。
 * </p>
 * <p>
 * 互換性維持のために、't'
 * モードを使用または依存しているコードを書き直し、
 * 正しい改行コードと 'b' モードを代わりに使用することが、
 * 強く推奨されます。
 * </p>
 * @param use_include_path bool[optional] <p>
 * オプションの３番目の引数use_include_pathに'1'又は
 * TRUE を設定することにより、include_path
 * のファイルの検索も行うこともできます。
 * </p>
 * @param context resource[optional] コンテキストのサポートは、
 * PHP 5.0.0 で追加されました。contexts の説明に関しては、
 * を参照してください。
 * @return resource 成功した場合にファイルポインタリソース、エラー時に FALSE を返します。
 */
function fopen ($filename, $mode, $use_include_path = null, $context = null) {}

/**
 * ファイルポインタ上に残っているすべてのデータを出力する
 * @link http://www.php.net/manual/ja/function.fpassthru.php
 * @param handle resource ファイルポインタは、有効なファイルポインタである必要があり、
 * fopen または fsockopen で正常にオープンされた
 * （そしてまだ fclose でクローズされていない）
 * ファイルを指している必要があります。</p>
 * @return int エラーが起こった場合、fpassthru は FALSE を返します。
 * それ以外の場合、fpassthru は handle
 * から読み込んだ文字の数を返し、出力へ渡します。
 */
function fpassthru ($handle) {}

/**
 * ファイルを指定した長さに丸める
 * @link http://www.php.net/manual/ja/function.ftruncate.php
 * @param handle resource <p>
 * ファイルポインタ。
 * </p>
 * <p>
 * handle は書き込みモードでオープンする必要があります。
 * </p>
 * @param size int <p>
 * 丸める大きさ。
 * </p>
 * <p>
 * size がファイルのサイズより大きい場合は、
 * null バイトを用いてファイルを拡大します。
 * </p>
 * <p>
 * size がファイルのサイズより小さい場合は、
 * 余分なデータは失われます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ftruncate ($handle, $size) {}

/**
 * オープンしたファイルポインタからファイルに関する情報を取得する
 * @link http://www.php.net/manual/ja/function.fstat.php
 * @param handle resource fopen
 * を使用して作成したファイルシステムポインタリソース。</p>
 * @return array ファイルの統計情報の配列を返します。配列のフォーマットについては
 * statのマニュアルをご覧ください。
 */
function fstat ($handle) {}

/**
 * ファイルポインタを移動する
 * @link http://www.php.net/manual/ja/function.fseek.php
 * @param handle resource fopen
 * を使用して作成したファイルシステムポインタリソース。</p>
 * @param offset int <p>
 * オフセット。
 * </p>
 * <p>
 * ファイルの終端から数えた位置に移動するには、負の値を
 * offset に渡して
 * whence を
 * SEEK_END に設定しなければなりません。
 * </p>
 * @param whence int[optional] <p>
 * whence の値は以下のようになります。
 * SEEK_SET - 位置を offset バイト目に設定する
 * SEEK_CUR - 現在の位置に offset を加えた位置に設定する
 * SEEK_END - ファイル終端に offset を加えた位置に設定する
 * </p>
 * @return int 成功すると 0 を返し、そうでなければ -1 を返します。
 */
function fseek ($handle, $offset, $whence = null) {}

/**
 * ファイルの読み書き用ポインタの現在位置を返す
 * @link http://www.php.net/manual/ja/function.ftell.php
 * @param handle resource <p>
 * ファイルポインタは有効なものでなければならず、また
 * fopen、popen
 * で正常にオープンされたファイルを指している必要があります。
 * ftell は、("a" フラグ付きでオープンされた)
 * 追加のみ可能なストリームに対する結果も未定義です。
 * </p>
 * @return int handle が示すファイルポインタの位置、
 * すなわちファイル・ストリーム上のオフセットを整数値で返します。
 * </p>
 * <p>
 * エラーが起こった場合 FALSE を返します。
 */
function ftell ($handle) {}

/**
 * 出力をファイルにフラッシュする
 * @link http://www.php.net/manual/ja/function.fflush.php
 * @param handle resource ファイルポインタは、有効なファイルポインタである必要があり、
 * fopen または fsockopen で正常にオープンされた
 * （そしてまだ fclose でクローズされていない）
 * ファイルを指している必要があります。</p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function fflush ($handle) {}

/**
 * バイナリセーフなファイル書き込み処理
 * @link http://www.php.net/manual/ja/function.fwrite.php
 * @param handle resource fopen
 * を使用して作成したファイルシステムポインタリソース。</p>
 * @param string string <p>
 * 書き込む文字列。
 * </p>
 * @param length int[optional] <p>
 * lengthパラメータが与えられている場合、
 * lengthバイト数分の書き込みが完了したか、
 * stringが終わりに達したかのいずれか早い方の
 * 事象により書き込みは中止されます。
 * </p>
 * <p>
 * length パラメータが指定されている場合、
 * magic_quotes_runtime
 * 構成オプションは無視され、stringからの
 * スラッシュ文字の取り除きは行われないことに注意してください。
 * </p>
 * @return int 
 */
function fwrite ($handle, $string, $length = null) {}

/**
 * <function>fwrite</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.fputs.php
 * @param fp
 * @param str
 * @param length[optional]
 */
function fputs ($fp, $str, $length) {}

/**
 * ディレクトリを作る
 * @link http://www.php.net/manual/ja/function.mkdir.php
 * @param pathname string <p>
 * ディレクトリのパス。
 * </p>
 * @param mode int[optional] <p>
 * モードは 0777 がデフォルトです。
 * これは最も緩やかなアクセス制限を意味します。
 * モードに関する詳細は chmod をご覧ください。
 * </p>
 * <p>
 * Windows では mode は無視されます。
 * </p>
 * <p>
 * モードを八進数で指定したくなることもあるかもしれません。
 * その場合は先頭にゼロをつける必要があります。
 * また、モードは、現在設定されている umask の影響も受けます。
 * umask を変更するには umask を使用します。
 * </p>
 * @param recursive bool[optional] <p>
 * pathname で、入れ子構造のディレクトリの作成を許可します。
 * </p>
 * @param context resource[optional] コンテキストのサポートは、
 * PHP 5.0.0 で追加されました。contexts の説明に関しては、
 * を参照してください。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function mkdir ($pathname, $mode = null, $recursive = null, $context = null) {}

/**
 * ファイルをリネームする
 * @link http://www.php.net/manual/ja/function.rename.php
 * @param oldname string <p>
 * </p>
 * <p>
 * 変更前の名前。
 * oldname で使用されるラッパーは、
 * newname で使用するラッパーと適合
 * している必要があります 。
 * </p>
 * @param newname string <p>
 * 変更後の名前。
 * </p>
 * @param context resource[optional] コンテキストのサポートは、
 * PHP 5.0.0 で追加されました。contexts の説明に関しては、
 * を参照してください。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function rename ($oldname, $newname, $context = null) {}

/**
 * ファイルをコピーする
 * @link http://www.php.net/manual/ja/function.copy.php
 * @param source string <p>
 * コピー元ファイルへのパス。
 * </p>
 * @param dest string <p>
 * コピー先のパス。dest が URL の場合、
 * 既存ファイルへの上書きをラッパーがサポートしていない場合にはコピーが失敗します。
 * </p>
 * <p>
 * コピー先のファイルが既に存在する場合、上書きされます。
 * </p>
 * @param context resource[optional] <p>
 * stream_context_create
 * で作成した有効なコンテキストリソース。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function copy ($source, $dest, $context = null) {}

/**
 * 一意なファイル名を生成する
 * @link http://www.php.net/manual/ja/function.tempnam.php
 * @param dir string <p>
 * テンポラリファイルを作成したいディレクトリ。
 * </p>
 * @param prefix string <p>
 * 作成されるテンポラリファイルのプレフィックス。
 * </p>
 * Windows では、プレフィックスの最初の 3 文字のみを使用します。
 * @return string 新しいテンポラリファイル名を返し、失敗した場合には FALSE を返します。
 */
function tempnam ($dir, $prefix) {}

/**
 * テンポラリファイルを作成する
 * @link http://www.php.net/manual/ja/function.tmpfile.php
 * @return resource ファイルのハンドルを返します。
 * これは、 fopen
 * により返されるハンドルと同じものです。
 * 失敗した場合に FALSE を返します。
 */
function tmpfile () {}

/**
 * ファイル全体を読み込んで配列に格納する
 * @link http://www.php.net/manual/ja/function.file.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * fopen wrappers が有効の場合、この関数のファイル名として
 * URL を使用することができます。ファイル名の指定方法に関する詳細は
 * fopen を参照ください。
 * には、さまざまなラッパーの機能やその使用法、
 * 提供される定義済み変数などの情報がまとめられています。
 * @param flags int[optional] <p>
 * オプションのパラメータ flags
 * は、以下の定数のうちのひとつ、あるいは複数の組み合わせとなります。
 * FILE_USE_INCLUDE_PATH
 * include_path のファイルを探します。
 * @param context resource[optional] <p>
 * stream_context_create 関数で作成したコンテキストリソース。
 * </p>
 * <p>
 * コンテキストのサポートは、
 * PHP 5.0.0 で追加されました。contexts の説明に関しては、
 * を参照してください。
 * </p>
 * @return array ファイルを配列に入れて返します。
 * 配列の各要素はファイルの各行に対応します。改行記号はついたままとなります。
 * 失敗すると file は FALSE を返します。
 * </p>
 * <p>
 * FILE_IGNORE_NEW_LINES を指定しない限り、
 * 配列に取り込まれた各行は行末文字も含みます。
 * 行末文字を取り除きたい場合には rtrim を使用する必要があります。
 */
function file ($filename, $flags = null, $context = null) {}

/**
 * ファイルの内容を全て文字列に読み込む
 * @link http://www.php.net/manual/ja/function.file-get-contents.php
 * @param filename string <p>
 * データを読み込みたいファイルの名前。
 * </p>
 * @param use_include_path bool[optional] <p>
 * PHP 5 以降では、FILE_USE_INCLUDE_PATH
 * を使用して インクルードパス
 * から探すことができます。
 * </p>
 * @param context resource[optional] <p>
 * stream_context_create で作成したコンテキストリソース。
 * 独自のコンテキストを使用する必要がない場合は、このパラメータに
 * NULL を指定します。
 * </p>
 * @param offset int[optional] <p>
 * 元のストリーム上で、読み込みを開始するオフセット位置。
 * </p>
 * <p>
 * リモートファイルに対するシーク (offset 指定) はサポートしていません。
 * オフセットが小さい場合はリモートファイルでのシークがうまくいくこともありますが、
 * これはバッファリングされたストリーム上で動作しているだけのことです。
 * </p>
 * @param maxlen int[optional] <p>
 * 読み込むデータの最大バイト数。
 * デフォルトは、ファイル終端に達するまで読み込みます。
 * このパラメータは、フィルタが処理した後のストリームに適用されることに注意しましょう。
 * </p>
 * @return string 読み込んだデータを返します。失敗した場合に FALSE を返します。
 */
function file_get_contents ($filename, $use_include_path = null, $context = null, $offset = null, $maxlen = null) {}

/**
 * 文字列をファイルに書き込む
 * @link http://www.php.net/manual/ja/function.file-put-contents.php
 * @param filename string <p>
 * データを書き込むファイルへのパス。
 * </p>
 * @param data mixed <p>
 * 書き込むデータ。文字列, 配列
 * もしくは ストリーム リソースのいずれかを指定可能です。
 * </p>
 * <p>
 * data が ストリーム リソースの場合は、
 * ストリームのバッファに残っている内容が指定したファイルにコピーされます。
 * これは、stream_copy_to_stream の挙動と似ています。
 * </p>
 * <p>
 * data に一次元の配列を指定することもできます。この場合は
 * file_put_contents($filename, implode('', $array))
 * と同じ意味になります。
 * </p>
 * @param flags int[optional] <p>
 * flags の値は、以下のフラグを組み合わせたものとなります
 * 組み合わせる際には、論理 OR
 * (|) 演算子で連結します。
 * </p>
 * <p>
 * <table>
 * 使用できるフラグ
 * <tr valign="top">
 * <td>フラグ</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>
 * FILE_USE_INCLUDE_PATH
 * </td>
 * <td>
 * filename をインクルードディレクトリから探します。
 * 詳細な情報は include_path を参照ください。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>
 * FILE_APPEND
 * </td>
 * <td>
 * filename がすでに存在する場合に、
 * データをファイルに上書きするするのではなく追記します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>
 * LOCK_EX
 * </td>
 * <td>
 * 書き込み処理中に、ファイルに対する排他ロックを確保します。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @param context resource[optional] <p>
 * stream_context_create
 * で作成したコンテキストリソース。
 * </p>
 * @return int この関数はファイルに書き込まれたバイト数を返します。
 * あるいは失敗した場合には FALSE を返します。
 */
function file_put_contents ($filename, $data, $flags = null, $context = null) {}

/**
 * select() システムコールと同等の操作を、
   ストリームの配列に対して tv_sec と tv_usec で指定されたタイムアウト時間をもって行う
 * @link http://www.php.net/manual/ja/function.stream-select.php
 * @param read array <p>
 * read 配列に列挙されたストリームに対しては、
 * 何らかのデータがそのストリーム内で読み出せる状態にあるかどうか
 * 監視が行われます
 * (より正確にいえば、ブロックしないで読み出せる状態かどうか -
 * 特にストリームが EOF に達したかどうか、です。このとき、
 * fread は長さ 0 の文字列を返します)。
 * </p>
 * @param write array <p>
 * write 配列に列挙されたストリームに対しては、
 * ブロックしないで書き込みができるかどうかの監視が行われます。
 * </p>
 * @param except array <p>
 * except 配列に列挙されたストリームに対しては、
 * 重大な例外（"帯域外の"）データが発生したかどうかの監視が行われます。
 * </p>
 * <p>
 * stream_select の終了時には、
 * どのストリームの状態が実際に変化したのかが分かるよう、
 * 配列 read、write および
 * except に変更が加えられます。
 * </p>
 * stream_select のすべてのパラメータに配列を
 * 渡す必要はありません。代わりに
 * そのままにしておくことも、空の配列を渡すことも、NULL を渡すことも
 * できます。このとき、それらの変数は参照渡しで渡されるため、
 * stream_select から戻った時点で変更されている
 * 可能性があることに注意してください。
 * @param tv_sec int <p>
 * tv_sec と tv_usec
 * は、一体となって、timeout パラメータを表現します。
 * tv_sec は秒数を指定し、一方
 * tv_usec はマイクロ秒数を指定します。
 * timeout は、stream_select
 * の実行から戻るまでの時間の上限です。
 * tv_sec および tv_usec
 * の両方に 0 を指定すると
 * stream_select はデータを待たずに一瞬で戻ります。
 * これは現在のストリームの状態を示します。
 * </p>
 * <p>
 * tv_sec が NULL (タイムアウトなし) の場合、
 * stream_select はブロックしつづけ、調べている
 * ストリームのひとつでイベントが発生する（あるいはシグナルがシステム
 * コールを中断する）まで終了しません。
 * </p>
 * <p>
 * タイムアウト値に 0 を指定すると、ストリームの
 * 状態を即時に取得することが可能です。しかし、ループ内でタイムアウト
 * 0 を指定するのは良い考えではありません。
 * そうすると大量の CPU 時間を消費してしまいます。
 * </p>
 * <p>
 * タイムアウト値を数秒にするとかなりましになります。しかし、どうしても
 * 他のコードを同時に実行させながらチェックをする必要がある場合には、
 * 少なくとも 200000 マイクロ秒以上のタイムアウトを
 * 設定するようにしましょう。これであなたのスクリプトの CPU 使用量を
 * 抑えることができます。
 * </p>
 * <p>
 * タイムアウト値は、あくまでも経過時間の最大値であることを覚えておきましょう。
 * stream_select は、指定したストリームが使用可能に
 * なるとすぐに結果を返します。
 * </p>
 * @param tv_usec int[optional] <p>
 * tv_sec の説明を参照ください。
 * </p>
 * @return int 成功した場合 stream_select は、変更された
 * 配列に何個のストリームリソースが格納されたかを示す数を返します。
 * もしタイムアウトの時間内に何も規定された事象が起こらなかった場合は
 * 0 になることもあります。エラーの際は FALSE を返し、警告を発生させます
 * （システムコールが別のシグナルによって中断された場合などに起こりえます）。
 */
function stream_select (array &$read, array &$write, array &$except, $tv_sec, $tv_usec = null) {}

/**
 * ストリームコンテキストを作成する
 * @link http://www.php.net/manual/ja/function.stream-context-create.php
 * @param options array[optional] <p>
 * 次のような形式の連想配列からなる連想配列でなくてはなりません。
 * $arr['wrapper']['option'] = $value.
 * </p>
 * <p>
 * デフォルトは空の配列です。
 * </p>
 * @param params array[optional] <p>
 * $arr['parameter'] = $value
 * 形式の連想配列でなくてばなりません。
 * 標準のストリームパラメータについては
 * コンテキストパラメータ を参照ください。
 * </p>
 * @return resource ストリームコンテキストリソースを返します。
 */
function stream_context_create (array $options = null, array $params = null) {}

/**
 * ストリーム / ラッパー / コンテキストのパラメータを設定する
 * @link http://www.php.net/manual/ja/function.stream-context-set-params.php
 * @param stream_or_context resource <p>
 * パラメータを適用したいストリームあるいはコンテキスト。
 * </p>
 * @param params array <p>
 * 設定するパラメータ。
 * </p>
 * <p>
 * params は、次のような形式の連想配列でなくてはなりません:
 * $params['paramname'] = "paramvalue";
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function stream_context_set_params ($stream_or_context, array $params) {}

/**
 * コンテキストのパラメータを取得する
 * @link http://www.php.net/manual/ja/function.stream-context-get-params.php
 * @param stream_or_context resource <p>
 * ストリームリソースあるいは
 * コンテキストリソース。
 * </p>
 * @return array すべてのコンテキストオプションおよびパラメータを含む連想配列を返します。
 */
function stream_context_get_params ($stream_or_context) {}

/**
 * ストリーム / ラッパー / コンテキストのオプションを設定する
 * @link http://www.php.net/manual/ja/function.stream-context-set-option.php
 * @param stream_or_context resource <p>
 * オプションを適用したいストリームあるいはコンテキストリソース。
 * </p>
 * @param wrapper string 
 * @param option string 
 * @param value mixed 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function stream_context_set_option ($stream_or_context, $wrapper, $option, $value) {}

/**
 * ストリーム / ラッパー / コンテキストに設定されているオプションを取得する
 * @link http://www.php.net/manual/ja/function.stream-context-get-options.php
 * @param stream_or_context resource <p>
 * オプションを取得したいストリームあるいはコンテキスト。
 * </p>
 * @return array オプションを連想配列で返します。
 */
function stream_context_get_options ($stream_or_context) {}

/**
 * デフォルトのストリームコンテキストを取得する
 * @link http://www.php.net/manual/ja/function.stream-context-get-default.php
 * @param options array[optional] options は、
 * $arr['wrapper']['option'] = $value
 * のような形式の、連想配列の連想配列である必要があります。
 * <p>
 * PHP 5.3.0 以降では、stream_context_set_default
 * 関数でデフォルトのコンテキストを設定することが可能です。
 * </p>
 * @return resource ストリームコンテキストリソースを返します。
 */
function stream_context_get_default (array $options = null) {}

/**
 * デフォルトのストリームコンテキストを設定する
 * @link http://www.php.net/manual/ja/function.stream-context-set-default.php
 * @param options array <p>
 * デフォルトコンテキストに設定するオプション。
 * </p>
 * <p>
 * options は、
 * $arr['wrapper']['option'] = $value
 * のような形式の、連想配列の連想配列である必要があります。
 * </p>
 * @return resource デフォルトのストリームコンテキストを返します。
 */
function stream_context_set_default (array $options) {}

/**
 * フィルタをストリームに付加する
 * @link http://www.php.net/manual/ja/function.stream-filter-prepend.php
 * @param stream resource <p>
 * 対象となるストリーム。
 * </p>
 * @param filtername string <p>
 * フィルタ名。
 * </p>
 * @param read_write int[optional] <p>
 * デフォルトでは、 stream_filter_prepend は
 * ストリームが読み込み用に開かれている場合は (つまり、オープンモードが
 * r あるいは + を伴う場合は)、
 * フィルタを リードフィルタチェイン に追加し、
 * ストリームが書き出し用に開かれている場合は(つまり、オープンモードが
 * w か aか、あるいは+ を伴う場合は)、
 * ライトフィルターチェィンにも追加します。
 * STREAM_FILTER_READ・
 * STREAM_FILTER_WRITE・
 * STREAM_FILTER_ALL を read_writeパラメータに渡すことで、この挙動を変えることができます。
 * このパラメータを使った例については、
 * stream_filter_append を参照ください。
 * </p>
 * @param params mixed[optional] <p>
 * このフィルタは、指定された params と共に、
 * リストの先頭に追加され、ストリームに対する操作の中で最初に呼び出されます。
 * フィルタをリストの末尾に加えたいときは、stream_filter_append
 * を使ってください。
 * </p>
 * @return resource リソースを返します。このリソースは
 * stream_filter_remove のコール時にこの
 * フィルタのインスタンスを指定するために使用可能です。
 */
function stream_filter_prepend ($stream, $filtername, $read_write = null, $params = null) {}

/**
 * ストリームにフィルタを付加する
 * @link http://www.php.net/manual/ja/function.stream-filter-append.php
 * @param stream resource <p>
 * 対象となるストリーム。
 * </p>
 * @param filtername string <p>
 * フィルタ名。
 * </p>
 * @param read_write int[optional] <p>
 * デフォルトでは、 stream_filter_append は
 * ストリームが読み込み用に開かれている場合は (つまり、オープンモードが
 * r あるいは + を伴う場合は)、
 * フィルタを リードフィルタチェイン に追加し、
 * ストリームが書き出し用に開かれている場合は(つまり、オープンモードが
 * w か aか、あるいは+ を伴う場合は)、
 * ライトフィルターチェィンにも追加します。
 * STREAM_FILTER_READ・
 * STREAM_FILTER_WRITE・
 * STREAM_FILTER_ALL を read_writeパラメータに渡すことで、この挙動を変えることができます。
 * </p>
 * @param params mixed[optional] <p>
 * このフィルタは、指定された params と共に、
 * リストの末尾に追加され、ストリームに対する操作の中で最後に呼び出されます。
 * フィルタをリストの先頭に加えたいときは、stream_filter_prepend
 * を使ってください。
 * </p>
 * @return resource リソースを返します。
 * このリソースは、stream_filter_remove
 * をコールする際にこのフィルタインスタンスを参照するために使用可能です。
 */
function stream_filter_append ($stream, $filtername, $read_write = null, $params = null) {}

/**
 * ストリームからフィルタを取り除く
 * @link http://www.php.net/manual/ja/function.stream-filter-remove.php
 * @param stream_filter resource <p>
 * 削除するストリームフィルタ。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function stream_filter_remove ($stream_filter) {}

/**
 * インターネットドメインまたは Unix ドメインのソケット接続を開く
 * @link http://www.php.net/manual/ja/function.stream-socket-client.php
 * @param remote_socket string <p>
 * 接続するソケットのアドレス。
 * </p>
 * @param errno int[optional] <p>
 * 接続に失敗した場合にシステムレベルのエラー番号が設定されます。
 * </p>
 * @param errstr string[optional] <p>
 * 接続に失敗した場合にシステムレベルのエラーメッセージが設定されます。
 * </p>
 * @param timeout float[optional] <p>
 * connect() システムコールがタイムアウトとなるまでの秒数。
 * このパラメータが適用されるのは、非同期通信を試みていない場合のみです。
 * <p>
 * ソケット上のデータの読み書きに関してタイムアウトを設定する必要がある場合は、
 * stream_set_timeout を使ってください。
 * stream_socket_client に渡される
 * timeout は、ソケットの接続時にのみ適用されます。
 * </p>
 * </p>
 * @param flags int[optional] <p>
 * 接続設定フラグの任意の組み合わせを指定できるビットフィールドです。
 * 現在、接続設定フラグとして選択できる値は、
 * STREAM_CLIENT_CONNECT（デフォルト）、
 * STREAM_CLIENT_ASYNC_CONNECT と 
 * STREAM_CLIENT_PERSISTENT のみです。
 * </p>
 * @param context resource[optional] <p>
 * stream_context_create で作成した有効なコンテキストリソース。
 * </p>
 * @return resource 成功した場合に、
 * fgets, fgetss,
 * fwrite, fclose,
 * feof といった、ファイル関数と共に使うことのできるストリームリソースを返します。
 */
function stream_socket_client ($remote_socket, &$errno = null, &$errstr = null, $timeout = null, $flags = null, $context = null) {}

/**
 * インターネットドメインまたは Unix ドメインのサーバーソケットを作成する
 * @link http://www.php.net/manual/ja/function.stream-socket-server.php
 * @param local_socket string <p>
 * 作成されるソケットのタイプは、[トランスポート]://[ターゲット]
 * という形式の URL フォーマットによって指定された
 * トランスポートによって決定されます:
 * </p>
 * <p>
 * TCP や UDP といったインターネットドメインのソケット (AF_INET)
 * には、remote_socket パラメータの
 * ターゲット の部分は、ホスト名または IP アドレスと、
 * それに続くコロンで区切られたポート番号から構成されていなければなりません。
 * Unix ドメインのソケットの場合は、ターゲット
 * の部分は、ファイルシステムにおけるソケットのファイルを指定しなくては
 * いけません。
 * </p>
 * <p>
 * システムの種類によって、Unix ドメインのソケットが利用できない場合があります。
 * 利用できるトランスポートの種類は、stream_get_transports
 * によって知ることができます。
 * 組み込みのトランスポートのリストは、
 * を参照ください。
 * </p>
 * @param errno int[optional] <p>
 * オプションの
 * errno と errstr
 * パラメータが存在するときは、そこにシステムレベルの
 * socket()、bind() および
 * listen() のコールにおいて発生した
 * 実際のシステムレベルのエラーを返します。
 * もし、errno に返された値が 0
 * で、かつ FALSE が返された場合、bind()
 * コールを行う前にエラーが発生したことを示しており、これは多くの場合
 * ソケットの初期化に失敗したことを示しています。
 * errno と errstr
 * パラメータは常に参照渡しとなることに留意してください。
 * </p>
 * @param errstr string[optional] <p>
 * errno の説明を参照ください。
 * </p>
 * @param flags int[optional] <p>
 * ソケット作成フラグの任意の組み合わせを指定できるビットフィールドです。
 * </p>
 * <p>
 * UDP ソケットに対しては、STREAM_SERVER_BIND を
 * flags パラメータとして使用する必要があります。
 * </p>
 * @param context resource[optional] <p>
 * </p>
 * @return resource 作成したストリーム、あるいはエラー時に FALSE を返します。
 */
function stream_socket_server ($local_socket, &$errno = null, &$errstr = null, $flags = null, $context = null) {}

/**
 * <function>stream_socket_server</function> で作られたソケットの接続を受け入れる
 * @link http://www.php.net/manual/ja/function.stream-socket-accept.php
 * @param server_socket resource <p>
 * 接続元からの接続を受け付けるサーバーソケット。
 * </p>
 * @param timeout float[optional] <p>
 * デフォルトのソケット接続待ちタイムアウトを上書きします。
 * 時間は秒単位で指定します。
 * </p>
 * @param peername string[optional] <p>
 * 接続元のクライアントの名前 (アドレス) が含まれていて、
 * 選択したトランスポートで有効であった場合に、それを設定します。
 * </p>
 * <p>
 * 後で
 * stream_socket_get_name
 * を使用して指定することもできます。
 * </p>
 * @return resource 受け付けたソケット接続へのストリームを返します。失敗した場合に FALSE を返します。
 */
function stream_socket_accept ($server_socket, $timeout = null, &$peername = null) {}

/**
 * ローカルまたはリモートのソケットの名前を取得する
 * @link http://www.php.net/manual/ja/function.stream-socket-get-name.php
 * @param handle resource <p>
 * 名前を取得したいソケット。
 * </p>
 * @param want_peer bool <p>
 * TRUE に設定するとリモートでのソケットの名前を返し、
 * FALSE に設定するとローカルでのソケットの名前を返します。
 * </p>
 * @return string ソケットの名前を返します。
 */
function stream_socket_get_name ($handle, $want_peer) {}

/**
 * 接続されているかどうかにかかわらず、ソケットからのデータを受信する
 * @link http://www.php.net/manual/ja/function.stream-socket-recvfrom.php
 * @param socket resource <p>
 * リモートソケット。
 * </p>
 * @param length int <p>
 * socket から受信するバイト数。
 * </p>
 * @param flags int[optional] <p>
 * flags は以下の値の組み合わせです。
 * <table>
 * flags でとりうる値
 * <tr valign="top">
 * <td>STREAM_OOB</td>
 * <td>
 * OOB (out-of-band) データを処理します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>STREAM_PEEK</td>
 * <td>
 * ソケットからデータを取得しますが、バッファを消費しません。
 * fread あるいは
 * stream_socket_recvfrom を続けてコールした
 * 際には、同じデータが読み込まれます。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @param address string[optional] <p>
 * address が指定された場合、
 * そこにはリモートソケットのアドレスが保存されます。
 * </p>
 * @return string 読み込んだデータを文字列で返します。
 */
function stream_socket_recvfrom ($socket, $length, $flags = null, &$address = null) {}

/**
 * 接続されているかどうかにかかわらず、ソケットにデータを送信する
 * @link http://www.php.net/manual/ja/function.stream-socket-sendto.php
 * @param socket resource <p>
 * data を送信するソケット。
 * </p>
 * @param data string <p>
 * 送りたいデータ。
 * </p>
 * @param flags int[optional] <p>
 * flags は以下の値の組み合わせです。
 * <table>
 * flags でとりうる値
 * <tr valign="top">
 * <td>STREAM_OOB</td>
 * <td>
 * OOB (out-of-band) データを処理します。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @param address string[optional] <p>
 * address で別のアドレスが指定されていない限り、
 * ソケットストリームが作成された際のアドレスを使用します。
 * </p>
 * <p>
 * 指定する場合は、ドットで 4 つに区切った形式 (あるいは IPv6 形式) でなければなりません。
 * </p>
 * @return int 結果コードを整数値で返します。
 */
function stream_socket_sendto ($socket, $data, $flags = null, $address = null) {}

/**
 * 接続済みのソケットについて暗号化の on/off を切り替える
 * @link http://www.php.net/manual/ja/function.stream-socket-enable-crypto.php
 * @param stream resource <p>
 * ストリームリソース。
 * </p>
 * @param enable bool <p>
 * ストリームの暗号化を有効にするか無効にするか。
 * </p>
 * @param crypto_type int[optional] <p>
 * ストリームの暗号化の設定。以下の方法が使用できます。
 * STREAM_CRYPTO_METHOD_SSLv2_CLIENT
 * @param session_stream resource[optional] <p>
 * ストリームで session_stream からの設定を送信します。
 * </p>
 * @return mixed 成功した場合に TRUE、ネゴシエーションに失敗した場合に FALSE、
 * 十分なデータがないために再試行が必要な場合（非ブロックモード時のみ）
 * に 0 を返します。
 */
function stream_socket_enable_crypto ($stream, $enable, $crypto_type = null, $session_stream = null) {}

/**
 * 全二重接続を終了する
 * @link http://www.php.net/manual/ja/function.stream-socket-shutdown.php
 * @param stream resource <p>
 * オープンしているストリーム (たとえば stream_socket_client
 * でオープンしたものなど)。
 * </p>
 * @param how int <p>
 * 以下の定数のいずれか。STREAM_SHUT_RD
 * (それ以降の受信を無効にする)、STREAM_SHUT_WR
 * (それ以降の送信を無効にする) あるいは
 * STREAM_SHUT_RDWR (それ以降の送受信を無効にする)。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function stream_socket_shutdown ($stream, $how) {}

/**
 * 接続された、区別できないソケットストリームの組を作成する
 * @link http://www.php.net/manual/ja/function.stream-socket-pair.php
 * @param domain int <p>
 * 使用するプロトコルファミリー。STREAM_PF_INET、
 * STREAM_PF_INET6 あるいは
 * STREAM_PF_UNIX
 * </p>
 * @param type int <p>
 * 使用する接続の型。
 * STREAM_SOCK_DGRAM、
 * STREAM_SOCK_RAW、
 * STREAM_SOCK_RDM、
 * STREAM_SOCK_SEQPACKET あるいは
 * STREAM_SOCK_STREAM
 * </p>
 * @param protocol int <p>
 * 使用するプロトコル。STREAM_IPPROTO_ICMP、
 * STREAM_IPPROTO_IP、
 * STREAM_IPPROTO_RAW、
 * STREAM_IPPROTO_TCP あるいは
 * STREAM_IPPROTO_UDP
 * </p>
 * @return array 成功した場合に 2 つのソケットリソースの配列、失敗した場合に FALSE を返します。
 */
function stream_socket_pair ($domain, $type, $protocol) {}

/**
 * データをあるストリームから別のストリームにコピーする
 * @link http://www.php.net/manual/ja/function.stream-copy-to-stream.php
 * @param source resource <p>
 * コピー元のストリーム。
 * </p>
 * @param dest resource <p>
 * コピー先のストリーム。
 * </p>
 * @param maxlength int[optional] <p>
 * コピーする最大バイト数。
 * </p>
 * @param offset int[optional] <p>
 * コピーを開始する位置。
 * </p>
 * @return int コピーされたバイト数を返します。
 */
function stream_copy_to_stream ($source, $dest, $maxlength = null, $offset = null) {}

/**
 * 残りのストリームを文字列に読み込む
 * @link http://www.php.net/manual/ja/function.stream-get-contents.php
 * @param handle resource <p>
 * ストリームリソース（例: fopen の返す値）。
 * </p>
 * @param maxlength int[optional] <p>
 * 読み込む最大バイト数。デフォルトは -1
 * （バッファの残りのデータをすべて読み込む）。
 * </p>
 * @param offset int[optional] <p>
 * 読み込みを開始する前に移動する位置。負の数を指定した場合は移動が発生せず、
 * 現在位置から読み込みを開始します。
 * </p>
 * @return string 文字列を返します。失敗した場合に FALSE を返します。
 */
function stream_get_contents ($handle, $maxlength = null, $offset = null) {}

/**
 * ストリームがロックをサポートしているかどうかを調べる
 * @link http://www.php.net/manual/ja/function.stream-supports-lock.php
 * @param stream resource <p>
 * 調べたいストリーム。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function stream_supports_lock ($stream) {}

/**
 * ファイルポインタから行を取得し、CSVフィールドを処理する
 * @link http://www.php.net/manual/ja/function.fgetcsv.php
 * @param handle resource <p>
 * ファイルポインタは有効なものでなければならず、また
 * fopen,
 * popen, もしくは fsockopen
 * で正常にオープンされたファイルを指している必要があります。
 * </p>
 * @param length int[optional] <p>
 * (行末文字を考慮して) CSV
 * ファイルにある最も長い行よりも大きい必要があります。
 * PHP 5 でオプションになりました。このパラメータを省略
 * (もしくは PHP 5.0.4 かそれ以降で 0 を設定) すると、
 * 最大行長は制限されません。この場合、若干動作が遅くなります。
 * </p>
 * @param delimiter string[optional] <p>
 * フィールドのデリミタ (1 文字のみ) を設定します。
 * </p>
 * @param enclosure string[optional] <p>
 * フィールド囲いこみ文字 (1 文字のみ) を設定します。
 * </p>
 * @param escape string[optional] <p>
 * エスケープ文字 (1 文字のみ) を設定します。
 * </p>
 * @return array 読み込んだフィールドの内容を含む数値添字配列を返します。
 * </p>
 * <p>
 * CSV ファイルの空行は null
 * フィールドを一つだけ含む配列として返され、
 * エラーにはなりません。
 * </p>
 * マッキントッシュコンピュータ上で作成されたファイルを読み込む際に、
 * PHP が行末を認識できないという問題が発生した場合、
 * 実行時の設定オプションauto_detect_line_endings を有効にする必要が生じるかもしれません。
 * <p>
 * fgetcsv は、無効な handle
 * を受け取った場合に NULL を返します。
 * また、ファイルの終端に達した場合を含めたその他のエラー時には FALSE を返します。
 */
function fgetcsv ($handle, $length = null, $delimiter = null, $enclosure = null, $escape = null) {}

/**
 * 行を CSV 形式にフォーマットし、ファイルポインタに書き込む
 * @link http://www.php.net/manual/ja/function.fputcsv.php
 * @param handle resource ファイルポインタは、有効なファイルポインタである必要があり、
 * fopen または fsockopen で正常にオープンされた
 * （そしてまだ fclose でクローズされていない）
 * ファイルを指している必要があります。</p>
 * @param fields array <p>
 * 値の配列。
 * </p>
 * @param delimiter string[optional] <p>
 * オプションの delimiter はフィールド区切り文字
 * (一文字だけ) を指定します。
 * </p>
 * @param enclosure string[optional] <p>
 * オプションの enclosure はフィールドを囲む文字
 * (一文字だけ) を指定します。
 * </p>
 * @return int 書き込んだ文字列の長さを返します。失敗した場合に FALSE を返します。
 */
function fputcsv ($handle, array $fields, $delimiter = null, $enclosure = null) {}

/**
 * 汎用のファイルロックを行う
 * @link http://www.php.net/manual/ja/function.flock.php
 * @param handle resource fopen
 * を使用して作成したファイルシステムポインタリソース。</p>
 * @param operation int <p>
 * operation は以下のいずれかとなります。
 * 共有ロック(読み手)とするには
 * LOCK_SH
 * をセットします。
 * @param wouldblock int[optional] <p>
 * ロックがブロックされた (errno が EWOULDBLOCK となった)
 * 場合に、オプションの 3 番目の引数に TRUE が設定されます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function flock ($handle, $operation, &$wouldblock = null) {}

/**
 * ファイル上のすべてのメタタグ情報を配列に展開する
 * @link http://www.php.net/manual/ja/function.get-meta-tags.php
 * @param filename string <p>
 * HTML ファイルへのパスを表す文字列。
 * ローカルファイルのほか URL も指定できます。
 * </p>
 * <p>
 * get_meta_tags が何をパースするのか
 * ]]>
 * (改行コードに注意してください。PHP は入力をパースするためにネイティブ関数を使用するため、
 * Macintosh のファイルは Unix 上では動作しません)。
 * </p>
 * @param use_include_path bool[optional] <p>
 * use_include_path を TRUE に指定すると、
 * include_path
 * ディレクティブの内容にしたがってファイルを探します。
 * これはローカルファイルにのみ有効で、URL の場合は使用できません。
 * </p>
 * @return array パースされたメタタグを含む配列を返します。
 * </p>
 * <p>
 * name 属性の値が配列のキーとなります。content 属性の値が配列の要素となります。
 * 標準の配列関数を利用することでこれらの値に簡単にアクセスすることができます。
 * name 属性で特別な文字が使われている場合は '_' で代用されます。
 * それ以外は小文字に変換されます。もしも同じ名前のメタタグがある場合には
 * 最後のもののみが返されます。
 */
function get_meta_tags ($filename, $use_include_path = null) {}

/**
 * 指定したストリームのファイル読み込みバッファリングを有効にする
 * @link http://www.php.net/manual/ja/function.stream-set-read-buffer.php
 * @param stream resource <p>
 * ファイルポインタ。
 * </p>
 * @param buffer int <p>
 * バッファのバイト数。
 * buffer が 0 であれば、読み込み操作はバッファされなくなります。
 * これにより、fread による読み込み操作が完了するまでは
 * 他のプロセスが同じ入力ストリームから読み込み操作をできないことが保証されます。
 * </p>
 * @return int 成功時に 0 を、要求通りに設定できなかった場合は EOF を返します。
 */
function stream_set_read_buffer ($stream, $buffer) {}

/**
 * 指定されたストリームのファイル書き込みバッファリングを有効にする
 * @link http://www.php.net/manual/ja/function.stream-set-write-buffer.php
 * @param stream resource <p>
 * ファイルポインタ。
 * </p>
 * @param buffer int <p>
 * バッファのバイト数。
 * buffer が 0 であれば、書き込み操作はバッファされなくなります。
 * これにより、fwrite による書き込み操作が、他の
 * プロセスが同じ出力ストリームに対して何らかの書き込み操作を行う前に
 * 完了することが保証されます。
 * </p>
 * @return int 成功時に 0 を、要求通りに設定できなかった場合は EOF を返します。
 */
function stream_set_write_buffer ($stream, $buffer) {}

/**
 * <function>stream_set_write_buffer</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.set-file-buffer.php
 * @param fp
 * @param buffer
 */
function set_file_buffer ($fp, $buffer) {}

/**
 * <function>stream_set_blocking</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.set-socket-blocking.php
 * @param socket
 * @param mode
 */
function set_socket_blocking ($socket, $mode) {}

/**
 * ストリームのブロックモードを有効にする / 解除する
 * @link http://www.php.net/manual/ja/function.stream-set-blocking.php
 * @param stream resource <p>
 * ストリーム。
 * </p>
 * @param mode int <p>
 * mode が 0 の時、ストリームは
 * 非ブロックモードに切り替えられ、1 の場合は、
 * ブロックモードに切り替えられます。このモードの違いは、
 * fgets や fread
 * といった、ストリームからデータを読む関数に影響します。
 * 非ブロックモードにおいては fgets を呼び出すと
 * どんな場合でもただちに呼び出し元に戻りますが、ブロックモードの場合では、
 * ストリームがデータを読み出せる状態になるまで待ちつづけます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function stream_set_blocking ($stream, $mode) {}

/**
 * <function>stream_set_blocking</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.socket-set-blocking.php
 * @param socket
 * @param mode
 */
function socket_set_blocking ($socket, $mode) {}

/**
 * ヘッダーあるいはメタデータをストリームまたはファイルポインタから取得する
 * @link http://www.php.net/manual/ja/function.stream-get-meta-data.php
 * @param stream resource <p>
 * ストリームは fopen か、
 * fsockopen か、pfsockopen で
 * 作成されたいずれのものも指定できます。
 * </p>
 * @return array 結果の配列は次のような項目を含みます。
 * </p>
 * <p>
 * timed_out (bool) - 最後に
 * fread または fgets
 * でデータを待っている時にタイムアウトした場合 TRUE を返します。
 * </p>
 * <p>
 * blocked (bool) -
 * ストリームがブロック I/O モードの場合に TRUE となります。
 * stream_set_blocking を参照ください。
 * </p>
 * <p>
 * eof (bool) - ストリームが EOF に
 * 達した時 TRUE となります。
 * ストリームがソケットベースの場合、このメンバーは、
 * たとえ unread_bytes が 0 でなくても
 * TRUE になる場合があることに注意してください。
 * まだデータがあるかどうかを調べるには、このパラメータではなく、
 * feof を使ってください。
 * </p>
 * <p>
 * unread_bytes (int) - PHP の
 * 内部バッファにあるデータのバイト数。
 * </p>
 * スクリプト中でこの値を使用してはいけません。
 * <p>
 * stream_type (string) -
 * ストリームの下層にある実装を表すラベル
 * </p>
 * <p>
 * wrapper_type (string) -
 * ストリームを覆うプロトコルラッパーを表すラベル。
 * ラッパーについては を参照ください。
 * </p>
 * <p>
 * wrapper_data (mixed) -
 * ストリームに付随しているラッパーの固有のデータ。
 * ラッパーとその固有の情報については、
 * を参照ください。
 * </p>
 * <p>
 * filters (array) -
 * ストリームに付加されているフィルタの名称を格納した配列。
 * フィルタに関するドキュメントは
 * 利用できるフィルタのリスト にあります。
 * </p>
 * <p>
 * mode (string) - このストリームに要求される
 * アクセスモード（fopen()
 * リファレンスの表 1 を参照ください）。
 * </p>
 * <p>
 * seekable (bool) - 現在のストリーム内で
 * 移動が可能かどうか。
 * </p>
 * <p>
 * uri (string) - このストリームに関連付けられた
 * URI / ファイル名。
 */
function stream_get_meta_data ($stream) {}

/**
 * 指定されたデリミタの位置までのデータを一行分としてストリームから読み込む
 * @link http://www.php.net/manual/ja/function.stream-get-line.php
 * @param handle resource <p>
 * 有効なファイルハンドル。
 * </p>
 * @param length int <p>
 * ハンドルから読み込むバイト数。
 * </p>
 * @param ending string[optional] <p>
 * オプションのデリミタ文字列。
 * </p>
 * @return string 最大 length バイトの、
 * handle で指定されたリソースから読み込んだデータを返します。
 * </p>
 * <p>
 * エラーが発生した際には、FALSE を返します。
 */
function stream_get_line ($handle, $length, $ending = null) {}

/**
 * PHP のクラスとして実装された URL ラッパーを登録する
 * @link http://www.php.net/manual/ja/function.stream-wrapper-register.php
 * @param protocol string <p>
 * 登録したいラッパー名。
 * </p>
 * @param classname string <p>
 * protocol を実装したクラス名。
 * </p>
 * @param flags int[optional] <p>
 * protocol が URL プロトコルである場合は
 * STREAM_IS_URL を設定しなければなりません。
 * デフォルトは 0 で、ローカルストリームを意味します。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * stream_wrapper_register は、
 * protocol というハンドラが既にある場合、
 * FALSE を返します。
 */
function stream_wrapper_register ($protocol, $classname, $flags = null) {}

/**
 * <function>stream_wrapper_register</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.stream-register-wrapper.php
 * @param protocol
 * @param classname
 * @param flags[optional]
 */
function stream_register_wrapper ($protocol, $classname, $flags) {}

/**
 * URL ラッパーの登録を解除する
 * @link http://www.php.net/manual/ja/function.stream-wrapper-unregister.php
 * @param protocol string <p>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function stream_wrapper_unregister ($protocol) {}

/**
 * 事前に登録を解除された組み込みラッパーを復元する
 * @link http://www.php.net/manual/ja/function.stream-wrapper-restore.php
 * @param protocol string <p>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function stream_wrapper_restore ($protocol) {}

/**
 * 登録されているストリームのラッパーのリストを取得する
 * @link http://www.php.net/manual/ja/function.stream-get-wrappers.php
 * @return array スクリプトを走らせているシステム上で使うことのできるすべてのストリーム
 * ラッパーの名前を配列の形で返します。
 */
function stream_get_wrappers () {}

/**
 * 登録されたソケットのトランスポートの一覧を取得する
 * @link http://www.php.net/manual/ja/function.stream-get-transports.php
 * @return array ソケットのトランスポート名の配列を返します。
 */
function stream_get_transports () {}

/**
 * インクルードパスに対してファイル名を解決する
 * @link http://www.php.net/manual/ja/function.stream-resolve-include-path.php
 * @param filename string <p>
 * 解決するファイル名。
 * </p>
 * @param context resource[optional] <p>
 * stream_context_create で作成したコンテキストリソース。
 * </p>
 * @return string 解決したファイル名を含む文字列を返します。失敗した場合に FALSE を返します。
 */
function stream_resolve_include_path ($filename, $context = null) {}

/**
 * ローカルストリームかどうかを調べる
 * @link http://www.php.net/manual/ja/function.stream-is-local.php
 * @param stream_or_url mixed <p>
 * 調べたいストリームリソースあるいは URL。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function stream_is_local ($stream_or_url) {}

/**
 * HTTP リクエストに対するレスポンス内で
   サーバーによって送出された全てのヘッダを取得する
 * @link http://www.php.net/manual/ja/function.get-headers.php
 * @param url string <p>
 * 対象となる URL。
 * </p>
 * @param format int[optional] <p>
 * オプションの format パラメータが
 * ゼロ以外にセットされた場合、get_headers
 * はレスポンスをパースし、配列のキーをセットします。
 * </p>
 * @return array 数値添字配列あるいは連想配列でヘッダを返します。
 * 失敗した場合は FALSE を返します。
 */
function get_headers ($url, $format = null) {}

/**
 * ストリームにタイムアウトを設定する
 * @link http://www.php.net/manual/ja/function.stream-set-timeout.php
 * @param stream resource <p>
 * 対象となるストリーム。
 * </p>
 * @param seconds int <p>
 * 設定したいタイムアウトの秒数部分。
 * </p>
 * @param microseconds int[optional] <p>
 * 設定したいタイムアウトのマイクロ秒数部分。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function stream_set_timeout ($stream, $seconds, $microseconds = null) {}

/**
 * <function>stream_set_timeout</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.socket-set-timeout.php
 * @param stream
 * @param seconds
 * @param microseconds
 */
function socket_set_timeout ($stream, $seconds, $microseconds) {}

/**
 * <function>stream_get_meta_data</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.socket-get-status.php
 * @param fp
 */
function socket_get_status ($fp) {}

/**
 * 絶対パス名を返す
 * @link http://www.php.net/manual/ja/function.realpath.php
 * @param path string <p>
 * 調べたいパス。
 * </p>
 * <p>
 * path の指定は必須ですが、空白や NULL を指定することもできます。
 * その場合はカレントディレクトリを指定したものとみなします。
 * </p>
 * @return string 成功した場合は正規化した絶対パス名を返します。
 * 返されるパスはシンボリックリンクや「/./」「/../」要素を含みません。
 * </p>
 * <p>
 * realpath は、
 * たとえばファイルが存在しないなどの失敗時に FALSE を返します。
 * </p>
 * <p>
 * 指定した階層にあるすべてのディレクトリに対して、
 * 実行中のスクリプトからの実行権限が必要です。もし権限がなければ
 * realpath は FALSE を返します。
 */
function realpath ($path) {}

/**
 * ファイル名がパターンにマッチするか調べる
 * @link http://www.php.net/manual/ja/function.fnmatch.php
 * @param pattern string <p>
 * シェルのワイルドカードパターン。
 * </p>
 * @param string string <p>
 * 調べたい文字列。この機能は特にファイル名のマッチに便利ですが、
 * 通常の文字列に関しても使用できます。
 * </p>
 * <p>
 * 一般的なユーザーにとって、シェルパターンやあるいは少なくとも
 * '?'と'*'によるワイルドカードのほうが
 * 慣れていると思われます。そのため、
 * preg_match
 * の代わりに fnmatch
 * をフロントエンドの検索表現として使うことは、
 * プログラマではないユーザーにとってより便利でしょう。
 * </p>
 * @param flags int[optional] <p>
 * flags の値は、以下のフラグを
 * 論理 OR (|) 演算子
 * で連結した任意の組み合わせです。
 * <table>
 * fnmatch で使えるフラグ
 * <tr valign="top">
 * <td>フラグ</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>FNM_NOESCAPE</td>
 * <td>
 * バックスラッシュのエスケープを無効にする。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>FNM_PATHNAME</td>
 * <td>
 * 文字列内のスラッシュは、指定したパターン内のスラッシュにのみマッチする。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>FNM_PERIOD</td>
 * <td>
 * 文字列の先頭のピリオドは、指定したパターン内のピリオドにマッチしなければならない。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>FNM_CASEFOLD</td>
 * <td>
 * 大文字小文字を区別しないマッチ。GNU 拡張の一部。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @return bool マッチした場合に TRUE、それ以外の場合に FALSE を返します。
 */
function fnmatch ($pattern, $string, $flags = null) {}

/**
 * インターネット接続もしくは Unix ドメインソケット接続をオープンする
 * @link http://www.php.net/manual/ja/function.fsockopen.php
 * @param hostname string <p>
 * OpenSSL サポートが インストール
 * されている場合、
 * hostname の前に ssl:// または
 * tls:// を付加することにより、TCP/IP
 * 経由でリモートホストに接続する際に SSL または
 * TLS クライアント接続を使用することができます。
 * </p>
 * @param port int[optional] <p>
 * ポート番号。
 * </p>
 * @param errno int[optional] <p>
 * 指定した場合は、システムコール connect()
 * で発生したエラーのエラー番号が格納されます。
 * </p>
 * <p>
 * errno は 0 なのに関数が
 * FALSE を返す場合、connect()
 * をコールする前にエラーを発生したことを示します。
 * この場合、おそらくはソケットの初期化に原因があります。
 * </p>
 * @param errstr string[optional] <p>
 * エラーメッセージを表す文字列。
 * </p>
 * @param timeout float[optional] <p>
 * 接続タイムアウト秒数。
 * </p>
 * <p>
 * ソケット経由でデータを読み書きする際のタイムアウトを設定する必要がある場合、
 * fsockopen の timeout パラメータは、
 * ソケットに接続する間にだけ適用されるため、
 * socket_set_timeout を使用してください。
 * </p>
 * @return resource fsockopenは、ファイルポインタを返します。
 * このファイルポインタは、
 * (fgets, fgetss,
 * fputs, fclose,
 * feof のような)
 * 他のファイル関数で使用可能です。
 * 失敗した場合は FALSE を返します。
 */
function fsockopen ($hostname, $port = null, &$errno = null, &$errstr = null, $timeout = null) {}

/**
 * 持続的な Internet または Unix ドメインソケット接続をオープンする
 * @link http://www.php.net/manual/ja/function.pfsockopen.php
 * @param hostname string 
 * @param port int[optional] 
 * @param errno int[optional] 
 * @param errstr string[optional] 
 * @param timeout float[optional] 
 * @return resource 
 */
function pfsockopen ($hostname, $port = null, &$errno = null, &$errstr = null, $timeout = null) {}

/**
 * データをバイナリ文字列にパックする
 * @link http://www.php.net/manual/ja/function.pack.php
 * @param format string <p>
 * フォーマット文字列は、
 * フォーマットコードの後にオプションの反復指定用引数が続く形式と
 * なっています。反復指定用引数として整数値、または入力データの最後まで
 * 反復を意味する * のどちらかを指定することができます。
 * a, A, h, H の場合、
 * 反復数はそのデータ引数が取得する文字の数を指定します。反復数が @ の場合、
 * 次のデータを置く場所の絶対位置を表します。その他の場合、反復数は
 * データ引数が使われる数を指定し、結果のバイナリ文字列にパックされます。
 * </p>
 * <p>
 * 現在、実装されているものを以下に示します。
 * <table>
 * pack の書式文字
 * <tr valign="top">
 * <td>コード</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>a</td>
 * <td>NUL で埋めた文字列</td>
 * </tr>
 * <tr valign="top">
 * <td>A</td>
 * <td>空白で埋めた文字列</td></tr>
 * <tr valign="top">
 * <td>h</td>
 * <td>十六進文字列、下位ニブルが先</td></tr>
 * <tr valign="top">
 * <td>H</td>
 * <td>十六進文字列、上位ニブルが先</td></tr>
 * <tr valign="top"><td>c</td><td>signed char</td></tr>
 * <tr valign="top">
 * <td>C</td>
 * <td>unsigned char</td></tr>
 * <tr valign="top">
 * <td>s</td>
 * <td>signed short (常に 16 ビット、マシンのバイトオーダー)</td>
 * </tr>
 * <tr valign="top">
 * <td>S</td>
 * <td>unsigned short (常に 16 ビット、マシンのバイトオーダー)</td>
 * </tr>
 * <tr valign="top">
 * <td>n</td>
 * <td>unsigned short (常に 16 ビット、ビッグエンディアンバイトオーダー)</td>
 * </tr>
 * <tr valign="top">
 * <td>v</td>
 * <td>unsigned short (常に 16 ビット、リトルエンディアンバイトオーダー)</td>
 * </tr>
 * <tr valign="top">
 * <td>i</td>
 * <td>signed integer (サイズおよびバイトオーダーはマシン依存)</td>
 * </tr>
 * <tr valign="top">
 * <td>I</td>
 * <td>unsigned integer (サイズおよびバイトオーダーはマシン依存)</td>
 * </tr>
 * <tr valign="top">
 * <td>l</td>
 * <td>signed long (常に 32 ビット、マシンのバイトオーダー)</td>
 * </tr>
 * <tr valign="top">
 * <td>L</td>
 * <td>unsigned long (常に 32 ビット、マシンのバイトオーダー)</td>
 * </tr>
 * <tr valign="top">
 * <td>N</td>
 * <td>unsigned long (常に 32 ビット、ビッグエンディアンバイトオーダー)</td>
 * </tr>
 * <tr valign="top">
 * <td>V</td>
 * <td>unsigned long (常に 32 ビット、リトルエンディアンバイトオーダー)</td>
 * </tr>
 * <tr valign="top">
 * <td>f</td>
 * <td>float (サイズおよび表現はマシン依存)</td>
 * </tr>
 * <tr valign="top">
 * <td>d</td>
 * <td>double (サイズおよび表現はマシン依存)</td>
 * </tr>
 * <tr valign="top">
 * <td>x</td>
 * <td>NUL バイト</td>
 * </tr>
 * <tr valign="top">
 * <td>X</td>
 * <td>1 バイト戻る</td>
 * </tr>
 * <tr valign="top">
 * <td>Z</td>
 * <td>NUL 埋め文字列 (PHP 5.5 以降)</td>
 * </tr>
 * <tr valign="top">
 * <td>@</td>
 * <td>絶対位置まで NUL で埋める</td>
 * </tr>
 * </table>
 * </p>
 * @param args mixed[optional] <p>
 * </p>
 * @param _ mixed[optional] 
 * @return string バイナリ文字列を含むデータを返します。
 */
function pack ($format, $args = null, $_ = null) {}

/**
 * バイナリ文字列からデータを切り出す
 * @link http://www.php.net/manual/ja/function.unpack.php
 * @param format string <p>
 * 書式コードの説明は pack を参照ください。
 * </p>
 * @param data string <p>
 * パックされたデータ。
 * </p>
 * @return array バイナリ文字列を切り出した要素を含む連想配列を返します。
 */
function unpack ($format, $data) {}

/**
 * ユーザーのブラウザの機能を取得する
 * @link http://www.php.net/manual/ja/function.get-browser.php
 * @param user_agent string[optional] <p>
 * 処理するユーザーエージェント。デフォルトでは、HTTP の User-Agent
 * ヘッダの内容を使用します。しかし、このパラメータを渡すことでこれを変更する
 * (別のブラウザの情報を取得する) ことが可能です。
 * </p>
 * <p>
 * このパラメータを処理しないようにするには NULL 値を渡します。
 * </p>
 * @param return_array bool[optional] <p>
 * TRUE を指定すると、この関数はオブジェクトでなく配列を返します。
 * </p>
 * @return mixed 情報は、オブジェクトあるいは配列形式で返されます。
 * たとえばブラウザのメジャーバージョン番号、マイナーバージョン番号や
 * ID 文字列といったさまざまなデータが含まれています。また、
 * フレームや JavaScript、クッキーといった機能についての
 * TRUE/FALSE 値も含んでいます。
 * </p>
 * <p>
 * cookies の値は、単にそのブラウザがクッキーを扱う機能を
 * 有していることを示すだけであり、ユーザーがクッキーを受け入れる設定に
 * しているかどうかを表すものではありません。それをチェックする唯一の方法は、
 * いったん setcookie でクッキーを設定してからリロードし、
 * その値を調べることです。
 */
function get_browser ($user_agent = null, $return_array = null) {}

/**
 * 文字列の一方向のハッシュ化を行う
 * @link http://www.php.net/manual/ja/function.crypt.php
 * @param str string <p>
 * ハッシュしたい文字列。
 * </p>
 * @param salt string[optional] <p>
 * ハッシュのもととなる salt 文字列。省略した場合の挙動は
 * アルゴリズムの実装によって決まるので、予期せぬ結果となることがあり得ます。
 * </p>
 * @return string ハッシュした文字列を返します。
 * 失敗した場合は、salt とは異なることが保証されている 13 文字未満の文字列を返します。
 */
function crypt ($str, $salt = null) {}

/**
 * ディレクトリハンドルをオープンする
 * @link http://www.php.net/manual/ja/function.opendir.php
 * @param path string <p>
 * オープンするディレクトリのパス。
 * </p>
 * @param context resource[optional] <p>
 * context パラメータの詳細については
 * マニュアルのストリーム
 * を参照ください。
 * </p>
 * @return resource 成功した場合にディレクトリハンドルの resource 、
 * 失敗した場合に FALSE を返します。
 * </p> 
 * <p>
 * path が有効なディレクトリでないかまたは権限が
 * 制限されているかファイルシステムのエラーによりディレクトリが
 * オープンできない場合、opendir は FALSE を返し、
 * E_WARNING エラーが発行されます。
 * opendir のこのエラー出力は、
 * 関数名の前に '@'
 * を付けることにより抑制できます。
 */
function opendir ($path, $context = null) {}

/**
 * ディレクトリハンドルをクローズする
 * @link http://www.php.net/manual/ja/function.closedir.php
 * @param dir_handle resource[optional] <p>
 * opendir が事前にオープンした
 * ディレクトリハンドルリソース。
 * ディレクトリハンドルを指定しなかった場合は、
 * opendir が最後にオープンしたものを使用します。
 * </p>
 * @return void 
 */
function closedir ($dir_handle = null) {}

/**
 * ディレクトリを変更する
 * @link http://www.php.net/manual/ja/function.chdir.php
 * @param directory string <p>
 * 新しいカレントディレクトリ
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function chdir ($directory) {}

/**
 * カレントのワーキングディレクトリを取得する
 * @link http://www.php.net/manual/ja/function.getcwd.php
 * @return string 成功時はカレントのワーキングディレクトリを返します。
 * 失敗時は FALSE を返します。
 * </p>
 * <p>
 * いくつかの UNIX の派生系では、親ディレクトリが読み込めない、
 * もしくは検索モードが設定されている場合、カレントディレクトリが可能だとしても
 * getcwd は FALSE を返します。
 * モードと権限についての詳細は、chmod を参照ください。
 */
function getcwd () {}

/**
 * ディレクトリハンドルを元に戻す
 * @link http://www.php.net/manual/ja/function.rewinddir.php
 * @param dir_handle resource[optional] <p>
 * opendir が事前にオープンした
 * ディレクトリハンドルリソース。
 * ディレクトリハンドルを指定しなかった場合は、
 * opendir が最後にオープンしたものを使用します。
 * </p>
 * @return void 
 */
function rewinddir ($dir_handle = null) {}

/**
 * ディレクトリハンドルからエントリを読み込む
 * @link http://www.php.net/manual/ja/function.readdir.php
 * @param dir_handle resource[optional] <p>
 * opendir が事前にオープンした
 * ディレクトリハンドルリソース。
 * ディレクトリハンドルを指定しなかった場合は、
 * opendir が最後にオープンしたものを使用します。
 * </p>
 * @return string 成功した場合にエントリ名、失敗した場合に FALSE を返します。
 */
function readdir ($dir_handle = null) {}

/**
 * ディレクトリクラスのインスタンスを返す
 * @link http://www.php.net/manual/ja/function.dir.php
 * @param directory string <p>
 * オープンするディレクトリ。
 * </p>
 * @param context resource[optional] <p>
 * コンテキストのサポートは、
 * PHP 5.0.0 で追加されました。contexts の説明に関しては、
 * を参照してください。
 * </p>
 * @return Directory Directory のインスタンスを返します。
 * パラメータが間違っている場合は NULL、それ以外のエラーの場合は
 * FALSE を返します。
 */
function dir ($directory, $context = null) {}

/**
 * 指定されたパスのファイルとディレクトリのリストを取得する
 * @link http://www.php.net/manual/ja/function.scandir.php
 * @param directory string <p>
 * 調べるディレクトリ。
 * </p>
 * @param sorting_order int[optional] <p>
 * デフォルトでは、ソート順はアルファベット昇順です。
 * オプションの sorting_order
 * に SCANDIR_SORT_DESCENDING を設定した場合、
 * ソート順はアルファベット降順になります。
 * SCANDIR_SORT_NONE を設定すると、
 * 結果をソートせずに返します。
 * </p>
 * @param context resource[optional] <p>
 * context パラメータの説明については、
 * マニュアルのストリーム
 * を参照ください。
 * </p>
 * @return array 成功した場合にファイル名の配列、失敗した場合に FALSE を返します。
 * directory がディレクトリではない場合は、
 * FALSE を返し、E_WARNING レベルのエラーを
 * 発行します。
 */
function scandir ($directory, $sorting_order = null, $context = null) {}

/**
 * パターンにマッチするパス名を探す
 * @link http://www.php.net/manual/ja/function.glob.php
 * @param pattern string <p>
 * パターン。チルダの展開やパラメータ置換は行いません。
 * </p>
 * @param flags int[optional] <p>
 * 有効なフラグは次のとおりです。
 * GLOB_MARK - 各ディレクトリにスラッシュを追加します
 * @return array マッチするファイル／ディレクトリを含む配列を返します。
 * マッチするファイルがなかった場合には空の配列、
 * そして失敗した場合には FALSE を返します。
 * </p>
 * <p>
 * システムによっては、何もマッチしなかった場合とエラーが発生した場合を区別できないものもあります。
 */
function glob ($pattern, $flags = null) {}

/**
 * ファイルの最終アクセス時刻を取得する
 * @link http://www.php.net/manual/ja/function.fileatime.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @return int ファイルの最終アクセス時刻を返し、失敗した場合に FALSE を返します。
 * 時間は Unix タイムスタンプとして返されます。
 */
function fileatime ($filename) {}

/**
 * ファイルの inode 変更時刻を取得する
 * @link http://www.php.net/manual/ja/function.filectime.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @return int ファイルの最終更新時刻を返し、失敗した場合に FALSE を返します。
 * 時間は Unix タイムスタンプとして返されます。
 */
function filectime ($filename) {}

/**
 * ファイルのグループを取得する
 * @link http://www.php.net/manual/ja/function.filegroup.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @return int ファイルの所有者のグループ ID を返し、エラーの場合は FALSE を返します。
 * グループ ID は数値で返されます。グループ名に変換するには
 * posix_getgrgid を使用してください。
 * 失敗すると FALSE を返します。
 */
function filegroup ($filename) {}

/**
 * ファイルの inode を取得する
 * @link http://www.php.net/manual/ja/function.fileinode.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @return int ファイルの inode 番号を返し、失敗した場合に FALSE を返します。
 */
function fileinode ($filename) {}

/**
 * ファイルの更新時刻を取得する
 * @link http://www.php.net/manual/ja/function.filemtime.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @return int ファイルの最終更新時刻を返し、失敗した場合に FALSE を返します
 * 時間は Unix タイムスタンプとして返されます。
 * この関数の結果は date 等で使用できます。
 */
function filemtime ($filename) {}

/**
 * ファイルの所有者を取得する
 * @link http://www.php.net/manual/ja/function.fileowner.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @return int ファイルの所有者のユーザー ID を返し、失敗した場合に FALSE を返します。
 * ユーザー ID は数値で返されます。ユーザー名に変換するには
 * posix_getpwuid を使用してください。
 */
function fileowner ($filename) {}

/**
 * ファイルのパーミッションを取得する
 * @link http://www.php.net/manual/ja/function.fileperms.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @return int ファイルのパーミッションを数値モードで返します。このモードの下位ビットは
 * chmod に渡すのと同じ形式です。
 * しかし、大半のプラットフォームでは、それだけではなく
 * filename のファイル形式に関する情報も含まれます。
 * 以下の例で示すのは、ファイルのパーミッションやファイル形式を
 * POSIX システム (Linux や Mac OS X など) で調べる方法です。
 * </p>
 * <p>
 * ローカルファイルの場合、その返り値は C ライブラリ関数 stat
 * が返す構造体の st_mode メンバーの値となります。
 * どのビットがセットされるかはプラットフォームによって異なるので、
 * パーミッション部分以外のビットをパースしたい場合は各プラットフォームのドキュメントを参照することをおすすめします。
 */
function fileperms ($filename) {}

/**
 * ファイルのサイズを取得する
 * @link http://www.php.net/manual/ja/function.filesize.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @return int ファイルのサイズを返し、エラーの場合は FALSE を返します
 * (また E_WARNING レベルのエラーを発生させます) 。
 */
function filesize ($filename) {}

/**
 * ファイルタイプを取得する
 * @link http://www.php.net/manual/ja/function.filetype.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @return string ファイルのタイプを返します。返される値は fifo、char、dir、
 * block、link、file、socket および unknown のいずれかです。
 * </p>
 * <p>
 * エラーが発生すると FALSE を返します。
 * また filetype は stat コールに失敗したり、
 * 未知のファイルタイプであったりした場合に
 * E_NOTICE メッセージを発行します。
 */
function filetype ($filename) {}

/**
 * ファイルまたはディレクトリが存在するかどうか調べる
 * @link http://www.php.net/manual/ja/function.file-exists.php
 * @param filename string <p>
 * ファイルあるいはディレクトリへのパス。
 * </p>
 * <p>
 * Windows 上でネットワーク共有上のファイルを調べるには、
 * //computername/share/filename または
 * \\computername\share\filename のように指定してください。
 * </p>
 * @return bool filename で指定したファイルまたはディレクトリが存在すれば
 * TRUE を返し、そうでなければ FALSE を返します。
 * </p>
 * <p>
 * この関数は、シンボリックリンクの指す先のファイルが存在しない場合は
 * FALSE を返します。
 * </p>
 * <p>
 * この関数は セーフモード
 * の制限のためファイルにアクセスできない場合 FALSE を返します。
 * しかし safe_mode_include_dir
 * で指定されたディレクトリに存在する場合は
 * include
 * することができます。
 * </p>
 * <p>
 * チェックは、実効ユーザーではなく実ユーザーの UID/GID
 * で行います。
 */
function file_exists ($filename) {}

/**
 * ファイルが書き込み可能かどうかを調べる
 * @link http://www.php.net/manual/ja/function.is-writable.php
 * @param filename string <p>
 * 調べたいファイル名。
 * </p>
 * @return bool filename が存在して書き込み可能な場合に
 * TRUE を返します。
 */
function is_writable ($filename) {}

/**
 * <function>is_writable</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.is-writeable.php
 * @param filename
 */
function is_writeable ($filename) {}

/**
 * ファイルが存在し、読み込み可能であるかどうかを知る
 * @link http://www.php.net/manual/ja/function.is-readable.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @return bool filename
 * で指定したファイルあるいはディレクトリが存在し、
 * それが読み込み可能であれば TRUE、それ以外の場合に
 * FALSE を返します。
 */
function is_readable ($filename) {}

/**
 * ファイルが実行可能かどうかを調べる
 * @link http://www.php.net/manual/ja/function.is-executable.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @return bool ファイルが存在し、かつそれが実行可能な場合に TRUE、
 * エラー時に FALSE を返します。
 */
function is_executable ($filename) {}

/**
 * 通常ファイルかどうかを調べる
 * @link http://www.php.net/manual/ja/function.is-file.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @return bool ファイルが存在し、かつそれが通常のファイルである場合に TRUE、
 * それ以外の場合に FALSE を返します。
 */
function is_file ($filename) {}

/**
 * ファイルがディレクトリかどうかを調べる
 * @link http://www.php.net/manual/ja/function.is-dir.php
 * @param filename string <p>
 * ファイルへのパス。filename
 * が相対パスの場合は、現在の作業ディレクトリからの相対パスとして処理します。
 * filename がシンボリックリンクあるいはハードリンクの場合は、
 * リンク先を解決して処理します。セーフモード あるいは
 * open_basedir を有効にすると、
 * さらに制限がかかるでしょう。
 * </p>
 * @return bool ファイルが存在して、かつそれがディレクトリであれば
 * TRUE、それ以外の場合は FALSE を返します。
 */
function is_dir ($filename) {}

/**
 * ファイルがシンボリックリンクかどうかを調べる
 * @link http://www.php.net/manual/ja/function.is-link.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @return bool filename が存在し、かつシンボリックリンクであれば TRUE、
 * それ以外の場合に FALSE を返します。
 */
function is_link ($filename) {}

/**
 * ファイルに関する情報を取得する
 * @link http://www.php.net/manual/ja/function.stat.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @return array <table>
 * stat と fstat
 * の結果のフォーマット
 * <tr valign="top">
 * <td>数値</td>
 * <td>連想 (PHP 4.0.6 以上)</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>0</td>
 * <td>dev</td>
 * <td>デバイス番号</td>
 * </tr>
 * <tr valign="top">
 * <td>1</td>
 * <td>ino</td>
 * <td>inode 番号(*)</td>
 * </tr>
 * <tr valign="top">
 * <td>2</td>
 * <td>mode</td>
 * <td>inode プロテクトモード</td>
 * </tr>
 * <tr valign="top">
 * <td>3</td>
 * <td>nlink</td>
 * <td>リンク数</td>
 * </tr>
 * <tr valign="top">
 * <td>4</td>
 * <td>uid</td>
 * <td>所有者のユーザー ID(*)</td>
 * </tr>
 * <tr valign="top">
 * <td>5</td>
 * <td>gid</td>
 * <td>所有者のグループ ID(*)</td>
 * </tr>
 * <tr valign="top">
 * <td>6</td>
 * <td>rdev</td>
 * <td>inode デバイス の場合、デバイスの種類</td>
 * </tr>
 * <tr valign="top">
 * <td>7</td>
 * <td>size</td>
 * <td>バイト単位のサイズ</td>
 * </tr>
 * <tr valign="top">
 * <td>8</td>
 * <td>atime</td>
 * <td>最終アクセス時間 (Unix タイムスタンプ)</td>
 * </tr>
 * <tr valign="top">
 * <td>9</td>
 * <td>mtime</td>
 * <td>最終修正時間 (Unix タイムスタンプ)</td>
 * </tr>
 * <tr valign="top">
 * <td>10</td>
 * <td>ctime</td>
 * <td>最終 inode 変更時間 (Unix タイムスタンプ)</td>
 * </tr>
 * <tr valign="top">
 * <td>11</td>
 * <td>blksize</td>
 * <td>ファイル IO のブロックサイズ(**)</td>
 * </tr>
 * <tr valign="top">
 * <td>12</td>
 * <td>blocks</td>
 * <td>512 バイトのブロックの確保数(**)</td>
 * </tr>
 * </table>
 * * Windows では常に 0 となります。
 * </p>
 * <p>
 * ** st_blksize タイプをサポートするシステムでのみ有効です。
 * その他のシステム(例えば Windows)では -1 を返します。
 * </p>
 * <p>
 * stat はエラーの場合 FALSE を返します。
 */
function stat ($filename) {}

/**
 * ファイルあるいはシンボリックリンクの情報を取得する
 * @link http://www.php.net/manual/ja/function.lstat.php
 * @param filename string <p>
 * ファイルあるいはシンボリックリンクへのパス。
 * </p>
 * @return array lstat が返す配列の内容については
 * stat のマニュアルをご覧ください。
 * この関数の動作は stat 関数と同じですが、
 * パラメータ filename
 * がシンボリックリンクであった場合に、
 * シンボリック先のファイルのステータスではなく、
 * シンボリックリンクのステータスが返されるところが異なります。
 */
function lstat ($filename) {}

/**
 * ファイルの所有者を変更する
 * @link http://www.php.net/manual/ja/function.chown.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @param user mixed <p>
 * ユーザー名あるいはユーザー番号。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function chown ($filename, $user) {}

/**
 * ファイルのグループを変更する
 * @link http://www.php.net/manual/ja/function.chgrp.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @param group mixed <p>
 * グループ名あるいはグループ番号。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function chgrp ($filename, $group) {}

/**
 * ファイルのモードを変更する
 * @link http://www.php.net/manual/ja/function.chmod.php
 * @param filename string <p>
 * ファイルへのパス。
 * </p>
 * @param mode int <p>
 * mode
 * は自動的には 8 進数と見なされないので注意してください。
 * このため、("g+w" のような)文字列は正常に動作しません。
 * 意図した操作を行うには、mode
 * の前にゼロ(0)を付ける必要があります。
 * </p>
 * <p>
 * ]]>
 * </p>
 * <p>
 * mode 引数は 3 つの 8 進法による数値で構成され、
 * 所有者自身、所有者が属するグループ、その他のユーザーの順で
 * アクセス制限を設定します。一つ一つの数字はそのターゲットに対し
 * 許可を与えます。1 は実行権限、2 はファイルに対する書き込み権限、
 * 4 はファイルに対する読み込み権限を与えます。
 * 必要な権限にあわせ数値を加算してください。
 * 許可モードに関する詳細は Unix システムの
 * 「man 1 chmod」や「man 2 chmod」をご覧ください。
 * </p>
 * <p>
 * ]]>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function chmod ($filename, $mode) {}

/**
 * ファイルの最終アクセス時刻および最終更新日をセットする
 * @link http://www.php.net/manual/ja/function.touch.php
 * @param filename string <p>
 * 処理したいファイルの名前。
 * </p>
 * @param time int[optional] <p>
 * 設定する時刻。
 * time を省略した場合は、
 * 現在時刻を使用します。
 * </p>
 * @param atime int[optional] <p>
 * 指定されたファイルの最終アクセス時刻が存在する場合は、
 * その値が atime にセットされます。
 * 存在しない場合は time に渡した値となります。
 * どちらも存在しない場合は、現在のシステム時刻を使います。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function touch ($filename, $time = null, $atime = null) {}

/**
 * ファイルのステータスのキャッシュをクリアする
 * @link http://www.php.net/manual/ja/function.clearstatcache.php
 * @param clear_realpath_cache bool[optional] <p>
 * realpath キャッシュをクリアするか否か。
 * </p>
 * @param filename string[optional] <p>
 * realpath キャッシュと stat キャッシュを特定のファイル名だけに対してクリアする。
 * clear_realpath_cache が TRUE
 * の場合にのみ使用。
 * </p>
 * @return void 値を返しません。
 */
function clearstatcache ($clear_realpath_cache = null, $filename = null) {}

/**
 * ファイルシステムあるいはディスクパーティションの全体サイズを返す
 * @link http://www.php.net/manual/ja/function.disk-total-space.php
 * @param directory string <p>
 * ファイルシステムのディレクトリあるいはディスクパーティション。
 * </p>
 * @return float 総バイト数を float 型で返します。
 * 失敗した場合に FALSE を返します。
 */
function disk_total_space ($directory) {}

/**
 * ファイルシステムあるいはディスクパーティション上で利用可能な領域を返す
 * @link http://www.php.net/manual/ja/function.disk-free-space.php
 * @param directory string <p>
 * ファイルシステムのディレクトリあるいはディスクパーティション。
 * </p>
 * <p>
 * ディレクトリのかわりにファイル名を指定したときの挙動は未定義です。
 * OS や PHP のバージョンによって結果は異なります。
 * </p>
 * @return float 利用可能なバイト数を float 型で返します。
 * 失敗した場合に FALSE を返します。
 */
function disk_free_space ($directory) {}

/**
 * <function>disk_free_space</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.diskfreespace.php
 * @param path
 */
function diskfreespace ($path) {}

/**
 * realpath キャッシュサイズを取得
 * @link http://www.php.net/manual/ja/function.realpath-cache-size.php
 * @return int realpath キャッシュが使用中のメモリ量を返します。
 */
function realpath_cache_size () {}

/**
 * realpath キャッシュ・エントリーを取得
 * @link http://www.php.net/manual/ja/function.realpath-cache-get.php
 * @return array realpath キャッシュ・エントリーの配列を返します。キーは元のパス・エントリーで、
 * 値はデータ項目の配列です。それには、解決されたパス、失効日、キャッシュに保持されるその他のオプションを含みます。
 */
function realpath_cache_get () {}

/**
 * メールを送信する
 * @link http://www.php.net/manual/ja/function.mail.php
 * @param to string <p>
 * メールの受信者。
 * </p>
 * <p>
 * RFC 2822 を満たす書式でなければ
 * なりません。例えば以下のようなものです。
 * user@example.com
 * user@example.com, anotheruser@example.com
 * User &lt;user@example.com&gt;
 * User &lt;user@example.com&gt;, Another User &lt;anotheruser@example.com&gt;
 * </p>
 * @param subject string <p>
 * 送信するメールの表題。
 * </p>
 * <p>
 * 表題は RFC 2047
 * を満たすものでなければなりません。
 * </p>
 * @param message string <p>
 * 送信するメッセージ。
 * </p>
 * <p>
 * 改行コードは CRLF (\r\n) となります。各行の長さは 70 文字を超えては
 * いけません。
 * </p>
 * <p>
 * （Windows のみ）PHP が SMTP サーバーと直接通信をする際、ピリオドから
 * 始まる行は無視されます。これを防ぐには、行頭のピリオドを
 * ピリオド 2 つに置き換えてください。
 * ]]>
 * </p>
 * @param additional_headers string[optional] <p>
 * メールヘッダの最後に挿入される文字列。
 * </p>
 * <p>
 * 通常、これは追加のヘッダ（From、Cc、Bcc）のために用いられます。
 * 複数のヘッダを追加する場合は CRLF（\r\n）で区切ります。
 * </p>
 * <p>
 * メールを送信する際には、必ず 
 * From ヘッダが含まれていなければなりません。
 * additional_headers パラメータで指定するか、
 * あるいは php.ini にデフォルト値を指定します。
 * </p>
 * <p>
 * 指定しなかった場合は、以下のようなエラーメッセージが返ります
 * Warning: mail(): "sendmail_from" not
 * set in php.ini or custom "From:" header missing 。
 * Windows では、From ヘッダを設定すると
 * Return-Path も設定されます。
 * </p>
 * <p>
 * メッセージが受信されなかった場合には、LF（\n）のみを使ってみてください。
 * Unix の MTA の中には、自動的に LF を CRLF に変換してしまう
 * もの (有名なところでは、qmail など)
 * があります（もし CRLF を利用していた場合、CR が重複してしまいます）。
 * ただし、これは最後の手段です。というのも、これは
 * RFC 2822 に違反しているからです。
 * </p>
 * @param additional_parameters string[optional] <p>
 * パラメータ additional_parameters は、
 * 追加のフラグをコマンドラインオプションとしてメール送信プログラムに渡す際に使用可能です。
 * メール送信プログラムは、設定オプション
 * sendmail_path により設定されます。例えば、
 * sendmail を使用する際に -f オプションを使って
 * エンベロープの sender アドレスを設定する際に使用できます。
 * </p>
 * <p>
 * この方法でエンベロープの sender ヘッダ（-f）を設定する際は、
 * 'X-Warning' ヘッダが付加されないように Web サーバーの実行ユーザーを
 * sendmail 設定に追加しておく必要があるかもしれません。
 * sendmail を利用している場合、これは /etc/mail/trusted-users
 * で設定します。
 * </p>
 * @return bool メール送信が受け入れられた場合に TRUE 、それ以外の場合に FALSE
 * を返します。
 * </p>
 * <p>
 * メールの配送が受け入れられたかどうかが基準であることに注意しましょう。
 * メールが実際にあて先に届いたかどうかでは「ありません」。
 */
function mail ($to, $subject, $message, $additional_headers = null, $additional_parameters = null) {}

/**
 * EZMLM で必要なハッシュ値を計算する
 * @link http://www.php.net/manual/ja/function.ezmlm-hash.php
 * @param addr string <p>
 * ハッシュ値を計算する email アドレス。
 * </p>
 * @return int addr のハッシュ値を返します。
 */
function ezmlm_hash ($addr) {}

/**
 * システムのロガーへの接続をオープンする
 * @link http://www.php.net/manual/ja/function.openlog.php
 * @param ident string <p>
 * 文字列 ident が、各メッセージに追加されます。
 * </p>
 * @param option int <p>
 * option 引数は、
 * ログメッセージの生成時に使用されるロギング用オプションを指定します。
 * <table>
 * openlog のオプション
 * <tr valign="top">
 * <td>定数</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_CONS</td>
 * <td>
 * システムロガーにデータが送信される間にエラーが発生した場合、
 * 直接、システムコンソールに書き込まれます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_NDELAY</td>
 * <td>
 * 直ちにロガーへの接続をオープンします。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_ODELAY</td>
 * <td>
 * (デフォルト) 最初のメッセージがロギングされるまで接続のオープンを遅延します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_PERROR</td>
 * <td>標準エラー出力にもログメッセージを出力します。</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_PID</td>
 * <td>各メッセージに PID も含めます。</td>
 * </tr>
 * </table>
 * このオプションを一つまたは複数設定することが可能です。
 * 複数のオプションを使用する場合、その論理和を指定します。
 * つまり、直ちに接続をオープンし、コンソールに書き込み、
 * 各メッセージに PID を含めるには、
 * LOG_CONS | LOG_NDELAY | LOG_PID
 * とします。
 * </p>
 * @param facility int <p>
 * 引数 facility には、
 * ロギングを行う際のメッセージ型を指定します。これにより、
 * (使用するシステムの syslog の設定に関して) 異なった facility 
 * を有するメッセージをどのように処理するかを指定できるようになります。
 * <table>
 * openlog の機能
 * <tr valign="top">
 * <td>定数</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_AUTH</td>
 * <td>
 * セキュリティ/認証用メッセージ
 * (定数 LOG_AUTHPRIV
 * が定義されているシステムでは、代わりにそれを使用してください)
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_AUTHPRIV</td>
 * <td>セキュリティ/認証 メッセージ (プライベート)</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_CRON</td>
 * <td>クロックデーモン (cron や at)</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_DAEMON</td>
 * <td>他のシステムデーモン</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_KERN</td>
 * <td>カーネルメッセージ</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_LOCAL0 ... LOG_LOCAL7</td>
 * <td>ローカルでの使用のために確保されているもので、Windows では使用できません</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_LPR</td>
 * <td>ラインプリンタサブシステム</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_MAIL</td>
 * <td>メールサブシステム</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_NEWS</td>
 * <td>USENET ニュース サブシステム</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_SYSLOG</td>
 * <td>syslogd で内部的に生成されたメッセージ</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_USER</td>
 * <td>一般的なユーザーレベルのメッセージ</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_UUCP</td>
 * <td>UUCP サブシステム</td>
 * </tr>
 * </table>
 * </p>
 * <p>
 * Windows 環境で使用できるのは LOG_USER だけです。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function openlog ($ident, $option, $facility) {}

/**
 * システムログのメッセージを生成する
 * @link http://www.php.net/manual/ja/function.syslog.php
 * @param priority int <p>
 * priority は、容易さ (facility)
 * とレベル (level) の組み合わせです。以下の値が使用できます。
 * <table>
 * syslog の優先順位 (降順)
 * <tr valign="top">
 * <td>定数</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_EMERG</td>
 * <td>システムは使用不可</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_ALERT</td>
 * <td>アクションを直ちにおこす必要がある</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_CRIT</td>
 * <td>致命的な条件</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_ERR</td>
 * <td>エラーを発生する条件</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_WARNING</td>
 * <td>警告を発生する条件</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_NOTICE</td>
 * <td>通常の動作だが、特徴的な条件</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_INFO</td>
 * <td>情報を与えるメッセージ</td>
 * </tr>
 * <tr valign="top">
 * <td>LOG_DEBUG</td>
 * <td>デバッグ用のメッセージ</td>
 * </tr>
 * </table>
 * </p>
 * @param message string <p>
 * 残りの引数は送信するメッセージです。ただし、文字 %m
 * は、errno
 * の値に対応するエラーメッセージ文字列 (strerror) に置換されます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function syslog ($priority, $message) {}

/**
 * システムログへの接続を閉じる
 * @link http://www.php.net/manual/ja/function.closelog.php
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function closelog () {}

/**
 * syslog に関係する全ての定数を初期化する
 * @link http://www.php.net/manual/ja/function.define-syslog-variables.php
 * @return void 値を返しません。
 */
function define_syslog_variables () {}

/**
 * 複合線形合同法
 * @link http://www.php.net/manual/ja/function.lcg-value.php
 * @return float (0, 1) の範囲の疑似乱数を、浮動小数点数で返します。
 */
function lcg_value () {}

/**
 * 文字列の metaphone キーを計算する
 * @link http://www.php.net/manual/ja/function.metaphone.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @param phonemes int[optional] <p>
 * このパラメータは、返される metaphone キーの長さを最大
 * phonemes 文字までに制限します。
 * デフォルト値の 0 は、無制限であることを意味します。
 * </p>
 * @return string metaphone キーを文字列で返します。失敗した場合に FALSE を返します。
 */
function metaphone ($str, $phonemes = null) {}

/**
 * 出力のバッファリングを有効にする
 * @link http://www.php.net/manual/ja/function.ob-start.php
 * @param output_callback callable[optional] <p>
 * オプションの引数 output_callback
 * 関数を指定することが可能です。この関数は、パラメータとして文字列をとり、
 * 文字列を返します。このコールバック関数は、
 * 出力バッファがフラッシュ (送信) あるいは消去
 * (ob_flush, ob_clean
 * あるいは同等の関数で) された場合、
 * またはリクエストの最後にブラウザに出力をフラッシュする際にコールされます。
 * output_callback がコールされた際に、
 * この関数は出力バッファの内容をパラメータとして受け取ります。このコールバック関数は、
 * 新規の出力バッファを実際に出力される結果として返す必要があり、
 * この結果はブラウザに送信されます。
 * output_callback がコール可能な関数ではない場合は
 * FALSE を返します。
 * </p>
 * <p>
 * コールバック関数が 2 つの引数をとる場合、
 * 2 番目のパラメータは、ビットフィールド
 * PHP_OUTPUT_HANDLER_* を含みます。
 * </p>
 * <p>
 * output_callback が FALSE
 * を返すと、元の入力がそのままブラウザに送信されます。
 * </p>
 * <p>
 * output_callback パラメータに NULL 値を渡すと、
 * これをバイパスすることができます。
 * </p>
 * <p>
 * ob_end_clean、
 * ob_end_flush、ob_clean、
 * ob_flush および ob_start
 * をコールバック関数の内部からコールすることはできません。
 * 実際にコールした際の挙動は未定義です。バッファの内容を消去したい際には、
 * コールバック関数から "" (空文字列) を返してください。
 * 同じく、print_r($expression, true) や
 * highlight_file($filename, true) のような
 * 出力バッファリング関数も、
 * コールバック関数の内部からコールすることはできません。
 * </p>
 * <p>
 * PHP 4.0.4 において、Web ページの圧縮をサポートする圧縮 gz エンコード
 * されたデータの Web ブラウザへの送信を容易にするために
 * ob_gzhandler がサポートされています。
 * ob_gzhandler は、ブラウザが受け入れる content
 * encoding の型を調べ、それに基づいて出力を返します。
 * </p>
 * @param chunk_size int[optional] <p>
 * オプションのパラメータ chunk_size が渡された場合、
 * バッファの長さが chunk_size バイトを超えるたびに、
 * 出力の後でバッファがフラッシュされます。
 * デフォルト値は 0 で、これは出力関数がコールされるのが
 * 出力バッファが閉じたときだけであることを意味します。
 * </p>
 * <p>
 * PHP 5.4.0 より前のバージョンでは、1 にも特別な意味があり、
 * これを指定するとチャンクサイズが 4096 バイトになります。
 * </p>
 * @param erase bool[optional] <p>
 * オプションのパラメータ erase に FALSE を指定すると、
 * スクリプトが終了するまでバッファは削除されません。その結果、
 * flush 関数や clean 関数がコールされると notice が発生し、FALSE を返すようになります。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ob_start ($output_callback = null, $chunk_size = null, $erase = null) {}

/**
 * 出力バッファをフラッシュ(送信)する
 * @link http://www.php.net/manual/ja/function.ob-flush.php
 * @return void 値を返しません。
 */
function ob_flush () {}

/**
 * 出力バッファをクリア(消去)する
 * @link http://www.php.net/manual/ja/function.ob-clean.php
 * @return void 値を返しません。
 */
function ob_clean () {}

/**
 * 出力用バッファをフラッシュ(送信)し、出力のバッファリングをオフにする
 * @link http://www.php.net/manual/ja/function.ob-end-flush.php
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 * 失敗する原因は、まず、アクティブなバッファ以外に対してこの
 * 関数をコールしたか、あるいは何らかの理由により
 * バッファを消去することができなかった場合です（特殊なバッファ等）。
 */
function ob_end_flush () {}

/**
 * 出力用バッファをクリア(消去)し、出力のバッファリングをオフにする
 * @link http://www.php.net/manual/ja/function.ob-end-clean.php
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 * 失敗する原因は、まず、アクティブなバッファ以外に対して
 * この関数をコールしたか、あるいは何らかの理由により
 * バッファを消去することができなかった場合です（特殊なバッファ等）。
 */
function ob_end_clean () {}

/**
 * 出力バッファをフラッシュし、その内容を文字列として返した後で出力バッファリングを終了する
 * @link http://www.php.net/manual/ja/function.ob-get-flush.php
 * @return string 出力バッファを返します。バッファリングが開始されていない場合は
 * FALSE を返します。
 */
function ob_get_flush () {}

/**
 * 現在のバッファの内容を取得し、出力バッファを削除する
 * @link http://www.php.net/manual/ja/function.ob-get-clean.php
 * @return string 出力バッファの内容を返した後で出力のバッファリングを終了します。
 * 出力バッファリングが開始されていない場合は FALSE が返されます。
 */
function ob_get_clean () {}

/**
 * 出力バッファの長さを返す
 * @link http://www.php.net/manual/ja/function.ob-get-length.php
 * @return int 出力バッファの内容の長さを返します。
 * 出力のバッファリングがアクティブでない場合には、FALSE を返します。
 */
function ob_get_length () {}

/**
 * 出力バッファリング機構のネストレベルを返す
 * @link http://www.php.net/manual/ja/function.ob-get-level.php
 * @return int 出力バッファリングハンドラのネストレベルを返します。
 * バッファリングがアクティブでない場合はゼロを返します。
 */
function ob_get_level () {}

/**
 * 出力バッファのステータスを取得する
 * @link http://www.php.net/manual/ja/function.ob-get-status.php
 * @param full_status bool[optional] <p>
 * TRUE を指定すると、すべてのアクティブな出力バッファを返します。
 * FALSE を指定した場合、あるいは省略した場合は、
 * トップレベルの出力バッファのみを返します。
 * </p>
 * @return array パラメータ full_status を指定していなかったり
 * full_status = FALSE としていた場合は、
 * 以下の要素を保持する配列が返されます。
 * 2
 * [type] => 0
 * [status] => 0
 * [name] => URL-Rewriter
 * [del] => 1
 * )
 * ]]>
 * 単純な ob_get_status の出力結果
 * キー値
 * level出力階層レベル
 * typePHP_OUTPUT_HANDLER_INTERNAL (0) あるいは PHP_OUTPUT_HANDLER_USER (1)
 * statusPHP_OUTPUT_HANDLER_START (0)、PHP_OUTPUT_HANDLER_CONT (1) あるいは PHP_OUTPUT_HANDLER_END (2) のいずれか
 * nameアクティブな出力ハンドラの名前、あるいは設定されていない場合は ' default output handler'
 * delob_start が設定した削除フラグ
 * </p>
 * <p>
 * full_status = TRUE を指定してコールした場合、
 * 出力バッファごとにひとつの要素を保持する配列が返されます。
 * 出力レベルが配列のキーとして使用され、対応する値として
 * 各出力レベルのステータス情報を配列として保持します。
 * Array
 * (
 * [chunk_size] => 0
 * [size] => 40960
 * [block_size] => 10240
 * [type] => 1
 * [status] => 0
 * [name] => default output handler
 * [del] => 1
 * )
 * [1] => Array
 * (
 * [chunk_size] => 0
 * [size] => 40960
 * [block_size] => 10240
 * [type] => 0
 * [buffer_size] => 0
 * [status] => 0
 * [name] => URL-Rewriter
 * [del] => 1
 * )
 * )
 * ]]>
 * </p>
 * <p>
 * 完全な出力には、追加項目として以下の要素が含まれます。
 * 完全な ob_get_status の出力結果
 * キー値
 * chunk_sizeob_start で設定したチャンクの大きさ
 * size...
 * blocksize...
 */
function ob_get_status ($full_status = null) {}

/**
 * 出力用バッファの内容を返す
 * @link http://www.php.net/manual/ja/function.ob-get-contents.php
 * @return string 出力用バッファの内容を返します。
 * 出力のバッファリングがアクティブでない場合には FALSE を返します。
 */
function ob_get_contents () {}

/**
 * 自動フラッシュをオンまたはオフにする
 * @link http://www.php.net/manual/ja/function.ob-implicit-flush.php
 * @param flag int[optional] <p>
 * TRUE で自動フラッシュをオンに、FALSE でオフにします。
 * </p>
 * @return void 値を返しません。
 */
function ob_implicit_flush ($flag = null) {}

/**
 * 使用中の出力ハンドラの一覧を取得する
 * @link http://www.php.net/manual/ja/function.ob-list-handlers.php
 * @return array これは、使用中の出力ハンドラを（もし存在すれば）配列で返します。もし
 * output_buffering が
 * 有効になっているか、あるいは ob_start で
 * 無名関数が使用されている場合、ob_list_handlers
 * は "default output handler" を返します。
 */
function ob_list_handlers () {}

/**
 * 配列をキーでソートする
 * @link http://www.php.net/manual/ja/function.ksort.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @param sort_flags int[optional] <p>
 * オプションのパラメータ sort_flags
 * によりソートの動作を修正可能です。詳細については、
 * sort を参照ください。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ksort (array &$array, $sort_flags = null) {}

/**
 * 配列をキーで逆順にソートする
 * @link http://www.php.net/manual/ja/function.krsort.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @param sort_flags int[optional] <p>
 * オプションのパラメータ sort_flags
 * によりソートの動作を修正可能です。詳細については、
 * sort を参照ください。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function krsort (array &$array, $sort_flags = null) {}

/**
 * "自然順"アルゴリズムで配列をソートする
 * @link http://www.php.net/manual/ja/function.natsort.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function natsort (array &$array) {}

/**
 * 大文字小文字を区別しない"自然順"アルゴリズムを用いて配列をソートする
 * @link http://www.php.net/manual/ja/function.natcasesort.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function natcasesort (array &$array) {}

/**
 * 連想キーと要素との関係を維持しつつ配列をソートする
 * @link http://www.php.net/manual/ja/function.asort.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @param sort_flags int[optional] <p>
 * オプションのパラメータ sort_flags
 * によりソートの動作を修正可能です。
 * 詳細については、sort を参照ください。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function asort (array &$array, $sort_flags = null) {}

/**
 * 連想キーと要素との関係を維持しつつ配列を逆順にソートする
 * @link http://www.php.net/manual/ja/function.arsort.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @param sort_flags int[optional] <p>
 * オプションのパラメータ sort_flags
 * によりソートの動作を修正可能です。詳細については、
 * sort を参照ください。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function arsort (array &$array, $sort_flags = null) {}

/**
 * 配列をソートする
 * @link http://www.php.net/manual/ja/function.sort.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @param sort_flags int[optional] <p>
 * オプションの 2 番目のパラメータ sort_flags
 * は、以下の値によりソートの動作を修正するために使用することが可能です。
 * </p>
 * <p>
 * ソート型のフラグ:
 * SORT_REGULAR - 通常通りに項目を比較
 * (型は変更しません)
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function sort (array &$array, $sort_flags = null) {}

/**
 * 配列を逆順にソートする
 * @link http://www.php.net/manual/ja/function.rsort.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @param sort_flags int[optional] <p>
 * オプションのパラメータ sort_flags
 * によりソートの動作を修正可能です。詳細については、
 * sort を参照ください。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function rsort (array &$array, $sort_flags = null) {}

/**
 * ユーザー定義の比較関数を使用して、配列を値でソートする
 * @link http://www.php.net/manual/ja/function.usort.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @param cmp_function callable <p>
 * 比較関数は、最初の引数と二番目の引数の比較結果を返します。最初の引数のほうが二番目の引数より大きい場合は正の数を、二番目の引数と等しい場合はゼロを、そして二番目の引数より小さい場合は負の数を返す必要があります。
 * </p>
 * intcallbackmixedamixedb
 * <p>
 * float のような非整数を比較関数が返すと、
 * その返り値を内部的に integer にキャストして使います。
 * つまり、0.99 や 0.1 といった値は整数値 0 にキャストされ、
 * 値が等しいとみなされます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function usort (array &$array, $cmp_function) {}

/**
 * ユーザー定義の比較関数で配列をソートし、連想インデックスを保持する
 * @link http://www.php.net/manual/ja/function.uasort.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @param cmp_function callable <p>
 * ユーザー定義の比較関数の例については、
 * usort および uksort
 * を参照ください。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function uasort (array &$array, $cmp_function) {}

/**
 * ユーザー定義の比較関数を用いて、キーで配列をソートする
 * @link http://www.php.net/manual/ja/function.uksort.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @param cmp_function callable <p>
 * 比較関数は、最初の引数と二番目の引数の比較結果を返します。最初の引数のほうが二番目の引数より大きい場合は正の数を、二番目の引数と等しい場合はゼロを、そして二番目の引数より小さい場合は負の数を返す必要があります。
 * </p>
 * intcallbackmixedamixedb
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function uksort (array &$array, $cmp_function) {}

/**
 * 配列をシャッフルする
 * @link http://www.php.net/manual/ja/function.shuffle.php
 * @param array array <p>
 * 配列。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function shuffle (array &$array) {}

/**
 * 配列の全ての要素にユーザー関数を適用する
 * @link http://www.php.net/manual/ja/function.array-walk.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @param funcname callable <p>
 * 通常、
 * funcname は引数を二つとります。
 * array パラメータの値が最初の引数、
 * キー/添字は二番目の引数となります。
 * </p>
 * <p>
 * funcname により配列の値そのものを変更する必要がある場合、
 * funcname の最初の引数は
 * 参照
 * として渡す必要があります。この場合、配列の要素に加えた変更は、
 * 配列自体に対して行われます。
 * </p>
 * <p>
 * 内部関数の多く (たとえば strtolower) は、
 * 期待しているよりも多い引数を受け取ると警告が発生します。
 * そのため、funcname
 * に直接指定することはできません。
 * </p>
 * <p>
 * 変更される可能性があるのは配列の値だけであり、
 * その構造を変更することはできません。つまり、
 * プログラマは要素の追加や削除そして並べ替えなどができないということです。
 * コールバック関数がこの条件を満たさない場合は、
 * この関数の動作は未定義で予期せぬ結果を得ることになります。
 * </p>
 * @param userdata mixed[optional] <p>
 * オプションの userdata パラメータが指定された場合、
 * コールバック関数 funcname
 * への三番目の引数として渡されます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function array_walk (array &$array, $funcname, $userdata = null) {}

/**
 * 配列の全ての要素に、ユーザー関数を再帰的に適用する
 * @link http://www.php.net/manual/ja/function.array-walk-recursive.php
 * @param input array <p>
 * 入力の配列。
 * </p>
 * @param funcname callable <p>
 * 通常、
 * funcname は引数を二つとります。
 * input パラメータの値が最初の引数、
 * キー/添字は二番目の引数となります。
 * </p>
 * <p>
 * funcname により配列の値そのものを変更する必要がある場合、
 * funcname の最初の引数は
 * 参照
 * として渡す必要があります。この場合、配列の要素に加えた変更は、
 * 配列自体に対して行われます。
 * </p>
 * @param userdata mixed[optional] <p>
 * オプションの userdata パラメータが指定された場合、
 * コールバック関数 funcname への三番目の引数として渡されます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function array_walk_recursive (array &$input, $funcname, $userdata = null) {}

/**
 * 変数に含まれるすべての要素、
  あるいはオブジェクトに含まれる何かの数を数える
 * @link http://www.php.net/manual/ja/function.count.php
 * @param var mixed <p>
 * 配列あるいはオブジェクト。
 * </p>
 * @param mode int[optional] <p>
 * オプションのmode 引数が COUNT_RECURSIVE
 * (または 1) にセットされた場合、count
 * は再帰的に配列をカウントします。
 * これは多次元配列の全ての要素をカウントするといった場合に特に有効です。
 * </p>
 * <p>
 * count は、再帰を検出して無限ループを回避するようになっています。
 * しかしその場合 (配列の中に自分自身が複数回登場する場合) は毎回 E_WARNING
 * を発行し、期待する結果より大きい数を返します。
 * </p>
 * @return int varに含まれる要素の数を返します。
 * もし var が配列もしくは
 * Countable インターフェイスを実装したオブジェクトではない場合、
 * 1 が返されます。
 * ひとつ例外があり、var が NULL の場合、
 * 0 が返されます。
 * </p>
 * <p>
 * count は、セットされていない変数に関して 0
 * を返しますが、変数が空の配列として初期化されている場合にも 0 を返します。
 * ある変数がセットされているかどうかを調べるには、
 * isset を使用してください。
 */
function count ($var, $mode = null) {}

/**
 * 配列の内部ポインタを最終要素にセットする
 * @link http://www.php.net/manual/ja/function.end.php
 * @param array array <p>
 * 配列。この配列は参照渡しとなります。関数内で配列の中身を変更するからです。
 * つまり、ここには配列そのものを渡さなければならず、
 * 配列を返す関数を指定することはできません。
 * 参照渡しできるのは、実際の変数だけだからです。
 * </p>
 * @return mixed 最後の要素の値、あるいは空の配列の場合は FALSE を返します。
 */
function end (array &$array) {}

/**
 * 内部の配列ポインタをひとつ前に戻す
 * @link http://www.php.net/manual/ja/function.prev.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @return mixed 内部の配列ポインタが指している前の場所の配列値を返します。
 * もう要素がない場合は FALSE を返します。
 */
function prev (array &$array) {}

/**
 * 内部配列ポインタを進める
 * @link http://www.php.net/manual/ja/function.next.php
 * @param array array <p>
 * 対象となる配列。
 * </p>
 * @return mixed 内部配列ポインタが指す場所の次の場所の値を返します。
 * それ以上要素がない場合は FALSE を返します。
 */
function next (array &$array) {}

/**
 * 配列の内部ポインタを先頭の要素にセットする
 * @link http://www.php.net/manual/ja/function.reset.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @return mixed 配列の最初の要素の値を返します。
 * 配列が空の場合 FALSE を返します。
 */
function reset (array &$array) {}

/**
 * 配列内の現在の要素を返す
 * @link http://www.php.net/manual/ja/function.current.php
 * @param array array <p>
 * 配列。
 * </p>
 * @return mixed current 関数は、
 * 単に内部ポインタが現在指している配列要素の値を返します。
 * この関数は、ポインタを全く移動しません。
 * 内部ポインタが最終要素の次を指していたり
 * 配列が空だったりした場合、
 * current は FALSE を返します。
 */
function current (array &$array) {}

/**
 * 配列からキーを取り出す
 * @link http://www.php.net/manual/ja/function.key.php
 * @param array array <p>
 * 配列。
 * </p>
 * @return mixed key 関数は、内部ポインタが現在指している配列要素のキーを返します。
 * ポインタを移動することはありません。内部ポインタが要素リストの末尾にいる場合や配列が空の場合は
 * key は NULL を返します。
 */
function key (array &$array) {}

/**
 * 最小値を返す
 * @link http://www.php.net/manual/ja/function.min.php
 * @param values array <p>
 * 値を含む配列。
 * </p>
 * @return mixed min は、パラメータとして渡した値の中で
 * 数値として最も小さいものを返します。
 */
function min (array $values) {}

/**
 * 最大値を返す
 * @link http://www.php.net/manual/ja/function.max.php
 * @param values array <p>
 * 値を含む配列。
 * </p>
 * @return mixed max は、パラメータとして渡した値の中で
 * 数値として最も大きいものを返します。
 * 同じ大きさの値が複数あった場合は、最初にあらわれたものを返します。
 * </p>
 * <p>
 * max に複数の配列を渡した場合は、いちばん長い配列を返します。
 * すべての配列が同じ長さの場合は、辞書順の並べ替えで返り値を見つけます。
 * </p>
 * <p>
 * 文字列を渡した場合は、integer に変換してから比較します。
 */
function max (array $values) {}

/**
 * 配列に値があるかチェックする
 * @link http://www.php.net/manual/ja/function.in-array.php
 * @param needle mixed <p>
 * 探す値。
 * </p>
 * <p>
 * needle が文字列の場合、
 * 比較の際に大文字小文字は区別されます。
 * </p>
 * @param haystack array <p>
 * 配列。
 * </p>
 * @param strict bool[optional] <p>
 * 三番目のパラメータ strict が
 * TRUE に設定された場合、
 * in_array は、haystack
 * の中の needle の
 * 型も確認します。
 * </p>
 * @return bool 配列で needle が見つかった場合に
 * TRUE、それ以外の場合は、FALSE を返します。
 */
function in_array ($needle, array $haystack, $strict = null) {}

/**
 * 指定した値を配列で検索し、見つかった場合に対応するキーを返す
 * @link http://www.php.net/manual/ja/function.array-search.php
 * @param needle mixed <p>
 * 探したい値。
 * </p>
 * <p>
 * needle が文字列の場合、
 * 大文字小文字を区別して比較が行われます。
 * </p>
 * @param haystack array <p>
 * 配列。
 * </p>
 * @param strict bool[optional] <p>
 * オプションの3番目のパラメータ strict に
 * TRUE が指定された場合、array_search は
 * identical 要素を
 * haystack から探します。つまり、
 * haystack の中で
 * needle の型に一致するかどうか、
 * そしてオブジェクトが同一のインスタンスであるかどうかも確認します。
 * </p>
 * @return mixed needle が見つかった場合に配列のキー、
 * それ以外の場合に FALSE を返します。
 * </p>
 * <p>
 * もし haystack に 1 つ以上の
 * needle に見つかった場合、
 * 最初にマッチしたキーが返されます。
 * 全てのマッチした値に対するキーを返すためには、代わりに
 * array_keys にパラメータ
 * search_value を付けて使用してください。
 */
function array_search ($needle, array $haystack, $strict = null) {}

/**
 * 配列からシンボルテーブルに変数をインポートする
 * @link http://www.php.net/manual/ja/function.extract.php
 * @param var_array array <p>
 * prefix は、
 * extract_type が
 * EXTR_PREFIX_SAME、EXTR_PREFIX_ALL、
 * EXTR_PREFIX_INVALID あるいは
 * EXTR_PREFIX_IF_EXISTS の場合にのみ必要であることに注意してください。
 * 接頭辞を付けた変数名が有効な変数名でない場合、
 * この変数はシンボルテーブルにインポートされません。接頭辞は、
 * アンダースコア文字で配列のキーから自動的に分割されます。
 * </p>
 * @param extract_type int[optional] <p>
 * 無効または数値キーおよび衝突に関する対処法は、
 * extract_type で定義されます。
 * これは以下の値のどれかとなります。
 * EXTR_OVERWRITE
 * 衝突があった場合、存在する変数が上書きされます。
 * @param prefix string[optional] 現在のシンボルテーブルに既に存在する場合にのみ上書きします。
 * 例えば $_REQUEST 以外にあなたが定義した変数のみを展開し
 * 有効な変数としたいような場合に有用です。
 * @return int シンボルテーブルにインポートした変数の数を返します。
 */
function extract (array &$var_array, $extract_type = null, $prefix = null) {}

/**
 * 変数名とその値から配列を作成する
 * @link http://www.php.net/manual/ja/function.compact.php
 * @param varname mixed <p>
 * compact がとるパラメータの数は可変です。
 * 各パラメータは、変数名を値とする文字列か、
 * 変数名の配列のどちらかとすることができます。
 * 配列は、変数名を値とする別の配列を持つことができます。
 * compactはこれを再帰的に処理します。
 * </p>
 * @param _ mixed[optional] 
 * @return array 追加された全ての変数を値とする出力配列を返します。
 */
function compact ($varname, $_ = null) {}

/**
 * 配列を指定した値で埋める
 * @link http://www.php.net/manual/ja/function.array-fill.php
 * @param start_index int <p>
 * 返される配列の最初のインデックス。
 * </p>
 * <p>
 * start_index が負の場合は、
 * 返される配列の最初のインデックスが
 * start_index
 * となり、それ以降のインデックスはゼロから始まります
 * (例を参照ください)。
 * </p>
 * @param num int <p>
 * 挿入する要素数。
 * 正の数でなければなりません。
 * </p>
 * @param value mixed <p>
 * 要素に使用する値。
 * </p>
 * @return array 値を埋めた配列を返します。
 */
function array_fill ($start_index, $num, $value) {}

/**
 * キーを指定して、配列を値で埋める
 * @link http://www.php.net/manual/ja/function.array-fill-keys.php
 * @param keys array <p>
 * キーとして使用する値の配列。キーとして無効な値は
 * string に変換されます。
 * </p>
 * @param value mixed <p>
 * 埋めたい値。
 * </p>
 * @return array 値を埋めた配列を返します。
 */
function array_fill_keys (array $keys, $value) {}

/**
 * ある範囲の整数を有する配列を作成する
 * @link http://www.php.net/manual/ja/function.range.php
 * @param start mixed <p>
 * シーケンスの最初の値。
 * </p>
 * @param end mixed <p>
 * 値が end に達するまでシーケンスが続きます。
 * </p>
 * @param step number[optional] <p>
 * step が指定されている場合、それは
 * 要素毎の増加数となります。step
 * は正の数でなければなりません。デフォルトは 1 です。
 * </p>
 * @return array start から
 * end までの整数の配列を返します。
 */
function range ($start, $end, $step = null) {}

/**
 * 複数の多次元の配列をソートする
 * @link http://www.php.net/manual/ja/function.array-multisort.php
 * @param arr array <p>
 * ソートしたい配列。
 * </p>
 * @param arg mixed[optional] <p>
 * オプションで指定する別の配列、
 * あるいは先ほどの引数の配列のソート方法
 * </p>
 * <p>
 * これらのフラグが使えます。
 * SORT_ASC - アイテムを昇順にソートします。
 * @param arg mixed[optional] 
 * @param _ mixed[optional] 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function array_multisort (array &$arr, $arg = null, $arg = null, $_ = null) {}

/**
 * 一つ以上の要素を配列の最後に追加する
 * @link http://www.php.net/manual/ja/function.array-push.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @param var mixed <p>
 * 追加する値。
 * </p>
 * @param _ mixed[optional] 
 * @return int 処理後の配列の中の要素の数を返します。
 */
function array_push (array &$array, $var, $_ = null) {}

/**
 * 配列の末尾から要素を取り除く
 * @link http://www.php.net/manual/ja/function.array-pop.php
 * @param array array <p>
 * 値を取り出す配列。
 * </p>
 * @return mixed 配列 array
 * の最後の値を取り出して返します。
 * array が空 (または、配列でない) の場合、
 * NULL が返されます。
 */
function array_pop (array &$array) {}

/**
 * 配列の先頭から要素を一つ取り出す
 * @link http://www.php.net/manual/ja/function.array-shift.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @return mixed 取り出した値を返します。array
 * が空の場合や配列でない場合は NULL を返します。
 */
function array_shift (array &$array) {}

/**
 * 一つ以上の要素を配列の最初に加える
 * @link http://www.php.net/manual/ja/function.array-unshift.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @param var mixed <p>
 * 加える変数。
 * </p>
 * @param _ mixed[optional] 
 * @return int 処理後の array の要素の数を返します。
 */
function array_unshift (array &$array, $var, $_ = null) {}

/**
 * 配列の一部を削除し、他の要素で置換する
 * @link http://www.php.net/manual/ja/function.array-splice.php
 * @param input array <p>
 * 入力の配列。
 * </p>
 * @param offset int <p>
 * offset が正の場合、削除される部分は
 * 配列 input の最初から指定オフセットの
 * ぶんだけ進んだ位置からとなります。
 * offset が負の場合、削除される部分は、
 * input の末尾から数えた位置からとなります。
 * </p>
 * @param length int[optional] <p>
 * length が省略された場合、
 * offset から配列の最後までが全て削除されます。
 * length が指定され、正の場合、複数の要素が削除されます。
 * length が指定され、負の場合、
 * 削除される部分は配列の末尾から複数の要素となります。
 * ヒント: replacement も指定した場合に
 * offset から配列の最後まで全てを削除するには、
 * length を求めるために count($input)
 * を使用してください。
 * </p>
 * @param replacement mixed[optional] <p>
 * 配列 replacement が指定された場合、
 * 削除された要素は、この配列の要素で置換されます。
 * </p>
 * <p>
 * offset および length
 * で何も削除しないと指定した場合、配列 replacement
 * の要素は offset で指定された位置に挿入されます。
 * 置換される配列のキーは保存されないことに注意してください。
 * </p>
 * <p>
 * もし replacement に一つしか要素がない場合、
 * 要素そのものが配列やオブジェクトあるいは NULL でない限り、array()
 * で括る必要はありません。
 * </p>
 * @return array 抽出された要素を含む配列を返します。
 */
function array_splice (array &$input, $offset, $length = null, $replacement = null) {}

/**
 * 配列の一部を展開する
 * @link http://www.php.net/manual/ja/function.array-slice.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @param offset int <p>
 * offset が負の値ではない場合、要素位置の計算は、
 * 配列 array の offset から始められます。
 * offset が負の場合、要素位置の計算は
 * array の最後から行われます。
 * </p>
 * @param length int[optional] <p>
 * lengthが指定され、正の場合、
 * 配列の要素の中から最大でその数までの要素を返します。
 * 配列の要素数が length より少ない場合は、
 * 配列から取得できる要素だけを返します。length
 * が指定され、負の場合、配列の末尾から連続する複数の要素が返されます。
 * 省略された場合、offset
 * から配列の最後までの全ての要素が返されます。
 * </p>
 * @param preserve_keys bool[optional] <p>
 * array_slice はデフォルトで配列の数値キーを並べなおし、
 * リセットすることに注意してください。
 * preserve_keys を TRUE
 * にする事でこの動作を変更することができます。
 * </p>
 * @return array 切り取った部分を返します。
 */
function array_slice (array $array, $offset, $length = null, $preserve_keys = null) {}

/**
 * ひとつまたは複数の配列をマージする
 * @link http://www.php.net/manual/ja/function.array-merge.php
 * @param array1 array <p>
 * 最初の配列。
 * </p>
 * @param _ array[optional] 
 * @return array 結果の配列を返します。
 */
function array_merge (array $array1, array $_ = null) {}

/**
 * 二つ以上の配列を再帰的にマージする
 * @link http://www.php.net/manual/ja/function.array-merge-recursive.php
 * @param array1 array <p>
 * マージするもとの配列。
 * </p>
 * @param _ array[optional] 
 * @return array すべての引数の配列をマージした結果の配列を返します。
 */
function array_merge_recursive (array $array1, array $_ = null) {}

/**
 * 渡された配列の要素を置き換える
 * @link http://www.php.net/manual/ja/function.array-replace.php
 * @param array array <p>
 * 要素を置き換えたい配列。
 * </p>
 * @param array1 array <p>
 * 置き換えたい要素を含む配列。
 * </p>
 * @param _ array[optional] 
 * @return array 配列を返します。エラーが発生した場合は NULL を返します。
 */
function array_replace (array $array, array $array1, array $_ = null) {}

/**
 * 渡された配列の要素を再帰的に置き換える
 * @link http://www.php.net/manual/ja/function.array-replace-recursive.php
 * @param array array <p>
 * 要素を置き換えたい配列。
 * </p>
 * @param array1 array <p>
 * 置き換えたい要素を含む配列。
 * </p>
 * @param _ array[optional] 
 * @return array 配列を返します。エラーが発生した場合は NULL を返します。
 */
function array_replace_recursive (array $array, array $array1, array $_ = null) {}

/**
 * 配列のキーすべて、あるいはその一部を返す
 * @link http://www.php.net/manual/ja/function.array-keys.php
 * @param input array <p>
 * 返すキーを含む配列。
 * </p>
 * @param search_value mixed[optional] <p>
 * 指定した場合は、これらの値を含むキーのみを返します。
 * </p>
 * @param strict bool[optional] <p>
 * 検索時に厳密な比較 (===) を行うかどうか。
 * </p>
 * @return array input のすべてのキーを配列で返します。
 */
function array_keys (array $input, $search_value = null, $strict = null) {}

/**
 * 配列の全ての値を返す
 * @link http://www.php.net/manual/ja/function.array-values.php
 * @param input array <p>
 * 配列。
 * </p>
 * @return array 数値添字の値の配列を返します。
 */
function array_values (array $input) {}

/**
 * 配列の値の数を数える
 * @link http://www.php.net/manual/ja/function.array-count-values.php
 * @param input array <p>
 * 値を数える配列。
 * </p>
 * @return array input のキーとその登場回数を組み合わせた連想配列を返します。
 */
function array_count_values (array $input) {}

/**
 * 要素を逆順にした配列を返す
 * @link http://www.php.net/manual/ja/function.array-reverse.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @param preserve_keys bool[optional] <p>
 * TRUE の場合は数値のキーを保持します。
 * 非数値のキーは、この設定にかかわらず常に保持されます。
 * </p>
 * @return array 逆転させた配列を返します。
 */
function array_reverse (array $array, $preserve_keys = null) {}

/**
 * コールバック関数を用いて配列を普通の値に変更することにより、配列を再帰的に減らす
 * @link http://www.php.net/manual/ja/function.array-reduce.php
 * @param input array <p>
 * 入力の配列。
 * </p>
 * @param function callable <p>
 * コールバック関数。
 * </p>
 * mixedcallback
 * mixedresult
 * mixeditem
 * @param initial mixed[optional] <p>
 * オプションの intial
 * が利用可能な場合、処理の最初で使用されたり、
 * 配列が空の場合の最終結果として使用されます。
 * </p>
 * @return mixed 結果の値を返します。
 * </p>
 * <p>
 * 配列が空で initial が渡されなかった場合は、
 * array_reduce は NULL を返します。
 */
function array_reduce (array $input, $function, $initial = null) {}

/**
 * 指定長、指定した値で配列を埋める
 * @link http://www.php.net/manual/ja/function.array-pad.php
 * @param input array <p>
 * 値を埋めるもととなる配列。
 * </p>
 * @param pad_size int <p>
 * 新しい配列のサイズ。
 * </p>
 * @param pad_value mixed <p>
 * input が
 * pad_size より小さいときに、
 * 埋めるために使用する値。
 * </p>
 * @return array pad_size
 * で指定した長さになるように値 pad_value で埋めて
 * input のコピーを返します。
 * pad_size が正の場合、配列の右側が埋められます。
 * 負の場合、配列の左側が埋められます。
 * pad_size の絶対値が
 * input の長さ以下の場合、埋める処理は行われません。
 */
function array_pad (array $input, $pad_size, $pad_value) {}

/**
 * 配列のキーと値を反転する
 * @link http://www.php.net/manual/ja/function.array-flip.php
 * @param trans array <p>
 * 反転を行うキー/値の組。
 * </p>
 * @return array 成功した場合に反転した配列、失敗した場合に NULL を返します。
 */
function array_flip (array $trans) {}

/**
 * 配列のすべてのキーを変更する
 * @link http://www.php.net/manual/ja/function.array-change-key-case.php
 * @param input array <p>
 * 処理を行う配列。
 * </p>
 * @param case int[optional] <p>
 * CASE_UPPER あるいは
 * CASE_LOWER (デフォルト)。
 * </p>
 * @return array すべてのキーを小文字あるいは大文字にした配列を返します。
 * input が配列でない場合は FALSE を返します。
 */
function array_change_key_case (array $input, $case = null) {}

/**
 * 配列から一つ以上の要素をランダムに取得する
 * @link http://www.php.net/manual/ja/function.array-rand.php
 * @param input array <p>
 * 入力の配列。
 * </p>
 * @param num_req int[optional] <p>
 * 取得するエントリの数を指定します。
 * 配列の要素数より多くの要素を取り出そうとすると
 * E_WARNING レベルのエラーとなります。
 * </p>
 * @return mixed エントリを一つだけ取得する場合、
 * array_rand はランダムなエントリのキーを返します。
 * その他の場合は、ランダムなエントリのキーの配列を返します。
 * これにより、ランダムなキーを取得し、
 * 配列から値を取得することが可能になります。
 */
function array_rand (array $input, $num_req = null) {}

/**
 * 配列から重複した値を削除する
 * @link http://www.php.net/manual/ja/function.array-unique.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @param sort_flags int[optional] <p>
 * オプションの 2 番目のパラメータ sort_flags
 * にこれらの値を使用して、ソートの挙動を変更します。
 * </p>
 * <p>
 * ソート形式のフラグは次のとおりです。
 * SORT_REGULAR - 通常の比較
 * (型変換をしない) を行います
 * @return array 処理済の配列を返します。
 */
function array_unique (array $array, $sort_flags = null) {}

/**
 * 配列の共通項を計算する
 * @link http://www.php.net/manual/ja/function.array-intersect.php
 * @param array1 array <p>
 * 値を調べるもととなる配列。
 * </p>
 * @param array2 array <p>
 * 値を比較する対象となる配列。
 * </p>
 * @param _ array[optional] 
 * @return array array1 の値のうち、
 * すべての引数に存在する値のものを含む連想配列を返します。
 */
function array_intersect (array $array1, array $array2, array $_ = null) {}

/**
 * キーを基準にして配列の共通項を計算する
 * @link http://www.php.net/manual/ja/function.array-intersect-key.php
 * @param array1 array <p>
 * 値を調べるもととなる配列。
 * </p>
 * @param array2 array <p>
 * 値を比較する対象となる配列。
 * </p>
 * @param _ array[optional] 
 * @return array array1 のエントリのうち、
 * すべての引数に存在するキーのものを含む連想配列を返します。
 */
function array_intersect_key (array $array1, array $array2, array $_ = null) {}

/**
 * キーを基準にし、コールバック関数を用いて
  配列の共通項を計算する
 * @link http://www.php.net/manual/ja/function.array-intersect-ukey.php
 * @param array1 array <p>
 * 比較元となる最初の配列。
 * </p>
 * @param array2 array <p>
 * キーを比較する対象となる最初の配列。
 * </p>
 * @param _ array[optional] 
 * @param key_compare_func callable <p>
 * 比較関数は、最初の引数と二番目の引数の比較結果を返します。最初の引数のほうが二番目の引数より大きい場合は正の数を、二番目の引数と等しい場合はゼロを、そして二番目の引数より小さい場合は負の数を返す必要があります。
 * </p>
 * intcallbackmixedamixedb
 * @return array array1 の値のうち、
 * すべての引数に存在するキーのものを含む連想配列を返します。
 */
function array_intersect_ukey (array $array1, array $array2, array $_ = null, $key_compare_func) {}

/**
 * データの比較にコールバック関数を用い、配列の共通項を計算する
 * @link http://www.php.net/manual/ja/function.array-uintersect.php
 * @param array1 array <p>
 * 最初の配列。
 * </p>
 * @param array2 array <p>
 * 2 番目の配列。
 * </p>
 * @param _ array[optional] 
 * @param data_compare_func callable <p>
 * 比較関数は、最初の引数と二番目の引数の比較結果を返します。最初の引数のほうが二番目の引数より大きい場合は正の数を、二番目の引数と等しい場合はゼロを、そして二番目の引数より小さい場合は負の数を返す必要があります。
 * </p>
 * intcallbackmixedamixedb
 * @return array 他の全ての引数に存在する
 * array1 の値を全て有する配列を返します。
 */
function array_uintersect (array $array1, array $array2, array $_ = null, $data_compare_func) {}

/**
 * 追加された添字の確認も含めて配列の共通項を確認する
 * @link http://www.php.net/manual/ja/function.array-intersect-assoc.php
 * @param array1 array <p>
 * 値を調べるもととなる配列。
 * </p>
 * @param array2 array <p>
 * 値を比較する対象となる配列。
 * </p>
 * @param _ array[optional] 
 * @return array array1 の値のうち、すべての引数に存在するものを含む連想配列を返します。
 */
function array_intersect_assoc (array $array1, array $array2, array $_ = null) {}

/**
 * データの比較にコールバック関数を用い、
  追加された添字の確認も含めて配列の共通項を計算する
 * @link http://www.php.net/manual/ja/function.array-uintersect-assoc.php
 * @param array1 array <p>
 * 最初の配列。
 * </p>
 * @param array2 array <p>
 * 2 番目の配列。
 * </p>
 * @param _ array[optional] 
 * @param data_compare_func callable <p>
 * 比較関数は、最初の引数と二番目の引数の比較結果を返します。最初の引数のほうが二番目の引数より大きい場合は正の数を、二番目の引数と等しい場合はゼロを、そして二番目の引数より小さい場合は負の数を返す必要があります。
 * </p>
 * intcallbackmixedamixedb
 * @return array 全ての引数に現れる
 * array1 の全ての値を含む配列を返します。
 */
function array_uintersect_assoc (array $array1, array $array2, array $_ = null, $data_compare_func) {}

/**
 * 追加された添字の確認も含め、コールバック関数を用いて
  配列の共通項を確認する
 * @link http://www.php.net/manual/ja/function.array-intersect-uassoc.php
 * @param array1 array <p>
 * 比較元となる最初の配列。
 * </p>
 * @param array2 array <p>
 * キーを比較する対象となる最初の配列。
 * </p>
 * @param _ array[optional] 
 * @param key_compare_func callable <p>
 * 比較関数は、最初の引数と二番目の引数の比較結果を返します。最初の引数のほうが二番目の引数より大きい場合は正の数を、二番目の引数と等しい場合はゼロを、そして二番目の引数より小さい場合は負の数を返す必要があります。
 * </p>
 * intcallbackmixedamixedb
 * @return array array1 の値のうち、
 * すべての引数に存在するもののみを返します。
 */
function array_intersect_uassoc (array $array1, array $array2, array $_ = null, $key_compare_func) {}

/**
 * データと添字の比較にコールバック関数を用い、
  追加された添字の確認も含めて配列の共通項を計算する
 * @link http://www.php.net/manual/ja/function.array-uintersect-uassoc.php
 * @param array1 array <p>
 * 最初の配列。
 * </p>
 * @param array2 array <p>
 * 2 番目の配列。
 * </p>
 * @param _ array[optional] 
 * @param data_compare_func callable <p>
 * 比較関数は、最初の引数と二番目の引数の比較結果を返します。最初の引数のほうが二番目の引数より大きい場合は正の数を、二番目の引数と等しい場合はゼロを、そして二番目の引数より小さい場合は負の数を返す必要があります。
 * </p>
 * intcallbackmixedamixedb
 * @param key_compare_func callable <p>
 * キーの比較用のコールバック関数。
 * </p>
 * @return array 全ての引数に現れる
 * array1 の全ての値を含む配列を返します。
 */
function array_uintersect_uassoc (array $array1, array $array2, array $_ = null, $data_compare_func, $key_compare_func) {}

/**
 * 配列の差を計算する
 * @link http://www.php.net/manual/ja/function.array-diff.php
 * @param array1 array <p>
 * 比較元の配列。
 * </p>
 * @param array2 array <p>
 * 比較対象の配列。
 * </p>
 * @param _ array[optional] 
 * @return array array1
 * のエントリのうち、他のどの配列にも含まれない要素のみを含む配列を返します。
 */
function array_diff (array $array1, array $array2, array $_ = null) {}

/**
 * キーを基準にして配列の差を計算する
 * @link http://www.php.net/manual/ja/function.array-diff-key.php
 * @param array1 array <p>
 * 比較元の配列。
 * </p>
 * @param array2 array <p>
 * 比較する対象となる配列。
 * </p>
 * @param _ array[optional] 
 * @return array array1 の要素のうち、
 * その他の配列のいずれにも含まれないキーのものだけを残した配列を返します。
 */
function array_diff_key (array $array1, array $array2, array $_ = null) {}

/**
 * キーを基準にし、コールバック関数を用いて配列の差を計算する
 * @link http://www.php.net/manual/ja/function.array-diff-ukey.php
 * @param array1 array <p>
 * 比較元の配列。
 * </p>
 * @param array2 array <p>
 * 比較する対象となる配列。
 * </p>
 * @param _ array[optional] 
 * @param key_compare_func callable <p>
 * 比較関数は、最初の引数と二番目の引数の比較結果を返します。最初の引数のほうが二番目の引数より大きい場合は正の数を、二番目の引数と等しい場合はゼロを、そして二番目の引数より小さい場合は負の数を返す必要があります。
 * </p>
 * intcallbackmixedamixedb
 * @return array array1 の要素のうち、
 * その他の配列のいずれにも含まれないものだけを残した配列を返します。
 */
function array_diff_ukey (array $array1, array $array2, array $_ = null, $key_compare_func) {}

/**
 * データの比較にコールバック関数を用い、配列の差を計算する
 * @link http://www.php.net/manual/ja/function.array-udiff.php
 * @param array1 array <p>
 * 最初の配列。
 * </p>
 * @param array2 array <p>
 * 2 番目の配列。
 * </p>
 * @param _ array[optional] 
 * @param data_compare_func callable <p>
 * 比較用のコールバック関数。
 * </p>
 * <p>
 * 比較関数は、最初の引数と二番目の引数の比較結果を返します。最初の引数のほうが二番目の引数より大きい場合は正の数を、二番目の引数と等しい場合はゼロを、そして二番目の引数より小さい場合は負の数を返す必要があります。
 * </p>
 * intcallbackmixedamixedb
 * @return array 他の引数のいずれにも存在しない
 * array1 の値の全てを有する配列を返します。
 */
function array_udiff (array $array1, array $array2, array $_ = null, $data_compare_func) {}

/**
 * 追加された添字の確認を含めて配列の差を計算する
 * @link http://www.php.net/manual/ja/function.array-diff-assoc.php
 * @param array1 array <p>
 * 比較元の配列。
 * </p>
 * @param array2 array <p>
 * 比較する対象となる配列。
 * </p>
 * @param _ array[optional] 
 * @return array array1 の要素のうち、
 * その他の配列のいずれにも含まれないものだけを残した配列を返します。
 */
function array_diff_assoc (array $array1, array $array2, array $_ = null) {}

/**
 * データの比較にコールバック関数を用い、
  追加された添字の確認を含めて配列の差を計算する
 * @link http://www.php.net/manual/ja/function.array-udiff-assoc.php
 * @param array1 array <p>
 * 最初の配列。
 * </p>
 * @param array2 array <p>
 * 2 番目の配列。
 * </p>
 * @param _ array[optional] 
 * @param data_compare_func callable <p>
 * 比較関数は、最初の引数と二番目の引数の比較結果を返します。最初の引数のほうが二番目の引数より大きい場合は正の数を、二番目の引数と等しい場合はゼロを、そして二番目の引数より小さい場合は負の数を返す必要があります。
 * </p>
 * intcallbackmixedamixedb
 * @return array array_udiff_assoc は、
 * array1 から他の引数の配列の中に現れない全ての値を含む
 * array を返します。
 * array_diff や array_udiff
 * と異なり、キーが比較に使用されることに注意してください。
 * 配列のデータの比較は、ユーザーが指定したコールバックを用いて行われます。
 * この点で、array_diff_assoc は反対の動作、つまり
 * 内部関数を利用した比較を行います。
 */
function array_udiff_assoc (array $array1, array $array2, array $_ = null, $data_compare_func) {}

/**
 * ユーザーが指定したコールバック関数を利用し、
   追加された添字の確認を含めて配列の差を計算する
 * @link http://www.php.net/manual/ja/function.array-diff-uassoc.php
 * @param array1 array <p>
 * 比較元の配列。
 * </p>
 * @param array2 array <p>
 * 比較する対象となる配列。
 * </p>
 * @param _ array[optional] 
 * @param key_compare_func callable <p>
 * 比較関数は、最初の引数と二番目の引数の比較結果を返します。最初の引数のほうが二番目の引数より大きい場合は正の数を、二番目の引数と等しい場合はゼロを、そして二番目の引数より小さい場合は負の数を返す必要があります。
 * </p>
 * intcallbackmixedamixedb
 * @return array array1 の要素のうち、
 * その他の配列のいずれにも含まれないものだけを残した配列を返します。
 */
function array_diff_uassoc (array $array1, array $array2, array $_ = null, $key_compare_func) {}

/**
 * データと添字の比較にコールバック関数を用い、
  追加された添字の確認を含めて配列の差を計算する
 * @link http://www.php.net/manual/ja/function.array-udiff-uassoc.php
 * @param array1 array <p>
 * 最初の配列。
 * </p>
 * @param array2 array <p>
 * 2 番目の配列。
 * </p>
 * @param _ array[optional] 
 * @param data_compare_func callable <p>
 * 比較関数は、最初の引数と二番目の引数の比較結果を返します。最初の引数のほうが二番目の引数より大きい場合は正の数を、二番目の引数と等しい場合はゼロを、そして二番目の引数より小さい場合は負の数を返す必要があります。
 * </p>
 * intcallbackmixedamixedb
 * @param key_compare_func callable <p>
 * キー（添字）の比較は、コールバック関数
 * key_compare_func で行われます。
 * array_udiff_assoc では後者の比較が内部関数で
 * 行われるという点で、この関数とは異なります。
 * </p>
 * @return array array1 から他の引数の配列の中に現れない全ての
 * 値を含むarray を返します。
 */
function array_udiff_uassoc (array $array1, array $array2, array $_ = null, $data_compare_func, $key_compare_func) {}

/**
 * 配列の中の値の合計を計算する
 * @link http://www.php.net/manual/ja/function.array-sum.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @return number 値の合計を整数または
 * float として返します。
 */
function array_sum (array $array) {}

/**
 * 配列の値の積を計算する
 * @link http://www.php.net/manual/ja/function.array-product.php
 * @param array array <p>
 * 配列。
 * </p>
 * @return number 積を、integer あるいは float で返します。
 */
function array_product (array $array) {}

/**
 * コールバック関数を使用して、配列の要素をフィルタリングする
 * @link http://www.php.net/manual/ja/function.array-filter.php
 * @param input array <p>
 * 処理する配列。
 * </p>
 * @param callback callable[optional] <p>
 * 使用するコールバック関数。
 * </p>
 * <p>
 * コールバック関数が与えられなかった場合、
 * input のエントリの中で FALSE と等しいもの
 * (boolean
 * への変換 を参照ください) がすべて削除されます。
 * </p>
 * @return array フィルタリングされた結果の配列を返します。
 */
function array_filter (array $input, $callback = null) {}

/**
 * 指定した配列の要素にコールバック関数を適用する
 * @link http://www.php.net/manual/ja/function.array-map.php
 * @param callback callable <p>
 * 配列の各要素に適用するコールバック関数。
 * </p>
 * @param arr1 array <p>
 * コールバック関数を適用する配列。
 * </p>
 * @param _ array[optional] 
 * @return array arr1
 * の各要素に callback 関数を適用した後、
 * その全ての要素を含む配列を返します。
 */
function array_map ($callback, array $arr1, array $_ = null) {}

/**
 * 配列を分割する
 * @link http://www.php.net/manual/ja/function.array-chunk.php
 * @param input array <p>
 * 処理を行う配列。
 * </p>
 * @param size int <p>
 * 各部分のサイズ。
 * </p>
 * @param preserve_keys bool[optional] <p>
 * TRUE の場合はキーをそのまま保持します。
 * デフォルトは FALSE で、各部分のキーをあらためて数字で振りなおします。
 * </p>
 * @return array 数値添字の多次元配列を返します。添え字はゼロから始まり、
 * 各次元の要素数が size となります。
 */
function array_chunk (array $input, $size, $preserve_keys = null) {}

/**
 * 一方の配列をキーとして、もう一方の配列を値として、ひとつの配列を生成する
 * @link http://www.php.net/manual/ja/function.array-combine.php
 * @param keys array <p>
 * キーとして使用する配列。無効な値を渡すと文字列に変換されます。
 * </p>
 * @param values array <p>
 * 値として使用する配列。
 * </p>
 * @return array 作成した配列を返します。
 * 互いの配列の要素の数が合致しない場合に
 * FALSE を返します。
 */
function array_combine (array $keys, array $values) {}

/**
 * 指定したキーまたは添字が配列にあるかどうかを調べる
 * @link http://www.php.net/manual/ja/function.array-key-exists.php
 * @param key mixed <p>
 * 調べる値。
 * </p>
 * @param search array <p>
 * キーが存在するかどうかを調べたい配列。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function array_key_exists ($key, array $search) {}

/**
 * <function>current</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.pos.php
 * @param arg
 */
function pos (&$arg) {}

/**
 * <function>count</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.sizeof.php
 * @param var
 * @param mode[optional]
 */
function sizeof ($var, $mode) {}

/**
 * @param key
 * @param search
 */
function key_exists ($key, $search) {}

/**
 * assertion が FALSE であるかどうかを調べる
 * @link http://www.php.net/manual/ja/function.assert.php
 * @param assertion mixed <p>
 * アサーション。
 * </p>
 * @param description string[optional] <p>
 * オプションの説明で、
 * assertion が失敗したときのメッセージにこれを含めます。
 * </p>
 * @return bool アサーションが false となった場合に FALSE、それ以外の場合に TRUE を返します。
 */
function assert ($assertion, $description = null) {}

/**
 * 様々な assert フラグを設定/取得する
 * @link http://www.php.net/manual/ja/function.assert-options.php
 * @param what int <p>
 * <table>
 * assert オプション
 * <tr valign="top">
 * <td>オプション</td>
 * <td>INI 設定</td>
 * <td>デフォルト値</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>ASSERT_ACTIVE</td>
 * <td>assert.active</td>
 * <td>1</td>
 * <td>assert による評価を有効にする</td>
 * </tr>
 * <tr valign="top">
 * <td>ASSERT_WARNING</td>
 * <td>assert.warning</td>
 * <td>1</td>
 * <td>assersion に失敗した場合に PHP 警告を発生する</td>
 * </tr>
 * <tr valign="top">
 * <td>ASSERT_BAIL</td>
 * <td>assert.bail</td>
 * <td>0</td>
 * <td>assersion に失敗した場合に実行を終了する</td>
 * </tr>
 * <tr valign="top">
 * <td>ASSERT_QUIET_EVAL</td>
 * <td>assert.quiet_eval</td>
 * <td>0</td>
 * <td>
 * assersion 式については error_reporting を無効にする
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ASSERT_CALLBACK</td>
 * <td>assert.callback</td>
 * <td)<NULL)</td>
 * <td>assertion に失敗した場合にコールされるコールバック</td>
 * </tr>
 * </table>
 * </p>
 * @param value mixed[optional] <p>
 * オプションに指定する新しい値。
 * </p>
 * @return mixed そのオプションの元の値、あるいはエラー時に FALSE を返します。
 */
function assert_options ($what, $value = null) {}

/**
 * ふたつの "PHP 標準" バージョン番号文字列を比較する
 * @link http://www.php.net/manual/ja/function.version-compare.php
 * @param version1 string <p>
 * 最初のバージョン番号。
 * </p>
 * @param version2 string <p>
 * ふたつめのバージョン番号。
 * </p>
 * @param operator string[optional] <p>
 * 三番目のオプション引数 operator を指定した場合、
 * 特定の関係を調べることが可能です。指定可能な演算子を以下に示します。
 * &lt;,
 * lt, &lt;=,
 * le, &gt;,
 * gt, &gt;=,
 * ge, ==,
 * =, eq,
 * !=, &lt;&gt;,
 * ne
 * </p>
 * <p>
 * このパラメータは大文字小文字を区別するので、すべて小文字で指定しなければなりません。
 * </p>
 * @return mixed デフォルトでは、version_compare の返り値は
 * 最初のバージョンが 2 番目のバージョンより小さい場合に -1、
 * 同じ場合に 0、そして 2 番目のバージョンのほうが小さい場合に
 * 1 となります。
 * </p>
 * <p>
 * オプションの引数 operator を使用すると、
 * 指定した演算子による関係を満たす場合に TRUE、それ以外の場合に
 * FALSE を返すようになります。
 */
function version_compare ($version1, $version2, $operator = null) {}

/**
 * 文字列に rot13 変換を行う
 * @link http://www.php.net/manual/ja/function.str-rot13.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @return string 指定した文字列を ROT13 変換した結果を返します。
 */
function str_rot13 ($str) {}

/**
 * 登録されているフィルタのリストを取得する
 * @link http://www.php.net/manual/ja/function.stream-get-filters.php
 * @return array 使用可能なすべてのストリームフィルタの名前を含む配列を返します。
 */
function stream_get_filters () {}

/**
 * ユーザー定義のストリームフィルタを登録する
 * @link http://www.php.net/manual/ja/function.stream-filter-register.php
 * @param filtername string <p>
 * 登録するフィルタ名。
 * </p>
 * @param classname string <p>
 * フィルタを実装するには、まず、php_user_filter
 * を継承したクラスのメンバ関数を実装しなくてはなりません。
 * PHP は、書き込みまたは読み出し操作を
 * カスタムフィルタの付加されたストリームに対して行う際に、まず
 * データをそのフィルタに(そして、付加されている他のすべてのフィルタにも)
 * 渡し、指示どおりストリームのデータが変更されるようにします。
 * メソッドの実装は、php_user_filter の説明の通りにしなければなりません。
 * さもないと、定義されていない動作をします。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * stream_filter_register は、
 * 指定された filtername がすでに定義されている場合、
 * FALSE を返します。
 */
function stream_filter_register ($filtername, $classname) {}

/**
 * 操作する brigade から bucket オブジェクトを返す
 * @link http://www.php.net/manual/ja/function.stream-bucket-make-writeable.php
 * @param brigade resource 
 * @return object 
 */
function stream_bucket_make_writeable ($brigade) {}

/**
 * bucket を brigade の先頭に追加する
 * @link http://www.php.net/manual/ja/function.stream-bucket-prepend.php
 * @param brigade resource <p>
 * brigade は bucket brigade
 * を指すリソースで、ここにはひとつあるいは複数の
 * bucket オブジェクトが含まれます。
 * </p>
 * @param bucket resource <p>
 * bucket オブジェクト。
 * </p>
 * @return void 値を返しません。
 */
function stream_bucket_prepend ($brigade, $bucket) {}

/**
 * bucket を brigade に追加する
 * @link http://www.php.net/manual/ja/function.stream-bucket-append.php
 * @param brigade resource 
 * @param bucket resource 
 * @return void 
 */
function stream_bucket_append ($brigade, $bucket) {}

/**
 * 現在のストリームで使用する新しい bucket を作成する
 * @link http://www.php.net/manual/ja/function.stream-bucket-new.php
 * @param stream resource 
 * @param buffer string 
 * @return object 
 */
function stream_bucket_new ($stream, $buffer) {}

/**
 * URL リライタの値を追加する
 * @link http://www.php.net/manual/ja/function.output-add-rewrite-var.php
 * @param name string <p>
 * 変数名。
 * </p>
 * @param value string <p>
 * 変数の値。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function output_add_rewrite_var ($name, $value) {}

/**
 * URL リライタの値をリセットする
 * @link http://www.php.net/manual/ja/function.output-reset-rewrite-vars.php
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function output_reset_rewrite_vars () {}

/**
 * 一時ファイル用に使用されるディレクトリのパスを返す
 * @link http://www.php.net/manual/ja/function.sys-get-temp-dir.php
 * @return string 一時ディレクトリのパスを返します。
 */
function sys_get_temp_dir () {}

define ('CONNECTION_ABORTED', 1);
define ('CONNECTION_NORMAL', 0);
define ('CONNECTION_TIMEOUT', 2);
define ('INI_USER', 1);
define ('INI_PERDIR', 2);
define ('INI_SYSTEM', 4);
define ('INI_ALL', 7);

/**
 * 通常の INI スキャナモード (PHP 5.3 以降)。
 * @link http://www.php.net/manual/ja/filesystem.constants.php
 */
define ('INI_SCANNER_NORMAL', 0);

/**
 * 生の INI スキャナモード (PHP 5.3 以降)。
 * @link http://www.php.net/manual/ja/filesystem.constants.php
 */
define ('INI_SCANNER_RAW', 1);
define ('PHP_URL_SCHEME', 0);
define ('PHP_URL_HOST', 1);
define ('PHP_URL_PORT', 2);
define ('PHP_URL_USER', 3);
define ('PHP_URL_PASS', 4);
define ('PHP_URL_PATH', 5);
define ('PHP_URL_QUERY', 6);
define ('PHP_URL_FRAGMENT', 7);
define ('M_E', 2.718281828459);
define ('M_LOG2E', 1.442695040889);
define ('M_LOG10E', 0.43429448190325);
define ('M_LN2', 0.69314718055995);
define ('M_LN10', 2.302585092994);

/**
 * 端数を切り上げる
 * @link http://www.php.net/manual/ja/math.constants.php
 */
define ('M_PI', 3.1415926535898);
define ('M_PI_2', 1.5707963267949);
define ('M_PI_4', 0.78539816339745);
define ('M_1_PI', 0.31830988618379);
define ('M_2_PI', 0.63661977236758);
define ('M_SQRTPI', 1.7724538509055);
define ('M_2_SQRTPI', 1.1283791670955);
define ('M_LNPI', 1.1447298858494);
define ('M_EULER', 0.57721566490153);
define ('M_SQRT2', 1.4142135623731);
define ('M_SQRT1_2', 0.70710678118655);
define ('M_SQRT3', 1.7320508075689);
define ('INF', INF);
define ('NAN', NAN);
define ('PHP_ROUND_HALF_UP', 1);

/**
 * 端数を切り捨てる
 * @link http://www.php.net/manual/ja/math.constants.php
 */
define ('PHP_ROUND_HALF_DOWN', 2);

/**
 * 端数を偶数に丸める
 * @link http://www.php.net/manual/ja/math.constants.php
 */
define ('PHP_ROUND_HALF_EVEN', 3);

/**
 * 端数を奇数に丸める
 * @link http://www.php.net/manual/ja/math.constants.php
 */
define ('PHP_ROUND_HALF_ODD', 4);
define ('INFO_GENERAL', 1);

/**
 * PHP クレジット。phpcreditsも参照してください。
 * @link http://www.php.net/manual/ja/info.constants.php
 */
define ('INFO_CREDITS', 2);

/**
 * PHPディレクティブの現在のローカルおよびマスター値。
 * ini_getも参照してください。
 * @link http://www.php.net/manual/ja/info.constants.php
 */
define ('INFO_CONFIGURATION', 4);

/**
 * ロードされているモジュールとそれぞれの設定。
 * @link http://www.php.net/manual/ja/info.constants.php
 */
define ('INFO_MODULES', 8);

/**
 * 環境変数に関する情報で、$_ENVでも入手可能です。
 * @link http://www.php.net/manual/ja/info.constants.php
 */
define ('INFO_ENVIRONMENT', 16);

/**
 * EGPCS (Environment, GET, POST, Cookie, Server)から定義済の変数を表示します。
 * @link http://www.php.net/manual/ja/info.constants.php
 */
define ('INFO_VARIABLES', 32);

/**
 * PHPライセンス情報。license
 * faqも参照してください。
 * @link http://www.php.net/manual/ja/info.constants.php
 */
define ('INFO_LICENSE', 64);

/**
 * 未使用
 * @link http://www.php.net/manual/ja/info.constants.php
 */
define ('INFO_ALL', -1);

/**
 * コア開発者のリスト
 * @link http://www.php.net/manual/ja/info.constants.php
 */
define ('CREDITS_GROUP', 1);

/**
 * 一般的なクレジット: 言語設計とコンセプト、PHP と
 * PHP SAPIモジュールの作者。
 * @link http://www.php.net/manual/ja/info.constants.php
 */
define ('CREDITS_GENERAL', 2);

/**
 * PHPのサーバーAPIモジュールとその作者の一覧。
 * @link http://www.php.net/manual/ja/info.constants.php
 */
define ('CREDITS_SAPI', 4);

/**
 * PHPの拡張モジュールとその作者の一覧。
 * @link http://www.php.net/manual/ja/info.constants.php
 */
define ('CREDITS_MODULES', 8);

/**
 * ドキュメント作成チームのクレジット
 * @link http://www.php.net/manual/ja/info.constants.php
 */
define ('CREDITS_DOCS', 16);

/**
 * 通常、他のフラグと組み合わせて使用されます。
 * 他のフラグで示される情報を含む完全に独立したHTMLページを出力する
 * ことを指定します。
 * @link http://www.php.net/manual/ja/info.constants.php
 */
define ('CREDITS_FULLPAGE', 32);

/**
 * 品質管理チームのクレジット
 * @link http://www.php.net/manual/ja/info.constants.php
 */
define ('CREDITS_QA', 64);

/**
 * configureオプション、php.ini の場所、構築日、Webサーバー、システム等。
 * @link http://www.php.net/manual/ja/info.constants.php
 */
define ('CREDITS_ALL', -1);
define ('HTML_SPECIALCHARS', 0);
define ('HTML_ENTITIES', 1);
define ('ENT_COMPAT', 2);
define ('ENT_QUOTES', 3);
define ('ENT_NOQUOTES', 0);
define ('ENT_IGNORE', 4);
define ('STR_PAD_LEFT', 0);
define ('STR_PAD_RIGHT', 1);
define ('STR_PAD_BOTH', 2);
define ('PATHINFO_DIRNAME', 1);
define ('PATHINFO_BASENAME', 2);
define ('PATHINFO_EXTENSION', 4);

/**
 * PHP 5.2.0 以降。
 * @link http://www.php.net/manual/ja/filesystem.constants.php
 */
define ('PATHINFO_FILENAME', 8);
define ('CHAR_MAX', 127);
define ('LC_CTYPE', 2);
define ('LC_NUMERIC', 4);
define ('LC_TIME', 5);
define ('LC_COLLATE', 1);
define ('LC_MONETARY', 3);
define ('LC_ALL', 0);
define ('SEEK_SET', 0);
define ('SEEK_CUR', 1);
define ('SEEK_END', 2);
define ('LOCK_SH', 1);
define ('LOCK_EX', 2);
define ('LOCK_UN', 3);
define ('LOCK_NB', 4);

/**
 * 外部のリソースへの接続が確立されたことを示します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_NOTIFY_CONNECT', 2);

/**
 * 指定されたリソースにアクセスするためには、さらに認証情報が必要です。
 * 通常に、STREAM_NOTIFY_SEVERITY_ERR の
 * severity (深刻度) と共に通知されます。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_NOTIFY_AUTH_REQUIRED', 3);

/**
 * 認証が完了した(成功または失敗した)ことを示します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_NOTIFY_AUTH_RESULT', 10);

/**
 * リソースの mime タイプ が確認されました。
 * どのタイプと判定されたかについては、message
 * を見てください。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_NOTIFY_MIME_TYPE_IS', 4);

/**
 * 確認されたリソースのサイズを表します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_NOTIFY_FILE_SIZE_IS', 5);

/**
 * 外部リソースへのアクセスは、別の場所にリダイレクトされました。
 * 詳細を知るには、message を調べてみてください。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_NOTIFY_REDIRECTED', 6);

/**
 * ストリームにおける転送の進捗が、
 * bytes_transferred または、場合によっては
 * bytes_max に現れていることを示します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_NOTIFY_PROGRESS', 7);

/**
 * ストリームにおいて一般的なエラーが発生したことを示します。
 * エラーの詳細については、
 * message と message_code
 * を調べてみてください。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_NOTIFY_FAILURE', 9);

/**
 * これ以上ストリームにデータがないことを示します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_NOTIFY_COMPLETED', 8);

/**
 * 該当するストリームにおいて、リクエストされたリモートのドメイン名の
 * 解決に成功したか、失敗したことを示します。
 * このとき、何が起こっているかについては、
 * severity を参照ください。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_NOTIFY_RESOLVE', 1);

/**
 * 正常な状態における、エラーでない通知があることを示します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_NOTIFY_SEVERITY_INFO', 0);

/**
 * 致命的でないエラーが発生したことを示します。処理は継続されます。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_NOTIFY_SEVERITY_WARN', 1);

/**
 * 致命的なエラーが発生したことを示します。処理は中断されます。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_NOTIFY_SEVERITY_ERR', 2);

/**
 * stream_filter_append または
 * stream_filter_prepend と共に使われます。
 * 指定されたフィルタが 読み込みのときのみ
 * 適用されることを示します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_FILTER_READ', 1);

/**
 * stream_filter_append または
 * stream_filter_prepend と共に使われます。
 * 指定されたフィルタが 書き込みのときのみ
 * 適用されることを示します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_FILTER_WRITE', 2);

/**
 * この定数は右の値と等価です:
 * STREAM_FILTER_READ |
 * STREAM_FILTER_WRITE
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_FILTER_ALL', 3);

/**
 * stream_socket_clientを使って
 * 開かれたソケットが、セッションをまたいでも保持されるよう
 * 指示します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_CLIENT_PERSISTENT', 1);

/**
 * 非同期的にソケットを開きます。このオプションは、
 * STREAM_CLIENT_CONNECT フラグとともに使用する
 * 必要があります。
 * stream_socket_client と共に使われます。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_CLIENT_ASYNC_CONNECT', 2);

/**
 * クライアントソケット接続を開きます。クライアントソケットは
 * 常にこのフラグを含んでいる必要があります。
 * stream_socket_client と共に使われます。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_CLIENT_CONNECT', 4);
define ('STREAM_CRYPTO_METHOD_SSLv2_CLIENT', 0);
define ('STREAM_CRYPTO_METHOD_SSLv3_CLIENT', 1);
define ('STREAM_CRYPTO_METHOD_SSLv23_CLIENT', 2);
define ('STREAM_CRYPTO_METHOD_TLS_CLIENT', 3);
define ('STREAM_CRYPTO_METHOD_SSLv2_SERVER', 4);
define ('STREAM_CRYPTO_METHOD_SSLv3_SERVER', 5);
define ('STREAM_CRYPTO_METHOD_SSLv23_SERVER', 6);
define ('STREAM_CRYPTO_METHOD_TLS_SERVER', 7);

/**
 * stream_socket_shutdown で使用し、
 * それ以降の受信を無効にします。
 * PHP 5.2.1 で追加されました。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_SHUT_RD', 0);

/**
 * stream_socket_shutdown で使用し、
 * それ以降の送信を無効にします。
 * PHP 5.2.1 で追加されました。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_SHUT_WR', 1);

/**
 * stream_socket_shutdown で使用し、
 * それ以降の送受信を無効にします。
 * PHP 5.2.1 で追加されました。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_SHUT_RDWR', 2);

/**
 * Internet Protocol バージョン 4（IPv4）です。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_PF_INET', 2);

/**
 * Internet Protocol バージョン 6（IPv6）です。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_PF_INET6', 23);

/**
 * Unix システムの内部プロトコルです。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_PF_UNIX', 1);

/**
 * IP ソケットを提供します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_IPPROTO_IP', 0);

/**
 * 帯域外データを転送するための、シーケンシャルで双方向の
 * バイトストリーム（例: TCP）を提供します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_SOCK_STREAM', 1);

/**
 * データグラムを提供します。これはコネクションレスのメッセージ
 * （例: UDP）です。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_SOCK_DGRAM', 2);

/**
 * raw ソケットを提供します。これは内部のネットワークプロトコルや
 * インターフェイスへのアクセス機能を提供します。通常、この形式の
 * ソケットは root ユーザーが使用します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_SOCK_RAW', 3);

/**
 * シーケンシャルパケットストリームソケットを提供します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_SOCK_SEQPACKET', 5);

/**
 * RDM（Reliably-delivered messages）ソケットを提供します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_SOCK_RDM', 4);
define ('STREAM_PEEK', 2);
define ('STREAM_OOB', 1);

/**
 * stream_socket_server で開かれたソケットが
 * 特定のターゲットに関連付けられることを示します。
 * サーバーソケットには常にこのフラグが与えられているはずです。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_SERVER_BIND', 4);

/**
 * stream_socket_server で開かれ、
 * STREAM_SERVER_BIND によってターゲットに
 * 関連付けられたストリームに、ソケットに対して接続待ちを開始するよう
 * 指示します。
 * 接続指向の転送（TCP のような）はこのフラグを使用する必要があります。
 * それ以外の場合はサーバーソケットが有効になりません。
 * このフラグを非接続指向の転送（UDP のような）に使用するとエラーになります。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_SERVER_LISTEN', 8);

/**
 * filename を
 * include_path
 * から探します (PHP 5 以降)。
 * @link http://www.php.net/manual/ja/filesystem.constants.php
 */
define ('FILE_USE_INCLUDE_PATH', 1);

/**
 * EOL (行末) 文字を取り除きます (PHP 5 以降)。
 * @link http://www.php.net/manual/ja/filesystem.constants.php
 */
define ('FILE_IGNORE_NEW_LINES', 2);

/**
 * 空行を読み飛ばします (PHP 5 以降)。
 * @link http://www.php.net/manual/ja/filesystem.constants.php
 */
define ('FILE_SKIP_EMPTY_LINES', 4);

/**
 * 既存のファイルに追記します。
 * @link http://www.php.net/manual/ja/filesystem.constants.php
 */
define ('FILE_APPEND', 8);
define ('FILE_NO_DEFAULT_CONTEXT', 16);

/**
 * <p>
 * テキストモード (PHP 5.2.7 以降)。
 * <p>
 * この定数は何の効果もありません。
 * 前方互換性 のためだけに用意されています。
 * </p>
 * </p>
 * @link http://www.php.net/manual/ja/filesystem.constants.php
 */
define ('FILE_TEXT', 0);

/**
 * <p>
 * バイナリモード (PHP 5.2.7 以降)。
 * <p>
 * この定数は何の効果もありません。
 * 前方互換性 のためだけに用意されています。
 * </p>
 * </p>
 * @link http://www.php.net/manual/ja/filesystem.constants.php
 */
define ('FILE_BINARY', 0);

/**
 * バックスラッシュのエスケープを無効にする。
 * @link http://www.php.net/manual/ja/filesystem.constants.php
 */
define ('FNM_NOESCAPE', 1);

/**
 * 文字列中のスラッシュが、指定したパターン内のスラッシュにのみマッチする。
 * @link http://www.php.net/manual/ja/filesystem.constants.php
 */
define ('FNM_PATHNAME', 2);

/**
 * 文字列の先頭のピリオドが、指定したパターン内のピリオドにのみマッチする。
 * @link http://www.php.net/manual/ja/filesystem.constants.php
 */
define ('FNM_PERIOD', 4);

/**
 * 大文字小文字を区別しないマッチを行う。GNU 拡張の一部。
 * @link http://www.php.net/manual/ja/filesystem.constants.php
 */
define ('FNM_CASEFOLD', 16);

/**
 * 返値: ユーザー空間のフィルタが
 * バケットを $out に返したことを
 * 示します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('PSFS_PASS_ON', 2);

/**
 * 返値: ユーザー空間のフィルタが
 * $out にバケットを返さなかったことを
 * 示します。(つまり、変換されたデータを返す用意ができていないという
 * ことです。)
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('PSFS_FEED_ME', 1);

/**
 * 返値: ユーザー空間のフィルタにおいて、
 * 復旧不可能なエラーが発生したことを示します。
 * (つまり、不正なデータを受け取ったということです。)
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('PSFS_ERR_FATAL', 0);

/**
 * 通常の読み書き。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('PSFS_FLAG_NORMAL', 0);

/**
 * インクリメンタルなフラッシュ。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('PSFS_FLAG_FLUSH_INC', 1);

/**
 * 最後に閉じる前にフラッシュ。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('PSFS_FLAG_FLUSH_CLOSE', 2);
define ('CRYPT_SALT_LENGTH', 123);
define ('CRYPT_STD_DES', 1);
define ('CRYPT_EXT_DES', 1);
define ('CRYPT_MD5', 1);
define ('CRYPT_BLOWFISH', 1);
define ('CRYPT_SHA256', 1);
define ('CRYPT_SHA512', 1);
define ('DIRECTORY_SEPARATOR', "\\");

/**
 * PHP 4.3.0 以降で使用可能です。Windows の場合はセミコロン、それ以外の場合はコロンとなります。
 * @link http://www.php.net/manual/ja/dir.constants.php
 */
define ('PATH_SEPARATOR', ";");
define ('GLOB_BRACE', 128);
define ('GLOB_MARK', 8);
define ('GLOB_NOSORT', 32);
define ('GLOB_NOCHECK', 16);
define ('GLOB_NOESCAPE', 4096);
define ('GLOB_ERR', 4);
define ('GLOB_ONLYDIR', 1073741824);
define ('GLOB_AVAILABLE_FLAGS', 1073746108);

/**
 * システムは使用不可
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_EMERG', 1);

/**
 * アクションを直ちに起こすことが必要
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_ALERT', 1);

/**
 * 危機的な条件
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_CRIT', 1);

/**
 * エラー条件
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_ERR', 4);

/**
 * 警告条件
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_WARNING', 5);

/**
 * 正常、しかし、注意すべき条件
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_NOTICE', 6);

/**
 * 情報メッセージ
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_INFO', 6);

/**
 * デバッグレベルメッセージ
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_DEBUG', 6);

/**
 * カーネルメッセージ
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_KERN', 0);

/**
 * 一般ユーザーレベルのメッセージ
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_USER', 8);

/**
 * メールサブシステム
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_MAIL', 16);

/**
 * その他のシステムデーモン
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_DAEMON', 24);

/**
 * セキュリティ/認証メッセージ（LOG_AUTHPRIVが定義されているシステムであれば
 * 代わりにそれを使用してください）
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_AUTH', 32);

/**
 * syslogdによって内部で生成されたメッセージ
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_SYSLOG', 40);

/**
 * ラインプリンタサブシステム
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_LPR', 48);

/**
 * USENETニュースサブシステム
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_NEWS', 56);

/**
 * UUCPサブシステム
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_UUCP', 64);

/**
 * 時刻デーモン (cron and at)
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_CRON', 72);

/**
 * セキュリティ/認証メッセージ (private)
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_AUTHPRIV', 80);

/**
 * 各メッセージにプロセスIDを含める
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_PID', 1);

/**
 * システムロガーにデータを送信する際にエラーが発生した場合、
 * システムコンソールに直接書き込む。
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_CONS', 2);

/**
 * (デフォルト) 最初のメッセージが記録されるまで接続のオープンを
 * 遅延させる。
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_ODELAY', 4);

/**
 * ロガーにただちに接続をオープンする。
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_NDELAY', 8);
define ('LOG_NOWAIT', 16);

/**
 * 標準エラー出力にもログメッセージを出力する
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('LOG_PERROR', 32);
define ('EXTR_OVERWRITE', 0);
define ('EXTR_SKIP', 1);
define ('EXTR_PREFIX_SAME', 2);
define ('EXTR_PREFIX_ALL', 3);
define ('EXTR_PREFIX_INVALID', 4);
define ('EXTR_PREFIX_IF_EXISTS', 5);
define ('EXTR_IF_EXISTS', 6);
define ('EXTR_REFS', 256);

/**
 * SORT_ASCは、
 * array_multisortでソート順を昇順にするために
 * 使用されます。
 * @link http://www.php.net/manual/ja/array.constants.php
 */
define ('SORT_ASC', 4);

/**
 * SORT_DESCは、
 * array_multisortでソート順を降順にするために
 * 使用されます。
 * @link http://www.php.net/manual/ja/array.constants.php
 */
define ('SORT_DESC', 3);

/**
 * SORT_REGULARは通常の比較するために使用され
 * ます。
 * @link http://www.php.net/manual/ja/array.constants.php
 */
define ('SORT_REGULAR', 0);

/**
 * SORT_NUMERICは数値で比較を行うために使用さ
 * れます。
 * @link http://www.php.net/manual/ja/array.constants.php
 */
define ('SORT_NUMERIC', 1);

/**
 * SORT_STRINGは文字列として比較を行うために使
 * 用されます。
 * @link http://www.php.net/manual/ja/array.constants.php
 */
define ('SORT_STRING', 2);

/**
 * SORT_LOCALE_STRINGは現在のロケールに基づいた
 * 文字列として比較を行うために使用されます。 PHP 4.4.0と5.0.2で追加
 * されました。
 * @link http://www.php.net/manual/ja/array.constants.php
 */
define ('SORT_LOCALE_STRING', 5);

/**
 * CASE_LOWERは、
 * array_change_key_caseで使用され、
 * 配列のキーを小文字に変換するために使用されます。小文字は、
 * array_change_key_caseのデフォルトのケースで
 * もあります。
 * @link http://www.php.net/manual/ja/array.constants.php
 */
define ('CASE_LOWER', 0);

/**
 * CASE_UPPERは、
 * array_change_key_caseで使用され、配列のキー
 * を大文字に変換するために使用されます。
 * @link http://www.php.net/manual/ja/array.constants.php
 */
define ('CASE_UPPER', 1);
define ('COUNT_NORMAL', 0);
define ('COUNT_RECURSIVE', 1);
define ('ASSERT_ACTIVE', 1);
define ('ASSERT_CALLBACK', 2);
define ('ASSERT_BAIL', 3);
define ('ASSERT_WARNING', 4);
define ('ASSERT_QUIET_EVAL', 5);

/**
 * フラグ: stream が
 * include_path を使ったかどうかを示します。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_USE_PATH', 1);
define ('STREAM_IGNORE_URL', 2);
define ('STREAM_ENFORCE_SAFE_MODE', 4);

/**
 * フラグ: ストリームを開く際に、
 * ユーザー空間にある wrapper の側で、
 * trigger_error を使ってエラーを発生させるかどうかを
 * 示します。もし、このフラグがセットされていない場合は、
 * ユーザーの側でエラーを投げてはいけません。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_REPORT_ERRORS', 8);

/**
 * このフラグは、拡張モジュール内で、本当にストリームをランダムにシーク
 * する必要があるときに有用です。
 * いくつかの種類のストリームはそのままの形ではシークができないことが
 * あるので、このフラグをセットしておくと、ストリーム API は、
 * まず開かれたストリームがシーク可能かどうかを調べ、シークできない場合は、
 * ストリームのデータをシーク可能な一時的なストレージ (テンポラリファイル
 * あるいはメモリーストリーム) にコピーします。
 * このフラグは、ストリームに対してシーク動作を行ってから書き込みを行うような
 * 場合には適していません。アクセス対象のストリームは当初アクセスを要求した
 * リソースに必ずしも関連付けられているとは限らないからです。
 * もし、要求されたリソースがネットワークベースであった場合、
 * この関数は、すべてのデータが読み込まれるまでブロックします。
 * @link http://www.php.net/manual/ja/internals2.ze1.streams.constants.php
 */
define ('STREAM_MUST_SEEK', 16);
define ('STREAM_URL_STAT_LINK', 1);
define ('STREAM_URL_STAT_QUIET', 2);
define ('STREAM_MKDIR_RECURSIVE', 1);
define ('STREAM_IS_URL', 1);
define ('STREAM_OPTION_BLOCKING', 1);
define ('STREAM_OPTION_READ_TIMEOUT', 4);
define ('STREAM_OPTION_READ_BUFFER', 2);
define ('STREAM_OPTION_WRITE_BUFFER', 3);
define ('STREAM_BUFFER_NONE', 0);
define ('STREAM_BUFFER_LINE', 1);
define ('STREAM_BUFFER_FULL', 2);

/**
 * stream_cast
 * が他からコールされた (上記参照) 場合のストリームのキャスト。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_CAST_AS_STREAM', 0);

/**
 * stream_select が
 * stream_cast をコールしている場合のストリームのキャスト。
 * @link http://www.php.net/manual/ja/stream.constants.php
 */
define ('STREAM_CAST_FOR_SELECT', 3);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_GIF', 1);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_JPEG', 2);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_PNG', 3);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_SWF', 4);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_PSD', 5);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_BMP', 6);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_TIFF_II', 7);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_TIFF_MM', 8);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_JPC', 9);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_JP2', 10);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_JPX', 11);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_JB2', 12);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_SWC', 13);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_IFF', 14);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_WBMP', 15);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_JPEG2000', 9);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_XBM', 16);

/**
 * image_type_to_mime_type および
 * image_type_to_extension
 * 関数で使用する画像形式定数
 * (PHP 5.3.0 以降で利用可能)。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMAGETYPE_ICO', 17);
define ('IMAGETYPE_UNKNOWN', 0);
define ('IMAGETYPE_COUNT', 18);

/**
 * IPv4アドレスリソース
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('DNS_A', 1);

/**
 * Authoritative Name Serverリソース
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('DNS_NS', 2);

/**
 * エイリアス(Canonical Name)リソース
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('DNS_CNAME', 16);

/**
 * 認証リソースの開始
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('DNS_SOA', 32);

/**
 * ポインタリソース
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('DNS_PTR', 2048);

/**
 * ホスト情報リソース（これらの値の意味については、IANA の
 * Operating System Names
 * を参照ください）
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('DNS_HINFO', 4096);

/**
 * Mail Exchangerリソース
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('DNS_MX', 16384);

/**
 * テキストリソース
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('DNS_TXT', 32768);
define ('DNS_SRV', 33554432);
define ('DNS_NAPTR', 67108864);

/**
 * IPv6アドレスリソース
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('DNS_AAAA', 134217728);
define ('DNS_A6', 16777216);

/**
 * 全てのリソースレコード。多くのシステムでは、
 * これは、全てのリソースレコードを返します。
 * しかし、危機的な状況には対応できません。代わりに
 * DNS_ALL を試してください。
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('DNS_ANY', 268435456);

/**
 * 利用可能なレコード型毎のネームサーバーへの反復クエリ。
 * @link http://www.php.net/manual/ja/network.constants.php
 */
define ('DNS_ALL', 251713587);

// End of standard v.5.3.21
?>
