<?php

// Start of oci8 v.1.4.9

class OCI_Lob  {

	/**
	 * ラージオブジェクトの内容を返す
	 * @link http://www.php.net/manual/ja/oci-lob.load.php
	 * @return string オブジェクトの内容、あるいはエラー時に FALSE を返します。
	 */
	public function load () {}

	/**
	 * ラージオブジェクトの内部ポインタの現在位置を返す
	 * @link http://www.php.net/manual/ja/oci-lob.tell.php
	 * @return int LOB の内部ポインタの現在位置を返します。
	 * エラーの場合、FALSE を返します。
	 */
	public function tell () {}

	/**
	 * ラージオブジェクトを切りつめる
	 * @link http://www.php.net/manual/ja/oci-lob.truncate.php
	 * @param length int[optional] <p>
	 * 指定した場合は、このメソッドはラージオブジェクトを
	 * length バイトに切りつめます。
	 * そうでない場合は、LOB を完全に消去します。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function truncate ($length = null) {}

	/**
	 * 内部 LOB データの特定の位置を消去する
	 * @link http://www.php.net/manual/ja/oci-lob.erase.php
	 * @param offset int[optional] <p>
	 * </p>
	 * @param length int[optional] <p>
	 * </p>
	 * @return int 消去された実際の文字数あるいはバイト数、失敗した場合に FALSE を返します
	 */
	public function erase ($offset = null, $length = null) {}

	/**
	 * LOB のバッファをサーバーにフラッシュする、あるいは書き込む
	 * @link http://www.php.net/manual/ja/oci-lob.flush.php
	 * @param flag int[optional] <p>
	 * デフォルトではリソースは解放されませんが、フラグ
	 * OCI_LOB_BUFFER_FREE
	 * を使用することで明示的に行うことができます。
	 * あなたが何をしようとしているかを理解しておいてください -
	 * 次に LOB の同じ箇所に読み書きしようとする場合、
	 * サーバーへのラウンドトリップを伴い、
	 * 新しいバッファリソースが初期化されるでしょう。
	 * もはや LOB に対して何も行わない場合のみ、
	 * OCI_LOB_BUFFER_FREE
	 * フラグを使用することが推奨されます。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 * </p>
	 * <p>
	 * バッファリングが有効でない、あるいはエラーが発生した場合、
	 * FALSE を返します。
	 */
	public function flush ($flag = null) {}

	/**
	 * 現在のラージオブジェクト用のバッファリング状態を変更する
	 * @link http://www.php.net/manual/ja/oci-lob.setbuffering.php
	 * @param on_off bool <p>
	 * TRUE は有効、FALSE は無効を表します。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。 
	 * 同じフラグで繰り返しコールすると TRUE を返します。
	 */
	public function setbuffering ($on_off) {}

	/**
	 * ラージオブジェクトに対する現在のバッファリングの状態を返す
	 * @link http://www.php.net/manual/ja/oci-lob.getbuffering.php
	 * @return bool もしラージオブジェクトに対するバッファリングが無効な場合は FALSE、
	 * 有効な場合は TRUE を返します。
	 */
	public function getbuffering () {}

	/**
	 * 内部ポインタをラージオブジェクトの先頭に移動する
	 * @link http://www.php.net/manual/ja/oci-lob.rewind.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function rewind () {}

	/**
	 * ラージオブジェクトの一部を読み込む
	 * @link http://www.php.net/manual/ja/oci-lob.read.php
	 * @param length int <p>
	 * 読み込むバイト数。
	 * </p>
	 * @return string 読み込んだ内容を表す文字列、失敗した場合に FALSE を返します
	 */
	public function read ($length) {}

	/**
	 * ラージオブジェクトのディスクリプタが EOF かどうかを調べる
	 * @link http://www.php.net/manual/ja/oci-lob.eof.php
	 * @return bool もし、ラージオブジェクトの内部ポインタが LOB の最後にあるとき、
	 * TRUE を返します。その他の場合は FALSE を返します。
	 */
	public function eof () {}

	/**
	 * ラージオブジェクトの内部ポインタをセットする
	 * @link http://www.php.net/manual/ja/oci-lob.seek.php
	 * @param offset int <p>
	 * 内部ポインタを whence
	 * で示された位置から移動させるバイト数を表します。
	 * </p>
	 * @param whence int[optional] <p>
	 * 以下のいずれかです。
	 * OCI_SEEK_SET -
	 * offset と等しい位置にセットします
	 * OCI_SEEK_CUR - 現在の位置に
	 * offset バイト追加します
	 * OCI_SEEK_END - ラージオブジェクトの終端に
	 * offset バイト追加します
	 * (ラージオブジェクトの終端より前の位置に移動するには負の値を指定します)
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function seek ($offset, $whence = null) {}

	/**
	 * データをラージオブジェクトに書き込む
	 * @link http://www.php.net/manual/ja/oci-lob.write.php
	 * @param data string <p>
	 * LOB に書き込むデータ。
	 * </p>
	 * @param length int[optional] <p>
	 * このパラメータを指定すると、
	 * length バイト書き込むか
	 * data の終端に達するか、
	 * いずれか早い方の後に書き込みが停止します。
	 * </p>
	 * @return int 書き込んだバイト数、失敗した場合に FALSE を返します
	 */
	public function write ($data, $length = null) {}

	/**
	 * ラージオブジェクトのデータを他のラージオブジェクトに追加する
	 * @link http://www.php.net/manual/ja/oci-lob.append.php
	 * @param lob_from OCI-Lob <p>
	 * コピーする LOB。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function append (OCI_Lob $lob_from) {}

	/**
	 * ラージオブジェクトのサイズを返す
	 * @link http://www.php.net/manual/ja/oci-lob.size.php
	 * @return int ラージオブジェクトのサイズを返します。
	 * 失敗した場合に FALSE を返します。
	 * 空のオブジェクトは長さ 0 となります。
	 */
	public function size () {}

	/**
	 * <function>OCI-Lob::export</function> のエイリアス
	 * @link http://www.php.net/manual/ja/oci-lob.writetofile.php
	 * @param filename
	 * @param start[optional]
	 * @param length[optional]
	 */
	public function writetofile ($filename, $start, $length) {}

	/**
	 * LOB の内容をファイルに出力する
	 * @link http://www.php.net/manual/ja/oci-lob.export.php
	 * @param filename string <p>
	 * ファイルへのパス。
	 * </p>
	 * @param start int[optional] <p>
	 * 出力を開始する位置。
	 * </p>
	 * @param length int[optional] <p>
	 * 出力するデータの長さ。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function export ($filename, $start = null, $length = null) {}

	/**
	 * ファイルデータを LOB にインポートする
	 * @link http://www.php.net/manual/ja/oci-lob.import.php
	 * @param filename string <p>
	 * ファイルへのパス。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function import ($filename) {}

	/**
	 * 一時的なラージオブジェクトを書き込む
	 * @link http://www.php.net/manual/ja/oci-lob.writetemporary.php
	 * @param data string <p>
	 * 書き込むデータ。
	 * </p>
	 * @param lob_type int[optional] <p>
	 * 以下のいずれかです。
	 * OCI_TEMP_BLOB が一時的な BLOB
	 * を生成するために使われます
	 * OCI_TEMP_CLOB が一時的な CLOB
	 * を生成するために使われます
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function writetemporary ($data, $lob_type = null) {}

	/**
	 * LOB ディスクリプタを閉じる
	 * @link http://www.php.net/manual/ja/oci-lob.close.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function close () {}

	/**
	 * データをラージオブジェクトに保存する
	 * @link http://www.php.net/manual/ja/oci-lob.save.php
	 * @param data string <p>
	 * 保存するデータ。
	 * </p>
	 * @param offset int[optional] <p>
	 * ラージオブジェクトの先頭からのオフセットを指定するために利用します。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function save ($data, $offset = null) {}

	/**
	 * <function>OCI-Lob::import</function> のエイリアス
	 * @link http://www.php.net/manual/ja/oci-lob.savefile.php
	 * @param filename
	 */
	public function savefile ($filename) {}

	/**
	 * LOB ディスクリプタに関連付けられたりソースを解放する
	 * @link http://www.php.net/manual/ja/oci-lob.free.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function free () {}

}

class OCI_Collection  {

	/**
	 * コレクションに要素を追加する
	 * @link http://www.php.net/manual/ja/oci-collection.append.php
	 * @param value mixed <p>
	 * コレクションに追加する値を指定します。文字列か数値です。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function append ($value) {}

	/**
	 * 要素の値を返す
	 * @link http://www.php.net/manual/ja/oci-collection.getelem.php
	 * @param index int <p>
	 * 要素のインデックス。最初のインデックスは 0 です。
	 * </p>
	 * @return mixed もし要素が存在しない場合 FALSE 、要素が NULL 文字列なら
	 * NULL 、要素が文字データ型なら文字列、
	 * 要素が数値フィールドなら数値を返します。
	 */
	public function getelem ($index) {}

	/**
	 * コレクションの要素に値を割り当てる
	 * @link http://www.php.net/manual/ja/oci-collection.assignelem.php
	 * @param index int <p>
	 * 要素のインデックス。最初のインデックスは 0 です。
	 * </p>
	 * @param value mixed <p>
	 * 文字列あるいは数値です。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function assignelem ($index, $value) {}

	/**
	 * コレクションに他の存在するコレクションから値を割り当てる
	 * @link http://www.php.net/manual/ja/oci-collection.assign.php
	 * @param from OCI-Collection <p>
	 * OCI-Collection のインスタンスを指定します。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function assign (OCI_Collection $from) {}

	/**
	 * コレクションのサイズを返す
	 * @link http://www.php.net/manual/ja/oci-collection.size.php
	 * @return int コレクション内の要素の数、もしくはエラー時に FALSE を返します。
	 */
	public function size () {}

	/**
	 * コレクション内の要素の最大数を取得する
	 * @link http://www.php.net/manual/ja/oci-collection.max.php
	 * @return int コレクション内の要素の最大数、あるいはエラー時に
	 * FALSE を返します。
	 * </p>
	 * <p>
	 * 返り値が 0 の場合、要素の数に制限はありません。
	 */
	public function max () {}

	/**
	 * コレクションの最後から要素を切り取る
	 * @link http://www.php.net/manual/ja/oci-collection.trim.php
	 * @param num int <p>
	 * 切り取る要素の数。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function trim ($num) {}

	/**
	 * コレクションオブジェクトに関連付けられたリソースを解放する
	 * @link http://www.php.net/manual/ja/oci-collection.free.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function free () {}

}

/**
 * PHP の変数を、クエリで取得するカラムに関連づける
 * @link http://www.php.net/manual/ja/function.oci-define-by-name.php
 * @param statement resource &oci.arg.statement.id;
 * @param column_name string <p>
 * クエリで使用するカラム名。
 * </p>
 * <p>
 * Oracle のデフォルトである大文字小文字を区別しないカラム名では大文字を使います。
 * 大文字小文字を区別するカラム名の場合は、正確なカラム名を使います。
 * </p>
 * @param variable mixed <p>
 * 返されるカラムの値を格納する PHP 変数。
 * </p>
 * @param type int[optional] <p>
 * 返されるデータの型。一般的には不要です。
 * Oracle 式のデータ変換は行われないことに注意しましょう。たとえば、
 * SQLT_INT は無視され、返されるデータの型は
 * SQLT_CHR のままとなります。
 * </p>
 * <p>
 * オプションで、oci_new_descriptor を使って
 * LOB/ROWID/BFILE の領域を確保することもできます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_define_by_name ($statement, $column_name, &$variable, $type = null) {}

/**
 * Oracle プレースホルダに PHP 変数をバインドする
 * @link http://www.php.net/manual/ja/function.oci-bind-by-name.php
 * @param statement resource <p>
 * 有効な OCI8 ステートメント識別子。
 * </p>
 * @param bv_name string <p>
 * コロンを先頭につけたバインド変数プレースホルダをステートメント内で使います。
 * コロンは bv_name では必須ではありません。
 * Oracle はクエスチョンマークをプレースホルダとして使いません。
 * </p>
 * @param variable mixed <p>
 * bv_name に関連づける PHP の変数。
 * </p>
 * @param maxlength int[optional] <p>
 * バインド時の最大長。-1 に設定した場合、
 * variable の現在の長さを最大長として設定します。
 * この場合は、oci_bind_by_name がコールされたときに
 * variable が存在してデータが格納されている必要があります。
 * </p>
 * @param type int[optional] <p>
 * Oracle がデータを扱うときのデータ型。デフォルトの
 * type は
 * SQLT_CHR です。
 * Oracle は、可能な場合はこの型とデータベースのカラム
 * (あるいは PL/SQL の変数) の型の間で変換を行います。
 * </p>
 * <p>
 * 抽象データ型 (LOB/ROWID/BFILE) をバインドする必要がある場合、まず
 * oci_new_descriptor
 * 関数を使用してこれを確保する必要があります。
 * length は抽象データ型用には
 * 使用されず、-1 を設定する必要があります。
 * </p>
 * <p>
 * type に設定できる値は以下のとおりです。
 * <p>
 * SQLT_BFILEE or OCI_B_BFILE
 * - BFILE 用
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_bind_by_name ($statement, $bv_name, &$variable, $maxlength = null, $type = null) {}

/**
 * PHP の配列を Oracle PL/SQL の配列に名前でバインドする
 * @link http://www.php.net/manual/ja/function.oci-bind-array-by-name.php
 * @param statement resource <p>
 * 有効な OCI ステートメント識別子
 * </p>
 * @param name string <p>
 * Oracle のプレースホルダ
 * </p>
 * @param var_array array <p>
 * 配列
 * </p>
 * @param max_table_length int <p>
 * 入力配列および結果の配列の両方の最大長を設定する
 * </p>
 * @param max_item_length int[optional] <p>
 * 配列要素の最大長を設定する。もし指定されない、もしくは -1
 * が指定された場合、oci_bind_array_by_name
 * は入力の配列の中で最も長い要素を探し、その長さを最大長とする。
 * </p>
 * @param type int[optional] <p>
 * PL/SQL 配列の項目の型を指定するために利用される。
 * 指定可能な型については以下を参照のこと。
 * </p>
 * <p>
 * <p>
 * SQLT_NUM - NUMBER の配列
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_bind_array_by_name ($statement, $name, array &$var_array, $max_table_length, $max_item_length = null, $type = null) {}

/**
 * フィールドが NULL であるかどうかを確認する
 * @link http://www.php.net/manual/ja/function.oci-field-is-null.php
 * @param statement resource <p>
 * 有効な OCI ステートメント ID。
 * </p>
 * @param field mixed <p>
 * フィールド番号またはフィールド名 (大文字)。
 * </p>
 * @return bool field が NULL の場合に TRUE、
 * それ以外の場合に FALSE を返します。
 */
function oci_field_is_null ($statement, $field) {}

/**
 * 文からのフィールド名を返す
 * @link http://www.php.net/manual/ja/function.oci-field-name.php
 * @param statement resource <p>
 * 有効な OCI ステートメント ID。
 * </p>
 * @param field int <p>
 * フィールド番号 (1 から始まる) あるいは名前のいずれか。
 * </p>
 * @return string 名前を表す文字列、あるいはエラー時に FALSE を返します。
 */
function oci_field_name ($statement, $field) {}

/**
 * フィールドサイズを返す
 * @link http://www.php.net/manual/ja/function.oci-field-size.php
 * @param statement resource <p>
 * 有効な OCI ステートメント ID。
 * </p>
 * @param field mixed <p>
 * フィールドのインデックス (1 から始まるもの) あるいは名前。
 * </p>
 * @return int フィールド field のサイズを表すバイト数、あるいは
 * エラー時に FALSE を返します。
 */
function oci_field_size ($statement, $field) {}

/**
 * フィールドの桁数を問い合わせる
 * @link http://www.php.net/manual/ja/function.oci-field-scale.php
 * @param statement resource <p>
 * 有効な OCI ステートメント ID。
 * </p>
 * @param field int <p>
 * フィールド番号 (1 から始まる) あるいは名前のいずれか。
 * </p>
 * @return int 桁数を表す整数値、あるいはエラー時に FALSE を返します。
 */
function oci_field_scale ($statement, $field) {}

/**
 * フィールドの精度を問い合わせる
 * @link http://www.php.net/manual/ja/function.oci-field-precision.php
 * @param statement resource <p>
 * 有効な OCI ステートメント ID。
 * </p>
 * @param field int <p>
 * フィールド番号 (1 から始まる) あるいは名前のいずれか。
 * </p>
 * @return int 精度を表す整数値、あるいはエラー時に FALSE を返します。
 */
function oci_field_precision ($statement, $field) {}

/**
 * フィールドのデータ型を返す
 * @link http://www.php.net/manual/ja/function.oci-field-type.php
 * @param statement resource <p>
 * 有効な OCI ステートメント ID。
 * </p>
 * @param field int <p>
 * フィールド番号 (1 から始まる) あるいは名前のいずれか。
 * </p>
 * @return mixed フィールドのデータ型を表す文字列、あるいはエラー時に FALSE を返します。
 */
function oci_field_type ($statement, $field) {}

/**
 * Oracle におけるフィールドの型を問い合わせる
 * @link http://www.php.net/manual/ja/function.oci-field-type-raw.php
 * @param statement resource <p>
 * 有効な OCI ステートメント ID。
 * </p>
 * @param field int <p>
 * フィールド番号 (1 から始まる) あるいは名前のいずれか。
 * </p>
 * @return int Oracle のデータ型を表す文字列、あるいはエラー時に FALSE を返します。
 */
function oci_field_type_raw ($statement, $field) {}

/**
 * 文を実行する
 * @link http://www.php.net/manual/ja/function.oci-execute.php
 * @param statement resource <p>
 * 有効な OCI ステートメント ID。
 * </p>
 * @param mode int[optional] <p>
 * オプションの二番目のパラメータは、次の定数のいずれかとなります。
 * <table>
 * 実行モード
 * <tr valign="top">
 * <td>定数</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>OCI_COMMIT_ON_SUCCESS</td>
 * <td>ステートメントの実行に成功すると、
 * この接続においてまだ確定していない変更をすべてコミットします。
 * これがデフォルトです。</td>
 * </tr>
 * <tr valign="top">
 * <td>OCI_DESCRIBE_ONLY</td>
 * <td>oci_field_name
 * 関数などでクエリのメタデータを使えるようにしますが、
 * 結果セットは作りません。続けて
 * oci_fetch_array
 * などをコールすると失敗します。</td>
 * </tr>
 * <tr valign="top">
 * <td>OCI_NO_AUTO_COMMIT</td>
 * <td>変更を自動的にはコミットしません。PHP
 * 5.3.2 (PECL OCI8 1.4) より前のバージョンでは
 * OCI_DEFAULT を使います。これは、
 * OCI_NO_AUTO_COMMIT と同じ意味です。</td>
 * </tr>
 * </table>
 * </p>
 * <p>
 * OCI_NO_AUTO_COMMIT モードを使うとトランザクションを開始あるいは続行します。
 * 接続を閉じたりスクリプトが終了したりしたときに、
 * トランザクションは自動的にロールバックされます。
 * トランザクションをコミットするには
 * oci_commit を、破棄するには
 * oci_rollback をコールします。
 * </p>
 * <p>
 * データを追加したり更新したりする際には、
 * リレーショナルデータの一貫性やパフォーマンスなどを考慮して
 * トランザクションを使うことを推奨します。
 * </p>
 * <p>
 * OCI_NO_AUTO_COMMIT モードを使った文を実行した後に
 * oci_commit
 * あるいは oci_rollback をコールしなかった場合、
 * たとえデータが変更されていなくても
 * スクリプトの終了時に OCI8 がロールバックを実行します。
 * 不要なロールバックを避けるために、多くのスクリプトはクエリや PL/SQL で
 * OCI_NO_AUTO_COMMIT モードを使いません。
 * 同じスクリプトの中で異なるモードで
 * oci_execute を実行する場合は、
 * アプリケーション内で適切なトランザクションの一貫性を確保するよう注意しましょう。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_execute ($statement, $mode = null) {}

/**
 * カーソルからの読み込みをキャンセルする
 * @link http://www.php.net/manual/ja/function.oci-cancel.php
 * @param statement resource <p>
 * OCI ステートメント
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_cancel ($statement) {}

/**
 * クエリの次の行を内部バッファに取得する
 * @link http://www.php.net/manual/ja/function.oci-fetch.php
 * @param statement resource &oci.arg.statement.id;
 * @return bool 成功した場合に TRUE、
 * statement にもう行がない場合に
 * FALSE を返します。
 */
function oci_fetch ($statement) {}

/**
 * クエリの次の行をオブジェクトとして返す
 * @link http://www.php.net/manual/ja/function.oci-fetch-object.php
 * @param statement resource &oci.arg.statement.id;
 * @return object オブジェクトを返します。
 * オブジェクトの属性は文中のフィールドと一致しています。
 * statement にもう行がない場合は FALSE を返します。
 * </p>
 * <p>
 * LOB カラムは LOB ディスクリプタを返します。
 * </p>
 * <p>
 * DATE カラムは、現行のデータフォーマットにフォーマットされた
 * 文字列として返されます。既定のフォーマットは NLS_LANG
 * のような Oracle 環境変数で変更したり、またはあらかじめ
 * ALTER SESSION SET NLS_DATE_FORMAT コマンドを実行して変更します。
 * </p>
 * <p>
 * Oracle のデフォルトでは、文字の大小を区別しないカラム名はすべて大文字となります。
 * 文字の大小を区別するカラム名は、属性の名前もそれと同じになります。
 * 結果のオブジェクト配列を var_dump すれば、
 * 各クエリの文字の大小を確かめられます。
 * </p>
 * <p>
 * NULL データ・フィールドの全てに対して、属性の値は NULL になります。
 */
function oci_fetch_object ($statement) {}

/**
 * クエリの次の行を配列で返す
 * @link http://www.php.net/manual/ja/function.oci-fetch-row.php
 * @param statement resource &oci.arg.statement.id;
 * @return array 数値添字配列を返します。
 * statement にもう行がない場合は FALSE を返します。
 */
function oci_fetch_row ($statement) {}

/**
 * クエリの次の行を連想配列で返す
 * @link http://www.php.net/manual/ja/function.oci-fetch-assoc.php
 * @param statement resource &oci.arg.statement.id;
 * @return array 連想配列を返します。
 * statement にもう行がない場合は FALSE を返します。
 */
function oci_fetch_assoc ($statement) {}

/**
 * クエリの次の行を連想配列あるいは数値添字配列で返す
 * @link http://www.php.net/manual/ja/function.oci-fetch-array.php
 * @param statement resource &oci.arg.statement.id;
 * @param mode int[optional] <p>
 * オプションの第2引数は、次の定数の組み合わせが可能です。
 * <table>
 * oci_fetch_array のモード
 * <tr valign="top">
 * <td>定数</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>OCI_BOTH</td>
 * <td>連想配列と配列の両方を返します。
 * これは OCI_ASSOC
 * + OCI_NUM と同等で、
 * デフォルトの動作です。</td>
 * </tr>
 * <tr valign="top">
 * <td>OCI_ASSOC</td>
 * <td>連想配列を返します。</td>
 * </tr>
 * <tr valign="top">
 * <td>OCI_NUM</td>
 * <td>数値添字配列を返します。</td>
 * </tr>
 * <tr valign="top">
 * <td>OCI_RETURN_NULLS</td>
 * <td>NULL フィールドの要素も作成します。この要素の値は
 * PHP の NULL となります。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>OCI_RETURN_LOBS</td>
 * <td>LOB ディスクリプタではなく LOB の中身を返します。</td>
 * </tr>
 * </table>
 * </p>
 * <p>
 * デフォルトの mode は OCI_BOTH です。
 * </p>
 * <p>
 * 加算演算子 &quot;+&quot; を使うと、複数のモードを同時に指定できます。
 * </p>
 * @return array 連想配列や数値添字配列を返します。
 * statement にもう行がない場合は
 * FALSE を返します。
 * </p>
 * <p>
 * デフォルトでは、LOB カラムは LOB ディスクリプタを返します。
 * </p>
 * <p>
 * DATE カラムは、現行のデータフォーマットにフォーマットされた
 * 文字列として返されます。既定のフォーマットは NLS_LANG
 * のような Oracle 環境変数で変更したり、またはあらかじめ
 * ALTER SESSION SET NLS_DATE_FORMAT コマンドを実行して変更します。
 * </p>
 * <p>
 * Oracle のデフォルトでは、大文字小文字を区別しないカラム名はすべて大文字となり、
 * 結果の連想配列のインデックスも大文字になります。
 * 大文字小文字を区別するカラム名は、配列のインデックスもそれと同じになります。
 * 結果の配列を var_dump すれば、
 * 各クエリの大文字小文字を確かめることができます。
 */
function oci_fetch_array ($statement, $mode = null) {}

/**
 * 結果配列の次の行を取得する (非推奨)
 * @link http://www.php.net/manual/ja/function.ocifetchinto.php
 * @param statement resource 
 * @param result array 
 * @param mode int[optional] 
 * @return int 
 */
function ocifetchinto ($statement, array &$result, $mode = null) {}

/**
 * クエリからの複数の行を二次元配列に取得する
 * @link http://www.php.net/manual/ja/function.oci-fetch-all.php
 * @param statement resource &oci.arg.statement.id;
 * @param output array <p>
 * 返された行を格納する変数。
 * </p>
 * <p>
 * LOB 列は文字列として返されます。
 * Oracle は変換をサポートしています。
 * </p>
 * <p>
 * データや型の取得についての詳細な情報は
 * oci_fetch_array を参照ください。
 * </p>
 * @param skip int[optional] <p>
 * 結果を取得する際に無視する行数
 * (デフォルトの値は 0 で、最初の行から開始されます)。
 * </p>
 * @param maxrows int[optional] <p>
 * 読み込む行数。デフォルトは -1 で、これは
 * skip + 1 番目の行以降のすべての行を意味します。
 * </p>
 * @param flags int[optional] <p>
 * パラメータ flags は、
 * 配列の構造をあらわし、また連想配列を使うかどうかもあらわします。
 * <table>
 * oci_fetch_all の配列構造モード
 * <tr valign="top">
 * <td>定数</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>OCI_FETCHSTATEMENT_BY_ROW</td>
 * <td>配列の配列で、内側の配列はクエリの行単位となります。</td>
 * </tr>
 * <tr valign="top">
 * <td>OCI_FETCHSTATEMENT_BY_COLUMN</td>
 * <td>配列の配列で、内側の配列はクエリの列単位となります。
 * これがデフォルトです。</td>
 * </tr>
 * </table>
 * </p>
 * <p>
 * 配列のインデックスには、カラム名あるいは数値を使うことができます。
 * <table>
 * oci_fetch_all の配列インデックスモード
 * <tr valign="top">
 * <td>定数</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>OCI_NUM</td>
 * <td>各列の配列に数値添字を使います。</td>
 * </tr>
 * <tr valign="top">
 * <td>OCI_ASSOC</td>
 * <td>各カラムを連想配列にします。
 * これがデフォルトです。</td>
 * </tr>
 * </table>
 * </p>
 * <p>
 * 加算演算子 &quot;+&quot; を使って、
 * 配列の構造とインデックス形式の組み合わせを選択します。
 * </p>
 * <p>
 * Oracle のデフォルトである大文字小文字を区別しないカラム名の場合は、
 * 配列のキーは大文字となります。大文字小文字を区別するカラム名の場合は、
 * 配列のキーの大文字小文字は実際のカラム名と同じになります。
 * var_dump で output
 * を確認し、大文字小文字を適切に指定するようにしましょう。
 * </p>
 * <p>
 * 同じ名前のカラムが複数あるクエリでは、カラムの別名を使わなければなりません。
 * そうしないと、連想配列にあらわれるのはその中の一つのカラムだけとなってしまいます。
 * </p>
 * @return int output の行数を返します。これは 0 以上の値となります。
 * 失敗した場合に FALSE を返します.
 */
function oci_fetch_all ($statement, array &$output, $skip = null, $maxrows = null, $flags = null) {}

/**
 * 文やカーソルに関連付けられた全てのリソースを解放する
 * @link http://www.php.net/manual/ja/function.oci-free-statement.php
 * @param statement resource <p>
 * 有効な OCI ステートメント ID。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_free_statement ($statement) {}

/**
 * 内部デバッグ用の出力を有効または無効にする
 * @link http://www.php.net/manual/ja/function.oci-internal-debug.php
 * @param onoff bool <p>
 * これを FALSE にするとデバッグ出力をオフにし、
 * TRUE にするとオンになります。
 * </p>
 * @return void 値を返しません。
 */
function oci_internal_debug ($onoff) {}

/**
 * ある文における結果のカラム数を返す
 * @link http://www.php.net/manual/ja/function.oci-num-fields.php
 * @param statement resource <p>
 * 有効な OCI ステートメント ID。
 * </p>
 * @return int カラムの数を表す整数値、あるいはエラー時に FALSE を返します。
 */
function oci_num_fields ($statement) {}

/**
 * 実行のために Oracle の文をパースする
 * @link http://www.php.net/manual/ja/function.oci-parse.php
 * @param connection resource <p>
 * oci_connect、oci_pconnect
 * あるいは oci_new_connect
 * が返す Oracle 接続 ID。
 * </p>
 * @param sql_text string <p>
 * SQL あるいは PL/SQL ステートメント。
 * </p>
 * <p>
 * SQL の最後にセミコロン (&quot;;&quot;) をつけては
 * いけません。一方、PL/SQL ステートメントの最後はセミコロン
 * (&quot;;&quot;) を つけなければなりません。
 * </p>
 * @return resource 成功した場合にステートメントハンドル、あるいはエラー時に FALSE を返します。
 */
function oci_parse ($connection, $sql_text) {}

/**
 * 新規カーソル (ステートメントハンドル) を割り当て、それを返す
 * @link http://www.php.net/manual/ja/function.oci-new-cursor.php
 * @param connection resource <p>
 * oci_connect あるいは oci_pconnect
 * が返す Oracle 接続 ID。
 * </p>
 * @return resource 新しいステートメントハンドル、あるいはエラー時に FALSE を返します。
 */
function oci_new_cursor ($connection) {}

/**
 * フェッチした行からフィールドの値を取得する
 * @link http://www.php.net/manual/ja/function.oci-result.php
 * @param statement resource <p>
 * </p>
 * @param field mixed <p>
 * カラム番号
 * (1から始まる) またはカラム名 (大文字) のどちらかを使用可能です。
 * </p>
 * @return mixed 抽象型 (ROWID, LOB, FILE) を除き、全てを文字列として返します。
 * エラーの場合、FALSE を返します。
 */
function oci_result ($statement, $field) {}

/**
 * Oracle クライアント・ライブラリのバージョンを返す
 * @link http://www.php.net/manual/ja/function.oci-client-version.php
 * @return string 文字列としてバージョン番号を返します。
 */
function oci_client_version () {}

/**
 * Oracle データベースのバージョンを返す
 * @link http://www.php.net/manual/ja/function.oci-server-version.php
 * @param connection resource <p>
 * </p>
 * @return string バージョン情報を表す文字列、あるいはエラー時に FALSE を返します。
 */
function oci_server_version ($connection) {}

/**
 * ステートメントの種類を返す
 * @link http://www.php.net/manual/ja/function.oci-statement-type.php
 * @param statement resource <p>
 * oci_parse が返す、有効な OCI8 ステートメント ID。
 * </p>
 * @return string ステートメント statement
 * の種類を次のいずれかの値で返します。
 * <table>
 * ステートメントの種類
 * <tr valign="top">
 * <td>返される文字列</td>
 * <td>注意</td>
 * </tr>
 * <tr valign="top">
 * <td>ALTER</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>BEGIN</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>CALL</td>
 * <td>PHP 5.2.1 (PECL OCI8 1.2.3) 以降で使用可能です。</td>
 * </tr>
 * <tr valign="top">
 * <td>CREATE</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>DECLARE</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>DELETE</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>DROP</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>INSERT</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>SELECT</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>UPDATE</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>UNKNOWN</td>
 * <td></td>
 * </tr>
 * </table>
 * </p>
 * <p>
 * エラー時には FALSE を返します。
 */
function oci_statement_type ($statement) {}

/**
 * 文の実行で作用された行数を取得する
 * @link http://www.php.net/manual/ja/function.oci-num-rows.php
 * @param statement resource <p>
 * 有効な OCI ステートメント ID。
 * </p>
 * @return int 作用された行の数を表す整数値、あるいはエラー時に FALSE を返します。
 */
function oci_num_rows ($statement) {}

/**
 * Oracleとの接続を閉じる
 * @link http://www.php.net/manual/ja/function.oci-close.php
 * @param connection resource <p>
 * oci_connect、oci_pconnect
 * あるいは oci_new_connect が返す Oracle 接続 ID。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_close ($connection) {}

/**
 * Oracle データベースに接続する
 * @link http://www.php.net/manual/ja/function.oci-connect.php
 * @param username string <p>
 * Oracle ユーザー名
 * </p>
 * @param password string <p>
 * username に対するパスワード
 * </p>
 * @param connection_string string[optional] 接続先の Oracle インスタンス。
 * Easy Connect
 * 文字列、tnsnames.ora
 * ファイルの接続文字列、あるいはローカルの Oracle インスタンス名を指定します。
 * </p>
 * 省略した場合、PHP は環境変数
 * TWO_TASK (Linux) あるいは
 * LOCAL (Windows)
 * と ORACLE_SID を用いて接続先の
 * Oracle インスタンス を判断します。
 * </p>
 * Easy Connect 方式を使うには、PHP を Oracle
 * 10g 以降のクライアントライブラリとリンクさせる必要があります。Oracle 10g の Easy Connect
 * 文字列の形式は
 * [//]host_name[:port][/service_name] です。Oracle
 * 11g の場合は、この構文は
 * [//]host_name[:port][/service_name][:server_type][/instance_name]
 * となります。サービス名を調べるには、Oracle のユーティリティ
 * lsnrctl status をデータベースサーバー上で実行します。
 * </p>
 * tnsnames.ora ファイルは Oracle Net のサーチパス上にあります。
 * サーチパスに含まれるのは $ORACLE_HOME/network/admin
 * や /etc です。もうひとつの方法として、
 * TNS_ADMIN を指定して
 * $TNS_ADMIN/tnsnames.ora を読み込ませることもできます。
 * ウェブデーモンにそのファイルの読み込み権限を与えておきましょう。
 * </p>
 * @param character_set string[optional] Oracle クライアントライブラリが使う文字セットを指定します。
 * これは、データベースが用いる文字セットと一致させる必要はありません。
 * 一致していない場合は、Oracle
 * が最善を尽くしてデータベースの文字セットとの間の変換を行います。
 * 文字セットによっては、この変換結果がうまく使えないこともあります。
 * また、変換にはそれなりの時間を要します。
 * </p>
 * 省略した場合は、
 * Oracle クライアントライブラリは環境変数 NLS_LANG
 * の値をもとに文字セットを判断します。
 * </p>
 * このパラメータを渡すことで、
 * 接続に要する時間を短縮できます。
 * </p>
 * @param session_mode int[optional] このパラメータは PHP 5 (PECL OCI8 1.1) 以降で使え、
 * OCI_DEFAULT、
 * OCI_SYSOPER そして OCI_SYSDBA
 * といった値を指定することができます。OCI_SYSOPER あるいは
 * OCI_SYSDBA を指定した場合は、
 * この関数は外部の証明書を使った特権接続の確立を試みます。
 * 特権接続は、デフォルトでは無効になっています。有効にするには
 * oci8.privileged_connect
 * を On に設定しなければなりません。
 * </p>
 * PHP 5.3 (PECL OCI8 1.3.4) 以降、
 * OCI_CRED_EXT モードを使えるようになりました。
 * これは、Oracle に外部認証あるいは OS 認証を使うよう指示します。
 * どちらかをデータベースで設定しておかなければなりません。
 * OCI_CRED_EXT フラグを使えるのは、ユーザー名が
 * &quot;/&quot; でパスワードが空のときだけです。
 * oci8.privileged_connect
 * は On あるいは Off のどちらでもかまいません。
 * </p>
 * OCI_CRED_EXT は、
 * OCI_SYSOPER あるいは
 * OCI_SYSDBA モードと組み合わせて使います。
 * </p>
 * OCI_CRED_EXT は、セキュリティ上の理由により
 * Windows ではサポートされていません。
 * </p>
 * @return resource 接続 ID、もしくはエラー時は FALSE を返します。
 */
function oci_connect ($username, $password, $connection_string = null, $character_set = null, $session_mode = null) {}

/**
 * 一意な接続を使って Oracle サーバーへ接続する
 * @link http://www.php.net/manual/ja/function.oci-new-connect.php
 * @param username string <p>
 * Oracle のユーザー名。
 * </p>
 * @param password string <p>
 * username のパスワード。
 * </p>
 * @param connection_string string[optional] 接続先の Oracle インスタンス。
 * Easy Connect
 * 文字列、tnsnames.ora
 * ファイルの接続文字列、あるいはローカルの Oracle インスタンス名を指定します。
 * </p>
 * 省略した場合、PHP は環境変数
 * TWO_TASK (Linux) あるいは
 * LOCAL (Windows)
 * と ORACLE_SID を用いて接続先の
 * Oracle インスタンス を判断します。
 * </p>
 * Easy Connect 方式を使うには、PHP を Oracle
 * 10g 以降のクライアントライブラリとリンクさせる必要があります。Oracle 10g の Easy Connect
 * 文字列の形式は
 * [//]host_name[:port][/service_name] です。Oracle
 * 11g の場合は、この構文は
 * [//]host_name[:port][/service_name][:server_type][/instance_name]
 * となります。サービス名を調べるには、Oracle のユーティリティ
 * lsnrctl status をデータベースサーバー上で実行します。
 * </p>
 * tnsnames.ora ファイルは Oracle Net のサーチパス上にあります。
 * サーチパスに含まれるのは $ORACLE_HOME/network/admin
 * や /etc です。もうひとつの方法として、
 * TNS_ADMIN を指定して
 * $TNS_ADMIN/tnsnames.ora を読み込ませることもできます。
 * ウェブデーモンにそのファイルの読み込み権限を与えておきましょう。
 * </p>
 * @param character_set string[optional] Oracle クライアントライブラリが使う文字セットを指定します。
 * これは、データベースが用いる文字セットと一致させる必要はありません。
 * 一致していない場合は、Oracle
 * が最善を尽くしてデータベースの文字セットとの間の変換を行います。
 * 文字セットによっては、この変換結果がうまく使えないこともあります。
 * また、変換にはそれなりの時間を要します。
 * </p>
 * 省略した場合は、
 * Oracle クライアントライブラリは環境変数 NLS_LANG
 * の値をもとに文字セットを判断します。
 * </p>
 * このパラメータを渡すことで、
 * 接続に要する時間を短縮できます。
 * </p>
 * @param session_mode int[optional] このパラメータは PHP 5 (PECL OCI8 1.1) 以降で使え、
 * OCI_DEFAULT、
 * OCI_SYSOPER そして OCI_SYSDBA
 * といった値を指定することができます。OCI_SYSOPER あるいは
 * OCI_SYSDBA を指定した場合は、
 * この関数は外部の証明書を使った特権接続の確立を試みます。
 * 特権接続は、デフォルトでは無効になっています。有効にするには
 * oci8.privileged_connect
 * を On に設定しなければなりません。
 * </p>
 * PHP 5.3 (PECL OCI8 1.3.4) 以降、
 * OCI_CRED_EXT モードを使えるようになりました。
 * これは、Oracle に外部認証あるいは OS 認証を使うよう指示します。
 * どちらかをデータベースで設定しておかなければなりません。
 * OCI_CRED_EXT フラグを使えるのは、ユーザー名が
 * &quot;/&quot; でパスワードが空のときだけです。
 * oci8.privileged_connect
 * は On あるいは Off のどちらでもかまいません。
 * </p>
 * OCI_CRED_EXT は、
 * OCI_SYSOPER あるいは
 * OCI_SYSDBA モードと組み合わせて使います。
 * </p>
 * OCI_CRED_EXT は、セキュリティ上の理由により
 * Windows ではサポートされていません。
 * </p>
 * @return resource 接続 ID、あるいはエラー時に FALSE を返します。
 */
function oci_new_connect ($username, $password, $connection_string = null, $character_set = null, $session_mode = null) {}

/**
 * 持続的接続を使用してOracle データベースに接続する
 * @link http://www.php.net/manual/ja/function.oci-pconnect.php
 * @param username string <p>
 * Oracle のユーザー名。
 * </p>
 * @param password string <p>
 * username のパスワード。
 * </p>
 * @param connection_string string[optional] 接続先の Oracle インスタンス。
 * Easy Connect
 * 文字列、tnsnames.ora
 * ファイルの接続文字列、あるいはローカルの Oracle インスタンス名を指定します。
 * </p>
 * 省略した場合、PHP は環境変数
 * TWO_TASK (Linux) あるいは
 * LOCAL (Windows)
 * と ORACLE_SID を用いて接続先の
 * Oracle インスタンス を判断します。
 * </p>
 * Easy Connect 方式を使うには、PHP を Oracle
 * 10g 以降のクライアントライブラリとリンクさせる必要があります。Oracle 10g の Easy Connect
 * 文字列の形式は
 * [//]host_name[:port][/service_name] です。Oracle
 * 11g の場合は、この構文は
 * [//]host_name[:port][/service_name][:server_type][/instance_name]
 * となります。サービス名を調べるには、Oracle のユーティリティ
 * lsnrctl status をデータベースサーバー上で実行します。
 * </p>
 * tnsnames.ora ファイルは Oracle Net のサーチパス上にあります。
 * サーチパスに含まれるのは $ORACLE_HOME/network/admin
 * や /etc です。もうひとつの方法として、
 * TNS_ADMIN を指定して
 * $TNS_ADMIN/tnsnames.ora を読み込ませることもできます。
 * ウェブデーモンにそのファイルの読み込み権限を与えておきましょう。
 * </p>
 * @param character_set string[optional] Oracle クライアントライブラリが使う文字セットを指定します。
 * これは、データベースが用いる文字セットと一致させる必要はありません。
 * 一致していない場合は、Oracle
 * が最善を尽くしてデータベースの文字セットとの間の変換を行います。
 * 文字セットによっては、この変換結果がうまく使えないこともあります。
 * また、変換にはそれなりの時間を要します。
 * </p>
 * 省略した場合は、
 * Oracle クライアントライブラリは環境変数 NLS_LANG
 * の値をもとに文字セットを判断します。
 * </p>
 * このパラメータを渡すことで、
 * 接続に要する時間を短縮できます。
 * </p>
 * @param session_mode int[optional] このパラメータは PHP 5 (PECL OCI8 1.1) 以降で使え、
 * OCI_DEFAULT、
 * OCI_SYSOPER そして OCI_SYSDBA
 * といった値を指定することができます。OCI_SYSOPER あるいは
 * OCI_SYSDBA を指定した場合は、
 * この関数は外部の証明書を使った特権接続の確立を試みます。
 * 特権接続は、デフォルトでは無効になっています。有効にするには
 * oci8.privileged_connect
 * を On に設定しなければなりません。
 * </p>
 * PHP 5.3 (PECL OCI8 1.3.4) 以降、
 * OCI_CRED_EXT モードを使えるようになりました。
 * これは、Oracle に外部認証あるいは OS 認証を使うよう指示します。
 * どちらかをデータベースで設定しておかなければなりません。
 * OCI_CRED_EXT フラグを使えるのは、ユーザー名が
 * &quot;/&quot; でパスワードが空のときだけです。
 * oci8.privileged_connect
 * は On あるいは Off のどちらでもかまいません。
 * </p>
 * OCI_CRED_EXT は、
 * OCI_SYSOPER あるいは
 * OCI_SYSDBA モードと組み合わせて使います。
 * </p>
 * OCI_CRED_EXT は、セキュリティ上の理由により
 * Windows ではサポートされていません。
 * </p>
 * @return resource 接続 ID、あるいはエラー時に FALSE を返します。
 */
function oci_pconnect ($username, $password, $connection_string = null, $character_set = null, $session_mode = null) {}

/**
 * 最後に見つかったエラーを返す
 * @link http://www.php.net/manual/ja/function.oci-error.php
 * @param resource resource[optional] <p>
 * 大半のエラーでは、resource
 * は関数コール時に渡されたリソースハンドルとなります。
 * oci_connect や
 * oci_new_connect、
 * oci_pconnect の接続エラーの場合は resource
 * を渡しません。
 * </p>
 * @return array もしエラーが見つからない場合、oci_error は
 * FALSE を返します。それ以外の場合は、
 * oci_error はエラーの情報を連想配列で返します。
 * </p>
 * <p>
 * <table>
 * oci_error の配列の形式
 * <tr valign="top">
 * <td>配列のキー</td>
 * <td>型</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>code</td>
 * <td>integer</td>
 * <td>
 * Oracle のエラーコード。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>message</td>
 * <td>string</td>
 * <td>
 * Oracle のエラーメッセージ。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>offset</td>
 * <td>integer</td>
 * <td>
 * SQL 文の中でのエラーが発生した場所のバイト位置。SQL 文がない場合は
 * 0 となります。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>sqltext</td>
 * <td>string</td>
 * <td>
 * SQL 文のテキスト。SQL 文がない場合は空文字列となります。
 * </td>
 * </tr>
 * </table>
 */
function oci_error ($resource = null) {}

/**
 * ディスクリプタを解放する
 * @link http://www.php.net/manual/ja/function.oci-free-descriptor.php
 * @param descriptor resource 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_free_descriptor ($descriptor) {}

/**
 * @param lob_descriptor
 * @param data
 * @param offset[optional]
 */
function oci_lob_save ($lob_descriptor, $data, $offset) {}

/**
 * @param lob_descriptor
 * @param filename
 */
function oci_lob_import ($lob_descriptor, $filename) {}

/**
 * @param lob_descriptor
 */
function oci_lob_size ($lob_descriptor) {}

/**
 * @param lob_descriptor
 */
function oci_lob_load ($lob_descriptor) {}

/**
 * @param lob_descriptor
 * @param length
 */
function oci_lob_read ($lob_descriptor, $length) {}

/**
 * @param lob_descriptor
 */
function oci_lob_eof ($lob_descriptor) {}

/**
 * @param lob_descriptor
 */
function oci_lob_tell ($lob_descriptor) {}

/**
 * @param lob_descriptor
 * @param length[optional]
 */
function oci_lob_truncate ($lob_descriptor, $length) {}

/**
 * @param lob_descriptor
 * @param offset[optional]
 * @param length[optional]
 */
function oci_lob_erase ($lob_descriptor, $offset, $length) {}

/**
 * @param lob_descriptor
 * @param flag[optional]
 */
function oci_lob_flush ($lob_descriptor, $flag) {}

/**
 * @param lob_descriptor
 * @param mode
 */
function ocisetbufferinglob ($lob_descriptor, $mode) {}

/**
 * @param lob_descriptor
 */
function ocigetbufferinglob ($lob_descriptor) {}

/**
 * 2 つの LOB/FILE ロケータの等価性を比較する
 * @link http://www.php.net/manual/ja/function.oci-lob-is-equal.php
 * @param lob1 OCI-Lob <p>
 * LOB の ID。
 * </p>
 * @param lob2 OCI-Lob <p>
 * LOB の ID。
 * </p>
 * @return bool これらのオブジェクトが等しい場合 TRUE を返し、
 * そうでなければ FALSE を返します。
 */
function oci_lob_is_equal (OCI_Lob $lob1, OCI_Lob $lob2) {}

/**
 * @param lob_descriptor
 */
function oci_lob_rewind ($lob_descriptor) {}

/**
 * @param lob_descriptor
 * @param string
 * @param length[optional]
 */
function oci_lob_write ($lob_descriptor, $string, $length) {}

/**
 * @param lob_descriptor_to
 * @param lob_descriptor_from
 */
function oci_lob_append ($lob_descriptor_to, $lob_descriptor_from) {}

/**
 * ラージオブジェクトをコピーする
 * @link http://www.php.net/manual/ja/function.oci-lob-copy.php
 * @param lob_to OCI-Lob <p>
 * コピー先の LOB。
 * </p>
 * @param lob_from OCI-Lob <p>
 * コピー元の LOB。
 * </p>
 * @param length int[optional] <p>
 * コピーされるデータの長さ。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_lob_copy (OCI_Lob $lob_to, OCI_Lob $lob_from, $length = null) {}

/**
 * @param lob_descriptor
 * @param filename
 * @param start[optional]
 * @param length[optional]
 */
function oci_lob_export ($lob_descriptor, $filename, $start, $length) {}

/**
 * @param lob_descriptor
 * @param offset
 * @param whence[optional]
 */
function oci_lob_seek ($lob_descriptor, $offset, $whence) {}

/**
 * 未解決のトランザクションをコミットする
 * @link http://www.php.net/manual/ja/function.oci-commit.php
 * @param connection resource <p>
 * oci_connect、oci_pconnect
 * あるいは oci_new_connect が返す
 * Oracle 接続 ID。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_commit ($connection) {}

/**
 * 未解決のデータベーストランザクションをロールバックする
 * @link http://www.php.net/manual/ja/function.oci-rollback.php
 * @param connection resource <p>
 * oci_connect、oci_pconnect
 * あるいは oci_new_connect.
 * が返す Oracle 接続 ID。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_rollback ($connection) {}

/**
 * 空の新規 LOB あるいは FILE ディスクリプタを初期化する
 * @link http://www.php.net/manual/ja/function.oci-new-descriptor.php
 * @param connection resource <p>
 * oci_connect あるいは oci_pconnect
 * が返す Oracle 接続 ID。
 * </p>
 * @param type int[optional] <p>
 * type として有効な値は、
 * OCI_DTYPE_FILE、OCI_DTYPE_LOB および
 * OCI_DTYPE_ROWID
 * です。
 * </p>
 * @return OCI-Lob 成功した場合に新しい LOB あるいは FILE ディスクリプタ、
 * エラー時に FALSE を返します。
 */
function oci_new_descriptor ($connection, $type = null) {}

/**
 * クエリがプリフェッチする行数を設定する
 * @link http://www.php.net/manual/ja/function.oci-set-prefetch.php
 * @param statement resource &oci.arg.statement.id;
 * @param rows int <p>
 * プリフェッチする行数。&gt;= 0
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_set_prefetch ($statement, $rows) {}

/**
 * クライアント識別子を設定します
 * @link http://www.php.net/manual/ja/function.oci-set-client-identifier.php
 * @param connection resource oci_connect、oci_pconnect
 * あるいは oci_new_connect が返す Oracle 接続 ID。</p>
 * @param client_identifier string <p>
 * ユーザーが選んだ、長さが最高64バイトの文字列。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_set_client_identifier ($connection, $client_identifier) {}

/**
 * データベース・エディション を設定します
 * @link http://www.php.net/manual/ja/function.oci-set-edition.php
 * @param edition string <p>
 * SQLコマンド "CREATE EDITION" であらかじめ作成されたオラクル・データベース・エディション名
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_set_edition ($edition) {}

/**
 * モジュール名を設定します
 * @link http://www.php.net/manual/ja/function.oci-set-module-name.php
 * @param connection resource oci_connect、oci_pconnect
 * あるいは oci_new_connect が返す Oracle 接続 ID。</p>
 * @param module_name string <p>
 * ユーザーが選んだ、長さが最高48バイトの string 。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_set_module_name ($connection, $module_name) {}

/**
 * アクション名を設定します
 * @link http://www.php.net/manual/ja/function.oci-set-action.php
 * @param connection resource oci_connect、oci_pconnect
 * あるいは oci_new_connect が返す Oracle 接続 ID。</p>
 * @param action_name string <p>
 * ユーザーが選んだ、長さが最高32バイトの文字列。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_set_action ($connection, $action_name) {}

/**
 * クライアント情報を設定する
 * @link http://www.php.net/manual/ja/function.oci-set-client-info.php
 * @param connection resource oci_connect、oci_pconnect
 * あるいは oci_new_connect が返す Oracle 接続 ID。</p>
 * @param client_info string <p>
 * ユーザーが選んだ、長さが最高64バイトの文字列。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_set_client_info ($connection, $client_info) {}

/**
 * Oracle ユーザーのパスワードを変更する
 * @link http://www.php.net/manual/ja/function.oci-password-change.php
 * @param connection resource <p>
 * oci_connect あるいは oci_pconnect
 * が返す Oracle 接続 ID。
 * </p>
 * @param username string <p>
 * Oracle のユーザー名。
 * </p>
 * @param old_password string <p>
 * 旧パスワード。
 * </p>
 * @param new_password string <p>
 * 設定したい、新しいパスワード。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function oci_password_change ($connection, $username, $old_password, $new_password) {}

/**
 * @param collection
 */
function oci_free_collection ($collection) {}

/**
 * @param collection
 * @param value
 */
function oci_collection_append ($collection, $value) {}

/**
 * @param collection
 * @param index
 */
function oci_collection_element_get ($collection, $index) {}

/**
 * @param collection
 * @param index
 * @param value
 */
function oci_collection_element_assign ($collection, $index, $value) {}

/**
 * @param collection_to
 * @param collection_from
 */
function oci_collection_assign ($collection_to, $collection_from) {}

/**
 * @param collection
 */
function oci_collection_size ($collection) {}

/**
 * @param collection
 */
function oci_collection_max ($collection) {}

/**
 * @param collection
 * @param number
 */
function oci_collection_trim ($collection, $number) {}

/**
 * 新しいコレクションオブジェクトを割り当てる
 * @link http://www.php.net/manual/ja/function.oci-new-collection.php
 * @param connection resource <p>
 * oci_connect あるいは oci_pconnect
 * が返す Oracle 接続 ID。
 * </p>
 * @param tdo string <p>
 * 有効な型名 (大文字)。
 * </p>
 * @param schema string[optional] <p>
 * 型を作成したスキーマを指定しなければなりません。
 * 現在のユーザー名がデフォルト値となります。
 * </p>
 * @return OCI-Collection 新しい OCICollection オブジェクト、
 * あるいはエラー時に FALSE を返します。
 */
function oci_new_collection ($connection, $tdo, $schema = null) {}

/**
 * @param statement_resource
 */
function oci_free_cursor ($statement_resource) {}

/**
 * <function>oci_free_statement</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocifreecursor.php
 * @param statement_resource
 */
function ocifreecursor ($statement_resource) {}

/**
 * <function>oci_bind_by_name</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocibindbyname.php
 * @param statement_resource
 * @param column_name
 * @param variable
 * @param maximum_length[optional]
 * @param type[optional]
 */
function ocibindbyname ($statement_resource, $column_name, &$variable, $maximum_length, $type) {}

/**
 * <function>oci_define_by_name</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocidefinebyname.php
 * @param statement_resource
 * @param column_name
 * @param variable
 * @param type[optional]
 */
function ocidefinebyname ($statement_resource, $column_name, &$variable, $type) {}

/**
 * <function>oci_field_is_null</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocicolumnisnull.php
 * @param statement_resource
 * @param column_number_or_name
 */
function ocicolumnisnull ($statement_resource, $column_number_or_name) {}

/**
 * <function>oci_field_name</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocicolumnname.php
 * @param statement_resource
 * @param column_number
 */
function ocicolumnname ($statement_resource, $column_number) {}

/**
 * <function>oci_field_size</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocicolumnsize.php
 * @param statement_resource
 * @param column_number_or_name
 */
function ocicolumnsize ($statement_resource, $column_number_or_name) {}

/**
 * <function>oci_field_scale</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocicolumnscale.php
 * @param statement_resource
 * @param column_number
 */
function ocicolumnscale ($statement_resource, $column_number) {}

/**
 * <function>oci_field_precision</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocicolumnprecision.php
 * @param statement_resource
 * @param column_number
 */
function ocicolumnprecision ($statement_resource, $column_number) {}

/**
 * <function>oci_field_type</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocicolumntype.php
 * @param statement_resource
 * @param column_number
 */
function ocicolumntype ($statement_resource, $column_number) {}

/**
 * <function>oci_field_type_raw</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocicolumntyperaw.php
 * @param statement_resource
 * @param column_number
 */
function ocicolumntyperaw ($statement_resource, $column_number) {}

/**
 * <function>oci_execute</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ociexecute.php
 * @param statement_resource
 * @param mode[optional]
 */
function ociexecute ($statement_resource, $mode) {}

/**
 * <function>oci_cancel</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocicancel.php
 * @param statement_resource
 */
function ocicancel ($statement_resource) {}

/**
 * <function>oci_fetch</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocifetch.php
 * @param statement_resource
 */
function ocifetch ($statement_resource) {}

/**
 * <function>oci_fetch_all</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocifetchstatement.php
 * @param statement_resource
 * @param output
 * @param skip[optional]
 * @param maximum_rows[optional]
 * @param flags[optional]
 */
function ocifetchstatement ($statement_resource, &$output, $skip, $maximum_rows, $flags) {}

/**
 * <function>oci_free_statement</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocifreestatement.php
 * @param statement_resource
 */
function ocifreestatement ($statement_resource) {}

/**
 * <function>oci_internal_debug</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ociinternaldebug.php
 * @param mode
 */
function ociinternaldebug ($mode) {}

/**
 * <function>oci_num_fields</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocinumcols.php
 * @param statement_resource
 */
function ocinumcols ($statement_resource) {}

/**
 * <function>oci_parse</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ociparse.php
 * @param connection_resource
 * @param sql_text
 */
function ociparse ($connection_resource, $sql_text) {}

/**
 * <function>oci_new_cursor</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocinewcursor.php
 * @param connection_resource
 */
function ocinewcursor ($connection_resource) {}

/**
 * <function>oci_result</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ociresult.php
 * @param statement_resource
 * @param column_number_or_name
 */
function ociresult ($statement_resource, $column_number_or_name) {}

/**
 * <function>oci_server_version</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ociserverversion.php
 * @param connection_resource
 */
function ociserverversion ($connection_resource) {}

/**
 * <function>oci_statement_type</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocistatementtype.php
 * @param statement_resource
 */
function ocistatementtype ($statement_resource) {}

/**
 * <function>oci_num_rows</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocirowcount.php
 * @param statement_resource
 */
function ocirowcount ($statement_resource) {}

/**
 * <function>oci_close</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocilogoff.php
 * @param connection_resource
 */
function ocilogoff ($connection_resource) {}

/**
 * <function>oci_connect</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocilogon.php
 * @param username
 * @param password
 * @param connection_string[optional]
 * @param character_set[optional]
 * @param session_mode[optional]
 */
function ocilogon ($username, $password, $connection_string, $character_set, $session_mode) {}

/**
 * <function>oci_new_connect</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocinlogon.php
 * @param username
 * @param password
 * @param connection_string[optional]
 * @param character_set[optional]
 * @param session_mode[optional]
 */
function ocinlogon ($username, $password, $connection_string, $character_set, $session_mode) {}

/**
 * <function>oci_pconnect</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ociplogon.php
 * @param username
 * @param password
 * @param connection_string[optional]
 * @param character_set[optional]
 * @param session_mode[optional]
 */
function ociplogon ($username, $password, $connection_string, $character_set, $session_mode) {}

/**
 * <function>oci_error</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocierror.php
 * @param connection_or_statement_resource[optional]
 */
function ocierror ($connection_or_statement_resource) {}

/**
 * <function>OCI-Lob::free</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocifreedesc.php
 * @param lob_descriptor
 */
function ocifreedesc ($lob_descriptor) {}

/**
 * <function>OCI-Lob::save</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocisavelob.php
 * @param lob_descriptor
 * @param data
 * @param offset[optional]
 */
function ocisavelob ($lob_descriptor, $data, $offset) {}

/**
 * <function>OCI-Lob::import</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocisavelobfile.php
 * @param lob_descriptor
 * @param filename
 */
function ocisavelobfile ($lob_descriptor, $filename) {}

/**
 * <function>OCI-Lob::export</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ociwritelobtofile.php
 * @param lob_descriptor
 * @param filename
 * @param start[optional]
 * @param length[optional]
 */
function ociwritelobtofile ($lob_descriptor, $filename, $start, $length) {}

/**
 * <function>OCI-Lob::load</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ociloadlob.php
 * @param lob_descriptor
 */
function ociloadlob ($lob_descriptor) {}

/**
 * <function>oci_commit</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocicommit.php
 * @param connection_resource
 */
function ocicommit ($connection_resource) {}

/**
 * <function>oci_rollback</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocirollback.php
 * @param connection_resource
 */
function ocirollback ($connection_resource) {}

/**
 * <function>oci_new_descriptor</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocinewdescriptor.php
 * @param connection_resource
 * @param type[optional]
 */
function ocinewdescriptor ($connection_resource, $type) {}

/**
 * <function>oci_set_prefetch</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocisetprefetch.php
 * @param statement_resource
 * @param number_of_rows
 */
function ocisetprefetch ($statement_resource, $number_of_rows) {}

/**
 * @param connection_resource_or_connection_string
 * @param username
 * @param old_password
 * @param new_password
 */
function ocipasswordchange ($connection_resource_or_connection_string, $username, $old_password, $new_password) {}

/**
 * <function>OCI-Collection::free</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocifreecollection.php
 * @param collection
 */
function ocifreecollection ($collection) {}

/**
 * <function>oci_new_collection</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocinewcollection.php
 * @param connection_resource
 * @param type_name
 * @param schema_name[optional]
 */
function ocinewcollection ($connection_resource, $type_name, $schema_name) {}

/**
 * <function>OCI-Collection::append</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocicollappend.php
 * @param collection
 * @param value
 */
function ocicollappend ($collection, $value) {}

/**
 * <function>OCI-Collection::getElem</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocicollgetelem.php
 * @param collection
 * @param index
 */
function ocicollgetelem ($collection, $index) {}

/**
 * <function>OCI-Collection::assignElem</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocicollassignelem.php
 * @param collection
 * @param index
 * @param value
 */
function ocicollassignelem ($collection, $index, $value) {}

/**
 * <function>OCI-Collection::size</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocicollsize.php
 * @param collection
 */
function ocicollsize ($collection) {}

/**
 * <function>OCI-Collection::max</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocicollmax.php
 * @param collection
 */
function ocicollmax ($collection) {}

/**
 * <function>OCI-Collection::trim</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ocicolltrim.php
 * @param collection
 * @param number
 */
function ocicolltrim ($collection, $number) {}


/**
 * OCI_NO_AUTO_COMMIT を参照ください。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_DEFAULT', 0);

/**
 * oci_connect で、SYSOPER として接続するために使います。
 * php.ini 設定
 * oci8.privileged_connect
 * を有効にしないと使えません。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_SYSOPER', 4);

/**
 * oci_connect で、SYSDBA として接続するために使います。
 * php.ini 設定
 * oci8.privileged_connect
 * を有効にしないと使えません。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_SYSDBA', 2);

/**
 * oci_connect と組み合わせ、
 * Oracles の External 認証あるいは OS 認証を利用します。
 * PHP 5.3 および PECL OCI8 1.3.4 で追加されました。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_CRED_EXT', -2147483648);

/**
 * oci_execute のステートメント実行モード。
 * このモードをは、カラム名などのメタデータは欲しいけれど
 * クエリから行を取得したくないという場合に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_DESCRIBE_ONLY', 16);

/**
 * oci_execute のステートメント実行モード。
 * ステートメントが成功したときに、自動的に変更をコミットします。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_COMMIT_ON_SUCCESS', 32);

/**
 * oci_execute のステートメント実行モード。
 * このモードでは、トランザクションの自動コミットは行われません。
 * コードの可読性を考慮して、今までの
 * OCI_DEFAULT ではなくこちらを使うようにしましょう。
 * PHP 5.3.2 (PECL OCI8 1.4) 以降で使用可能です。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_NO_AUTO_COMMIT', 0);

/**
 * 現在はサポートされていません。文の取得モードを指定します。
 * アプリケーションがあらかじめ何行取得すればよいか分かっている場合に使います。
 * このモードは Oracle リリース 8 以降ではプリフェッチ機能をオフにします。
 * カーソルは希望する行を取得した後キャンセルされ、
 * サーバー側のリソースの使用は軽減されます。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_EXACT_FETCH', 2);

/**
 * でシーク位置を設定するために使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_SEEK_SET', 0);

/**
 * でシーク位置を設定するために使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_SEEK_CUR', 1);

/**
 * でシーク位置を設定するために使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_SEEK_END', 2);

/**
 * 使用されたバッファを解放するために
 * と併用します。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_LOB_BUFFER_FREE', 1);

/**
 * OCI_B_BFILE と等価です。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_BFILEE', 114);

/**
 * OCI_B_CFILEE と等価です。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_CFILEE', 115);

/**
 * OCI_B_CLOB と等価です。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_CLOB', 112);

/**
 * OCI_B_BLOB と等価です。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_BLOB', 113);

/**
 * OCI_B_ROWID と等価です。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_RDD', 104);

/**
 * OCI_B_INT と等価です。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_INT', 3);

/**
 * OCI_B_NUM と等価です。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_NUM', 2);

/**
 * OCI_B_CURSOR と等価です。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_RSET', 116);

/**
 * oci_bind_array_by_name で
 * CHAR の配列をバインドする場合に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_AFC', 96);

/**
 * oci_bind_array_by_name で
 * VARCHAR2 の配列をバインドする場合に使います。
 * oci_bind_by_name でも使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_CHR', 1);

/**
 * oci_bind_array_by_name で
 * VARCHAR の配列をバインドする際に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_VCS', 9);

/**
 * oci_bind_array_by_name で
 * CHARZ の配列をバインドする場合に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_AVC', 97);

/**
 * oci_bind_array_by_name で
 * STRING の配列をバインドする場合に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_STR', 5);

/**
 * oci_bind_array_by_name で
 * LONG VARCHAR の配列をバインドする場合に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_LVC', 94);

/**
 * oci_bind_array_by_name で
 * FLOAT の配列をバインドする場合に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_FLT', 4);

/**
 * サポートされていません。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_UIN', 68);

/**
 * oci_bind_by_name で
 * LONG 値をバインドする際に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_LNG', 8);

/**
 * oci_bind_by_name で
 * LONG RAW 値をバインドする際に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_LBI', 24);

/**
 * OCI_B_BIN と同じ。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_BIN', 23);

/**
 * oci_bind_array_by_name で
 * LONG の配列をバインドする場合に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_ODT', 156);

/**
 * サポートされていません。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_BDOUBLE', 22);

/**
 * サポートされていません。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_BFLOAT', 21);

/**
 * oci_bind_by_name で
 * 名前付けされたデータ型をバインドする場合に使います。
 * 注意: PHP &lt; 5.0 では OCI_B_SQLT_NTY と呼ばれます。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_B_NTY', 108);

/**
 * OCI_B_NTY と等価です。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('SQLT_NTY', 108);

/**
 * サポートされなくなりました。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_SYSDATE', "SYSDATE");

/**
 * oci_bind_by_name で
 * BFILE をバインドする場合に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_B_BFILE', 114);

/**
 * oci_bind_by_name で
 * CFILE をバインドする場合に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_B_CFILEE', 115);

/**
 * oci_bind_by_name で
 * CLOB をバインドする場合に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_B_CLOB', 112);

/**
 * oci_bind_by_name で
 * BLOB をバインドする場合に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_B_BLOB', 113);

/**
 * oci_bind_by_name で
 * ROWID をバインドする場合に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_B_ROWID', 104);

/**
 * oci_bind_by_name で
 * oci_new_descriptor
 * によってあらかじめ割り当てられたカーソルをバインドする場合に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_B_CURSOR', 116);

/**
 * oci_bind_by_name で
 * RAW 値をバインドする際に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_B_BIN', 23);

/**
 * oci_bind_array_by_name で
 * INTEGER の配列をバインドする場合に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_B_INT', 3);

/**
 * oci_bind_array_by_name で
 * NUMBER の配列をバインドする場合に使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_B_NUM', 2);

/**
 * oci_fetch_all のデフォルトのモード。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_FETCHSTATEMENT_BY_COLUMN', 16);

/**
 * oci_fetch_all でのもうひとつのモード。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_FETCHSTATEMENT_BY_ROW', 32);

/**
 * oci_fetch_all と
 * oci_fetch_array
 * で結果を連想配列で取得するために使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_ASSOC', 1);

/**
 * oci_fetch_all と
 * oci_fetch_array
 * で結果を配列で取得するために使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_NUM', 2);

/**
 * oci_fetch_all と
 * oci_fetch_array
 * で結果を配列と連想配列の両方で取得するために使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_BOTH', 3);

/**
 * oci_fetch_array
 * でフィールド値が NULL の場合に空の配列要素を取得するために使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_RETURN_NULLS', 4);

/**
 * oci_fetch_array
 * でディスクリプタの代わりに LOB の値を取得するために使います。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_RETURN_LOBS', 8);

/**
 * このフラグは oci_new_descriptor に新しい
 * FILE ディスクリプタを初期化するように伝えます。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_DTYPE_FILE', 56);

/**
 * このフラグは oci_new_descriptor に新しい
 * LOB ディスクリプタを初期化するように伝えます。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_DTYPE_LOB', 50);

/**
 * このフラグは oci_new_descriptor に新しい
 * ROWID ディスクリプタを初期化するように伝えます。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_DTYPE_ROWID', 54);

/**
 * OCI_DTYPE_FILE と等価です。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_D_FILE', 56);

/**
 * OCI_DTYPE_LOB と等価です。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_D_LOB', 50);

/**
 * OCI_DTYPE_ROWID と等価です。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_D_ROWID', 54);

/**
 * 一時的な CLOB が生成されるよう明示的に指定するため
 * と併用します。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_TEMP_CLOB', 2);

/**
 * 一時的な BLOB が生成されるよう明示的に指定するため
 * と併用します。
 * @link http://www.php.net/manual/ja/oci8.constants.php
 */
define ('OCI_TEMP_BLOB', 1);

// End of oci8 v.1.4.9
?>
