<?php

// Start of gd v.

/**
 * 現在インストールされているGDライブラリに関する情報を取得する
 * @link http://www.php.net/manual/ja/function.gd-info.php
 * @return array 連想配列を返します。
 * </p>
 * <p>
 * <table>
 * gd_info が返す配列の要素
 * <tr valign="top">
 * <td>属性</td>
 * <td>意味</td>
 * </tr>
 * <tr valign="top">
 * <td>GD Version</td>
 * <td>string。インストールされている
 * libgdのバージョン</td>
 * </tr>
 * <tr valign="top">
 * <td>FreeType Support</td>
 * <td>boolean value. TRUE 
 * の場合FreeTypeサポートはインストールされている</td>
 * </tr>
 * <tr valign="top">
 * <td>FreeType Linkage</td>
 * <td>
 * string値。FreeTypeのリンク方法の情報。
 * 'with freetype', 'with TTF library', 'with unknown library'など。
 * FreeType SupportがTRUEにセットされている場合にのみ
 * この要素が定義されます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>T1Lib Support</td>
 * <td>boolean値。
 * T1Libサポートが含まれている場合にTRUE</td>
 * </tr>
 * <tr valign="top">
 * <td>GIF Read Support</td>
 * <td>boolean値。
 * GIF画像の読み込み
 * がサポートされている場合にTRUE</td>
 * </tr>
 * <tr valign="top">
 * <td>GIF Create Support</td>
 * <td>boolean値。
 * GIF画像の生成
 * がサポートされている場合にTRUE</td>
 * </tr>
 * <tr valign="top">
 * <td>JPEG Support</td>
 * <td>boolean値。
 * JPEGサポートが含まれている場合にTRUE</td>
 * </tr>
 * <tr valign="top">
 * <td>PNG Support</td>
 * <td>boolean値。
 * PNGサポートが含まれている場合にTRUE</td>
 * </tr>
 * <tr valign="top">
 * <td>WBMP Support</td>
 * <td>boolean値。
 * WBMPサポートが含まれている場合にTRUE</td>
 * </tr>
 * <tr valign="top">
 * <td>XBM Support</td>
 * <td>boolean値。
 * XBMサポートが含まれている倍にTRUE</td>
 * </tr>
 * </table>
 * </p>
 * <p>
 * PHP 5.3.0 より前のバージョンでは、JPEG Support 属性は
 * JPG Support という名前でした。
 */
function gd_info () {}

/**
 * 部分楕円を描画する
 * @link http://www.php.net/manual/ja/function.imagearc.php
 * @param image resource 
 * @param cx int <p>
 * 中心の x 座標。
 * </p>
 * @param cy int <p>
 * 中心の y 座標。
 * </p>
 * @param width int <p>
 * 円弧の幅。
 * </p>
 * @param height int <p>
 * 円弧の高さ。
 * </p>
 * @param start int <p>
 * 始点の角度。
 * </p>
 * @param end int <p>
 * 終点の角度。
 * 0° は 3 時の位置で、そこから時計回りの方向に円弧が描かれます。
 * </p>
 * @param color int <p>
 * imagecolorallocate で作成した色 ID。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagearc ($image, $cx, $cy, $width, $height, $start, $end, $color) {}

/**
 * 楕円を描画する
 * @link http://www.php.net/manual/ja/function.imageellipse.php
 * @param image resource 
 * @param cx int <p>
 * 中心の x 座標。
 * </p>
 * @param cy int <p>
 * 中心の y 座標。
 * </p>
 * @param width int <p>
 * 楕円の幅。
 * </p>
 * @param height int <p>
 * 楕円の高さ。
 * </p>
 * @param color int <p>
 * 楕円の色を、
 * imagecolorallocate
 * で作成した画像 ID で指定します。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imageellipse ($image, $cx, $cy, $width, $height, $color) {}

/**
 * 水平に文字を描画する
 * @link http://www.php.net/manual/ja/function.imagechar.php
 * @param image resource 
 * @param font int 
 * @param x int <p>
 * 始点の x 座標。
 * </p>
 * @param y int <p>
 * 始点の y 座標。
 * </p>
 * @param c string <p>
 * 描画する文字。
 * </p>
 * @param color int <p>
 * imagecolorallocate で作成した色 ID。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagechar ($image, $font, $x, $y, $c, $color) {}

/**
 * 垂直に文字を描画する
 * @link http://www.php.net/manual/ja/function.imagecharup.php
 * @param image resource 
 * @param font int 
 * @param x int <p>
 * 始点の x 座標。
 * </p>
 * @param y int <p>
 * 始点の y 座標。
 * </p>
 * @param c string <p>
 * 描画する文字。
 * </p>
 * @param color int <p>
 * imagecolorallocate で作成した色 ID。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagecharup ($image, $font, $x, $y, $c, $color) {}

/**
 * ピクセルの色のインデックスを取得する
 * @link http://www.php.net/manual/ja/function.imagecolorat.php
 * @param image resource 
 * @param x int <p>
 * 点の x 座標。
 * </p>
 * @param y int <p>
 * 点の y 座標。
 * </p>
 * @return int 色のインデックスを返します。
 */
function imagecolorat ($image, $x, $y) {}

/**
 * 画像で使用する色を作成する
 * @link http://www.php.net/manual/ja/function.imagecolorallocate.php
 * @param image resource 
 * @param red int <p>赤コンポーネントの値。</p>
 * @param green int <p>緑コンポーネントの値。</p>
 * @param blue int <p>青コンポーネントの値。</p>
 * @return int 色の ID、あるいは作成に失敗したい場合に FALSE を返します。
 */
function imagecolorallocate ($image, $red, $green, $blue) {}

/**
 * あるイメージから他のイメージにパレットをコピーする
 * @link http://www.php.net/manual/ja/function.imagepalettecopy.php
 * @param destination resource <p>
 * コピー先の画像リソース。
 * </p>
 * @param source resource <p>
 * コピー元の画像リソース。
 * </p>
 * @return void 値を返しません。
 */
function imagepalettecopy ($destination, $source) {}

/**
 * 文字列の中のイメージストリームから新規イメージを作成する
 * @link http://www.php.net/manual/ja/function.imagecreatefromstring.php
 * @param image string <p>
 * 画像データを含む文字列。
 * </p>
 * @return resource 成功時にはイメージリソースが返されます。
 * イメージの種類がサポートされていない、データのフォーマットが識別できない、
 * イメージが壊れておりリロードできないなどの場合は FALSE が返されます。
 */
function imagecreatefromstring ($image) {}

/**
 * 指定した色に最も近い色のインデックスを取得する
 * @link http://www.php.net/manual/ja/function.imagecolorclosest.php
 * @param image resource 
 * @param red int <p>赤コンポーネントの値。</p>
 * @param green int <p>緑コンポーネントの値。</p>
 * @param blue int <p>青コンポーネントの値。</p>
 * @return int 画像パレット内で、指定した色にいちばん近い色のインデックスを返します。
 */
function imagecolorclosest ($image, $red, $green, $blue) {}

/**
 * 色合い、白、黒を有する色のインデックスを得る
 * @link http://www.php.net/manual/ja/function.imagecolorclosesthwb.php
 * @param image resource 
 * @param red int <p>赤コンポーネントの値。</p>
 * @param green int <p>緑コンポーネントの値。</p>
 * @param blue int <p>青コンポーネントの値。</p>
 * @return int 指定した色に最も近い色合い、白、黒を有する色のインデックスを返します。
 */
function imagecolorclosesthwb ($image, $red, $green, $blue) {}

/**
 * イメージの色リソースを開放する
 * @link http://www.php.net/manual/ja/function.imagecolordeallocate.php
 * @param image resource 
 * @param color int <p>
 * 色 ID。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagecolordeallocate ($image, $color) {}

/**
 * 指定した色または出来るだけ近い色のインデックスを得る
 * @link http://www.php.net/manual/ja/function.imagecolorresolve.php
 * @param image resource 
 * @param red int <p>赤コンポーネントの値。</p>
 * @param green int <p>緑コンポーネントの値。</p>
 * @param blue int <p>青コンポーネントの値。</p>
 * @return int 色インデックスを返します。
 */
function imagecolorresolve ($image, $red, $green, $blue) {}

/**
 * 指定した色のインデックスを取得する
 * @link http://www.php.net/manual/ja/function.imagecolorexact.php
 * @param image resource 
 * @param red int <p>赤コンポーネントの値。</p>
 * @param green int <p>緑コンポーネントの値。</p>
 * @param blue int <p>青コンポーネントの値。</p>
 * @return int 指定した色の、パレット内でのインデックスを返します。
 * 画像パレット中に色が存在しない場合は -1 を返します。
 */
function imagecolorexact ($image, $red, $green, $blue) {}

/**
 * 指定したパレットインデックスの色を設定する
 * @link http://www.php.net/manual/ja/function.imagecolorset.php
 * @param image resource 
 * @param index int <p>
 * パレットのインデックス。
 * </p>
 * @param red int <p>赤コンポーネントの値。</p>
 * @param green int <p>緑コンポーネントの値。</p>
 * @param blue int <p>青コンポーネントの値。</p>
 * @param alpha int[optional] <p>
 * アルファコンポーネントの値。
 * </p>
 * @return void 値を返しません。
 */
function imagecolorset ($image, $index, $red, $green, $blue, $alpha = null) {}

/**
 * 透明色を定義する
 * @link http://www.php.net/manual/ja/function.imagecolortransparent.php
 * @param image resource 
 * @param color int[optional] <p>
 * imagecolorallocate で指定した色 ID。
 * </p>
 * @return int 新しい透明色の ID (指定しなかった場合は現在設定されている ID)
 * を返します。color を指定せず、
 * さらに現在の透明色も設定されていない場合は -1 を返します。
 */
function imagecolortransparent ($image, $color = null) {}

/**
 * 画像パレットの色数を検出する
 * @link http://www.php.net/manual/ja/function.imagecolorstotal.php
 * @param image resource <p>
 * imagecreatefromgif のような画像作成関数のひとつが返す画像リソース。
 * </p>
 * @return int 指定した画像パレットの色数を返します。
 * truecolor 画像の場合は 0 を返します。
 */
function imagecolorstotal ($image) {}

/**
 * カラーインデックスからカラーを取得する
 * @link http://www.php.net/manual/ja/function.imagecolorsforindex.php
 * @param image resource 
 * @param index int <p>
 * 色インデックス。
 * </p>
 * @return array 指定したカラーインデックス index に対して適当な値からなる
 * red、green、blue をキーとする連想配列を返します。
 */
function imagecolorsforindex ($image, $index) {}

/**
 * 画像の一部をコピーする
 * @link http://www.php.net/manual/ja/function.imagecopy.php
 * @param dst_im resource <p>コピー先の画像リンクリソース。</p>
 * @param src_im resource <p>コピー元の画像リンクリソース。</p>
 * @param dst_x int <p>
 * コピー先の x 座標。
 * </p>
 * @param dst_y int <p>
 * コピー先の y 座標。
 * </p>
 * @param src_x int <p>
 * コピー元の x 座標。
 * </p>
 * @param src_y int <p>
 * コピー元の y 座標。
 * </p>
 * @param src_w int <p>コピー元の幅。</p>
 * @param src_h int <p>コピー元の高さ。</p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagecopy ($dst_im, $src_im, $dst_x, $dst_y, $src_x, $src_y, $src_w, $src_h) {}

/**
 * イメージの一部をコピー、マージする
 * @link http://www.php.net/manual/ja/function.imagecopymerge.php
 * @param dst_im resource <p>コピー先の画像リンクリソース。</p>
 * @param src_im resource <p>コピー元の画像リンクリソース。</p>
 * @param dst_x int <p>
 * コピー先の x 座標。
 * </p>
 * @param dst_y int <p>
 * コピー先の y 座標。
 * </p>
 * @param src_x int <p>
 * コピー元の x 座標。
 * </p>
 * @param src_y int <p>
 * コピー元の y 座標。
 * </p>
 * @param src_w int <p>コピー元の幅。</p>
 * @param src_h int <p>コピー元の高さ。</p>
 * @param pct int <p>
 * 二つの画像は、
 * 0から100の範囲で指定した pctに基づきマージされます。
 * pct = 0 の時は、何も行われません。
 * 100の場合、この関数の動作は、パレットイメージに対する
 * imagecopy と同じとなります
 * (アルファコンポーネントを無視する点だけが違います)。
 * 一方 true color 画像については、この関数はアルファ透過度を実装しています。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagecopymerge ($dst_im, $src_im, $dst_x, $dst_y, $src_x, $src_y, $src_w, $src_h, $pct) {}

/**
 * グレースケールでイメージの一部をコピー、マージする
 * @link http://www.php.net/manual/ja/function.imagecopymergegray.php
 * @param dst_im resource <p>コピー先の画像リンクリソース。</p>
 * @param src_im resource <p>コピー元の画像リンクリソース。</p>
 * @param dst_x int <p>
 * コピー先の x 座標。
 * </p>
 * @param dst_y int <p>
 * コピー先の y 座標。
 * </p>
 * @param src_x int <p>
 * コピー元の x 座標。
 * </p>
 * @param src_y int <p>
 * コピー元の y 座標。
 * </p>
 * @param src_w int <p>コピー元の幅。</p>
 * @param src_h int <p>コピー元の高さ。</p>
 * @param pct int <p>
 * src_im が pct
 * にしたがってグレースケールに変換されます。
 * pct が 0 の場合は完全なグレースケール、
 * 100 の場合は何も変わらない状態となります。
 * pct = 100 の場合、パレット画像に対してはこの関数は
 * imagecopy と同じ動作となります
 * (アルファコンポーネントを無視する点だけが違います)。
 * 一方 true color 画像については、この関数はアルファ透過度を実装しています。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagecopymergegray ($dst_im, $src_im, $dst_x, $dst_y, $src_x, $src_y, $src_w, $src_h, $pct) {}

/**
 * 画像の一部をコピーしサイズを変更する
 * @link http://www.php.net/manual/ja/function.imagecopyresized.php
 * @param dst_image resource <p>コピー先の画像リンクリソース。</p>
 * @param src_image resource <p>コピー元の画像リンクリソース。</p>
 * @param dst_x int <p>
 * コピー先の x 座標。
 * </p>
 * @param dst_y int <p>
 * コピー先の y 座標。
 * </p>
 * @param src_x int <p>
 * コピー元の x 座標。
 * </p>
 * @param src_y int <p>
 * コピー元の y 座標。
 * </p>
 * @param dst_w int <p>
 * コピー先の幅。
 * </p>
 * @param dst_h int <p>
 * コピー先の高さ。
 * </p>
 * @param src_w int <p>コピー元の幅。</p>
 * @param src_h int <p>コピー元の高さ。</p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagecopyresized ($dst_image, $src_image, $dst_x, $dst_y, $src_x, $src_y, $dst_w, $dst_h, $src_w, $src_h) {}

/**
 * パレットを使用する新規画像を作成する
 * @link http://www.php.net/manual/ja/function.imagecreate.php
 * @param width int <p>
 * 画像の幅。
 * </p>
 * @param height int <p>
 * 画像の高さ。
 * </p>
 * @return resource 成功した場合に画像リソース ID、エラー時に FALSE を返します。
 */
function imagecreate ($width, $height) {}

/**
 * TrueColor イメージを新規に作成する
 * @link http://www.php.net/manual/ja/function.imagecreatetruecolor.php
 * @param width int <p>
 * 画像の幅。
 * </p>
 * @param height int <p>
 * 画像の高さ。
 * </p>
 * @return resource 成功した場合に画像リソース ID、エラー時に FALSE を返します。
 */
function imagecreatetruecolor ($width, $height) {}

/**
 * 画像が truecolor かどうか調べる
 * @link http://www.php.net/manual/ja/function.imageistruecolor.php
 * @param image resource 
 * @return bool image が truecolor の場合に TRUE、
 * それ以外の場合に FALSE を返します。
 */
function imageistruecolor ($image) {}

/**
 * TrueColor イメージをパレットイメージに変換する
 * @link http://www.php.net/manual/ja/function.imagetruecolortopalette.php
 * @param image resource 
 * @param dither bool <p>
 * イメージにディザーをかけることを指定します。
 * TRUE の場合はディザーが行われます。
 * 出力はぼやけますが、色の近似はより良くなります。
 * </p>
 * @param ncolors int <p>
 * パレットに保持される最大の色数を設定します。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagetruecolortopalette ($image, $dither, $ncolors) {}

/**
 * 線描画用の線幅を設定する
 * @link http://www.php.net/manual/ja/function.imagesetthickness.php
 * @param image resource 
 * @param thickness int <p>
 * ピクセル単位の線幅。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagesetthickness ($image, $thickness) {}

/**
 * 楕円弧を描画し、塗りつぶす
 * @link http://www.php.net/manual/ja/function.imagefilledarc.php
 * @param image resource 
 * @param cx int <p>
 * 中心の x 座標。
 * </p>
 * @param cy int <p>
 * 中心の y 座標。
 * </p>
 * @param width int <p>
 * 弧の幅。
 * </p>
 * @param height int <p>
 * 弧の高さ。
 * </p>
 * @param start int <p>
 * 弧の開始角度。
 * </p>
 * @param end int <p>
 * 弧の終了角度。
 * 0° は三時の方向で、そこから時計回りに数えます。
 * </p>
 * @param color int <p>
 * imagecolorallocate
 * で作成した色 ID。
 * </p>
 * @param style int <p>
 * 次の選択肢のビット和。
 * IMG_ARC_PIE
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagefilledarc ($image, $cx, $cy, $width, $height, $start, $end, $color, $style) {}

/**
 * 塗りつぶされた楕円を描画する
 * @link http://www.php.net/manual/ja/function.imagefilledellipse.php
 * @param image resource 
 * @param cx int <p>
 * 中心の x 座標。
 * </p>
 * @param cy int <p>
 * 中心の y 座標。
 * </p>
 * @param width int <p>
 * 楕円の幅。
 * </p>
 * @param height int <p>
 * 楕円の高さ。
 * </p>
 * @param color int <p>
 * 塗りつぶし色。
 * imagecolorallocate
 * で作成した色 ID です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagefilledellipse ($image, $cx, $cy, $width, $height, $color) {}

/**
 * イメージのブレンドモードを設定する
 * @link http://www.php.net/manual/ja/function.imagealphablending.php
 * @param image resource 
 * @param blendmode bool <p>
 * ブレンドモードを有効にするかどうか。True Color 画像の場合のデフォルトは
 * TRUE、それ以外の場合のデフォルトは FALSE です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagealphablending ($image, $blendmode) {}

/**
 * PNG 画像を保存する際に（単一色の透過設定ではない）完全な
   アルファチャネル情報を保存するフラグを設定する
 * @link http://www.php.net/manual/ja/function.imagesavealpha.php
 * @param image resource 
 * @param saveflag bool <p>
 * アルファチャネルを保存するか否か。デフォルトは FALSE です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagesavealpha ($image, $saveflag) {}

/**
 * 画像で使用する色を透過度を指定して作成する
 * @link http://www.php.net/manual/ja/function.imagecolorallocatealpha.php
 * @param image resource 
 * @param red int <p>赤コンポーネントの値。</p>
 * @param green int <p>緑コンポーネントの値。</p>
 * @param blue int <p>青コンポーネントの値。</p>
 * @param alpha int <p>
 * 0 から 127 までの値。
 * 0 は完全に不透明な状態。
 * 127 は完全に透明な状態を表します。
 * </p>
 * @return int 色 ID、あるいは作成に失敗した場合に FALSE を返します。
 */
function imagecolorallocatealpha ($image, $red, $green, $blue, $alpha) {}

/**
 * 指定した色+アルファ値または最も近い色のインデックスを取得する
 * @link http://www.php.net/manual/ja/function.imagecolorresolvealpha.php
 * @param image resource 
 * @param red int <p>赤コンポーネントの値。</p>
 * @param green int <p>緑コンポーネントの値。</p>
 * @param blue int <p>青コンポーネントの値。</p>
 * @param alpha int <p>
 * 0 から 127 までの値。
 * 0 は完全に不透明な状態。
 * 127 は完全に透明な状態を表します。
 * </p>
 * @return int 色インデックスを返します。
 */
function imagecolorresolvealpha ($image, $red, $green, $blue, $alpha) {}

/**
 * 指定した色+アルファ値に最も近い色のインデックスを取得する
 * @link http://www.php.net/manual/ja/function.imagecolorclosestalpha.php
 * @param image resource 
 * @param red int <p>赤コンポーネントの値。</p>
 * @param green int <p>緑コンポーネントの値。</p>
 * @param blue int <p>青コンポーネントの値。</p>
 * @param alpha int <p>
 * 0 から 127 までの値。
 * 0 は完全に不透明な状態。
 * 127 は完全に透明な状態を表します。
 * </p>
 * @return int 画像パレット内で、指定した色にいちばん近い色のインデックスを返します。
 */
function imagecolorclosestalpha ($image, $red, $green, $blue, $alpha) {}

/**
 * 指定した色+アルファ値のインデックスを取得する
 * @link http://www.php.net/manual/ja/function.imagecolorexactalpha.php
 * @param image resource 
 * @param red int <p>赤コンポーネントの値。</p>
 * @param green int <p>緑コンポーネントの値。</p>
 * @param blue int <p>青コンポーネントの値。</p>
 * @param alpha int <p>
 * 0 から 127 までの値。
 * 0 は完全に不透明な状態。
 * 127 は完全に透明な状態を表します。
 * </p>
 * @return int イメージのパレットにおける、指定した色+アルファ値のインデックスを返します。
 * 指定した色がイメージのパレットに存在しない場合、-1が返されます。
 */
function imagecolorexactalpha ($image, $red, $green, $blue, $alpha) {}

/**
 * 再サンプリングを行いイメージの一部をコピー、伸縮する
 * @link http://www.php.net/manual/ja/function.imagecopyresampled.php
 * @param dst_image resource <p>コピー先の画像リンクリソース。</p>
 * @param src_image resource <p>コピー元の画像リンクリソース。</p>
 * @param dst_x int <p>
 * コピー先の x 座標。
 * </p>
 * @param dst_y int <p>
 * コピー先の y 座標。
 * </p>
 * @param src_x int <p>
 * コピー元の x 座標。
 * </p>
 * @param src_y int <p>
 * コピー元の y 座標。
 * </p>
 * @param dst_w int <p>
 * コピー先の幅。
 * </p>
 * @param dst_h int <p>
 * コピー先の高さ。
 * </p>
 * @param src_w int <p>コピー元の幅。</p>
 * @param src_h int <p>コピー元の高さ。</p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagecopyresampled ($dst_image, $src_image, $dst_x, $dst_y, $src_x, $src_y, $dst_w, $dst_h, $src_w, $src_h) {}

/**
 * ウィンドウをキャプチャする
 * @link http://www.php.net/manual/ja/function.imagegrabwindow.php
 * @param window_handle int <p>
 * HWND ウィンドウ ID。
 * </p>
 * @param client_area int[optional] <p>
 * アプリケーションのクライアント領域を含めるかどうか。
 * </p>
 * @return resource 成功した場合に画像リソースの ID、失敗した場合に FALSE を返します。
 */
function imagegrabwindow ($window_handle, $client_area = null) {}

/**
 * 画面全体をキャプチャする
 * @link http://www.php.net/manual/ja/function.imagegrabscreen.php
 * @return resource 成功した場合に画像リソースの ID、失敗した場合に FALSE を返します。
 */
function imagegrabscreen () {}

/**
 * 指定された角度で画像を回転する
 * @link http://www.php.net/manual/ja/function.imagerotate.php
 * @param image resource 
 * @param angle float <p>
 * 回転角度。これは、画像を反時計回りに回転させるときの度数を表します。
 * </p>
 * @param bgd_color int <p>
 * 回転後、カバーされない部分の色。
 * </p>
 * @param ignore_transparent int[optional] <p>
 * ゼロ以外を指定すると、透過色は無視されます
 * (その他の場合は保持されます)。
 * </p>
 * @return resource 回転させた画像のリソースを返します。失敗した場合に FALSE を返します。
 */
function imagerotate ($image, $angle, $bgd_color, $ignore_transparent = null) {}

/**
 * アンチエイリアス機能を使用すべきかどうかを判断する
 * @link http://www.php.net/manual/ja/function.imageantialias.php
 * @param image resource 
 * @param enabled bool <p>
 * アンチエイリアスを有効にするかどうか。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imageantialias ($image, $enabled) {}

/**
 * 塗りつぶし用のイメージを設定する
 * @link http://www.php.net/manual/ja/function.imagesettile.php
 * @param image resource 
 * @param tile resource <p>
 * タイルとして使用する画像リソース。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagesettile ($image, $tile) {}

/**
 * 線の描画用にブラシイメージを設定する
 * @link http://www.php.net/manual/ja/function.imagesetbrush.php
 * @param image resource 
 * @param brush resource <p>
 * 画像リソース。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagesetbrush ($image, $brush) {}

/**
 * 線描画用のスタイルを設定する
 * @link http://www.php.net/manual/ja/function.imagesetstyle.php
 * @param image resource 
 * @param style array <p>
 * はピクセルの配列です。定数
 * IMG_COLOR_TRANSPARENT
 * を使用すると、透明なピクセルを追加できます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagesetstyle ($image, array $style) {}

/**
 * 新しい画像をファイルあるいは URL から作成する
 * @link http://www.php.net/manual/ja/function.imagecreatefrompng.php
 * @param filename string <p>
 * PNG 画像へのパス。
 * </p>
 * @return resource 成功した場合に画像リソース ID、エラー時に FALSE を返します。
 */
function imagecreatefrompng ($filename) {}

/**
 * 新しい画像をファイルあるいは URL から作成する
 * @link http://www.php.net/manual/ja/function.imagecreatefromgif.php
 * @param filename string <p>
 * GIF 画像へのパス。
 * </p>
 * @return resource 成功した場合に画像リソース ID、エラー時に FALSE を返します。
 */
function imagecreatefromgif ($filename) {}

/**
 * 新しい画像をファイルあるいは URL から作成する
 * @link http://www.php.net/manual/ja/function.imagecreatefromjpeg.php
 * @param filename string <p>
 * JPEG 画像へのパス。
 * </p>
 * @return resource 成功した場合に画像リソース ID、エラー時に FALSE を返します。
 */
function imagecreatefromjpeg ($filename) {}

/**
 * 新しい画像をファイルあるいは URL から作成する
 * @link http://www.php.net/manual/ja/function.imagecreatefromwbmp.php
 * @param filename string <p>
 * WBMP 画像へのパス。
 * </p>
 * @return resource 成功した場合に画像リソース ID、エラー時に FALSE を返します。
 */
function imagecreatefromwbmp ($filename) {}

/**
 * 新しい画像をファイルあるいは URL から作成する
 * @link http://www.php.net/manual/ja/function.imagecreatefromxbm.php
 * @param filename string <p>
 * XBM 画像へのパス。
 * </p>
 * @return resource 成功した場合に画像リソース ID、エラー時に FALSE を返します。
 */
function imagecreatefromxbm ($filename) {}

/**
 * 新しい画像をファイルあるいは URL から作成する
 * @link http://www.php.net/manual/ja/function.imagecreatefromxpm.php
 * @param filename string <p>
 * XPM 画像へのパス。
 * </p>
 * @return resource 成功した場合に画像リソース ID、エラー時に FALSE を返します。
 */
function imagecreatefromxpm ($filename) {}

/**
 * GD ファイルまたは URL から新規イメージを生成する
 * @link http://www.php.net/manual/ja/function.imagecreatefromgd.php
 * @param filename string <p>
 * </p>
 * @return resource 成功した場合に画像リソース ID、エラー時に FALSE を返します。
 */
function imagecreatefromgd ($filename) {}

/**
 * GD2 ファイルまたは URL から新規イメージを生成する
 * @link http://www.php.net/manual/ja/function.imagecreatefromgd2.php
 * @param filename string <p>
 * GD2 画像へのパス。
 * </p>
 * @return resource 成功した場合に画像リソース ID、エラー時に FALSE を返します。
 */
function imagecreatefromgd2 ($filename) {}

/**
 * GD2 ファイルまたは URL の指定した部分から新規イメージを生成する
 * @link http://www.php.net/manual/ja/function.imagecreatefromgd2part.php
 * @param filename string <p>
 * GD2 画像へのパス。
 * </p>
 * @param srcX int <p>
 * 作成元の x 座標。
 * </p>
 * @param srcY int <p>
 * 作成元の y 座標。
 * </p>
 * @param width int <p>コピー元の幅。</p>
 * @param height int <p>コピー元の高さ。</p>
 * @return resource 成功した場合に画像リソース ID、エラー時に FALSE を返します。
 */
function imagecreatefromgd2part ($filename, $srcX, $srcY, $width, $height) {}

/**
 * PNG イメージをブラウザまたはファイルに出力する
 * @link http://www.php.net/manual/ja/function.imagepng.php
 * @param image resource 
 * @param filename string[optional] <p>ファイルの保存先のパス。省略したり NULL を設定したりした場合は、画像ストリームを直接出力します。</p>
 * <p>
 * quality および
 * filters を使用しない場合は、
 * NULL を指定することはできません。
 * </p>
 * @param quality int[optional] <p>
 * 圧縮レベル。0 (圧縮しない) から 9 までの値です。
 * </p>
 * @param filters int[optional] <p>
 * PNG ファイルの大きさを小さくします。
 * これはビットマスクフィールドで、定数
 * PNG_FILTER_XXX の組み合わせを指定します。
 * PNG_NO_FILTER や
 * PNG_ALL_FILTERS を使用すると、
 * 全フィルタを一括で無効にしたり有効にしたりできます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagepng ($image, $filename = null, $quality = null, $filters = null) {}

/**
 * 画像をブラウザあるいはファイルに出力する
 * @link http://www.php.net/manual/ja/function.imagegif.php
 * @param image resource 
 * @param filename string[optional] <p>ファイルの保存先のパス。省略したり NULL を設定したりした場合は、画像ストリームを直接出力します。</p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagegif ($image, $filename = null) {}

/**
 * 画像をブラウザあるいはファイルに出力する
 * @link http://www.php.net/manual/ja/function.imagejpeg.php
 * @param image resource 
 * @param filename string[optional] <p>ファイルの保存先のパス。省略したり NULL を設定したりした場合は、画像ストリームを直接出力します。</p>
 * <p>
 * quality
 * パラメータを指定するためにこの引数をスキップするには、
 * NULL を指定します。
 * </p>
 * @param quality int[optional] <p>
 * quality はオプションであり、0(品質は最低
 * ですが、ファイルはより小さい)から100(品質は最高ですが、ファイルは
 * 最大)の範囲で指定します。デフォルトは IJG 品質値(75)です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagejpeg ($image, $filename = null, $quality = null) {}

/**
 * 画像をブラウザあるいはファイルに出力する
 * @link http://www.php.net/manual/ja/function.imagewbmp.php
 * @param image resource 
 * @param filename string[optional] <p>ファイルの保存先のパス。省略したり NULL を設定したりした場合は、画像ストリームを直接出力します。</p>
 * @param foreground int[optional] <p>
 * このパラメータで、
 * 前景の色を指定できます。imagecolorallocate で
 * 取得した ID を使用してください。デフォルトの前景色は黒です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagewbmp ($image, $filename = null, $foreground = null) {}

/**
 * GD イメージをブラウザまたはファイルに出力する
 * @link http://www.php.net/manual/ja/function.imagegd.php
 * @param image resource 
 * @param filename string[optional] <p>ファイルの保存先のパス。省略したり NULL を設定したりした場合は、画像ストリームを直接出力します。</p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagegd ($image, $filename = null) {}

/**
 * GD2 イメージをブラウザまたはファイルに出力する
 * @link http://www.php.net/manual/ja/function.imagegd2.php
 * @param image resource 
 * @param filename string[optional] <p>ファイルの保存先のパス。省略したり NULL を設定したりした場合は、画像ストリームを直接出力します。</p>
 * @param chunk_size int[optional] <p>
 * チャンクの大きさ。
 * </p>
 * @param type int[optional] <p>
 * IMG_GD2_RAW あるいは
 * IMG_GD2_COMPRESSED のいずれかです。デフォルトは
 * IMG_GD2_RAW です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagegd2 ($image, $filename = null, $chunk_size = null, $type = null) {}

/**
 * 画像を破棄する
 * @link http://www.php.net/manual/ja/function.imagedestroy.php
 * @param image resource 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagedestroy ($image) {}

/**
 * GD イメージにガンマ補正を適用する
 * @link http://www.php.net/manual/ja/function.imagegammacorrect.php
 * @param image resource 
 * @param inputgamma float <p>
 * 入力ガンマ値。
 * </p>
 * @param outputgamma float <p>
 * 出力ガンマ値。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagegammacorrect ($image, $inputgamma, $outputgamma) {}

/**
 * 塗り潰す
 * @link http://www.php.net/manual/ja/function.imagefill.php
 * @param image resource 
 * @param x int <p>
 * 開始位置の x 座標。
 * </p>
 * @param y int <p>
 * 開始位置の y 座標。
 * </p>
 * @param color int <p>
 * 塗りつぶし色。
 * imagecolorallocate
 * で作成した色 ID です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagefill ($image, $x, $y, $color) {}

/**
 * 塗りつぶした多角形を描画する
 * @link http://www.php.net/manual/ja/function.imagefilledpolygon.php
 * @param image resource 
 * @param points array <p>
 * 多角形の頂点の座標 x および y
 * を含む配列。
 * </p>
 * @param num_points int <p>
 * 頂点の総数。
 * 3 以上である必要があります。
 * </p>
 * @param color int <p>
 * imagecolorallocate で作成した色 ID。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagefilledpolygon ($image, array $points, $num_points, $color) {}

/**
 * 塗りつぶした矩形を描画する
 * @link http://www.php.net/manual/ja/function.imagefilledrectangle.php
 * @param image resource 
 * @param x1 int <p>
 * 開始位置の x 座標。
 * </p>
 * @param y1 int <p>
 * 開始位置の y 座標。
 * </p>
 * @param x2 int <p>
 * 終了位置の x 座標。
 * </p>
 * @param y2 int <p>
 * 終了位置の y 座標。
 * </p>
 * @param color int <p>
 * 塗りつぶし色。
 * imagecolorallocate
 * で作成した色 ID です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagefilledrectangle ($image, $x1, $y1, $x2, $y2, $color) {}

/**
 * 特定色で塗りつぶす
 * @link http://www.php.net/manual/ja/function.imagefilltoborder.php
 * @param image resource 
 * @param x int <p>
 * 開始位置の x 座標。
 * </p>
 * @param y int <p>
 * 開始位置の y 座標。
 * </p>
 * @param border int <p>
 * 境界色。
 * imagecolorallocate
 * で作成した色 ID です。
 * </p>
 * @param color int <p>
 * 塗りつぶし色。
 * imagecolorallocate
 * で作成した色 ID です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagefilltoborder ($image, $x, $y, $border, $color) {}

/**
 * フォントの幅を取得する
 * @link http://www.php.net/manual/ja/function.imagefontwidth.php
 * @param font int 
 * @return int フォントの幅をピクセルで返します。
 */
function imagefontwidth ($font) {}

/**
 * フォントの高さを取得する
 * @link http://www.php.net/manual/ja/function.imagefontheight.php
 * @param font int 
 * @return int フォントの高さをピクセルで返します。
 */
function imagefontheight ($font) {}

/**
 * インターレースを有効もしくは無効にする
 * @link http://www.php.net/manual/ja/function.imageinterlace.php
 * @param image resource 
 * @param interlace int[optional] <p>
 * ゼロ以外の場合はインターレース画像となり、
 * ゼロの場合はインターレースビットを off にします。
 * </p>
 * @return int 画像のインターレースビットが設定されている場合に 1、
 * それ以外の場合に 0 を返します。
 */
function imageinterlace ($image, $interlace = null) {}

/**
 * 直線を描画する
 * @link http://www.php.net/manual/ja/function.imageline.php
 * @param image resource 
 * @param x1 int <p>
 * 最初の点の x 座標。
 * </p>
 * @param y1 int <p>
 * 最初の点の y 座標。
 * </p>
 * @param x2 int <p>
 * 二番目の点の x 座標。
 * </p>
 * @param y2 int <p>
 * 二番目の点の y 座標。
 * </p>
 * @param color int <p>
 * 直線の色。
 * imagecolorallocate
 * で作成した色 ID です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imageline ($image, $x1, $y1, $x2, $y2, $color) {}

/**
 * 新しいフォントを読み込む
 * @link http://www.php.net/manual/ja/function.imageloadfont.php
 * @param file string <p>
 * フォントファイル形式は現在はバイナリで、アーキクチャに依存します。
 * このため、PHP を実行するマシーンと同一の型の CPU 上でフォントファイルを
 * 生成する必要があります。
 * </p>
 * <p>
 * <table>
 * フォントファイルのフォーマット
 * <tr valign="top">
 * <td>バイト位置</td>
 * <td>C 言語のデータ型</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>0-3 バイト目</td>
 * <td>int</td>
 * <td>フォント中の文字の数</td>
 * </tr>
 * <tr valign="top">
 * <td>4-7 バイト目</td>
 * <td>int</td>
 * <td>
 * フォント中の最初の文字の値(しばしば 空白を表す 32 となります)
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>8-11 バイト目</td>
 * <td>int</td>
 * <td>各文字のピクセル幅</td>
 * </tr>
 * <tr valign="top">
 * <td>12-15 バイト目</td>
 * <td>int</td>
 * <td>各文字のピクセル高さ</td>
 * </tr>
 * <tr valign="top">
 * <td>16 バイト目から</td>
 * <td>char</td>
 * <td>
 * 文字データの配列、各文字のピクセルにつき1バイトで、
 * 総数は(文字数*幅*高さ)バイトです。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @return int フォント ID を返します。これは常に 5 より大きくなり、
 * 組み込みのフォントと衝突することはありません。
 * エラー時には FALSE を返します。
 */
function imageloadfont ($file) {}

/**
 * 多角形を描画する
 * @link http://www.php.net/manual/ja/function.imagepolygon.php
 * @param image resource 
 * @param points array <p>
 * 多角形の頂点からなる PHP の配列で、
 * 次のようになります。
 * <tr valign="top">
 * <td>points[0]</td>
 * <td>= x0</td>
 * </tr>
 * <tr valign="top">
 * <td>points[1]</td>
 * <td>= y0</td>
 * </tr>
 * <tr valign="top">
 * <td>points[2]</td>
 * <td>= x1</td>
 * </tr>
 * <tr valign="top">
 * <td>points[3]</td>
 * <td>= y1</td>
 * </tr>
 * </p>
 * @param num_points int <p>
 * 頂点の総数。
 * </p>
 * @param color int <p>
 * imagecolorallocate
 * で作成した色 ID。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagepolygon ($image, array $points, $num_points, $color) {}

/**
 * 矩形を描画する
 * @link http://www.php.net/manual/ja/function.imagerectangle.php
 * @param image resource 
 * @param x1 int <p>
 * 左上の x 座標。
 * </p>
 * @param y1 int <p>
 * 左上の y 座標。
 * 0, 0 が画像の左上隅を表します。
 * </p>
 * @param x2 int <p>
 * 右下の x 座標。
 * </p>
 * @param y2 int <p>
 * 右下の y 座標。
 * </p>
 * @param color int <p>
 * imagecolorallocate
 * で作成した色 ID。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagerectangle ($image, $x1, $y1, $x2, $y2, $color) {}

/**
 * 点を生成する
 * @link http://www.php.net/manual/ja/function.imagesetpixel.php
 * @param image resource 
 * @param x int <p>
 * x 座標。
 * </p>
 * @param y int <p>
 * y 座標。
 * </p>
 * @param color int <p>
 * imagecolorallocate
 * で作成した色 ID。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagesetpixel ($image, $x, $y, $color) {}

/**
 * 文字列を水平に描画する
 * @link http://www.php.net/manual/ja/function.imagestring.php
 * @param image resource 
 * @param font int 
 * @param x int <p>
 * 左上隅の x 座標。
 * </p>
 * @param y int <p>
 * 左上隅の y 座標。
 * </p>
 * @param string string <p>
 * 書き出す文字列。
 * </p>
 * @param color int <p>
 * imagecolorallocate
 * で作成した色 ID。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagestring ($image, $font, $x, $y, $string, $color) {}

/**
 * 文字列を垂直に描画する
 * @link http://www.php.net/manual/ja/function.imagestringup.php
 * @param image resource 
 * @param font int 
 * @param x int <p>
 * 左下隅の x 座標。
 * </p>
 * @param y int <p>
 * 左下隅の y 座標。
 * </p>
 * @param string string <p>
 * 書き出す文字列。
 * </p>
 * @param color int <p>
 * imagecolorallocate
 * で作成した色 ID。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagestringup ($image, $font, $x, $y, $string, $color) {}

/**
 * 画像の幅を取得する
 * @link http://www.php.net/manual/ja/function.imagesx.php
 * @param image resource 
 * @return int image の幅、あるいはエラー時に FALSE
 * を返します。
 */
function imagesx ($image) {}

/**
 * 画像の高さを取得する
 * @link http://www.php.net/manual/ja/function.imagesy.php
 * @param image resource 
 * @return int image の高さ、あるいはエラー時に FALSE
 * を返します。
 */
function imagesy ($image) {}

/**
 * 破線を描画する
 * @link http://www.php.net/manual/ja/function.imagedashedline.php
 * @param image resource 
 * @param x1 int <p>
 * 左上の x 座標。
 * </p>
 * @param y1 int <p>
 * 左上の y 座標 0。0 は画像の左上の角です。
 * </p>
 * @param x2 int <p>
 * 右下の x 座標。
 * </p>
 * @param y2 int <p>
 * 右下の y 座標。
 * </p>
 * @param color int <p>
 * 塗りつぶし色。
 * imagecolorallocate で作成した色 ID。
 * </p>
 * @return bool 常に true を返します。
 */
function imagedashedline ($image, $x1, $y1, $x2, $y2, $color) {}

/**
 * TypeType フォントを使用したテキストの bounding box を生成する
 * @link http://www.php.net/manual/ja/function.imagettfbbox.php
 * @param size float <p>
 * フォントサイズ。
 * GD 1 ではピクセル数、GD 2 ではポイント数で指定します。
 * </p>
 * @param angle float <p>
 * 測定する text の角度(度単位)。
 * </p>
 * @param fontfile string <p>
 * TrueType フォントファイルのファイル名 (URL)。PHP が使用している
 * GD ライブラリのバージョンによっては、'/' から始まり '.ttf' で終わるような
 * ファイル名で探し、またライブラリによって定義されているフォントパスで
 * 探そうと試みます。
 * </p>
 * @param text string <p>
 * 測定する文字列。
 * </p>
 * @return array imagettfbbox は、テキストの bounding box を
 * 作成するための 4 点を表現する 8 個の要素からなる配列を返します。
 * エラー時には FALSE を返します。
 * <tr valign="top">
 * <td>キー</td>
 * <td>内容</td>
 * </tr>
 * <tr valign="top">
 * <td>0</td>
 * <td>左下角の X 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>1</td>
 * <td>左下角の Y 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>2</td>
 * <td>右下角の X 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>3</td>
 * <td>右下角の Y 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>4</td>
 * <td>右上角の X 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>5</td>
 * <td>右上角の Y 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>6</td>
 * <td>左上角の X 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>7</td>
 * <td>左上角の Y 座標</td>
 * </tr>
 * </p>
 * <p>
 * 各点の位置は、
 * angle にかかわらず
 * text からの相対位置で表されます。
 * つまり、"左上"はテキストを水平に見た場合の左上の角を意味します。
 */
function imagettfbbox ($size, $angle, $fontfile, $text) {}

/**
 * TrueType フォントを使用してテキストを画像に書き込む
 * @link http://www.php.net/manual/ja/function.imagettftext.php
 * @param image resource 
 * @param size float <p>フォントサイズ。GD のバージョンによって、ピクセル単位 (GD1) あるいはポイント数 (GD2) で指定します。</p>
 * @param angle float <p>
 * 度で表される角度。0 度は左から右にテキストを読む方向になります。
 * 0 より大きな値は、反時計回りの回転を表現します。例えば、
 * 90 という値は下から上にテキストを読む方向になります。
 * </p>
 * @param x int <p>
 * x と y
 * で与えられた座標は、最初の文字のベースポイント
 * (ほぼ文字の左下角) を定義します。
 * この仕様は、x と y
 * で最初の文字の右上角を定義する
 * imagestring と異なっています。
 * 例えば、左上は 0, 0 となります。
 * </p>
 * @param y int <p>
 * y 座標。これは文字の最下位置ではなく、
 * フォントペースラインの位置を指定します。
 * </p>
 * @param color int <p>
 * カラーインデックス。負の数を使用した場合、
 * アンチエイリアス機能がオフになります。
 * imagecolorallocate を参照ください。
 * </p>
 * @param fontfile string <p>
 * 使用する TrueType フォントのパス。
 * </p>
 * <p>
 * PHP が使用している GD ライブラリのバージョンに依存しており、
 * fontfile が /
 * で始まらない場合、ファイル名に .ttf が追加され、
 * ライブラリはライブラリが定義したフォントパスから
 * ファイル名を検索しようとします。
 * </p>
 * <p>
 * 2.0.18 以前のバージョンの GD ライブラリを使用している場合、
 * 異なるフォントファイルに対する 'パスの区切り文字' として
 * セミコロンよりも space 文字が使用されます。
 * この特徴が意図せずに使用されることで
 * Warning: Could not find/open font
 * という結果になります。
 * これらの影響があるバージョンに対する唯一の解決方法は、
 * スペースを含まないパスにフォントを移動させることです。
 * </p>
 * <p>
 * フォントがスクリプトと同一ディレクトリに存在している場合のほとんどで、
 * 以下のトリックが問題の軽減に繋がります。
 * ]]>
 * </p>
 * @param text string <p>
 * テキスト文字列を UTF-8 エンコーディングで表したもの。
 * </p>
 * <p>
 * フォント内で 127 文字目以降の文字にアクセスするために、
 * (&amp;#8364; のような) 十進数文字参照を含めることができます。
 * (&amp;#xA9; のような) 十六進形式もサポートしています。
 * UTF-8 エンコーディングされた文字列を直接渡すことができます。
 * </p>
 * <p>
 * &amp;copy; のような文字エンティティはサポートされません。
 * html_entity_decode を使用して、
 * 文字エンティティを UTF-8 文字列にすることを検討してください
 * (html_entity_decode() は、PHP 5.0.0 以降でこの機能をサポートします)。
 * </p>
 * <p>
 * フォントでサポートされていない文字が文字列で使用されている場合、
 * その文字は白抜きの矩形に置き換えられます。
 * </p>
 * @return array テキストの境界を
 * 構成する 4 点を表す 8 個の要素を有する配列を返します。
 * 返される点は左下、右下、右上、左上の順番となります。
 * 点の座標は、角度によらず text に関する相対座標として表されます。
 * つまり、"左上"は、text を水平に見た場合の左上の隅を表します。
 * エラー時には FALSE を返します。
 */
function imagettftext ($image, $size, $angle, $x, $y, $color, $fontfile, $text) {}

/**
 * freetype2 によるフォントを用いたテキストを囲む箱を取得する
 * @link http://www.php.net/manual/ja/function.imageftbbox.php
 * @param size float <p>フォントサイズ。GD のバージョンによって、ピクセル単位 (GD1) あるいはポイント数 (GD2) で指定します。</p>
 * @param angle float <p>
 * text を取得する角度。
 * </p>
 * @param fontfile string <p>
 * TrueType フォントのファイル名 (URL も可)。
 * PHP が使用している GD ライブラリのバージョンにも依存しますが、
 * 先頭に '/' がついていないファイル名を渡した場合は
 * ファイル名の末尾に '.ttf' を追加して GD
 * のフォントパスからファイルを探そうとすることもあります。
 * </p>
 * @param text string <p>
 * 取得したい文字列。
 * </p>
 * @param extrainfo array[optional] <p>
 * <table>
 * extrainfo の配列のインデックス
 * <tr valign="top">
 * <td>キー</td>
 * <td>型</td>
 * <td>意味</td>
 * </tr>
 * <tr valign="top">
 * <td>linespacing</td>
 * <td>float</td>
 * <td>描画時の行間を定義します</td>
 * </tr>
 * </table>
 * </p>
 * @return array imageftbbox は 8 つの要素からなる配列を返します。
 * これが、テキストを囲む箱の 4 つの角の座標を表します。
 * <tr valign="top">
 * <td>0</td>
 * <td>左下角の X 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>1</td>
 * <td>左下角の Y 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>2</td>
 * <td>右下角の X 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>3</td>
 * <td>右下角の Y 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>4</td>
 * <td>右上角の X 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>5</td>
 * <td>右上角の Y 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>6</td>
 * <td>左上角の X 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>7</td>
 * <td>左上角の Y 座標</td>
 * </tr>
 * </p>
 * <p>
 * これらの点は、angle の値にかかわらず
 * text からの相対位置になります。
 * つまり「左上」とは、そのテキストが水平になるように見たときの左上ということです。
 */
function imageftbbox ($size, $angle, $fontfile, $text, array $extrainfo = null) {}

/**
 * FreeType 2 によるフォントを用いてイメージにテキストを描画する
 * @link http://www.php.net/manual/ja/function.imagefttext.php
 * @param image resource 
 * @param size float <p>
 * 使用するフォントのサイズ (ポイント数)。
 * </p>
 * @param angle float <p> 
 * 角度 (度数)。0 度は、左から右に読むテキストを表します。
 * 度数を上げていくと、反時計回りに回転します。たとえば、
 * 90 度の場合は下から上に読むテキストとなります。
 * </p>
 * @param x int <p>
 * x と
 * y で表す座標が、最初の文字のベースポイント
 * (その文字の左下の角とほぼ等しい点) となります。
 * imagestring の場合は
 * x と y
 * で最初の文字の左上の角を指定しており、
 * たとえば "左上" は 0, 0 となりますが、この関数では異なります。
 * </p>
 * @param y int <p>
 * y 座標。これはフォントのベースラインを指定するものであり、
 * 文字の最下端を指定するものではありません。
 * </p>
 * @param color int <p>
 * テキストに使用する色のインデックス。
 * imagecolorexact を参照ください。
 * </p>
 * @param fontfile string <p>
 * 使用する TrueType フォントへのパス。
 * </p>
 * <p>
 * PHP が使用している GD ライブラリのバージョンにも依存しますが、
 * fontfile の先頭に /
 * がついていない場合はファイル名の末尾に
 * .ttf を追加して GD
 * のフォントパスからファイルを探そうとすることもあります。
 * </p>
 * <p>
 * GD ライブラリのバージョンが 2.0.18 より古い場合は、複数のフォントファイルを指定するときの
 * 'パス区切り文字' がセミコロンではなく スペース となります。
 * この機能を意図せずに使ってしまい、
 * Warning: Could not find/open font
 * といった警告が発生してしまうことがあります。
 * この問題が発生するバージョンの場合は、
 * スペースを含まないパスにフォントを格納しなければなりません。
 * </p>
 * <p>
 * たいていの場合は、スクリプト内で使うフォントの場所は同じディレクトリになるでしょう。
 * そんな場合は、次のようにすれば読み込み時の問題を回避できます。
 * ]]>
 * </p>
 * @param text string <p>
 * 画像に挿入するテキスト。
 * </p>
 * @param extrainfo array[optional] <p>
 * <table>
 * extrainfo の配列のインデックス
 * <tr valign="top">
 * <td>キー</td>
 * <td>型</td>
 * <td>意味</td>
 * </tr>
 * <tr valign="top">
 * <td>linespacing</td>
 * <td>float</td>
 * <td>描画時の行間を定義します</td>
 * </tr>
 * </table>
 * </p>
 * @return array この関数は、長方形の 4 つの角を表す点の配列を返します。
 * 最初が左下の位置で、そこから反時計回りに回ります。
 * <tr valign="top">
 * <td>0</td>
 * <td>左下の x 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>1</td>
 * <td>左下の y 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>2</td>
 * <td>右下の x 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>3</td>
 * <td>右下の y 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>4</td>
 * <td>右上の x 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>5</td>
 * <td>右上の y 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>6</td>
 * <td>左上の x 座標</td>
 * </tr>
 * <tr valign="top">
 * <td>7</td>
 * <td>左上の y 座標</td>
 * </tr>
 */
function imagefttext ($image, $size, $angle, $x, $y, $color, $fontfile, $text, array $extrainfo = null) {}

/**
 * この PHP がサポートしている画像形式を返す
 * @link http://www.php.net/manual/ja/function.imagetypes.php
 * @return int 画像形式に対応するビットフィールドで、
 * PHP に組み込まれている GD がサポートする画像形式を返します。
 * 返されるビットは次のとおりです。
 * IMG_GIF | IMG_JPG |
 * IMG_PNG | IMG_WBMP | 
 * IMG_XPM。
 */
function imagetypes () {}

/**
 * JPEG イメージファイルから WBMP イメージファイルに変換する
 * @link http://www.php.net/manual/ja/function.jpeg2wbmp.php
 * @param jpegname string <p>
 * JPEG ファイルへのパス。
 * </p>
 * @param wbmpname string <p>
 * 変換後の WBMP ファイルへのパス。
 * </p>
 * @param dest_height int <p>
 * 変換後の画像の高さ。
 * </p>
 * @param dest_width int <p>
 * 変換後の画像の幅。
 * </p>
 * @param threshold int <p>
 * 閾値。0 から 8 までの値 (両端を含みます)。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function jpeg2wbmp ($jpegname, $wbmpname, $dest_height, $dest_width, $threshold) {}

/**
 * PNG イメージファイルから WBMP イメージファイルに変換する
 * @link http://www.php.net/manual/ja/function.png2wbmp.php
 * @param pngname string <p>
 * PNG ファイルへのパス。
 * </p>
 * @param wbmpname string <p>
 * 変換後の WBMP ファイルへのパス。
 * </p>
 * @param dest_height int <p>
 * 変換後の画像の高さ。
 * </p>
 * @param dest_width int <p>
 * 変換後の画像の幅。
 * </p>
 * @param threshold int <p>
 * 閾値。0 から 8 までの値 (両端を含みます)。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function png2wbmp ($pngname, $wbmpname, $dest_height, $dest_width, $threshold) {}

/**
 * 画像をブラウザあるいはファイルに出力する
 * @link http://www.php.net/manual/ja/function.image2wbmp.php
 * @param image resource 
 * @param filename string[optional] <p>
 * 保存されるファイルへのパス。指定しなかった場合は、生の画像ストリームが直接出力されます。
 * </p>
 * @param threshold int[optional] <p>
 * 閾値。0 から 255 までの値 (両端を含みます)。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function image2wbmp ($image, $filename = null, $threshold = null) {}

/**
 * アルファブレンディングフラグを設定し、
   libgd にバンドルされているレイヤ効果を使用する
 * @link http://www.php.net/manual/ja/function.imagelayereffect.php
 * @param image resource 
 * @param effect int <p>
 * 以下の定数のいずれか。
 * IMG_EFFECT_REPLACE
 * ピクセルの置換を使用します
 * (imagealphablending に TRUE
 * を渡すのと同じです)。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagelayereffect ($image, $effect) {}

/**
 * XBM 画像をブラウザあるいはファイルに出力する
 * @link http://www.php.net/manual/ja/function.imagexbm.php
 * @param image resource 
 * @param filename string <p>ファイルの保存先のパス。省略したり NULL を設定したりした場合は、画像ストリームを直接出力します。</p>
 * @param foreground int[optional] <p>
 * このパラメータで、
 * 前景の色を指定できます。imagecolorallocate で
 * 取得した ID を使用してください。デフォルトの前景色は黒です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagexbm ($image, $filename, $foreground = null) {}

/**
 * パレットイメージの色を True カラーイメージに近づける
 * @link http://www.php.net/manual/ja/function.imagecolormatch.php
 * @param image1 resource <p>
 * truecolor イメージリンクリソース。
 * </p>
 * @param image2 resource <p>
 * パレットイメージリンクリソース。
 * image1 と同じ大きさの画像をさします。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagecolormatch ($image1, $image2) {}

/**
 * 画像にフィルタを適用する
 * @link http://www.php.net/manual/ja/function.imagefilter.php
 * @param image resource 
 * @param filtertype int <p>
 * filtertype は、以下のいずれかです。
 * IMG_FILTER_NEGATE: 画像の色を反転させます。
 * @param arg1 int[optional] <p>
 * IMG_FILTER_BRIGHTNESS: 輝度レベル。
 * @param arg2 int[optional] <p>
 * IMG_FILTER_COLORIZE: 緑コンポーネントの値。
 * @param arg3 int[optional] <p>
 * IMG_FILTER_COLORIZE: 青コンポーネントの値。
 * @param arg4 int[optional] <p>
 * IMG_FILTER_COLORIZE: アルファチャネル。
 * 0 から 127 までの値で、0 は完全な不透明、127
 * は完全な透明を表す。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imagefilter ($image, $filtertype, $arg1 = null, $arg2 = null, $arg3 = null, $arg4 = null) {}

/**
 * div および offset の係数を使用し、3x3 の畳み込み配列を適用する
 * @link http://www.php.net/manual/ja/function.imageconvolution.php
 * @param image resource 
 * @param matrix array <p>
 * 3x3 の配列。三つの float 値からなる三つの配列の配列。
 * </p>
 * @param div float <p>
 * 畳み込み結果の除数。正規化で使用します。
 * </p>
 * @param offset float <p>
 * 色オフセット。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function imageconvolution ($image, array $matrix, $div, $offset) {}


/**
 * imagetypes の返り値として使用。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_GIF', 1);

/**
 * imagetypes の返り値として使用。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_JPG', 2);

/**
 * imagetypes の返り値として使用。
 * <p>
 * この定数の値は IMG_JPG と同じです。
 * </p>
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_JPEG', 2);

/**
 * imagetypes の返り値として使用。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_PNG', 4);

/**
 * imagetypes の返り値として使用。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_WBMP', 8);

/**
 * imagetypes の返り値として使用。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_XPM', 16);

/**
 * imagecolorallocate あるいは
 * imagecolorallocatealpha
 * で割り当てた色のかわりに使用できる、特別な色オプション。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_COLOR_TILED', -5);

/**
 * imagecolorallocate あるいは
 * imagecolorallocatealpha
 * で割り当てた色のかわりに使用できる、特別な色オプション。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_COLOR_STYLED', -2);

/**
 * imagecolorallocate あるいは
 * imagecolorallocatealpha
 * で割り当てた色のかわりに使用できる、特別な色オプション。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_COLOR_BRUSHED', -3);

/**
 * imagecolorallocate あるいは
 * imagecolorallocatealpha
 * で割り当てた色のかわりに使用できる、特別な色オプション。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_COLOR_STYLEDBRUSHED', -4);

/**
 * imagecolorallocate あるいは
 * imagecolorallocatealpha
 * で割り当てた色のかわりに使用できる、特別な色オプション。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_COLOR_TRANSPARENT', -6);

/**
 * imagefilledarc 関数で使用するスタイル定数。
 * <p>
 * この定数の値は IMG_ARC_PIE と同じです。
 * </p>
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_ARC_ROUNDED', 0);

/**
 * imagefilledarc 関数で使用するスタイル定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_ARC_PIE', 0);

/**
 * imagefilledarc 関数で使用するスタイル定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_ARC_CHORD', 1);

/**
 * imagefilledarc 関数で使用するスタイル定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_ARC_NOFILL', 2);

/**
 * imagefilledarc 関数で使用するスタイル定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_ARC_EDGED', 4);

/**
 * imagegd2 関数で使用する型定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_GD2_RAW', 1);

/**
 * imagegd2 関数で使用する型定数。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_GD2_COMPRESSED', 2);

/**
 * imagelayereffect 関数で使用するアルファブレンディング効果。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_EFFECT_REPLACE', 0);

/**
 * imagelayereffect 関数で使用するアルファブレンディング効果。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_EFFECT_ALPHABLEND', 1);

/**
 * imagelayereffect 関数で使用するアルファブレンディング効果。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_EFFECT_NORMAL', 2);

/**
 * imagelayereffect 関数で使用するアルファブレンディング効果。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_EFFECT_OVERLAY', 3);

/**
 * バンドルされている GD を使用する場合は 1、
 * それ以外の場合は 0 が設定されます。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('GD_BUNDLED', 1);

/**
 * imagefilter 関数で使用する特別な GD フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_FILTER_NEGATE', 0);

/**
 * imagefilter 関数で使用する特別な GD フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_FILTER_GRAYSCALE', 1);

/**
 * imagefilter 関数で使用する特別な GD フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_FILTER_BRIGHTNESS', 2);

/**
 * imagefilter 関数で使用する特別な GD フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_FILTER_CONTRAST', 3);

/**
 * imagefilter 関数で使用する特別な GD フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_FILTER_COLORIZE', 4);

/**
 * imagefilter 関数で使用する特別な GD フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_FILTER_EDGEDETECT', 5);

/**
 * imagefilter 関数で使用する特別な GD フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_FILTER_GAUSSIAN_BLUR', 7);

/**
 * imagefilter 関数で使用する特別な GD フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_FILTER_SELECTIVE_BLUR', 8);

/**
 * imagefilter 関数で使用する特別な GD フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_FILTER_EMBOSS', 6);

/**
 * imagefilter 関数で使用する特別な GD フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_FILTER_MEAN_REMOVAL', 9);

/**
 * imagefilter 関数で使用する特別な GD フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_FILTER_SMOOTH', 10);

/**
 * imagefilter 関数で使用する特別な GD フィルタ
 * (PHP 5.3.0 以降で使用可能)。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('IMG_FILTER_PIXELATE', 11);

/**
 * PHP をコンパイルしたときの GD のバージョン
 * (PHP 5.2.4 以降で利用可能)。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('GD_VERSION', "2.0.35");

/**
 * PHP をコンパイルしたときの GD のメジャーバージョン
 * (PHP 5.2.4 以降で利用可能)。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('GD_MAJOR_VERSION', 2);

/**
 * PHP をコンパイルしたときの GD のマイナーバージョン
 * (PHP 5.2.4 以降で利用可能)。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('GD_MINOR_VERSION', 0);

/**
 * PHP をコンパイルしたときの GD のリリースバージョン
 * (PHP 5.2.4 以降で利用可能)。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('GD_RELEASE_VERSION', 35);

/**
 * PHP をコンパイルしたときの GD の "追加" バージョン (beta/rc..)
 * (PHP 5.2.4 以降で利用可能)。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('GD_EXTRA_VERSION', "");

/**
 * imagepng 関数で使用する特別な PNG フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('PNG_NO_FILTER', 0);

/**
 * imagepng 関数で使用する特別な PNG フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('PNG_FILTER_NONE', 8);

/**
 * imagepng 関数で使用する特別な PNG フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('PNG_FILTER_SUB', 16);

/**
 * imagepng 関数で使用する特別な PNG フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('PNG_FILTER_UP', 32);

/**
 * imagepng 関数で使用する特別な PNG フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('PNG_FILTER_AVG', 64);

/**
 * imagepng 関数で使用する特別な PNG フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('PNG_FILTER_PAETH', 128);

/**
 * imagepng 関数で使用する特別な PNG フィルタ。
 * @link http://www.php.net/manual/ja/image.constants.php
 */
define ('PNG_ALL_FILTERS', 248);

// End of gd v.
?>
