package icetest;

import java.io.Serializable;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;
import javax.annotation.PostConstruct;

import java.util.logging.Logger;
import javax.inject.Inject;


import java.util.ArrayList;

@ManagedBean
@ViewScoped
public class ChatBean implements Serializable {

    @Inject
    public Logger log;

    
    @Inject
    private FacesContext context;


    private String msg;
    private ArrayList<ChatMessage> msgList;

    public void setMsg(String msg) {
        this.msg = msg;
    }
    public String getMsg() {
        return "";
    }

    ///chat list data
    public static class ChatMessage {
        private String uname;
        private String msg;
        private String date;
        public String getUname() {
            return uname;
        }
        public String getMsg() {
            return msg;
        }
        public String getDate() {
            return date;
        }
        public void setUname(String uname) {
            this.uname = uname;
        }
        public void setMsg(String msg) {
            this.msg = msg;
        }
        public void setDate(String date) {
            this.date = date;
        }
    }


    @PostConstruct
	public void initMsgList(){
	    log.info("initMsgList:");
	    msgList = new ArrayList<ChatMessage>();
	    ChatMessage cm = new ChatMessage();
	    cm.msg = "msg1";
	    cm.date = "xxxxx";
	    cm.uname = "uname1";
	    msgList.add(cm);

	    cm = new ChatMessage();
	    cm.msg = "msg2";
	    cm.date = "yyyy yy yy";
	    cm.uname = "name2.....";
	    msgList.add(cm);

	    cm = new ChatMessage();
	    cm.msg = "msg3333";
	    cm.date = "zzzz zzzzz";
	    cm.uname = "NAME 3333!";
	    msgList.add(cm);
	}
    
	public ArrayList<ChatMessage> getMsgList(){
		return msgList;
	}


}
