package motoSample;

import java.io.Serializable;
import java.util.ArrayList;

import java.io.File;
import java.io.FileWriter;
import java.io.FileReader;
import java.io.BufferedWriter;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.IOException;
import java.io.FileNotFoundException;

import java.util.ResourceBundle;


public final class ChatList implements Serializable {
    ArrayList list;

    public ChatList () {
        list = new ArrayList<String>();
        /*
        list.add("zzzz");
        list.add("ddddd");
        */
        loadMessage();
    }
    
    public ArrayList<String> getValues() {
        return list;
    }

    void loadMessage() {
        //String file_dir = getResources().getMessage("chat.directory"); 
        String file_dir = ResourceBundle.getBundle("motoSample.ApplicationResources").getString("chat.directory"); 

        File dir = new File(file_dir);
        File[] files = dir.listFiles();

        for (int i = 0; i < files.length; i++) {
            //File file = files[i];
            //System.out.println((i + 1) + ":    " + file);

            String fname = files[i].toString();
            try {
                File file = new File(fname);
                BufferedReader br = new BufferedReader(new FileReader(file));
                
                int fname_start = file.toString().lastIndexOf("\\") + 1;
                String msg = file.toString().substring(fname_start) + ": " + br.readLine();
                br.close();

                list.add(msg);
            }catch(FileNotFoundException e){
             System.out.println(e);
            }catch(IOException e){
             System.out.println(e);
            }

        }
        //request.setAttribute("list",list);
    }

}
