package motoSample;

import java.util.Vector;
import java.io.IOException; 
import java.lang.reflect.InvocationTargetException; 
import java.util.Locale; 
import java.util.Hashtable;
import javax.servlet.RequestDispatcher; 
import javax.servlet.ServletException; 
import javax.servlet.http.HttpServletRequest; 
import javax.servlet.http.HttpSession; 
import javax.servlet.http.HttpServletResponse; 
import org.apache.struts.action.Action; 
import org.apache.struts.action.ActionError; 
import org.apache.struts.action.ActionErrors; 
import org.apache.struts.action.ActionForm; 
import org.apache.struts.action.ActionForward; 
import org.apache.struts.action.ActionMapping; 
import org.apache.struts.action.ActionServlet; 
import org.apache.struts.util.MessageResources; 
import org.apache.struts.util.PropertyUtils;

import java.io.File;
import java.io.FileWriter;
import java.io.FileReader;
import java.io.BufferedWriter;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.IOException;
import java.io.FileNotFoundException;

public final class ChatAction extends Action {

    // The constructor method for this class
    public ChatAction() {
    }

    // The method used for processing the user-input
    public ActionForward perform(ActionMapping mapping, 
                                  ActionForm form, 
                                  HttpServletRequest request, 
                                  HttpServletResponse response) 
       throws IOException, ServletException { 

       Locale locale = getLocale(request); 
       MessageResources messages = getResources(); 
       HttpSession session = request.getSession(); 
       ChatForm cform = (ChatForm )form;
        
       // ActionErrors errors = new ActionErrors();

       //$CODE_FOR_PROCESSING_USER_INPUT$
        String msg = cform.getMessage();
        if (msg.trim().length() > 0) {
            saveMessage(cform.getMessageTime(), msg);
        }
        
        
        //listMessages(request);

       if (true) {
       } else {
         return (mapping.findForward("$FAILURE_FORWARD_PAGE$"));
       }

       if (mapping.getAttribute() != null) {
             if ("request".equals(mapping.getScope())) 
               request.removeAttribute(mapping.getAttribute()); 
             else 
               session.removeAttribute(mapping.getAttribute());
       }

       return (mapping.findForward("chatOk")); 

    }

    void saveMessage(String msgTime, String msg) {
        try{
            
            String file_dir = getResources().getMessage("chat.directory"); 
            String fname = file_dir + "/" + msgTime.replaceAll("/", "").replaceAll(":", "").replaceAll(" ", "-") + ".txt";

            File file = new File(fname);

            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));

            pw.println(msg);

            pw.close();
        }catch(IOException e){
          System.out.println(e);
        }
    }

    void listMessages(HttpServletRequest request) {
        String file_dir = getResources().getMessage("chat.directory"); 

        File dir = new File(file_dir);
        File[] files = dir.listFiles();
        java.util.ArrayList list = new java.util.ArrayList();

        for (int i = 0; i < files.length; i++) {
            //File file = files[i];
            //System.out.println((i + 1) + ":    " + file);

            String fname = files[i].toString();
            try {
                File file = new File(fname);
                BufferedReader br = new BufferedReader(new FileReader(file));
                
                int fname_start = file.toString().lastIndexOf("\\") + 1;
                String msg = file.toString().substring(fname_start) + ": " + br.readLine();
                br.close();

                list.add(msg);
            }catch(FileNotFoundException e){
             System.out.println(e);
            }catch(IOException e){
             System.out.println(e);
            }

        }
        request.setAttribute("list",list);
    }

}