package motoSample.jms;

import java.util.Properties;

import javax.jms.QueueConnectionFactory;
import javax.jms.QueueConnection;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.QueueSession;
import javax.jms.QueueReceiver;
import javax.jms.TextMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.JMSException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;


public class JmsReceiver
{
    private static final String JMS_FACTORY = "jms/RemoteConnectionFactory";
    private static final String QUEUE_NAME = "jms/queue/test";

    private static final String INITIAL_CONTEXT_FACTORY = "org.jboss.naming.remote.client.InitialContextFactory";
    private static final String PROVIDER_URL = "remote://localhost:4447";

    private static final String DEFAULT_USERNAME = "jmsuser";
    private static final String DEFAULT_PASSWORD = "jmspassword";

	public static void main(String[] args) throws Exception {

		// ReLXg쐬
		Context ctx = initContext();

		// RlNVt@Ng[ƃL[擾
		QueueConnectionFactory factory;
		Queue queue;
		try {
			factory = (QueueConnectionFactory) ctx.lookup(JMS_FACTORY);
			queue = (Queue) ctx.lookup(QUEUE_NAME);
		} finally {
			ctx.close();
		}

		QueueConnection connection = null;
		QueueSession session = null;
		QueueReceiver receiver = null;
		try {
			// RlNV쐬
			connection = factory.createQueueConnection(System.getProperty("username", DEFAULT_USERNAME), System.getProperty("password", DEFAULT_PASSWORD));

			// ZbV쐬
			session = connection.createQueueSession(false, Session.AUTO_ACKNOWLEDGE);

			// L[V[o[쐬
			receiver = session.createReceiver(queue);

			// bZ[WMJn
			connection.start();

		    int cnt;
			for (cnt = 0; cnt < 5; cnt++) {
				Message msg = receiver.receive();
				if (msg instanceof TextMessage) {
					TextMessage tm = (TextMessage) msg;
					System.out.println("MF" + tm.getText());
				} else if (msg instanceof ObjectMessage) {
					ObjectMessage om = (ObjectMessage) msg;
					Object obj = om.getObject();
					System.out.println("MF" + obj);
				}
			}

        } catch (Exception e) {
            System.out.println(e.getMessage());
            throw e;
		} finally {
			if (connection != null) {
				try { connection.close(); } catch (JMSException e) {}
			}
		}
	}

	public static Context initContext() throws NamingException {
        final Properties env = new Properties();
        env.put(Context.INITIAL_CONTEXT_FACTORY, INITIAL_CONTEXT_FACTORY);
        env.put(Context.PROVIDER_URL, System.getProperty(Context.PROVIDER_URL, PROVIDER_URL));
        env.put(Context.SECURITY_PRINCIPAL, System.getProperty("username", DEFAULT_USERNAME));
        env.put(Context.SECURITY_CREDENTIALS, System.getProperty("password", DEFAULT_PASSWORD));
        Context context = new InitialContext(env);
	    
		return context;
	}
}
