package motoSample.ejb;

import java.rmi.RemoteException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.CreateException;


import java.sql.SQLException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;


public class UserBean implements EntityBean
{
    private EntityContext context = null;
    private Connection connection = null;
    
    ////bean data
    private String userId = new String();
    private String password = new String();
    private String userName = new String();

    
    ////some ejb methods
    public void ejbActivate() {}
    public void ejbPassivate() {}
    public void ejbRemove() {}
    public void ejbStore() {}

    
    public void ejbLoad() {
        System.out.println("in ejbLoad");
        setUserId((String)(context.getPrimaryKey()));
        try {
            loadRow(getUserId());
        } catch (Exception ex) {
            throw new EJBException("ejbLoad: " + ex.getMessage());
        }
        System.out.println("leaving ejbLoad");    
    }
    
    private void loadRow(String uid) throws Exception{
        System.out.println("in loadRow");

        boolean result = false;

        try {
            result = selectByPrimaryKey(uid);
        } catch (Exception ex) {
            throw new EJBException("loadRow: " + ex.getMessage());
        }

        if (!result) {
            throw new ObjectNotFoundException("Row for id " + uid + " not found.");
        }
        
        System.out.println("leaving loadRow");
    }    
    
    public void setEntityContext(EntityContext ctx) {
        System.out.println("in setEntityContext");
        this.context = ctx;
        System.out.println("leaving setEntityContext");    
    }
    public void unsetEntityContext() {
        System.out.println("in unsetEntityContext");
        this.context = null;
        System.out.println("leaving unsetEntityContext");
    }
    
    public String ejbCreate(
			     String uid, 
			     String pwd, 
			     String name) throws CreateException {
        System.out.println("in ejbCreate");
        try {
            //insertRow(uid, pwd, name);
        } catch (Exception ex) {
            throw new EJBException("ejbCreate: " + ex.getMessage());
        }
			        /*
			        */
        this.userId = uid;
        this.password = pwd;
        this.userName = name;
			        
        System.out.println("leaving ejbCreate with " + uid);
        return uid;
    }

    public void ejbPostCreate(
			     String uid, 
			     String pwd, 
			     String name) {
        System.out.println("in ejbPostCreate");
        System.out.println("leaving ejbPostCreate");
    }
    
    
    
    public String ejbFindByPrimaryKey( String uid ) throws FinderException {

        System.out.println("in ejbFindByPrimaryKey");
	    System.out.println(uid);
        System.out.println("hash:" + hashCode());
        //return "";

        boolean result = false;
        

        try {
            result = selectByPrimaryKey(uid);
        } catch (Exception ex) {
            throw new EJBException("ejbFindByPrimaryKey: " + ex.getMessage());
        }

        if (result) {
            System.out.println("leaving ejbFindByPrimaryKey with " + uid);
            return uid;
        } else {
            throw new ObjectNotFoundException("Row for id " + uid + " not found.");
        }
        /*
        return uid;
        */
    }
    

    private boolean selectByPrimaryKey(String uid) throws Exception{

        System.out.println("in selectByPrimaryKey");

        try {
            makeConnection();
/*
*/
            String sqlString = "select user_password, user_name from tb_users where user_id=\'" + uid +"\'";

            Statement statement = connection.createStatement();
            statement.setQueryTimeout(30);  // set timeout to 30 sec.

            ResultSet rs = statement.executeQuery(sqlString);
            if(rs.next())
            {
                // read the result set
                System.out.println("pwd = " + rs.getString("user_password"));
                System.out.println("name = " + rs.getString("user_name"));
                this.userId = uid;
                this.password = rs.getString("user_password");
                this.userName = rs.getString("user_name");
            }
            else {
                System.out.println("uid " + uid + "not found...");
                statement.close();
                closeConnection();
                return false;
            }
            
            statement.close();
            closeConnection();
        } catch (SQLException e) {
            throw new Exception("Error fetching Phone from database");
        }
        System.out.println("leaving selectByPrimaryKey with " + uid);

        return true;
    }
    
    
    
    
    ///bean get/set
    
    public String getUserId() {
        return this.userId;
    }
    public String getPassword() {
        return this.password;
    }
    public String getUserName() {
        System.out.println("get user name:" + userName);
        System.out.println("hash:" + hashCode());
         
        return this.userName;
    }
    public void setUserId(String uid) {
        userId = uid;
    }
    public void setPassword(String pwd) {
        password = pwd;
    }
    public void setUserName(String uname) {
        userName = uname;
    }


    public void makeConnection() {
        System.out.println("in makeConnection");
        try {
            Class.forName("org.sqlite.JDBC");
            try {
                connection = DriverManager.getConnection("jdbc:sqlite:C:/Users/dmotooka/AppData/sqlite/moto-test2.db");

            } catch (SQLException e) {
                System.out.println("AN SQL Exception occurred while getting a connection");
            }
        /*
        */
        } catch (ClassNotFoundException cnfe) {
            System.out.println("Failed to load JDBC drivers.");
        }
        System.out.println("leaving makeConnection");
    }

    /////////////////////////////////////////////////////////////////////////////

    public void closeConnection() {
        System.out.println("in closeConnection");
        try {
            connection.close();
        } catch (SQLException e) {
            System.out.println("An SQL Exception occurred while closing the connection");
        }
        System.out.println("leaving closeConnection");
    }
}
