package motoSample.client;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.util.Properties;

import javax.rmi.PortableRemoteObject;
import java.rmi.RemoteException;
import javax.ejb.FinderException;

import motoSample.ejb.User;
import motoSample.ejb.UserHome;


public class UserLoginBean {
    
    UserHome uhome;

    
    public void startup () throws NamingException {
          Context context=null;
       try
         {
                Properties props = new Properties();
                props.put(Context.INITIAL_CONTEXT_FACTORY, "org.jboss.naming.remote.client.InitialContextFactory");
                props.put(Context.PROVIDER_URL, "remote://localhost:4447");
                props.put(Context.SECURITY_PRINCIPAL, "ejbuser");
                props.put(Context.SECURITY_CREDENTIALS, "ejbpassword");
                context = new InitialContext(props);
	        System.out.println("\n\tGot initial Context: "+context);
         }
       catch (Exception e)
         {
                e.printStackTrace();
          }

         // Lookup Format will be
         // <app-name>/<module-name>/<distinct-name>/<bean-name>!<fully-qualified-classname-of-the-remote-interface>


        Object ref;
        ref = context.lookup("/moto-ejb2-entity/User!motoSample.ejb.UserHome");
        System.out.println("Got reference 2\n");

        // Get a reference from this to the Bean's Home interface
        uhome = (UserHome) PortableRemoteObject.narrow (ref, UserHome.class);

        /*
        */
       
    }
    
    boolean userLogin(String uid, String pwd) {
        try {
            User usr = uhome.findByPrimaryKey(uid);
            if (!usr.getUserId().equals(uid))
                return false;
            
            System.out.println("user name : " + usr.getUserName());
            String ejb_pwd = usr.getPassword();
            //System.out.println("ejb pwd : " + ejb_pwd);
            //System.out.println("form pwd : " + pwd);
            return pwd.equals(ejb_pwd);
        }
        catch (RemoteException e1) {
            return false;
        }
        catch (FinderException e2) {
            return false;
        }
    }

}
