/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.net.URL;

public class ClassloadingUtil {
    public static Object newInstanceFromClassLoader(String className) {
        ClassLoader loader = ClassloadingUtil.class.getClassLoader();
        try {
            Class<?> clazz = loader.loadClass(className);
            return clazz.newInstance();
        }
        catch (Throwable t) {
            try {
                loader = Thread.currentThread().getContextClassLoader();
                if (loader != null) {
                    return loader.loadClass(className).newInstance();
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IllegalArgumentException("Could not find class " + className);
        }
    }

    public static URL findResource(String resourceName) {
        URL resource;
        ClassLoader loader = ClassloadingUtil.class.getClassLoader();
        try {
            resource = loader.getResource(resourceName);
            if (resource != null) {
                return resource;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            return null;
        }
        resource = loader.getResource(resourceName);
        if (resource != null) {
            return resource;
        }
        return null;
    }
}

