/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.action;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.util.MessageResources;

public class Action {
    public static final String DATA_SOURCE_KEY = "org.apache.struts.action.DATA_SOURCE";
    public static final String ERROR_KEY = "org.apache.struts.action.ERROR";
    public static final String EXCEPTION_KEY = "org.apache.struts.action.EXCEPTION";
    public static final String FORM_BEANS_KEY = "org.apache.struts.action.FORM_BEANS";
    public static final String FORWARDS_KEY = "org.apache.struts.action.FORWARDS";
    public static final String LOCALE_KEY = "org.apache.struts.action.LOCALE";
    public static final String MAPPING_KEY = "org.apache.struts.action.mapping.instance";
    public static final String MAPPINGS_KEY = "org.apache.struts.action.MAPPINGS";
    public static final String MESSAGES_KEY = "org.apache.struts.action.MESSAGE";
    public static final String MULTIPART_KEY = "org.apache.struts.action.mapping.multipartclass";
    public static final String SERVLET_KEY = "org.apache.struts.action.SERVLET_MAPPING";
    public static final String TRANSACTION_TOKEN_KEY = "org.apache.struts.action.TOKEN";
    protected static Locale defaultLocale = Locale.getDefault();
    protected ActionServlet servlet = null;

    public ActionServlet getServlet() {
        return this.servlet;
    }

    public void setServlet(ActionServlet servlet) {
        this.servlet = servlet;
    }

    public ActionForward perform(ActionServlet servlet, ActionMapping mapping, ActionForm form, ServletRequest request, ServletResponse response) throws IOException, ServletException {
        return this.perform(mapping, form, request, response);
    }

    public ActionForward perform(ActionMapping mapping, ActionForm form, ServletRequest request, ServletResponse response) throws IOException, ServletException {
        try {
            return this.perform(mapping, form, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public ActionForward perform(ActionServlet servlet, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return this.perform(mapping, form, request, response);
    }

    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return null;
    }

    protected String generateToken(HttpServletRequest request) {
        HttpSession session = request.getSession();
        try {
            byte[] id = session.getId().getBytes();
            byte[] now = new Long(System.currentTimeMillis()).toString().getBytes();
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(id);
            md.update(now);
            return this.toHex(md.digest());
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    protected Locale getLocale(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute(LOCALE_KEY);
        if (locale == null) {
            locale = defaultLocale;
        }
        return locale;
    }

    protected MessageResources getResources() {
        return this.servlet.getResources();
    }

    protected boolean isCancelled(HttpServletRequest request) {
        return request.getParameter("org.apache.struts.taglib.html.CANCEL") != null || request.getParameter("org.apache.struts.taglib.html.CANCEL.x") != null;
    }

    protected boolean isTokenValid(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        String saved = (String)session.getAttribute(TRANSACTION_TOKEN_KEY);
        if (saved == null) {
            return false;
        }
        String token = request.getParameter("org.apache.struts.taglib.html.TOKEN");
        if (token == null) {
            return false;
        }
        return saved.equals(token);
    }

    protected void resetToken(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute(TRANSACTION_TOKEN_KEY);
    }

    protected void saveErrors(HttpServletRequest request, ActionErrors errors) {
        if (errors == null || errors.empty()) {
            request.removeAttribute(ERROR_KEY);
            return;
        }
        request.setAttribute(ERROR_KEY, (Object)errors);
    }

    protected void saveToken(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String token = this.generateToken(request);
        if (token != null) {
            session.setAttribute(TRANSACTION_TOKEN_KEY, (Object)token);
        }
    }

    protected void setLocale(HttpServletRequest request, Locale locale) {
        HttpSession session = request.getSession();
        if (locale == null) {
            locale = defaultLocale;
        }
        session.setAttribute(LOCALE_KEY, (Object)locale);
    }

    protected String toHex(byte[] buffer) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < buffer.length) {
            sb.append(Integer.toHexString(buffer[i] & 0xFF));
            ++i;
        }
        return sb.toString();
    }
}

