/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.struts.util.GenericDataSource;

public class GenericConnection
implements Connection {
    private static final String SQLEXCEPTION_CLOSED = "Connection was closed.";
    protected boolean autoCommit = false;
    protected String catalog = null;
    private boolean closed = false;
    protected Connection conn = null;
    protected int level = 0;
    protected Map map = null;
    protected boolean readOnly = false;
    protected GenericDataSource source = null;

    public GenericConnection(GenericDataSource source, Connection conn, boolean autoCommit, boolean readOnly) throws SQLException {
        this.source = source;
        this.conn = conn;
        this.autoCommit = autoCommit;
        this.catalog = conn.getCatalog();
        this.level = conn.getTransactionIsolation();
        try {
            this.map = conn.getTypeMap();
        }
        catch (SQLException e) {
        }
        catch (UnsupportedOperationException e) {
        }
        catch (AbstractMethodError e) {
            // empty catch block
        }
        this.readOnly = readOnly;
        this.conn.setAutoCommit(this.autoCommit);
        try {
            this.conn.setReadOnly(this.readOnly);
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    public void clearWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        this.conn.clearWarnings();
    }

    public void close() throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        try {
            this.conn.rollback();
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            this.conn.setAutoCommit(this.autoCommit);
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            this.conn.setCatalog(this.catalog);
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            this.conn.setTransactionIsolation(this.level);
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            this.conn.setTypeMap(this.map);
        }
        catch (SQLException e) {
        }
        catch (UnsupportedOperationException e) {
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        try {
            this.conn.setReadOnly(this.readOnly);
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            this.conn.clearWarnings();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.closed = true;
        this.source.returnConnection(this);
    }

    public void commit() throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        this.conn.commit();
    }

    public Statement createStatement() throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        return this.conn.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        return this.conn.createStatement(resultSetType, resultSetConcurrency);
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        return this.conn.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        return this.conn.getCatalog();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        return this.conn.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        return this.conn.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        return this.conn.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        return this.conn.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public boolean isReadOnly() throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        return this.conn.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        return this.conn.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        return this.conn.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        return this.conn.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public void rollback() throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        this.conn.rollback();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        this.conn.setAutoCommit(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        this.conn.setCatalog(catalog);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        this.conn.setReadOnly(readOnly);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        this.conn.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.closed) {
            throw new SQLException(SQLEXCEPTION_CLOSED);
        }
        this.conn.setTypeMap(map);
    }

    Connection getConnection() {
        return this.conn;
    }

    DataSource getDataSource() {
        return this.source;
    }

    void setClosed(boolean closed) {
        this.closed = closed;
    }
}

