package motoSample;

import motoSample.ChatBean.ChatMessage;

public class PushMsg {

    public static class LoginUser {
        String uid;
        boolean login;
        
        public void setUid(String uid) { this.uid = uid; }
        public void setLogin(boolean login) { this.login = login; }
        public String getUid() { return uid; }
        public boolean getLogin() { return login; }
    }
    
    private String pushType;
    private LoginUser lu;
    private ChatMessage cm;
    
    public String getPushType() { return pushType; }
    public void setPushType(String pushType) { this.pushType = pushType; }
    public LoginUser getLoginUser () { return lu; }
    public void setLoginUser (LoginUser lu) { this.lu = lu; }
    public ChatMessage getChatMessage () { return cm; }
    public void setChatMessage (ChatMessage cm) { this.cm = cm; }
    
    public final static String PUSH_TYPE_LOGIN = "PUSH_TYPE_LOGIN";
    public final static String PUSH_TYPE_CHAT_MESSAGE = "PUSH_TYPE_CHAT_MESSAGE";
    public final static String PUSH_TYPE_SESSION_ERROR = "PUSH_TYPE_SESSION_ERROR";
    
    public static PushMsg newLoginPushMsg() {
        PushMsg pm = new PushMsg();
        pm.setPushType(PUSH_TYPE_LOGIN);
        pm.setLoginUser(new LoginUser());
        return pm;
    }

    public static PushMsg newChatMessage() {
        PushMsg pm = new PushMsg();
        pm.setPushType(PUSH_TYPE_CHAT_MESSAGE);
        pm.setChatMessage(new ChatMessage());
        return pm;
    }

    public static PushMsg newSessionErrorMessage() {
        PushMsg pm = new PushMsg();
        pm.setPushType(PUSH_TYPE_SESSION_ERROR);
        return pm;
    }
}
