/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.websocket.WebSocket;
import org.eclipse.jetty.websocket.api.Session;

public class Jetty9WebSocket
extends WebSocket {
    private final Session webSocketConnection;

    public Jetty9WebSocket(Session webSocketConnection, AtmosphereConfig config) {
        super(config);
        this.webSocketConnection = webSocketConnection;
    }

    @Override
    public boolean isOpen() {
        return this.webSocketConnection.isOpen();
    }

    @Override
    public WebSocket write(String s) throws IOException {
        if (this.isOpen()) {
            this.webSocketConnection.getRemote().sendString(s);
        }
        return this;
    }

    @Override
    public WebSocket write(byte[] b, int offset, int length) throws IOException {
        if (this.isOpen()) {
            this.webSocketConnection.getRemote().sendBytes(ByteBuffer.wrap(b, offset, length));
        }
        return this;
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        logger.trace("WebSocket.close() for AtmosphereResource {}", (Object)(this.resource() != null ? this.resource().uuid() : "null"));
        try {
            this.webSocketConnection.close();
        }
        catch (Throwable e) {
            logger.trace("Close error", e);
        }
    }
}

