package logbook.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import logbook.dto.ShipInfoDto;
import logbook.util.builder.Builders;

/**
 * 艦娘
 *
 */
public class Ship {

    /**
     * 艦娘プリセット値
     */
    private static final Map<String, ShipInfoDto> SHIP = Builders
            .newMapBuilder(ConcurrentHashMap<String, ShipInfoDto>::new)
            .put("1", new ShipInfoDto("睦月", "駆逐艦", "むつき", 20, 15, 15))
            .put("2", new ShipInfoDto("如月", "駆逐艦", "きさらぎ", 20, 15, 15))
            .put("3", ShipInfoDto.EMPTY)
            .put("4", ShipInfoDto.EMPTY)
            .put("5", ShipInfoDto.EMPTY)
            .put("6", new ShipInfoDto("長月", "駆逐艦", "ながつき", 20, 15, 15))
            .put("7", new ShipInfoDto("三日月", "駆逐艦", "みかづき", 20, 15, 15))
            .put("8", ShipInfoDto.EMPTY)
            .put("9", new ShipInfoDto("吹雪", "駆逐艦", "ふぶき", 20, 20, 15))
            .put("10", new ShipInfoDto("白雪", "駆逐艦", "しらゆき", 20, 20, 15))
            .put("11", new ShipInfoDto("深雪", "駆逐艦", "みゆき", 20, 20, 15))
            .put("12", new ShipInfoDto("磯波", "駆逐艦", "いそなみ", 20, 20, 15))
            .put("13", new ShipInfoDto("綾波", "駆逐艦", "あやなみ", 20, 20, 15))
            .put("14", new ShipInfoDto("敷波", "駆逐艦", "しきなみ", 20, 20, 15))
            .put("15", new ShipInfoDto("曙", "駆逐艦", "あけぼの", 20, 20, 15))
            .put("16", new ShipInfoDto("潮", "駆逐艦", "うしお", 20, 20, 15))
            .put("17", new ShipInfoDto("陽炎", "駆逐艦", "かげろう", 20, 20, 15))
            .put("18", new ShipInfoDto("不知火", "駆逐艦", "しらぬい", 20, 20, 15))
            .put("19", new ShipInfoDto("黒潮", "駆逐艦", "くろしお", 20, 20, 15))
            .put("20", new ShipInfoDto("雪風", "駆逐艦", "ゆきかぜ", 20, 20, 15))
            .put("21", new ShipInfoDto("長良", "軽巡洋艦", "ながら", 20, 25, 25))
            .put("22", new ShipInfoDto("五十鈴", "軽巡洋艦", "いすず", 12, 25, 25))
            .put("23", new ShipInfoDto("由良", "軽巡洋艦", "ゆら", 20, 25, 25))
            .put("24", new ShipInfoDto("大井", "軽巡洋艦", "おおい", 10, 25, 25))
            .put("25", new ShipInfoDto("北上", "軽巡洋艦", "きたかみ", 10, 25, 25))
            .put("26", new ShipInfoDto("扶桑", "戦艦", "ふそう", 20, 120, 85))
            .put("27", new ShipInfoDto("山城", "戦艦", "やましろ", 20, 120, 85))
            .put("28", new ShipInfoDto("皐月", "駆逐艦", "さつき", 20, 15, 15))
            .put("29", new ShipInfoDto("文月", "駆逐艦", "ふみづき", 20, 15, 15))
            .put("30", new ShipInfoDto("菊月", "駆逐艦", "きくづき", 20, 15, 15))
            .put("31", new ShipInfoDto("望月", "駆逐艦", "もちづき", 20, 15, 15))
            .put("32", new ShipInfoDto("初雪", "駆逐艦", "はつゆき", 20, 20, 15))
            .put("33", new ShipInfoDto("叢雲", "駆逐艦", "むらくも", 20, 20, 15))
            .put("34", new ShipInfoDto("暁", "駆逐艦", "あかつき", 20, 20, 15))
            .put("35", new ShipInfoDto("響", "駆逐艦", "ひびき", 20, 20, 15))
            .put("36", new ShipInfoDto("雷", "駆逐艦", "いかづち", 20, 20, 15))
            .put("37", new ShipInfoDto("電", "駆逐艦", "いなづま", 20, 20, 15))
            .put("38", new ShipInfoDto("初春", "駆逐艦", "はつはる", 20, 20, 15))
            .put("39", new ShipInfoDto("子日", "駆逐艦", "ねのひ", 20, 20, 15))
            .put("40", new ShipInfoDto("若葉", "駆逐艦", "わかば", 20, 20, 15))
            .put("41", new ShipInfoDto("初霜", "駆逐艦", "はつしも", 20, 20, 15))
            .put("42", new ShipInfoDto("白露", "駆逐艦", "しらつゆ", 20, 20, 15))
            .put("43", new ShipInfoDto("時雨", "駆逐艦", "しぐれ", 20, 20, 15))
            .put("44", new ShipInfoDto("村雨", "駆逐艦", "むらさめ", 20, 20, 15))
            .put("45", new ShipInfoDto("夕立", "駆逐艦", "ゆうだち", 20, 20, 15))
            .put("46", new ShipInfoDto("五月雨", "駆逐艦", "さみだれ", 20, 20, 15))
            .put("47", new ShipInfoDto("涼風", "駆逐艦", "すずかぜ", 20, 20, 15))
            .put("48", new ShipInfoDto("霰", "駆逐艦", "あられ", 20, 20, 15))
            .put("49", new ShipInfoDto("霞", "駆逐艦", "かすみ", 20, 20, 15))
            .put("50", new ShipInfoDto("島風", "駆逐艦", "しまかぜ", 20, 25, 20))
            .put("51", new ShipInfoDto("天龍", "軽巡洋艦", "てんりゅう", 20, 20, 25))
            .put("52", new ShipInfoDto("龍田", "軽巡洋艦", "たつた", 20, 20, 25))
            .put("53", new ShipInfoDto("名取", "軽巡洋艦", "なとり", 20, 25, 25))
            .put("54", new ShipInfoDto("川内", "軽巡洋艦", "せんだい", 20, 25, 25))
            .put("55", new ShipInfoDto("神通", "軽巡洋艦", "じんつう", 20, 25, 25))
            .put("56", new ShipInfoDto("那珂", "軽巡洋艦", "なか", 20, 25, 25))
            .put("57", new ShipInfoDto("大井改", "重雷装巡洋艦", "おおい", 50, 50, 25))
            .put("58", new ShipInfoDto("北上改", "重雷装巡洋艦", "きたかみ", 50, 50, 25))
            .put("59", new ShipInfoDto("古鷹", "重巡洋艦", "ふるたか", 25, 50, 35))
            .put("60", new ShipInfoDto("加古", "重巡洋艦", "かこ", 25, 50, 35))
            .put("61", new ShipInfoDto("青葉", "重巡洋艦", "あおば", 25, 50, 35))
            .put("62", new ShipInfoDto("妙高", "重巡洋艦", "みょうこう", 25, 65, 40))
            .put("63", new ShipInfoDto("那智", "重巡洋艦", "なち", 25, 65, 40))
            .put("64", new ShipInfoDto("足柄", "重巡洋艦", "あしがら", 25, 65, 40))
            .put("65", new ShipInfoDto("羽黒", "重巡洋艦", "はぐろ", 25, 65, 40))
            .put("66", new ShipInfoDto("高雄", "重巡洋艦", "たかお", 25, 65, 40))
            .put("67", new ShipInfoDto("愛宕", "重巡洋艦", "あたご", 25, 65, 40))
            .put("68", new ShipInfoDto("摩耶", "重巡洋艦", "まや", 18, 65, 40))
            .put("69", new ShipInfoDto("鳥海", "重巡洋艦", "ちょうかい", 25, 65, 40))
            .put("70", new ShipInfoDto("最上", "重巡洋艦", "もがみ", 10, 65, 40))
            .put("71", new ShipInfoDto("利根", "重巡洋艦", "とね", 25, 60, 45))
            .put("72", new ShipInfoDto("筑摩", "重巡洋艦", "ちくま", 25, 60, 45))
            .put("73", new ShipInfoDto("最上改", "航空巡洋艦", "もがみ", 0, 55, 50))
            .put("74", new ShipInfoDto("祥鳳", "軽空母", "しょうほう", 25, 35, 35))
            .put("75", new ShipInfoDto("飛鷹", "軽空母", "ひよう", 25, 40, 40))
            .put("76", new ShipInfoDto("龍驤", "軽空母", "りゅうじょう", 25, 35, 35))
            .put("77", new ShipInfoDto("伊勢", "戦艦", "いせ", 10, 120, 85))
            .put("78", new ShipInfoDto("金剛", "戦艦", "こんごう", 25, 110, 80))
            .put("79", new ShipInfoDto("榛名", "戦艦", "はるな", 25, 110, 80))
            .put("80", new ShipInfoDto("長門", "戦艦", "ながと", 30, 130, 100))
            .put("81", new ShipInfoDto("陸奥", "戦艦", "むつ", 30, 130, 100))
            .put("82", new ShipInfoDto("伊勢改", "航空戦艦", "いせ", 0, 105, 95))
            .put("83", new ShipInfoDto("赤城", "正規空母", "あかぎ", 30, 55, 60))
            .put("84", new ShipInfoDto("加賀", "正規空母", "かが", 30, 55, 60))
            .put("85", new ShipInfoDto("霧島", "戦艦", "きりしま", 25, 110, 80))
            .put("86", new ShipInfoDto("比叡", "戦艦", "ひえい", 25, 110, 80))
            .put("87", new ShipInfoDto("日向", "戦艦", "ひゅうが", 10, 120, 85))
            .put("88", new ShipInfoDto("日向改", "航空戦艦", "ひゅうが", 0, 105, 95))
            .put("89", new ShipInfoDto("鳳翔", "軽空母", "ほうしょう", 25, 25, 25))
            .put("90", new ShipInfoDto("蒼龍", "正規空母", "そうりゅう", 30, 50, 50))
            .put("91", new ShipInfoDto("飛龍", "正規空母", "ひりゅう", 30, 50, 50))
            .put("92", new ShipInfoDto("隼鷹", "軽空母", "じゅんよう", 25, 40, 40))
            .put("93", new ShipInfoDto("朧", "駆逐艦", "おぼろ", 20, 20, 15))
            .put("94", new ShipInfoDto("漣", "駆逐艦", "さざなみ", 20, 20, 15))
            .put("95", new ShipInfoDto("朝潮", "駆逐艦", "あさしお", 20, 20, 15))
            .put("96", new ShipInfoDto("大潮", "駆逐艦", "おおしお", 20, 20, 15))
            .put("97", new ShipInfoDto("満潮", "駆逐艦", "みちしお", 20, 20, 15))
            .put("98", new ShipInfoDto("荒潮", "駆逐艦", "あらしお", 20, 20, 15))
            .put("99", new ShipInfoDto("球磨", "軽巡洋艦", "くま", 20, 25, 25))
            .put("100", new ShipInfoDto("多摩", "軽巡洋艦", "たま", 20, 25, 25))
            .put("101", new ShipInfoDto("木曾", "軽巡洋艦", "きそ", 20, 25, 25))
            .put("102", new ShipInfoDto("千歳", "水上機母艦", "ちとせ", 10, 35, 35))
            .put("103", new ShipInfoDto("千代田", "水上機母艦", "ちよだ", 10, 35, 35))
            .put("104", new ShipInfoDto("千歳改", "水上機母艦", "ちとせ", 12, 40, 35))
            .put("105", new ShipInfoDto("千代田改", "水上機母艦", "ちよだ", 12, 40, 35))
            .put("106", new ShipInfoDto("千歳甲", "水上機母艦", "ちとせ", 15, 45, 35))
            .put("107", new ShipInfoDto("千代田甲", "水上機母艦", "ちよだ", 15, 45, 35))
            .put("108", new ShipInfoDto("千歳航", "軽空母", "ちとせ", 35, 40, 40))
            .put("109", new ShipInfoDto("千代田航", "軽空母", "ちよだ", 35, 40, 40))
            .put("110", new ShipInfoDto("翔鶴", "正規空母", "しょうかく", 30, 55, 55))
            .put("111", new ShipInfoDto("瑞鶴", "正規空母", "ずいかく", 25, 55, 55))
            .put("112", new ShipInfoDto("瑞鶴改", "正規空母", "ずいかく", 77, 70, 65))
            .put("113", new ShipInfoDto("鬼怒", "軽巡洋艦", "きぬ", 17, 25, 25))
            .put("114", new ShipInfoDto("阿武隈", "軽巡洋艦", "あぶくま", 17, 25, 25))
            .put("115", new ShipInfoDto("夕張", "軽巡洋艦", "ゆうばり", 25, 30, 20))
            .put("116", new ShipInfoDto("瑞鳳", "軽空母", "ずいほう", 25, 35, 35))
            .put("117", new ShipInfoDto("瑞鳳改", "軽空母", "ずいほう", 0, 40, 40))
            .put("118", new ShipInfoDto("大井改二", "重雷装巡洋艦", "おおい", 0, 75, 25))
            .put("119", new ShipInfoDto("北上改二", "重雷装巡洋艦", "きたかみ", 0, 75, 25))
            .put("120", new ShipInfoDto("三隈", "重巡洋艦", "みくま", 30, 65, 40))
            .put("121", new ShipInfoDto("三隈改", "航空巡洋艦", "みくま", 0, 55, 50))
            .put("122", new ShipInfoDto("舞風", "駆逐艦", "まいかぜ", 20, 20, 15))
            .put("123", new ShipInfoDto("衣笠", "重巡洋艦", "きぬがさ", 25, 50, 35))
            .put("124", new ShipInfoDto("鈴谷", "重巡洋艦", "すずや", 35, 65, 40))
            .put("125", new ShipInfoDto("熊野", "重巡洋艦", "くまの", 35, 65, 40))
            .put("126", new ShipInfoDto("伊168", "潜水艦", "い168", 50, 20, 10))
            .put("127", new ShipInfoDto("伊58", "潜水艦", "い58", 50, 20, 10))
            .put("128", new ShipInfoDto("伊8", "潜水艦", "い8", 50, 20, 10))
            .put("129", new ShipInfoDto("鈴谷改", "航空巡洋艦", "すずや", 0, 55, 50))
            .put("130", new ShipInfoDto("熊野改", "航空巡洋艦", "くまの", 0, 55, 50))
            .put("131", new ShipInfoDto("大和", "戦艦", "やまと", 60, 300, 250))
            .put("132", new ShipInfoDto("秋雲", "駆逐艦", "あきぐも", 30, 20, 15))
            .put("133", new ShipInfoDto("夕雲", "駆逐艦", "ゆうぐも", 30, 20, 15))
            .put("134", new ShipInfoDto("巻雲", "駆逐艦", "まきぐも", 30, 20, 15))
            .put("135", new ShipInfoDto("長波", "駆逐艦", "ながなみ", 30, 20, 15))
            .put("136", new ShipInfoDto("大和改", "戦艦", "やまと", 0, 325, 250))
            .put("137", new ShipInfoDto("阿賀野", "軽巡洋艦", "あがの", 35, 35, 30))
            .put("138", new ShipInfoDto("能代", "軽巡洋艦", "のしろ", 35, 35, 30))
            .put("139", new ShipInfoDto("矢矧", "軽巡洋艦", "やはぎ", 35, 35, 30))
            .put("140", new ShipInfoDto("酒匂", "軽巡洋艦", "さかわ", 35, 35, 30))
            .put("141", new ShipInfoDto("五十鈴改二", "軽巡洋艦", "いすず", 0, 30, 25))
            .put("142", new ShipInfoDto("衣笠改二", "重巡洋艦", "きぬがさ", 0, 65, 35))
            .put("143", new ShipInfoDto("武蔵", "戦艦", "むさし", 40, 300, 250))
            .put("144", new ShipInfoDto("夕立改二", "駆逐艦", "ゆうだち", 0, 20, 15))
            .put("145", new ShipInfoDto("時雨改二", "駆逐艦", "しぐれ", 0, 20, 15))
            .put("146", new ShipInfoDto("木曾改二", "重雷装巡洋艦", "きそ", 0, 50, 25))
            .put("147", new ShipInfoDto("Верный", "駆逐艦", "ひびき", 0, 25, 15))
            .put("148", new ShipInfoDto("武蔵改", "戦艦", "むさし", 0, 325, 250))
            .put("149", new ShipInfoDto("金剛改二", "戦艦", "こんごう", 0, 125, 100))
            .put("150", new ShipInfoDto("比叡改二", "戦艦", "ひえい", 0, 125, 100))
            .put("151", new ShipInfoDto("榛名改二", "戦艦", "はるな", 0, 125, 100))
            .put("152", new ShipInfoDto("霧島改二", "戦艦", "きりしま", 0, 125, 100))
            .put("153", new ShipInfoDto("大鳳", "装甲空母", "たいほう", 40, 65, 70))
            .put("154", new ShipInfoDto("香取", "練習巡洋艦", "かとり", 35, 15, 30))
            .put("155", new ShipInfoDto("伊401", "潜水空母", "い401", 35, 15, 20))
            .put("156", new ShipInfoDto("大鳳改", "装甲空母", "たいほう", 0, 75, 90))
            .put("157", new ShipInfoDto("龍驤改二", "軽空母", "りゅうじょう", 0, 45, 40))
            .put("158", new ShipInfoDto("川内改二", "軽巡洋艦", "せんだい", 0, 35, 25))
            .put("159", new ShipInfoDto("神通改二", "軽巡洋艦", "じんつう", 0, 35, 25))
            .put("160", new ShipInfoDto("那珂改二", "軽巡洋艦", "なか", 0, 35, 25))
            .put("161", new ShipInfoDto("あきつ丸", "揚陸艦", "あきつまる", 25, 10, 40))
            .put("162", ShipInfoDto.EMPTY)
            .put("163", new ShipInfoDto("まるゆ", "潜水艦", "まるゆ", 20, 5, 10))
            .put("164", new ShipInfoDto("弥生", "駆逐艦", "やよい", 20, 15, 15))
            .put("165", new ShipInfoDto("卯月", "駆逐艦", "うづき", 25, 15, 15))
            .put("166", new ShipInfoDto("あきつ丸改", "揚陸艦", "あきつまる", 0, 25, 45))
            .put("167", new ShipInfoDto("磯風", "駆逐艦", "いそかぜ", 45, 20, 15))
            .put("168", new ShipInfoDto("浦風", "駆逐艦", "うらかぜ", 35, 20, 15))
            .put("169", new ShipInfoDto("谷風", "駆逐艦", "たにかぜ", 30, 20, 15))
            .put("170", new ShipInfoDto("浜風", "駆逐艦", "はまかぜ", 30, 20, 15))
            .put("171", new ShipInfoDto("Bismarck", "戦艦", "ビスマルク", 30, 110, 90))
            .put("172", new ShipInfoDto("Bismarck改", "戦艦", "ビスマルク", 50, 115, 95))
            .put("173", new ShipInfoDto("Bismarckzwei", "戦艦", "ビスマルク", 75, 135, 105))
            .put("174", new ShipInfoDto("Z1", "駆逐艦", "レーベレヒト・マース", 30, 20, 20))
            .put("175", new ShipInfoDto("Z3", "駆逐艦", "マックス・シュルツ", 30, 20, 20))
            .put("176", new ShipInfoDto("PrinzEugen", "重巡洋艦", "プリンツ・オイゲン", 45, 70, 50))
            .put("177", new ShipInfoDto("PrinzEugen改", "重巡洋艦", "プリンツ・オイゲン", 0, 75, 55))
            .put("178", new ShipInfoDto("Bismarckdrei", "戦艦", "ビスマルク", 0, 155, 110))
            .put("179", new ShipInfoDto("Z1zwei", "駆逐艦", "レーベレヒト・マース", 0, 25, 20))
            .put("180", new ShipInfoDto("Z3zwei", "駆逐艦", "マックス・シュルツ", 0, 25, 20))
            .put("181", new ShipInfoDto("天津風", "駆逐艦", "あまつかぜ", 20, 20, 20))
            .put("182", new ShipInfoDto("明石", "工作艦", "あかし", 35, 10, 50))
            .put("183", new ShipInfoDto("大淀", "軽巡洋艦", "おおよど", 35, 30, 35))
            .put("184", new ShipInfoDto("大鯨", "潜水母艦", "たいげい・りゅうほう", 25, 10, 35))
            .put("185", new ShipInfoDto("龍鳳", "軽空母", "たいげい・りゅうほう", 50, 35, 35))
            .put("186", new ShipInfoDto("時津風", "駆逐艦", "ときつかぜ", 30, 20, 15))
            .put("187", new ShipInfoDto("明石改", "工作艦", "あかし", 0, 15, 55))
            .put("188", new ShipInfoDto("利根改二", "航空巡洋艦", "とね", 0, 65, 50))
            .put("189", new ShipInfoDto("筑摩改二", "航空巡洋艦", "ちくま", 0, 65, 50))
            .put("190", new ShipInfoDto("初風", "駆逐艦", "はつかぜ", 20, 20, 15))
            .put("191", new ShipInfoDto("伊19", "潜水艦", "い19", 50, 20, 10))
            .put("192", new ShipInfoDto("那智改二", "重巡洋艦", "なち", 0, 75, 45))
            .put("193", new ShipInfoDto("足柄改二", "重巡洋艦", "あしがら", 0, 75, 45))
            .put("194", new ShipInfoDto("羽黒改二", "重巡洋艦", "はぐろ", 0, 75, 45))
            .put("195", new ShipInfoDto("綾波改二", "駆逐艦", "あやなみ", 0, 20, 15))
            .put("196", new ShipInfoDto("飛龍改二", "正規空母", "ひりゅう", 0, 75, 70))
            .put("197", new ShipInfoDto("蒼龍改二", "正規空母", "そうりゅう", 0, 75, 70))
            .put("198", ShipInfoDto.EMPTY)
            .put("199", ShipInfoDto.EMPTY)
            .put("200", new ShipInfoDto("阿武隈改二", "軽巡洋艦", "あぶくま", 0, 35, 25))
            .put("201", new ShipInfoDto("吹雪改", "駆逐艦", "ふぶき", 70, 20, 15))
            .put("202", new ShipInfoDto("白雪改", "駆逐艦", "しらゆき", 0, 20, 15))
            .put("203", new ShipInfoDto("初雪改", "駆逐艦", "はつゆき", 0, 20, 15))
            .put("204", new ShipInfoDto("深雪改", "駆逐艦", "みゆき", 0, 20, 15))
            .put("205", new ShipInfoDto("叢雲改", "駆逐艦", "むらくも", 70, 20, 15))
            .put("206", new ShipInfoDto("磯波改", "駆逐艦", "いそなみ", 0, 20, 15))
            .put("207", new ShipInfoDto("綾波改", "駆逐艦", "あやなみ", 70, 20, 15))
            .put("208", new ShipInfoDto("敷波改", "駆逐艦", "しきなみ", 0, 20, 15))
            .put("209", new ShipInfoDto("金剛改", "戦艦", "こんごう", 75, 120, 90))
            .put("210", new ShipInfoDto("比叡改", "戦艦", "ひえい", 75, 120, 90))
            .put("211", new ShipInfoDto("榛名改", "戦艦", "はるな", 80, 120, 90))
            .put("212", new ShipInfoDto("霧島改", "戦艦", "きりしま", 75, 120, 90))
            .put("213", new ShipInfoDto("天龍改", "軽巡洋艦", "てんりゅう", 0, 25, 25))
            .put("214", new ShipInfoDto("龍田改", "軽巡洋艦", "たつた", 0, 25, 25))
            .put("215", new ShipInfoDto("球磨改", "軽巡洋艦", "くま", 0, 30, 25))
            .put("216", new ShipInfoDto("多摩改", "軽巡洋艦", "たま", 0, 30, 25))
            .put("217", new ShipInfoDto("木曾改", "軽巡洋艦", "きそ", 65, 30, 25))
            .put("218", new ShipInfoDto("長良改", "軽巡洋艦", "ながら", 0, 30, 25))
            .put("219", new ShipInfoDto("五十鈴改", "軽巡洋艦", "いすず", 50, 30, 25))
            .put("220", new ShipInfoDto("由良改", "軽巡洋艦", "ゆら", 0, 30, 25))
            .put("221", new ShipInfoDto("名取改", "軽巡洋艦", "なとり", 0, 30, 25))
            .put("222", new ShipInfoDto("川内改", "軽巡洋艦", "せんだい", 60, 30, 25))
            .put("223", new ShipInfoDto("神通改", "軽巡洋艦", "じんつう", 60, 30, 25))
            .put("224", new ShipInfoDto("那珂改", "軽巡洋艦", "なか", 48, 30, 25))
            .put("225", new ShipInfoDto("陽炎改", "駆逐艦", "かげろう", 0, 20, 15))
            .put("226", new ShipInfoDto("不知火改", "駆逐艦", "しらぬい", 0, 20, 15))
            .put("227", new ShipInfoDto("黒潮改", "駆逐艦", "くろしお", 0, 20, 15))
            .put("228", new ShipInfoDto("雪風改", "駆逐艦", "ゆきかぜ", 0, 20, 15))
            .put("229", new ShipInfoDto("島風改", "駆逐艦", "しまかぜ", 0, 25, 20))
            .put("230", new ShipInfoDto("朧改", "駆逐艦", "おぼろ", 0, 20, 15))
            .put("231", new ShipInfoDto("曙改", "駆逐艦", "あけぼの", 0, 20, 15))
            .put("232", new ShipInfoDto("漣改", "駆逐艦", "さざなみ", 0, 20, 15))
            .put("233", new ShipInfoDto("潮改", "駆逐艦", "うしお", 60, 20, 15))
            .put("234", new ShipInfoDto("暁改", "駆逐艦", "あかつき", 70, 20, 15))
            .put("235", new ShipInfoDto("響改", "駆逐艦", "ひびき", 70, 20, 15))
            .put("236", new ShipInfoDto("雷改", "駆逐艦", "いかづち", 0, 20, 15))
            .put("237", new ShipInfoDto("電改", "駆逐艦", "いなづま", 0, 20, 15))
            .put("238", new ShipInfoDto("初春改", "駆逐艦", "はつはる", 65, 20, 15))
            .put("239", new ShipInfoDto("子日改", "駆逐艦", "ねのひ", 0, 20, 15))
            .put("240", new ShipInfoDto("若葉改", "駆逐艦", "わかば", 0, 20, 15))
            .put("241", new ShipInfoDto("初霜改", "駆逐艦", "はつしも", 70, 20, 15))
            .put("242", new ShipInfoDto("白露改", "駆逐艦", "しらつゆ", 0, 20, 15))
            .put("243", new ShipInfoDto("時雨改", "駆逐艦", "しぐれ", 60, 20, 15))
            .put("244", new ShipInfoDto("村雨改", "駆逐艦", "むらさめ", 0, 20, 15))
            .put("245", new ShipInfoDto("夕立改", "駆逐艦", "ゆうだち", 55, 20, 15))
            .put("246", new ShipInfoDto("五月雨改", "駆逐艦", "さみだれ", 0, 20, 15))
            .put("247", new ShipInfoDto("涼風改", "駆逐艦", "すずかぜ", 0, 20, 15))
            .put("248", new ShipInfoDto("朝潮改", "駆逐艦", "あさしお", 0, 20, 15))
            .put("249", new ShipInfoDto("大潮改", "駆逐艦", "おおしお", 0, 20, 15))
            .put("250", new ShipInfoDto("満潮改", "駆逐艦", "みちしお", 0, 20, 15))
            .put("251", new ShipInfoDto("荒潮改", "駆逐艦", "あらしお", 0, 20, 15))
            .put("252", new ShipInfoDto("霰改", "駆逐艦", "あられ", 0, 20, 15))
            .put("253", new ShipInfoDto("霞改", "駆逐艦", "かすみ", 0, 20, 15))
            .put("254", new ShipInfoDto("睦月改", "駆逐艦", "むつき", 65, 15, 15))
            .put("255", new ShipInfoDto("如月改", "駆逐艦", "きさらぎ", 65, 15, 15))
            .put("256", new ShipInfoDto("皐月改", "駆逐艦", "さつき", 0, 15, 15))
            .put("257", new ShipInfoDto("文月改", "駆逐艦", "ふみづき", 0, 15, 15))
            .put("258", new ShipInfoDto("長月改", "駆逐艦", "ながつき", 0, 15, 15))
            .put("259", new ShipInfoDto("菊月改", "駆逐艦", "きくづき", 0, 15, 15))
            .put("260", new ShipInfoDto("三日月改", "駆逐艦", "みかづき", 0, 15, 15))
            .put("261", new ShipInfoDto("望月改", "駆逐艦", "もちづき", 0, 15, 15))
            .put("262", new ShipInfoDto("古鷹改", "重巡洋艦", "ふるたか", 65, 55, 35))
            .put("263", new ShipInfoDto("加古改", "重巡洋艦", "かこ", 65, 55, 35))
            .put("264", new ShipInfoDto("青葉改", "重巡洋艦", "あおば", 0, 55, 35))
            .put("265", new ShipInfoDto("妙高改", "重巡洋艦", "みょうこう", 70, 70, 40))
            .put("266", new ShipInfoDto("那智改", "重巡洋艦", "なち", 65, 70, 40))
            .put("267", new ShipInfoDto("足柄改", "重巡洋艦", "あしがら", 65, 70, 40))
            .put("268", new ShipInfoDto("羽黒改", "重巡洋艦", "はぐろ", 65, 70, 40))
            .put("269", new ShipInfoDto("高雄改", "重巡洋艦", "たかお", 0, 70, 40))
            .put("270", new ShipInfoDto("愛宕改", "重巡洋艦", "あたご", 0, 70, 40))
            .put("271", new ShipInfoDto("摩耶改", "重巡洋艦", "まや", 75, 70, 40))
            .put("272", new ShipInfoDto("鳥海改", "重巡洋艦", "ちょうかい", 65, 70, 40))
            .put("273", new ShipInfoDto("利根改", "重巡洋艦", "とね", 70, 65, 45))
            .put("274", new ShipInfoDto("筑摩改", "重巡洋艦", "ちくま", 70, 65, 45))
            .put("275", new ShipInfoDto("長門改", "戦艦", "ながと", 0, 160, 100))
            .put("276", new ShipInfoDto("陸奥改", "戦艦", "むつ", 0, 160, 100))
            .put("277", new ShipInfoDto("赤城改", "正規空母", "あかぎ", 0, 75, 75))
            .put("278", new ShipInfoDto("加賀改", "正規空母", "かが", 0, 80, 80))
            .put("279", new ShipInfoDto("蒼龍改", "正規空母", "そうりゅう", 78, 65, 65))
            .put("280", new ShipInfoDto("飛龍改", "正規空母", "ひりゅう", 77, 65, 65))
            .put("281", new ShipInfoDto("龍驤改", "軽空母", "りゅうじょう", 75, 40, 40))
            .put("282", new ShipInfoDto("祥鳳改", "軽空母", "しょうほう", 0, 40, 40))
            .put("283", new ShipInfoDto("飛鷹改", "軽空母", "ひよう", 0, 45, 45))
            .put("284", new ShipInfoDto("隼鷹改", "軽空母", "じゅんよう", 80, 45, 45))
            .put("285", new ShipInfoDto("鳳翔改", "軽空母", "ほうしょう", 0, 30, 30))
            .put("286", new ShipInfoDto("扶桑改", "航空戦艦", "ふそう", 80, 105, 95))
            .put("287", new ShipInfoDto("山城改", "航空戦艦", "やましろ", 80, 105, 95))
            .put("288", new ShipInfoDto("翔鶴改", "正規空母", "しょうかく", 80, 70, 65))
            .put("289", new ShipInfoDto("鬼怒改", "軽巡洋艦", "きぬ", 0, 35, 25))
            .put("290", new ShipInfoDto("阿武隈改", "軽巡洋艦", "あぶくま", 75, 35, 25))
            .put("291", new ShipInfoDto("千歳航改", "軽空母", "ちとせ", 50, 40, 45))
            .put("292", new ShipInfoDto("千代田航改", "軽空母", "ちよだ", 50, 40, 45))
            .put("293", new ShipInfoDto("夕張改", "軽巡洋艦", "ゆうばり", 0, 40, 25))
            .put("294", new ShipInfoDto("舞風改", "駆逐艦", "まいかぜ", 0, 20, 15))
            .put("295", new ShipInfoDto("衣笠改", "重巡洋艦", "きぬがさ", 55, 60, 35))
            .put("296", new ShipInfoDto("千歳航改二", "軽空母", "ちとせ", 0, 40, 45))
            .put("297", new ShipInfoDto("千代田航改二", "軽空母", "ちよだ", 0, 40, 45))
            .put("298", ShipInfoDto.EMPTY)
            .put("299", ShipInfoDto.EMPTY)
            .put("300", new ShipInfoDto("初風改", "駆逐艦", "はつかぜ", 0, 20, 15))
            .put("301", new ShipInfoDto("秋雲改", "駆逐艦", "あきぐも", 0, 20, 15))
            .put("302", new ShipInfoDto("夕雲改", "駆逐艦", "ゆうぐも", 0, 20, 15))
            .put("303", new ShipInfoDto("巻雲改", "駆逐艦", "まきぐも", 0, 20, 15))
            .put("304", new ShipInfoDto("長波改", "駆逐艦", "ながなみ", 0, 20, 15))
            .put("305", new ShipInfoDto("阿賀野改", "軽巡洋艦", "あがの", 0, 40, 30))
            .put("306", new ShipInfoDto("能代改", "軽巡洋艦", "のしろ", 0, 40, 30))
            .put("307", new ShipInfoDto("矢矧改", "軽巡洋艦", "やはぎ", 0, 40, 30))
            .put("308", new ShipInfoDto("弥生改", "駆逐艦", "やよい", 0, 15, 15))
            .put("309", new ShipInfoDto("卯月改", "駆逐艦", "うづき", 0, 15, 15))
            .put("310", new ShipInfoDto("Z1改", "駆逐艦", "レーベレヒト・マース", 70, 25, 20))
            .put("311", new ShipInfoDto("Z3改", "駆逐艦", "マックス・シュルツ", 70, 25, 20))
            .put("312", new ShipInfoDto("浜風改", "駆逐艦", "はまかぜ", 0, 20, 15))
            .put("313", new ShipInfoDto("谷風改", "駆逐艦", "たにかぜ", 0, 20, 15))
            .put("314", new ShipInfoDto("酒匂改", "軽巡洋艦", "さかわ", 0, 40, 30))
            .put("315", ShipInfoDto.EMPTY)
            .put("316", new ShipInfoDto("天津風改", "駆逐艦", "あまつかぜ", 0, 20, 20))
            .put("317", new ShipInfoDto("浦風改", "駆逐艦", "うらかぜ", 0, 20, 15))
            .put("318", new ShipInfoDto("龍鳳改", "軽空母", "たいげい・りゅうほう", 0, 40, 35))
            .put("319", new ShipInfoDto("妙高改二", "重巡洋艦", "みょうこう", 0, 75, 45))
            .put("320", new ShipInfoDto("磯風改", "駆逐艦", "いそかぜ", 0, 20, 15))
            .put("321", new ShipInfoDto("大淀改", "軽巡洋艦", "おおよど", 0, 35, 35))
            .put("322", new ShipInfoDto("時津風改", "駆逐艦", "ときつかぜ", 0, 20, 15))
            .put("323", new ShipInfoDto("春雨改", "駆逐艦", "はるさめ", 0, 20, 15))
            .put("324", new ShipInfoDto("早霜改", "駆逐艦", "はやしも", 0, 20, 15))
            .put("325", new ShipInfoDto("清霜改", "駆逐艦", "きよしも", 0, 20, 15))
            .put("326", new ShipInfoDto("初春改二", "駆逐艦", "はつはる", 0, 20, 15))
            .put("327", new ShipInfoDto("朝雲改", "駆逐艦", "あさぐも", 0, 20, 15))
            .put("328", new ShipInfoDto("山雲改", "駆逐艦", "やまぐも", 0, 20, 15))
            .put("329", new ShipInfoDto("野分改", "駆逐艦", "のわき", 0, 20, 15))
            .put("330", new ShipInfoDto("秋月改", "駆逐艦", "あきづき", 0, 25, 20))
            .put("331", new ShipInfoDto("天城", "正規空母", "あまぎ", 50, 45, 50))
            .put("332", new ShipInfoDto("葛城", "正規空母", "かつらぎ", 50, 45, 50))
            .put("333", ShipInfoDto.EMPTY)
            .put("334", new ShipInfoDto("U-511改", "潜水艦", "ゆー511・ろ500", 55, 20, 10))
            .put("335", ShipInfoDto.EMPTY)
            .put("336", ShipInfoDto.EMPTY)
            .put("337", ShipInfoDto.EMPTY)
            .put("338", ShipInfoDto.EMPTY)
            .put("339", ShipInfoDto.EMPTY)
            .put("340", ShipInfoDto.EMPTY)
            .put("341", ShipInfoDto.EMPTY)
            .put("342", ShipInfoDto.EMPTY)
            .put("343", new ShipInfoDto("香取改", "練習巡洋艦", "かとり", 0, 20, 35))
            .put("344", new ShipInfoDto("朝霜改", "駆逐艦", "あさしも", 0, 20, 15))
            .put("345", new ShipInfoDto("高波改", "駆逐艦", "たかなみ", 0, 20, 15))
            .put("346", new ShipInfoDto("照月改", "駆逐艦", "てるづき", 0, 25, 20))
            .put("347", new ShipInfoDto("Libeccio改", "駆逐艦", "リベッチオ", 0, 20, 15))
            .put("348", new ShipInfoDto("瑞穂改", "水上機母艦", "みずほ", 0, 45, 40))
            .put("349", new ShipInfoDto("風雲改", "駆逐艦", "かざぐも", 0, 20, 15))
            .put("350", new ShipInfoDto("海風改", "駆逐艦", "うみかぜ", 0, 20, 15))
            .put("351", new ShipInfoDto("江風改", "駆逐艦", "かわかぜ", 0, 20, 15))
            .put("352", new ShipInfoDto("速吸改", "補給艦", "はやすい", 0, 20, 120))
            .put("353", new ShipInfoDto("GrafZeppelin改", "正規空母", "グラーフ・ツェッペリン", 0, 80, 70))
            .put("354", new ShipInfoDto("嵐改", "駆逐艦", "あらし", 0, 20, 15))
            .put("355", new ShipInfoDto("萩風改", "駆逐艦", "はぎかぜ", 0, 20, 15))
            .put("356", new ShipInfoDto("鹿島改", "練習巡洋艦", "かしま", 0, 20, 35))
            .put("357", ShipInfoDto.EMPTY)
            .put("358", ShipInfoDto.EMPTY)
            .put("359", ShipInfoDto.EMPTY)
            .put("360", ShipInfoDto.EMPTY)
            .put("361", ShipInfoDto.EMPTY)
            .put("362", ShipInfoDto.EMPTY)
            .put("363", ShipInfoDto.EMPTY)
            .put("364", ShipInfoDto.EMPTY)
            .put("365", ShipInfoDto.EMPTY)
            .put("366", ShipInfoDto.EMPTY)
            .put("367", ShipInfoDto.EMPTY)
            .put("368", ShipInfoDto.EMPTY)
            .put("369", ShipInfoDto.EMPTY)
            .put("370", ShipInfoDto.EMPTY)
            .put("371", ShipInfoDto.EMPTY)
            .put("372", ShipInfoDto.EMPTY)
            .put("373", ShipInfoDto.EMPTY)
            .put("374", ShipInfoDto.EMPTY)
            .put("375", ShipInfoDto.EMPTY)
            .put("376", ShipInfoDto.EMPTY)
            .put("377", ShipInfoDto.EMPTY)
            .put("378", ShipInfoDto.EMPTY)
            .put("379", ShipInfoDto.EMPTY)
            .put("380", ShipInfoDto.EMPTY)
            .put("381", ShipInfoDto.EMPTY)
            .put("382", ShipInfoDto.EMPTY)
            .put("383", ShipInfoDto.EMPTY)
            .put("384", ShipInfoDto.EMPTY)
            .put("385", ShipInfoDto.EMPTY)
            .put("386", ShipInfoDto.EMPTY)
            .put("387", ShipInfoDto.EMPTY)
            .put("388", ShipInfoDto.EMPTY)
            .put("389", ShipInfoDto.EMPTY)
            .put("390", ShipInfoDto.EMPTY)
            .put("391", ShipInfoDto.EMPTY)
            .put("392", ShipInfoDto.EMPTY)
            .put("393", ShipInfoDto.EMPTY)
            .put("394", ShipInfoDto.EMPTY)
            .put("395", ShipInfoDto.EMPTY)
            .put("396", ShipInfoDto.EMPTY)
            .put("397", ShipInfoDto.EMPTY)
            .put("398", new ShipInfoDto("伊168改", "潜水艦", "い168", 0, 20, 10))
            .put("399", new ShipInfoDto("伊58改", "潜水空母", "い58", 0, 25, 10))
            .put("400", new ShipInfoDto("伊8改", "潜水空母", "い8", 0, 25, 10))
            .put("401", new ShipInfoDto("伊19改", "潜水空母", "い19", 0, 25, 10))
            .put("402", new ShipInfoDto("まるゆ改", "潜水艦", "まるゆ", 0, 10, 10))
            .put("403", new ShipInfoDto("伊401改", "潜水空母", "い401", 0, 30, 25))
            .put("404", new ShipInfoDto("雲龍", "正規空母", "うんりゅう", 50, 45, 50))
            .put("405", new ShipInfoDto("春雨", "駆逐艦", "はるさめ", 30, 20, 15))
            .put("406", new ShipInfoDto("雲龍改", "正規空母", "うんりゅう", 0, 55, 50))
            .put("407", new ShipInfoDto("潮改二", "駆逐艦", "うしお", 0, 20, 15))
            .put("408", new ShipInfoDto("隼鷹改二", "軽空母", "じゅんよう", 0, 50, 45))
            .put("409", new ShipInfoDto("早霜", "駆逐艦", "はやしも", 30, 20, 15))
            .put("410", new ShipInfoDto("清霜", "駆逐艦", "きよしも", 30, 20, 15))
            .put("411", new ShipInfoDto("扶桑改二", "航空戦艦", "ふそう", 0, 140, 105))
            .put("412", new ShipInfoDto("山城改二", "航空戦艦", "やましろ", 0, 140, 105))
            .put("413", new ShipInfoDto("朝雲", "駆逐艦", "あさぐも", 35, 20, 15))
            .put("414", new ShipInfoDto("山雲", "駆逐艦", "やまぐも", 35, 20, 15))
            .put("415", new ShipInfoDto("野分", "駆逐艦", "のわき", 35, 20, 15))
            .put("416", new ShipInfoDto("古鷹改二", "重巡洋艦", "ふるたか", 0, 65, 35))
            .put("417", new ShipInfoDto("加古改二", "重巡洋艦", "かこ", 0, 65, 35))
            .put("418", ShipInfoDto.EMPTY)
            .put("419", new ShipInfoDto("初霜改二", "駆逐艦", "はつしも", 0, 20, 15))
            .put("420", new ShipInfoDto("叢雲改二", "駆逐艦", "むらくも", 0, 20, 15))
            .put("421", new ShipInfoDto("秋月", "駆逐艦", "あきづき", 40, 25, 20))
            .put("422", new ShipInfoDto("照月", "駆逐艦", "てるづき", 40, 25, 20))
            .put("423", ShipInfoDto.EMPTY)
            .put("424", new ShipInfoDto("高波", "駆逐艦", "たかなみ", 30, 20, 15))
            .put("425", new ShipInfoDto("朝霜", "駆逐艦", "あさしも", 45, 20, 15))
            .put("426", new ShipInfoDto("吹雪改二", "駆逐艦", "ふぶき", 0, 20, 15))
            .put("427", new ShipInfoDto("鳥海改二", "重巡洋艦", "ちょうかい", 0, 80, 45))
            .put("428", new ShipInfoDto("摩耶改二", "重巡洋艦", "まや", 0, 80, 45))
            .put("429", new ShipInfoDto("天城改", "正規空母", "あまぎ", 0, 55, 50))
            .put("430", new ShipInfoDto("葛城改", "正規空母", "かつらぎ", 0, 55, 50))
            .put("431", new ShipInfoDto("U-511", "潜水艦", "ゆー511・ろ500", 35, 20, 10))
            .put("432", new ShipInfoDto("GrafZeppelin", "正規空母", "グラーフ・ツェッペリン", 50, 65, 55))
            .put("433", ShipInfoDto.EMPTY)
            .put("434", new ShipInfoDto("睦月改二", "駆逐艦", "むつき", 0, 15, 15))
            .put("435", new ShipInfoDto("如月改二", "駆逐艦", "きさらぎ", 0, 15, 15))
            .put("436", new ShipInfoDto("呂500", "潜水艦", "ゆー511・ろ500", 0, 20, 10))
            .put("437", new ShipInfoDto("暁改二", "駆逐艦", "あかつき", 0, 20, 15))
            .put("438", ShipInfoDto.EMPTY)
            .put("439", ShipInfoDto.EMPTY)
            .put("440", ShipInfoDto.EMPTY)
            .put("441", new ShipInfoDto("Littorio", "戦艦", "リットリオ・イタリア", 35, 150, 130))
            .put("442", new ShipInfoDto("Roma", "戦艦", "ローマ", 35, 150, 130))
            .put("443", new ShipInfoDto("Libeccio", "駆逐艦", "リベッチオ", 30, 20, 15))
            .put("444", ShipInfoDto.EMPTY)
            .put("445", new ShipInfoDto("秋津洲", "水上機母艦", "あきつしま", 35, 10, 50))
            .put("446", new ShipInfoDto("Italia", "戦艦", "リットリオ・イタリア", 0, 170, 140))
            .put("447", new ShipInfoDto("Roma改", "戦艦", "ローマ", 0, 170, 140))
            .put("448", ShipInfoDto.EMPTY)
            .put("449", ShipInfoDto.EMPTY)
            .put("450", new ShipInfoDto("秋津洲改", "水上機母艦", "あきつしま", 0, 15, 60))
            .put("451", new ShipInfoDto("瑞穂", "水上機母艦", "みずほ", 40, 35, 35))
            .put("452", ShipInfoDto.EMPTY)
            .put("453", new ShipInfoDto("風雲", "駆逐艦", "かざぐも", 30, 20, 15))
            .put("454", new ShipInfoDto("嵐", "駆逐艦", "あらし", 35, 20, 15))
            .put("455", new ShipInfoDto("萩風", "駆逐艦", "はぎかぜ", 35, 20, 15))
            .put("456", ShipInfoDto.EMPTY)
            .put("457", ShipInfoDto.EMPTY)
            .put("458", new ShipInfoDto("海風", "駆逐艦", "うみかぜ", 30, 20, 15))
            .put("459", new ShipInfoDto("江風", "駆逐艦", "かわかぜ", 30, 20, 15))
            .put("460", new ShipInfoDto("速吸", "補給艦", "はやすい", 25, 15, 100))
            .put("461", new ShipInfoDto("翔鶴改二", "正規空母", "しょうかく", 88, 85, 90))
            .put("462", new ShipInfoDto("瑞鶴改二", "正規空母", "ずいかく", 90, 85, 90))
            .put("463", ShipInfoDto.EMPTY)
            .put("464", ShipInfoDto.EMPTY)
            .put("465", new ShipInfoDto("鹿島", "練習巡洋艦", "かしま", 35, 15, 30))
            .put("466", new ShipInfoDto("翔鶴改二甲", "装甲空母", "しょうかく", 88, 85, 100))
            .put("467", new ShipInfoDto("瑞鶴改二甲", "装甲空母", "ずいかく", 90, 85, 100))
            .put("468", ShipInfoDto.EMPTY)
            .put("469", ShipInfoDto.EMPTY)
            .put("470", ShipInfoDto.EMPTY)
            .put("471", ShipInfoDto.EMPTY)
            .put("472", ShipInfoDto.EMPTY)
            .put("473", ShipInfoDto.EMPTY)
            .put("474", ShipInfoDto.EMPTY)
            .put("475", ShipInfoDto.EMPTY)
            .put("476", ShipInfoDto.EMPTY)
            .put("477", ShipInfoDto.EMPTY)
            .put("478", ShipInfoDto.EMPTY)
            .put("479", ShipInfoDto.EMPTY)
            .put("480", ShipInfoDto.EMPTY)
            .put("481", ShipInfoDto.EMPTY)
            .put("482", ShipInfoDto.EMPTY)
            .put("483", ShipInfoDto.EMPTY)
            .put("484", ShipInfoDto.EMPTY)
            .put("485", ShipInfoDto.EMPTY)
            .put("486", ShipInfoDto.EMPTY)
            .put("487", ShipInfoDto.EMPTY)
            .put("488", ShipInfoDto.EMPTY)
            .put("489", ShipInfoDto.EMPTY)
            .put("490", ShipInfoDto.EMPTY)
            .put("491", ShipInfoDto.EMPTY)
            .put("492", ShipInfoDto.EMPTY)
            .put("493", ShipInfoDto.EMPTY)
            .put("494", ShipInfoDto.EMPTY)
            .put("495", ShipInfoDto.EMPTY)
            .put("496", ShipInfoDto.EMPTY)
            .put("497", ShipInfoDto.EMPTY)
            .put("498", ShipInfoDto.EMPTY)
            .put("499", ShipInfoDto.EMPTY)
            .put("500", ShipInfoDto.EMPTY)
            .put("501", new ShipInfoDto("駆逐イ級", "駆逐艦", "", 0, 0, 0))
            .put("502", new ShipInfoDto("駆逐ロ級", "駆逐艦", "", 0, 0, 0))
            .put("503", new ShipInfoDto("駆逐ハ級", "駆逐艦", "", 0, 0, 0))
            .put("504", new ShipInfoDto("駆逐ニ級", "駆逐艦", "", 0, 0, 0))
            .put("505", new ShipInfoDto("軽巡ホ級", "軽巡洋艦", "", 0, 0, 0))
            .put("506", new ShipInfoDto("軽巡ヘ級", "軽巡洋艦", "", 0, 0, 0))
            .put("507", new ShipInfoDto("軽巡ト級", "軽巡洋艦", "", 0, 0, 0))
            .put("508", new ShipInfoDto("雷巡チ級", "重雷装巡洋艦", "", 0, 0, 0))
            .put("509", new ShipInfoDto("重巡リ級", "重巡洋艦", "", 0, 0, 0))
            .put("510", new ShipInfoDto("軽母ヌ級", "軽空母", "", 0, 0, 0))
            .put("511", new ShipInfoDto("戦艦ル級", "戦艦", "", 0, 0, 0))
            .put("512", new ShipInfoDto("空母ヲ級", "正規空母", "", 0, 0, 0))
            .put("513", new ShipInfoDto("輸送ワ級", "補給艦", "", 0, 0, 0))
            .put("514", new ShipInfoDto("駆逐イ級", "駆逐艦", "elite", 0, 0, 0))
            .put("515", new ShipInfoDto("駆逐ロ級", "駆逐艦", "elite", 0, 0, 0))
            .put("516", new ShipInfoDto("駆逐ハ級", "駆逐艦", "elite", 0, 0, 0))
            .put("517", new ShipInfoDto("駆逐ニ級", "駆逐艦", "elite", 0, 0, 0))
            .put("518", new ShipInfoDto("軽巡ホ級", "軽巡洋艦", "elite", 0, 0, 0))
            .put("519", new ShipInfoDto("軽巡ヘ級", "軽巡洋艦", "elite", 0, 0, 0))
            .put("520", new ShipInfoDto("軽巡ト級", "軽巡洋艦", "elite", 0, 0, 0))
            .put("521", new ShipInfoDto("雷巡チ級", "重雷装巡洋艦", "elite", 0, 0, 0))
            .put("522", new ShipInfoDto("重巡リ級", "重巡洋艦", "elite", 0, 0, 0))
            .put("523", new ShipInfoDto("軽母ヌ級", "軽空母", "elite", 0, 0, 0))
            .put("524", new ShipInfoDto("戦艦ル級", "戦艦", "elite", 0, 0, 0))
            .put("525", new ShipInfoDto("空母ヲ級", "正規空母", "elite", 0, 0, 0))
            .put("526", new ShipInfoDto("輸送ワ級", "補給艦", "elite", 0, 0, 0))
            .put("527", new ShipInfoDto("重巡リ級", "重巡洋艦", "flagship", 0, 0, 0))
            .put("528", new ShipInfoDto("空母ヲ級", "正規空母", "flagship", 0, 0, 0))
            .put("529", new ShipInfoDto("戦艦ル級", "戦艦", "flagship", 0, 0, 0))
            .put("530", new ShipInfoDto("潜水カ級", "潜水艦", "", 0, 0, 0))
            .put("531", new ShipInfoDto("潜水ヨ級", "潜水艦", "", 0, 0, 0))
            .put("532", new ShipInfoDto("潜水カ級", "潜水艦", "elite", 0, 0, 0))
            .put("533", new ShipInfoDto("潜水ヨ級", "潜水艦", "elite", 0, 0, 0))
            .put("534", new ShipInfoDto("潜水カ級", "潜水艦", "flagship", 0, 0, 0))
            .put("535", new ShipInfoDto("潜水ヨ級", "潜水艦", "flagship", 0, 0, 0))
            .put("536", new ShipInfoDto("浮遊要塞", "航空戦艦", "", 0, 0, 0))
            .put("537", new ShipInfoDto("浮遊要塞", "航空戦艦", "", 0, 0, 0))
            .put("538", new ShipInfoDto("浮遊要塞", "航空戦艦", "", 0, 0, 0))
            .put("539", new ShipInfoDto("泊地棲鬼", "航空戦艦", "", 0, 0, 0))
            .put("540", new ShipInfoDto("泊地棲姫", "航空戦艦", "", 0, 0, 0))
            .put("541", new ShipInfoDto("戦艦タ級", "戦艦", "", 0, 0, 0))
            .put("542", new ShipInfoDto("戦艦タ級", "戦艦", "elite", 0, 0, 0))
            .put("543", new ShipInfoDto("戦艦タ級", "戦艦", "flagship", 0, 0, 0))
            .put("544", new ShipInfoDto("装甲空母鬼", "航空戦艦", "", 0, 0, 0))
            .put("545", new ShipInfoDto("装甲空母姫", "航空戦艦", "", 0, 0, 0))
            .put("546", new ShipInfoDto("南方棲鬼", "航空戦艦", "", 0, 0, 0))
            .put("547", new ShipInfoDto("南方棲戦鬼", "航空戦艦", "", 0, 0, 0))
            .put("548", new ShipInfoDto("南方棲戦姫", "航空戦艦", "", 0, 0, 0))
            .put("549", new ShipInfoDto("護衛要塞", "航空戦艦", "", 0, 0, 0))
            .put("550", new ShipInfoDto("護衛要塞", "航空戦艦", "", 0, 0, 0))
            .put("551", new ShipInfoDto("護衛要塞", "航空戦艦", "", 0, 0, 0))
            .put("552", new ShipInfoDto("駆逐ロ級", "駆逐艦", "flagship", 0, 0, 0))
            .put("553", new ShipInfoDto("駆逐ハ級", "駆逐艦", "flagship", 0, 0, 0))
            .put("554", new ShipInfoDto("軽巡ホ級", "軽巡洋艦", "flagship", 0, 0, 0))
            .put("555", new ShipInfoDto("軽巡ヘ級", "軽巡洋艦", "flagship", 0, 0, 0))
            .put("556", new ShipInfoDto("飛行場姫", "航空戦艦", "", 0, 0, 0))
            .put("557", new ShipInfoDto("戦艦棲姫", "戦艦", "", 0, 0, 0))
            .put("558", new ShipInfoDto("輸送ワ級", "補給艦", "flagship", 0, 0, 0))
            .put("559", new ShipInfoDto("雷巡チ級", "重雷装巡洋艦", "flagship", 0, 0, 0))
            .put("560", new ShipInfoDto("軽母ヌ級", "軽空母", "flagship", 0, 0, 0))
            .put("561", new ShipInfoDto("戦艦レ級", "航空戦艦", "", 0, 0, 0))
            .put("562", new ShipInfoDto("戦艦レ級", "航空戦艦", "elite", 0, 0, 0))
            .put("563", ShipInfoDto.EMPTY)
            .put("564", new ShipInfoDto("駆逐イ級", "駆逐艦", "flagship", 0, 0, 0))
            .put("565", new ShipInfoDto("空母ヲ級改", "正規空母", "flagship", 0, 0, 0))
            .put("566", new ShipInfoDto("重巡リ級改", "重巡洋艦", "flagship", 0, 0, 0))
            .put("567", new ShipInfoDto("戦艦ル級改", "戦艦", "flagship", 0, 0, 0))
            .put("568", ShipInfoDto.EMPTY)
            .put("569", ShipInfoDto.EMPTY)
            .put("570", new ShipInfoDto("潜水ソ級", "潜水艦", "", 0, 0, 0))
            .put("571", new ShipInfoDto("潜水ソ級", "潜水艦", "elite", 0, 0, 0))
            .put("572", new ShipInfoDto("潜水ソ級", "潜水艦", "flagship", 0, 0, 0))
            .put("573", new ShipInfoDto("港湾棲姫", "航空戦艦", "", 0, 0, 0))
            .put("574", new ShipInfoDto("離島棲鬼", "航空戦艦", "", 0, 0, 0))
            .put("575", new ShipInfoDto("駆逐イ級後期型", "駆逐艦", "", 0, 0, 0))
            .put("576", new ShipInfoDto("駆逐ロ級後期型", "駆逐艦", "", 0, 0, 0))
            .put("577", new ShipInfoDto("駆逐ハ級後期型", "駆逐艦", "", 0, 0, 0))
            .put("578", new ShipInfoDto("駆逐ニ級後期型", "駆逐艦", "", 0, 0, 0))
            .put("579", new ShipInfoDto("空母ヲ級", "正規空母", "flagship", 0, 0, 0))
            .put("580", ShipInfoDto.EMPTY)
            .put("581", new ShipInfoDto("北方棲姫", "航空戦艦", "", 0, 0, 0))
            .put("582", new ShipInfoDto("北方棲姫", "航空戦艦", "", 0, 0, 0))
            .put("583", new ShipInfoDto("中間棲姫", "航空戦艦", "", 0, 0, 0))
            .put("584", new ShipInfoDto("中間棲姫", "航空戦艦", "", 0, 0, 0))
            .put("585", new ShipInfoDto("空母棲鬼", "正規空母", "", 0, 0, 0))
            .put("586", new ShipInfoDto("空母棲姫", "正規空母", "", 0, 0, 0))
            .put("587", new ShipInfoDto("北方棲姫", "航空戦艦", "", 0, 0, 0))
            .put("588", new ShipInfoDto("北方棲姫", "航空戦艦", "", 0, 0, 0))
            .put("589", new ShipInfoDto("北方棲姫", "航空戦艦", "", 0, 0, 0))
            .put("590", new ShipInfoDto("北方棲姫", "航空戦艦", "", 0, 0, 0))
            .put("591", new ShipInfoDto("軽巡ツ級", "軽巡洋艦", "", 0, 0, 0))
            .put("592", new ShipInfoDto("軽巡ツ級", "軽巡洋艦", "elite", 0, 0, 0))
            .put("593", ShipInfoDto.EMPTY)
            .put("594", new ShipInfoDto("重巡ネ級", "重巡洋艦", "", 0, 0, 0))
            .put("595", new ShipInfoDto("重巡ネ級", "重巡洋艦", "elite", 0, 0, 0))
            .put("596", ShipInfoDto.EMPTY)
            .put("597", new ShipInfoDto("駆逐棲姫", "駆逐艦", "", 0, 0, 0))
            .put("598", new ShipInfoDto("駆逐棲姫", "駆逐艦", "", 0, 0, 0))
            .put("599", new ShipInfoDto("空母水鬼", "正規空母", "", 0, 0, 0))
            .put("600", new ShipInfoDto("空母水鬼", "正規空母", "", 0, 0, 0))
            .put("601", new ShipInfoDto("軽巡棲鬼", "軽巡洋艦", "", 0, 0, 0))
            .put("602", new ShipInfoDto("軽巡棲鬼", "軽巡洋艦", "", 0, 0, 0))
            .put("603", new ShipInfoDto("戦艦水鬼", "戦艦", "", 0, 0, 0))
            .put("604", new ShipInfoDto("戦艦水鬼", "戦艦", "", 0, 0, 0))
            .put("605", new ShipInfoDto("港湾水鬼", "航空戦艦", "", 0, 0, 0))
            .put("606", new ShipInfoDto("港湾水鬼", "航空戦艦", "", 0, 0, 0))
            .put("607", new ShipInfoDto("港湾水鬼", "航空戦艦", "", 0, 0, 0))
            .put("608", new ShipInfoDto("港湾水鬼", "航空戦艦", "", 0, 0, 0))
            .put("609", new ShipInfoDto("泊地水鬼", "航空戦艦", "", 0, 0, 0))
            .put("610", new ShipInfoDto("泊地水鬼", "航空戦艦", "", 0, 0, 0))
            .put("611", new ShipInfoDto("泊地水鬼", "航空戦艦", "", 0, 0, 0))
            .put("612", new ShipInfoDto("泊地水鬼", "航空戦艦", "", 0, 0, 0))
            .put("613", new ShipInfoDto("港湾棲姫", "航空戦艦", "", 0, 0, 0))
            .put("614", new ShipInfoDto("空母ヲ級", "正規空母", "flagship", 0, 0, 0))
            .put("615", new ShipInfoDto("空母ヲ級", "正規空母", "flagship", 0, 0, 0))
            .put("616", new ShipInfoDto("空母ヲ級改", "正規空母", "flagship", 0, 0, 0))
            .put("617", new ShipInfoDto("空母ヲ級改", "正規空母", "flagship", 0, 0, 0))
            .put("618", new ShipInfoDto("空母ヲ級改", "正規空母", "flagship", 0, 0, 0))
            .put("619", new ShipInfoDto("空母棲鬼", "正規空母", "", 0, 0, 0))
            .put("620", new ShipInfoDto("空母棲姫", "正規空母", "", 0, 0, 0))
            .put("621", new ShipInfoDto("駆逐イ級後期型", "駆逐艦", "elite", 0, 0, 0))
            .put("622", new ShipInfoDto("駆逐ロ級後期型", "駆逐艦", "elite", 0, 0, 0))
            .put("623", new ShipInfoDto("駆逐ハ級後期型", "駆逐艦", "elite", 0, 0, 0))
            .put("624", new ShipInfoDto("駆逐ニ級後期型", "駆逐艦", "elite", 0, 0, 0))
            .put("625", new ShipInfoDto("水母棲姫", "水上機母艦", "", 0, 0, 0))
            .put("626", new ShipInfoDto("水母棲姫", "水上機母艦", "", 0, 0, 0))
            .put("627", new ShipInfoDto("水母棲姫", "水上機母艦", "", 0, 0, 0))
            .put("628", new ShipInfoDto("防空棲姫", "駆逐艦", "", 0, 0, 0))
            .put("629", new ShipInfoDto("防空棲姫", "駆逐艦", "", 0, 0, 0))
            .put("630", new ShipInfoDto("防空棲姫", "駆逐艦", "", 0, 0, 0))
            .put("631", new ShipInfoDto("飛行場姫", "航空戦艦", "", 0, 0, 0))
            .put("632", new ShipInfoDto("飛行場姫", "航空戦艦", "", 0, 0, 0))
            .put("633", new ShipInfoDto("飛行場姫", "航空戦艦", "", 0, 0, 0))
            .put("634", new ShipInfoDto("離島棲鬼", "航空戦艦", "", 0, 0, 0))
            .put("635", new ShipInfoDto("離島棲鬼", "航空戦艦", "", 0, 0, 0))
            .put("636", new ShipInfoDto("離島棲鬼", "航空戦艦", "", 0, 0, 0))
            .put("637", new ShipInfoDto("PT小鬼群", "駆逐艦", "", 0, 0, 0))
            .put("638", new ShipInfoDto("PT小鬼群", "駆逐艦", "", 0, 0, 0))
            .put("639", new ShipInfoDto("PT小鬼群", "駆逐艦", "", 0, 0, 0))
            .put("640", new ShipInfoDto("PT小鬼群", "駆逐艦", "", 0, 0, 0))
            .put("641", new ShipInfoDto("軽巡棲姫", "軽巡洋艦", "", 0, 0, 0))
            .put("642", new ShipInfoDto("軽巡棲姫", "軽巡洋艦", "", 0, 0, 0))
            .put("643", new ShipInfoDto("軽巡棲姫", "軽巡洋艦", "", 0, 0, 0))
            .put("644", new ShipInfoDto("潜水棲姫", "潜水艦", "", 0, 0, 0))
            .put("645", new ShipInfoDto("潜水棲姫", "潜水艦", "", 0, 0, 0))
            .put("646", new ShipInfoDto("潜水棲姫", "潜水艦", "", 0, 0, 0))
            .put("647", new ShipInfoDto("駆逐水鬼", "駆逐艦", "", 0, 0, 0))
            .put("648", new ShipInfoDto("駆逐水鬼", "駆逐艦", "", 0, 0, 0))
            .put("649", new ShipInfoDto("駆逐水鬼", "駆逐艦", "", 0, 0, 0))
            .build();

    /**
     * 艦娘を取得します
     *
     * @param id ID
     * @return 艦娘
     */
    public static ShipInfoDto get(String id) {
        return SHIP.get(id);
    }

    /**
     * 艦娘を設定します
     */
    public static void set(String id, ShipInfoDto ship) {
        SHIP.put(id, ship);
    }

    /**
     * IDの一覧を取得します
     *
     * @return IDの一覧
     */
    public static Set<String> keySet() {
        return SHIP.keySet();
    }
}
