package jp.mirageworld.apps.base2.service;

import static org.junit.Assert.*;

import java.math.BigDecimal;
import java.util.List;

import javax.annotation.Resource;

import jp.mirageworld.apps.base2.entity.TbUser;

import org.junit.runner.RunWith;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.framework.unit.PreparationType;
import org.seasar.framework.unit.Seasar2;
import org.seasar.framework.unit.TestContext;

import com.opensymphony.xwork2.interceptor.annotations.Before;

@RunWith(Seasar2.class)
public class TbUserServiceTest {

	private static Integer toInteger(Object v) {
		return toInteger(BigDecimal.class.cast(v));
	}

	private static Integer toInteger(BigDecimal v) {
		return v.intValue();
	}

	@Resource(name = "ctx")
	private TestContext ctx;

	@Resource(name = "tbUserService")
	private TbUserService service;

	@Before
	public void before() {
		ctx.setPreparationType(PreparationType.ALL_REPLACE);

	}

	public void testFindById() {

		assertNotNull("初期設定が誤っている可能性があります。", service);

		TbUser result = service.findById(1);
		DataSet expected = ctx.getExpected();
		DataTable table = expected.getTable(0);
		DataRow row = table.getRow(0);

		assertEquals("ID              ", row.getValue("ID").getClass(), BigDecimal.class);
		assertEquals("ID              ", result.id, toInteger(row.getValue("ID")));
		assertEquals("ACCOUNT         ", result.account, row.getValue("ACCOUNT"));
		assertEquals("MAILADDRESS     ", result.mailaddress, row.getValue("MAILADDRESS"));
		assertEquals("PASSWORD        ", result.password, row.getValue("PASSWORD"));
		assertEquals("CREATED         ", result.created, row.getValue("CREATED"));
		assertEquals("UPDATED         ", result.updated, row.getValue("UPDATED"));
		assertEquals("DELETED         ", result.deleted, row.getValue("DELETED"));
		assertEquals("FAIL_CNT        ", result.failCnt, toInteger(row.getValue("FAIL_CNT")));
		assertEquals("LOCK_FLG        ", result.lockFlg, row.getValue("LOCK_FLG"));
		assertEquals("TEMPORARY_FLGFlg", result.temporaryFlg, row.getValue("TEMPORARY_FLG"));

	}

	public void testFindAllOrderById() {

		assertNotNull("初期設定が誤っている可能性があります。", service);

		List<TbUser> results = service.findAllOrderById();
		Integer idx = 0;
		for (TbUser result : results) {
			DataSet expected = ctx.getExpected();
			DataTable table = expected.getTable(0);
			DataRow row = table.getRow(idx++);

			assertEquals("ID              ", row.getValue("ID").getClass(), BigDecimal.class);
			assertEquals("ID              ", result.id, toInteger(row.getValue("ID")));
			assertEquals("ACCOUNT         ", result.account, row.getValue("ACCOUNT"));
			assertEquals("MAILADDRESS     ", result.mailaddress, row.getValue("MAILADDRESS"));
			assertEquals("PASSWORD        ", result.password, row.getValue("PASSWORD"));
			assertEquals("CREATED         ", result.created, row.getValue("CREATED"));
			assertEquals("UPDATED         ", result.updated, row.getValue("UPDATED"));
			assertEquals("DELETED         ", result.deleted, row.getValue("DELETED"));
			assertEquals("FAIL_CNT        ", result.failCnt, toInteger(row.getValue("FAIL_CNT")));
			assertEquals("LOCK_FLG        ", result.lockFlg, row.getValue("LOCK_FLG"));
			assertEquals("TEMPORARY_FLGFlg", result.temporaryFlg, row.getValue("TEMPORARY_FLG"));
			
		}
	}

}
