package jp.mirageworld.apps.base2.mail;

import java.util.Properties;

import javax.net.ssl.SSLSocketFactory;

import org.seasar.framework.log.Logger;
import org.seasar.mai.mail.impl.SendMailImpl;

public class SSLSendMail extends SendMailImpl {

	protected final Logger logger = Logger.getLogger(this.getClass());

	public SSLSendMail() {
		logger.info(getClass().getSimpleName() + ": <INIT>");
	}

	public SSLSendMail(String host) {
		super(host);
		logger.info(getClass().getSimpleName() + ": <INIT>");
	}

	public SSLSendMail(SendMailImpl sendMail) {
		super(sendMail);
		logger.info(getClass().getSimpleName() + ": <INIT>");
	}

	@Override
	protected Properties initProperties() {
		Properties properties = super.initProperties();

		if (getPort() == 465) {
			properties.setProperty("mail.smtp.starttls.enable", Boolean.TRUE.toString());
			properties.setProperty("mail.smtp.socketFactory.class", SSLSocketFactory.class.getName());
			properties.setProperty("mail.smtp.socketFactory.fallback", Boolean.FALSE.toString());
			properties.setProperty("mail.smtp.socketFactory.port", Integer.toString(getPort()));
		}

		return properties;
	}

}
