package jp.mirageworld.apps.base2.base;

import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.seasar.framework.log.Logger;

import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.ModelDriven;

public abstract class ActionBase<FORM extends Form> extends ActionSupport implements ModelDriven<FORM> {

	protected final Logger logger = Logger.getLogger(getClass());

	@Resource(name = "request")
	protected HttpServletRequest request;

	@Resource(name = "response")
	protected HttpServletResponse response;

	@Resource(name = "session")
	protected HttpSession session;

	@Resource(name = "application")
	protected ServletContext application;

	protected FORM model;

	public void setModel(FORM model) {
		this.model = model;
	}

	@Override
	public FORM getModel() {
		return model;
	}

}
