package jp.mirageworld.apps.base2.service;

import static org.junit.Assert.*;

import java.math.BigDecimal;
import java.util.List;

import javax.annotation.Resource;

import jp.mirageworld.apps.base2.entity.TbLoginHistory;

import org.junit.runner.RunWith;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.framework.unit.PreparationType;
import org.seasar.framework.unit.Seasar2;
import org.seasar.framework.unit.TestContext;

import com.opensymphony.xwork2.interceptor.annotations.Before;

@RunWith(Seasar2.class)
public class TbLoginHistoryServiceTest {

	private static Integer toInteger(Object v) {
		return toInteger(BigDecimal.class.cast(v));
	}

	private static Integer toInteger(BigDecimal v) {
		return v.intValue();
	}

	@Resource(name = "ctx")
	private TestContext ctx;

	@Resource(name = "tbLoginHistoryService")
	private TbLoginHistoryService service;

	@Before
	public void before() {
		ctx.setPreparationType(PreparationType.ALL_REPLACE);

	}

	public void testFindById() {

		assertNotNull("初期設定が誤っている可能性があります。", service);

		TbLoginHistory result = service.findById(1);
		DataSet expected = ctx.getExpected();
		DataTable table = expected.getTable(0);
		DataRow row = table.getRow(0);

		assertEquals("ID        ", row.getValue("ID").getClass(), BigDecimal.class);
		assertEquals("ID        ", result.id, toInteger(row.getValue("ID")));
		assertEquals("TB_USER_ID", row.getValue("TB_USER_ID").getClass(), BigDecimal.class);
		assertEquals("TB_USER_ID", result.tbUserId, toInteger(row.getValue("TB_USER_ID")));
		assertEquals("CREATED   ", result.created, row.getValue("CREATED"));
		assertEquals("UPDATED   ", result.updated, row.getValue("UPDATED"));
		assertEquals("DELETED   ", result.deleted, row.getValue("DELETED"));
		assertEquals("SUCCESSED ", result.successed, row.getValue("SUCCESSED"));

	}

	public void testFindAllOrderById() {

		assertNotNull("初期設定が誤っている可能性があります。", service);

		List<TbLoginHistory> results = service.findAllOrderById();
		Integer idx = 0;
		for (TbLoginHistory result : results) {
			DataSet expected = ctx.getExpected();
			DataTable table = expected.getTable(0);
			DataRow row = table.getRow(idx++);

			assertEquals("ID        ", row.getValue("ID").getClass(), BigDecimal.class);
			assertEquals("ID        ", result.id, toInteger(row.getValue("ID")));
			assertEquals("TB_USER_ID", row.getValue("TB_USER_ID").getClass(), BigDecimal.class);
			assertEquals("TB_USER_ID", result.tbUserId, toInteger(row.getValue("TB_USER_ID")));
			assertEquals("CREATED   ", result.created, row.getValue("CREATED"));
			assertEquals("UPDATED   ", result.updated, row.getValue("UPDATED"));
			assertEquals("DELETED   ", result.deleted, row.getValue("DELETED"));
			assertEquals("SUCCESSED ", result.successed, row.getValue("SUCCESSED"));

		}
	}

}
