package jp.mirageworld.apps.base2.task;

import java.util.List;

import javax.annotation.Resource;

import jp.mirageworld.apps.base2.base.ITask;
import jp.mirageworld.apps.base2.entity.TbUser;
import jp.mirageworld.apps.base2.service.TbUserService;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.seasar.chronos.core.annotation.task.Task;
import org.seasar.chronos.core.annotation.trigger.CronTrigger;
import org.seasar.framework.log.Logger;

@Task
@CronTrigger(expression = "0 */10 * * * ?")
public class DbConnectionCheckTask implements ITask {

	protected final Logger logger = Logger.getLogger(getClass());

	@Resource(name = "tbUserService")
	protected TbUserService userService;

	@Override
	public void start() {
		logger.info("#start");
	}

	@Override
	public void doExecute() {
		logger.info("#doExecute");

		if (logger.isDebugEnabled()) {
			List<TbUser> users = userService.findAllOrderById();

			for (TbUser user : users) {
				logger.debug(ToStringBuilder.reflectionToString(user, ToStringStyle.SIMPLE_STYLE));
			}
		}
	}

	@Override
	public void end() {
		logger.info("#end");
	}

}
